// Copyright (c) Tailscale Inc & AUTHORS
// SPDX-License-Identifier: BSD-3-Clause

// Code generated by tailscale/cmd/viewer; DO NOT EDIT.

package types

import (
	"database/sql"
	"encoding/json"
	"errors"
	"net/netip"
	"time"

	"gorm.io/gorm"
	"tailscale.com/tailcfg"
	"tailscale.com/types/key"
	"tailscale.com/types/views"
)

//go:generate go run tailscale.com/cmd/cloner  -clonefunc=false -type=User,Node,PreAuthKey

// View returns a read-only view of User.
func (p *User) View() UserView {
	return UserView{ж: p}
}

// UserView provides a read-only view over User.
//
// Its methods should only be called if `Valid()` returns true.
type UserView struct {
	// ж is the underlying mutable value, named with a hard-to-type
	// character that looks pointy like a pointer.
	// It is named distinctively to make you think of how dangerous it is to escape
	// to callers. You must not let callers be able to mutate it.
	ж *User
}

// Valid reports whether v's underlying value is non-nil.
func (v UserView) Valid() bool { return v.ж != nil }

// AsStruct returns a clone of the underlying value which aliases no memory with
// the original.
func (v UserView) AsStruct() *User {
	if v.ж == nil {
		return nil
	}
	return v.ж.Clone()
}

func (v UserView) MarshalJSON() ([]byte, error) { return json.Marshal(v.ж) }

func (v *UserView) UnmarshalJSON(b []byte) error {
	if v.ж != nil {
		return errors.New("already initialized")
	}
	if len(b) == 0 {
		return nil
	}
	var x User
	if err := json.Unmarshal(b, &x); err != nil {
		return err
	}
	v.ж = &x
	return nil
}

func (v UserView) Model() gorm.Model                  { return v.ж.Model }
func (v UserView) Name() string                       { return v.ж.Name }
func (v UserView) DisplayName() string                { return v.ж.DisplayName }
func (v UserView) Email() string                      { return v.ж.Email }
func (v UserView) ProviderIdentifier() sql.NullString { return v.ж.ProviderIdentifier }
func (v UserView) Provider() string                   { return v.ж.Provider }
func (v UserView) ProfilePicURL() string              { return v.ж.ProfilePicURL }

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _UserViewNeedsRegeneration = User(struct {
	gorm.Model
	Name               string
	DisplayName        string
	Email              string
	ProviderIdentifier sql.NullString
	Provider           string
	ProfilePicURL      string
}{})

// View returns a read-only view of Node.
func (p *Node) View() NodeView {
	return NodeView{ж: p}
}

// NodeView provides a read-only view over Node.
//
// Its methods should only be called if `Valid()` returns true.
type NodeView struct {
	// ж is the underlying mutable value, named with a hard-to-type
	// character that looks pointy like a pointer.
	// It is named distinctively to make you think of how dangerous it is to escape
	// to callers. You must not let callers be able to mutate it.
	ж *Node
}

// Valid reports whether v's underlying value is non-nil.
func (v NodeView) Valid() bool { return v.ж != nil }

// AsStruct returns a clone of the underlying value which aliases no memory with
// the original.
func (v NodeView) AsStruct() *Node {
	if v.ж == nil {
		return nil
	}
	return v.ж.Clone()
}

func (v NodeView) MarshalJSON() ([]byte, error) { return json.Marshal(v.ж) }

func (v *NodeView) UnmarshalJSON(b []byte) error {
	if v.ж != nil {
		return errors.New("already initialized")
	}
	if len(b) == 0 {
		return nil
	}
	var x Node
	if err := json.Unmarshal(b, &x); err != nil {
		return err
	}
	v.ж = &x
	return nil
}

func (v NodeView) ID() NodeID                             { return v.ж.ID }
func (v NodeView) MachineKey() key.MachinePublic          { return v.ж.MachineKey }
func (v NodeView) NodeKey() key.NodePublic                { return v.ж.NodeKey }
func (v NodeView) DiscoKey() key.DiscoPublic              { return v.ж.DiscoKey }
func (v NodeView) Endpoints() views.Slice[netip.AddrPort] { return views.SliceOf(v.ж.Endpoints) }
func (v NodeView) Hostinfo() tailcfg.HostinfoView         { return v.ж.Hostinfo.View() }
func (v NodeView) IPv4() views.ValuePointer[netip.Addr]   { return views.ValuePointerOf(v.ж.IPv4) }

func (v NodeView) IPv6() views.ValuePointer[netip.Addr] { return views.ValuePointerOf(v.ж.IPv6) }

func (v NodeView) Hostname() string                      { return v.ж.Hostname }
func (v NodeView) GivenName() string                     { return v.ж.GivenName }
func (v NodeView) UserID() uint                          { return v.ж.UserID }
func (v NodeView) User() User                            { return v.ж.User }
func (v NodeView) RegisterMethod() string                { return v.ж.RegisterMethod }
func (v NodeView) ForcedTags() views.Slice[string]       { return views.SliceOf(v.ж.ForcedTags) }
func (v NodeView) AuthKeyID() views.ValuePointer[uint64] { return views.ValuePointerOf(v.ж.AuthKeyID) }

func (v NodeView) AuthKey() PreAuthKeyView               { return v.ж.AuthKey.View() }
func (v NodeView) Expiry() views.ValuePointer[time.Time] { return views.ValuePointerOf(v.ж.Expiry) }

func (v NodeView) LastSeen() views.ValuePointer[time.Time] {
	return views.ValuePointerOf(v.ж.LastSeen)
}

func (v NodeView) ApprovedRoutes() views.Slice[netip.Prefix] {
	return views.SliceOf(v.ж.ApprovedRoutes)
}
func (v NodeView) CreatedAt() time.Time { return v.ж.CreatedAt }
func (v NodeView) UpdatedAt() time.Time { return v.ж.UpdatedAt }
func (v NodeView) DeletedAt() views.ValuePointer[time.Time] {
	return views.ValuePointerOf(v.ж.DeletedAt)
}

func (v NodeView) IsOnline() views.ValuePointer[bool] { return views.ValuePointerOf(v.ж.IsOnline) }

func (v NodeView) String() string { return v.ж.String() }

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _NodeViewNeedsRegeneration = Node(struct {
	ID             NodeID
	MachineKey     key.MachinePublic
	NodeKey        key.NodePublic
	DiscoKey       key.DiscoPublic
	Endpoints      []netip.AddrPort
	Hostinfo       *tailcfg.Hostinfo
	IPv4           *netip.Addr
	IPv6           *netip.Addr
	Hostname       string
	GivenName      string
	UserID         uint
	User           User
	RegisterMethod string
	ForcedTags     []string
	AuthKeyID      *uint64
	AuthKey        *PreAuthKey
	Expiry         *time.Time
	LastSeen       *time.Time
	ApprovedRoutes []netip.Prefix
	CreatedAt      time.Time
	UpdatedAt      time.Time
	DeletedAt      *time.Time
	IsOnline       *bool
}{})

// View returns a read-only view of PreAuthKey.
func (p *PreAuthKey) View() PreAuthKeyView {
	return PreAuthKeyView{ж: p}
}

// PreAuthKeyView provides a read-only view over PreAuthKey.
//
// Its methods should only be called if `Valid()` returns true.
type PreAuthKeyView struct {
	// ж is the underlying mutable value, named with a hard-to-type
	// character that looks pointy like a pointer.
	// It is named distinctively to make you think of how dangerous it is to escape
	// to callers. You must not let callers be able to mutate it.
	ж *PreAuthKey
}

// Valid reports whether v's underlying value is non-nil.
func (v PreAuthKeyView) Valid() bool { return v.ж != nil }

// AsStruct returns a clone of the underlying value which aliases no memory with
// the original.
func (v PreAuthKeyView) AsStruct() *PreAuthKey {
	if v.ж == nil {
		return nil
	}
	return v.ж.Clone()
}

func (v PreAuthKeyView) MarshalJSON() ([]byte, error) { return json.Marshal(v.ж) }

func (v *PreAuthKeyView) UnmarshalJSON(b []byte) error {
	if v.ж != nil {
		return errors.New("already initialized")
	}
	if len(b) == 0 {
		return nil
	}
	var x PreAuthKey
	if err := json.Unmarshal(b, &x); err != nil {
		return err
	}
	v.ж = &x
	return nil
}

func (v PreAuthKeyView) ID() uint64                { return v.ж.ID }
func (v PreAuthKeyView) Key() string               { return v.ж.Key }
func (v PreAuthKeyView) UserID() uint              { return v.ж.UserID }
func (v PreAuthKeyView) User() User                { return v.ж.User }
func (v PreAuthKeyView) Reusable() bool            { return v.ж.Reusable }
func (v PreAuthKeyView) Ephemeral() bool           { return v.ж.Ephemeral }
func (v PreAuthKeyView) Used() bool                { return v.ж.Used }
func (v PreAuthKeyView) Tags() views.Slice[string] { return views.SliceOf(v.ж.Tags) }
func (v PreAuthKeyView) CreatedAt() views.ValuePointer[time.Time] {
	return views.ValuePointerOf(v.ж.CreatedAt)
}

func (v PreAuthKeyView) Expiration() views.ValuePointer[time.Time] {
	return views.ValuePointerOf(v.ж.Expiration)
}

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _PreAuthKeyViewNeedsRegeneration = PreAuthKey(struct {
	ID         uint64
	Key        string
	UserID     uint
	User       User
	Reusable   bool
	Ephemeral  bool
	Used       bool
	Tags       []string
	CreatedAt  *time.Time
	Expiration *time.Time
}{})
