/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.internal.ui.authenticator;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jsch.internal.ui.JSchUIPlugin;
import org.eclipse.jsch.internal.ui.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class UserValidationDialog
extends TrayDialog {
    protected Text usernameField;
    protected Text passwordField;
    protected Button allowCachingButton;
    protected String comment;
    protected String defaultUsername;
    protected String password = null;
    protected boolean allowCaching = false;
    protected boolean isAllowCaching = false;
    protected Image keyLockImage;
    protected boolean isUsernameMutable = true;
    protected String username = null;
    protected String message = null;

    public UserValidationDialog(Shell parentShell, String comment, String defaultName, String message, boolean isAllowCaching) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.defaultUsername = defaultName;
        this.comment = comment;
        this.message = message;
        this.isAllowCaching = isAllowCaching;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.UserValidationDialog_required);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jsch.ui.user_validation_dialog_context");
    }

    public void create() {
        super.create();
        this.usernameField.setText(this.defaultUsername);
        if (this.isUsernameMutable) {
            this.usernameField.selectAll();
            this.usernameField.setFocus();
        } else {
            this.usernameField.setEditable(false);
            this.passwordField.setFocus();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(768));
        Composite imageComposite = new Composite(top, 0);
        layout = new GridLayout();
        imageComposite.setLayout((Layout)layout);
        imageComposite.setLayoutData((Object)new GridData(1040));
        Composite main = new Composite(top, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(768));
        Label imageLabel = new Label(imageComposite, 0);
        this.keyLockImage = JSchUIPlugin.getImageDescriptor("wizban/keylock.gif").createImage();
        imageLabel.setImage(this.keyLockImage);
        GridData data = new GridData(768);
        imageLabel.setLayoutData((Object)data);
        if (this.message != null) {
            Label messageLabel = new Label(main, 64);
            messageLabel.setText(this.message);
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.widthHint = 400;
            messageLabel.setLayoutData((Object)data);
        }
        if (this.comment != null) {
            Label label = new Label(main, 64);
            if (this.isUsernameMutable) {
                label.setText(NLS.bind((String)Messages.UserValidationDialog_labelUser, (Object)this.comment));
            } else {
                label.setText(NLS.bind((String)Messages.UserValidationDialog_labelPassword, (Object[])new Object[]{this.defaultUsername, this.comment}));
            }
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.widthHint = 400;
            label.setLayoutData((Object)data);
        }
        this.createUsernameFields(main);
        this.createPasswordFields(main);
        if (this.isAllowCaching) {
            this.allowCachingButton = new Button(main, 32);
            this.allowCachingButton.setText(Messages.UserValidationDialog_6);
            data = new GridData(768);
            data.horizontalSpan = 3;
            this.allowCachingButton.setLayoutData((Object)data);
            this.allowCachingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UserValidationDialog.this.allowCaching = UserValidationDialog.this.allowCachingButton.getSelection();
                }
            });
        }
        Dialog.applyDialogFont((Control)parent);
        return main;
    }

    protected void createPasswordFields(Composite parent) {
        new Label(parent, 0).setText(Messages.UserValidationDialog_password);
        this.passwordField = new Text(parent, 0x400800);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.passwordField.setLayoutData((Object)data);
    }

    protected void createUsernameFields(Composite parent) {
        new Label(parent, 0).setText(Messages.UserValidationDialog_user);
        this.usernameField = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.usernameField.setLayoutData((Object)data);
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean getAllowCaching() {
        return this.allowCaching;
    }

    protected void okPressed() {
        this.password = this.passwordField.getText();
        this.username = this.usernameField.getText();
        super.okPressed();
    }

    public void setUsernameMutable(boolean value) {
        this.isUsernameMutable = value;
    }

    public boolean close() {
        if (this.keyLockImage != null) {
            this.keyLockImage.dispose();
        }
        return super.close();
    }
}

