%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0": ["0x3F80000040000000", "0x4080000041000000", "0x3F80000040000000", "0x4080000041000000"],
    "XMM1": ["0x4180000042000000", "0x4280000043000000", "0x4180000042000000", "0x4280000043000000"],
    "XMM2": ["0x4140000040400000", "0x4340000042400000", "0x0000000000000000", "0x0000000000000000"],
    "XMM3": ["0x4140000040400000", "0x4340000042400000", "0x4140000040400000", "0x4340000042400000"],
    "XMM4": ["0x4140000040400000", "0x4340000042400000", "0x0000000000000000", "0x0000000000000000"],
    "XMM5": ["0x4140000040400000", "0x4340000042400000", "0x4140000040400000", "0x4340000042400000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx]
vmovapd ymm1, [rdx + 32]

vhaddps xmm2, xmm0, xmm1
vhaddps ymm3, ymm0, ymm1

vhaddps xmm4, xmm0, [rdx + 32]
vhaddps ymm5, ymm0, [rdx + 32]

hlt

align 32
.data:
dq 0x3F80000040000000 ; 1.0, 2.0
dq 0x4080000041000000 ; 4.0, 8.0
dq 0x3F80000040000000 ; 1.0, 2.0
dq 0x4080000041000000 ; 4.0, 8.0

dq 0x4180000042000000 ; 16.0, 32.0
dq 0x4280000043000000 ; 64.0, 128.0
dq 0x4180000042000000 ; 16.0, 32.0
dq 0x4280000043000000 ; 64.0, 128.0
