
#include "bdl.h"

static BDL_Record moonrecords[] = {

     {
          2458849.5,
          {-5.726190255,0.04037970488,184.4402936,0.4345540486,-0.001166830832,1.727166103}, /*cmx*/
          {10.02895042,-4.144986703,8.723187039,5.307902718}, /*cfx*/
          {0.8249149715,0.02521532058,-81.2663651,-0.08976052916,0.0009028713351,0.7444145829}, /*cmy*/
          {2.397281202,6.228215741,177.7652869,7.150001292}, /*cfy*/
          {0.1694147379,0.0682958491,167.9452464,-0.438592146,0.001309621661,-1.592316337}, /*cmz*/
          {-26.149722,6.935135796,0.5709098098,-367.0294801} /*cfz*/
     },
     {
          2458904.5,
          {-3.397144859,0.08393984527,183.8633977,0.3045608913,-0.002513165001,1.720261196}, /*cmx*/
          {5.895133367,4.27665222,4.258109713,2.506662098}, /*cfx*/
          {2.23167965,-0.008574282262,-75.26882151,-0.1598451051,-0.000324049506,0.6691785732}, /*cmy*/
          {4.634749846,1.538105047,4.827054458,4.424585223}, /*cfy*/
          {4.133926179,0.02190162286,171.4096112,-0.2880778739,0.002623985666,-1.623950273}, /*cmz*/
          {1.126892423,2.947597257,2.806364254,0.8790209689} /*cfz*/
     },
     {
          2458959.5,
          {1.549254393,0.07093659391,183.7877327,0.01080801135,-0.002504006978,1.75567273}, /*cmx*/
          {1.822536752,1.196292078,0.2618197292,-0.2012072219}, /*cfx*/
          {1.684636092,-0.02848669322,-67.52883919,-0.1182417057,-0.00125303207,0.622006938}, /*cmy*/
          {0.6088457442,3.807729074,0.6083729204,1.712717744}, /*cfy*/
          {5.399316738,-0.05610093435,174.5944265,0.0471517445,0.002405025018,-1.6706383}, /*cmz*/
          {3.34432241,-2.362622375,5.179319208,4.465121617} /*cfz*/
     },
     {
          2459014.5,
          {5.585343897,-0.01510932031,184.2997081,-0.2906953534,0.0004349019249,1.78038704}, /*cmx*/
          {4.12051304,27.64824744,1.962673615,3.456149712}, /*cfx*/
          {0.06173536817,-0.03067877944,-64.76999766,0.03384535783,-0.0007510673666,0.6358150959}, /*cmy*/
          {2.863102293,5.899416256,2.845085521,5.290893065}, /*cfy*/
          {1.987895322,-0.09224778962,175.0665986,-0.2992933634,-0.0007320606901,-1.67891245}, /*cmz*/
          {5.651141423,16.71737374,0.1757891814,1.848437092} /*cfz*/
     },
     {
          2459069.5,
          {4.570416297,-0.08973471916,184.7169585,-0.2293920914,0.003236448097,1.752157034}, /*cmx*/
          {0.1766667218,4.8671507,4.870855889,0.7880288622}, /*cfx*/
          {-1.737600435,-0.009304914733,-68.79614186,0.117476423,-0.0005715353423,0.6771730794}, /*cmy*/
          {5.119112259,1.926207511,9.325447463,2.556052131}, /*cfy*/
          {-3.385121781,-0.03603208708,173.0634999,-0.2312827964,-0.003245360534,-1.627059639}, /*cmz*/
          {1.712316369,0.3694107773,9.603975749,-0.8156243934} /*cfz*/
     },
     {
          2459124.5,
          {-0.6964919656,-0.07519037758,184.8373217,0.1500623021,0.002485529634,1.713065118}, /*cmx*/
          {2.452399805,0.9118660695,0.7308798934,4.268423619}, /*cfx*/
          {-2.24344677,0.02551448659,-74.35631214,0.1086168802,-0.0009699183104,0.7054962782}, /*cmy*/
          {1.071926895,3.562869885,4.314283915,-0.2450057915}, /*cfy*/
          {-5.281005008,0.04056916306,170.6133696,0.1573241106,-0.002457475637,-1.576370189}, /*cmz*/
          {3.987984883,2.222338629,5.62005707,2.659680809} /*cfz*/
     },
     {
          2459179.5,
          {-4.919781825,-0.01053084037,184.6327138,0.4187838507,-0.000427713358,1.721487954}, /*cmx*/
          {4.628965946,3.023363038,-14.12470988,1.393589738}, /*cfx*/
          {-0.6848562019,0.03605470771,-76.28423819,0.07457243078,-0.001221482959,0.7024411248}, /*cmy*/
          {3.281777362,-1.764962758,-0.2731003981,3.237099273}, /*cfy*/
          {-2.849455078,0.07513961133,170.126947,0.4220725094,8.874302105e-05,-1.599948347}, /*cmz*/
          {6.156112468,4.630478862,0.983927822,-0.2265097439} /*cfz*/
     },
     {
          2459234.5,
          {-5.451374444,0.05301181405,184.0324119,0.4217572094,-0.00168982508,1.744692877}, /*cmx*/
          {0.4810843608,5.143337181,-7.357868093,4.846130126}, /*cfx*/
          {1.373673191,0.0110593546,-71.66366197,0.1575067212,-0.0004157763778,0.6410370017}, /*cmy*/
          {5.50849265,-0.6833857776,1.936384561,0.5114355246}, /*cfy*/
          {1.392013845,0.06243335501,172.7877879,0.4029724037,-0.001827887676,-1.663714022}, /*cmz*/
          {2.001090805,0.6061217466,13.11369721,3.224233467} /*cfz*/
     },
     {
          2459289.5,
          {-2.372458454,0.0866514949,183.6753501,0.2349098367,-0.002476582681,1.732934175}, /*cmx*/
          {2.643280764,1.078865475,1.039317298,2.096748953}, /*cfx*/
          {1.940370828,-0.01555677522,-62.01018415,0.1997870458,0.00100732919,0.5389721697}, /*cmy*/
          {1.480575584,1.485895782,4.284397788,4.105214004}, /*cfy*/
          {5.064919719,0.001714935532,176.752535,0.1955025539,-0.002320254113,-1.686432961}, /*cmz*/
          {4.169027343,2.928940433,2.792841032,0.4844928968} /*cfz*/
     },
     {
          2459344.5,
          {2.700643918,0.05518387884,184.0574052,-0.05226002159,-0.001961834393,1.74089215}, /*cmx*/
          {4.873467093,2.980877563,3.397307758,-0.5936149059}, /*cfx*/
          {1.034104983,-0.02452691656,-53.95950454,0.0931566126,0.001594017129,0.4991714638}, /*cmy*/
          {3.721310339,4.241466277,0.5914145863,1.351681738}, /*cfy*/
          {5.084887382,-0.07439095031,178.9161018,-0.08144067476,-0.001717520582,-1.689973881}, /*cmz*/
          {0.1271264484,4.650061095,5.175677437,4.086570624} /*cfz*/
     },
     {
          2459399.5,
          {5.810722876,-0.03839387029,184.6146717,-0.2828752576,0.0007522121658,1.757419193}, /*cmx*/
          {0.8958330281,-0.6945581806,5.346389481,3.032051561}, /*cfx*/
          {-0.3536513734,-0.02481730197,-54.30087611,0.111938247,0.0005957480101,0.5452087844}, /*cmy*/
          {5.936058668,2.524157378,3.414875557,4.87182284}, /*cfy*/
          {0.6331781801,-0.0881481299,178.3393837,-0.2832477814,0.0009421899824,-1.683121517}, /*cmz*/
          {2.438246459,1.026877281,0.6406075516,1.432093006} /*cfz*/
     },
     {
          2459454.5,
          {3.452309768,-0.09399599444,184.840729,-0.1829582619,0.003044486748,1.766088113}, /*cmx*/
          {3.227472031,1.670480455,1.655571758,0.3462108734}, /*cfx*/
          {-1.840966323,-0.0004032298128,-61.61323074,0.1542140889,-0.0008564360947,0.6205913234}, /*cmy*/
          {1.902930755,5.106823862,5.214130074,2.146539915}, /*cfy*/
          {-4.430662841,-0.01677313104,175.7329072,-0.1699145889,0.003029900784,-1.664475005}, /*cmz*/
          {4.769472561,3.561608753,3.337659764,5.026925347} /*cfz*/
     },
     {
          2459509.5,
          {-2.04383904,-0.06046371999,184.6537315,0.1775581859,0.002234601918,1.738068015}, /*cmx*/
          {5.49289281,3.919668004,3.750431644,3.844999324}, /*cfx*/
          {-1.789332094,0.03043590704,-67.46981999,0.05535243615,-0.001368013754,0.6404757762}, /*cmy*/
          {4.164836149,0.7684936168,1.038085035,-0.5899001358}, /*cfy*/
          {-5.195581885,0.05539158992,173.6469582,0.1989210576,0.00198892883,-1.63427767}, /*cmz*/
          {0.7452935105,5.415036384,5.571564682,2.233998421} /*cfz*/
     },
     {
          2459564.5,
          {-5.37628641,0.007553101053,184.1677952,0.4300742858,0.0004696645427,1.70372865}, /*cmx*/
          {1.381803598,6.070388267,10.6425537,0.9786851478}, /*cfx*/
          {0.0345707983,0.02635665892,-66.30905009,-0.1054450753,-0.00106130261,0.5844211299}, /*cmy*/
          {0.1295480805,3.421244067,3.084495518,2.942086129}, /*cfy*/
          {-1.990442265,0.08012603693,174.5916941,0.4256440773,-0.0004453506378,-1.632840015}, /*cmz*/
          {2.909657759,1.472835858,2.08435499,-0.6369045623} /*cfz*/
     },
     {
          2459619.5,
          {-4.90020111,0.06585869783,183.7287883,0.4168156454,-0.00197295364,1.721339762}, /*cmx*/
          {3.514970073,1.930115136,1.988512075,4.410229956}, /*cfx*/
          {1.49296524,-0.001976971317,-57.53965326,-0.2231058355,0.0002443899924,0.4871259883}, /*cmy*/
          {2.384218345,5.484563598,4.657428385,0.211275589}, /*cfy*/
          {2.585098332,0.05218295496,178.1959504,0.376417058,0.001995414758,-1.688329017}, /*cmz*/
          {5.045568431,3.662073379,0.557795295,2.804220009} /*cfz*/
     },
     {
          2459674.5,
          {-1.067793862,0.08570454378,183.9811035,0.1815285704,-0.002582497447,1.764052684}, /*cmx*/
          {5.683134551,4.158364572,4.098130941,1.667058395}, /*cfx*/
          {1.311911874,-0.0155013072,-45.88692848,-0.2029404114,-0.001563434932,0.3992923836}, /*cmy*/
          {4.642732331,1.585156054,4.360485259,3.771380983}, /*cfy*/
          {5.650481533,-0.01883578219,181.3233959,0.1443401163,0.002364580733,-1.745248202}, /*cmz*/
          {0.9430332657,5.907168343,2.662369708,0.07309767466} /*cfz*/
     },
     {
          2459729.5,
          {3.920142194,0.03423217877,184.5670386,-0.125634665,-0.001471305796,1.771926645}, /*cmx*/
          {1.648003944,0.00331384343,0.1930321475,5.30471028}, /*cfx*/
          {0.4590088075,-0.01848609381,-39.37750474,-0.07031871804,-0.001668267552,0.3851684742}, /*cmy*/
          {0.5640483915,5.022479489,0.725006629,1.00025753}, /*cfy*/
          {4.417728535,-0.08683391425,182.2471878,-0.1368014685,0.001299607327,-1.744383681}, /*cmz*/
          {3.199456273,1.661619759,5.11428481,3.714663156} /*cfz*/
     },
     {
          2459784.5,
          {5.825139802,-0.06040027062,184.9139425,-0.2954827851,0.001443508516,1.746748413}, /*cmx*/
          {3.968186726,2.411246229,2.337212367,2.661291578}, /*cfx*/
          {-0.6102529343,-0.01775971041,-43.30600574,-0.1698031028,0.0002446709549,0.452064698}, /*cmy*/
          {2.752790707,15.18771732,11.12450557,4.529340222}, /*cfy*/
          {-0.7013893161,-0.07789065351,181.0332526,-0.2814610002,-0.001592192884,-1.697060203}, /*cmz*/
          {5.520428485,4.114556286,0.7577062469,1.06816943} /*cfz*/
     },
     {
          2459839.5,
          {2.172111315,-0.0939593874,184.7949675,-0.108133556,0.00292543215,1.734984844}, /*cmx*/
          {6.29205353,4.750361439,4.696674872,-0.07032275393}, /*cfx*/
          {-1.689243271,0.009138945921,-52.57336268,-0.1613334055,-0.001435606898,0.5231416814}, /*cmy*/
          {5.018159845,5.20289263,-4.401151597,1.803131254}, /*cfy*/
          {-5.119958836,0.003951545751,178.587042,-0.08720415117,-0.002847811398,-1.667866832}, /*cmz*/
          {1.555312098,0.4562016714,3.262114578,4.612122918} /*cfz*/
     },
     {
          2459894.5,
          {-3.260651642,-0.04542174364,184.406269,0.2294789324,0.001662816064,1.742500794}, /*cmx*/
          {2.253843649,0.6591991169,0.4827223386,3.402254711}, /*cfx*/
          {-1.051364684,0.02905428382,-56.97030025,-0.02279921876,-0.001534070307,0.5280263482}, /*cmy*/
          {1.023102079,-16.01316291,4.138381389,-0.9043714114}, /*cfy*/
          {-4.707571866,0.0685206427,177.6115829,-0.2427230871,-0.001353025219,-1.684955016}, /*cmz*/
          {3.792087193,-13.4083436,5.413760381,1.795270626} /*cfz*/
     },
     {
          2459949.5,
          {-5.708227507,0.02456735757,183.9523728,0.4098213786,-0.0004041154801,1.737176448}, /*cmx*/
          {4.419575672,2.823906814,3.47488857,0.5651094738}, /*cfx*/
          {0.6487395032,0.01150282571,-52.11110553,-0.1860533719,-0.0006477013828,0.4448147676}, /*cmy*/
          {3.31384312,12.50672967,0.3616503459,2.705425795}, /*cfy*/
          {-0.7846674256,0.07856073445,179.6933883,-0.3811169143,0.0005621854907,-1.710828385}, /*cmz*/
          {5.95638285,1.390071789,1.915255451,-1.036301077} /*cfz*/
     },
     {
          2460004.5,
          {-4.290759602,0.0773374977,183.9668869,0.3720526925,-0.001877611754,1.723563561}, /*cmx*/
          {0.2802772968,4.994504805,-1.272542725,4.029236191}, /*cfx*/
          {1.222819648,-0.01032146304,-40.40708281,-0.2557937905,-0.0009263192017,0.3216519007}, /*cmy*/
          {5.622583014,2.320736405,4.956127805,0.03812394836}, /*cfy*/
          {3.751859057,0.03506736923,182.723343,-0.3259666478,0.001701720234,-1.718334721}, /*cmz*/
          {1.827979611,3.515087464,3.585028615,2.441431601} /*cfz*/
     },
     {
          2460059.5,
          {0.2199491394,0.08041544201,184.4823924,0.1610942382,-0.002654655954,1.729817132}, /*cmx*/
          {2.460772223,0.9612736863,0.9126803509,1.275786777}, /*cfx*/
          {0.6002764089,-0.01099294855,-28.81119565,-0.1695681497,-0.001801488607,0.2296935365}, /*cmy*/
          {1.617998987,4.920021319,1.318323801,3.563770047}, /*cfy*/
          {5.765535581,-0.03997652421,184.2798738,-0.1373244393,0.002439567063,-1.728749018}, /*cmz*/
          {4.019422452,5.682167604,5.674687263,-0.3040653062} /*cfz*/
     },
     {
          2460114.5,
          {4.878965341,0.01191853456,184.8955968,-0.1516350072,-0.00145593913,1.778220327}, /*cmx*/
          {4.715762123,3.075221567,3.359006527,4.903552332}, /*cfx*/
          {0.03619485719,-0.01273935376,-24.95145334,0.09857641142,-0.001445792153,0.263127678}, /*cmy*/
          {3.756318168,49.8264585,4.078817671,0.6796097809}, /*cfy*/
          {3.303974358,-0.09438500671,184.3273421,0.1514493379,0.001265700835,-1.768839371}, /*cmz*/
          {6.277831093,1.59874583,1.8868529,3.323189822} /*cfz*/
     },
     {
          2460169.5,
          {5.475319093,-0.07671428653,184.9816135,-0.3163438919,0.001937966912,1.773307481}, /*cmx*/
          {0.7592746786,5.486054624,5.398841622,2.279968032}, /*cfx*/
          {-0.7509858004,-0.009459878979,-31.77878436,0.2063402824,0.000792326725,0.3532023591}, /*cmy*/
          {5.91190303,2.74789401,-7.55372951,4.244675414}, /*cfy*/
          {-2.20030712,-0.06182510055,183.2845566,0.2946697316,-0.002004667403,-1.749901336}, /*cmz*/
          {2.318461951,4.020708408,3.921741474,0.6930505112} /*cfz*/
     },
     {
          2460224.5,
          {0.8609259049,-0.08804853862,184.6934693,-0.07582307049,0.003240682059,1.728980944}, /*cmx*/
          {3.08149374,1.59681725,1.492571316,-0.4419076094}, /*cfx*/
          {-1.311416634,0.01615497767,-41.25649424,0.1372293452,0.001723921797,0.4062813152}, /*cmy*/
          {1.92750528,5.474343967,1.896426051,1.582486298}, /*cfy*/
          {-5.663278665,0.02699237639,181.6836074,0.04674314701,-0.002948473602,-1.699259428}, /*cmz*/
          {4.633467628,6.674652122,6.335829176,4.245811933} /*cfz*/
     },
     {
          2460279.5,
          {-4.13937406,-0.02890469716,184.2303758,0.2943758163,0.00124593005,1.712371304}, /*cmx*/
          {5.312233417,3.716413096,3.509098436,2.995110002}, /*cfx*/
          {-0.2642628812,0.02036262423,-43.04164734,-0.09594829195,0.001351907084,0.3752355201}, /*cmy*/
          {4.259146166,-5.860698053,4.193453419,5.196854656}, /*cfy*/
          {-3.950751987,0.08025604775,181.7440068,0.2938774901,-0.0008805878,-1.697489458}, /*cmz*/
          {0.5757619569,5.389316985,1.913116858,1.39904383} /*cfz*/
     },
     {
          2460334.5,
          {-5.655108208,0.0405384981,184.015496,0.4214165705,-0.0009711531147,1.741512111}, /*cmx*/
          {1.182400675,5.891927663,6.120654025,0.140437712}, /*cfx*/
          {0.8779543696,-0.002855065617,-35.20852337,-0.2393741854,-0.0003286761559,0.2816110194}, /*cmy*/
          {0.33906002,3.060687115,-1.722288312,2.617022924}, /*cfy*/
          {0.6354428161,0.072361873,183.6421861,0.3835177521,0.001028645301,-1.743292866}, /*cmz*/
          {2.735096081,1.263610322,4.830627081,4.838716021} /*cfz*/
     },
     {
          2460389.5,
          {-3.337097267,0.08320910655,184.4195569,0.3102415161,-0.0019185734,1.761741082}, /*cmx*/
          {3.332667198,1.791704545,1.815622092,3.641256073}, /*cfx*/
          {0.6236171732,-0.01143246214,-23.26348314,-0.2411711553,-0.001328026065,0.1778839229}, /*cmy*/
          {2.791534584,5.485079254,1.963704528,0.1403509265}, /*cfy*/
          {4.828964184,0.01566361661,185.1092038,0.2799572837,0.001687631379,-1.765479463}, /*cmz*/
          {4.89653496,3.369581755,0.3142024533,2.066942001} /*cfz*/
     },
     {
          2460444.5,
          {1.530457527,0.06793841182,184.9880343,0.09120801705,-0.00213280626,1.742934022}, /*cmx*/
          {5.531975568,4.030855317,3.982590297,0.9282912965}, /*cfx*/
          {-0.006238023092,-0.004245496073,-14.37560996,-0.1117363174,-0.001733902584,0.1133331674}, /*cmy*/
          {5.246413388,2.014603357,4.536639265,3.749583078}, /*cfy*/
          {5.657692678,-0.05986633249,185.4587321,0.08564840087,0.002002450493,-1.744198278}, /*cmz*/
          {0.8179028891,5.54239158,2.407642322,-0.6431649051} /*cfz*/
     },
     {
          2460499.5,
          {5.446579397,-0.01181295437,185.2084796,-0.1651666625,-0.001043446434,1.74997347}, /*cmx*/
          {1.516303468,-0.05230357263,6.394241577,4.54156788}, /*cfx*/
          {-0.1967940844,-0.006565308929,-12.50797014,0.1299257699,-0.001045998271,0.1449942283}, /*cmy*/
          {0.9999035395,3.132873172,1.183809916,0.6279909421}, /*cfy*/
          {2.091224747,-0.09715155082,185.423373,-0.1600641247,0.0009204323176,-1.749285814}, /*cmz*/
          {3.08495255,1.552443954,4.843191567,2.967530758} /*cfz*/
     },
     {
          2460554.5,
          {4.634917374,-0.08841877261,185.0849121,-0.2837305322,0.001961078603,1.765036873}, /*cmx*/
          {3.84127552,2.317802763,2.270896243,1.888055648}, /*cfx*/
          {-0.6534608642,-0.000602656192,-20.00978278,0.2043058819,0.001269658986,0.2358535985}, /*cmy*/
          {2.987467091,5.991847281,2.285511949,4.117047897}, /*cfy*/
          {-3.545566242,-0.0422801229,184.9333341,-0.2608483854,-0.001913432838,-1.762042557}, /*cmz*/
          {5.40652146,3.921700692,0.7551882055,0.3077737612} /*cfz*/
     },
     {
          2460609.5,
          {-0.6342381893,-0.07741503321,184.5821358,-0.03266010862,0.002912059925,1.742318638}, /*cmx*/
          {6.153450464,4.796662904,4.569294388,-0.8315194285}, /*cfx*/
          {-0.6498167584,0.0165199969,-28.14484351,0.09993094292,0.001822314823,0.2774857483}, /*cmy*/
          {5.279854234,2.759778088,5.050210704,1.52138732}, /*cfy*/
          {-5.856177422,0.0476404721,184.2222849,-0.01800574957,-0.002626300651,-1.743031982}, /*cmz*/
          {1.429444697,6.021338412,3.030856442,3.867078834} /*cfz*/
     },
     {
          2460664.5,
          {-4.936604632,-0.00916156116,184.1739554,-0.3065281099,0.001144258778,1.718933776}, /*cmx*/
          {2.092967681,3.675244928,0.2086013822,2.626944318}, /*cfx*/
          {0.3819535408,0.005821394457,-27.70848541,0.1622843586,0.0009350436091,0.2351607981}, /*cmy*/
          {1.421694864,6.826493565,1.268913974,5.325906267}, /*cfy*/
          {-2.978911424,0.08550296357,184.648209,-0.2826353487,-0.001171056183,-1.727310104}, /*cmz*/
          {3.652561366,-0.9676760169,4.763063557,1.047234896} /*cfz*/
     },
     {
          2460719.5,
          {-5.380939814,0.057126057,184.4012531,-0.4245834064,-0.001106328089,1.719413446}, /*cmx*/
          {4.244703149,5.834137265,2.973784423,-0.2379093033}, /*cfx*/
          {0.6406238601,-0.01239356072,-20.63803109,0.2480857387,0.0006289059314,0.1734587217}, /*cmy*/
          {4.0397933,3.078357832,5.723011889,3.068855796}, /*cfy*/
          {1.901682662,0.06116413139,185.4827382,-0.3920410333,0.0008913101381,-1.724414517}, /*cmz*/
          {5.812891764,1.100449962,1.534417266,4.474058812} /*cfz*/
     },
     {
          2460774.5,
          {-2.093693046,0.08528310752,184.9943897,-0.2980972097,-0.002202172292,1.760882113}, /*cmx*/
          {0.1132824531,1.698857831,4.85746025,3.24821349}, /*cfx*/
          {-0.124725975,-0.006929375055,-16.03494885,0.1835136506,0.001418794558,0.1513362}, /*cmy*/
          {0.6313201205,5.527604977,2.108655102,0.8975937183}, /*cfy*/
          {5.428095919,-0.003372559856,185.3996287,-0.2965838313,0.002138972588,-1.757525964}, /*cmz*/
          {1.687540152,3.205075315,3.207821876,1.680037784} /*cfz*/
     },
     {
          2460829.5,
          {2.899330569,0.05173010911,185.2838863,-0.04586536686,-0.002236072939,1.78426276}, /*cmx*/
          {2.321065154,3.984748854,0.7894593584,0.5599808085}, /*cfx*/
          {-0.4574061997,0.00289121961,-14.93540528,0.05058963914,0.001328381192,0.1282183312}, /*cmy*/
          {3.280507355,2.625898014,4.631795572,4.645032255}, /*cfy*/
          {5.128996496,-0.0745942792,185.1039882,-0.05162546756,0.002299284773,-1.779347755}, /*cmz*/
          {3.89490538,5.486724356,5.450451501,5.275193583} /*cfz*/
     },
     {
          2460884.5,
          {5.852083539,-0.03535193719,185.2788105,0.2215644474,-0.0004597810982,1.764708009}, /*cmx*/
          {4.603150609,6.172252966,3.630115729,4.210011732}, /*cfx*/
          {-0.2805468856,0.0009738028087,-12.12823044,-0.1386721187,0.0005942456787,-0.1051430469}, /*cmy*/
          {5.378885538,15.98397078,1.630650403,-1.683091296}, /*cfy*/
          {0.7640719277,-0.09178105737,185.264064,0.2169804405,0.0004496957442,-1.765103246}, /*cmz*/
          {6.176243105,1.418617986,2.081833765,2.641619912} /*cfz*/
     },
     {
          2460939.5,
          {3.635653696,-0.09622251912,185.0187339,0.2594849798,-0.002492163426,1.736177384}, /*cmx*/
          {0.6507777681,2.262649239,8.504746849,1.535317998}, /*cfx*/
          {-0.289560589,0.006328711626,-13.33144062,-0.1644715006,-0.001422656431,-0.1491088347}, /*cmy*/
          {0.7183715169,6.11995583,8.76302588,1.415871837}, /*cfy*/
          {-4.571861051,-0.01851125645,185.4883014,0.2482572848,0.002379699964,-1.743130296}, /*cmz*/
          {2.222034411,3.796689049,6.922557844,-0.03549361322} /*cfz*/
     },
     {
          2460994.5,
          {-2.003684621,-0.06459429316,184.5806518,-0.03671792654,-0.002554834699,1.738736382}, /*cmx*/
          {2.947352758,4.396660236,4.513053513,5.054726161}, /*cfx*/
          {0.1476288775,0.009057075962,-18.43378362,-0.07705076705,-0.001539741065,-0.1880488723}, /*cmy*/
          {2.828248213,9.839475518,5.066551557,5.08529863}, /*cfy*/
          {-5.465522032,0.06485633071,185.4870546,-0.03398551967,0.00238035167,-1.750031653}, /*cmz*/
          {4.517007847,6.195570126,2.88412078,3.484082901} /*cfz*/
     },
     {
          2461049.5,
          {-5.533486248,0.009818304355,184.5363612,-0.3181324875,-0.0007050117451,1.748490312}, /*cmx*/
          {5.155930964,0.4558957309,0.07090581014,2.235843773}, /*cfx*/
          {0.6824042595,-0.009319894926,-19.88131416,-0.1948126119,-0.0003928158525,-0.2058036219}, /*cmy*/
          {5.413831399,6.926839922,1.730858835,2.809460652}, /*cfy*/
          {-1.624862675,0.08327784965,185.4496254,-0.2968513439,0.0008530064674,-1.753713307}, /*cmz*/
          {0.4463154387,8.275164647,4.652050069,0.6700696532} /*cfz*/
     },
     {
          2461104.5,
          {-4.94824882,0.06991221513,184.9930495,-0.3874512228,0.0009734382883,1.739027915}, /*cmx*/
          {1.028509786,2.610442111,2.873307436,-0.5889682486}, /*cfx*/
          {0.06407620781,-0.01487891886,-22.49866226,-0.2128216999,-0.0009663310782,-0.2406054274}, /*cmy*/
          {1.912108411,3.081966068,6.104801712,0.5189910223}, /*cfy*/
          {3.110306062,0.04474794113,184.713933,-0.3866696733,-0.0008670541952,-1.728436627}, /*cmz*/
          {2.606868405,4.111491483,1.257721238,4.12927437} /*cfz*/
     },
     {
          2461159.5,
          {-0.8812913052,0.08301473746,185.3620847,-0.2878516371,0.002141346481,1.737117138}, /*cmx*/
          {3.189515792,4.759079227,4.784505228,2.899912063}, /*cfx*/
          {-0.788832327,0.0003566844583,-26.90277283,-0.09942690933,-0.00119577458,-0.2618833058}, /*cmy*/
          {4.48248576,5.454279206,2.234097603,4.269660524}, /*cfy*/
          {5.663936379,-0.02340666045,183.6873911,-0.2973570983,-0.002221981818,-1.716581731}, /*cmz*/
          {4.765936041,0.006378414923,3.157069166,1.332229187} /*cfz*/
     },
     {
          2461214.5,
          {3.952783962,0.03427295735,185.4264372,-0.03973913565,0.002458938579,1.764872635}, /*cmx*/
          {5.399226589,0.7413439879,0.7208337778,0.190156785}, /*cfx*/
          {-0.7044655556,0.01009799071,-27.81003382,0.03627596903,-0.0006866387863,-0.2484547493}, /*cmy*/
          {0.5215409108,1.14261705,4.596384367,1.554946603}, /*cfy*/
          {4.225882275,-0.08546717318,183.4304287,-0.03630526085,-0.002467376274,-1.744652967}, /*cmz*/
          {0.6903426566,2.484934265,5.405376654,4.906235045} /*cfz*/
     },
     {
          2461269.5,
          {5.863087668,-0.05549600232,185.3601182,0.2554055514,0.0003004397237,1.788338302}, /*cmx*/
          {1.403450773,2.992830674,3.756030291,3.849328693}, /*cfx*/
          {-0.148852993,0.008855352423,-25.18531147,0.1146975596,0.0003584446077,-0.2235607867}, /*cmy*/
          {2.671334984,3.594380704,5.81205083,4.977565508}, /*cfy*/
          {-0.7555021519,-0.07999374621,183.949312,-0.265879619,-0.0002504845212,-1.776163309}, /*cmz*/
          {2.979379635,7.648800088,2.366624816,2.28506942} /*cfz*/
     },
     {
          2461324.5,
          {2.468734236,-0.09729349984,185.0638337,0.2631258376,-0.002910903426,1.754945658}, /*cmx*/
          {3.741878782,5.362325647,11.63539198,1.200603175}, /*cfx*/
          {0.345469185,0.007226652709,-23.04937909,0.09392320789,-0.001291332807,-0.2233261657}, /*cmy*/
          {4.715212973,6.245618093,5.692276602,2.0784138}, /*cfy*/
          {-5.408165055,0.006887880648,184.5799205,-0.266078903,-0.002878519733,-1.751756501}, /*cmz*/
          {5.320057894,3.745719526,13.15222111,-0.3609674804} /*cfz*/
     },
     {
          2461379.5,
          {-3.134121739,-0.04775863072,184.7392292,-0.09537203889,-0.002404337912,1.717714001}, /*cmx*/
          {6.033060542,1.384130101,1.250685745,4.702626562}, /*cfx*/
          {0.8154144635,-0.004674800268,-25.07780178,-0.0885678284,-0.0009568933352,-0.2621634268}, /*cmy*/
          {0.6158276693,1.132407544,1.916947439,-0.6235075032}, /*cfy*/
          {-4.77712406,0.07751070414,184.5006377,0.08449137376,-0.002452099757,-1.711777008}, /*cmz*/
          {1.329612861,5.987465399,2.748836969,3.144421295} /*cfz*/
     },
     {
          2461434.5,
          {-5.715734087,0.02818423623,184.9362689,-0.3612860034,-0.0005153639924,1.73296018}, /*cmx*/
          {1.943468222,3.549843074,2.326947322,1.848405355}, /*cfx*/
          {0.5032075139,-0.02012259904,-30.46527683,-0.1804796157,0.000322718449,-0.3262673211}, /*cmy*/
          {3.043715962,3.82479255,3.668278449,3.086744884}, /*cfy*/
          {-0.2746695282,0.07729514103,183.4693751,0.3600120442,-0.0005601865106,-1.709491971}, /*cmz*/
          {3.525479944,1.882740257,4.108613455,0.2891371054} /*cfz*/
     },
     {
          2461489.5,
          {-4.097353386,0.07706351009,185.3537047,-0.3753224301,0.001171571116,1.761827066}, /*cmx*/
          {4.093715157,5.671905756,-0.3744540123,-0.9690207247}, /*cfx*/
          {-0.7011457334,-0.01134867376,-37.24661438,-0.1384326427,0.001008037466,-0.3819390458}, /*cmy*/
          {5.475228842,6.117778905,6.325553424,0.4923327679}, /*cfy*/
          {4.10365194,0.02859410484,181.8605093,0.3915322478,-0.001226096344,-1.721642425}, /*cmz*/
          {5.672311737,4.022886806,-2.11963899,3.74769952} /*cfz*/
     },
     {
          2461544.5,
          {0.4175193721,0.07487373588,185.4982504,-0.2433351282,0.001964177564,1.746225567}, /*cmx*/
          {-0.02154851569,1.535728845,1.544319382,2.561753025}, /*cfx*/
          {-1.312826343,0.008353405221,-41.41993352,-0.03378771467,0.0006937226765,-0.3965755705}, /*cmy*/
          {1.507679679,1.321585083,2.369312023,4.095577678}, /*cfy*/
          {5.720926043,-0.04125560843,180.8761664,0.2491484812,-0.00215174693,-1.699333958}, /*cmz*/
          {1.551510868,6.206837761,-0.09345882687,0.9916133254} /*cfz*/
     },
     {
          2461599.5,
          {4.729725097,0.0140858972,185.4978352,-0.0138818059,0.002221528054,1.751172791}, /*cmx*/
          {2.198806822,3.795574958,3.80054074,-0.1394688957}, /*cfx*/
          {-0.8044438225,0.01833298775,-41.98979178,0.06816466839,0.0002132464538,-0.3873894641}, /*cmy*/
          {3.720499662,-7.464708108,-34.61430525,1.331064801}, /*cfy*/
          {3.278011773,-0.09127944779,180.7225522,-0.002030923988,-0.002272589496,-1.705389774}, /*cmz*/
          {3.772203079,6.501089218,2.182137071,4.577334917} /*cfz*/
     },
     {
          2461654.5,
          {5.465275357,-0.0734234494,185.3919778,0.2596412291,-0.0001787178858,1.768710917}, /*cmx*/
          {4.490024012,6.078792256,16.90609989,3.49279208}, /*cfx*/
          {0.2343038723,0.01531238084,-40.93968965,0.06238807655,-0.0004413439276,-0.3792855202}, /*cmy*/
          {5.900793701,0.6311776006,13.27586606,4.838771482}, /*cfy*/
          {-2.063941529,-0.06402321942,181.0482754,0.2709118832,0.0002550108653,-1.727775928}, /*cmz*/
          {6.06923913,126.9775785,-28.51703671,1.93318313} /*cfz*/
     },
     {
          2461709.5,
          {1.038533745,-0.09297168409,185.1621555,0.247833453,-0.002952385689,1.774684519}, /*cmx*/
          {0.5432006386,2.143168378,-92.10204837,0.8327482152}, /*cfx*/
          {1.136155784,0.0008096831181,-39.83346185,0.01048441279,-0.0008999930411,-0.3875764123}, /*cmy*/
          {1.834235167,3.138365485,2.520724969,2.106774236}, /*cfy*/
          {-5.740879808,0.02842761018,181.5040434,0.2517991089,0.002994609802,-1.737281331}, /*cmz*/
          {2.12688844,3.681256455,-5.806919707,-0.7224136979} /*cfz*/
     },
     {
          2461764.5,
          {-4.237199672,-0.02768551051,185.108496,-0.1007219631,-0.00250269712,1.728573058}, /*cmx*/
          {2.828917183,4.478139195,4.32625543,4.35899223}, /*cfx*/
          {1.172808455,-0.01969473118,-41.76836708,-0.1012925403,-0.0002771159098,-0.4231541362}, /*cmy*/
          {4.121142078,11.02719464,4.322993912,-0.5764337197}, /*cfy*/
          {-3.846172116,0.08197526399,181.0791433,-0.1042755611,0.002617612871,-1.681168019}, /*cmz*/
          {4.41370825,5.825557513,2.694524927,2.803632746} /*cfz*/
     },
     {
          2461819.5,
          {-5.708347213,0.04576999805,185.4313158,-0.3780589672,-0.0005212512536,1.719713371}, /*cmx*/
          {5.019862592,0.3117307868,-0.6148254372,1.505366327}, /*cfx*/
          {-0.01336493906,-0.0240006684,-47.20783926,-0.1259024428,-0.0007453506044,-0.4692772622}, /*cmy*/
          {0.169297862,0.6169636204,-1.936486399,3.006637941}, /*cfy*/
          {0.8281204779,0.06761638244,179.5295612,-0.3952299952,0.00042101815,-1.656151926}, /*cmz*/
          {0.316795729,1.795477352,4.199287402,-0.05807638105} /*cfz*/
     },
     {
          2461874.5,
          {-3.057902178,0.08148526698,185.5459213,-0.4130088197,-0.001547409506,1.738917335}, /*cmx*/
          {0.880616435,2.43176243,-0.5817091996,4.939907083}, /*cfx*/
          {-1.389007435,-0.004757754207,-52.30754128,-0.06810946389,-0.0007117147818,-0.5051977262}, /*cmy*/
          {2.450146029,2.077244406,0.2349833644,0.2538317274}, /*cfy*/
          {4.670771645,0.0128182772,178.0348461,-0.424202696,0.001747862289,-1.665572347}, /*cmz*/
          {2.451621122,3.959375407,-2.22791781,3.367456914} /*cfz*/
     },
     {
          2461929.5,
          {1.704867364,0.06517578814,185.4754066,-0.2440973621,-0.002473940008,1.762707643}, /*cmx*/
          {3.04382822,4.609533543,1.477218088,2.186576719}, /*cfx*/
          {-1.62079467,0.01580677985,-54.61010984,-0.09340239702,0.0001444669406,-0.5228047607}, /*cmy*/
          {4.655155866,3.311476196,3.038347281,3.775170879}, /*cfy*/
          {5.376092788,-0.05459251135,177.2969898,-0.2280592231,0.002559899799,-1.684122689}, /*cmz*/
          {4.610654522,6.142101092,-0.1005288268,0.6137401327} /*cfz*/
     },
     {
          2461984.5,
          {5.415222868,-0.00663464864,185.4584099,0.04153271565,-0.002120396634,1.773683379}, /*cmx*/
          {5.271587186,0.4337638924,3.780871889,-0.4745063993}, /*cfx*/
          {-0.7170353582,0.02649305731,-55.82136596,-0.07405589939,0.0007586334138,-0.5348426305}, /*cmy*/
          {0.5501142919,5.65069162,5.452223302,1.046691592}, /*cfy*/
          {2.171724556,-0.08944956583,176.8383577,0.06673881634,0.001965692346,-1.689906976}, /*cmz*/
          {0.5600009278,2.166596818,2.193433298,4.241910747} /*cfz*/
     },
     {
          2462039.5,
          {4.957222436,-0.08831917452,185.4408705,0.2943731334,0.0006530857431,1.754470547}, /*cmx*/
          {1.293858521,2.876912854,5.774731742,3.172060567}, /*cfx*/
          {0.8381140358,0.01670817595,-56.93628954,0.02144377228,0.0003568465448,-0.5372319538}, /*cmy*/
          {2.782915698,1.01043998,1.337686064,4.635807312}, /*cfy*/
          {-3.090808128,-0.04440387306,176.6064189,0.3058121178,-0.0008499189179,-1.669371803}, /*cmz*/
          {2.872979666,4.445202834,4.246574663,1.611719392} /*cfz*/
     },
     {
          2462094.5,
          {-0.3115057345,-0.0844908046,185.3631037,0.2007127876,0.002976394554,1.749666353}, /*cmx*/
          {3.630188518,5.214156194,2.084697705,0.4750978816}, /*cfx*/
          {1.804678774,-0.0117217621,-57.12260682,0.05931399156,-0.0004457850344,-0.5462171033}, /*cmy*/
          {5.081597315,3.426029716,4.981699645,1.938505006}, /*cfy*/
          {-5.537595733,0.04557966535,176.6849939,0.1940484219,-0.003116369012,-1.661572386}, /*cmz*/
          {5.213256906,0.5360551317,0.4686123081,5.200049245} /*cfz*/
     },
     {
          2462149.5,
          {-5.048693902,-0.00886372735,185.4139934,-0.1486735167,0.002069078089,1.741816645}, /*cmx*/
          {5.901976567,1.245737709,4.183477709,3.979852509}, /*cfx*/
          {1.058360254,-0.0309891429,-58.79020557,0.0810344908,-0.0004864242915,-0.5778424665}, /*cmy*/
          {1.111087851,4.978980048,-0.4056301034,-0.7651219569}, /*cfy*/
          {-2.698527656,0.08149313154,176.0043201,-0.1712290243,-0.002026312655,-1.639890507}, /*cmz*/
          {1.198167036,2.644405842,2.650914183,2.415485986} /*cfz*/
     },
     {
          2462204.5,
          {-5.471071526,0.05801521657,185.4681982,-0.3754710035,0.0005597182549,1.748365438}, /*cmx*/
          {1.802402612,3.378436321,-0.7900653389,1.151407343}, /*cfx*/
          {-0.735947665,-0.02132494834,-62.21139111,0.06112530525,-0.000942643098,-0.6020543657}, /*cmy*/
          {3.391840963,0.01504054657,1.41532933,2.778384733}, /*cfy*/
          {1.887254358,0.05534862491,174.7379912,-0.398289003,0.0003397652029,-1.640933827}, /*cmz*/
          {3.371163522,4.896638097,12.79981715,-0.4244461666} /*cfz*/
     },
     {
          2462259.5,
          {-2.085933878,0.08247712047,185.4139003,-0.4075811687,0.001317226342,1.728357179}, /*cmx*/
          {3.946898007,5.507131727,-0.5899220312,4.601538859}, /*cfx*/
          {-1.927719002,0.003016971021,-64.46648923,0.1191770535,-0.0003588220354,-0.6062145107}, /*cmy*/
          {5.599838636,1.06475793,3.825648848,-0.03002929957}, /*cfy*/
          {5.060760124,-0.00391490957,174.0267512,-0.3956973963,-0.00158253523,-1.621113525}, /*cmz*/
          {5.506647706,0.7713545442,-2.155726718,3.021221495} /*cfz*/
     },
     {
          2462314.5,
          {2.690237894,0.05411391131,185.4686178,-0.2547070551,0.002656252288,1.730635018}, /*cmx*/
          {6.107896394,1.379707759,1.372318114,1.823043934}, /*cfx*/
          {-1.739444891,0.02369713269,-65.8625875,0.1574231133,0.0008988816451,-0.62232013}, /*cmy*/
          {1.464118257,3.25241305,5.927538709,3.432978921}, /*cfy*/
          {4.787566654,-0.06501842963,173.515803,-0.2189632972,-0.00254114183,-1.61652804}, /*cmz*/
          {1.385664765,2.864809549,-0.1670355876,0.2473014787} /*cfz*/
     },
     {
          2462369.5,
          {5.761225744,-0.02579105494,185.5217591,0.06258538916,0.002390546588,1.781728369}, /*cmx*/
          {2.052724266,3.607409716,3.670981345,-0.8439200864}, /*cfx*/
          {-0.3792831173,0.03354643374,-68.61002905,0.0746817093,0.001344235732,-0.672257884}, /*cmy*/
          {3.640164589,6.240829811,2.279404742,0.7214059871}, /*cfy*/
          {0.9806767543,-0.08386377415,172.3583833,0.08751339864,-0.002045716777,-1.649805494}, /*cmz*/
          {3.620731204,5.494147687,2.044516912,3.869353851} /*cfz*/
     },
     {
          2462424.5,
          {4.194669123,-0.09667313943,185.5244329,0.3470595047,-0.001077493792,1.7825563}, /*cmx*/
          {4.368881353,5.954865256,5.810232798,2.835960756}, /*cfx*/
          {1.62449012,0.01141895849,-71.35921216,-0.1160100485,0.0003575976249,-0.6896159081}, /*cmy*/
          {5.925584054,0.9992170524,5.599941901,4.390390746}, /*cfy*/
          {-3.950847311,-0.02519828201,171.2722601,0.3268740019,0.001181350752,-1.641529578}, /*cmz*/
          {5.942458592,1.277572418,4.351903625,1.267638239} /*cfz*/
     },
     {
          2462479.5,
          {-1.539015779,-0.07072333278,185.4856639,0.1911781189,-0.003471972533,1.741765095}, /*cmx*/
          {0.430320334,1.999377738,1.996788954,0.1501058298}, /*cfx*/
          {2.218771684,-0.02649391201,-72.03039198,-0.1155712385,0.0008625082088,-0.6807334967}, /*cmy*/
          {1.99273127,3.542499073,3.676575,1.734863999}, /*cfy*/
          {-5.205646493,0.05851503314,170.9211139,0.1568738457,0.003373147681,-1.600504398}, /*cmz*/
          {2.002620552,3.572872056,0.4113679609,4.860153335} /*cfz*/
     },
     {
          2462534.5,
          {-5.447666442,0.008737233315,185.4393355,-0.2109055853,-0.001955270352,1.727729063}, /*cmx*/
          {2.691136562,4.282102562,4.066502018,3.614940899}, /*cfx*/
          {0.610846184,-0.03618819984,-72.53626142,-0.02559586326,0.001063433656,-0.6830088709}, /*cmy*/
          {4.304335833,4.962454666,5.710822551,5.262447732}, /*cfy*/
          {-1.718356205,0.07965294359,170.6881962,-0.2366299997,0.001677312192,-1.586279728}, /*cmz*/
          {4.254285562,5.83769357,2.453966223,2.031870741} /*cfz*/
     },
     {
          2462589.5,
          {-4.876097618,0.06645793143,185.3475383,-0.4181811288,-0.0003986029233,1.751957676}, /*cmx*/
          {4.858491402,0.1309915729,-1.877955678,0.7640326831}, /*cfx*/
          {-1.427721426,-0.01561800904,-73.17048859,0.1031565049,0.0007682465222,-0.6919112395}, /*cmy*/
          {0.2500955727,-4.455955944,1.623477745,2.453677112}, /*cfy*/
          {2.765043338,0.04416396102,170.6468198,-0.4071748661,-0.0006337250696,-1.611864405}, /*cmz*/
          {0.1269707604,1.705056951,5.656470091,-0.8257659261} /*cfz*/
     },
     {
          2462644.5,
          {-0.996538289,0.07947016231,185.2867621,-0.3995327225,0.001570845426,1.7599589}, /*cmx*/
          {0.7149265122,2.274915549,-35.31316815,4.238955447}, /*cfx*/
          {-2.299144559,0.009713216373,-73.22523762,0.1905348061,-0.0003757471708,-0.6983725465}, /*cmy*/
          {2.402901339,3.983761588,2.992985621,-0.3731697481}, /*cfy*/
          {5.31855867,-0.01764950618,170.755527,-0.3535466971,-0.001563749714,-1.618136586}, /*cmz*/
          {2.264261622,3.803944939,0.9001725017,2.652251153} /*cfz*/
     },
     {
          2462699.5,
          {3.553375323,0.03939368296,185.3759778,-0.2316731411,0.002620002943,1.746887743}, /*cmx*/
          {2.882617213,4.459527376,4.465574425,1.48691386}, /*cfx*/
          {-1.743401472,0.0317208013,-74.90849423,0.1708985425,0.00144328731,-0.7229117522}, /*cmy*/
          {4.532942968,6.472580739,9.108227664,3.116160477}, /*cfy*/
          {4.218795313,-0.07165170789,169.8501078,-0.191006272,-0.002240612848,-1.592403736}, /*cmz*/
          {4.437792026,5.829582996,2.888382415,-0.09352642566} /*cfz*/
     },
     {
          2462754.5,
          {5.82045303,-0.04434607741,185.3969561,0.07992106373,0.002355020089,1.756803525}, /*cmx*/
          {5.116385142,0.3042551422,0.5121469292,5.087791443}, /*cfx*/
          {0.1106822556,0.03713044,-78.95155612,-0.08815237412,0.001550513885,-0.7670759554}, /*cmy*/
          {0.4535593518,6.941563421,5.521224861,0.4214605867}, /*cfy*/
          {0.03791341233,-0.07697817664,167.8629355,0.08181808961,-0.001935459242,-1.583388792}, /*cmz*/
          {0.3931837618,2.398293098,5.0933111,3.507056949} /*cfz*/
     },
     {
          2462809.5,
          {3.136703952,-0.1001562456,185.4381928,0.3647959619,-0.0013717924,1.78056053}, /*cmx*/
          {1.153265956,2.735555245,2.583840663,2.46716665}, /*cfx*/
          {2.319634481,0.0008576702451,-82.23940705,0.189094714,0.000658772598,-0.7960859979}, /*cmy*/
          {2.777146935,1.054698865,-3.006619833,4.101620713}, /*cfy*/
          {-4.459936674,-0.00898909416,166.3492249,0.3123310357,0.001317028578,-1.596325256}, /*cmz*/
          {2.711214422,4.335301825,1.215779332,0.8798388751} /*cfz*/
     },
     {
          2462864.5,
          {-2.756155527,-0.05485982801,185.3574097,0.1841317437,-0.003685378793,1.765509691}, /*cmx*/
          {3.498649017,5.096168084,5.079905597,-0.2040782009}, /*cfx*/
          {2.23282835,-0.03777480455,-82.63461829,0.1449730702,0.001559586178,-0.784728613}, /*cmy*/
          {5.149073453,3.705749501,6.647493505,1.468993811}, /*cfy*/
          {-4.746630789,0.06634013798,166.2786601,0.1362932894,0.0033130023,-1.585561673}, /*cmz*/
          {5.049766316,0.2813923798,3.517898651,4.482795561} /*cfz*/
     },
     {
          2462919.5,
          {-5.720465961,0.02500307455,185.1731897,-0.241218201,-0.002055223049,1.725281582}, /*cmx*/
          {5.754385216,1.039578875,0.8679092839,3.274368502}, /*cfx*/
          {0.02176191409,-0.03459688756,-81.37117626,-0.04608264148,0.001408124025,-0.750354299}, /*cmy*/
          {1.165812345,5.141340612,2.640387033,4.989316546}, /*cfy*/
          {-0.8974267398,0.07537151465,167.0783487,-0.2459106049,0.001627764642,-1.559524778}, /*cmz*/
          {1.012837937,2.675813948,5.501631393,1.670992549} /*cfz*/
     },
     {
          2462974.5,
          {-4.222705338,0.07410728677,185.0369543,-0.4658703394,0.0006349214994,1.719927755}, /*cmx*/
          {1.627804286,3.195744195,4.028340248,0.395595418}, /*cfx*/
          {-1.901228135,-0.009140948921,-79.4672486,0.2039770241,0.0003665261172,-0.7291903371}, /*cmy*/
          {3.349756865,-7.837946969,5.248328529,2.112214792}, /*cfy*/
          {3.388367337,0.03279816551,168.1639679,-0.4200297479,-0.0008790191722,-1.563032061}, /*cmz*/
          {3.165662394,4.771364848,2.401431181,5.077782466} /*cfz*/
     },
     {
          2463029.5,
          {0.0755842257,0.07564562905,185.1702225,-0.4151097862,0.001986461064,1.757129102}, /*cmx*/
          {3.756969484,5.324063898,-0.8563847545,3.849990198}, /*cfx*/
          {-2.422559114,0.01564688551,-78.61981247,0.2417957049,0.001093974741,-0.7517825395}, /*cmy*/
          {5.457432073,0.7947188865,3.517562683,-0.7535094315}, /*cfy*/
          {5.266284608,-0.02836647051,168.393624,-0.3542798971,-0.001774059024,-1.591231251}, /*cmz*/
          {5.299966952,0.5467964123,3.959141211,2.257268706} /*cfz*/
     },
     {
          2463084.5,
          {4.382744491,0.02431760546,185.3174876,-0.1892644369,0.002758279428,1.768367641}, /*cmx*/
          {5.926413639,1.203491813,1.204629986,1.125476677}, /*cfx*/
          {-1.522689742,0.03810751218,-81.09063745,0.1370623518,0.001788210719,-0.7959299595}, /*cmy*/
          {1.309100302,3.478684465,6.026360835,2.786089252}, /*cfy*/
          {3.535305451,-0.07428493079,167.0383564,-0.1700534194,-0.002215262747,-1.58262969}, /*cmz*/
          {1.191722354,2.527524889,5.895035133,-0.4649492167} /*cfz*/
     },
     {
          2463139.5,
          {5.815239354,-0.06072556013,185.2936348,0.1391356422,0.001890953137,1.760433014}, /*cmx*/
          {1.891927346,3.473766272,3.559954819,4.761834294}, /*cfx*/
          {0.7304039859,0.03409957789,-85.27529526,0.1257740483,0.001233148246,-0.8280228008}, /*cmy*/
          {3.558927387,1.339149512,2.516742824,0.1575137142}, /*cfy*/
          {-0.7730414342,-0.068468231,164.9737085,0.1048785414,-0.001584877476,-1.56099376}, /*cmz*/
          {3.436995981,5.333375729,1.791100775,3.162746351} /*cfz*/
     },
     {
          2463194.5,
          {2.115275911,-0.09981511191,185.1269423,0.3568623394,-0.001784604505,1.746309034}, /*cmx*/
          {4.222748617,5.823659048,5.754989386,2.124273142}, /*cfx*/
          {2.721004371,-0.01252273572,-88.00306326,0.2201048365,-0.001082515455,-0.8337626224}, /*cmy*/
          {5.916739302,4.268583968,3.737554561,3.833978514}, /*cfy*/
          {-4.752494211,0.006371103151,163.8146623,0.286319235,0.001486962354,-1.547384498}, /*cmz*/
          {5.758413764,1.087193213,4.342356258,0.513566992} /*cfz*/
     },
     {
          2463249.5,
          {-3.675021067,-0.04024473502,184.8550717,0.1177840317,-0.003358962799,1.743624821}, /*cmx*/
          {0.2760628578,1.858822985,1.836078155,-0.5845071193}, /*cfx*/
          {1.836430937,-0.04315009065,-87.54042233,0.1171236234,-0.001844084096,-0.8162247198}, /*cmy*/
          {2.000601057,0.7734628674,6.570359889,1.157448791}, /*cfy*/
          {-4.169219003,0.07286930918,164.2144168,0.09191284186,0.00282331229,-1.558732804}, /*cmz*/
          {1.803555348,3.059412195,0.248529702,4.080897731} /*cfz*/
     },
     {
          2463304.5,
          {-5.78823481,0.03737911135,184.659531,-0.267279197,-0.001771994697,1.74597617}, /*cmx*/
          {2.51691123,4.120510671,3.829753105,2.89817348}, /*cfx*/
          {-0.6212211273,-0.02880540202,-84.56584359,-0.1199620294,-0.001261120671,-0.7816556652}, /*cmy*/
          {4.267685661,2.11442281,2.644922148,4.65322006}, /*cfy*/
          {0.0168217055,0.06961911558,165.8837603,-0.2378899604,0.001491119945,-1.576755491}, /*cmz*/
          {4.041901099,-0.4819194926,2.071354304,1.282728866} /*cfz*/
     },
     {
          2463359.5,
          {-3.602443045,0.07885289282,184.8502762,-0.4537348891,-0.0005819070947,1.727204494}, /*cmx*/
          {4.670357835,-0.03313899713,-77.47980039,0.04778088116}, /*cfx*/
          {-2.226163555,-0.002668590391,-81.29803421,-0.2518372199,0.0002645443784,-0.7495332635}, /*cmy*/
          {0.131127026,4.665879603,22.46507057,1.775204882}, /*cfy*/
          {4.011724231,0.02022602932,167.440343,-0.3792485287,0.0007246205951,-1.564083181}, /*cmz*/
          {-0.08210178793,1.532106203,-3.417443279,4.725059887} /*cfz*/
     },
     {
          2463414.5,
          {0.9535984561,0.06977954185,185.1356679,-0.4230518324,-0.002087019785,1.729876335}, /*cmx*/
          {0.5177228773,2.075789022,-0.9746041996,3.491023039}, /*cfx*/
          {-2.384000541,0.02253061752,-80.7821272,-0.2357757036,-0.001492740198,-0.7634424056}, /*cmy*/
          {2.225558569,0.756131055,9.904255691,-1.095083982}, /*cfy*/
          {5.110321798,-0.03882696489,167.5205475,-0.3633631989,-0.001550435201,-1.556593015}, /*cmz*/
          {2.056862178,3.554630639,6.898640129,1.891329485} /*cfz*/
     },
     {
          2463469.5,
          {4.938233696,0.009944929537,185.136989,-0.1851803598,-0.003155971684,1.757803567}, /*cmx*/
          {2.686835022,4.235977663,1.123082935,0.7489134996}, /*cfx*/
          {-1.072138122,0.04188258312,-83.28760314,-0.07987640942,-0.001840264614,-0.8099752692}, /*cmy*/
          {4.384663874,3.634168321,6.033715407,2.460288216}, /*cfy*/
          {2.813447813,-0.07730646827,166.2080717,-0.1909372097,-0.002637146654,-1.568178111}, /*cmz*/
          {4.225821976,5.626166584,2.580505102,-0.8561103325} /*cfz*/
     },
     {
          2463524.5,
          {5.535395696,-0.07261772491,184.8150782,0.1931074104,-0.001708044867,1.783841969}, /*cmx*/
          {4.942655172,0.2360472005,3.556595311,4.406945615}, /*cfx*/
          {1.403609662,0.02524311327,-86.09454561,-0.1665266336,-0.0008401689458,-0.8440826731}, /*cmy*/
          {0.3901630398,7.962417822,2.680581853,-0.1249815457}, /*cfy*/
          {-1.661089754,-0.06010342642,165.0089793,0.1270765109,-0.001688089849,-1.590958752}, /*cmz*/
          {0.1877326824,1.848869221,4.929393018,2.789193927} /*cfz*/
     },
     {
          2463579.5,
          {1.08732599,-0.09466531842,184.4967323,0.3869861917,0.002590833002,1.752246884}, /*cmx*/
          {1.002641557,2.603324182,5.704489848,1.796139605}, /*cfx*/
          {2.825509782,-0.02430750145,-87.6126625,-0.2294982873,-0.001621404103,-0.8326391038}, /*cmy*/
          {2.770562303,4.325536896,13.38681331,3.577476133}, /*cfy*/
          {-5.141408808,0.02230277832,164.6709196,0.3174955626,0.001967772432,-1.570279933}, /*cmz*/
          {2.51921058,4.097837655,1.038902237,0.1690492475} /*cfz*/
     },
     {
          2463634.5,
          {-4.297507329,-0.02533162145,184.30941,0.06385629617,0.003470237347,1.718472651}, /*cmx*/
          {3.335356144,4.887455721,1.765995141,-0.9372881213}, /*cfx*/
          {1.287779742,-0.04245601358,-86.41760691,-0.07533126595,-0.001967474135,-0.7895642187}, /*cmy*/
          {5.123694717,1.290221684,3.425090378,0.8565186037}, /*cfy*/
          {-3.657176925,0.0794573054,165.4740299,0.0704491583,0.002864912205,-1.554522926}, /*cmz*/
          {4.848604812,-0.3285400983,3.27970561,3.718787781} /*cfz*/
     },
     {
          2463689.5,
          {-5.586106441,0.04875329577,184.4952898,-0.3216580581,0.001232646765,1.733043661}, /*cmx*/
          {5.559069589,0.8654770825,3.667977753,2.508778684}, /*cfx*/
          {-1.092306445,-0.02253259438,-82.56726467,0.1946923159,-0.0006824609537,-0.7555702325}, /*cmy*/
          {1.06282464,8.490152579,5.944102917,4.28340433}, /*cfy*/
          {0.9083658244,0.06414273529,167.2677537,0.2589740675,0.001207148011,-1.579904155}, /*cmz*/
          {0.7956517298,-0.6413503786,5.056055598,0.8915034258} /*cfz*/
     },
     {
          2463744.5,
          {-2.758463911,0.08033689378,184.8373892,-0.4498235312,-0.000830196716,1.75133603}, /*cmx*/
          {1.422242639,2.997102641,6.694112471,-0.3302029056}, /*cfx*/
          {-2.366634591,0.00265154945,-79.35703412,0.260337264,0.0008489771692,-0.7464963177}, /*cmy*/
          {3.175941971,4.624367413,1.318737355,1.405578358}, /*cfy*/
          {4.582188198,0.009428183797,168.454566,0.3764391583,-0.0006063879057,-1.596022758}, /*cmz*/
          {2.953452152,1.392231987,2.363350404,4.345680529} /*cfz*/
     },
     {
          2463799.5,
          {1.875981253,0.05991831086,184.9898613,-0.3792829055,-0.00199211259,1.74221502}, /*cmx*/
          {3.560562448,5.122277382,2.099690139,3.154057338}, /*cfx*/
          {-2.203869687,0.02886348324,-79.1841745,0.1636362025,0.001560338464,-0.7528840828}, /*cmy*/
          {5.288090575,0.7007384232,3.755030105,4.889439132}, /*cfy*/
          {5.015935702,-0.04874289744,168.3010794,0.3502167677,-0.001505038481,-1.581614025}, /*cmz*/
          {5.097150597,3.489479143,3.582948309,1.546535708} /*cfz*/
     },
     {
          2463854.5,
          {5.30869767,-0.005620678366,184.7752974,-0.1567945955,-0.002917000232,1.738086223}, /*cmx*/
          {5.740425252,0.9800311091,4.180140838,0.4135269933}, /*cfx*/
          {-0.5128594033,0.0401090192,-80.23252062,-0.02126566099,0.001290379798,-0.7615422133}, /*cmy*/
          {1.21205751,2.049882683,6.051450289,2.198112225}, /*cfy*/
          {2.208775406,-0.08135147095,167.9877719,0.1831113087,-0.002698902366,-1.580384823}, /*cmz*/
          {0.9869802783,5.726089707,5.689483775,5.079327434} /*cfz*/
     },
     {
          2463909.5,
          {4.968810365,-0.08287665018,184.2791918,0.2006017975,-0.001557489272,1.762997993}, /*cmx*/
          {1.717817092,3.330144072,0.2660754273,4.047852404}, /*cfx*/
          {1.841110131,0.01280917166,-80.67234822,0.1674786049,0.0002755033603,-0.7769224334}, /*cmy*/
          {3.530170363,8.178901836,3.086773547,-0.4017641073}, /*cfy*/
          {-2.53944206,-0.05073537169,168.3503371,-0.1509465082,-0.001660774243,-1.612577526}, /*cmz*/
          {3.235107049,1.59032994,1.83515229,2.420596174} /*cfz*/
     },
     {
          2463964.5,
          {-0.06118353715,-0.08721922598,183.9508608,0.3730509153,0.00261105411,1.768344024}, /*cmx*/
          {4.061774227,5.662559437,2.525274784,1.438125761}, /*cfx*/
          {2.50302867,-0.03011215032,-81.05872604,0.1809857594,0.001676542821,-0.7756714868}, /*cmy*/
          {5.90678048,4.351199334,0.9190772873,3.285815492}, /*cfy*/
          {-5.437549748,0.03780426266,168.6614114,-0.3362150124,0.002107327988,-1.625137833}, /*cmz*/
          {5.572111229,4.018377877,4.053019601,-0.1915229856} /*cfz*/
     },
     {
          2464019.5,
          {-4.932089699,-0.009082265213,184.0044247,0.04103380386,0.003358509096,1.734167388}, /*cmx*/
          {0.1072075565,1.395399497,4.788380114,5.006847973}, /*cfx*/
          {0.6863762533,-0.03635028529,-79.68392793,0.05640246509,0.001711592615,-0.7332299282}, /*cmy*/
          {1.947622373,-192.5828037,3.395639644,0.5540931948}, /*cfy*/
          {-3.062715706,0.08332450917,169.103998,-0.07264261021,0.00303168262,-1.602622004}, /*cmz*/
          {1.620502878,6.028934519,0.03442555601,3.384923848} /*cfz*/
     },
     {
          2464074.5,
          {-5.345866603,0.06076457646,184.415416,0.343842979,0.001253191711,1.708386051}, /*cmx*/
          {2.325058244,0.8054395194,0.2304822143,2.161600995}, /*cfx*/
          {-1.343511019,-0.01622594093,-76.24741935,0.2210529312,0.0001001497004,-0.6909442146}, /*cmy*/
          {4.132195947,5.42369951,6.210045641,3.948682787}, /*cfy*/
          {1.721644374,0.0569704238,170.1838967,0.274530999,0.00134704128,-1.582543459}, /*cmz*/
          {3.85016082,-3.920866878,1.859918746,0.5509536877} /*cfz*/
     },
     {
          2464129.5,
          {-1.818069962,0.08088546175,184.8404776,0.4551110677,-0.001077639638,1.734099731}, /*cmx*/
          {4.465941964,2.896628615,3.352513791,-0.7021479835}, /*cfx*/
          {-2.276375918,0.008709623851,-74.0060135,0.219714751,0.001260988442,-0.6913872227}, /*cmy*/
          {-0.05141688993,1.431626038,10.98972344,1.061215225}, /*cfy*/
          {4.945690765,-0.001427661504,170.827859,0.4041108692,-0.0006206638412,-1.605305071}, /*cmz*/
          {6.001130255,4.431437016,4.938229973,3.97430039} /*cfz*/
     },
     {
          2464184.5,
          {2.83908519,0.04961060097,184.8455103,0.3403889524,-0.002137441307,1.761968249}, /*cmx*/
          {0.3237653844,4.997754336,5.064339418,2.796067834}, /*cfx*/
          {-1.740317342,0.03234966149,-73.23101022,0.07033638905,0.001357754627,-0.6955116996}, /*cmy*/
          {2.097339627,3.368324424,0.692300053,4.602568549}, /*cfy*/
          {4.763765848,-0.05828546488,171.2447904,0.3397210438,-0.001896535617,-1.638322064}, /*cmz*/
          {1.858456567,0.3051516535,0.2175581776,1.183404739} /*cfz*/
     },
     {
          2464239.5,
          {5.676403433,-0.02148976829,184.3744208,0.09853193257,-0.002652847455,1.753968402}, /*cmx*/
          {2.518033139,0.7995411665,0.9193966633,0.09941859413}, /*cfx*/
          {0.1502903989,0.03082776581,-71.4448185,0.09698831709,0.0004891930312,-0.6731657663}, /*cmy*/
          {4.361615761,3.326447922,2.514822059,1.985715588}, /*cfy*/
          {1.442009049,-0.08276152953,172.4625442,0.1225169927,-0.002651275647,-1.648945381}, /*cmz*/
          {4.044081363,2.724229456,2.501933907,4.763003904} /*cfz*/
     },
     {
          2464294.5,
          {4.374237389,-0.09213502585,183.7759542,-0.2198980975,-0.001026708266,1.738617591}, /*cmx*/
          {4.79185393,3.23708797,3.376826962,3.7382589}, /*cfx*/
          {1.934367297,9.125573654e-05,-69.35402692,0.1383842761,-0.0003318002877,-0.6550367971}, /*cmy*/
          {0.4249805983,5.269539487,5.650871614,-0.6169526846}, /*cfy*/
          {-3.453255504,-0.03658500783,173.8770367,-0.1966404573,-0.001207503273,-1.645891856}, /*cmz*/
          {0.02891241733,4.66357557,5.103650477,2.117280921} /*cfz*/
     },
     {
          2464349.5,
          {-1.133775876,-0.0779148204,183.719331,-0.3258295406,0.002596781471,1.748284458}, /*cmx*/
          {0.8496085048,5.557055515,5.564632002,1.087727904}, /*cfx*/
          {1.85921178,-0.02983837424,-69.19523377,0.08588410726,0.001370175012,-0.6552038479}, /*cmy*/
          {2.77410548,1.101265316,-2.175580404,2.994599502}, /*cfy*/
          {-5.46107737,0.05412922892,174.0111506,-0.3132686878,0.002203117132,-1.654539182}, /*cmz*/
          {2.36905809,0.8382791247,0.8078917518,-0.5299456163} /*cfz*/
     },
     {
          2464404.5,
          {-5.432299956,0.006601022758,184.1173469,-0.01790177904,0.002992433323,1.75360282}, /*cmx*/
          {3.164107467,0.5873861943,1.542024653,4.64603668}, /*cfx*/
          {0.1155047494,-0.02856764504,-68.71430301,-0.08252372754,0.0009564773211,-0.6423156823}, /*cmy*/
          {5.044515616,3.104865997,0.1240842202,0.2159981101}, /*cfy*/
          {-2.159450018,0.08482706187,173.7089515,-0.04034135756,0.0027825859,-1.657654992}, /*cmz*/
          {4.689574572,3.007732233,3.102005596,3.036320597} /*cfz*/
     },
     {
          2464459.5,
          {-4.992214361,0.06972026185,184.6854378,-0.3209142593,0.001154553676,1.734266787}, /*cmx*/
          {5.37947173,-11.87786992,3.404756789,1.832709431}, /*cfx*/
          {-1.499277207,-0.009384372566,-66.85207318,-0.1885367484,-0.0005084986457,-0.6202508401}, /*cmy*/
          {0.9177244818,5.465881963,2.790220383,3.639099124}, /*cfy*/
          {2.68969955,0.04659583723,173.903346,0.2735387348,0.00132152986,-1.638791284}, /*cmz*/
          {0.6317339961,5.373584309,5.093412274,0.2300268065} /*cfz*/
     },
     {
          2464514.5,
          {-0.9114184287,0.07909576946,184.8604832,-0.4413206491,-0.001040218603,1.715404295}, /*cmx*/
          {1.244803614,2.798159996,6.327041266,-1.020862553}, /*cfx*/
          {-2.034128936,0.01604754748,-65.27169171,-0.1335773228,-0.001343175734,-0.5992573942}, /*cmy*/
          {3.044634926,1.232449282,4.924998042,0.8067841956}, /*cfy*/
          {5.286419249,-0.01573040732,174.3863732,0.4187816967,-0.0006790174147,-1.627867983}, /*cmz*/
          {2.784551379,1.23630901,1.434791144,3.657960279} /*cfz*/
     },
     {
          2464569.5,
          {3.608678144,0.0385442313,184.5355971,-0.3381455621,-0.002443095347,1.737693861}, /*cmx*/
          {3.389966249,4.91975433,1.846363006,2.457849781}, /*cfx*/
          {-1.055809262,0.03084875039,-62.38381081,-0.08235633518,-0.0008452663696,-0.5712228268}, /*cmy*/
          {5.251808957,58.45801939,0.8326082908,4.385065819}, /*cfy*/
          {4.327152774,-0.06975752865,175.7189585,0.3415617851,-0.002412014219,-1.670240517}, /*cmz*/
          {4.925799264,3.461002353,3.364987922,0.8480663806} /*cfz*/
     },
     {
          2464624.5,
          {5.807630944,-0.03671282258,183.9225841,-0.05779216009,-0.002732427852,1.768407442}, /*cmx*/
          {5.589127294,0.7972501902,4.022410073,-0.2307572451}, /*cfx*/
          {0.7265243316,0.01707669095,-57.32638305,-0.1515913479,0.000456432109,-0.5329953947}, /*cmy*/
          {1.285898498,3.607738391,3.926808291,1.79935978}, /*cfy*/
          {0.3253965189,-0.08124855599,177.9693636,0.07133448819,-0.002748018559,-1.721529699}, /*cmz*/
          {0.8388045532,6.262329515,5.692085381,4.442861696} /*cfz*/
     },
     {
          2464679.5,
          {3.588325002,-0.0974343295,183.7185174,0.2763977433,-0.0003888304076,1.762333275}, /*cmx*/
          {1.592503256,3.157164967,6.771398642,3.442965431}, /*cfx*/
          {1.681927651,-0.008045856025,-53.46823037,-0.08613120406,0.00096269444,-0.5095383569}, /*cmy*/
          {3.644760438,5.518795448,5.867431734,-0.8026038209}, /*cfy*/
          {-4.508747247,-0.01757767347,179.4467261,0.2764622792,-0.0005789738625,-1.719111379}, /*cmz*/
          {3.126897594,4.671288091,2.575130962,1.836669395} /*cfz*/
     },
     {
          2464734.5,
          {-2.151450441,-0.06394676511,184.0400395,0.2996536787,-0.002951429975,1.732205354}, /*cmx*/
          {3.939824016,5.506119166,5.541467487,0.7914556192}, /*cfx*/
          {1.169253789,-0.02491720998,-53.80653828,0.03429459117,0.0009359933946,-0.5093456783}, /*cmy*/
          {5.946034501,-1059.184742,0.991954313,2.749053774}, /*cfy*/
          {-5.321151366,0.07053365608,179.1386277,0.3008920898,0.00278183297,-1.679651478}, /*cmz*/
          {5.475969798,0.8575900324,10.23046994,-0.8106186618} /*cfz*/
     },
     {
          2464789.5,
          {-5.663763395,0.02319893508,184.5189255,-0.05763843128,-0.002428010512,1.732740488}, /*cmx*/
          {6.24149513,1.720228819,1.451996721,4.308076341}, /*cfx*/
          {-0.2617331784,-0.02131612454,-55.19963516,-0.1148070878,0.0003731428307,-0.5163132572}, /*cmy*/
          {1.869918653,0.4053683228,2.126939947,-0.09991562297}, /*cfy*/
          {-1.131217775,0.08469143025,178.1347433,-0.03268062414,0.002473966868,-1.671455551}, /*cmz*/
          {1.498611214,2.67992571,6.234001117,2.711885086} /*cfz*/
     },
     {
          2464844.5,
          {-4.268994161,0.07591974259,184.7815946,-0.3280441731,-0.0007185086958,1.748989136}, /*cmx*/
          {2.162989752,3.753078166,2.985242467,1.488741598}, /*cfx*/
          {-1.492945565,-0.002096994586,-55.14920105,-0.1232265612,0.001083008689,-0.5164985433}, /*cmy*/
          {4.01264561,2.333260636,9.225869405,3.349136724}, /*cfy*/
          {3.676141041,0.03509115182,177.8180629,0.3064352323,0.0007402785529,-1.68806067}, /*cmz*/
          {3.708390427,8.430875726,1.949739218,-0.1062125419} /*cfz*/
     },
     {
          2464899.5,
          {0.1859220781,0.07313704255,184.7009943,-0.3860291253,0.0009013203374,1.741019991}, /*cmx*/
          {4.31724235,5.870522316,6.289870043,4.959340229}, /*cfx*/
          {-1.581149002,0.02097161596,-52.98076176,0.07364147658,0.001098243048,-0.4824847085}, /*cmy*/
          {6.199770224,0.08692981448,5.216052244,0.6317773385}, /*cfy*/
          {5.608370049,-0.03140232015,178.5790543,0.3873381709,-0.0008760439603,-1.697621175}, /*cmz*/
          {5.862462247,4.35998621,4.417629224,3.360684368} /*cfz*/
     },
     {
          2464954.5,
          {4.314008332,0.0234992823,184.2929169,-0.2941221149,0.002114809224,1.724546319}, /*cmx*/
          {0.1931006883,1.711034279,1.726382931,2.177049202}, /*cfx*/
          {-0.3136202297,0.02216072118,-47.25342025,0.1737096153,-4.458861089e-05,-0.4138217408}, /*cmy*/
          {2.218943106,1.610624256,0.586967591,4.309343188}, /*cfy*/
          {3.782209525,-0.08058916217,180.6791589,0.2891029558,-0.002267262771,-1.707704747}, /*cmz*/
          {1.736963984,0.3110347591,0.2260776306,0.5791017404} /*cfz*/
     },
     {
          2465009.5,
          {5.67368767,-0.05359662995,183.9576464,-0.0429320361,0.002781889133,1.746543835}, /*cmx*/
          {2.400732517,3.916204645,3.947445194,-0.5304483734}, /*cfx*/
          {0.923527122,0.003168211125,-39.84327373,0.167446991,0.001291684643,-0.3544054858}, /*cmy*/
          {4.611704913,3.941760029,25.79595901,1.731546051}, /*cfy*/
          {-0.8997629375,-0.07526991172,182.772755,0.03555340067,-0.002663879076,-1.742076181}, /*cmz*/
          {3.948807533,3.33185275,2.498226003,4.160695305} /*cfz*/
     },
     {
          2465064.5,
          {2.450741645,-0.09895980589,184.0836604,0.2920237618,0.0003208407974,1.777458269}, /*cmx*/
          {4.692681119,6.240021174,7.081233564,3.138797019}, /*cfx*/
          {1.068695608,-0.009409031102,-35.46210654,0.01876130538,0.001051541587,-0.3411063927}, /*cmy*/
          {0.6705136281,7.37253939,3.127483025,5.325873562}, /*cfy*/
          {-5.337930096,0.003374623435,183.5155399,-0.2946969485,0.0004523242544,-1.76626589}, /*cmz*/
          {6.245281817,10.96954417,9.114787441,1.549953495} /*cfz*/
     },
     {
          2465119.5,
          {-3.318122164,-0.04558288973,184.4931443,0.2911078977,-0.003076857242,1.762299238}, /*cmx*/
          {0.7588372852,2.309149544,8.597386326,0.5056340152}, /*cfx*/
          {0.5295840456,-0.01731273156,-36.95959868,-0.1077856137,-0.0003355164435,-0.3657054336}, /*cmy*/
          {2.866252269,8.377592085,0.270280403,2.519846307}, /*cfy*/
          {-4.878317655,0.08305570064,182.7734198,-0.2878901327,0.002998457571,-1.737567058}, /*cmz*/
          {2.311577975,0.8304163461,-43.22652606,5.201079268} /*cfz*/
     },
     {
          2465174.5,
          {-5.799586597,0.04084234379,184.7865222,-0.07726214552,-0.002533625222,1.721664363}, /*cmx*/
          {3.055293474,4.779506374,4.506100799,4.026606801}, /*cfx*/
          {-0.4745229223,-0.01350761055,-40.56599237,-0.107600457,0.0008541196127,-0.3842786222}, /*cmy*/
          {5.012835806,3.943238378,-8.162156271,-0.3269176535}, /*cfy*/
          {-0.04843868108,0.07987729412,181.6224118,0.07190506455,0.002514607236,-1.690383973}, /*cmz*/
          {4.608731045,2.911589624,3.028476185,2.439968356} /*cfz*/
     },
     {
          2465229.5,
          {-3.360101096,0.08146518548,184.9139576,-0.34775219,-0.0004994299632,1.723558259}, /*cmx*/
          {5.252687079,0.5280884898,-0.3520941819,1.178158903}, /*cfx*/
          {-1.273849029,0.006138987906,-41.44973216,-0.04107236073,0.001328521204,-0.3778790761}, /*cmy*/
          {0.9014375921,5.030762665,0.01335441412,3.17395799}, /*cfy*/
          {4.480173592,0.02038207137,181.4095565,0.3476530917,0.000345016873,-1.698792686}, /*cmz*/
          {0.5232593475,5.266127981,4.729811642,-0.4096075034} /*cfz*/
     },
     {
          2465284.5,
          {1.376332382,0.06584502102,184.6349783,-0.376972544,-0.001243819114,1.750820056}, /*cmx*/
          {1.121860494,2.64832802,-0.3747081005,4.644140097}, /*cfx*/
          {-0.8512341401,0.02034297554,-37.67832362,0.1497495536,0.0007359449187,-0.3308249218}, /*cmy*/
          {3.191839317,-16.32782751,2.519755969,0.5885821533}, /*cfy*/
          {5.568558011,-0.04697489151,182.592335,0.3700567266,0.00138023758,-1.746440987}, /*cmz*/
          {2.674614185,1.182183112,-1.901991165,3.056967462} /*cfz*/
     },
     {
          2465339.5,
          {5.062987079,0.006040172556,184.2204542,-0.2425752271,-0.002274390225,1.755351986}, /*cmx*/
          {3.290613726,4.831517413,1.673757075,1.902599937}, /*cfx*/
          {0.3539364611,0.007700427727,-30.24164558,0.2362733093,-0.0008585636174,-0.2592242595}, /*cmy*/
          {5.665177962,4.800178821,4.225330946,4.479100701}, /*cfy*/
          {2.846325675,-0.08539048951,184.336202,0.2111781866,0.002153993686,-1.76729973}, /*cmz*/
          {4.847610764,3.393604939,0.2139432323,0.3220338645} /*cfz*/
     },
     {
          2465394.5,
          {5.446403168,-0.07083340501,184.2124238,0.02250083842,-0.00228911885,1.738898109}, /*cmx*/
          {5.515508916,0.2442190749,4.0048118,-0.773959423}, /*cfx*/
          {0.7145683656,-0.006566968792,-23.39193713,0.1565333608,-0.001834382213,-0.1983907274}, /*cmy*/
          {1.956898437,1.172301719,0.7452286342,2.016161692}, /*cfy*/
          {-2.153405037,-0.06206825981,185.2414822,-0.04083016822,0.002038149116,-1.750672711}, /*cmz*/
          {0.7972077152,5.278835072,2.465770071,3.933057059} /*cfz*/
     },
     {
          2465449.5,
          {1.186752218,-0.09602865715,184.6426739,0.2959112914,0.0003755624131,1.755366233}, /*cmx*/
          {1.534107216,9.363657447,5.528093328,2.868796083}, /*cfx*/
          {0.3368775292,-0.005671394658,-19.23273397,0.09727257924,-0.0009953495833,-0.1767965484}, /*cmy*/
          {4.266906901,-7.067257794,3.563681453,-0.8961193179}, /*cfy*/
          {-5.736528207,0.02616307493,185.3547241,0.2902142803,-0.0004327541728,-1.758692502}, /*cmz*/
          {3.101006198,4.6891008,4.015719399,1.291314351} /*cfz*/
     },
     {
          2465504.5,
          {-4.345211508,-0.02589687895,184.9817362,0.2462107075,0.00287975586,1.769531173}, /*cmx*/
          {3.876596517,5.452231635,14.88376031,0.2101482944}, /*cfx*/
          {0.04535122873,-0.009900725896,-20.84921846,0.1631984482,0.000731881374,-0.2199378274}, /*cmy*/
          {-0.09154261268,2.13577507,5.093136456,2.36117277}, /*cfy*/
          {-3.972540098,0.09164250454,184.9256912,0.2374288609,0.002825059194,-1.76296371}, /*cmz*/
          {5.440964827,0.8275500187,16.49081894,4.91431615} /*cfz*/
     },
     {
          2465559.5,
          {-5.699761207,0.05561075825,185.0749966,-0.09181813687,0.002208933849,1.752165977}, /*cmx*/
          {6.163509777,1.454409394,4.511054404,3.746983563}, /*cfx*/
          {-0.5697624116,-0.004905484583,-25.78580066,0.07813550788,0.001358457405,-0.2539383633}, /*cmy*/
          {1.970136863,4.522540449,1.17803145,-0.4317388932}, /*cfy*/
          {1.293165956,0.06923021859,184.1491801,-0.09754551579,0.002165217242,-1.742208124}, /*cmz*/
          {1.442761552,2.933808873,6.182376991,2.167250565} /*cfz*/
     },
     {
          2465614.5,
          {-2.383121356,0.08386214783,184.8637537,-0.344024065,0.0005003076021,1.718797471}, /*cmx*/
          {2.078295327,3.635206814,-0.3733679315,0.9183331389}, /*cfx*/
          {-0.8512371996,0.01272735357,-26.48191434,-0.08230950906,0.001237934337,-0.2372826228}, /*cmy*/
          {4.250150699,0.07283153404,3.4561083,3.274392535}, /*cfy*/
          {5.223425359,0.0006658978826,184.2173862,-0.34496504,0.0003410021755,-1.718547047}, /*cmz*/
          {3.639537476,5.253083828,0.9739370636,-0.6610190388} /*cfz*/
     },
     {
          2465669.5,
          {2.416214786,0.05582933571,184.4994128,-0.3836361998,0.001484073949,1.724193702}, /*cmx*/
          {4.231328893,5.78293901,-0.3765960357,4.365890941}, /*cfx*/
          {-0.03179096298,0.01250713933,-22.54000936,-0.2248447271,0.0004688043225,-0.2040812726}, /*cmy*/
          {0.5178869642,2.475664283,6.853880102,0.9960846304}, /*cfy*/
          {5.167085351,-0.06258856971,185.1004629,-0.361712208,-0.001584789564,-1.736562601}, /*cmz*/
          {5.795293984,1.123029746,-1.831592519,2.792767154} /*cfz*/
     },
     {
          2465724.5,
          {5.553539753,-0.01224418586,184.4208648,-0.2107091377,0.0025381241,1.76481092}, /*cmx*/
          {0.1183731635,1.708113683,1.673960867,1.620231846}, /*cfx*/
          {0.6651347735,-0.007387201884,-19.96656534,-0.2482280048,0.001451816377,-0.1984646619}, /*cmy*/
          {3.375927071,4.961830118,192.9064677,5.178018861}, /*cfy*/
          {1.547568361,-0.0853390411,185.4915792,-0.1859822573,-0.002355810863,-1.775823721}, /*cmz*/
          {1.690623947,3.217429438,0.11876713,0.05417144624} /*cfz*/
     },
     {
          2465779.5,
          {4.873927512,-0.08360512591,184.8151221,0.09479120143,0.001955766663,1.775955456}, /*cmx*/
          {2.357171728,3.832933844,4.009617474,5.263696321}, /*cfx*/
          {0.1456037005,-0.008923182657,-20.0728163,-0.1331204921,0.001972112844,-0.1754998982}, /*cmy*/
          {6.143128707,1.710043015,0.9251344982,2.862952263}, /*cfy*/
          {-3.454603127,-0.04391996208,185.0814374,0.0905991683,-0.001865564709,-1.779306539}, /*cmz*/
          {3.933875925,5.516675045,2.371288655,3.697061963} /*cfz*/
     },
     {
          2465834.5,
          {-0.1504605213,-0.08615596446,185.1579904,0.3236176126,-0.001034250629,1.755706467}, /*cmx*/
          {4.676079083,6.250282687,6.109271034,2.647785725}, /*cfx*/
          {-0.3064339868,0.0009998224108,-15.30424601,0.1654194022,0.000928780619,-0.1043525176}, /*cmy*/
          {2.248872011,2.624532732,4.222198252,0.0006901978474}, /*cfy*/
          {-5.903644679,0.04936473911,185.2555591,0.3093694926,0.0009900290157,-1.757461908}, /*cmz*/
          {6.250282379,1.516964249,4.452814582,1.076669887} /*cfz*/
     },
     {
          2465889.5,
          {-5.048858733,-0.00446042835,185.2461659,0.181242461,-0.002749795369,1.741749967}, /*cmx*/
          {0.7317858904,2.307944231,2.293962654,-0.04787231751}, /*cfx*/
          {-0.2252213998,-0.002721877478,-9.880300588,0.182742601,-0.001341980269,0.07178271502}, /*cmy*/
          {3.884405986,5.466611295,-1.208954294,7.882661635}, /*cfy*/
          {-2.870660532,0.09619265644,185.4695153,0.1730825596,0.002725522652,-1.742495586}, /*cmz*/
          {2.302488175,3.8746038,0.7176047235,4.661400465} /*cfz*/
     },
     {
          2465944.5,
          {-5.15966981,0.06821223957,185.098225,-0.1353702826,-0.001761657005,1.751725624}, /*cmx*/
          {3.001203973,4.586607131,4.420356025,3.458842295}, /*cfx*/
          {-0.4519752572,0.003958014439,-13.04323923,0.06571566941,-0.00161105881,-0.1404152151}, /*cmy*/
          {5.645691369,2.440626583,1.284654596,6.215239633}, /*cfy*/
          {2.64196793,0.05502705487,185.3377973,-0.1386666249,0.001650331319,-1.754149732}, /*cmz*/
          {4.569917601,6.185559353,2.873051111,1.885225277} /*cfz*/
     },
     {
          2465999.5,
          {-1.129508464,0.08127687024,184.8558486,-0.3243697541,-0.0003360416518,1.748814434}, /*cmx*/
          {5.193258204,0.4583740697,-0.3344118919,0.6518607617}, /*cfx*/
          {-0.1752556883,0.0136894608,-15.5706868,-0.1695617069,-0.0009675401332,-0.1747540732}, /*cmy*/
          {1.89738108,28.30281009,3.875326633,3.978376576}, /*cfy*/
          {5.750854985,-0.01903522537,185.4743324,-0.3113343467,0.0004470110849,-1.755208282}, /*cmz*/
          {0.4798251295,2.065289597,3.836151594,-0.9166798747} /*cfz*/
     },
     {
          2466054.5,
          {3.461092627,0.04003706671,184.6923359,-0.3493043599,-0.001350213596,1.731076613}, /*cmx*/
          {1.07076208,2.622811853,-0.4958056985,4.131158528}, /*cfx*/
          {0.6730358368,-0.001435522082,-20.61474125,-0.2632286491,-0.0008126861231,-0.2408518034}, /*cmy*/
          {4.747841625,5.706060796,1.68831211,1.785655138}, /*cfy*/
          {4.543680864,-0.07413920625,185.2681884,-0.3205854179,0.00119810996,-1.73056612}, /*cmz*/
          {2.646813597,4.137923757,-1.912025839,2.570590399} /*cfz*/
     },
     {
          2466109.5,
          {5.752700384,-0.03246686066,184.9397774,-0.1957902554,-0.002705063166,1.743321551}, /*cmx*/
          {3.250024268,4.839750908,1.665190409,1.377219573}, /*cfx*/
          {0.5140129265,-0.0182806176,-28.85548338,-0.2140404003,-0.001775780994,-0.2992841532}, /*cmy*/
          {1.136426643,2.041296638,4.598775701,-0.5949660835}, /*cfy*/
          {0.2770326409,-0.08077058997,183.8818596,-0.1928847465,0.002472641772,-1.727772555}, /*cmz*/
          {4.831653106,-0.0633475342,-0.01377700375,-0.1823557806} /*cfz*/
     },
     {
          2458849.5,
          {1.174291621,-0.005761104207,236.9361143,-0.712701562,-0.002262244928,0.5550631482}, /*cmx*/
          {-0.5448538188,-5.304939149,-2.015953262,-7.076371133}, /*cfx*/
          {-0.6499417387,0.0001240354782,98.75034416,-0.2693356441,-0.0009329534067,0.2188566399}, /*cmy*/
          {-5.019568568,-3.993963123,-0.5417127115,7.336154308}, /*cfy*/
          {-1.160731049,-0.003263463191,218.3608832,0.6512273963,-0.002049393441,0.517927508}, /*cmz*/
          {-5.304130089,5.739777563,-0.4179102979,-5.552063332} /*cfz*/
     },
     {
          2458949.5,
          {0.5575788251,-0.0102889103,236.5240981,-0.1607810874,-0.002446076253,0.5655601366}, /*cmx*/
          {5.458259796,0.7521503911,3.893006351,4.661921932}, /*cfx*/
          {-0.6470572614,0.000690966813,88.22561545,-0.06179815971,-0.001017553218,0.2130688252}, /*cmy*/
          {1.030916429,1.796775826,4.807403288,0.2254687185}, /*cfy*/
          {-1.552123573,-0.0006752254646,222.637375,0.1459996743,-0.002215461891,0.5338194919}, /*cmz*/
          {0.7033525067,5.550622261,5.575380669,-0.09473867006} /*cfz*/
     },
     {
          2459049.5,
          {-0.5743450244,-0.009083907607,236.5588952,0.3029363766,0.003483599818,0.5617134521}, /*cmx*/
          {5.415038971,0.7086558035,3.851056412,3.921802946}, /*cfx*/
          {-0.5592121463,0.00307737654,91.58160598,0.1369541866,0.001335326509,0.2252243358}, /*cmy*/
          {0.9732388874,1.569175474,5.080413725,-0.5339103877}, /*cfy*/
          {-1.542981697,0.005476497476,221.2954345,-0.2738164957,0.003172222537,0.52169098}, /*cmz*/
          {0.6584749901,5.56013434,5.48192005,5.447962451} /*cfz*/
     },
     {
          2459149.5,
          {-1.398105437,-0.003218682166,236.5395842,-0.5089023378,0.001174574294,0.5563706067}, /*cmx*/
          {5.325733229,0.6311721495,2.973125166,2.951821555}, /*cfx*/
          {-0.2349608296,0.003213457304,95.40361922,0.1965845547,0.0007364484067,0.2127807947}, /*cmy*/
          {0.8690035601,5.262789843,3.775865923,4.800245871}, /*cfy*/
          {-0.9667963917,0.006233074465,219.5711097,0.4665966572,0.00100287955,0.5206495198}, /*cmz*/
          {0.5672335137,5.361694847,4.684233437,4.472622463} /*cfz*/
     },
     {
          2459249.5,
          {-1.709650201,0.0005526235231,236.7869017,-0.6475885032,0.002759773465,0.5581814859}, /*cmx*/
          {5.005481597,0.243680071,0.2984972899,1.945573972}, /*cfx*/
          {0.05914677277,0.00250872281,84.22797855,0.236767247,0.001021216159,0.1832061247}, /*cmy*/
          {0.5956353187,4.41114632,1.378989506,3.858778353}, /*cfy*/
          {-0.4305903411,0.007921203635,224.5088585,0.5962173004,-0.002532480548,0.5356993112}, /*cmz*/
          {0.2529321707,5.026893016,-7.484600325,3.481164329} /*cfz*/
     },
     {
          2459349.5,
          {-1.742323784,0.006890635252,236.5017672,0.03407447446,0.001193409078,0.5606747634}, /*cmx*/
          {4.772766592,-0.03820630391,0.1245497097,1.155500678}, /*cfx*/
          {0.312105363,0.002444022472,73.28960703,-0.0200687173,0.0006426513555,0.1798123295}, /*cmy*/
          {0.41676231,3.658210461,0.7307821527,3.067606599}, /*cfy*/
          {0.3859180249,0.008921583618,228.0127423,-0.03148518901,-0.001071456119,0.5362428746}, /*cmz*/
          {0.02653595599,4.846549474,4.998121197,2.6893628} /*cfz*/
     },
     {
          2459449.5,
          {-0.9764411687,0.00891827019,236.4031995,0.1504221591,-0.003633604867,0.5528660258}, /*cmx*/
          {4.75987753,6.255300481,-0.001000785925,0.3791917597}, /*cfx*/
          {0.5957068368,-6.538547832e-05,80.99680723,-0.1102612917,-0.001416655387,0.1938132544}, /*cmy*/
          {0.3661664472,3.594196713,0.9869052905,2.263846391}, /*cfy*/
          {1.359222305,0.003017478089,225.3022552,-0.1319483167,0.00332035216,0.5261639425}, /*cmz*/
          {6.292237886,4.935364505,4.790369598,1.912418746} /*cfz*/
     },
     {
          2459549.5,
          {-0.03557357319,0.006133312884,236.5939007,-0.6284259312,-0.0007664967862,0.5456542417}, /*cmx*/
          {4.601665944,6.163161144,4.233701348,-0.6301576908}, /*cfx*/
          {0.5624379495,-0.002097246947,81.01614013,-0.217237349,0.0006724456637,0.170582313}, /*cmy*/
          {0.207437134,1.079823955,-10.22412469,1.313613094}, /*cfy*/
          {1.624291132,5.252930494e-05,225.4860679,0.5821530434,-0.0006489353596,0.5251729517}, /*cmz*/
          {6.134075781,4.640049349,5.861536232,0.9048162401} /*cfz*/
     },
     {
          2459649.5,
          {0.5592781915,0.007411512142,236.7507496,-0.5372327297,-0.002997767508,0.55137682}, /*cmx*/
          {4.276394579,5.807140518,8.964369346,4.690304572}, /*cfx*/
          {0.3292937203,-0.002216915953,64.85508962,-0.1997033149,0.001172088308,0.1394053963}, /*cmy*/
          {-0.03579576858,0.2546474048,-6.051500858,0.424206624}, /*cfy*/
          {1.589245085,-0.003937520626,230.7139804,0.5008860732,-0.002786567178,0.542130936}, /*cmz*/
          {5.81877486,4.303075275,4.325267297,-0.04909667751} /*cfz*/
     },
     {
          2459749.5,
          {1.303337881,0.004515791306,236.6782447,0.2001967722,0.0003634277708,0.558833772}, /*cmx*/
          {4.098761694,5.684273974,2.420410005,3.936458969}, /*cfx*/
          {0.1264128145,-0.002910037736,56.74629101,0.1011764659,0.0001161181123,0.1455120681}, /*cmy*/
          {6.125228366,-0.1068173583,-0.8031519354,-0.375976853}, /*cfy*/
          {1.189180391,-0.01096786823,232.5957312,-0.1832311617,0.0003849243393,0.544705407}, /*cmz*/
          {5.646116764,4.215037597,3.86301601,5.486313717} /*cfz*/
     },
     {
          2459849.5,
          {1.741067892,-0.002842653803,236.3991005,-0.05654290414,0.003101778164,0.5437302839}, /*cmx*/
          {4.092390201,6.032252568,2.383145998,3.102903903}, /*cfx*/
          {-0.1834820364,-0.001824469856,67.39551549,0.0774039725,0.001304260776,0.1521047802}, /*cmy*/
          {6.050584489,5.386984028,-3.193340225,5.069203023}, /*cfy*/
          {0.08648118306,-0.008614257109,229.6050428,0.05656368312,0.002864614702,0.5292374229}, /*cmz*/
          {5.633029627,4.136147055,-33.66399256,4.639660305} /*cfz*/
     },
     {
          2459949.5,
          {1.511683936,-0.004510508761,236.7766128,-0.6732079169,-0.001262964911,0.5397964429}, /*cmx*/
          {3.872565228,-0.8647444805,2.712056893,2.078247644}, /*cfx*/
          {-0.3631896403,0.0006039021785,61.49245893,0.2213299705,0.000594692138,0.1181542875}, /*cmy*/
          {5.865141498,3.11507326,0.9027242404,4.181759076}, /*cfy*/
          {-0.7764856765,-0.004659712025,231.5926479,0.6333492187,-0.001181183111,0.5338040984}, /*cmz*/
          {5.417036037,-2.383274413,4.344337697,3.629602182} /*cfz*/
     },
     {
          2460049.5,
          {1.064774785,-0.007745181966,236.8741694,-0.3940016456,-0.002943550074,0.5465698474}, /*cmx*/
          {3.564850907,5.109881827,1.969163386,1.182029513}, /*cfx*/
          {-0.2941196576,0.0005256323509,42.94447138,0.154963414,-0.001307941391,0.09099571709}, /*cmy*/
          {5.725658559,2.441756157,-35.31547821,3.395642687}, /*cfy*/
          {-1.312098969,-0.003440919165,235.4715699,0.3723233821,-0.002766653564,0.5435478147}, /*cmz*/
          {5.120273748,3.583192466,3.591941256,2.740187328} /*cfz*/
     },
     {
          2460149.5,
          {0.1750133876,-0.01085144434,236.9342561,0.3004485087,0.001887419939,0.5398070475}, /*cmx*/
          {3.444561297,5.050897267,1.904667367,0.4580929404}, /*cfx*/
          {-0.2554060025,0.0006724778498,39.90295218,-0.1629237652,0.0005549498733,0.1060858415}, /*cmy*/
          {5.642368178,2.282616594,2.529165313,2.589164892}, /*cfy*/
          {-1.655361887,0.001805179966,235.9269673,-0.2785510133,0.001809571365,0.5377284317}, /*cmz*/
          {5.001777981,3.551880013,3.495012972,2.011566126} /*cfz*/
     },
     {
          2460249.5,
          {-0.8835660269,-0.005994867588,236.5663593,-0.2575589851,0.002232474599,0.5366946418}, /*cmx*/
          {3.418166607,5.071095144,1.56341507,-0.4184074539}, /*cfx*/
          {-0.1683539223,0.002039104697,50.2047223,-0.06318599804,0.001092064291,0.1052328424}, /*cmy*/
          {5.499376334,6.71481695,1.995925996,1.713997142}, /*cfy*/
          {-1.383815998,0.005285182554,233.8370425,0.2494579411,0.002090726043,0.5307634632}, /*cmz*/
          {4.969305363,3.50118276,3.191051516,1.133732326} /*cfz*/
     },
     {
          2460349.5,
          {-1.409833778,-0.002348392317,237.0731208,-0.6653714735,-0.001800414364,0.5360497367}, /*cmx*/
          {3.150880983,4.689270043,1.747906675,4.850627558}, /*cfx*/
          {0.03944697929,0.001084541134,38.33495287,-0.2250346219,-0.0006173011129,0.06948985887}, /*cmy*/
          {5.371249773,5.166935305,2.495485621,1.002299617}, /*cfy*/
          {-0.9095043168,0.007071875786,236.3190986,0.6370681511,-0.00173542876,0.5392888815}, /*cmz*/
          {4.709143395,3.149725382,3.372664888,0.129126886} /*cfz*/
     },
     {
          2460449.5,
          {-1.714496092,0.002155100984,237.1185243,-0.2379696832,-0.002541787086,0.5435754426}, /*cmx*/
          {2.871827555,4.439368451,1.298159073,3.995140341}, /*cfx*/
          {0.1345688899,0.0003179278958,23.16636107,-0.09211520406,-0.001276339961,0.0509558477}, /*cmy*/
          {5.559514559,4.736342105,1.540588794,0.4197464674}, /*cfy*/
          {-0.258668979,0.009845304686,237.8160202,0.2283717932,-0.002412425913,0.5446726893}, /*cmz*/
          {4.438869844,2.878385915,2.884385605,5.562611514} /*cfz*/
     },
     {
          2460549.5,
          {-1.516261809,0.007730414515,237.1381657,0.2974995479,0.003008748358,0.5433836598}, /*cmx*/
          {2.800508098,4.397924105,1.25221892,3.261835278}, /*cfx*/
          {0.1873790139,0.0002856364937,24.80195599,0.1872787477,0.00108483795,0.06454753545}, /*cmy*/
          {5.375355767,4.65650471,1.620524267,-0.6424934111}, /*cfy*/
          {0.8395011919,0.006808683068,237.7121056,-0.2786317161,0.002898068022,0.542034144}, /*cmz*/
          {4.366288236,2.865039367,2.841283376,4.821168771} /*cfz*/
     },
     {
          2460649.5,
          {-0.6638222046,0.006207557637,236.9045852,-0.4358158364,0.001322220459,0.529241093}, /*cmx*/
          {2.727905647,4.331217278,0.574279704,2.315046188}, /*cfx*/
          {0.2117242689,-0.001862338802,30.71383086,-0.09499768498,0.000827849279,0.05794988903}, /*cmy*/
          {5.105044601,5.014310219,0.8422033346,4.979291881}, /*cfy*/
          {1.526747538,0.001825551503,236.9747709,0.4245616303,0.00128411651,0.5306313722}, /*cmz*/
          {4.290387753,2.779396069,2.120426114,3.882398213} /*cfz*/
     },
     {
          2460749.5,
          {-0.02707674504,0.00708076041,237.4374865,-0.6329229972,-0.002273482832,0.535943416}, /*cmx*/
          {2.428080531,3.961689795,0.9140522976,1.314709099}, /*cfx*/
          {0.006592626243,-0.001645039038,19.64704252,-0.2234260174,-0.0008267482747,0.04762446143}, /*cmy*/
          {5.448309981,4.121712082,1.138557165,4.869979071}, /*cfy*/
          {1.656639176,-0.0007643785879,238.2607059,0.6146547883,-0.002208363478,0.5351865445}, /*cmz*/
          {3.998183085,2.383350213,2.494184494,2.887217999} /*cfz*/
     },
     {
          2460849.5,
          {0.6536679937,0.008469976868,237.4141226,-0.071936509,-0.00174523586,0.5438755536}, /*cmx*/
          {2.182397746,3.800823049,0.6449500446,0.5123632376}, /*cfx*/
          {-0.1501622968,0.0001408598612,22.40708078,-0.0141699487,-0.0009916988176,0.0468675637}, /*cmy*/
          {6.055339723,4.239671154,0.7788134811,4.257845847}, /*cfy*/
          {1.56530124,-0.007252718814,237.5458845,0.07058504116,-0.001673443176,0.5446352613}, /*cmz*/
          {3.757564317,2.213615198,2.179496234,2.091486369} /*cfz*/
     },
     {
          2460949.5,
          {1.507966804,0.001631698242,237.2970757,0.1987133866,0.003471276815,0.5396290356}, /*cmx*/
          {2.148072861,3.703062786,0.5600992133,-0.2568645546}, /*cfx*/
          {-0.1327007986,6.088650201e-05,18.97835043,-0.1620061022,0.001370997922,0.04278128141}, /*cmy*/
          {5.628892494,7.023945917,0.7243750188,3.03682913}, /*cfy*/
          {0.8169470866,-0.01044788103,237.9083956,-0.1866538009,0.003362308863,0.5405270018}, /*cmz*/
          {3.720831846,2.109803114,2.120707108,1.316443634} /*cfz*/
     },
     {
          2461049.5,
          {1.703659096,-0.002761519378,237.3525768,-0.5615854058,0.0007200924062,0.536679309}, /*cmx*/
          {2.01643446,3.591330024,-7.18629793,5.037843611}, /*cfx*/
          {-0.1342399796,0.00125385823,18.96113041,0.1481317056,0.0005175214151,0.05294566027}, /*cmy*/
          {5.410113209,0.5854866834,-0.4720786029,2.601511994}, /*cfy*/
          {-0.2011547184,-0.006112079871,237.9708941,0.5501290821,0.000817125258,0.5399515077}, /*cmz*/
          {3.588820159,2.016584665,-5.680779796,0.3310500946} /*cfz*/
     },
     {
          2461149.5,
          {1.472249965,-0.005042495985,237.7971063,-0.5723187424,-0.002682820853,0.5435509035}, /*cmx*/
          {1.702561174,3.233413493,0.1264683053,4.067498794}, /*cfx*/
          {0.01291663507,0.001673628828,29.96240444,0.2078830783,0.00106218542,0.0840356216}, /*cmy*/
          {5.915378568,-0.02306898592,3.178572619,2.136705788}, /*cfy*/
          {-0.8577506145,-0.004910639779,236.8019965,0.5615846814,-0.002622497293,0.5395414843}, /*cmz*/
          {3.280138245,1.611144573,-4.635995639,-0.6332904375} /*cfz*/
     },
     {
          2461249.5,
          {0.9024696799,-0.01045027237,237.7304186,0.1083684535,-0.0004839547285,0.5464611615}, /*cmx*/
          {1.498326873,3.060945635,0.07220946087,3.295153909}, /*cfx*/
          {0.1898083892,0.0001489466179,40.04617927,-0.06884469714,0.000454886533,0.08256114858}, /*cmy*/
          {5.916004683,6.091413502,3.385902468,1.37683701}, /*cfy*/
          {-1.42255489,-0.002989613898,234.9555608,-0.1050274299,-0.0004791383666,0.5434332134}, /*cmz*/
          {3.077268504,1.387019621,1.515774098,4.86628849} /*cfz*/
     },
     {
          2461349.5,
          {-0.2112254998,-0.008809985548,237.4578972,0.04146020919,0.00330331532,0.5402557075}, /*cmx*/
          {1.487652379,2.667266088,6.111971684,2.502336525}, /*cfx*/
          {0.1821725568,0.0005172564369,30.24155276,-0.09437002517,-0.001354412009,0.07052112674}, /*cmy*/
          {5.718621534,6.3104193,-3.355700963,0.4354301743}, /*cfy*/
          {-1.633287789,0.003015913784,236.3570308,-0.04446006775,0.003242192699,0.5372072217}, /*cmz*/
          {3.065112611,0.8047805412,1.343614431,4.079157904} /*cfz*/
     },
     {
          2461449.5,
          {-0.9991006565,-0.004916098393,237.7551262,0.6358179121,-0.0008781338283,0.5367119071}, /*cmx*/
          {1.297311321,-0.2850993642,6.793773155,1.494751676}, /*cfx*/
          {0.2507174327,-9.000067712e-05,34.75596467,-0.1977367761,0.0003313731694,0.1016153024}, /*cmy*/
          {5.623277204,-3.655577939,3.949454178,-0.3690189506}, /*cfy*/
          {-1.312808521,0.00541297753,235.9390047,0.6244267359,-0.0009345267861,0.5275769097}, /*cmz*/
          {2.875633654,-5.043624348,2.107499672,3.071459934} /*cfz*/
     },
     {
          2461549.5,
          {-1.48659944,-0.001993571745,238.0299008,0.4873157894,-0.0030085407,0.5482651045}, /*cmx*/
          {0.9844602127,5.659522764,-0.6164089818,0.5612543232}, /*cfx*/
          {0.2581331138,-0.002026818492,53.57706597,-0.1757406306,-0.001213890406,0.1341903804}, /*cmy*/
          {5.541199559,2.135256292,-7.236110263,5.143771764}, /*cfy*/
          {-0.8581423687,0.008449356973,232.2430279,0.4815217012,0.002970299421,0.5313868678}, /*cmz*/
          {2.563456985,0.8620306981,4.000237663,2.139234545} /*cfz*/
     },
     {
          2461649.5,
          {-1.781585657,0.004246881501,238.0097923,-0.2657480575,0.001107895272,0.557182763}, /*cmx*/
          {0.8282605186,5.568949653,5.547281292,-0.1651071898}, /*cfx*/
          {0.03383936997,-0.002044699809,59.17860159,0.1296742352,0.0003464100645,0.121753422}, /*cmy*/
          {5.433266207,2.178148517,4.659212759,4.41418557}, /*cfy*/
          {0.0288468908,0.01034131453,230.72577,-0.2614537376,-0.001058509592,0.5392083073}, /*cmz*/
          {2.40630607,0.7328648794,3.905257221,1.414226574} /*cfz*/
     },
     {
          2461749.5,
          {-1.28172743,0.006161220225,237.6431805,0.1575532738,0.002724903679,0.5459453294}, /*cmx*/
          {0.818537333,5.677996708,5.327243063,5.247857796}, /*cfx*/
          {-0.1688182913,-0.001968208622,49.04466988,0.02439984677,0.001097367961,0.1221298149}, /*cmy*/
          {5.339367702,-612.0191218,5.034659804,3.509476864}, /*cfy*/
          {1.148357067,0.004189993261,232.9027129,0.1549260488,-0.002715647492,0.5350147066}, /*cmz*/
          {2.39749704,0.9906379886,3.658909833,0.5470777384} /*cfz*/
     },
     {
          2461849.5,
          {-0.6209217146,0.00600972874,238.0998018,0.6828380491,-0.001379392541,0.5508138045}, /*cmx*/
          {0.5727828701,5.258943544,5.65185707,4.222089985}, /*cfx*/
          {-0.3758408953,-0.001918980169,59.24704333,0.2316933144,-0.0005213011806,0.159427254}, /*cmy*/
          {5.170634273,4.724092758,5.328485808,2.584734729}, /*cfy*/
          {1.533798974,0.001370141601,230.8564423,0.6706421113,0.001360443157,0.5262771287}, /*cmz*/
          {2.151013009,-18.38576184,4.018638998,-0.4788801304} /*cfz*/
     },
     {
          2461949.5,
          {-0.04192087531,0.009776936012,238.1178824,0.3802620148,-0.003141306159,0.5573164767}, /*cmx*/
          {0.2674696835,4.948787475,4.947956878,3.333125228}, /*cfx*/
          {-0.5608334529,0.0007036911818,75.60234305,0.1295618443,-0.001205991887,0.1814029342}, /*cmy*/
          {4.957163452,4.269660818,4.371854493,1.751106786}, /*cfy*/
          {1.634197565,-0.002134277316,225.8019741,0.3750290332,0.003107202385,0.5279886445}, /*cmz*/
          {1.840835532,0.1455595148,3.267129291,4.906298489} /*cfz*/
     },
     {
          2462049.5,
          {0.957262161,0.007364963241,238.127616,-0.3480019301,0.002644982931,0.558142937}, /*cmx*/
          {0.1611056723,4.906941552,4.907344192,2.595508181}, /*cfx*/
          {-0.470200266,0.003038780633,76.05483074,-0.1519868876,0.0009372330723,0.1700224289}, /*cmy*/
          {4.860948896,4.492982225,4.193833681,0.9898259077}, /*cfy*/
          {1.409790684,-0.009267209113,225.6484794,-0.3467858985,-0.002580542676,0.5351397039}, /*cmz*/
          {1.7334647,0.05934317738,3.239921305,4.17238309} /*cfz*/
     },
     {
          2462149.5,
          {1.685314931,2.638070349e-05,237.8087727,0.3520632718,0.002010889775,0.5530083202}, /*cmx*/
          {0.1233825387,4.90126062,4.430116033,1.694624499}, /*cfx*/
          {-0.1856612569,0.002621289206,69.24816241,0.1038817193,0.0007739262176,0.1730638353}, /*cmy*/
          {4.782997687,3.988688542,3.79731948,0.07274263072}, /*cfy*/
          {0.497617068,-0.007404918491,227.5845164,0.3420757855,-0.001994042725,0.5264091492}, /*cmz*/
          {1.699037793,6.415463538,2.747838602,3.264690202} /*cfz*/
     },
     {
          2462249.5,
          {1.739947166,-0.002502388834,238.2759911,0.7100221736,-0.001971854002,0.5571083343}, /*cmx*/
          {-0.1707344677,4.501508632,4.708634964,0.6527412184}, /*cfx*/
          {0.08864935196,0.002688479141,81.61396208,0.2544162829,-0.0007764640003,0.2066951639}, /*cmy*/
          {4.54402032,3.662306613,3.998855043,5.384567471}, /*cfy*/
          {-0.2404215911,-0.005246532157,223.8849159,0.6915886134,0.001922092192,0.5185565255}, /*cmz*/
          {1.399813727,-0.3039817339,3.030331911,2.220743146} /*cfz*/
     },
     {
          2462349.5,
          {1.506004274,-0.007469452682,237.9778157,0.2310013235,-0.002872419405,0.5726746241}, /*cmx*/
          {5.822169506,4.242228067,4.242788038,-0.2029412479}, /*cfx*/
          {0.3961226766,0.002354765402,92.49195025,0.07420623313,-0.001023871462,0.2207117928}, /*cmy*/
          {4.302656544,3.219289003,3.40729797,4.562036315}, /*cfy*/
          {-0.833186643,-0.006563289684,219.3690767,0.2237624461,0.002808907509,0.5268598686}, /*cmz*/
          {1.100561762,5.748095513,2.576253626,1.352813961} /*cfz*/
     },
     {
          2462449.5,
          {0.6231475081,-0.01108298428,238.0007103,-0.3296301464,0.003704344153,0.5673402845}, /*cmx*/
          {5.767105536,4.206978171,4.2071176,5.342484621}, /*cfx*/
          {0.6143315226,0.0001810322225,89.8848661,-0.1278401279,0.001351196583,0.2076407828}, /*cmy*/
          {4.241397745,3.590497137,3.330457739,3.803796121}, /*cfy*/
          {-1.514283565,-0.001198640867,220.4615738,-0.3298695937,-0.003606333442,0.5280083339}, /*cmz*/
          {1.047231011,5.652982035,2.541266497,0.6226178412} /*cfz*/
     },
     {
          2462549.5,
          {-0.4414997164,-0.00689231055,237.9124106,0.519400171,0.00132772828,0.5587409787}, /*cmx*/
          {5.67964795,4.134665154,3.339241788,4.35599032}, /*cfx*/
          {0.6152094197,-0.0008302345621,87.86948904,0.1903107151,0.0005375583315,0.2193045507}, /*cmy*/
          {4.137331387,3.13000363,2.220653501,2.830809573}, /*cfy*/
          {-1.54745066,0.002907234578,221.1423998,0.4992587178,-0.001265168898,0.5110177729}, /*cmz*/
          {0.9628752242,5.623805365,1.680718505,-0.3610208391} /*cfz*/
     },
     {
          2462649.5,
          {-1.058106115,-0.004827565483,238.2113632,0.7063340317,0.002644037237,0.5620235439}, /*cmx*/
          {5.351276128,3.727189912,-11.88787192,3.33662815}, /*cfx*/
          {0.5627742822,-0.002792580578,98.45143479,0.2636156825,0.001043804184,0.2404759012}, /*cmy*/
          {3.852065647,2.610463665,-0.3500193318,1.852369992}, /*cfy*/
          {-1.309136377,0.005463258439,217.1920287,0.675287104,0.002530517454,0.5086338369}, /*cmz*/
          {0.6242613901,5.223003913,-22.97729964,4.886432195} /*cfz*/
     },
     {
          2462749.5,
          {-1.610823371,-0.001276349663,237.6836139,0.0270863987,0.001922881366,0.5647266652}, /*cmx*/
          {5.089960085,3.702815956,0.4205414529,2.534514253}, /*cfx*/
          {0.2962576967,-0.004868516391,103.239554,0.005336035473,0.0006224123154,0.242291935}, /*cmy*/
          {3.623674417,-8.021458662,5.592052799,1.068655504}, /*cfy*/
          {-0.8199371492,0.0105187232,214.7775688,0.02647183229,0.0018653574,0.5097575821}, /*cmz*/
          {0.3534645322,5.355436447,1.923173433,4.088591684} /*cfz*/
     },
     {
          2462849.5,
          {-1.741634244,0.004754587653,237.7190382,0.2128066191,-0.004076906685,0.5616123036}, /*cmx*/
          {5.081115707,-5.966677877,0.3302279051,1.77381482}, /*cfx*/
          {-0.2369620189,-0.003393823532,100.5078612,0.06813256332,-0.001516132554,0.2376877055}, /*cmy*/
          {3.599513411,30.8453729,5.497115331,0.2841542806}, /*cfy*/
          {0.3559438525,0.007608822144,215.8596206,0.2121246998,-0.003896881211,0.5117654411}, /*cmz*/
          {0.3495538497,8.079833387,1.823649529,3.326109328} /*cfz*/
     },
     {
          2462949.5,
          {-1.202671946,0.004595555846,237.8633733,-0.6478046641,-0.0009265390632,0.554359474}, /*cmx*/
          {4.931018612,0.215197822,-20.11183239,0.7589944543}, /*cfx*/
          {-0.5808986906,-0.001859218974,101.9607509,0.2585391248,0.0005410683155,0.2459714765}, /*cmy*/
          {3.447452398,-4.107142797,13.05106116,-0.7075221328}, /*cfy*/
          {1.111224607,0.003058284307,215.3358889,-0.6100177228,-0.0007908183435,0.499820774}, /*cmz*/
          {0.1992210419,1.714189125,-12.31666992,2.308959354} /*cfz*/
     },
     {
          2463049.5,
          {-0.731612456,0.007694404747,237.8398896,-0.6614845073,-0.003279701957,0.5621364427}, /*cmx*/
          {4.583738305,-0.186873842,-3.296170898,-0.2367745095}, /*cfx*/
          {-0.7447865264,-0.0004586804915,107.4447613,0.2519377756,0.001270395804,0.2546810522}, /*cmy*/
          {3.137696588,1.577758229,-1.482868329,4.612910362}, /*cfy*/
          {1.377843199,0.002093941462,213.2484028,-0.6178507754,0.003062420721,0.5028759634}, /*cmz*/
          {-0.1601072946,1.350375314,1.370901993,1.296467576} /*cfz*/
     },
     {
          2463149.5,
          {0.0491112754,0.01174117512,237.3613074,0.1948083351,-0.0002660349721,0.5694856896}, /*cmx*/
          {4.365775539,5.927014265,3.177087012,5.278519104}, /*cfx*/
          {-0.7942468977,0.002844964922,107.4237179,-0.07407351617,9.204047116e-06,0.2585084838}, /*cmy*/
          {2.94393363,1.418466582,4.323241559,3.847165861}, /*cfy*/
          {1.604454896,-0.004005077666,213.1789787,0.1810113505,0.0002979264028,0.5153198326}, /*cmz*/
          {5.899377403,1.188699506,1.576320276,0.5311352325} /*cfz*/
     },
     {
          2463249.5,
          {1.225529274,0.004324280373,237.322657,0.02884730291,0.003764458034,0.555235021}, /*cmx*/
          {4.380955555,4.843074608,8.96412342,4.474860085}, /*cfx*/
          {-0.50366732,0.003994164601,107.2140842,-0.01898667549,0.001438814059,0.2519149064}, /*cmy*/
          {2.937252491,-0.7255251747,-23.83865082,3.02887238}, /*cfy*/
          {1.171865372,-0.007255426648,212.7865733,0.02605781795,-0.003523173105,0.494727446}, /*cmz*/
          {5.919803088,0.457625282,7.358569268,-0.2711772053} /*cfz*/
     },
     {
          2463349.5,
          {1.679085894,4.460865518e-05,237.5968252,0.7421701336,-0.00113240642,0.5493334347}, /*cmx*/
          {4.161958324,-16.28251008,3.407503095,3.425352423}, /*cfx*/
          {-0.1149751964,0.002945516916,109.1264012,-0.3031186407,-0.0007080890591,0.2529672889}, /*cmy*/
          {2.727192662,-8.2368441,2.079636871,2.010250908}, /*cfy*/
          {0.4870035748,-0.005110346457,212.3550861,0.6848561284,0.0009406620648,0.4920548466}, /*cmz*/
          {5.697237002,-21.0323766,1.72382907,4.953861065} /*cfz*/
     },
     {
          2463449.5,
          {1.733919803,-0.002514883028,237.2978865,0.5713966182,0.003699938702,0.5574708249}, /*cmx*/
          {3.809428724,2.185630452,11.61620268,2.464914148}, /*cfx*/
          {0.1966799217,0.003238029166,107.8812567,-0.2176240563,0.00140832118,0.249766259}, /*cmy*/
          {2.413576703,3.695150418,3.703916406,1.086512681}, /*cfy*/
          {-0.04088767285,-0.007066530935,213.44721,0.5258054381,0.003407322047,0.503736519}, /*cmz*/
          {5.336363042,3.774565652,0.6375849083,3.992023078} /*cfz*/
     },
     {
          2463549.5,
          {1.430251414,-0.009429656987,237.0963872,-0.3567580586,-0.001687079438,0.557777332}, /*cmx*/
          {3.645386016,2.101152083,5.230612499,1.748019346}, /*cfx*/
          {0.5504135764,0.002681728901,105.8212925,0.1337863001,-0.0006943571156,0.2534143503}, /*cmy*/
          {2.265831077,3.548740608,3.742913529,0.3472728172}, /*cfy*/
          {-0.8358259856,-0.006901564351,214.4815607,-0.3278028867,-0.001527690475,0.5013616533}, /*cmz*/
          {5.170770756,3.699914561,0.4931623005,3.268680391} /*cfz*/
     },
     {
          2463649.5,
          {0.4120177577,-0.008125457488,236.9213055,0.220470738,-0.002974530775,0.5517165969}, /*cmx*/
          {3.649567968,2.214772049,4.948673686,0.8591419935}, /*cfx*/
          {0.7844068009,-0.0005018875813,108.933252,-0.1113379878,-0.001181275608,0.2536749441}, /*cmy*/
          {2.245772606,4.080486968,3.257436671,-0.5321427567}, /*cfy*/
          {-1.459322175,-0.0009581753794,212.3498071,0.1953645438,-0.002723452336,0.4944538103}, /*cmz*/
          {5.177071967,3.697395373,0.2715239864,2.390762266} /*cfz*/
     },
     {
          2463749.5,
          {-0.3150424642,-0.006059863369,237.2298854,0.7848142884,0.001677399644,0.5481600738}, /*cmx*/
          {3.368612622,1.758056112,5.306798495,-0.2057854433}, /*cfx*/
          {0.7304731887,-0.002338866709,107.6527619,-0.3131800309,0.0008803821334,0.2406053753}, /*cmy*/
          {1.984540803,3.302886756,3.880725326,4.714749004}, /*cfy*/
          {-1.53861271,0.001823132715,213.7551393,0.716847282,0.001477755272,0.4981225186}, /*cmz*/
          {4.89316833,3.33907442,0.5427149228,1.312958659} /*cfz*/
     },
     {
          2463849.5,
          {-0.9123128517,-0.00612385722,236.7839993,0.419191223,0.003649162573,0.5515494739}, /*cmx*/
          {3.029986197,1.42472719,4.565182345,5.160172422}, /*cfx*/
          {0.5246119819,-0.003715462284,99.7757944,-0.1594772353,0.001404256856,0.2293834129}, /*cmy*/
          {1.690419539,2.676570604,2.618229927,3.827537}, /*cfy*/
          {-1.437966209,0.006785854271,217.6441122,0.3836671033,0.00333797316,0.5096890898}, /*cmz*/
          {4.553880931,3.057355209,-0.07404254339,0.4010734112} /*cfz*/
     },
     {
          2463949.5,
          {-1.630369512,-0.0004932134482,236.8012451,-0.4075563094,-0.003237098226,0.5516698493}, /*cmx*/
          {2.927686276,1.385972001,4.529973854,4.429226509}, /*cfx*/
          {0.1250309728,-0.004586420343,99.18761566,0.1618460304,-0.001259751218,0.2366284394}, /*cmy*/
          {1.591029607,2.528400683,2.798811237,3.077216855}, /*cfy*/
          {-0.6945987034,0.01012899187,217.949135,-0.3723449942,-0.002956342765,0.5019548887}, /*cmz*/
          {4.451531288,3.042906636,6.131558939,-0.3275206902} /*cfz*/
     },
     {
          2464049.5,
          {-1.623299038,0.002804243509,236.6214971,0.4162707518,-0.002025376811,0.5329993162}, /*cmx*/
          {2.890814176,1.374267061,3.97168804,3.505070825}, /*cfx*/
          {-0.3590602916,-0.002008958293,104.1857361,-0.1793292733,-0.0009095239722,0.229950091}, /*cmy*/
          {1.531778668,3.046071137,1.889731393,2.166839395}, /*cfy*/
          {0.3573937933,0.005521780824,215.1902157,0.377024001,-0.001802334981,0.4890549048}, /*cmz*/
          {4.413427879,2.924090629,5.648824906,5.026274263} /*cfz*/
     },
     {
          2464149.5,
          {-1.303917735,0.004459371331,236.9279003,0.764679328,0.00226320989,0.5359722151}, /*cmx*/
          {2.570485884,0.9515389617,4.281737885,2.453433912}, /*cfx*/
          {-0.5405773708,-0.0005734752823,97.25143137,-0.2875389404,-0.0009568785251,0.2055775899}, /*cmy*/
          {1.244656179,2.232982188,5.746750047,1.173495167}, /*cfy*/
          {0.8866409113,0.004690992237,219.0763125,0.7000059213,0.002053181763,0.500756926}, /*cmz*/
          {4.094930203,2.576055543,5.88769977,3.979637343} /*cfz*/
     },
     {
          2464249.5,
          {-0.8812627157,0.01046208682,236.4904113,0.211565719,0.002932113998,0.5463129714}, /*cmx*/
          {2.26754233,0.7017626719,3.842576861,1.607451609}, /*cfx*/
          {-0.579502161,7.624681668e-06,84.90718968,-0.0809737229,-0.001224868909,0.1977202768}, /*cmy*/
          {0.9973270565,1.713458418,4.718468804,0.330239821}, /*cfy*/
          {1.343738429,0.002603882388,223.9500158,0.1936553215,0.002669786163,0.5182865376}, /*cmz*/
          {3.797632657,2.353057786,5.521613228,3.138567621} /*cfz*/
     },
     {
          2464349.5,
          {0.2217349412,0.009559761386,236.5278913,-0.3313165018,-0.003951508649,0.54030186}, /*cmx*/
          {2.223153209,0.6581370363,3.799698285,0.8754722021}, /*cfx*/
          {-0.5979678146,0.002616301709,88.62320852,0.1538828031,0.00151821849,0.2109904108}, /*cmy*/
          {0.9364382446,1.473655,4.963732758,-0.4244574705}, /*cfy*/
          {1.593079662,-0.004361122789,222.5400351,-0.2997781977,-0.003605326942,0.5053258846}, /*cmz*/
          {3.751156403,2.375201324,5.440797746,2.40575308} /*cfz*/
     },
     {
          2464449.5,
          {1.17137016,0.003126209087,236.508762,0.5540858188,-0.001186783746,0.5320290203}, /*cmx*/
          {2.126615283,0.5715932717,2.811085153,-0.1050555336}, /*cfx*/
          {-0.3330122124,0.002834100686,92.3711099,-0.2089136839,-0.0007891530182,0.1948761989}, /*cmy*/
          {0.8252803419,1.993829518,0.4533680407,4.905550996}, /*cfy*/
          {1.176810895,-0.004830587649,220.8913296,0.5081304537,-0.001028595325,0.5030588476}, /*cmz*/
          {3.652560299,2.172293807,4.515897179,1.419307604} /*cfz*/
     },
     {
          2464549.5,
          {1.525212307,0.001282534827,236.816477,0.6980626225,-0.002754334569,0.5355558836}, /*cmx*/
          {1.790214925,0.1692071783,0.2457357872,5.162040139}, /*cfx*/
          {-0.04174950382,0.002104606658,79.01484585,-0.253684849,0.001017132466,0.1613217563}, /*cmy*/
          {0.5454993393,1.118803114,32.69185804,3.967865589}, /*cfy*/
          {0.7081837897,-0.006048186788,226.4129194,0.6453878485,-0.002536912362,0.5208784248}, /*cmz*/
          {3.323987854,1.812762733,1.893707882,0.417893291} /*cfz*/
     },
     {
          2464649.5,
          {1.678539356,-0.003136523181,236.540113,-0.01110282352,-0.001525701061,0.5371344302}, /*cmx*/
          {1.535500932,-0.4166181298,0.02470797447,4.373695561}, /*cfx*/
          {0.1729813897,0.002741456723,65.58299707,0.001515132181,0.0008222033744,0.1555766712}, /*cmy*/
          {0.3634925077,1.713949407,0.6033208713,3.180449927}, /*cfy*/
          {0.04162158274,-0.009944055262,230.3062099,-0.008704371911,-0.001388487265,0.5195620741}, /*cmz*/
          {3.077345167,1.489384362,1.735433959,-0.3753036705} /*cfz*/
     },
     {
          2464749.5,
          {1.269322963,-0.007640435774,236.4122122,-0.1554664393,0.003813935584,0.5342391759}, /*cmx*/
          {1.526414729,-0.1220871282,6.188633525,3.604838286}, /*cfx*/
          {0.461870733,0.0008627279086,74.29733195,-0.1213901481,-0.001499201608,0.1719887175}, /*cmy*/
          {0.3056049092,-84.502111,0.7918182656,2.37729065}, /*cfy*/
          {-0.9769682038,-0.005867179534,227.5843323,0.136332577,0.0035027176,0.5129610533}, /*cmz*/
          {3.062848368,4.838594924,1.559719932,5.1396792} /*cfz*/
     },
     {
          2464849.5,
          {0.5396152954,-0.006662071808,236.5845191,0.6402761214,-0.0008208214669,0.5301313227}, /*cmx*/
          {1.362954607,6.071595804,-17.64683734,2.594438284}, /*cfx*/
          {0.5220778139,-0.001855074299,73.75923401,-0.2137165201,-0.0007121561468,0.1469472621}, /*cmy*/
          {0.1444981367,0.8859895765,24.24617488,1.445725165}, /*cfy*/
          {-1.498070337,-0.001466820888,227.9013638,-0.5959772058,-0.000733590291,0.5141538504}, /*cmz*/
          {2.899724857,4.551809109,-28.54907098,4.132912612} /*cfz*/
     },
     {
          2464949.5,
          {-0.06783198563,-0.007498699733,236.8879615,0.6035288741,0.003105974684,0.536638839}, /*cmx*/
          {1.026475124,5.694626315,-9.987727894,1.611118557}, /*cfx*/
          {0.3326248153,-0.001972430017,55.47852961,-0.2232184006,0.001216397214,0.1117880174}, /*cmy*/
          {-0.08135157329,0.02918951785,-56.52102674,0.5795506825}, /*cfy*/
          {-1.684745381,0.002317813022,233.1085429,-0.5667873864,0.002903524616,0.5308893371}, /*cmz*/
          {2.57459059,4.181580457,-8.351059479,3.160539888} /*cfz*/
     },
     {
          2465049.5,
          {-0.906717711,-0.006901056601,236.8211014,-0.1934976429,-0.0002240537726,0.5507579711}, /*cmx*/
          {0.8252609697,5.556864241,2.221452267,0.8450925077}, /*cfx*/
          {0.1566130449,-0.001796755404,45.02547133,0.1047790059,0.0001831698645,0.1159587478}, /*cmy*/
          {6.101136893,5.928917022,5.825932224,-0.2463934881}, /*cfy*/
          {-1.4980514,0.00858628502,235.026221,0.1770093206,-0.00026067474,0.541334493}, /*cmz*/
          {2.379672658,4.065062452,3.5524668,2.405637287} /*cfz*/
     },
     {
          2465149.5,
          {-1.609462821,-0.000651187447,236.4685398,0.05933428264,-0.003120939852,0.5344887865}, /*cmx*/
          {0.8215626622,5.901342241,2.250973547,0.01470404438}, /*cfx*/
          {-0.06332256566,-0.001746158425,56.68363764,0.07940950171,0.001331116718,0.1252528576}, /*cmy*/
          {5.990277363,5.309523768,2.846812164,5.201308814}, /*cfy*/
          {-0.5369657346,0.008034729455,232.3930828,-0.06052128357,0.00290414347,0.5270212063}, /*cmz*/
          {2.368778077,4.055459987,7.035149504,1.561511488} /*cfz*/
     },
     {
          2465249.5,
          {-1.62350163,0.001852335515,236.8443907,0.6777462781,0.001073876865,0.5345502414}, /*cmx*/
          {0.5998199907,-0.9880285722,2.794437144,5.260349269}, /*cfx*/
          {-0.2359423046,8.961550843e-05,50.22972169,0.2145778453,0.000576648897,0.09137996755}, /*cmy*/
          {5.820914158,2.85699812,19.71561294,4.370418361}, /*cfy*/
          {0.2726703444,0.00628028692,234.1402996,0.6428995563,-0.00102835732,0.5343915218}, /*cmz*/
          {2.150982051,0.6253498713,1.301664177,0.5376858427} /*cfz*/
     },
     {
          2465349.5,
          {-1.443524612,0.006583603798,237.112706,0.4729657006,0.003223118901,0.5453450055}, /*cmx*/
          {0.278405013,4.956618087,1.818014503,4.338875568}, /*cfx*/
          {-0.2016311322,0.0004145632915,30.88556441,0.1827087547,-0.00142463833,0.06189177385}, /*cmy*/
          {5.797905636,2.159538129,-4.165140287,3.712893472}, /*cfy*/
          {0.8592389684,0.006493893792,237.2381225,0.4513908399,-0.003056690858,0.5471326082}, /*cmz*/
          {1.840723325,0.2661347655,-6.009619047,-0.3784944737} /*cfz*/
     },
     {
          2465449.5,
          {-0.7763184513,0.01177476062,237.1573823,-0.3015449588,-0.001807262159,0.5411508498}, /*cmx*/
          {0.1366977697,4.888458686,1.742587802,3.604542455}, /*cfx*/
          {-0.1815783878,0.0001452384229,26.60206399,-0.171882126,0.0005144771004,0.07547621479}, /*cmy*/
          {5.783934394,2.00923692,2.129178153,2.808634876}, /*cfy*/
          {1.534501194,0.001234709756,237.5934392,-0.2820077226,0.001748279726,0.5447705633}, /*cmz*/
          {1.701582635,0.2099413813,0.1689265414,5.163647693} /*cfz*/
     },
     {
          2465549.5,
          {0.4183725817,0.00682968276,236.7195267,0.2393523797,-0.002284350883,0.5434806467}, /*cmx*/
          {0.1135718786,4.918381325,1.415145709,2.7285793}, /*cfx*/
          {-0.1686390449,0.001839721285,36.5715155,-0.04472354771,0.00110120642,0.07617146852}, /*cmy*/
          {5.507074224,38.03866848,1.746388082,1.921996325}, /*cfy*/
          {1.659827586,-0.003901749739,236.1682671,0.2358466204,0.002157867766,0.5415698009}, /*cmz*/
          {1.672673074,0.2042980053,-0.1265183526,4.285092958} /*cfz*/
     },
     {
          2465649.5,
          {1.121233595,0.003733597536,237.2461042,0.6728618414,0.001550591779,0.542980543}, /*cmx*/
          {-0.1483702054,4.536500119,1.684961751,1.705662699}, /*cfx*/
          {0.03419548304,0.001143690572,26.15337646,0.2213014821,-0.000530529778,0.04933243998}, /*cmy*/
          {5.517807304,-4.571061202,2.361252984,1.530619831}, /*cfy*/
          {1.281974705,-0.005028410931,237.7739298,0.6501929634,-0.001518609373,0.5464553352}, /*cmz*/
          {1.416798872,-0.1649765213,6.444042219,3.271778628} /*cfz*/
     },
     {
          2465749.5,
          {1.531302264,0.002069807023,237.3802227,0.3014306543,0.002904235762,0.5544617896}, /*cmx*/
          {5.841447201,4.256359168,1.11497059,0.8267695458}, /*cfx*/
          {0.1419691296,-0.0001709765827,19.37250419,0.1168012523,-0.001406851134,0.04532369425}, /*cmy*/
          {6.200421401,1.251038399,1.23552827,1.282157825}, /*cfy*/
          {0.7528193323,-0.009320755308,237.9643765,0.2916736115,-0.002788825354,0.5533357149}, /*cmz*/
          {1.131165031,5.808768209,-0.4781394578,2.399888019} /*cfz*/
     },
     {
          2465849.5,
          {1.701501893,-0.004701098476,237.3873494,-0.308890068,-0.002882079996,0.55647373}, /*cmx*/
          {5.758648065,4.218550495,1.073785136,0.09797426618}, /*cfx*/
          {0.1229297458,4.101897547e-05,18.76279956,-0.1900081722,0.001033699638,0.03932590331}, /*cmy*/
          {6.035934204,1.243790625,1.25026745,0.02740579643}, /*cfy*/
          {-0.2668034442,-0.01020352177,238.0300019,-0.2940124004,0.002803082587,0.5556455918}, /*cmz*/
          {1.047883084,5.775484521,5.774806264,1.666593643} /*cfz*/
     },
     {
          2465949.5,
          {1.198416518,-0.006743355625,237.0881924,0.3870853201,-0.00150975394,0.5426990167}, /*cmx*/
          {5.695627472,4.169037236,0.5058260933,5.445740537}, /*cfx*/
          {0.1293666424,-0.00180167278,20.03051778,0.07229386329,0.0008304709974,0.04786680016}, /*cmy*/
          {5.517859642,1.415425612,0.6443478516,5.69131477}, /*cfy*/
          {-1.227594782,-0.00429854419,237.8634869,0.3813789124,0.001475801337,0.5442631514}, /*cmz*/
          {0.9821150102,5.745549255,5.161885853,0.7393104} /*cfz*/
     },
     {
          2466049.5,
          {0.5931177376,-0.00743268709,237.6607236,0.6504045872,0.00211763761,0.5512506881}, /*cmx*/
          {5.407006428,3.799778217,0.7836804015,4.439722567}, /*cfx*/
          {-0.06737983376,-0.001855469821,21.96808079,0.2264575458,-0.0007474206838,0.07003793067}, /*cmy*/
          {6.11529944,0.6498590257,0.8652458768,5.442819596}, /*cfy*/
          {-1.654484587,-0.0003837480115,237.8667092,0.6362061825,-0.002073408984,0.5481575777}, /*cmz*/
          {0.6989073794,5.337607734,5.482457739,-0.2643501938} /*cfz*/
     },
     {
          2466149.5,
          {-0.1593453992,-0.009675133483,237.6362507,0.1084100045,0.002029587391,0.5604229709}, /*cmx*/
          {5.147749088,3.604953067,0.4590036606,3.626743131}, /*cfx*/
          {-0.2634443543,0.0004874393946,35.08114474,0.03028103888,-0.001058207547,0.07713001974}, /*cmy*/
          {6.335252913,0.4987019744,0.4763489974,4.788618208}, /*cfy*/
          {-1.771855894,0.004476120515,235.7862089,0.1063025878,-0.001976194288,0.5584275929}, /*cmz*/
          {0.4429299261,5.130774301,5.095166518,5.209751608} /*cfz*/
     },
     {
          2458849.5,
          {-0.0004849978492,-0.0002369566095,293.2009641,-0.6658013791,-0.00264053899,0.01735039289}, /*cmx*/
          {-4.032922636,3.779693422,-5.597438869,-4.746749454}, /*cfx*/
          {0.0199058045,-1.112137129e-05,117.3828359,0.2784426853,-0.001034940205,-0.004985887053}, /*cmy*/
          {-2.20988926,14.35677043,-4.202711653,-5.669975593}, /*cfy*/
          {0.04392707465,-8.473708686e-05,272.3996661,-0.6003401857,-0.002411165948,-0.01309417714}, /*cmz*/
          {-2.506926105,-7.139756863,-3.984542138,-25.18297912} /*cfz*/
     },
     {
          2458954.5,
          {-0.03332986694,0.0006124523305,292.9746618,0.05489286791,-0.002758052758,0.01234296653}, /*cmx*/
          {5.974799255,0.9411233075,4.517962261,2.731270857}, /*cfx*/
          {0.03241116099,-0.000126345102,103.6750709,0.02658983847,-0.001171989754,-0.005763432778}, /*cmy*/
          {1.540547649,4.383696949,5.44425738,2.048221544}, /*cfy*/
          {0.08128253246,-0.0002686509806,277.322473,0.06650488238,-0.002505296137,-0.01255177549}, /*cmz*/
          {1.225398441,2.41496897,6.197574574,1.341569122} /*cfz*/
     },
     {
          2459059.5,
          {0.01657565704,1.557964407e-05,293.4112086,-0.5480211642,0.004372870136,0.01818677113}, /*cmx*/
          {3.672318743,8.416534551,2.135700555,4.026915677}, /*cfx*/
          {0.01810873001,-1.287080322e-06,110.1318806,-0.2053204759,0.001655899485,-0.006650440519}, /*cmy*/
          {5.486894808,-3.0624313,3.316530737,2.573322939}, /*cfy*/
          {0.04670394302,3.610212121e-05,274.948261,0.5059776344,0.004016289419,-0.01683562515}, /*cmz*/
          {5.205485412,13.20878959,3.771432632,2.425760365} /*cfz*/
     },
     {
          2459164.5,
          {0.03998377026,0.0003557633742,293.4134714,0.4850301491,0.0005637113492,0.02145747777}, /*cmx*/
          {1.289575089,6.004628063,5.018398218,4.679418837}, /*cfx*/
          {0.02350281036,-0.0001425010546,113.8444581,0.1921838837,0.0005889768988,-0.00881398515}, /*cmy*/
          {3.084922518,0.9923096107,-6.852228844,3.368262728}, /*cfy*/
          {0.06311143411,-0.0002006811093,273.1396739,-0.4398133914,0.0004842426481,-0.02425329538}, /*cmz*/
          {2.822480244,4.492294117,0.5801546471,3.258307712} /*cfz*/
     },
     {
          2459269.5,
          {0.02547182969,0.0001724323921,293.4998798,0.4958803818,-0.003757268526,0.01765996397}, /*cmx*/
          {4.972709713,3.366989604,-2.914960949,5.831277082}, /*cfx*/
          {0.003984078151,8.49088457e-05,99.67135153,0.2104219481,0.001462208556,-0.006279935565}, /*cmy*/
          {0.5245625255,4.12936099,1.153424176,4.659207799}, /*cfy*/
          {0.02862295677,0.0002730974617,278.7879635,-0.458800658,0.003474874187,-0.0149301106}, /*cmz*/
          {0.2280503287,1.909254514,1.883788645,4.32559527} /*cfz*/
     },
     {
          2459374.5,
          {0.08053072267,-0.0002184415235,293.4114196,-0.4954755837,0.0006846738393,0.01392594359}, /*cmx*/
          {2.51280727,0.9636093682,0.5976859945,1.266066627}, /*cfx*/
          {0.004929721286,-0.0001119841959,92.54810157,-0.1862394484,-0.0001327101513,-0.01018771709}, /*cmy*/
          {4.380242044,1.976859622,4.714490454,6.123025194}, /*cfy*/
          {0.05154558837,-0.0004433892392,281.3065773,0.4601823388,-0.0007143102801,-0.01714722684}, /*cmz*/
          {4.05316042,5.74079396,5.329120852,5.802450513} /*cfz*/
     },
     {
          2459479.5,
          {0.05306745772,0.0001842156254,293.0330995,-0.1117876988,-0.003546200343,0.01995212902}, /*cmx*/
          {0.2450708921,4.839461599,8.03435325,2.188882777}, /*cfx*/
          {0.0004942646112,-3.215306071e-05,105.9559766,-0.06451266752,0.001439631385,-0.007530241978}, /*cmy*/
          {2.080544573,5.661269399,5.731658539,0.6946526487}, /*cfy*/
          {0.01311842679,1.182985399e-05,276.4072732,0.09663011153,0.003265081726,-0.01744687329}, /*cmz*/
          {1.778757791,3.428283247,6.57539821,0.3539202898} /*cfz*/
     },
     {
          2459584.5,
          {0.07551574707,-0.000302130255,293.1477741,0.629541027,0.00178398062,0.01757477928}, /*cmx*/
          {4.02234161,2.415053164,5.686420759,2.41741117}, /*cfx*/
          {-0.01661895315,1.508485108e-07,98.86282477,0.2465180335,-0.0007024313181,-0.004700146875}, /*cmy*/
          {5.899816021,3.146726256,3.906348929,1.724014306}, /*cfy*/
          {-0.0128447198,-0.0003200091735,279.5978363,-0.5846922425,-0.001642094574,-0.02106589677}, /*cmz*/
          {5.55698854,0.9501121153,4.172398619,0.9119543508} /*cfz*/
     },
     {
          2459689.5,
          {0.05099006936,0.0001938035206,292.6374073,0.1527771875,0.003427895427,0.02224403564}, /*cmx*/
          {1.4457298,6.211870269,3.059154897,3.750905679}, /*cfx*/
          {-0.004671365968,-0.0001653602301,78.41301984,0.1276861948,-0.001458500831,-0.005846843093}, /*cmy*/
          {3.445899168,0.04868553723,0.4910908944,2.776320969}, /*cfy*/
          {0.004894534416,-0.0004129549012,285.9378544,-0.1401600304,-0.0031693889,-0.02129068822}, /*cmz*/
          {2.988004994,4.875113594,1.580738249,2.085743059} /*cfz*/
     },
     {
          2459794.5,
          {0.05503924362,-0.0003089620875,292.7672456,-0.6158504577,-0.003668176874,0.02843976622}, /*cmx*/
          {5.378771917,3.857624857,0.7074650454,5.325455214}, /*cfx*/
          {-0.02194983622,3.634494099e-05,80.82766253,0.2310316952,0.001399995797,-0.009836650945}, /*cmy*/
          {1.103041309,7.871588302,4.625090441,3.829311515}, /*cfy*/
          {-0.07397345399,0.000224135708,285.8101676,0.568853177,0.003401773346,-0.02768520701}, /*cmz*/
          {0.6356070712,2.353528163,5.497644483,3.609759083} /*cfz*/
     },
     {
          2459899.5,
          {0.0366673309,4.039507965e-05,292.2421871,0.3310786028,-0.001344593077,0.03270185256}, /*cmx*/
          {3.044777997,1.503848613,4.283676094,0.01081145952}, /*cfx*/
          {-0.02078692195,1.686564583e-05,88.23704958,-0.1367639139,0.0008527881479,-0.007911805305}, /*cmy*/
          {5.032669769,5.309154282,1.529081241,4.758810182}, /*cfy*/
          {-0.0487857272,-0.0002559795552,283.5034071,-0.3069532183,0.001207654785,-0.02866517402}, /*cmz*/
          {4.579796712,6.327594764,2.790964033,4.608523864} /*cfz*/
     },
     {
          2460004.5,
          {0.01120012251,-0.0001964065289,292.5637,0.5538375004,0.003122319896,0.02177344711}, /*cmx*/
          {0.4642147191,5.144023075,2.007709597,1.08123135}, /*cfx*/
          {-0.01421320106,0.0001003246371,66.27526071,-0.2990282435,-0.001173955662,-0.007527995848}, /*cmy*/
          {2.60480041,2.386828006,5.673221417,6.491137207}, /*cfy*/
          {-0.06964348268,0.0003116176497,289.6639804,-0.5058813324,-0.002917589664,-0.02434648618}, /*cmz*/
          {2.011279491,3.657407306,0.4999821801,5.747910498} /*cfz*/
     },
     {
          2460109.5,
          {0.03994916222,-0.0005906501742,292.639084,-0.2883196218,0.001085007756,0.02422340448}, /*cmx*/
          {4.244411817,2.648786194,6.12558701,2.464738276}, /*cfx*/
          {-0.006631110582,1.255112461e-05,48.55171826,0.03534828124,-0.0006790568113,-0.007228691167}, /*cmy*/
          {0.3068779413,6.607751246,3.27855552,1.370471333}, /*cfy*/
          {-0.05753913839,-0.0002144748135,292.6284292,0.2808524211,-0.001006186042,-0.01779149534}, /*cmz*/
          {5.801595875,1.091235723,4.644715751,0.9112558676} /*cfz*/
     },
     {
          2460214.5,
          {-0.04510424465,0.0001548531031,292.5884193,-0.3130827743,-0.004006690771,0.02689115112}, /*cmx*/
          {1.964543901,0.3953175423,3.541323462,3.513956282}, /*cfx*/
          {-0.004632091125,2.661109541e-05,59.06837497,0.1018566164,0.00166870215,-0.006180390489}, /*cmy*/
          {4.155425733,4.078907328,0.9267804943,2.659421744}, /*cfy*/
          {-0.04949806732,-5.231682113e-06,290.7362515,0.297272936,0.003738461732,-0.02613041446}, /*cmz*/
          {3.515754832,5.149812724,2.022090177,1.952305389} /*cfz*/
     },
     {
          2460319.5,
          {-0.03007720515,-0.0003461715588,292.9907747,0.5589963473,0.0008960671136,0.02549026658}, /*cmx*/
          {5.795743589,4.215297059,1.403185021,4.376839345}, /*cfx*/
          {-0.006936679117,8.05618351e-05,51.97302886,-0.2712508831,-0.0003971360773,-0.002003271092}, /*cmy*/
          {1.751264847,1.54804,5.789843474,4.895049327}, /*cfy*/
          {-0.05663028721,-5.22355254e-05,291.9945295,-0.5194791845,-0.0008625977332,-0.0229778478}, /*cmz*/
          {1.068053862,2.69651827,6.252553202,2.774654903} /*cfz*/
     },
     {
          2460424.5,
          {-0.05351897942,0.0002412224944,293.5205061,0.3137807745,0.003603584404,0.02288116867}, /*cmx*/
          {3.211525323,1.64916641,4.782883797,5.583323947}, /*cfx*/
          {0.005967737746,-4.577425337e-05,28.62489519,-0.2173791279,0.001676457634,-0.002020649961}, /*cmy*/
          {5.930833355,5.105387181,5.025407584,-1.177706581}, /*cfy*/
          {-0.03204525734,7.832573513e-05,294.454895,-0.2941201331,0.003449225426,-0.02430691891}, /*cmz*/
          {4.778857161,0.08133845547,0.07633235394,4.045739192} /*cfz*/
     },
     {
          2460529.5,
          {-0.07646589055,-8.823894304e-05,294.009723,-0.5953962205,-0.002419948165,0.03175923079}, /*cmx*/
          {0.8101370271,5.56709688,2.388216087,0.6353146062}, /*cfx*/
          {-0.001399954564,6.308463387e-05,24.14501879,0.2108020398,-0.0008299119654,-0.003171352334}, /*cmy*/
          {3.624811091,2.644158967,2.61707507,-1.139954671}, /*cfy*/
          {-0.06343438753,0.0007223881936,294.828451,0.572556931,-0.002316562247,-0.02959429705}, /*cmz*/
          {2.379160392,4.008938486,3.96311506,5.560646262} /*cfz*/
     },
     {
          2460634.5,
          {-0.05836899501,-8.471858559e-05,293.6026283,0.1389979842,-0.002264294574,0.02627424417}, /*cmx*/
          {4.796487258,3.339618366,6.221470977,1.722524648}, /*cfx*/
          {0.003473405191,-2.466556547e-05,33.18801181,-0.06650028353,-0.001114992567,-0.00313869363}, /*cmy*/
          {0.8848020732,0.8716212653,0.1088405866,0.3808735362}, /*cfy*/
          {0.01521577766,-9.410112716e-05,293.6156213,-0.131511598,-0.002200242052,-0.02851928178}, /*cmz*/
          {6.360888479,1.820004192,1.504298265,0.1638728727} /*cfz*/
     },
     {
          2460739.5,
          {-0.07549018779,3.150918315e-05,294.2315829,0.5787565697,0.002368802988,0.01991250465}, /*cmx*/
          {2.249902816,0.6469530021,3.826226574,2.796348319}, /*cfx*/
          {0.009695527005,-6.767937679e-05,19.75501069,-0.2809592707,0.0009290398961,-0.002644473481}, /*cmy*/
          {5.181556431,29.12668969,4.113281047,2.742072075}, /*cfy*/
          {-0.001624775275,0.0004551619711,294.880255,-0.5609201686,0.00229962176,-0.0191977266}, /*cmz*/
          {3.819857998,5.351202479,5.407453231,1.292524058} /*cfz*/
     },
     {
          2460844.5,
          {-0.03816786067,-0.0001647377078,294.18051,-0.06381807696,0.0025018255,0.01374911912}, /*cmx*/
          {5.995793775,4.224262775,1.395937601,4.286622687}, /*cfx*/
          {0.001456055104,3.457280468e-05,22.9349493,-0.03013099434,0.001232738279,-0.003446263565}, /*cmy*/
          {3.696365711,2.066302982,1.548754168,3.526108848}, /*cfy*/
          {0.02035563413,-0.0001132648103,294.0387391,0.06708902874,0.002418146891,-0.01944213697}, /*cmz*/
          {1.286240332,2.643281001,2.953723118,2.638429048} /*cfz*/
     },
     {
          2460949.5,
          {-0.06050729836,0.0004540301542,294.2889779,-0.4966560087,-0.00417403239,0.01789724244}, /*cmx*/
          {3.687731962,2.154667108,5.295586582,4.858255568}, /*cfx*/
          {0.004555605669,-5.811096431e-05,17.89793252,-0.2012729351,-0.001737295098,-0.0008561050105}, /*cmy*/
          {0.8333265551,8.626364635,5.423696384,5.537736053}, /*cfy*/
          {0.06989270794,-4.056568215e-05,294.7432136,-0.4831665045,-0.004055756224,-0.01786295021}, /*cmz*/
          {5.259596145,3.717188748,0.5763926438,3.390140468} /*cfz*/
     },
     {
          2461054.5,
          {-0.009614756503,-0.0001412003433,294.1024315,0.4633679184,-0.000404870828,0.01869201297}, /*cmx*/
          {1.293830269,6.006468732,-4.620946632,-0.6200735813}, /*cfx*/
          {0.003533993398,-5.387310159e-05,19.04608138,0.2066445286,-0.0004400674479,-0.003098658452}, /*cmy*/
          {4.566873392,6.073860783,1.931696451,0.7481863156}, /*cfy*/
          {0.0491895109,0.0001330637425,294.6678736,0.4497977711,-0.0005088426432,-0.0210866774}, /*cmz*/
          {2.865163126,1.292629461,9.389018862,4.040790424} /*cfz*/
     },
     {
          2461159.5,
          {-0.03082726834,0.0005406536598,294.3130023,0.4554544458,0.003443847712,0.01847404551}, /*cmx*/
          {4.991215001,3.392173055,0.2506506993,0.6480380575}, /*cfx*/
          {-0.01016712953,-9.836890104e-06,33.87677889,0.2521773888,-0.001426917891,-0.001924889359}, /*cmy*/
          {2.914279973,3.290505623,3.279830387,1.905319969}, /*cfy*/
          {0.08243660549,-0.0001543892968,293.3280399,0.44272069,0.003375389505,-0.01938114637}, /*cmz*/
          {0.2845375504,4.890943681,-4.515110735,5.367856139} /*cfz*/
     },
     {
          2461264.5,
          {-0.02133256821,0.0002469407702,294.3356085,-0.4788739743,-0.0007193861357,0.023655167}, /*cmx*/
          {2.534293837,0.9891801902,3.823120314,2.235555901}, /*cfx*/
          {-0.01001159921,-9.954674792e-06,44.54928612,-0.1407188006,0.0002782352252,0.002277171608}, /*cmy*/
          {0.5948256257,0.8447685068,0.0369394122,3.246383361}, /*cfy*/
          {0.04952070299,0.0003372600146,291.8699444,-0.475497406,-0.0007466227924,-0.02812993462}, /*cmz*/
          {4.112724699,2.515848117,5.352391105,0.4142143017} /*cfz*/
     },
     {
          2461369.5,
          {0.05062496743,-2.309902687e-05,293.8007876,-0.08134715284,-0.003294433727,0.02209283365}, /*cmx*/
          {0.2584994701,4.828507559,1.771069407,2.980768052}, /*cfx*/
          {-0.008025474007,1.228481478e-05,33.66118613,-0.004273875202,-0.001433292402,0.0004765059752}, /*cmy*/
          {4.305198319,-111.0381481,7.972859549,-59.91069827}, /*cfy*/
          {0.06566424007,-0.0002833845248,293.3325491,-0.08406143899,-0.003213817865,-0.01844988344}, /*cmz*/
          {1.835585939,0.0660477635,3.275585691,1.452965339} /*cfz*/
     },
     {
          2461474.5,
          {0.02563983585,0.0001966795841,294.1705644,0.6008321883,0.001579592085,0.01516630353}, /*cmx*/
          {4.034194754,2.438395156,5.717547632,3.586424795}, /*cfx*/
          {-0.007758606576,-6.493189966e-05,47.48495662,-0.3021036284,0.0005970113032,-0.005526658279}, /*cmy*/
          {2.039382493,-32.27033451,5.616976778,4.333588935}, /*cfy*/
          {0.02958527211,0.0001594633882,291.6941233,0.5810613333,0.001527021146,-0.01635411015}, /*cmz*/
          {5.614867092,3.92025809,0.9998220426,1.911020327} /*cfz*/
     },
     {
          2461579.5,
          {0.07624207216,-0.0003450148638,294.2056172,0.1770869518,0.003546480789,0.02007413775}, /*cmx*/
          {1.461053184,-0.05021231144,3.071494825,4.877067591}, /*cfx*/
          {-0.01275502336,9.891286814e-05,72.21184405,-0.1435908739,0.001488926544,-0.00465989691}, /*cmy*/
          {5.973557931,3.047954006,2.736196079,5.954741797}, /*cfy*/
          {0.03582848783,-0.0004771623562,285.9691385,0.1787720764,0.003489660748,-0.01896114475}, /*cmz*/
          {3.044333372,1.304508763,4.534003825,3.214437707} /*cfz*/
     },
     {
          2461684.5,
          {0.0529123756,0.0002395249463,294.5363476,-0.6232498596,-0.003795870205,0.02659998241}, /*cmx*/
          {5.389623022,3.868053857,0.7217566495,-0.2478295023}, /*cfx*/
          {-0.006884222307,3.565654548e-05,71.44760184,0.19898992,-0.001413355839,-0.005089227205}, /*cmy*/
          {3.622535858,0.2945577307,0.4022939315,1.518527259}, /*cfy*/
          {0.02891149409,-0.0003208111161,286.5010903,-0.6115813887,-0.003732600281,-0.02689872016}, /*cmz*/
          {0.6891271083,5.367857823,2.206839716,4.352050341} /*cfz*/
     },
     {
          2461789.5,
          {0.05703437103,-0.0001626563121,294.1206616,0.3328463125,-0.001383903855,0.02961973778}, /*cmx*/
          {3.052912335,1.529148195,4.276050979,0.6464634069}, /*cfx*/
          {0.003873636565,5.696353516e-05,66.33908145,-0.1717820112,-0.0005775799206,-0.007893952322}, /*cmy*/
          {1.244501487,4.541486328,3.755422338,2.566167999}, /*cfy*/
          {-0.03800306004,7.327605095e-05,287.4647996,0.3281831519,-0.001417213752,-0.0237461297}, /*cmz*/
          {4.635916888,2.975282723,5.714084265,5.408340249} /*cfz*/
     },
     {
          2461894.5,
          {0.04182986587,0.000224563881,294.7559671,0.586018475,0.003043410547,0.0221951628}, /*cmx*/
          {0.4719891463,5.148411148,2.02295073,1.996769705}, /*cfx*/
          {-0.0006079815047,0.0001355427834,88.7542462,-0.2524638006,0.001230379692,-0.005500905772}, /*cmy*/
          {5.101373058,1.686080072,1.513004739,3.345814225}, /*cfy*/
          {-0.003189099102,-0.0003231514024,281.3558643,0.5907542228,0.002977597828,-0.02043937213}, /*cmz*/
          {2.051044272,0.2935879714,3.469527864,0.2895661216} /*cfz*/
     },
     {
          2461999.5,
          {0.03828177934,-0.0002126447036,294.6016104,-0.2733943959,0.001398485009,0.02904411908}, /*cmx*/
          {4.238334926,2.632811742,6.072458461,3.230728225}, /*cfx*/
          {0.02206760914,-9.245964753e-05,102.3868805,0.1199066372,0.0005903608343,-0.006204549957}, /*cmy*/
          {2.668327446,4.657186741,5.773070868,5.115405223}, /*cfy*/
          {-0.05389712291,0.0002907029558,276.2398137,-0.2511696918,0.001449774109,-0.02405046199}, /*cmz*/
          {5.809150569,4.124068407,1.229720154,1.775288095} /*cfz*/
     },
     {
          2462104.5,
          {0.04577002207,-0.0003415866636,294.6235607,-0.3335456316,-0.004290460341,0.02342294675}, /*cmx*/
          {1.96354431,0.3902725231,3.531473754,4.350389077}, /*cfx*/
          {0.01584175889,0.0001162770807,91.9116909,0.1206565369,0.001583528395,-0.00716416638}, /*cmy*/
          {0.3743761038,2.76321373,-0.1875839987,-0.3888726515}, /*cfy*/
          {-0.0503726863,-0.0002251514934,279.8963417,-0.32422215,-0.004248577599,-0.02571385367}, /*cmz*/
          {3.536348872,1.86734226,4.994430917,2.809952688} /*cfz*/
     },
     {
          2462209.5,
          {-0.01776631502,5.506913664e-05,294.7572292,0.5895276655,0.0007265985789,0.01885792454}, /*cmx*/
          {5.791848631,4.205653161,1.688383622,4.961812857}, /*cfx*/
          {0.0159285989,-1.273399615e-05,96.97153863,-0.2267372373,-0.0004596508215,-0.007318174522}, /*cmy*/
          {4.235645086,0.5391292514,4.420941308,0.398092392}, /*cfy*/
          {-0.04775914514,8.342605436e-05,278.3757716,0.5937675811,0.000728114001,-0.01362192927}, /*cmz*/
          {1.077923312,5.659104424,3.091525832,3.611133672} /*cfz*/
     },
     {
          2462314.5,
          {0.0156084639,-0.0005662070349,294.52582,0.4221755151,-0.004138243537,0.02260964378}, /*cmx*/
          {3.188385502,1.592927842,1.594952133,-0.009844496123}, /*cfx*/
          {0.02275679266,3.297630733e-05,112.8048407,-0.1414695274,0.001507572376,-0.008111280455}, /*cmy*/
          {1.700963686,3.961876477,29.01104416,1.596809687}, /*cfy*/
          {-0.05194529325,-0.0001670297664,272.4650935,0.4230309502,-0.004074050168,-0.01952136672}, /*cmz*/
          {4.745021282,3.068522373,-3.215511197,4.644464255} /*cfz*/
     },
     {
          2462419.5,
          {-0.05606799073,0.000240671193,294.6929844,-0.6584917117,0.002593282622,0.02919135425}, /*cmx*/
          {0.7677904306,5.521006656,5.47191606,1.066246903}, /*cfx*/
          {0.01240431586,-2.295817412e-05,113.3472519,0.2462691116,-0.001047390514,-0.0114535653}, /*cmy*/
          {5.580890477,1.487872342,1.417759399,3.075305453}, /*cfy*/
          {-0.04328091563,0.0001003472009,272.590186,-0.6391869001,0.002485200858,-0.02816357472}, /*cmz*/
          {2.321547247,0.7150439508,0.6567820637,5.930486484} /*cfz*/
     },
     {
          2462524.5,
          {-0.0661886282,-0.0001012670297,294.4012098,0.1437415616,0.002721370828,0.0233889381}, /*cmx*/
          {4.769288994,3.334345461,3.028279395,2.192445486}, /*cfx*/
          {0.01706101331,-8.879740339e-05,104.9846499,-0.06919513401,-0.001030425654,-0.01011492687}, /*cmy*/
          {3.268421972,5.761169745,5.171908931,3.936274234}, /*cfy*/
          {-0.05729800211,0.0002730091096,275.2137056,0.1382437513,0.002639113786,-0.02691368806}, /*cmz*/
          {6.329859891,4.787216715,4.502578276,0.5682922025} /*cfz*/
     },
     {
          2462629.5,
          {-0.04789604973,6.960292785e-05,294.7436867,0.6946526196,-0.002394832087,0.01779605954}, /*cmx*/
          {2.205366093,0.5888126283,0.6697306801,3.413969704}, /*cfx*/
          {0.00475314993,2.87354098e-05,115.1684107,-0.2715341769,0.0009571523164,-0.007254091065}, /*cmy*/
          {0.7238602384,-3.548678903,2.907351083,5.331838508}, /*cfy*/
          {-0.01384702096,-9.71500178e-05,271.7336061,0.6680753889,-0.002325352366,-0.01653682883}, /*cmz*/
          {3.760292427,2.070807019,2.145222395,2.084782745} /*cfz*/
     },
     {
          2462734.5,
          {-0.06238075826,-0.0001260542902,294.1575623,0.03319298228,-0.003442140954,0.01609599159}, /*cmx*/
          {5.911195071,4.89319021,4.427260102,4.738681768}, /*cfx*/
          {0.01710851622,-0.0002719011992,122.511375,-0.01607070026,0.001188265673,-0.006732241685}, /*cmy*/
          {4.447710556,0.7212933592,0.09267363396,-0.09111262878}, /*cfy*/
          {-0.04315890351,0.0005881072124,268.1837362,0.02981515577,-0.003286268647,-0.0178064356}, /*cmz*/
          {1.176460594,6.398636522,5.946543244,2.995793598} /*cfz*/
     },
     {
          2462839.5,
          {-0.03733273248,-0.0002665563492,294.6201662,-0.5943859297,0.004885074932,0.01850572629}, /*cmx*/
          {3.604988277,8.351250416,2.069452272,5.385152114}, /*cfx*/
          {-0.009599224752,5.482537864e-05,120.0488118,0.1941112028,-0.001814569314,-0.008105959474}, /*cmy*/
          {2.118729799,10.31817672,4.132629987,0.7229463199}, /*cfy*/
          {0.01951391081,-0.0001557562265,269.5066695,-0.5729341913,0.004668807925,-0.01821550108}, /*cmz*/
          {5.159195914,3.585636122,3.562783255,3.763439732} /*cfz*/
     },
     {
          2462944.5,
          {-0.07395515271,0.0001633385648,294.5276272,0.5255425214,0.0008249340522,0.01518800673}, /*cmx*/
          {1.219612049,5.940012899,5.071017149,-0.1901222894}, /*cfx*/
          {-0.02060813763,-4.503883057e-05,121.5022318,-0.2269293016,-0.0004790456921,-0.008979617786}, /*cmy*/
          {5.996111059,1.792881856,-6.012410041,1.401950765}, /*cfy*/
          {0.04360697486,-4.605050284e-06,268.573271,0.4951783954,0.0007185376213,-0.01728496692}, /*cmz*/
          {2.777174191,1.117566339,0.4006437354,4.462888732} /*cfz*/
     },
     {
          2463049.5,
          {-0.04917311095,-0.0001431890529,294.6170144,0.6278832377,0.004046861075,0.02316899835}, /*cmx*/
          {4.880874399,3.259244827,0.1217879069,1.055081178}, /*cfx*/
          {-0.01300075198,-2.325072053e-05,130.7929852,-0.2348851215,-0.001583391349,-0.01047974326}, /*cmy*/
          {3.401000338,5.117826639,1.923784801,2.809333618}, /*cfy*/
          {0.02407204339,-4.621206565e-06,264.6380125,0.591858978,0.003760470344,-0.02074939614}, /*cmz*/
          {0.1463159222,4.781176342,1.65097666,5.875623986} /*cfz*/
     },
     {
          2463154.5,
          {-0.08461596617,0.0008134829612,294.3214231,-0.5094965091,-0.0004288964072,0.03216706116}, /*cmx*/
          {2.384295023,0.8264116116,3.11270778,2.555856472}, /*cfx*/
          {-0.03468649923,-2.655247939e-06,133.1327345,0.2076895166,0.0001903537992,-0.01364774984}, /*cmy*/
          {0.9246963562,2.467867784,5.180732136,3.958446528}, /*cfy*/
          {0.05723292848,0.0001431003872,263.5417343,-0.4707194181,-0.000426363438,-0.03105122625}, /*cmz*/
          {3.926560481,2.385282769,4.654903146,0.6803445039} /*cfz*/
     },
     {
          2463259.5,
          {-0.02554108128,3.133479229e-05,294.1827839,-0.1308423326,-0.004082594717,0.0283087678}, /*cmx*/
          {6.416469456,4.707154348,7.913489202,3.390349722}, /*cfx*/
          {-0.02198823714,-0.0001759883162,134.169554,0.06677927474,-0.00151998042,-0.01151600277}, /*cmy*/
          {4.934907875,-0.4520041593,6.488816652,5.11847204}, /*cfy*/
          {0.04065956662,0.0002987692826,262.5157238,-0.1153531084,-0.003829482828,-0.02287184291}, /*cmz*/
          {1.680897641,6.417271925,9.46367808,1.748672177} /*cfz*/
     },
     {
          2463364.5,
          {0.006379398914,4.607674138e-06,294.3556805,0.7210964785,0.00152116138,0.01958034618}, /*cmx*/
          {3.898032157,2.288945781,5.718555376,4.529195296}, /*cfx*/
          {-0.03635510961,6.722592486e-05,138.617885,0.2655609136,0.0008351102516,-0.0105173069}, /*cmy*/
          {2.440355508,0.9295013859,4.560296244,-0.1530129433}, /*cfy*/
          {0.07073708817,-0.0001114833051,260.8979973,0.6816022236,0.001355564063,-0.01868578681}, /*cmz*/
          {5.437120861,3.823987332,0.8552549017,2.783511776} /*cfz*/
     },
     {
          2463469.5,
          {-0.008680539267,7.037329305e-05,293.4502207,0.3323820408,0.00455075446,0.02501745041}, /*cmx*/
          {1.278453913,5.982740765,2.850704694,5.514838344}, /*cfx*/
          {-0.02755093263,-7.942980839e-05,137.1370101,0.09849477249,0.001701957354,-0.01048443147}, /*cmy*/
          {-0.1223886424,4.066892415,1.186678421,1.005377573}, /*cfy*/
          {0.04718185543,0.0002469862669,262.0610564,0.3217168089,0.00421131218,-0.02028139239}, /*cmz*/
          {2.803584691,1.341438326,4.448707392,3.90826211} /*cfz*/
     },
     {
          2463574.5,
          {0.05511269457,-0.0001271053036,293.619219,-0.7393521503,-0.004230094193,0.03098717328}, /*cmx*/
          {5.18826019,3.666706208,0.513211665,0.2770747267}, /*cfx*/
          {-0.03088669696,0.0002442730461,137.0621069,-0.3075783778,-0.001676074452,-0.01244429163}, /*cmy*/
          {3.803261032,-4.195589769,5.238166699,1.876894143}, /*cfy*/
          {0.0672807687,-0.0005067070468,262.8254596,-0.6716821494,-0.003899106452,-0.02585331603}, /*cmz*/
          {0.4262074946,5.248320814,2.09396067,4.750288485} /*cfz*/
     },
     {
          2463679.5,
          {0.03181198459,0.0002992554623,293.1897416,0.3544704641,-0.001957760721,0.02801138634}, /*cmx*/
          {2.876516122,1.345839311,4.096391466,1.220540148}, /*cfx*/
          {-0.02149968154,7.440628712e-05,139.8436104,0.1298978834,-0.000862372516,-0.01192452939}, /*cmy*/
          {1.483976278,6.185607143,2.110172908,3.083989649}, /*cfy*/
          {0.04813450019,-2.463742514e-05,260.737498,0.3348353558,-0.001719654083,-0.0229523806}, /*cmz*/
          {4.397130152,2.903040161,5.77346656,5.940849385} /*cfz*/
     },
     {
          2463784.5,
          {0.06610537769,-9.328685781e-05,293.0195109,0.726427455,0.003248394041,0.03041106141}, /*cmx*/
          {0.267002476,4.920601481,1.815067009,2.573325405}, /*cfx*/
          {-0.005679552417,3.537601755e-05,133.6988649,0.2717159918,0.00124294497,-0.01395265344}, /*cmy*/
          {5.208785494,3.021693753,6.487445882,4.205097872}, /*cfy*/
          {0.0295816792,-3.365008088e-05,265.1371635,0.6653747054,0.002986297281,-0.02650894862}, /*cmz*/
          {1.781326127,0.2814467572,3.407015748,0.9029679201} /*cfz*/
     },
     {
          2463889.5,
          {0.04473733714,0.0005698098051,292.2234611,-0.1954999021,0.002246486638,0.03986614323}, /*cmx*/
          {3.990141795,2.342818985,5.741825514,3.730299018}, /*cfx*/
          {-0.01505310772,0.0001441074282,121.5184725,-0.07744204472,0.0008638085094,-0.01448617844}, /*cmy*/
          {2.704103381,1.235312608,3.673803126,5.5838528}, /*cfy*/
          {0.04991033496,-0.0002676786374,270.8696418,-0.1835869912,0.002089324436,-0.03227610088}, /*cmz*/
          {5.506835692,3.82777318,1.129469333,2.325808217} /*cfz*/
     },
     {
          2463994.5,
          {0.06694157992,-0.0002589052723,292.5048441,-0.4241336832,-0.004894845748,0.02639362893}, /*cmx*/
          {1.719740147,6.435672695,3.295406137,5.019074111}, /*cfx*/
          {0.01814357611,-8.76983477e-05,126.5659556,-0.1567904745,-0.00191238381,-0.01168947791}, /*cmy*/
          {0.4079086649,4.674562431,1.496751537,0.5125573576}, /*cfy*/
          {-0.01639400047,7.697054964e-05,268.4686222,-0.3880221529,-0.004429281416,-0.02476929519}, /*cmz*/
          {3.235457494,1.764857042,4.914489725,3.356602606} /*cfz*/
     },
     {
          2464099.5,
          {0.07094508143,-9.198959191e-05,292.68839,0.6363817012,0.0006534557554,0.01771972815}, /*cmx*/
          {5.557776038,3.974311158,1.81290241,-0.4066011956}, /*cfx*/
          {0.01031286806,0.0001092128703,124.1666269,0.262703098,-0.0006324905702,-0.008126270359}, /*cmy*/
          {4.246722243,2.10783445,3.380354465,1.741972622}, /*cfy*/
          {-0.001264183787,-0.0002676217082,269.5993282,0.5716347785,0.0005046621593,-0.01718424596}, /*cmz*/
          {0.7927574284,5.607103126,3.330273687,4.378285566} /*cfz*/
     },
     {
          2464204.5,
          {0.04386011376,-8.001060169e-05,292.7973273,0.5237071979,0.00439913487,0.0245033307}, /*cmx*/
          {2.92804378,1.329903542,-8.10004263,0.5654518137}, /*cfx*/
          {0.01895074538,-4.832125412e-05,106.8385243,0.2447105448,0.001708393972,-0.007113144913}, /*cmy*/
          {1.661103401,5.342753835,-3.969670085,2.358017329}, /*cfy*/
          {-0.04273598852,9.447971034e-05,276.8784316,0.4683535858,0.004019841205,-0.02278400074}, /*cmz*/
          {4.456293805,3.011523913,-6.449126054,5.293302174} /*cfz*/
     },
     {
          2464309.5,
          {0.06211404685,-0.0004876184914,293.2331568,-0.6521702985,-0.002160861589,0.02899839827}, /*cmx*/
          {0.4805586495,5.234672213,2.020405005,1.373332712}, /*cfx*/
          {0.02360527875,0.0001390536464,99.34857932,-0.2222949222,-0.0007052621313,-0.007180901819}, /*cmy*/
          {5.501514184,3.175918654,6.340425977,3.341674934}, /*cfy*/
          {-0.04112699082,-0.0004617264031,279.5016184,-0.6044727943,-0.001995724994,-0.02797861552}, /*cmz*/
          {2.014911288,0.580954027,3.61836175,0.08419820997} /*cfz*/
     },
     {
          2464414.5,
          {-0.004706860339,0.0001831541012,292.9557215,0.09019394281,-0.003021473592,0.02057091662}, /*cmx*/
          {4.496045215,3.165256999,5.926462228,2.841814886}, /*cfx*/
          {0.01929874188,-1.182992339e-05,110.3947497,0.0592485618,-0.00122897137,-0.007534883321}, /*cmy*/
          {3.183716086,1.641302334,3.691904712,4.398185491}, /*cfy*/
          {-0.05042337819,0.0001178419345,274.6506296,0.07413228597,-0.002787332433,-0.02205317957}, /*cmz*/
          {6.02684061,4.736835706,1.303533593,1.084587878} /*cfz*/
     },
     {
          2464519.5,
          {0.01904018282,-0.000257598357,293.5391241,-0.6955449317,0.002158002985,0.01683887301}, /*cmx*/
          {1.939632759,-2.81020155,3.581082665,4.04442767}, /*cfx*/
          {0.02550287158,-0.0001286226961,100.0610789,-0.2848470636,0.0008915831502,-0.006843099776}, /*cmy*/
          {0.6411699975,1.274824656,1.724222167,5.767100269}, /*cfy*/
          {-0.07375623808,6.073645317e-05,278.877748,-0.6386065108,0.001971188354,-0.01843010047}, /*cmz*/
          {3.477137249,-1.152404822,5.21608027,2.568128838} /*cfz*/
     },
     {
          2464624.5,
          {-0.01806238712,0.0001273311563,293.263098,-0.1066407176,0.003646492305,0.01870030328}, /*cmx*/
          {5.636131044,1.070075116,0.9912741915,4.98214015}, /*cfx*/
          {0.009796510558,1.10479978e-05,81.24548682,-0.07972582068,0.00160420679,-0.007368215681}, /*cmy*/
          {4.394235334,4.56251397,4.832674479,0.3101580305}, /*cfy*/
          {-0.04180533149,-0.0001115861919,284.3963168,-0.09616019848,0.003362232158,-0.0210476772}, /*cmz*/
          {0.8987056833,2.859108618,2.661293142,3.358877128} /*cfz*/
     },
     {
          2464729.5,
          {-0.02516038707,-0.0004726906449,293.5726039,0.6118684384,-0.00453345044,0.01496597618}, /*cmx*/
          {3.310571697,4.924761408,4.923683198,-0.4195656962}, /*cfx*/
          {0.01689970627,-0.0001327687293,88.55394541,-0.2494726963,-0.001741134689,-0.004393870702}, /*cmy*/
          {2.040898006,-0.5161914947,2.64433813,1.748408168}, /*cfy*/
          {-0.06889081976,0.0003880080366,282.5919468,0.5654709837,-0.004217314028,-0.01508548925}, /*cmz*/
          {4.853543312,0.3037723569,0.2959794262,4.320758544} /*cfz*/
     },
     {
          2464834.5,
          {-0.02692332281,-4.554561649e-05,293.2511391,-0.4504254924,-0.0009168858423,0.009641338428}, /*cmx*/
          {0.9440049373,2.527726625,1.896085649,0.6154771479}, /*cfx*/
          {0.002996402206,9.991793613e-06,94.90132389,0.1639658376,-0.0007488866398,-0.002921502815}, /*cmy*/
          {5.945925466,3.443862427,-0.8556079443,2.695948658}, /*cfy*/
          {-0.02319201395,-0.0001801655137,280.347773,-0.4191427972,-0.0008585444694,-0.01229176956}, /*cmz*/
          {2.483294513,4.185460213,3.611709967,4.867156839} /*cfz*/
     },
     {
          2464939.5,
          {-0.07021864922,6.585784104e-05,293.3910373,-0.5891278753,-0.003544539866,0.01775330264}, /*cmx*/
          {4.623548006,-0.1328670273,3.016413668,1.452710676}, /*cfx*/
          {0.004018941638,-8.059137647e-05,74.83244041,0.2723687566,-0.001348935748,-0.002856558389}, /*cmy*/
          {3.444725182,0.301403778,0.5140543321,3.101306881}, /*cfy*/
          {-0.03860160543,0.0003028881744,286.7501072,-0.5508881412,0.003327306606,-0.02010308368}, /*cmz*/
          {-0.1129807097,1.539427545,-29.89230787,-0.01985522501} /*cfz*/
     },
     {
          2465044.5,
          {-0.04277747991,-0.0002385194028,293.0843054,0.4021521028,-0.0003961094125,0.02590582233}, /*cmx*/
          {2.122746252,3.699983108,1.461932607,2.590287681}, /*cfx*/
          {-0.0002010140275,-1.910421505e-05,60.37038403,-0.1268282192,-0.0002900806648,-0.006969335428}, /*cmy*/
          {1.075807209,4.52930468,4.619930847,3.738366594}, /*cfy*/
          {-0.0006193591797,-1.210762352e-05,290.1009854,0.3827983011,0.0003781995371,-0.02793213154}, /*cmz*/
          {3.67464686,5.307938923,6.459123993,0.8376745875} /*cfz*/
     },
     {
          2465149.5,
          {-0.0797752453,0.0004706584455,292.6439014,0.1882096981,0.003761803556,0.02629465509}, /*cmx*/
          {6.137220564,1.383884342,10.81454708,3.670321058}, /*cfx*/
          {-0.0156792152,1.644886215e-06,75.55548389,-0.07908873154,-0.001607845322,-0.004858549842}, /*cmy*/
          {5.012417932,2.206739695,11.37435677,5.487154544}, /*cfy*/
          {0.01982892795,0.0003134473045,286.663371,0.1709112352,-0.003471166774,-0.02187269271}, /*cmz*/
          {1.397872225,3.010455102,9.328523622,2.114750104} /*cfz*/
     },
     {
          2465254.5,
          {-0.0485679793,-0.0001139257597,292.7374076,-0.6063145373,-0.001110364599,0.01994802101}, /*cmx*/
          {3.650222452,5.200977431,2.356808275,5.187421804}, /*cfx*/
          {-0.004523746221,-5.256758985e-05,66.35057681,-0.276850188,0.0004673737441,-0.006430291079}, /*cmy*/
          {2.615667569,8.756970578,3.659025347,0.7076575633}, /*cfy*/
          {0.002996769732,0.0001388575972,289.3392777,-0.5624902038,0.00106697686,-0.01865184565}, /*cmz*/
          {5.197858872,0.570629023,0.8986978244,3.343654064} /*cfz*/
     },
     {
          2465359.5,
          {-0.04804042434,0.0002860698451,292.7801052,-0.3108437932,-0.003942035655,0.02082755935}, /*cmx*/
          {1.056363409,2.64028508,5.778436179,-0.3862286005}, /*cfx*/
          {-0.0104640767,7.141033522e-05,41.42127473,-0.2281966279,0.001785327047,-0.002556409489}, /*cmy*/
          {0.399575657,-0.3114714439,6.035706988,2.077159366}, /*cfy*/
          {0.05228160765,-5.467562539e-05,293.5839603,-0.281852705,0.003703496423,-0.02117291543}, /*cmz*/
          {2.617519231,4.256981004,4.233947608,4.327994219} /*cfz*/
     },
     {
          2465464.5,
          {-0.01161971913,-9.692333153e-05,293.111644,0.6264049478,0.003214643181,0.02339510884}, /*cmx*/
          {4.952099297,0.2895551452,3.415413254,0.5816576558}, /*cfx*/
          {-0.009441569083,-1.359850123e-05,38.5276345,0.2092643581,-0.001204617665,-0.0009428698342}, /*cmy*/
          {4.369646213,3.850226923,3.806653843,4.344254565}, /*cfy*/
          {0.0193584002,0.0004655603735,294.1991335,0.5967623728,-0.003050363015,-0.02127367841}, /*cmz*/
          {0.2318049959,1.885851233,1.872912784,5.189933296} /*cfz*/
     },
     {
          2465569.5,
          {0.01538400813,7.577433501e-05,292.6350123,-0.2305204155,0.001851881717,0.02253718803}, /*cmx*/
          {2.63758587,4.281026445,0.8558027633,1.633697391}, /*cfx*/
          {-0.005474690919,5.367928366e-05,46.49634765,-0.1226202605,-0.0009785756935,-0.003001683733}, /*cmy*/
          {1.870554043,1.561737247,1.072472151,5.518537779}, /*cfy*/
          {0.0712006078,-0.000369484513,292.7692532,-0.2140802082,-0.001761623235,-0.0195051032}, /*cmz*/
          {4.195898228,5.919317905,5.546356912,0.1838734829} /*cfz*/
     },
     {
          2465674.5,
          {-0.01323284512,0.0002143244853,293.4534489,-0.5988353174,-0.002620289348,0.03067786607}, /*cmx*/
          {0.07378401662,1.618271589,4.788813091,3.031807393}, /*cfx*/
          {-0.001266131918,8.889648924e-05,29.41139693,-0.3225347342,0.001041992866,0.0006917937871}, /*cmy*/
          {6.124953346,4.997642656,5.018956545,0.1777367577}, /*cfy*/
          {0.06773565102,8.670927134e-05,294.8682138,-0.5680574148,0.00249849429,-0.02897373693}, /*cmz*/
          {1.64252628,3.174723286,3.22535327,1.327894206} /*cfz*/
     },
     {
          2465779.5,
          {0.03827458222,7.863754371e-05,293.7468686,0.1489106103,-0.002044210195,0.03255878978}, /*cmx*/
          {3.820578551,5.298250953,2.412035317,4.077925459}, /*cfx*/
          {0.00498322835,-3.871122537e-05,28.61398664,-0.04418547863,0.001125325252,0.003841723689}, /*cmy*/
          {4.504637638,3.712863495,2.585733464,-25.04099714}, /*cfy*/
          {0.0651572453,-0.0002764837762,294.001254,0.1451260967,0.001988617066,-0.03150277489}, /*cmz*/
          {5.396135369,0.5833064603,0.8202316083,2.665925294} /*cfz*/
     },
     {
          2465884.5,
          {0.01416599846,0.0006807720852,293.8548695,0.4037197247,0.003993775132,0.02305430493}, /*cmx*/
          {1.52617882,3.118619496,6.263428357,5.329104621}, /*cfx*/
          {0.003400629189,7.910681275e-06,22.86618261,0.1514281367,-0.001645705231,-0.001511846446}, /*cmy*/
          {1.739013288,6.344494007,0.1647459933,2.288916379}, /*cfy*/
          {0.04822772583,-8.813720771e-05,294.674196,0.3922852957,-0.003873877564,-0.02408215154}, /*cmz*/
          {3.098157619,4.682748502,4.681780281,3.803647593} /*cfz*/
     },
     {
          2465989.5,
          {0.06379636902,-0.0002399891305,294.0186463,-0.4841470039,-0.0003742591649,0.02121980306}, /*cmx*/
          {5.389539297,0.6803185701,17.82380456,0.2277596098}, /*cfx*/
          {0.007824457842,-2.349443483e-05,21.32507803,-0.2216805699,-0.0003732144539,-0.003219972845}, /*cmy*/
          {5.691154459,4.05750256,-3.648515574,3.469261118}, /*cfy*/
          {0.007540886726,6.334230675e-05,294.6282903,-0.4709427457,-0.0004793398279,-0.02148603471}, /*cmz*/
          {0.6787079398,2.236043405,57.14498323,5.111723248} /*cfz*/
     },
     {
          2466094.5,
          {0.07665776346,8.112801179e-05,294.4577855,-0.4388474797,0.003738993094,0.02323803108}, /*cmx*/
          {2.803541338,4.352779399,-20.78232907,1.134439128}, /*cfx*/
          {0.004553499648,4.194242484e-06,35.21716772,-0.2289693783,0.001622435219,-0.003998057071}, /*cmy*/
          {3.987927529,1.265667416,-5.118058614,5.710050862}, /*cfy*/
          {0.03365269295,-0.0002622978832,292.9728928,-0.4359987015,0.003701985304,-0.02181356113}, /*cmz*/
          {4.379482783,5.850703501,-0.4216300734,-0.4930437611} /*cfz*/
     },
     {
          2458849.5,
          {0.9449444938,0.000528084342,375.6302633,-1.064384466,-0.003099395541,0.407276891}, /*cmx*/
          {-0.6374618632,-17.96123314,-2.088578033,-0.6273443501}, /*cfx*/
          {-0.4314158796,0.0005548511293,156.7596294,-0.4038723826,-0.001281008368,0.1606684355}, /*cmy*/
          {-5.111623819,-10.40169371,-0.6723675135,-5.048660646}, /*cfy*/
          {-0.7232618271,0.0005360420917,346.1074755,-0.973260953,-0.002818400838,0.3780512471}, /*cmz*/
          {-5.396907318,-3.767646079,-0.4753123116,-5.381261771} /*cfz*/
     },
     {
          2458949.5,
          {0.9744915696,-0.001624189181,374.9881934,-0.2925872475,-0.004246914818,0.4108119567}, /*cmx*/
          {2.565117897,4.143140285,1.000652807,5.928227981}, /*cfx*/
          {-0.3746612822,-0.0006867200701,140.0128715,-0.1081246746,-0.00169131014,0.1548995778}, /*cmy*/
          {4.422001132,5.278960554,1.982450123,1.527266456}, /*cfy*/
          {-0.6872486411,-0.001811706819,352.9888074,-0.2663024282,-0.003854253489,0.3850700328}, /*cmz*/
          {4.093142705,5.778859944,2.665841279,1.183176525} /*cfz*/
     },
     {
          2459049.5,
          {0.7943903694,-0.002418794874,375.1439723,0.5557698153,0.005074082444,0.4251351041}, /*cmx*/
          {5.999967734,1.308864403,4.451495773,0.05724691951}, /*cfx*/
          {-0.4467888393,-0.0005333144988,145.3037387,0.2342103068,0.001960071778,0.1685903551}, /*cmy*/
          {1.559063448,2.270099891,5.624055799,1.870608917}, /*cfy*/
          {-0.8651061659,-0.001508232518,350.916505,0.5048411855,0.004628458321,0.3922551957}, /*cmz*/
          {1.243161148,2.990801566,6.090100154,1.581388703} /*cfz*/
     },
     {
          2459149.5,
          {0.5998297491,0.000168154636,374.9489928,-0.6489361519,0.00211785445,0.4275606227}, /*cmx*/
          {3.136956856,4.738697715,1.020413427,0.2713499842}, /*cfx*/
          {-0.5068717198,0.0007750585021,151.3243949,-0.2514353402,0.001065350006,0.160661392}, /*cmy*/
          {4.964400499,6.139520682,1.798035617,2.101061503}, /*cfy*/
          {-1.025600459,0.0004660556529,348.1136175,-0.5931785981,0.001879662221,0.3948344568}, /*cmz*/
          {4.661430956,0.05662285859,2.724945847,1.794952434} /*cfz*/
     },
     {
          2459249.5,
          {0.6324131427,0.0003369811772,375.3834084,-0.9867907234,-0.004037480205,0.4113418063}, /*cmx*/
          {0.04095669946,1.564816215,4.766063737,0.4294197862}, /*cfx*/
          {-0.4352657876,0.0006130422228,133.578108,-0.3676491938,-0.001544148997,0.1387135967}, /*cmy*/
          {1.91559503,2.561349645,5.785981041,2.361943094}, /*cfy*/
          {-1.011760154,0.000134655619,355.9649652,-0.9082927221,-0.003703725879,0.3956241842}, /*cmz*/
          {1.57151766,3.210156783,6.415379493,1.962217748} /*cfz*/
     },
     {
          2459349.5,
          {0.6230985403,-0.002322058927,374.9850912,0.03218814226,-0.002431483098,0.4027096377}, /*cmx*/
          {3.288138815,4.675665026,1.776940595,0.7871450776}, /*cfx*/
          {-0.3686677129,-0.0005851732505,116.1653713,0.03666037637,-0.001059451253,0.1376565377}, /*cmy*/
          {5.216712301,4.984006548,2.569991195,2.722279849}, /*cfy*/
          {-0.9934632434,-0.001345501918,361.4853264,0.02877148564,-0.002211002124,0.393533285}, /*cmz*/
          {4.824954613,0.1552322421,3.478580716,2.312809506} /*cfz*/
     },
     {
          2459449.5,
          {0.3566751977,-0.001837368325,374.8839297,-0.3586848019,0.005516374369,0.4165709342}, /*cmx*/
          {0.478794454,11.45470491,5.174330627,1.165847377}, /*cfx*/
          {-0.4347413028,9.982329072e-05,128.448218,-0.1816292528,0.002171223991,0.1452757954}, /*cmy*/
          {2.369281735,5.851362436,6.128665207,3.045297779}, /*cfy*/
          {-1.110477093,-0.0004767666485,357.3433736,-0.3237233605,0.005048838649,0.3974092138}, /*cmz*/
          {2.010993913,6.89713992,0.5503802427,2.695389955} /*cfz*/
     },
     {
          2459549.5,
          {0.2281072828,0.0006038259669,375.0202848,0.8484604475,0.001000689629,0.427551944}, /*cmx*/
          {3.836456134,2.265736171,-11.72482757,1.331730882}, /*cfx*/
          {-0.4379776605,0.0010051712,128.435031,0.3074311782,0.0008397422585,0.1285251906}, /*cmy*/
          {5.727019687,3.353629296,-35.99711218,3.264725882}, /*cfy*/
          {-1.193915785,0.0002823589011,357.5016801,0.7811182048,0.0008854037992,0.4113140139}, /*cmz*/
          {5.368641359,3.897922289,-35.15380759,2.883802456} /*cfz*/
     },
     {
          2459649.5,
          {0.3000991789,-0.0001046462421,375.3969206,0.8389690415,-0.004593250143,0.4225621505}, /*cmx*/
          {0.7303458642,5.401068455,-0.8672850855,1.549584037}, /*cfx*/
          {-0.3322898793,0.0004416216436,102.7419832,0.3169212725,0.001853815132,0.1089508517}, /*cmy*/
          {2.703459908,-0.1610382036,2.944372878,3.561843949}, /*cfy*/
          {-1.194803013,-0.0002484630371,365.8607941,0.781223316,-0.004257381055,0.4133511839}, /*cmz*/
          {2.272695545,0.7587339203,0.7841624416,3.092125302} /*cfz*/
     },
     {
          2459749.5,
          {0.238361619,-0.003016386033,375.2497765,-0.3166560358,0.0001237850884,0.4224596944}, /*cmx*/
          {4.030038142,2.468406935,0.6717799382,1.964808358}, /*cfx*/
          {-0.2846437853,-0.0004376165869,89.76926925,-0.1622124898,0.0001531337498,0.1162244565}, /*cmy*/
          {6.059015347,2.942596566,0.413848217,3.944335138}, /*cfy*/
          {-1.202993941,-0.0005777225082,368.8362727,-0.2879005543,0.0001796153258,0.4061125449}, /*cmz*/
          {5.577526188,4.141713808,8.690217731,3.489204838} /*cfz*/
     },
     {
          2459849.5,
          {-0.07386491952,-0.001345837242,374.8668694,-0.06780071368,-0.004922844748,0.4300779551}, /*cmx*/
          {1.234409359,5.590889994,40.41924373,2.29217798}, /*cfx*/
          {-0.3352442129,0.000503856754,106.6491509,-0.09996730218,-0.002038832967,0.1195763536}, /*cmy*/
          {3.193569146,-0.2501522684,9.701424498,4.272991934}, /*cfy*/
          {-1.224474379,-0.0002130586023,364.1761181,-0.05426868215,-0.004570574518,0.4142552009}, /*cmz*/
          {2.775008888,1.2408373,16.93988174,3.828948217} /*cfz*/
     },
     {
          2459949.5,
          {-0.1635456873,0.0006367169111,375.37277,-0.9510729484,0.001437956932,0.4357148956}, /*cmx*/
          {4.530377335,-0.2007727347,6.640844252,2.418144805}, /*cfx*/
          {-0.2930048063,0.001099941549,97.26179112,0.3408748844,0.0007658769997,0.09236239405}, /*cmy*/
          {0.2405354202,3.697336912,1.48920734,4.509665458}, /*cfy*/
          {-1.284335283,0.000125442175,367.1770375,0.8894569143,0.001352401567,0.4345641476}, /*cmz*/
          {6.074861196,4.575447445,2.045972498,3.970477694} /*cfz*/
     },
     {
          2460049.5,
          {-0.09868056899,-0.001140153215,375.6262179,-0.6420413621,-0.00471247194,0.4390236223}, /*cmx*/
          {1.432835553,2.974726278,6.116983415,2.654214405}, /*cfx*/
          {-0.1730920741,0.0002691700201,67.86291999,0.2449607354,0.002072646481,0.07377797635}, /*cmy*/
          {3.593601702,0.3225942282,15.96275731,4.852741528}, /*cfy*/
          {-1.317945173,0.0001920724728,373.3893818,0.6085131487,-0.004438259957,0.4383245403}, /*cmz*/
          {2.988415886,1.448130411,-4.824558814,4.21450372} /*cfz*/
     },
     {
          2460149.5,
          {-0.2557351271,-0.003201410814,375.6260284,0.4974189791,0.002367874555,0.4377048072}, /*cmx*/
          {4.787402254,0.1035584734,3.223515328,3.079709693}, /*cfx*/
          {-0.1459627031,-0.0002023733351,63.08419365,-0.2587552943,-0.0008878372302,0.08998489681}, /*cmy*/
          {0.7017159067,3.630497644,0.5423813025,5.217687063}, /*cfy*/
          {-1.267535475,0.0005904361225,374.1413787,-0.4622015544,0.002248341688,0.4305488223}, /*cmz*/
          {0.06157463094,4.89525629,4.847764818,4.647597367} /*cfz*/
     },
     {
          2460249.5,
          {-0.5550060649,-0.0006760346914,375.1391104,-0.2497197766,0.003734208638,0.4344926373}, /*cmx*/
          {1.97775799,3.663617005,0.2152677466,3.360591698}, /*cfx*/
          {-0.1639733747,0.0007376052735,79.43961532,-0.06662550703,-0.001689422078,0.08781987002}, /*cmy*/
          {4.05810278,5.113484491,3.774139355,5.531943476}, /*cfy*/
          {-1.160735594,0.0001611059004,370.7428255,0.2410525903,0.003511926832,0.4304154792}, /*cmz*/
          {3.529041909,2.122568376,1.829589411,4.925000689} /*cfz*/
     },
     {
          2460349.5,
          {-0.587610546,0.0004164754852,375.8882369,-0.9737480292,-0.002356813383,0.4359924242}, /*cmx*/
          {5.2236109,0.4820023973,3.849237132,3.480646407}, /*cfx*/
          {-0.09428173585,0.0009459424958,60.67496405,-0.3601373589,0.0009581083097,0.05204681936}, /*cmy*/
          {1.159955996,-5.360420571,1.324858282,5.960626003}, /*cfy*/
          {-1.199293156,0.0004699305102,374.653074,0.9275478173,-0.002251804757,0.436308979}, /*cmz*/
          {0.4986350246,5.231116042,5.497619956,5.036867051} /*cfz*/
     },
     {
          2460449.5,
          {-0.5567994811,-0.00148871503,375.9749302,-0.406938278,-0.004321416296,0.4328663917}, /*cmx*/
          {2.147992851,3.714291942,0.5734893463,3.756363412}, /*cfx*/
          {0.009008286211,-4.615500902e-05,36.62272679,-0.1434255768,0.001999122202,0.03997244299}, /*cmy*/
          {4.836288072,4.028278942,3.96464707,0.2069828854}, /*cfy*/
          {-1.200156795,0.001079151238,377.0968009,0.3921828136,-0.004120962994,0.4339831219}, /*cmz*/
          {3.7150768,2.149137657,2.154983496,5.316655119} /*cfz*/
     },
     {
          2460549.5,
          {-0.7507514072,-0.002020831529,376.0391866,0.5370413974,0.004234466798,0.4245320592}, /*cmx*/
          {5.554733241,0.8762177004,4.016055882,4.193077287}, /*cfx*/
          {0.002944435247,-3.391895201e-07,39.18584047,0.2926194559,-0.001755042578,0.05790787501}, /*cmy*/
          {1.846415053,1.151041435,1.193422641,0.2848659913}, /*cfy*/
          {-1.035213149,0.001497582178,376.9619444,-0.5067435046,0.004054814117,0.4288821837}, /*cmz*/
          {0.8373966881,5.622214666,5.610210972,5.754130247} /*cfz*/
     },
     {
          2460649.5,
          {-0.9022688988,-0.0002353976764,375.6120174,-0.5201513684,0.002391180878,0.4186790254}, /*cmx*/
          {2.707892564,4.325390576,0.7517489388,4.445034483}, /*cfx*/
          {0.004956512146,0.0006035502594,48.54943761,-0.1542128034,-0.001218630102,0.05008906175}, /*cmy*/
          {5.085058407,4.853333177,4.040932864,0.6991925391}, /*cfy*/
          {-0.8746718647,0.0002429637309,375.7288697,0.5039784353,0.002310979759,0.4244665654}, /*cmz*/
          {4.270503801,2.782447454,2.299108203,6.007315248} /*cfz*/
     },
     {
          2460749.5,
          {-0.8889816613,0.0003167595294,376.4674286,-0.94348627,-0.003205333316,0.4165905596}, /*cmx*/
          {5.91956517,1.172409012,4.413497331,4.573071403}, /*cfx*/
          {0.06719507742,0.000501954132,30.9921406,-0.3595461937,0.001350847036,0.03726683539}, /*cmy*/
          {2.65813206,1.333204114,1.480268806,1.93913151}, /*cfy*/
          {-0.9103604131,0.0004474934495,377.7817554,0.9138744489,-0.003093651444,0.4149231788}, /*cmz*/
          {1.206452641,5.874942432,5.989493889,-0.133757671} /*cfz*/
     },
     {
          2460849.5,
          {-0.9030023918,-0.001108933902,376.4454439,-0.1365120653,-0.003243920671,0.4132832356}, /*cmx*/
          {2.874450167,4.490161543,1.336714066,4.880399529}, /*cfx*/
          {0.1207214029,-0.0002636119172,35.39302814,-0.01865398407,0.001512565595,0.04042066729}, /*cmy*/
          {6.751572306,4.984231522,4.606400328,2.492866056}, /*cfy*/
          {-0.8899322723,0.001827857514,376.5805229,0.1327540936,-0.003113775052,0.4087872615}, /*cmz*/
          {4.449487459,2.928879712,2.8866428,0.1821897716} /*cfz*/
     },
     {
          2460949.5,
          {-1.046627135,-0.001108774749,376.3345245,0.4270203109,0.005183518333,0.4133627109}, /*cmx*/
          {6.324868112,1.62501547,4.763499183,5.316356026}, /*cfx*/
          {0.08798659611,7.918314613e-05,29.84563403,0.2487686105,-0.002203513533,0.03171384676}, /*cmy*/
          {3.52399465,70.90404319,1.772980677,2.276019758}, /*cfy*/
          {-0.6494502264,0.001565569626,377.2699074,-0.4069941351,0.0050000906,0.4134945602}, /*cmz*/
          {1.614497157,0.03670533169,0.03877908669,0.6040728628} /*cfz*/
     },
     {
          2461049.5,
          {-1.094959116,-0.0002355734559,376.2424005,-0.7298811309,0.0012632157,0.4138726527}, /*cmx*/
          {3.425516942,5.013509805,1.002578559,5.544121726}, /*cfx*/
          {0.09355616772,0.0003021451805,29.90705118,-0.2485616229,-0.0007527637521,0.03499131822}, /*cmy*/
          {0.5342948042,5.151442542,4.066926117,3.036862775}, /*cfy*/
          {-0.516190314,-6.909173411e-05,377.3116011,0.7112846352,0.001335733198,0.4124103134}, /*cmz*/
          {4.997874958,3.431358403,2.487274307,0.8243293682} /*cfz*/
     },
     {
          2461149.5,
          {-1.099210843,0.0001377295084,377.024852,-0.879756145,0.004002506475,0.4063273272}, /*cmx*/
          {0.3343368392,1.866919942,1.904209821,5.683237368}, /*cfx*/
          {0.1343430161,6.315993926e-05,47.357492,-0.3311262622,-0.001715300963,0.06633343509}, /*cmy*/
          {4.547992322,1.76349298,-1.309283483,3.731341464}, /*cfy*/
          {-0.5764485796,0.0006553664097,375.5007584,0.8628057854,0.003906386335,0.4040851702}, /*cmz*/
          {1.911829045,0.2398744302,-2.868688866,0.9833402847} /*cfz*/
     },
     {
          2461249.5,
          {-1.141460976,-0.0006548526744,376.9517533,0.156404776,0.00135591051,0.3983975674}, /*cmx*/
          {3.608997072,5.164752201,5.288038784,6.016791481}, /*cfx*/
          {0.1387225174,-0.000357351279,63.38845719,0.1121617821,-0.0006385353111,0.06864291746}, /*cmy*/
          {1.744628156,5.086878225,2.265489352,4.045870913}, /*cfy*/
          {-0.5108407475,0.002660862272,372.4399186,-0.1524698742,0.00134931706,0.4022308341}, /*cmz*/
          {5.187870274,3.440192267,0.5519915389,1.322045156} /*cfz*/
     },
     {
          2461349.5,
          {-1.209651127,-0.0004688817442,376.5777393,0.197166108,-0.005147385239,0.4063502236}, /*cmx*/
          {0.8047479816,2.299483598,2.330111448,0.1178090581}, /*cfx*/
          {0.09251744714,-7.915764766e-05,47.80134378,0.1400966795,0.002148393372,0.05409189898}, /*cmy*/
          {5.037069393,2.412727213,5.418064772,4.362298095}, /*cfy*/
          {-0.1813654356,0.001168607286,374.8483715,-0.1940553972,-0.005055042824,0.407391744}, /*cmz*/
          {2.382121209,0.6338896068,3.845513925,1.693597624} /*cfz*/
     },
     {
          2461449.5,
          {-1.217216583,-0.0002393482104,376.9262773,-0.8800693186,0.0009635908227,0.416717995}, /*cmx*/
          {4.129762172,5.696146427,-18.27154399,0.2891394996}, /*cfx*/
          {0.08034232712,-0.0001441620422,54.9773728,-0.3176237011,-0.000620282595,0.07456635345}, /*cmy*/
          {2.1731836,5.529687981,3.633738902,4.784570644}, /*cfy*/
          {-0.09998716918,-8.179447651e-05,374.0917888,0.8636080113,-0.001045672305,0.4070361856}, /*cmz*/
          {5.708043947,4.069577746,-0.9955307769,1.871415422} /*cfz*/
     },
     {
          2461549.5,
          {-1.230376281,0.0001539893398,377.4332134,-0.7801100965,0.004708135078,0.4075113963}, /*cmx*/
          {1.030353518,2.562221893,-3.713389612,0.4632991417}, /*cfx*/
          {0.08421670266,-0.0003839278547,84.79903966,-0.2788514738,-0.001924600776,0.09983649253}, /*cmy*/
          {5.588080951,2.174506609,-7.181536601,5.032883369}, /*cfy*/
          {-0.1700491395,0.001259633032,368.2860473,0.7701221291,-0.00464474731,0.3952488897}, /*cmz*/
          {2.609225539,0.9073020488,0.9017511769,2.037733948} /*cfz*/
     },
     {
          2461649.5,
          {-1.246720758,0.0006395532849,377.3233851,0.4222706938,-0.001108401695,0.39366024}, /*cmx*/
          {4.348660051,5.937903922,5.850185645,0.8268382825}, /*cfx*/
          {0.04174493981,-0.0004393183456,93.66731058,0.208876875,0.0004979083867,0.09258385858}, /*cmy*/
          {2.671060235,5.695502653,2.12854797,5.331916267}, /*cfy*/
          {-0.005476751946,0.002837828689,365.8631399,-0.4156911567,0.001053200232,0.3828098794}, /*cmz*/
          {5.926631855,4.249016236,4.179396508,2.382961163} /*cfz*/
     },
     {
          2461749.5,
          {-1.169590558,3.404834739e-05,376.8734221,-0.09736032196,-0.004436267199,0.397348973}, /*cmx*/
          {1.551152153,3.417550409,2.989182556,1.137778487}, /*cfx*/
          {-0.01320157845,-0.0004119932798,77.51702291,-0.0112564351,0.001747421884,0.09087908073}, /*cmy*/
          {6.072698163,51.106267,5.799067682,5.674875242}, /*cfy*/
          {0.3364858426,0.0004862198841,369.3478308,0.09741900507,0.004408463176,0.385244798}, /*cmz*/
          {3.130053727,1.922456275,1.317846451,2.706936519} /*cfz*/
     },
     {
          2461849.5,
          {-1.140630324,-0.0003630996553,377.4939121,-0.9830633236,0.001662006969,0.4029629127}, /*cmx*/
          {4.819539967,-6.198378836,0.5602273831,1.276554216}, /*cfx*/
          {-0.05428847882,-0.0004731809815,93.65624004,0.3588043825,-0.0008526091189,0.1158072307}, /*cmy*/
          {3.133736723,40.45495142,3.428544843,5.945754661}, /*cfy*/
          {0.3359995462,-0.0002007334069,366.0333265,0.9678511382,-0.001651553958,0.388640553}, /*cmz*/
          {0.1146179469,-1.574921882,5.199923717,2.859844871} /*cfz*/
     },
     {
          2461949.5,
          {-1.173506752,0.0008328625696,377.5291676,-0.625041446,0.005123999483,0.3945377771}, /*cmx*/
          {1.72143789,3.262263877,3.261911492,1.489954188}, /*cfx*/
          {-0.08098357198,-0.0005479349907,119.6397219,0.2107946303,-0.001938074027,0.1274331646}, /*cmy*/
          {0.1268668766,5.693367327,-0.481094301,-0.08807212998}, /*cfy*/
          {0.2580629378,0.001466325626,358.092544,0.6159576692,-0.005069720832,0.3725788944}, /*cmz*/
          {3.294953785,1.602836688,1.583389315,3.065651933} /*cfz*/
     },
     {
          2462049.5,
          {-1.102153838,0.001646755302,377.5343956,0.5909029484,-0.003564763876,0.3815255414}, /*cmx*/
          {5.091233565,0.4101481342,0.4028333926,1.878589173}, /*cfx*/
          {-0.1384513551,-0.000426601905,120.427132,-0.2470214206,0.001403019575,0.1170124375}, /*cmy*/
          {3.506100302,3.093658883,2.942810497,0.2560607791}, /*cfy*/
          {0.4571125865,0.002155796219,357.9043987,-0.5895136275,0.003522335784,0.3557351817}, /*cmz*/
          {0.3804190146,5.004529144,5.014215437,3.464013094} /*cfz*/
     },
     {
          2462149.5,
          {-0.904649391,-0.0004712593037,377.1118597,-0.3898517145,-0.003423664361,0.3786464803}, /*cmx*/
          {2.274876886,3.928026543,3.567318275,2.150102633}, /*cfx*/
          {-0.1879686914,-0.0005488395252,109.6688762,0.1350409953,0.001284272245,0.1224171529}, /*cmy*/
          {0.6494823317,0.1099792827,-0.3007514457,0.5328973752}, /*cfy*/
          {0.6974849162,-0.0002159316696,360.8646143,0.3822134213,0.003365665996,0.3548481352}, /*cmz*/
          {3.850802804,2.283813397,1.881144561,3.736135121} /*cfz*/
     },
     {
          2462249.5,
          {-0.929383464,-0.0004529999755,377.7790219,-1.048419364,0.00265731863,0.3889314432}, /*cmx*/
          {5.493970015,0.7438371101,0.9691978891,2.290044462}, /*cfx*/
          {-0.2365137175,-0.0004872185153,129.3431546,0.384064587,-0.001158495461,0.144866696}, /*cmy*/
          {3.923906018,3.095218855,3.494922041,0.7463132301}, /*cfy*/
          {0.6340890836,-0.0002439630442,354.9572651,1.025383977,-0.002612474649,0.3642584903}, /*cmz*/
          {0.7816186158,5.357733758,5.559130355,3.847103003} /*cfz*/
     },
     {
          2462349.5,
          {-1.00693809,0.00166725458,377.2874958,-0.3919172487,0.004878202217,0.39143076}, /*cmx*/
          {2.406824289,3.97416424,3.97411884,2.557246941}, /*cfx*/
          {-0.2663573899,-0.0005690390989,146.6816856,0.1262280029,-0.001720411871,0.1517095615}, /*cmy*/
          {0.8860662665,-0.236589059,-0.05727087956,1.04043554}, /*cfy*/
          {0.5595219299,0.00180204891,347.8118506,0.379397254,-0.004760066131,0.3638945385}, /*cmz*/
          {3.968662186,2.336499986,2.309138063,4.108379279} /*cfz*/
     },
     {
          2462449.5,
          {-0.8264010925,0.001707050443,377.4682396,0.6044966388,-0.005420852669,0.3787432927}, /*cmx*/
          {5.831776511,1.145777125,1.146728328,2.966660927}, /*cfx*/
          {-0.3244240371,-0.0003907708564,142.5755686,-0.223562613,0.002025461805,0.141980478}, /*cmy*/
          {4.305088125,3.560834948,3.462762338,1.414120033}, /*cfy*/
          {0.7738790704,0.001396325822,349.6160851,-0.5988082694,0.005301046291,0.3547181571}, /*cmz*/
          {1.112022712,5.746426826,5.754653235,4.542314386} /*cfz*/
     },
     {
          2462549.5,
          {-0.6168727116,-0.0009379712241,377.193046,-0.661416587,-0.002360731933,0.3768728116}, /*cmx*/
          {2.972155033,4.580497938,4.001307234,3.178403932}, /*cfx*/
          {-0.3692606339,-0.0005397470249,139.33489,0.2530058945,0.0009836646763,0.1505627001}, /*cmy*/
          {1.428622479,0.5578156822,-0.3441669918,1.633454613}, /*cfy*/
          {0.9172127756,-0.0004064576734,350.5901503,0.6409150266,0.002217696928,0.3498063711}, /*cmz*/
          {4.538756321,2.909024813,2.357450931,4.753925207} /*cfz*/
     },
     {
          2462649.5,
          {-0.7119676747,-0.0001744424403,377.6557871,-1.074391284,0.003814842795,0.4029592127}, /*cmx*/
          {-0.1314103105,1.389058655,1.491441116,3.299340895}, /*cfx*/
          {-0.4117522222,-0.0004678986391,156.1577553,0.4004205531,0.001515679237,0.1707062849}, /*cmy*/
          {4.651666488,3.429627982,-81.17843721,1.814437977}, /*cfy*/
          {0.8443228884,0.000213421782,344.3239622,1.030454773,-0.003676073118,0.3614610291}, /*cmz*/
          {1.425011801,-0.2606434281,6.097860961,4.842575407} /*cfz*/
     },
     {
          2462749.5,
          {-0.771968032,0.002803915193,376.8612564,-0.07360719246,0.003534345128,0.4181628364}, /*cmx*/
          {3.087441986,4.780112846,4.700719536,3.600032126}, /*cfx*/
          {-0.4473315753,-0.0004434173932,163.7746422,0.02079468811,0.001194053155,0.1762560367}, /*cmy*/
          {1.620361476,-0.2671170367,3.531958821,2.139539197}, /*cfy*/
          {0.8368143516,0.001763047776,340.4007071,0.06979799009,-0.003391666942,0.3710497692}, /*cmz*/
          {4.634246064,3.314455958,3.081955439,5.140949811} /*cfz*/
     },
     {
          2462849.5,
          {-0.4627508745,0.001742447562,377.0026688,0.4458192462,-0.006213478096,0.4065385415}, /*cmx*/
          {0.2784700496,1.835198695,1.83717091,3.998539293}, /*cfx*/
          {-0.4980656778,-0.0001923519893,159.5394078,-0.1502894736,-0.002312165878,0.1713421089}, /*cmy*/
          {5.0792603,-2.363609946,0.7410487846,2.511883693}, /*cfy*/
          {1.036147226,0.0004505835562,342.3011308,0.4343062455,0.005952006154,0.3677971204}, /*cmz*/
          {1.830195002,3.334942951,0.1895369957,5.551013393} /*cfz*/
     },
     {
          2462949.5,
          {-0.2776688698,-0.001137266288,377.0476598,-0.8906269564,-0.001485232033,0.3977827193}, /*cmx*/
          {3.641055838,5.218525627,4.115141788,4.166789961}, /*cfx*/
          {-0.5214565627,-0.0003987561567,161.8224127,0.3531034688,-0.0008716506527,0.176715916}, /*cmy*/
          {2.15668941,0.9459192363,-22.51896826,2.682114167}, /*cfy*/
          {1.072275441,-0.0001525205972,341.3014816,-0.8433048182,0.001229861165,0.3602944087}, /*cmz*/
          {5.19248369,0.4226874,2.536040338,5.706131908} /*cfz*/
     },
     {
          2463049.5,
          {-0.3938691927,0.0003370003755,377.1090364,-1.038353074,-0.004987616458,0.4174163494}, /*cmx*/
          {0.510875593,2.023704804,-1.082344124,4.26450224}, /*cfx*/
          {-0.5457180382,-0.0001937659109,170.580866,0.3939661102,-0.001915064763,0.1877573964}, /*cmy*/
          {5.347975251,3.787822181,3.875905196,2.84167495}, /*cfy*/
          {1.030871667,0.0003862915514,338.0240586,-0.970433675,0.004663900891,0.3728277959}, /*cmz*/
          {2.050134906,3.560501886,3.582791564,5.811207605} /*cfz*/
     },
     {
          2463149.5,
          {-0.3799290898,0.003898421949,376.3598633,0.2885238205,-0.00102475856,0.4311640605}, /*cmx*/
          {3.768045186,5.32439959,2.397595229,4.587127678}, /*cfx*/
          {-0.5699095265,9.548425998e-05,170.4954924,-0.1069205187,-0.000312177418,0.1949363595}, /*cmy*/
          {2.346841533,0.8097831739,0.8707357912,3.187168726}, /*cfy*/
          {1.078845255,0.0005062978526,337.8445554,0.2667731559,0.001041529301,0.3882596489}, /*cmz*/
          {5.301539325,0.5682373937,0.8521628035,-0.1311812977} /*cfz*/
     },
     {
          2463249.5,
          {0.01894623449,0.0009921126065,376.356063,0.1588961003,0.005901913869,0.418756114}, /*cmx*/
          {0.9893550953,2.37290362,5.61813231,4.976142095}, /*cfx*/
          {-0.5676464443,0.0001002199176,170.1965354,-0.05101314311,0.0022560252,0.1924213222}, /*cmy*/
          {5.829368171,3.717879536,4.236601526,3.542980676}, /*cfy*/
          {1.137136541,-0.0002390055518,337.4295364,0.1541707487,-0.00553938791,0.3774208673}, /*cmz*/
          {2.527858833,3.997486534,-2.267030448,0.2380580704} /*cfz*/
     },
     {
          2463349.5,
          {0.1199981405,-0.001538450244,376.6383152,-1.055976605,-0.001379521243,0.4078752682}, /*cmx*/
          {4.284807127,5.837563689,3.771493877,5.130483336}, /*cfx*/
          {-0.5580381083,-6.587004424e-05,173.1004484,-0.4242161893,0.0009436305172,0.1864032213}, /*cmy*/
          {2.850751245,-1.818871491,-0.7402727622,3.710077866}, /*cfy*/
          {1.108498792,0.0001410242974,336.5949149,-0.976708313,0.00108783982,0.3619531612}, /*cmz*/
          {5.819750133,1.087863653,2.092955226,0.3695069168} /*cfz*/
     },
     {
          2463449.5,
          {-0.03460860308,0.000974130868,376.2732347,-0.9108444401,-0.005836809431,0.4150768797}, /*cmx*/
          {1.145138587,2.660816315,-0.4754716182,5.270601374}, /*cfx*/
          {-0.5529054101,0.0001482416122,171.0879558,-0.3467308686,0.002211396919,0.1858983459}, /*cmy*/
          {6.033229366,1.030221955,-11.53095357,3.890571405}, /*cfy*/
          {1.109366777,0.0002153463762,338.4305135,-0.8364268952,-0.005359967133,0.3788116304}, /*cmz*/
          {2.671788035,4.251906893,1.116468719,0.5152786169} /*cfz*/
     },
     {
          2463549.5,
          {0.07232490142,0.003546206882,375.845253,0.5819438916,0.002030120588,0.4218322782}, /*cmx*/
          {4.457061392,6.046247807,2.849267554,5.654923202}, /*cfx*/
          {-0.5468319757,0.0004679110786,167.8088232,0.2171822403,-0.0007886611219,0.1937631715}, /*cmy*/
          {3.078349544,4.369300203,4.491577324,4.253475528}, /*cfy*/
          {1.133332922,-0.0006767856192,340.1340086,0.5331521809,0.001829139787,0.3917564101}, /*cmz*/
          {5.982403791,1.371253488,4.432615112,0.8889205014} /*cfz*/
     },
     {
          2463649.5,
          {0.4376135399,-0.0002451655135,375.710601,-0.185491722,0.004837432659,0.4186513103}, /*cmx*/
          {1.677666428,3.459219205,6.200138279,5.994702154}, /*cfx*/
          {-0.5085411542,0.0002305000143,172.7417256,-0.1046418103,-0.001896838339,0.1932356917}, /*cmy*/
          {0.2744428708,2.285237254,1.370025434,4.585718867}, /*cfy*/
          {1.077954684,-0.0002026319949,336.6933084,-0.1642274402,0.004428204045,0.3787392887}, /*cmz*/
          {3.205097022,4.915648442,1.513831997,1.225677071} /*cfz*/
     },
     {
          2463749.5,
          {0.4166118876,-0.001404484894,376.0807435,1.138458413,-0.002137048564,0.4154618276}, /*cmx*/
          {4.913039108,-2.976663211,3.771281062,-0.1454371873}, /*cfx*/
          {-0.4876825714,0.0001266914417,170.6882248,-0.4485231772,0.001142397696,0.1829096107}, /*cmy*/
          {3.529414493,4.829772706,5.486866409,4.785447974}, /*cfy*/
          {1.075627327,0.0006637426194,338.806673,-1.039920578,-0.001877088176,0.3746996508}, /*cmz*/
          {0.1541540326,8.037177261,5.305264478,1.384958494} /*cfz*/
     },
     {
          2463849.5,
          {0.2632041111,0.001650576883,375.4313857,0.6812075563,-0.005947157522,0.4217926672}, /*cmx*/
          {1.7836676,0.1775763609,0.1768814513,0.07082754171}, /*cfx*/
          {-0.461711476,0.0002544955745,158.2329161,-0.2582297757,0.002278617426,0.1745496377}, /*cmy*/
          {0.4448889737,1.443248957,1.389120752,5.024477496}, /*cfy*/
          {1.117429492,3.586086339e-05,345.092858,-0.6232869058,-0.005436363193,0.3880582852}, /*cmz*/
          {3.307382931,4.949354607,1.817204069,1.594594571} /*cfz*/
     },
     {
          2463949.5,
          {0.4725974094,0.002637866622,375.4495751,-0.6982260413,0.004547565183,0.4325515087}, /*cmx*/
          {5.159475436,3.62055299,3.617784846,0.472264116}, /*cfx*/
          {-0.44262671,0.0006570758991,157.3144171,0.2739094344,-0.001752865259,0.1822140364}, /*cmy*/
          {3.823814713,4.816228922,4.978192617,5.391035588}, /*cfy*/
          {1.094192559,-0.001348936456,345.6669976,0.6394828269,0.00417803565,0.3907100026}, /*cmz*/
          {0.3998819651,2.130986362,5.23741538,1.980224414} /*cfz*/
     },
     {
          2464049.5,
          {0.7550926826,-0.0006327731372,375.1696504,0.4917446445,0.003440014293,0.4336021457}, /*cmx*/
          {2.346313112,0.8445076619,0.4229520787,0.7372335484}, /*cfx*/
          {-0.3890562405,0.00029542398,165.1820181,-0.2100537274,-0.001437317037,0.1821369632}, /*cmy*/
          {0.9885098569,2.482796728,1.507290223,5.66953161}, /*cfy*/
          {0.9871385471,0.0002556698606,341.2038562,-0.4476742064,0.003083679384,0.3927049819}, /*cmz*/
          {3.868800919,5.548311067,2.082757645,2.254735111} /*cfz*/
     },
     {
          2464149.5,
          {0.6874579925,-0.0007697107261,375.6068365,1.136365713,-0.003095019749,0.4317659036}, /*cmx*/
          {5.538667393,3.922889293,4.130283193,0.8856766118}, /*cfx*/
          {-0.3548655911,0.0002737745912,154.1261442,-0.4304944407,0.001314451725,0.1693151898}, /*cmy*/
          {4.214128884,5.164280396,5.531522276,5.875031659}, /*cfy*/
          {1.029672458,0.0009763391181,347.3807405,-1.039930634,-0.00281501267,0.4074440817}, /*cmz*/
          {0.779759295,2.41252188,5.748885047,2.417852188} /*cfz*/
     },
     {
          2464249.5,
          {0.5982205633,0.00224795476,374.9500958,0.3683202594,-0.005016391815,0.4381421861}, /*cmx*/
          {2.438009512,0.8719446879,0.8713533724,1.157808633}, /*cfx*/
          {-0.3171289199,0.0004826419056,134.4730752,-0.1363497243,0.002014563355,0.1619919745}, /*cmy*/
          {1.169055985,1.95488275,1.80746443,-0.1187639534}, /*cfy*/
          {1.100883827,-0.001010230952,355.1463284,-0.3367481087,-0.004565920367,0.4179074281}, /*cmz*/
          {3.967992126,5.653281155,2.538532591,2.690583103} /*cfz*/
     },
     {
          2464349.5,
          {0.8590961139,0.001800211098,375.1273987,-0.6087651421,0.005848134115,0.4416039308}, /*cmx*/
          {5.872897113,4.32580781,4.326565335,1.53965366}, /*cfx*/
          {-0.2733232562,0.0007928658103,140.3773149,0.2606857835,-0.00226708875,0.1694052216}, /*cmy*/
          {4.587030725,5.236797731,5.436953925,0.2495495195}, /*cfy*/
          {0.9554058391,-0.001793346133,352.9566492,0.5528435394,0.005337605413,0.4124369411}, /*cmz*/
          {1.11772961,2.869314766,5.970771702,3.074678078} /*cfz*/
     },
     {
          2464449.5,
          {1.050741061,-0.0007744176002,374.9128164,0.7232148815,0.002089626571,0.4377629661}, /*cmx*/
          {3.003743747,1.460825024,0.7979331638,1.731436318}, /*cfx*/
          {-0.198282531,0.000296616837,146.3214116,-0.276420636,-0.001122091174,0.1561668287}, /*cmy*/
          {1.703256869,2.790254394,1.513147366,0.4764065835}, /*cfy*/
          {0.7959488128,0.000579914083,350.2854602,-0.6615962366,0.001870193741,0.4134986914}, /*cmz*/
          {4.529698988,6.215531602,2.496460981,3.271429989} /*cfz*/
     },
     {
          2464549.5,
          {0.9801985141,-0.0002567049025,375.4285498,1.062991134,-0.003995091961,0.441233023}, /*cmx*/
          {-0.1089967597,4.556631839,4.64181985,1.901605677}, /*cfx*/
          {-0.1603008995,0.0003799377307,125.1540296,-0.3956042534,0.001544547873,0.136107727}, /*cmy*/
          {4.93028869,5.474520898,24.45079153,0.6680101742}, /*cfy*/
          {0.8710957652,0.0004040311549,359.0631736,-0.9829352434,-0.003683190249,0.4274340643}, /*cmz*/
          {1.424877326,3.059502056,6.29108242,3.430200834} /*cfz*/
     },
     {
          2464649.5,
          {0.9391900063,0.002042898785,375.0435865,0.01688265512,-0.002998941458,0.4460458445}, /*cmx*/
          {3.116428256,2.02613881,1.601994194,2.246407047}, /*cfx*/
          {-0.1226951338,0.0005737511946,103.783083,-0.03184435185,0.001316295794,0.1346170642}, /*cmy*/
          {1.94512516,-8.204329573,2.323368682,0.9862428968}, /*cfy*/
          {0.8969392677,-0.002323497879,365.1196151,-0.01478960707,-0.002737130683,0.4293472496}, /*cmz*/
          {4.658144125,0.3308070427,3.294300371,3.766989715} /*cfz*/
     },
     {
          2464749.5,
          {1.14083783,0.0005467212116,374.9250783,0.3673166965,0.005818024132,0.4321659147}, /*cmx*/
          {0.3094128343,14.42672468,5.004481259,2.603154669}, /*cfx*/
          {-0.05943735933,0.0005643226718,117.6629912,0.1947522253,-0.002313376745,0.1388231719}, /*cmy*/
          {5.372393247,5.605720373,5.85694754,1.371550566}, /*cfy*/
          {0.6133115255,-0.001585240761,360.9880856,-0.3312023458,0.005339199299,0.4149904278}, /*cmz*/
          {1.845951995,6.724930009,0.3814662872,4.134293318} /*cfz*/
     },
     {
          2464849.5,
          {1.213529342,-0.0007978120741,375.0493683,-0.8664284854,0.001156489116,0.418387443}, /*cmx*/
          {3.661447892,5.236918144,-5.46417031,2.752202924}, /*cfx*/
          {-0.001883407119,0.0001180141092,116.7632137,-0.3107076085,0.00091135591,0.1136295758}, /*cmy*/
          {2.444089075,3.079250497,-26.76743076,1.628184937}, /*cfy*/
          {0.4773870685,0.0006459094562,361.3882157,0.8028453292,0.001089106992,0.4127917807}, /*cmz*/
          {5.198317935,3.730551707,2.499280029,4.295478545} /*cfz*/
     },
     {
          2464949.5,
          {1.143898528,0.0001297553612,375.6003541,-0.93421788,-0.004729793001,0.4292401859}, /*cmx*/
          {0.5455876969,2.072872369,-1.042955674,2.950689883}, /*cfx*/
          {0.0132148918,0.0002123601545,87.7204504,-0.3549574066,-0.001937916687,0.08674201463}, /*cmy*/
          {5.721543823,-0.4653070991,-3.62124187,1.853670901}, /*cfy*/
          {0.5614810266,-0.0001247324948,369.684914,0.8758665557,-0.004407381213,0.4203376923}, /*cmz*/
          {2.093808607,0.5597970266,0.5941798576,4.501876114} /*cfz*/
     },
     {
          2465049.5,
          {1.148072776,0.001034304503,375.4774732,0.3054306679,-0.0003295022818,0.4370502042}, /*cmx*/
          {3.823403345,5.40250713,2.695153507,3.338964744}, /*cfx*/
          {0.02700695598,0.0005072613671,71.04862674,0.1698985415,-0.0002707385501,0.09226072128}, /*cmy*/
          {2.816321189,2.622493709,6.374068017,2.174906517}, /*cfy*/
          {0.5222797132,-0.002880526076,372.6451224,-0.278855174,-0.0003483980233,0.4209091127}, /*cmz*/
          {5.377968796,3.911427608,4.523768656,4.90351946} /*cfz*/
     },
     {
          2465149.5,
          {1.237109197,-0.0001033063444,375.0424712,0.07144660167,0.004939409709,0.4198900175}, /*cmx*/
          {1.031513288,2.276263507,11.94510159,3.681484938}, /*cfx*/
          {0.08526478285,0.0002303869258,89.59283509,0.1044591981,-0.002077238659,0.0991816086}, /*cmy*/
          {6.198754919,5.83012268,6.240880716,2.574081401}, /*cfy*/
          {0.2195429903,-0.001194344635,368.5941265,-0.05781034715,-0.004618917587,0.4105703542}, /*cmz*/
          {2.578875123,0.9902940271,10.44638578,5.236990222} /*cfz*/
     },
     {
          2465249.5,
          {1.243525274,-0.0003265244171,375.515233,0.9405205738,-0.0011742297,0.4054193309}, /*cmx*/
          {4.328029632,2.746092298,3.595803566,3.830609033}, /*cfx*/
          {0.1102185186,-0.0001217576011,79.40550836,-0.3366593228,0.0007547218701,0.07036358548}, /*cmy*/
          {3.264004361,3.368604482,-8.029685189,2.954343199}, /*cfy*/
          {0.1321216901,0.000768865624,371.1898467,0.8877561867,0.001174623357,0.4044807733}, /*cmz*/
          {5.879387144,4.370708878,2.158026159,5.37796033} /*cfz*/
     },
     {
          2465349.5,
          {1.225297692,0.0001986124081,375.9798621,0.7515456279,0.005098323947,0.4146712528}, /*cmx*/
          {1.221954264,5.899810221,-3.522091247,4.043148722}, /*cfx*/
          {0.09665191456,8.2859388e-05,48.76252126,-0.2892143463,0.00226276477,0.04532133402}, /*cmy*/
          {0.4540291853,-0.03991557478,-6.365458421,3.385531496}, /*cfy*/
          {0.2029256203,-0.0007681505535,376.1435479,0.7177239549,0.004837400964,0.4160529829}, /*cmz*/
          {2.784337181,1.210032869,4.359653775,5.613186162} /*cfz*/
     },
     {
          2465449.5,
          {1.249655098,-0.000130160197,375.9649178,-0.5045657875,-0.002244188821,0.4244293627}, /*cmx*/
          {4.557617778,3.015990597,6.129357031,4.450145608}, /*cfx*/
          {0.09262186605,0.0005064525677,42.02360845,0.2732066452,-0.0008774874852,0.05716406521}, /*cmy*/
          {3.917736252,3.290507199,3.260610179,3.541856481}, /*cfy*/
          {0.09092642862,-0.003278963612,376.7675528,-0.4730194257,-0.002143096141,0.4306878518}, /*cmz*/
          {6.122578037,4.633243103,1.449900411,6.026484324} /*cfz*/
     },
     {
          2465549.5,
          {1.225303836,-0.0002410017794,375.4399741,0.2175545969,-0.00378268113,0.4162874987}, /*cmx*/
          {1.752704994,0.3082202178,3.149198048,4.750122706}, /*cfx*/
          {0.1449622672,-0.0001789879708,57.89593773,-0.04519721695,-0.001704397979,0.05958157305}, /*cmy*/
          {0.8590418302,1.754217938,0.3118186817,3.889109072}, /*cfy*/
          {-0.209974502,-0.0008120579033,374.4424033,0.2124441827,-0.003604918683,0.4197114297}, /*cmz*/
          {3.311799777,1.907178718,4.738650701,0.03169543697} /*cfz*/
     },
     {
          2465649.5,
          {1.22136615,-9.613079434e-05,376.1504556,0.9707991096,0.001918432913,0.4058037885}, /*cmx*/
          {5.005581188,3.411519432,0.6121526077,4.877015528}, /*cfx*/
          {0.1309520939,-0.000429112726,41.41604809,-0.3588714716,0.0008413771574,0.03849537582}, /*cmy*/
          {4.384027605,-2.578316203,4.272504233,4.735337473}, /*cfy*/
          {-0.2752266531,0.0006489563857,376.913678,0.9340696965,0.001878859979,0.4033323647}, /*cmz*/
          {0.2875394445,4.997868463,2.261533193,0.1636669683} /*cfz*/
     },
     {
          2465749.5,
          {1.228809661,-0.0004452633621,376.370316,0.5081420827,0.004826182637,0.4104098639}, /*cmx*/
          {1.91824453,0.3337790353,3.475769571,5.120275741}, /*cfx*/
          {0.08023970795,2.5422342e-05,30.56818029,-0.1819413398,0.002202097022,0.03493863515}, /*cmy*/
          {2.275126228,0.4645474144,0.4506406187,5.550073688}, /*cfy*/
          {-0.2298329304,-0.001747149704,377.3137122,0.4947399711,0.004664088899,0.4102385318}, /*cmz*/
          {3.491217654,1.885941719,5.024077994,0.4091662155} /*cfz*/
     },
     {
          2465849.5,
          {1.162853722,-0.00136214513,376.4299405,-0.5428963818,-0.004028383189,0.4185829046}, /*cmx*/
          {5.311584823,3.776187015,0.6320775764,5.525460797}, /*cfx*/
          {0.0759123822,0.0002482755906,29.59813505,0.2979082705,-0.001692109113,0.0295188287}, /*cmy*/
          {5.586023274,3.940834929,3.929645016,5.332617252}, /*cfy*/
          {-0.4418834871,-0.002728519121,377.4833901,-0.5207945849,-0.003913072424,0.4209739366}, /*cmz*/
          {0.6007121114,5.338733418,2.195593894,0.7988435978} /*cfz*/
     },
     {
          2465949.5,
          {1.038766094,-0.0004926066784,375.9619163,0.4552753326,-0.002649248487,0.4118384131}, /*cmx*/
          {2.471281246,0.9560670188,3.719707492,5.760575939}, /*cfx*/
          {0.09885650474,-0.0006881036399,31.67163001,-0.1252212562,-0.00125859419,0.02870818173}, /*cmy*/
          {2.288740209,1.270439234,0.6125998196,5.894107713}, /*cfy*/
          {-0.68536655,-0.0001964642934,377.1517166,0.445270644,-0.002590235319,0.4126705704}, /*cmz*/
          {4.04090664,2.537841608,5.239343822,1.040201777} /*cfz*/
     },
     {
          2466049.5,
          {1.02410031,-0.0001143098783,376.7901549,0.9673939802,0.002892813098,0.3936004528}, /*cmx*/
          {5.692670641,4.08922366,1.089899803,-0.3956904769}, /*cfx*/
          {0.03105324616,-0.0006572365587,34.66352236,-0.3638997087,0.001232193753,0.05020248605}, /*cmy*/
          {6.398025823,4.092988324,4.313783965,0.5677115798}, /*cfy*/
          {-0.6919175991,0.0004461337608,377.1212087,0.9461143921,0.00283189829,0.3927481804}, /*cmz*/
          {0.9845966582,5.624613439,2.643055427,1.195020281} /*cfz*/
     },
     {
          2466149.5,
          {1.004720323,-0.00146577471,376.7707391,0.2072780198,0.003677449686,0.3868573583}, /*cmx*/
          {2.633042607,1.089153514,4.227055379,-0.1054779513}, /*cfx*/
          {-0.04290967843,6.035696021e-05,55.442362,-0.04475831539,0.001633067613,0.05678542662}, /*cmy*/
          {3.819222018,1.010602063,1.066911719,0.9697126761}, /*cfy*/
          {-0.6727002124,-0.001674986928,373.8300734,0.2029346504,0.003580139746,0.3864899325}, /*cmz*/
          {4.211355956,2.635295517,5.739610543,1.488131843} /*cfz*/
     },
     {
          2458849.5,
          {-0.4713540801,0.0007334576552,524.5835943,-1.381411303,-0.003708057493,0.2537636986}, /*cmx*/
          {-2.425153342,-0.8834012302,-3.8005275,-5.775806291}, /*cfx*/
          {-0.1610234553,-8.202639684e-05,218.2111268,-0.526564392,-0.001569434077,0.09241402856}, /*cmy*/
          {-0.6286876433,-5.91431026,-2.386265936,-4.003800659}, /*cfy*/
          {-0.4847629233,-0.0007642214087,483.1239486,-1.259041079,-0.003291805063,0.2223811575}, /*cmz*/
          {-0.8990696139,-5.540809192,-2.20559399,-4.219616415} /*cfz*/
     },
     {
          2458939.5,
          {-0.3995120692,0.000418571944,524.1825124,-0.6066391716,-0.007109278266,0.2227839594}, /*cmx*/
          {3.203713656,4.75475948,1.614133058,5.728744703}, /*cfx*/
          {-0.1529505606,-6.318678781e-05,197.1477845,-0.2280134769,-0.002779637074,0.08442755194}, /*cmy*/
          {5.042095434,5.847819328,2.635114757,1.323787118}, /*cfy*/
          {-0.5233763867,7.513082342e-05,492.0157951,-0.5566702829,-0.006506548216,0.2139351529}, /*cmz*/
          {4.733499365,0.1231516074,3.278528328,0.9922400895} /*cfz*/
     },
     {
          2459029.5,
          {-0.4459203256,-0.0002460452164,524.3166536,0.8276680613,0.004142838159,0.2299901251}, /*cmx*/
          {2.731083443,4.330960025,1.173388871,4.723441503}, /*cfx*/
          {-0.1617159437,0.0002293404856,199.0547202,0.3383073254,0.001607515752,0.07869520577}, /*cmy*/
          {4.56583366,5.336916468,2.285827358,0.3648884356}, /*cfy*/
          {-0.5161774267,0.0007021296382,491.3865087,0.7631112693,0.003890551083,0.2034712573}, /*cmz*/
          {4.260134392,5.993356585,2.802645537,0.03087377034} /*cfz*/
     },
     {
          2459119.5,
          {-0.4253663977,0.0002220965547,523.9184283,-0.2102583955,0.006177275928,0.2167297554}, /*cmx*/
          {2.333948366,4.071646529,0.6209034178,3.943048536}, /*cfx*/
          {-0.1633787234,-0.0001320392338,212.4309851,-0.1000030899,0.002424746532,0.09455420381}, /*cmy*/
          {4.145193788,5.840763903,1.661975261,5.782095311}, /*cfy*/
          {-0.4850110185,-0.0009222170896,485.143053,-0.197185348,0.005561647482,0.2130844676}, /*cmz*/
          {3.86064144,5.598675901,2.278885029,5.476656532} /*cfz*/
     },
     {
          2459209.5,
          {-0.3849773753,0.001395839801,524.3282853,-1.322053916,-0.002402888218,0.2335060264}, /*cmx*/
          {1.734066434,-3.001461725,0.5597983627,2.806350496}, /*cfx*/
          {-0.1571026749,2.716551018e-05,199.5777718,0.498011542,-0.001207564229,0.08394749484}, /*cmy*/
          {3.569264023,1.253518187,1.974588855,4.693317487}, /*cfy*/
          {-0.5298579952,-0.0006640271797,491.2178122,-1.209429915,-0.002138081905,0.2087767988}, /*cmz*/
          {3.263020247,4.929310257,2.220946328,4.351856384} /*cfz*/
     },
     {
          2459299.5,
          {-0.2671581302,-0.0002584866031,524.1471741,-0.8500310543,-0.007106976153,0.2335832965}, /*cmx*/
          {1.068594339,2.610294262,-0.531049533,1.668456194}, /*cfx*/
          {-0.1670855145,9.805249409e-05,171.6238256,0.3224227806,-0.002840680073,0.07652784022}, /*cmy*/
          {2.960331842,0.3520244217,0.2906722155,3.573811624}, /*cfy*/
          {-0.6336001185,0.0002249424975,501.7746133,-0.7858547753,-0.006551201949,0.225816853}, /*cmz*/
          {2.604334043,4.261573439,1.130271391,3.203783633} /*cfz*/
     },
     {
          2459389.5,
          {-0.2540400362,-0.001090694688,524.132109,0.6714854129,0.0015295855,0.2745953851}, /*cmx*/
          {0.554618651,2.14736108,5.186828368,0.7192591092}, /*cfx*/
          {-0.1759336517,-0.0001646654147,166.5149924,-0.2902054575,0.0005689726394,0.0831676036}, /*cmy*/
          {2.458116137,6.035278045,5.875501534,2.528124066}, /*cfy*/
          {-0.644299623,0.0003312205893,503.3239201,0.6084856696,0.001369013584,0.2457863211}, /*cmz*/
          {2.091844487,3.815820754,0.4781410895,2.325320154} /*cfz*/
     },
     {
          2459479.5,
          {-0.36981646,0.001060352415,523.6870912,0.111171998,0.007063678385,0.2230811162}, /*cmx*/
          {0.1703373951,1.485680856,4.80935623,6.042719839}, /*cfx*/
          {-0.171189538,0.0001541254726,185.5114795,-0.08938438439,0.002807846947,0.07954171188}, /*cmy*/
          {2.03564298,5.148372083,5.722015308,1.666674312}, /*cfy*/
          {-0.5939579354,0.0003365791889,496.4411599,0.09592164578,0.0064849344,0.2218815628}, /*cmz*/
          {1.702307705,3.375643907,0.1981238718,1.305019373} /*cfz*/
     },
     {
          2459569.5,
          {-0.3068221304,0.001203142448,524.0572833,1.202018709,-0.001332064351,0.2304915832}, /*cmx*/
          {5.892802085,-1.969908534,5.342186603,4.889226346}, /*cfx*/
          {-0.1785867389,0.0003271568502,175.0337347,-0.4531463098,0.001027369516,0.06153422802}, /*cmy*/
          {1.496312884,2.128780162,1077.758614,0.6437578702}, /*cfy*/
          {-0.6269278966,-0.0003338213492,500.573,-1.113931402,-0.001228440493,0.217177814}, /*cmz*/
          {1.144454121,2.819891137,6.991111881,0.168160277} /*cfz*/
     },
     {
          2459659.5,
          {-0.1784502924,0.0009496143934,524.3137939,1.028564501,0.006532379027,0.2370501656}, /*cmx*/
          {5.225093879,3.620064552,0.486961215,3.83758567}, /*cfx*/
          {-0.1521176366,0.0001124365277,141.5804829,-0.3957643851,0.002672137397,0.05758574783}, /*cmy*/
          {0.9079485906,1.170146419,-5.147335042,5.872998688}, /*cfy*/
          {-0.6546759111,-0.0004489062521,511.0795072,-0.9600002615,0.006074267721,0.2321662666}, /*cmz*/
          {0.4854558471,2.12474461,-4.140318803,5.371107356} /*cfz*/
     },
     {
          2459749.5,
          {-0.1238782507,-0.0003037966266,524.0197652,-0.4031872399,0.001332348113,0.2403159672}, /*cmx*/
          {4.67275598,3.083589464,0.2224797665,3.01258838}, /*cfx*/
          {-0.1323103007,-0.0001228989488,127.7967334,0.1984451541,0.0006507833209,0.07081044404}, /*cmy*/
          {0.3990712029,0.4403489923,1.004771797,5.013526822}, /*cfy*/
          {-0.693781549,0.0004739798238,514.3732882,0.3680448624,0.001242046592,0.2210739935}, /*cmz*/
          {-0.06320339128,1.633455858,1.849098449,4.605891868} /*cfz*/
     },
     {
          2459839.5,
          {-0.1773297031,-0.0005717388957,523.8833792,-0.3999891737,-0.007482429233,0.2428384499}, /*cmx*/
          {4.284819672,2.695158295,5.839624852,1.976081578}, /*cfx*/
          {-0.1674895469,3.104559222e-05,149.1896273,0.2044346192,-0.003049452948,0.07079440896}, /*cmy*/
          {6.232374233,6.413878716,-5.998863097,3.911705292}, /*cfy*/
          {-0.6685718206,-0.0002389660287,508.6142665,0.3657770956,-0.006933498406,0.237221372}, /*cmz*/
          {5.826139813,1.251541656,1.215819636,3.528782473} /*cfz*/
     },
     {
          2459929.5,
          {-0.1854639857,0.001468826847,523.9872224,1.038119252,-0.001438930366,0.2623226381}, /*cmx*/
          {3.767004048,2.203063239,4.334737121,0.8643176846}, /*cfx*/
          {-0.1633263772,0.0003418505281,144.6141065,-0.3883836956,-0.001048544212,0.05749415661}, /*cmy*/
          {5.727712073,6.129600697,-14.06380967,2.800346555}, /*cfy*/
          {-0.6799412071,-0.0004331437451,510.0381796,-0.9639325261,-0.001428767953,0.2513831774}, /*cmz*/
          {5.309417487,0.7043374519,-0.2754035581,2.452167867} /*cfz*/
     },
     {
          2460019.5,
          {-0.04675068405,0.0006709654703,524.5321285,1.147604793,-0.005597414451,0.2562753728}, /*cmx*/
          {3.105126126,1.503419467,1.539983315,6.067231909}, /*cfx*/
          {-0.1186630292,0.0003177734282,108.3934076,-0.451699072,-0.002357133581,0.04305481926}, /*cmy*/
          {5.18965608,5.159339613,2.043852667,1.773119928}, /*cfy*/
          {-0.7533823869,0.000564968219,518.9859609,-1.082720178,-0.00526265427,0.2513036253}, /*cmz*/
          {4.657330674,-0.01313200645,3.173255509,1.325811055} /*cfz*/
     },
     {
          2460109.5,
          {0.04133023614,-0.001152199408,524.392259,-0.07796053741,-0.003789449646,0.2339317003}, /*cmx*/
          {2.519521682,0.8039615894,1.025102637,5.002795616}, /*cfx*/
          {-0.1020333641,-0.0002764629938,86.58043169,0.07829442424,-0.001662225039,0.03736098297}, /*cmy*/
          {4.728608734,4.184467599,1.520142948,1.239351303}, /*cfy*/
          {-0.7200426369,0.0001594773514,522.3760803,0.07471501106,-0.003489937477,0.2257186619}, /*cmz*/
          {4.077003513,5.607637218,2.669088249,0.313899106} /*cfz*/
     },
     {
          2460199.5,
          {-0.08586781142,0.0006225348781,524.3399495,-0.6286912355,0.007213999988,0.2519386483}, /*cmx*/
          {2.113218721,13.12786495,0.5600220934,4.153845403}, /*cfx*/
          {-0.1284011465,-1.739731786e-05,105.1506968,0.3098238365,0.003037472201,0.05001090663}, /*cmy*/
          {4.212704668,4.164100337,1.085530438,-0.03549786125}, /*cfy*/
          {-0.7145500555,0.0001331692335,519.3543527,-0.5859806848,0.006781351876,0.2439685458}, /*cmz*/
          {3.666042796,-4.065950397,2.200517766,5.702918987} /*cfz*/
     },
     {
          2460289.5,
          {-0.05348149828,0.001316558819,524.1925683,0.8205228946,0.002594525655,0.244855997}, /*cmx*/
          {1.637690236,0.08813678618,-0.3816175553,3.148670165}, /*cfx*/
          {-0.1281311707,0.0006189300045,108.8145438,-0.302762615,0.001370047137,0.04975952653}, /*cmy*/
          {3.724293584,3.846683505,-0.1574295127,5.369168971}, /*cfy*/
          {-0.7593507774,0.0003808749827,518.4043549,0.7745627987,0.002554368088,0.2404598935}, /*cmz*/
          {3.18961785,1.726263562,1.182134778,4.74162311} /*cfz*/
     },
     {
          2460379.5,
          {0.08379533009,0.001111950318,524.8909881,1.219655612,-0.004520695401,0.2481145257}, /*cmx*/
          {0.989825965,5.675429988,5.764557465,2.025642616}, /*cfx*/
          {-0.07835617204,0.0004696237198,74.44252363,-0.488675992,-0.001963578986,0.03495913002}, /*cmy*/
          {3.302270366,2.880491915,6.14627452,4.335721991}, /*cfy*/
          {-0.711313177,-0.0002841749895,524.5389657,1.157003184,-0.00423797274,0.2413675469}, /*cmz*/
          {2.550461359,0.9937977061,1.10523269,3.568469956} /*cfz*/
     },
     {
          2460469.5,
          {0.1441821931,-4.797288244e-06,524.9411174,0.246873378,-0.005489753181,0.2683875029}, /*cmx*/
          {0.3762153386,5.118691996,5.113402172,0.9360236159}, /*cfx*/
          {-0.03865080541,-0.0002606717183,51.20768458,-0.06457282703,-0.002433654299,0.01657487911}, /*cmy*/
          {3.090393385,2.456462539,5.388270971,3.655249799}, /*cfy*/
          {-0.7356778197,-5.092490508e-05,526.5241979,0.2421368758,-0.005260560773,0.2652987791}, /*cmz*/
          {1.943527966,0.4291766513,0.4263034589,2.530272893} /*cfz*/
     },
     {
          2460559.5,
          {0.1360041829,-0.001066165169,525.0859553,-0.7609105582,0.006134370126,0.2785575828}, /*cmx*/
          {6.223672361,4.691737072,4.691674884,6.375297852}, /*cfx*/
          {-0.07299191617,-0.0001186901453,59.86205484,0.3785926196,0.002695865991,0.03124087259}, /*cmy*/
          {2.439391462,1.843493616,4.996969549,2.187614146}, /*cfy*/
          {-0.7871390298,0.0003221327652,525.9848605,-0.7195609433,0.00584316415,0.2655322984}, /*cmz*/
          {1.504992755,6.289112207,6.281756285,1.644561318} /*cfz*/
     },
     {
          2460649.5,
          {0.08475888886,0.0009876566688,524.4541933,0.560634594,0.004022837855,0.2464758372}, /*cmx*/
          {5.786082136,4.27020695,3.958772889,5.237499192}, /*cfx*/
          {-0.08104563643,0.0004625266802,70.38445581,-0.2012967585,0.001829636163,0.02773236736}, /*cmy*/
          {1.865353691,1.570027145,4.108631313,1.939536436}, /*cfy*/
          {-0.7206635264,-0.0001388957674,524.5588646,0.53959917,0.003846980452,0.2484344148}, /*cmz*/
          {1.064844874,5.873134583,5.525456087,0.5613448177} /*cfz*/
     },
     {
          2460739.5,
          {0.1575202148,0.001348850925,525.3450675,1.240514213,-0.003295310323,0.2547051019}, /*cmx*/
          {5.159449397,3.567387976,3.75852123,4.145583336}, /*cfx*/
          {-0.03418025475,0.0004609459243,47.32273353,-0.5011744121,-0.001517723577,0.02594578158}, /*cmy*/
          {1.743445137,0.611916685,4.044888585,1.339748963}, /*cfy*/
          {-0.7658102033,0.0009882722396,527.1189892,1.196580762,-0.003210414617,0.2463527348}, /*cmz*/
          {0.4450864078,5.141893793,5.384066068,5.686412006} /*cfz*/
     },
     {
          2460829.5,
          {0.325336617,-0.0003770672742,525.5765973,0.5536589441,-0.006485637136,0.2586996742}, /*cmx*/
          {4.524038056,2.950268741,2.951080977,3.145067023}, /*cfx*/
          {0.01972665469,-6.049423478e-06,47.96576846,-0.1939312426,-0.002852052939,0.02135624304}, /*cmy*/
          {1.981976627,-0.1103778604,3.024458997,0.5913031803}, /*cfy*/
          {-0.7277605463,0.0001640624199,526.4305404,0.5396208441,-0.006280953835,0.259170045}, /*cmz*/
          {6.098699237,4.490128123,4.485957456,4.741828529} /*cfz*/
     },
     {
          2460919.5,
          {0.2944477201,-0.0003259919433,525.7460953,-0.7748335909,0.004268614894,0.2590517973}, /*cmx*/
          {4.050889616,2.515490596,2.501397366,2.337495579}, /*cfx*/
          {0.0166168111,-0.0003486655539,45.61366496,0.3865038787,0.00194445249,0.02541060733}, /*cmy*/
          {1.423124141,5.76985939,2.566787919,5.198684198}, /*cfy*/
          {-0.6857602178,-0.0005327828784,526.8053945,-0.7351362931,0.004021876536,0.2419044464}, /*cmz*/
          {5.62524835,4.065256003,4.049972501,3.884445213} /*cfz*/
     },
     {
          2461009.5,
          {0.1827255481,0.001089636848,525.0051013,0.2704246687,0.005363486096,0.2794641559}, /*cmx*/
          {3.64326465,2.190590181,1.927868464,1.198165502}, /*cfx*/
          {-0.02574655006,0.000407032538,43.70427006,-0.08358475439,0.002300949017,0.01724063165}, /*cmy*/
          {0.5242118584,5.592074526,1.984341432,4.954290845}, /*cfy*/
          {-0.7872183125,0.0007473490709,526.8004213,0.2573719182,0.005264511073,0.2825542356}, /*cmz*/
          {5.214029123,3.775387464,3.469792367,2.815082511} /*cfz*/
     },
     {
          2461099.5,
          {0.3219204349,0.001169949292,525.7124404,1.220562166,-0.002123330765,0.2857821635}, /*cmx*/
          {3.044948294,1.465614678,1.913867751,0.09087401665}, /*cfx*/
          {0.02162383911,0.0006750849491,49.78936646,-0.4912307859,-0.001143889273,0.02996612268}, /*cmy*/
          {0.5717012081,-1.653361567,2.086759758,4.456314398}, /*cfy*/
          {-0.7353057502,0.0003658979426,526.3907462,1.192602868,-0.002144119424,0.2748707136}, /*cmz*/
          {4.620332747,2.999001155,3.484382054,1.628490712} /*cfz*/
     },
     {
          2461189.5,
          {0.4151542165,0.0006105261827,526.3157332,0.8214651642,-0.006740759137,0.269824502}, /*cmx*/
          {2.393404876,0.798596651,0.7988656387,5.289106911}, /*cfx*/
          {0.07583237476,-2.380129546e-05,79.88860224,-0.3024451233,-0.002879672897,0.04398983007}, /*cmy*/
          {0.4250386242,3.79557351,0.6787251401,3.391855579}, /*cfy*/
          {-0.6474897986,0.0001219399907,522.0878712,0.806117907,-0.00659808194,0.2693242043}, /*cmz*/
          {3.972533466,2.308682995,2.29971171,0.590992114} /*cfz*/
     },
     {
          2461279.5,
          {0.4042159167,-0.0009479313932,526.2567447,-0.6417349624,0.001574382614,0.2586104316}, /*cmx*/
          {1.879139171,0.3232520973,0.1914988381,4.309162746}, /*cfx*/
          {0.06355269296,-0.0003221808873,84.65493736,0.3199141806,0.0008374615769,0.04679419268}, /*cmy*/
          {6.241593408,3.387414367,-0.05145642594,2.338690031}, /*cfy*/
          {-0.6865218479,1.987842517e-05,521.2779795,-0.6300713374,0.001572152768,0.2365958152}, /*cmz*/
          {3.458345087,1.832417025,1.738539732,5.842701233} /*cfz*/
     },
     {
          2461369.5,
          {0.3903396651,0.0003471165795,525.7663634,-0.06088031517,0.006643381722,0.2670674968}, /*cmx*/
          {1.488678903,5.851240113,6.137934761,3.444718028}, /*cfx*/
          {0.04724570124,0.0003442091899,64.84051621,0.04635802921,0.002743876524,0.03311321524}, /*cmy*/
          {5.643005012,2.990205847,6.053875542,1.262161895}, /*cfy*/
          {-0.7013996281,-6.444034022e-05,523.8890921,-0.06566148224,0.006502704416,0.2681208092}, /*cmz*/
          {3.066336146,0.8996313146,1.352831956,5.063741226} /*cfz*/
     },
     {
          2461459.5,
          {0.4111046321,0.001538067108,526.1786105,1.160707393,-0.001272064876,0.2763281129}, /*cmx*/
          {0.9261369825,-0.6439747059,6.750048,2.364079639}, /*cfx*/
          {0.08480261851,0.0002529541736,81.12589004,0.460462732,-0.0009283422594,0.04395694183}, /*cmy*/
          {5.249170327,5.487801016,6.562986054,0.4344215136}, /*cfy*/
          {-0.6824253346,0.001440589588,521.8268474,-1.132854139,0.001316330264,0.2646609785}, /*cmz*/
          {2.505276634,-8.565480496,-1.08581537,3.912396731} /*cfz*/
     },
     {
          2461549.5,
          {0.545320602,0.0002043906977,526.8838965,1.043775626,-0.006374881049,0.2695720413}, /*cmx*/
          {0.26436929,4.945375334,-1.325576011,1.210675539}, /*cfx*/
          {0.1204240894,3.713526854e-05,118.9419958,0.3835675571,-0.002624664267,0.06396648285}, /*cmy*/
          {4.798699505,4.582966725,10.92410318,5.73781313}, /*cfy*/
          {-0.613716229,0.000845418698,514.2667,-1.031125262,0.006298706043,0.2672669141}, /*cmz*/
          {1.844547571,3.284015353,3.283699934,2.787921804} /*cfz*/
     },
     {
          2461639.5,
          {0.5987947613,-0.0005162894565,526.8210951,-0.3844666824,-0.00153703112,0.3150164616}, /*cmx*/
          {5.990876726,4.421540154,4.589660535,0.2130975591}, /*cfx*/
          {0.1321740051,-0.0001552513013,132.322586,-0.1981242457,-0.0005024838155,0.06804838166}, /*cmy*/
          {4.293983786,4.136385529,4.640017038,4.97883725}, /*cfy*/
          {-0.5661644003,-0.001049393611,510.4010808,0.3905170971,0.00144810006,0.2882608862}, /*cmz*/
          {1.286531368,2.703528071,3.032308298,1.731314892} /*cfz*/
     },
     {
          2461729.5,
          {0.4756890668,0.0006023933485,526.4509972,-0.3889093701,0.007566314317,0.2722015837}, /*cmx*/
          {5.602369581,4.010414456,4.014658757,5.564603258}, /*cfx*/
          {0.1105075692,-2.998967295e-05,111.6649004,-0.166242266,-0.00301025582,0.06155881518}, /*cmy*/
          {3.831425874,3.848246056,6.885341576,3.779362327}, /*cfy*/
          {-0.6591608072,0.0008818414981,515.4550302,0.3825817474,-0.007416375528,0.2661768515}, /*cmz*/
          {0.8992344914,2.339031897,2.353891451,0.8845668367} /*cfz*/
     },
     {
          2461819.5,
          {0.5205701959,0.0009620454258,526.6443377,1.038985837,0.001623995984,0.2690678146}, /*cmx*/
          {5.081682788,3.520210918,2.612450976,4.449744823}, /*cfx*/
          {0.1136729193,0.000366996903,120.3338676,0.4063976158,0.0009427492952,0.07505220318}, /*cmy*/
          {3.33745396,3.174988092,-35.96112732,2.729555672}, /*cfy*/
          {-0.6306582646,0.001149684659,513.5209993,-1.023104704,-0.001705109721,0.2508613825}, /*cmz*/
          {0.3786699169,1.86392087,0.8991398818,6.010456565} /*cfz*/
     },
     {
          2461909.5,
          {0.6220249378,0.0009763536698,527.3198472,1.223230791,0.005594648137,0.2690964669}, /*cmx*/
          {4.417204733,2.810110185,-0.2849259925,3.312451481}, /*cfx*/
          {0.1408844281,7.031418092e-05,156.2325501,0.4459868025,0.002261719646,0.09005306532}, /*cmy*/
          {2.779717012,2.228285406,-0.7813650886,1.651833434}, /*cfy*/
          {-0.4959114273,0.0007033795486,503.8811661,-1.201647104,-0.005472899217,0.2597400639}, /*cmz*/
          {5.99430898,1.137823281,-1.96977486,4.876440541} /*cfz*/
     },
     {
          2461999.5,
          {0.6913770502,-0.0003123570818,526.9899766,-0.03933040407,0.004425793215,0.2923145655}, /*cmx*/
          {3.818933917,1.980754729,5.450107288,2.467213613}, /*cfx*/
          {0.1532003687,-0.0001696905356,174.5264952,-0.05222615483,0.001516708728,0.07988625177}, /*cmy*/
          {2.227763171,1.927350854,4.893247436,0.8406564036}, /*cfy*/
          {-0.4350846489,1.784552055e-06,497.1495467,0.04689634409,-0.004455433632,0.2680652264}, /*cmz*/
          {5.39242617,-0.2178508093,3.802246785,4.000926956} /*cfz*/
     },
     {
          2462089.5,
          {0.6762386061,-0.0007564014402,527.0542676,-0.6877181252,-0.007799687836,0.2778340704}, /*cmx*/
          {3.415214501,8.145770529,5.003109257,1.465108887}, /*cfx*/
          {0.1467584292,6.215123785e-05,160.0011227,-0.2614612375,-0.002993947361,0.08101138455}, /*cmy*/
          {1.794993148,1.404369342,4.488958996,6.085024761}, /*cfy*/
          {-0.4914270048,-0.0006535540682,502.2888862,0.6811745963,0.007678328823,0.2645721678}, /*cmz*/
          {4.991136514,19.02943066,3.322927339,3.033369036} /*cfz*/
     },
     {
          2462179.5,
          {0.6356818504,0.00112023295,526.8135452,0.8545938208,-0.003048830893,0.3031306561}, /*cmx*/
          {2.940911771,1.400535107,4.041629197,0.352534051}, /*cfx*/
          {0.1601741756,-9.120251403e-05,159.6548055,0.3329349428,-0.001274190072,0.09699925374}, /*cmy*/
          {1.312008254,0.8415405733,3.033157295,5.121820994}, /*cfy*/
          {-0.5378940035,0.00155256797,502.2767252,-0.8424740027,0.002924514695,0.2767494857}, /*cmz*/
          {4.517656153,6.00208939,2.371451435,1.905415447} /*cfz*/
     },
     {
          2462269.5,
          {0.7421979704,0.0004090569555,527.4487389,1.346328665,0.004449485315,0.2955479471}, /*cmx*/
          {2.282181161,0.6760805974,3.94569215,5.49447274}, /*cfx*/
          {0.1747149314,-0.0004250805867,188.9650212,0.4955045895,-0.001864341669,0.114974084}, /*cmy*/
          {0.715245258,-0.1284973553,0.1438200598,3.945738122}, /*cfy*/
          {-0.4336478359,0.001882884334,492.3948274,-1.31859685,-0.004387908671,0.2801638927}, /*cmz*/
          {3.852588776,5.288505705,2.255194374,0.7525848976} /*cfz*/
     },
     {
          2462359.5,
          {0.795964607,-0.0005164034016,526.8500757,0.369777456,0.006821042736,0.2736787439}, /*cmx*/
          {1.646559382,0.0967535282,3.233353803,4.46599295}, /*cfx*/
          {0.1327576583,0.0001619421868,207.4453619,0.1117928707,-0.002376700532,0.106280982}, /*cmy*/
          {0.1207498,5.254391495,5.462324891,2.900610968}, /*cfy*/
          {-0.2704306824,-0.000728110053,484.5295592,-0.3613739768,-0.006684259423,0.246831587}, /*cmz*/
          {3.209141921,4.750178875,1.569246073,6.010662778} /*cfz*/
     },
     {
          2462449.5,
          {0.69778185,0.0005667543336,527.1536511,-0.8971197528,-0.006989717735,0.2790987937}, /*cmx*/
          {1.209484131,5.94850138,2.804331879,3.534425838}, /*cfx*/
          {0.1450894932,7.499254093e-05,200.9745468,0.3257572856,0.002661836084,0.1081394353}, /*cmy*/
          {5.958427665,8.308342868,5.154019653,1.942767401}, /*cfy*/
          {-0.3679690217,-4.579018825e-05,487.5969601,0.8763142924,0.006773263458,0.2603577369}, /*cmz*/
          {2.774326409,4.280138763,1.133581093,5.048639434} /*cfz*/
     },
     {
          2462539.5,
          {0.7462287492,0.0004600790939,526.8126365,0.5986117556,-0.004690635709,0.2885273802}, /*cmx*/
          {0.7820257139,5.552179676,2.07514135,2.585803073}, /*cfx*/
          {0.1698895805,-0.0002049613737,195.1549499,-0.2419588201,0.001793351557,0.1031434764}, /*cmy*/
          {5.511918505,1.647194593,4.111832749,1.043148949}, /*cfy*/
          {-0.4004960792,0.001367721373,489.3455918,-0.5762607906,0.004558451662,0.257998252}, /*cmz*/
          {2.349792036,3.863782508,0.427357128,4.152932778} /*cfz*/
     },
     {
          2462629.5,
          {0.7912466025,0.0006297572346,527.1359608,1.416358397,0.003251147733,0.2787985481}, /*cmx*/
          {0.1399526107,4.825804092,1.998477822,1.432209588}, /*cfx*/
          {0.1275070397,-0.0002602146683,215.426384,-0.5308282641,-0.001513736938,0.1185039459}, /*cmy*/
          {4.907618192,0.6689482908,4.333821432,-0.1050950919}, /*cfy*/
          {-0.2323512551,0.001167848672,481.580831,-1.366280102,-0.003112761024,0.2590114754}, /*cmz*/
          {1.69975582,3.160661652,6.545672507,2.956049116} /*cfz*/
     },
     {
          2462719.5,
          {0.8117265264,0.0003597526664,526.58747,0.7638436288,0.008122087515,0.2906375636}, /*cmx*/
          {5.756174378,4.161036854,1.019346363,0.2849089135}, /*cfx*/
          {0.1073422833,-0.0001409648028,229.7807657,-0.2716245675,-0.002962245877,0.1274283652}, /*cmy*/
          {4.279308932,-0.2378914004,2.972570781,5.111683056}, /*cfy*/
          {-0.1268082707,0.0002285891826,474.9814691,-0.7297325573,-0.007774564852,0.2612472924}, /*cmz*/
          {1.022007001,2.543167678,5.671412831,1.838126308} /*cfz*/
     },
     {
          2462809.5,
          {0.9029255213,-0.001118749197,526.6768045,-0.9265121122,-0.004662525008,0.3180968544}, /*cmx*/
          {5.271932116,3.724590982,0.5566273892,5.703521338}, /*cfx*/
          {0.1306177275,0.0002003598112,228.7447886,0.3425253334,0.001875932667,0.1343511233}, /*cmy*/
          {3.797843104,5.758124983,2.623033891,4.187589157}, /*cfy*/
          {-0.1655327855,-0.001031553737,475.8561212,0.8998305778,0.004548485927,0.2994791083}, /*cmz*/
          {0.5369120218,2.088471643,5.201094722,0.896458079} /*cfz*/
     },
     {
          2462899.5,
          {0.7955765047,0.000442223932,526.4794441,0.2548318756,-0.006506776555,0.2817195134}, /*cmx*/
          {4.883082377,3.454826391,0.01593036104,4.630548515}, /*cfx*/
          {0.1302932633,-0.0002943562049,223.3125642,-0.1249546367,0.002419366156,0.1219002546}, /*cmy*/
          {3.387943577,5.692406155,1.922834218,3.141394823}, /*cfy*/
          {-0.223991371,0.00105175788,477.4034348,-0.2430240614,0.006166007921,0.2427495799}, /*cmz*/
          {0.1542920684,1.757506988,4.660198777,6.186341253} /*cfz*/
     },
     {
          2462989.5,
          {0.8164612693,0.000217883048,526.6306158,1.419325762,0.002162512205,0.2718948217}, /*cmx*/
          {4.271127716,2.679982577,6.508176453,3.477451409}, /*cfx*/
          {0.1302346771,-0.0009508083255,234.1432578,0.5472517072,-0.00130801002,0.1273577167}, /*cmy*/
          {2.798226707,1.48565133,2.381216335,1.979043819}, /*cfy*/
          {-0.1801142697,0.002523532101,473.0530902,-1.338284472,-0.001877872486,0.2513025683}, /*cmz*/
          {5.817817792,1.042196326,4.78198287,4.977788423} /*cfz*/
     },
     {
          2463079.5,
          {0.8725595338,-0.0001673996505,526.033681,1.092677026,-0.008214538673,0.282005271}, /*cmx*/
          {3.58202762,1.969298089,1.973226494,2.3552423}, /*cfx*/
          {0.0556893366,-0.0001697481241,241.2339126,0.4090444285,0.003100576893,0.1277255321}, /*cmy*/
          {2.146686365,0.5282239692,3.702479465,0.9687125275}, /*cfy*/
          {0.02105802969,0.0005563719933,470.3807413,-1.023769056,-0.007709505479,0.2520228633}, /*cmz*/
          {5.117693289,0.3763877576,3.514145278,3.915191346} /*cfz*/
     },
     {
          2463169.5,
          {0.8085581358,0.0008928205574,525.8246155,-0.7388494902,0.001131320349,0.2766654233}, /*cmx*/
          {3.043511594,1.491322212,1.29775787,1.667748811}, /*cfx*/
          {0.01686467698,0.0004811605824,240.2873319,-0.2782360218,-0.0005165487179,0.1295626232}, /*cmy*/
          {1.620572284,0.07549421434,3.12726687,0.1156001097}, /*cfy*/
          {0.1073063509,-0.0009803286127,470.8127292,0.6986276141,0.001145436737,0.2593879419}, /*cmz*/
          {4.575992471,6.159871891,2.688009523,3.115492244} /*cfz*/
     },
     {
          2463259.5,
          {0.8453564492,4.374852012e-05,525.6835207,-0.1557128131,0.00811117747,0.3085634543}, /*cmx*/
          {2.675597493,0.8909640597,1.026587208,0.4969701254}, /*cfx*/
          {0.1004471922,-0.0003590699245,240.1910809,-0.05877818433,-0.003086391624,0.13859195}, /*cmy*/
          {1.230838824,5.205328665,2.784471618,5.369677193}, /*cfy*/
          {-0.0813600956,0.0008324855929,470.1198627,0.1422336425,-0.0075544426,0.2666821311}, /*cmz*/
          {4.213925186,5.721153507,5.714114791,2.036531583} /*cfz*/
     },
     {
          2463349.5,
          {0.8890854975,-0.0002207734897,525.814148,1.327760077,0.0016334042,0.3016282623}, /*cmx*/
          {2.107129872,0.526290578,17.77478722,5.642427642}, /*cfx*/
          {0.05794181318,-0.0005975992779,243.9003237,0.5302315805,0.001250273684,0.1432299478}, /*cmy*/
          {0.6741732309,-0.8307575492,3.630196886,4.184565516}, /*cfy*/
          {0.0312952017,0.001380144607,468.703506,-1.239451942,0.001282544898,0.2798225096}, /*cmz*/
          {3.641257251,5.205856936,19.25602818,0.8508536094} /*cfz*/
     },
     {
          2463439.5,
          {0.8331424869,-0.0001140360367,525.3802383,1.32705859,0.00738427281,0.3034750511}, /*cmx*/
          {1.408804882,-0.2127349368,-3.329984513,4.461566222}, /*cfx*/
          {-0.0179958233,-0.000472684017,241.9006853,0.5031394677,0.002809716866,0.1353130265}, /*cmy*/
          {0.0126380133,4.462862425,-4.9064257,3.091365847}, /*cfy*/
          {0.203151748,0.001084491785,471.1246258,-1.218282716,0.006758364213,0.2730342674}, /*cmz*/
          {2.934211051,4.515514726,4.534300831,6.022266297} /*cfz*/
     },
     {
          2463529.5,
          {0.8300884763,-0.0005922774983,524.5299988,-0.361318516,0.002835993484,0.2452870674}, /*cmx*/
          {0.8181608588,5.502102267,2.52933422,3.495507737}, /*cfx*/
          {-0.01489770602,0.0002413399141,235.8144586,-0.132414617,0.001113680993,0.1207514228}, /*cmy*/
          {5.728660539,3.803212563,0.830758325,2.093900368}, /*cfy*/
          {0.2202400755,-0.0008271256071,474.0826606,0.3200110559,0.002762326427,0.2423108745}, /*cmz*/
          {2.341645297,3.949725487,4.143341494,4.943633566} /*cfz*/
     },
     {
          2463619.5,
          {0.8524406015,0.0001612962901,524.8085432,-0.554531424,-0.008989868825,0.2906935377}, /*cmx*/
          {0.44532155,5.138596952,1.9995937,2.644072591}, /*cfx*/
          {0.003156377638,-2.822254615e-05,242.0219872,-0.2105078449,-0.003499844526,0.1318131103}, /*cmy*/
          {5.333709918,3.393946568,0.4228639143,1.260423785}, /*cfy*/
          {0.1594625524,0.0001708070949,470.4931173,0.5147105846,-0.008310979499,0.2544580437}, /*cmz*/
          {1.970288738,3.612859114,3.579278906,4.176914719} /*cfz*/
     },
     {
          2463709.5,
          {0.8245014816,-0.0004064012715,524.6835239,1.144823632,-0.002416578108,0.2834587662}, /*cmx*/
          {6.214261569,4.655038016,0.6610728033,1.587583654}, /*cfx*/
          {-0.002986408441,-0.0009200798021,243.4137299,0.4624220969,0.001331852003,0.1347251247}, /*cmy*/
          {4.821644996,3.137994605,1.785979957,0.1687124404}, /*cfy*/
          {0.1655910257,0.002357102791,469.9144381,-1.053421829,-0.001939978525,0.263774469}, /*cmz*/
          {1.455229039,3.073906505,2.350029368,3.071077018} /*cfz*/
     },
     {
          2463799.5,
          {0.7862397367,-0.0008085363049,524.6629047,1.447605366,-0.005940642861,0.2871020895}, /*cmx*/
          {5.521306349,3.901881896,-2.305807846,0.3665169786}, /*cfx*/
          {-0.05556609895,-0.0004383387129,232.3838035,0.5523333521,0.002334207829,0.1278303234}, /*cmy*/
          {4.166510716,2.128857513,5.420670071,5.346028213}, /*cfy*/
          {0.3212928179,0.001311265666,476.7678057,-1.324872398,-0.005446685102,0.2621102205}, /*cmz*/
          {0.7591699428,2.379502286,-0.693034954,1.917583125} /*cfz*/
     },
     {
          2463889.5,
          {0.7205113977,0.001297449513,523.5484163,0.1155700654,-0.006108198308,0.300813136}, /*cmx*/
          {4.889421141,3.483683471,3.37155099,5.567012454}, /*cfx*/
          {-0.1134146467,0.000300351821,217.6238525,0.045617415,0.002382812507,0.1282036606}, /*cmy*/
          {3.570080616,1.716759037,4.56773473,4.19131028}, /*cfy*/
          {0.4595999038,-0.0008567124843,483.6000762,-0.1044955285,-0.005556426498,0.2948705262}, /*cmz*/
          {0.1281854217,1.866528629,4.998128535,0.7862482432} /*cfz*/
     },
     {
          2463979.5,
          {0.7869132183,-0.0001030483276,524.0028859,-0.8581765105,0.008630155945,0.2961280419}, /*cmx*/
          {4.485085863,2.931250885,2.932366889,4.71539809}, /*cfx*/
          {-0.06659272426,-7.531411869e-05,226.6090253,0.3364498579,-0.003335189426,0.1308755423}, /*cmy*/
          {3.146528717,4.152706843,4.278126494,3.365998485}, /*cfy*/
          {0.3372317523,7.397900245e-05,479.4263203,0.7798991697,0.007851139121,0.2714749761}, /*cmz*/
          {6.005801346,1.437405561,4.553889321,6.247578204} /*cfz*/
     },
     {
          2464069.5,
          {0.7916033504,-0.0009553160922,523.7967886,0.8710032351,0.003674281303,0.2674023556}, /*cmx*/
          {4.027337033,2.488758988,2.001963109,3.616716549}, /*cfx*/
          {-0.05882023284,-0.0003616649375,231.3635278,-0.34583929,-0.001663619572,0.1161564455}, /*cmy*/
          {2.679566583,3.97994095,3.00530404,2.27415762}, /*cfy*/
          {0.3304635827,0.001008751605,476.7227944,-0.7869477558,0.003329493874,0.2543480419}, /*cmz*/
          {5.547049099,0.9397336995,3.691896846,5.103878908} /*cfz*/
     },
     {
          2464159.5,
          {0.7056728482,-0.0008195445239,523.968208,1.473853568,-0.004394440609,0.2746701056}, /*cmx*/
          {3.355535217,1.748634709,1.931195114,2.409331589}, /*cfx*/
          {-0.1102782738,-0.0002518348756,213.6096349,-0.5609144417,0.001833485745,0.1025206287}, /*cmy*/
          {2.047195009,2.934832885,3.261887708,1.234997732}, /*cfy*/
          {0.4649083254,0.001282478708,486.0786223,-1.345341336,-0.003978260926,0.2617774792}, /*cmz*/
          {4.877873182,0.2427378236,3.548125903,3.961178894} /*cfz*/
     },
     {
          2464249.5,
          {0.6308998127,-0.0004586596638,523.3408062,0.5413364154,-0.00777719072,0.2897720103}, /*cmx*/
          {2.695767957,1.123976264,1.123908177,1.452028497}, /*cfx*/
          {-0.1180346865,-0.0002003887008,188.9335068,-0.2014776587,0.003058270757,0.11112541}, /*cmy*/
          {1.439207974,2.165789334,2.076104223,0.1670288632}, /*cfy*/
          {0.5548447652,0.0004087072397,495.9013052,-0.492069571,-0.007050984515,0.2814940482}, /*cmz*/
          {4.223699162,5.912013457,2.787166153,2.976577037} /*cfz*/
     },
     {
          2464339.5,
          {0.6351863359,0.000701155499,523.5981962,-0.9555202981,0.006613752026,0.2696225835}, /*cmx*/
          {2.244105959,0.7031771499,0.6976542771,0.5849873079}, /*cfx*/
          {-0.129660195,0.0002361712667,194.5494407,0.3915264651,-0.002566531816,0.1156257571}, /*cmy*/
          {0.9754265163,1.676083802,1.775812439,5.619501995}, /*cfy*/
          {0.5735972768,-0.001042139116,493.9912222,0.8743451144,0.006098040577,0.2617319778}, /*cmz*/
          {3.770486905,5.51744884,2.348603011,2.125575998} /*cfz*/
     },
     {
          2464429.5,
          {0.6967696999,-0.0005519652291,523.2670709,0.5138507165,0.005167780443,0.2993075665}, /*cmx*/
          {1.83213488,0.3259726315,0.02824496599,5.761153888}, /*cfx*/
          {-0.1126034604,-0.0002784393365,207.033481,-0.2005503878,-0.002135653582,0.114856063}, /*cmy*/
          {0.5398877231,1.745357305,0.9147104478,4.416763293}, /*cfy*/
          {0.4653591865,0.001509466741,488.2555386,-0.4699167752,0.004698711095,0.2870115132}, /*cmz*/
          {3.35540683,5.081628695,1.685931798,0.9803774713} /*cfz*/
     },
     {
          2464519.5,
          {0.63622248,-0.001551569323,523.6685026,1.416522329,-0.002903751556,0.2990241083}, /*cmx*/
          {1.195783699,5.883352494,6.248739964,4.572294875}, /*cfx*/
          {-0.1268708356,-0.0001468529658,186.5532636,-0.5353910047,0.001371483509,0.09143330316}, /*cmy*/
          {-0.05601148747,0.5991525013,1.231167119,3.344150508}, /*cfy*/
          {0.5634268237,0.001493762293,497.1384658,-1.294890843,-0.002594725246,0.2917767666}, /*cmz*/
          {2.724430459,4.392164856,1.636029859,-0.1413373945} /*cfz*/
     },
     {
          2464609.5,
          {0.4714951217,0.0003059499793,523.5606024,0.8583167298,-0.007959203236,0.2882749389}, /*cmx*/
          {0.5218097889,5.211966349,5.211437716,3.521948479}, /*cfx*/
          {-0.1352032814,0.0001616142083,153.1921722,-0.3267429901,0.003245319769,0.08076176637}, /*cmy*/
          {5.630678107,-0.2894702314,-0.3599744164,2.35581336}, /*cfy*/
          {0.7186607833,-0.0003899342735,508.1697039,-0.7925360416,-0.00731895011,0.2786210711}, /*cmz*/
          {2.060145543,3.715894822,0.5858617653,5.068850222} /*cfz*/
     },
     {
          2464699.5,
          {0.476879133,0.0008920096588,523.7956619,-0.8369881314,0.003468366356,0.2587508534}, /*cmx*/
          {0.01902535008,4.767063801,4.737604102,2.479308871}, /*cfx*/
          {-0.1155216298,-0.000180934037,150.0064932,0.3700919123,-0.001395554714,0.0779017705}, /*cmy*/
          {5.134764971,5.445149824,5.440586066,1.510143984}, /*cfy*/
          {0.6285720472,-2.53612005e-05,509.0345686,0.7650949889,0.00320401138,0.2696723975}, /*cmz*/
          {1.558451464,3.284855964,0.06574920144,4.074887218} /*cfz*/
     },
     {
          2464789.5,
          {0.5818467191,-0.0009696976821,523.1450099,0.12942013,0.006477528438,0.2840756314}, /*cmx*/
          {5.916658584,4.597845302,4.231051498,1.693575495}, /*cfx*/
          {-0.1305207348,-1.025190706e-05,170.6801311,-0.06561497636,-0.002615269663,0.09630292719}, /*cmy*/
          {4.700189613,12.73869673,4.991641489,0.4536181713}, /*cfy*/
          {0.6294388719,0.0003841760534,502.3019113,-0.1211006545,0.005925408458,0.2752118102}, /*cmz*/
          {1.166764042,2.954812594,5.895330939,3.197838108} /*cfz*/
     },
     {
          2464879.5,
          {0.4765447311,-0.001271163254,523.6450274,-1.283197049,-0.001606632712,0.277524927}, /*cmx*/
          {5.325242275,0.6033359137,4.589900248,0.5187629311}, /*cfx*/
          {-0.1318390488,0.0003964492337,152.5577427,0.4876823451,-0.001090549965,0.07837766469}, /*cmy*/
          {4.15094652,-4.870209281,-10.0379153,5.698265683}, /*cfy*/
          {0.7078716354,0.0006919323052,508.2919784,1.192270454,-0.001574336682,0.2775221075}, /*cmz*/
          {0.5809189893,-0.8900173978,6.285516777,2.083787453} /*cfz*/
     },
     {
          2464969.5,
          {0.3469888076,-0.0007859577125,524.1389024,-1.068722846,0.007256126171,0.2870745118}, /*cmx*/
          {4.649521054,-0.09432608298,-0.08779226757,5.680135163}, /*cfx*/
          {-0.08731316245,-4.36082104e-05,113.7118832,0.4174659443,0.003057690246,0.05963999883}, /*cmy*/
          {3.600793871,0.4637821606,-15.28758107,4.647462045}, /*cfy*/
          {0.7300707777,0.000856590734,518.1186016,0.9981986034,0.006737368139,0.2760288462}, /*cmz*/
          {-0.08382722658,4.677830042,1.553134922,0.9501356627} /*cfz*/
     },
     {
          2465059.5,
          {0.3604639304,0.0007957532,524.13029,0.5576404064,0.0002669401275,0.312453868}, /*cmx*/
          {4.100589994,5.682171809,-17.82572865,4.642715546}, /*cfx*/
          {-0.1067947519,-0.0001918666505,100.1123303,-0.2784434337,-0.0003113550981,0.05656203249}, /*cmy*/
          {3.115575495,6.083146848,26.60029551,3.512476114}, /*cfy*/
          {0.8117485449,-0.0008389166681,520.582232,-0.5051957114,0.0002834462692,0.3222815442}, /*cmz*/
          {5.654806615,4.192371922,40.00339774,-0.01243710212} /*cfz*/
     },
     {
          2465149.5,
          {0.390072569,3.380458652e-06,523.6798546,0.2370928119,-0.007249444638,0.2765859831}, /*cmx*/
          {3.719307076,5.230307675,-32.44413453,3.763483879}, /*cfx*/
          {-0.118547032,0.000218410725,124.2303914,-0.1445501367,0.003014623014,0.06475416044}, /*cmy*/
          {2.627237643,5.651255482,30.97434556,2.71377337}, /*cfy*/
          {0.726867201,0.0004222929067,515.3973254,-0.217355066,-0.006767375071,0.2741142247}, /*cmz*/
          {5.266242304,3.773839644,13.17978362,5.290288748} /*cfz*/
     },
     {
          2465239.5,
          {0.3750668566,-0.001629896282,523.8433254,-1.103003482,-0.001395334772,0.2675067024}, /*cmx*/
          {3.177303043,4.759413288,3.511993328,2.583868632}, /*cfx*/
          {-0.09363791834,0.0003435181409,113.521202,0.4225650785,0.001041249222,0.04864660103}, /*cmy*/
          {2.126486805,5.372430022,-2.362427774,1.862069487}, /*cfy*/
          {0.7021606194,0.001196722475,517.9028065,1.034279684,-0.001419650225,0.2769784715}, /*cmz*/
          {4.727405057,3.243189927,-1.133914191,4.170811892} /*cfz*/
     },
     {
          2465329.5,
          {0.2366833508,-0.000668999202,524.8214478,-1.18621806,0.006052564506,0.2773955652}, /*cmx*/
          {2.509333535,4.048064314,4.078763033,1.490030481}, /*cfx*/
          {-0.06203770004,0.0003722082121,74.58745205,0.4741964973,0.002625268589,0.03179032213}, /*cmy*/
          {1.704208715,4.416580696,1.288470521,1.067203531}, /*cfy*/
          {0.8182998414,-6.069188384e-05,524.658702,1.131978172,0.005773496461,0.2665834572}, /*cmz*/
          {4.070201314,2.507430724,-0.5913005737,3.045871171} /*cfz*/
     },
     {
          2465419.5,
          {0.09119224969,0.001196436158,524.7297877,0.1889041626,0.003184450513,0.2800718518}, /*cmx*/
          {1.923594365,3.429668804,3.60776003,0.6256545726}, /*cfx*/
          {-0.01575125691,-0.0003695285754,55.65645345,-0.1360729836,0.001410471073,0.04477183736}, /*cmy*/
          {1.398993678,3.581693672,0.9002775439,-0.2132074893}, /*cfy*/
          {0.8193937116,0.0003148944592,526.3781319,-0.1803576877,0.00294181629,0.2914800644}, /*cmz*/
          {3.489403315,1.933961495,5.189261851,2.247873464} /*cfz*/
     },
     {
          2465509.5,
          {0.2473421219,-8.012993845e-05,524.5546995,0.5329894746,-0.00735747081,0.2867065196}, /*cmx*/
          {1.526754582,3.1091046,3.107332263,5.921242242}, /*cfx*/
          {-0.05604814811,-0.0001122689973,73.46204906,-0.2739948745,-0.003155432527,0.04136502133}, /*cmy*/
          {0.7218602466,3.454377208,0.3528996782,5.073317501}, /*cfy*/
          {0.7837322555,2.477133384e-05,524.4212894,-0.4969578692,-0.006932235692,0.2829528519}, /*cmz*/
          {3.087797835,1.58755866,4.718030425,1.194392569} /*cfz*/
     },
     {
          2465599.5,
          {0.2545949032,-0.001258038526,524.44886,-0.8820600072,-0.0022715314,0.2921445986}, /*cmx*/
          {1.03332561,2.629144144,2.045386924,4.783247238}, /*cfx*/
          {-0.06851391873,0.00065709395,72.79247151,0.3354981845,-0.001224360055,0.02681187045}, /*cmy*/
          {0.2388562164,3.050962464,5.27518544,4.184697873}, /*cfy*/
          {0.8342723576,-6.577905767e-05,524.3447643,0.8326272217,-0.002385883626,0.3020433972}, /*cmz*/
          {2.594232682,1.096479895,3.589273257,0.1041568732} /*cfz*/
     },
     {
          2465689.5,
          {0.09312371784,-0.00133388337,525.4302335,-1.243272443,0.004747207154,0.3003866142}, /*cmx*/
          {0.3812194521,1.92667285,2.014056252,3.659930331}, /*cfx*/
          {-0.001400034734,0.0005334084076,45.56174612,0.5018342517,0.002120834746,0.0157309611}, /*cmy*/
          {6.468818488,2.120757106,11.66009101,4.292607316}, /*cfy*/
          {0.8272050355,0.0005400314084,527.4183972,1.200140045,0.004560661836,0.2904676195}, /*cmz*/
          {1.950684953,0.3449766971,3.581062394,5.219862867} /*cfz*/
     },
     {
          2465779.5,
          {0.02836501303,0.0001449091798,525.6235461,-0.1758839464,0.005390984964,0.2579992519}, /*cmx*/
          {6.050127733,1.374679404,1.366482887,2.628550915}, /*cfx*/
          {0.03948645482,-0.0002597124086,46.01282006,0.02821696329,0.002355369726,0.03520546867}, /*cmy*/
          {6.622033708,2.059231053,4.675695432,3.155941266}, /*cfy*/
          {0.8137780894,-0.0002375173109,526.3743426,0.1683793653,0.005150132898,0.2633930598}, /*cmz*/
          {1.340999019,6.115628033,2.930681803,4.262491168} /*cfz*/
     },
     {
          2465869.5,
          {0.0675620927,0.0007136958435,525.5290849,0.7173248113,-0.006558980536,0.2761668256}, /*cmx*/
          {5.624826452,0.940690568,0.9397061941,1.747102003}, /*cfx*/
          {0.003297092459,-2.522958463e-05,41.57790238,-0.3579545659,-0.002889603254,0.02315524234}, /*cmy*/
          {5.797496187,7.41031769,4.263623779,1.979890291}, /*cfy*/
          {0.8196867223,0.0001903196757,527.1502256,-0.6907605456,-0.006351916955,0.2697199481}, /*cmz*/
          {0.9133715613,5.648601407,2.507759005,3.32464814} /*cfz*/
     },
     {
          2465959.5,
          {0.08011403506,-0.001208693169,525.1607687,-0.618910857,-0.003568402074,0.2763441853}, /*cmx*/
          {5.173831159,0.5053536715,0.1755132938,0.7598989437}, /*cfx*/
          {0.004956280652,0.0005727760731,43.15226178,0.2293217145,-0.001609677406,0.02656899844}, /*cmy*/
          {5.112935937,0.7390976837,3.304017725,0.7964951055}, /*cfy*/
          {0.7959837503,0.0007103537704,526.7748917,0.601359979,-0.003521463027,0.2848709212}, /*cmz*/
          {0.4611156949,5.231783494,1.670994849,2.36405764} /*cfz*/
     },
     {
          2466049.5,
          {-0.01937138808,-0.001298078593,526.0985834,-1.250649436,0.003428025777,0.2835142474}, /*cmx*/
          {4.54452633,-0.1902540127,6.272660975,5.917067727}, /*cfx*/
          {0.06630691884,0.0004767037441,50.2925274,0.5011228117,0.001610199271,0.02684462796}, /*cmy*/
          {5.311301666,-0.1640565939,3.250140114,6.876900293}, /*cfy*/
          {0.8150799808,-0.0004144203789,526.2432361,1.216721502,0.003288291496,0.274157156}, /*cmz*/
          {6.119805793,4.484104452,1.556984691,1.211961223} /*cfz*/
     },
     {
          2466139.5,
          {-0.1763111313,0.0009400242809,526.3180725,-0.4988498088,0.006613983949,0.2825813031}, /*cmx*/
          {3.909217642,5.47675341,5.477398686,4.778263576}, /*cfx*/
          {0.1132442606,-0.0002007760904,77.9827433,0.1608054021,0.002815596253,0.04570289904}, /*cmy*/
          {5.111031008,5.392313484,2.274848111,6.11275884}, /*cfy*/
          {0.810028855,0.0002961706418,522.0186412,0.496120335,0.006544695144,0.281145792}, /*cmz*/
          {5.48760558,3.860094159,0.7043354503,0.1000163831} /*cfz*/
     },
     {
          2458849.5,
          {-41.14913012,0.06873757426,1214.885182,2.902281278,-0.006914609181,17.51321454}, /*cmx*/
          {-2.136395301,-3.738266131,-3.511161704,-5.268086558}, /*cfx*/
          {-8.891058365,-0.01578596457,498.339925,1.100986754,-0.00279099548,6.818129428}, /*cmy*/
          {-0.3235244323,-21.38303929,-2.055096749,-3.432983063}, /*cfy*/
          {-31.8461806,-0.07198083557,1123.490759,-2.596460488,-0.005570781988,16.3238736}, /*cmz*/
          {-0.6124792541,7.321072125,-1.88008389,-3.735170242} /*cfz*/
     },
     {
          2458919.5,
          {-35.73018257,0.02313534215,1213.63229,1.987326129,-0.01683322443,17.37328193}, /*cmx*/
          {0.1709309138,4.863182224,4.864576062,5.821769934}, /*cfx*/
          {-9.947993185,-0.003395938785,457.5020728,0.7728546154,-0.006591636336,6.368799395}, /*cmy*/
          {2.01840131,5.905645597,-0.3737826836,1.400929332}, /*cfy*/
          {-37.18277877,-0.02156857301,1140.512296,-1.824103214,-0.01553218105,16.39740993}, /*cmz*/
          {1.69914603,3.362163078,0.2215177721,1.069753437} /*cfz*/
     },
     {
          2458989.5,
          {-34.11485428,-0.04288939594,1213.39802,-0.7037511394,-0.0088399504,17.41998198}, /*cmx*/
          {2.570204235,0.954563396,1.123891567,4.453165112}, /*cfx*/
          {-10.27824914,0.006525039798,440.9472259,-0.2962691901,-0.003221811745,6.43015053}, /*cmy*/
          {4.430893729,1.959546265,2.233940191,0.02655392981}, /*cfy*/
          {-38.8483711,0.0433104908,1146.282157,0.7041442764,-0.007283998823,16.29635884}, /*cmz*/
          {4.099318674,5.740294477,2.809545657,5.983474924} /*cfz*/
     },
     {
          2459059.5,
          {-37.24750901,-0.02672246273,1213.437951,-1.984207591,0.01556226703,17.34679259}, /*cmx*/
          {5.091623023,3.527545295,3.514697235,3.15210056}, /*cfx*/
          {-9.769101919,0.003956677721,466.8236568,-0.7816501082,0.006071283005,6.860988254}, /*cmy*/
          {0.6484274855,4.660093493,4.674495605,4.989741039}, /*cfy*/
          {-35.55405715,0.02358331242,1136.622502,1.834308571,0.01448927631,16.15643082}, /*cmz*/
          {0.3352353755,2.056697462,5.195817343,4.682259695} /*cfz*/
     },
     {
          2459129.5,
          {-39.33415578,0.04671298787,1213.494483,0.4818657962,0.01385156392,17.33628532}, /*cmx*/
          {1.308363875,6.131290868,5.904351066,1.736926971}, /*cfx*/
          {-9.431685463,-0.00885876611,483.5069851,0.1905780882,0.005563600125,6.728952499}, /*cmy*/
          {3.135951762,1.238801241,0.6443379469,3.576167347}, /*cfy*/
          {-33.5907734,-0.04664546776,1128.344373,-0.4389427443,0.01276499935,16.15618132}, /*cmz*/
          {2.833855617,4.66454146,1.253185276,3.262659956} /*cfz*/
     },
     {
          2459199.5,
          {-35.9768213,0.08195104233,1213.791472,2.571801761,-0.002561094899,17.55772485}, /*cmx*/
          {3.673708454,2.096007132,-9.278316469,0.2246672673}, /*cfx*/
          {-10.20268878,-0.004993511739,459.4015325,-1.005128318,-0.001803518947,6.190597358}, /*cmy*/
          {5.520259328,0.01226229151,10.71721314,2.089906166}, /*cfy*/
          {-37.22951956,-0.06818359785,1140.423351,-2.320453496,-0.001585705031,16.54165302}, /*cmz*/
          {5.201414503,0.5854066358,17.64865644,1.75677385} /*cfz*/
     },
     {
          2459269.5,
          {-29.77981979,0.05715948142,1213.801872,2.523890013,-0.01356464242,17.37792508}, /*cmx*/
          {5.976993196,4.381577485,-1.866295413,4.995372826}, /*cfx*/
          {-10.4509563,0.002798359155,407.7336844,-0.9980708676,-0.005436723106,5.465436324}, /*cmy*/
          {1.583190656,2.133878686,24.19377432,0.6310446499}, /*cfy*/
          {-42.0987634,-0.03710527319,1159.505347,-2.344390931,0.01274085488,16.68728109}, /*cmz*/
          {1.227960337,2.890709913,-3.358111997,0.250213265} /*cfz*/
     },
     {
          2459339.5,
          {-25.40291034,-0.02680041047,1213.301734,0.4529187262,-0.01498552797,17.42549577}, /*cmx*/
          {2.049628563,0.5652848471,0.5241745392,3.589132514}, /*cfx*/
          {-10.21034357,-0.004114926422,370.2072051,-0.1728449242,-0.005997155989,5.355106986}, /*cmy*/
          {3.973196416,4.583077303,1.343634743,5.506372489}, /*cfy*/
          {-44.96914628,0.01683240237,1171.163029,-0.3890094344,0.0134644996,16.77488798}, /*cmz*/
          {3.58740242,5.30297614,5.29869567,5.123292493} /*cfz*/
     },
     {
          2459409.5,
          {-27.3150919,-0.05015334945,1213.109928,-2.021345537,0.008296097793,17.33076527}, /*cmx*/
          {4.528249854,2.954670209,2.847111741,2.283133119}, /*cfx*/
          {-10.39570408,-0.003766291192,384.9552614,0.7894008994,0.003141679521,5.799564981}, /*cmy*/
          {0.155170917,0.6801725841,3.648418812,4.181182455}, /*cfy*/
          {-43.4111174,0.0300550224,1167.040672,1.81991581,-0.007165574305,16.43431545}, /*cmz*/
          {6.065372818,1.507314467,1.470237612,3.816891337} /*cfz*/
     },
     {
          2459479.5,
          {-31.46624513,0.02382924406,1213.579827,-0.6362277099,0.01700598102,17.38297627}, /*cmx*/
          {0.7763252363,5.462607036,5.464331344,0.9126982227}, /*cfx*/
          {-10.64428189,0.0008778601959,418.8846627,0.2566987938,0.006835233461,5.946967448}, /*cmy*/
          {2.65623238,3.231690853,6.381723707,2.795631222}, /*cfy*/
          {-40.80964198,-0.01727994729,1154.614523,0.5912380155,-0.01575715954,16.54668815}, /*cmz*/
          {2.308733393,3.954174354,3.972338022,2.443744149} /*cfz*/
     },
     {
          2459549.5,
          {-29.72586986,0.08385311515,1213.362002,1.923551394,0.005680278918,17.50800607}, /*cmx*/
          {3.192428978,1.638670573,1.163877886,5.718856262}, /*cfx*/
          {-10.69130168,0.007502048664,406.7634494,-0.7873890702,0.002578732727,5.452292532}, /*cmy*/
          {5.083291912,5.691680801,1.669157161,1.342422845}, /*cfy*/
          {-42.24657468,-0.05420230274,1159.841292,-1.781811049,-0.00492677516,16.81820187}, /*cmz*/
          {4.726698824,0.130418983,-0.2325386021,0.9682426601} /*cfz*/
     },
     {
          2459619.5,
          {-23.58945397,0.08400940472,1214.352694,2.729341309,-0.009136909097,17.41818926}, /*cmx*/
          {5.509275802,3.915179872,4.037842749,4.187939736}, /*cfx*/
          {-10.10246999,0.01597336414,351.2177949,-1.103656668,0.003849385154,4.508580784}, /*cmy*/
          {1.16740342,1.522977135,1.774588841,6.17426579}, /*cfy*/
          {-46.08797022,-0.03792616092,1177.433194,-2.556681686,0.008784256667,16.97670365}, /*cmz*/
          {0.7671505587,2.430403921,2.570619857,5.731990218} /*cfz*/
     },
     {
          2459689.5,
          {-17.15434596,0.008261653198,1214.089104,1.432855372,-0.01629968102,17.4267046}, /*cmx*/
          {1.552639256,-0.01924279466,-0.02088431168,2.741051664}, /*cfx*/
          {-8.796184179,-0.0006911278538,294.8725578,-0.5785978731,0.006812246419,4.11886395}, /*cmy*/
          {3.559635188,3.75928501,3.729344403,4.758956902}, /*cfy*/
          {-48.92993359,-0.004206052271,1191.930382,-1.325941167,0.01514625535,17.14240843}, /*cmz*/
          {3.099571332,4.754576112,4.755698598,4.288089668} /*cfz*/
     },
     {
          2459759.5,
          {-16.62269064,-0.05453654102,1214.332562,-1.317019615,-0.002244418763,17.27265605}, /*cmx*/
          {3.980250898,2.402501527,2.925025722,1.407941655}, /*cfx*/
          {-8.806833077,-0.01363375693,286.603688,0.5670796063,0.001385022002,4.473158315}, /*cmy*/
          {5.998731464,6.088358399,7.299617926,3.400272123}, /*cfy*/
          {-48.91587539,0.0213587788,1193.255166,1.154368056,0.002888799215,16.87290346}, /*cmz*/
          {5.529392515,0.9001785585,1.320142731,2.945145051} /*cfz*/
     },
     {
          2459829.5,
          {-21.38478002,-0.01042381385,1214.63627,-1.568578328,-0.01694949748,17.47720646}, /*cmx*/
          {0.2278144716,4.971382279,8.108870354,0.07285124822}, /*cfx*/
          {-10.00994378,-0.0002482564778,327.8293191,0.6367237895,-0.007054472062,4.863579665}, /*cmy*/
          {2.19204089,2.563471776,8.821695686,2.023890543}, /*cfy*/
          {-47.11921668,0.004960293053,1183.570836,1.453212674,0.01572193088,16.97341275}, /*cmz*/
          {1.771293132,3.467963602,6.611729257,1.614401077} /*cfz*/
     },
     {
          2459899.5,
          {-22.20643939,0.07322324542,1213.747696,1.02188425,-0.01086340705,17.43845183}, /*cmx*/
          {2.697621684,1.169722664,4.105937625,4.91986598}, /*cfx*/
          {-10.09371689,0.0166412215,337.248772,-0.4517229201,-0.004425459293,4.543142923}, /*cmy*/
          {4.653914701,5.065233625,4.623520539,0.6155892081}, /*cfy*/
          {-46.72776221,-0.0351690567,1180.90667,-0.9835869648,0.009647718954,17.09974878}, /*cmz*/
          {4.240506247,5.961127009,2.610041538,0.1786178362} /*cfz*/
     },
     {
          2459969.5,
          {-17.06709827,0.09977833307,1215.0812,2.632797463,0.004446828678,17.46039703}, /*cmx*/
          {5.044438555,3.454714547,0.6766898982,3.393674533}, /*cfx*/
          {-8.95122879,0.02993426109,287.6999279,-1.099501336,0.002302655675,3.527496309}, /*cmy*/
          {0.7756609665,0.9184468512,1.592395359,5.475902886}, /*cfy*/
          {-49.26259938,-0.02770912439,1193.661359,-2.47311584,-0.004553521326,17.25742306}, /*cmz*/
          {0.3095950933,1.971211348,5.590627203,4.943022897} /*cfz*/
     },
     {
          2460039.5,
          {-9.560896152,0.0463752425,1214.988696,2.113846162,0.0142425474,17.42641672}, /*cmx*/
          {1.073973885,5.776169826,2.650044661,1.913718529}, /*cfx*/
          {-6.653530108,0.01390094289,219.6706647,-0.8896755736,0.006221714357,2.871682082}, /*cmy*/
          {3.209738206,3.096591546,3.094314158,4.104782841}, /*cfy*/
          {-51.37596016,-0.008003378926,1207.377395,-1.981006265,-0.01328665662,17.35970889}, /*cmz*/
          {2.629505833,4.248959247,1.125103285,3.470507327} /*cfz*/
     },
     {
          2460109.5,
          {-6.181029347,-0.039218814,1215.762095,-0.1756686848,0.01111749985,17.30403933}, /*cmx*/
          {3.455657686,1.819544323,5.085497684,0.530917346}, /*cfx*/
          {-5.64286687,-0.01589859772,187.2503724,0.1378453484,0.004445557265,2.939465956}, /*cmy*/
          {5.677259774,5.100175991,5.62162984,2.729880233}, /*cfy*/
          {-51.97697376,0.009860840638,1211.360635,0.1642373602,-0.01071097994,17.30910621}, /*cmz*/
          {5.0149182,-0.006742765789,3.622809914,2.086607119} /*cfz*/
     },
     {
          2460179.5,
          {-9.556978931,-0.04590715892,1216.080681,1.956504641,-0.01189852895,17.5540476}, /*cmx*/
          {5.956119754,20.13429629,1.275502033,5.504221538}, /*cfx*/
          {-7.062998156,-0.01348025212,216.1814,-0.8422782944,-0.005505604166,3.476096664}, /*cmy*/
          {1.808974962,4.926208195,1.734054594,1.293800463}, /*cfy*/
          {-51.45641798,0.01183886586,1207.910015,1.87064745,0.01154256701,17.36856464}, /*cmz*/
          {1.228650256,2.899236332,6.022188651,0.7709105848} /*cfz*/
     },
     {
          2460249.5,
          {-13.14184847,0.04779453873,1214.838104,0.03959466671,-0.01506352962,17.4376493}, /*cmx*/
          {2.185162769,3.234363145,3.717271734,4.106770111}, /*cfx*/
          {-8.089409457,0.01760851373,248.4382448,0.03024708964,-0.006333101377,3.411229823}, /*cmy*/
          {4.259782481,1.459922707,4.175000698,6.211226401}, /*cfy*/
          {-50.3589818,-0.01521511646,1201.52695,0.04957947017,0.01386630903,17.32504887}, /*cmz*/
          {3.738208553,4.028036134,2.183034829,5.661950541} /*cfz*/
     },
     {
          2460319.5,
          {-9.90145997,0.1002384696,1215.762559,-2.244995023,-0.002009720206,17.49027452}, /*cmx*/
          {4.575646284,-18.99502336,5.064310722,2.60425588}, /*cfx*/
          {-6.952166855,0.03895832902,216.490181,0.984458881,-0.001603225351,2.533119127}, /*cmy*/
          {0.4310755918,-9.113416757,-7.386747549,4.859933896}, /*cfy*/
          {-51.55176109,-0.01253657098,1207.537618,-2.096529996,0.002904058194,17.51194275}, /*cmz*/
          {6.131479926,-48.76241065,3.469866735,4.161766215} /*cfz*/
     },
     {
          2460389.5,
          {-2.350895995,0.07490416441,1215.912532,-2.485137269,0.01042423811,17.40356843}, /*cmx*/
          {0.6071149758,2.172935352,-4.018073689,1.102548755}, /*cfx*/
          {-4.032005756,0.02945593338,149.1295783,1.080351056,-0.00482008946,1.799593316}, /*cmy*/
          {2.985565997,5.635492448,-6.812704232,3.678768741}, /*cfy*/
          {-52.53727454,0.0003039364779,1217.102814,-2.366512582,-0.009850128682,17.47361302}, /*cmz*/
          {2.170356115,-2.523373692,0.7120280924,2.668074857} /*cfz*/
     },
     {
          2460459.5,
          {3.370038082,-0.009511439114,1217.117269,-0.9328492608,0.01548251843,17.46458358}, /*cmx*/
          {2.953191171,4.525343894,4.531390555,5.954817311}, /*cfx*/
          {-1.775859736,-0.00741584423,107.7850197,0.3591470348,-0.006706197392,1.559500077}, /*cmy*/
          {5.686206394,1.685890404,1.641094449,2.420001987}, /*cfy*/
          {-52.62623245,0.002288016399,1220.343043,-0.8849983721,-0.01470705671,17.5278034}, /*cmz*/
          {4.520952975,6.11863289,2.979850293,1.24096055} /*cfz*/
     },
     {
          2460529.5,
          {2.653477571,-0.0627877026,1217.005058,1.628552451,-0.002772724565,17.54009199}, /*cmx*/
          {5.406755406,0.7083139147,0.450056969,4.637936891}, /*cfx*/
          {-2.340851545,-0.02678086397,110.8414167,-0.7483743804,0.001950543307,1.935757881}, /*cmy*/
          {1.796338678,4.109254609,3.767700303,0.7916424716}, /*cfy*/
          {-52.68561422,-0.000121751355,1220.713962,1.61169286,0.003305674339,17.65278415}, /*cmz*/
          {0.6903612039,2.308459654,5.275529752,6.201016643} /*cfz*/
     },
     {
          2460599.5,
          {-2.582545605,0.01235109706,1216.465944,1.074849846,-0.01699769897,17.48925}, /*cmx*/
          {1.65330559,3.244207549,34.65781315,3.27810785}, /*cfx*/
          {-4.48650475,0.008144853683,145.4852008,-0.410767338,0.007458540815,2.113167506}, /*cmy*/
          {4.038096368,0.4846519185,6.713611707,5.661868379}, /*cfy*/
          {-52.45730552,-0.001199852685,1217.120735,1.017117161,0.01611251958,17.50297666}, /*cmz*/
          {3.217219889,4.827946094,1.690143449,4.842730439} /*cfz*/
     },
     {
          2460669.5,
          {-1.908565897,0.08680619405,1216.343621,-1.562221499,-0.006557040034,17.54275616}, /*cmx*/
          {4.095719677,5.682415845,5.396145582,1.81205028}, /*cfx*/
          {-4.032945419,0.03938594257,140.1459242,0.7445624427,0.002800988573,1.604336974}, /*cmy*/
          {0.2336141769,2.844295559,2.289665933,4.475349967}, /*cfy*/
          {-52.78235409,0.003729713234,1217.696081,-1.439274061,0.007094840711,17.65452238}, /*cmz*/
          {5.659315326,1.011891593,3.783426275,3.381857407} /*cfz*/
     },
     {
          2460739.5,
          {4.705646359,0.0907472277,1216.866695,-2.576535863,0.00613101505,17.39599647}, /*cmx*/
          {0.1452142683,1.720446058,2.025001952,0.3024351822}, /*cfx*/
          {-1.057533005,0.03934208185,97.19361491,1.150200899,-0.003287108432,1.368335069}, /*cmy*/
          {3.086352944,5.054041654,11.73585067,3.718784586}, /*cfy*/
          {-52.54817396,0.01555207484,1221.097022,-2.489657801,-0.005971468855,17.46852972}, /*cmz*/
          {1.714880291,3.280508519,6.749613384,1.87595939} /*cfz*/
     },
     {
          2460809.5,
          {11.78426076,0.02501971545,1218.809401,-1.779345405,0.01510547584,17.55149315}, /*cmx*/
          {2.46832546,4.015167473,4.018951002,5.117916048}, /*cfx*/
          {1.999310775,0.007785498333,99.40528907,0.7369708278,-0.006748146162,1.538790652}, /*cmy*/
          {6.2146044,0.9616811132,0.9489967909,2.738050569}, /*cfy*/
          {-51.35335946,0.006719767093,1220.221315,-1.738388728,-0.01478858476,17.58051426}, /*cmz*/
          {4.042312043,5.562240974,2.42224692,0.4092137535} /*cfz*/
     },
     {
          2460879.5,
          {13.87954723,-0.05284823322,1218.103964,0.7352720567,0.007179690417,17.55359302}, /*cmx*/
          {4.871940042,0.1083038569,0.3277147027,3.762534853}, /*cfx*/
          {2.67432175,-0.02525176759,110.7333132,-0.3923831491,-0.002610889974,1.368511272}, /*cmy*/
          {2.532956225,3.263044615,3.746471921,1.196141782}, /*cfy*/
          {-50.75759795,-0.0154974651,1218.876816,0.7127133975,-0.006842338254,17.6185893}, /*cmz*/
          {0.1638616477,1.69826904,4.954131377,5.340370568} /*cfz*/
     },
     {
          2460949.5,
          {9.189855615,-0.02643594475,1218.552746,1.818094703,-0.01508024478,17.54926794}, /*cmx*/
          {1.105143127,2.711279722,2.709229308,2.429300798}, /*cfx*/
          {0.4616405462,-0.008271677209,90.84215441,-0.7526973133,0.006963554911,1.258850705}, /*cmy*/
          {4.649367722,6.005464959,5.986170235,5.792891679}, /*cfy*/
          {-51.98139943,-0.00279995048,1221.017356,1.736520364,0.014316603,17.6267551}, /*cmz*/
          {2.678502174,4.266165304,1.123999301,4.002235473} /*cfz*/
     },
     {
          2461019.5,
          {7.062190292,0.06207031129,1217.191221,-0.5987130479,-0.01188904074,17.61474987}, /*cmx*/
          {3.597422341,5.259394361,5.056402311,1.013352577}, /*cfx*/
          {-0.223752795,0.03073377654,89.67873024,0.3634547345,0.004836023845,1.307135425}, /*cmy*/
          {0.5990582385,2.257789516,1.949749597,4.625731248}, /*cfy*/
          {-52.38292112,0.01308675218,1221.197395,-0.5410002472,0.0119781709,17.62379169}, /*cmz*/
          {5.168717036,0.4975467948,3.478716845,2.590619123} /*cfz*/
     },
     {
          2461089.5,
          {11.71786932,0.09662575084,1217.879774,-2.394879894,-0.002715387182,17.40857068}, /*cmx*/
          {5.963992412,1.267613601,-0.6911148276,5.791501938}, /*cfx*/
          {2.112058738,0.04189428854,104.39811,1.0963553,-0.002206070365,1.970117152}, /*cmy*/
          {3.522244814,4.476453308,-0.8063668793,3.646718389}, /*cfy*/
          {-51.3433961,0.03221713056,1219.195879,-2.345915441,-0.002947102922,17.36934324}, /*cmz*/
          {1.255508918,2.799361296,0.8509685151,1.086752231} /*cfz*/
     },
     {
          2461159.5,
          {19.07245216,0.05682974181,1220.169542,-2.34345812,0.01204669048,17.57757298}, /*cmx*/
          {1.995138672,3.534387904,-2.724210401,4.296336081}, /*cfx*/
          {5.280118327,0.02052359892,160.9652862,0.9824998945,-0.005548145228,2.683465215}, /*cmy*/
          {6.303167786,0.3186806715,0.3639674464,2.426433788}, /*cfy*/
          {-48.78226754,0.02566853061,1212.632613,-2.294597984,-0.01177080328,17.43712964}, /*cmz*/
          {3.572199105,5.054824545,1.956056341,5.87647904} /*cfz*/
     },
     {
          2461229.5,
          {23.42511008,-0.02351176494,1219.777143,-0.4303112146,0.01414455494,17.55786473}, /*cmx*/
          {4.355371052,5.970882559,5.958030279,2.892335257}, /*cfx*/
          {6.818048555,-0.01179812176,202.0104355,0.1013200048,-0.005544764271,2.753429271}, /*cmy*/
          {2.522010766,2.798762574,2.708936638,1.044341334}, /*cfy*/
          {-46.66859543,-0.01324781093,1205.373233,-0.4477174749,-0.01416413678,17.34963871}, /*cmz*/
          {5.933684906,1.208070135,4.313699222,4.471259031} /*cfz*/
     },
     {
          2461299.5,
          {21.28070335,-0.05459566833,1220.524406,1.923036365,-0.008007036795,17.65564294}, /*cmx*/
          {0.5491125313,2.160416661,2.133574378,1.560350311}, /*cfx*/
          {5.761343105,-0.02075316949,183.186666,-0.8230320676,0.004148117003,2.337436668}, /*cmy*/
          {4.956484565,5.217603892,5.173055431,5.92023438}, /*cfy*/
          {-48.11393637,-0.02042363063,1208.701459,1.86477885,0.007539285762,17.53788232}, /*cmz*/
          {2.127027576,3.646299986,0.4188014231,3.141681892} /*cfz*/
     },
     {
          2461369.5,
          {17.04733114,0.02829117079,1218.753013,0.5398166438,-0.01630114159,17.5942181}, /*cmx*/
          {3.074909022,4.59533144,4.6237357,0.2001675376}, /*cfx*/
          {4.178373088,0.01566515095,147.6395186,-0.1232438115,0.006755269386,2.214050898}, /*cmy*/
          {1.046760682,1.238269158,1.4122366,4.506888547}, /*cfy*/
          {-49.67572799,0.01111256257,1213.967592,0.5234579164,0.01593350003,17.45821907}, /*cmz*/
          {4.651900182,6.172099255,3.010282651,1.776858204} /*cfz*/
     },
     {
          2461439.5,
          {19.01216267,0.08987073615,1218.993478,-1.918332573,-0.005028754606,17.43691003}, /*cmx*/
          {5.489039617,0.8070657937,0.2186675428,4.996621598}, /*cfx*/
          {5.341465311,0.03625995735,169.7527717,0.9047699627,0.00231719688,3.008240323}, /*cmy*/
          {3.55096185,-2.395520601,2.678725996,3.164786727}, /*cfy*/
          {-48.76064286,0.04640618184,1210.455351,-1.908757438,0.004948517799,17.19119111}, /*cmz*/
          {0.7837265164,2.310895617,4.786319665,0.2937732088} /*cfz*/
     },
     {
          2461509.5,
          {25.63489666,0.07709403282,1220.715911,-2.627653285,0.007811250045,17.58340515}, /*cmx*/
          {1.526664823,3.075947226,3.218568206,3.488030183}, /*cfx*/
          {7.998869869,0.02355315437,236.6659585,1.093413221,-0.003993066474,3.879566237}, /*cmy*/
          {6.051334083,-0.2867662691,-0.02541081981,1.794546131}, /*cfy*/
          {-45.17343419,0.05165074047,1199.360872,-2.566232476,0.007338832244,17.12016826}, /*cmz*/
          {3.10422835,4.562017334,11.02133734,5.067506443} /*cfz*/
     },
     {
          2461579.5,
          {31.3277995,0.009740077041,1221.030086,-1.529184591,0.01670754107,17.5247525}, /*cmx*/
          {3.854693736,5.405884761,5.40779261,2.030110473}, /*cfx*/
          {9.683900582,-2.384415404e-05,293.9464466,0.5449892476,-0.00657774744,4.328696711}, /*cmy*/
          {2.187978149,1.889085981,1.911410011,0.3763346746}, /*cfy*/
          {-41.20814851,0.008440908122,1185.79736,-1.507419131,0.01644311155,17.00403849}, /*cmz*/
          {5.431383172,0.6042502325,0.5915281195,3.607455506} /*cfz*/
     },
     {
          2461649.5,
          {32.16715591,-0.05514959481,1221.234087,1.240218553,0.003090165745,17.73412916}, /*cmx*/
          {-0.004198928013,1.590184583,1.733941208,0.6820999895}, /*cfx*/
          {9.740413349,-0.01664143375,300.4728618,-0.5456119739,-0.0005922128013,4.048806727}, /*cmy*/
          {4.626859024,4.38767218,5.012892135,5.310927452}, /*cfy*/
          {-40.82153753,-0.04101998302,1183.545291,1.253754502,0.003096904728,17.17952693}, /*cmz*/
          {1.571709602,3.013573374,3.528348222,2.258579148} /*cfz*/
     },
     {
          2461719.5,
          {27.55897736,-0.005667854577,1220.390621,1.568913404,-0.01736027959,17.48687112}, /*cmx*/
          {2.525653685,4.114062243,4.11844428,5.640398078}, /*cfx*/
          {8.317738952,0.002017389998,261.1526506,-0.5528333773,0.007222341267,3.655185747}, /*cmy*/
          {0.8207229623,0.6776013421,7.013740691,3.921323931}, /*cfy*/
          {-43.91617193,-0.004736792637,1193.400283,1.560076517,0.01732029133,17.12148862}, /*cmz*/
          {4.103037274,5.609307202,8.738699435,0.9356985497} /*cfz*/
     },
     {
          2461789.5,
          {26.80297827,0.06988293504,1220.101494,-1.129848013,-0.01007253429,17.4747952}, /*cmx*/
          {4.994612489,0.3343640904,0.07355254584,4.194218107}, /*cfx*/
          {8.404976979,0.02311633086,257.283592,0.5796128283,0.003690942109,4.145349426}, /*cmy*/
          {3.276313354,3.288201353,2.640343563,2.516826364}, /*cfy*/
          {-44.4570996,0.05407990345,1193.713691,-1.134457847,0.009821948727,16.94638363}, /*cmz*/
          {0.2893082206,1.813967765,4.657324987,5.771455873} /*cfz*/
     },
     {
          2461859.5,
          {31.86698466,0.08129932167,1220.751626,-2.619522759,0.003552189305,17.52742839}, /*cmx*/
          {1.055184557,2.623252212,3.311043897,2.686546747}, /*cfx*/
          {10.13732158,0.0152896328,312.2232618,1.07487358,-0.00276299278,4.948128576}, /*cmy*/
          {5.691081773,5.39078324,12.46705928,1.075185108}, /*cfy*/
          {-40.56385952,0.07748448166,1181.139414,-2.571789281,-0.003084781359,16.76260229}, /*cmz*/
          {2.631124169,4.07951792,1.64763931,4.259094479} /*cfz*/
     },
     {
          2461929.5,
          {37.89096812,0.03330584618,1221.594844,-2.33624313,0.01489567809,17.5574089}, /*cmx*/
          {3.364134091,4.906318876,4.926071942,1.1812696}, /*cfx*/
          {11.25961816,0.0003353277266,373.1117721,0.8520046188,-0.005828120075,5.625455145}, /*cmy*/
          {1.780039142,1.16679961,1.225343446,5.901502853}, /*cfy*/
          {-34.88525948,0.04196504516,1163.715224,-2.312247223,0.01475488299,16.59089246}, /*cmz*/
          {4.936445237,0.07735507076,0.06942336192,2.754334727} /*cfz*/
     },
     {
          2461999.5,
          {40.66065379,-0.03065043905,1220.885691,0.0415633493,0.01327109752,17.63808653}, /*cmx*/
          {5.735832986,0.4838516569,1.067513167,6.080999693}, /*cfx*/
          {11.28968272,-0.002741033563,398.5121121,-0.08456845167,-0.004443295693,5.597976529}, /*cmy*/
          {4.177537029,3.648240899,3.607621325,4.522643116}, /*cfy*/
          {-31.49858621,-0.03902912366,1153.906904,0.08083593902,0.01274196992,16.69912607}, /*cmz*/
          {1.021924916,1.749342939,2.560128284,1.364042011} /*cfz*/
     },
     {
          2462069.5,
          {37.73053935,-0.0316827248,1220.801403,-2.118478011,-0.01287011872,17.42729875}, /*cmx*/
          {1.952953181,31.80800991,3.500457253,4.765392324}, /*cfx*/
          {10.89538489,-0.001816177375,376.3152577,-0.7865681078,0.00549959811,5.168271023}, /*cmy*/
          {0.3795033331,6.114107582,6.156704287,3.173501744}, /*cfy*/
          {-34.74381244,-0.03189423237,1162.183777,2.116553333,-0.01310469986,16.54772104}, /*cmz*/
          {3.524134519,23.87777741,5.001155121,6.338820819} /*cfz*/
     },
     {
          2462139.5,
          {35.12404353,0.03807614043,1220.692143,0.05795041704,-0.01530301488,17.48684721}, /*cmx*/
          {4.471026111,3.764313512,5.973802097,3.37515607}, /*cfx*/
          {10.7544087,0.007859343356,352.5634072,0.1622032953,0.005510058841,5.297918691}, /*cmy*/
          {2.871353421,3.050644049,2.196598255,1.787257341}, /*cfy*/
          {-37.59843908,0.04401410108,1168.665435,-0.0434389931,-0.01513498361,16.65073353}, /*cmz*/
          {6.044487651,1.751493961,1.142664063,4.945927421} /*cfz*/
     },
     {
          2462209.5,
          {37.90730797,0.07116103619,1220.62634,2.303185758,-0.004153751391,17.4320937}, /*cmx*/
          {0.5724937516,-26.11302471,1.29656085,1.881429126}, /*cfx*/
          {11.455747,0.0007811743613,384.7495059,-0.940424083,-0.002648006233,5.900275188}, /*cmy*/
          {5.279952313,1.623042313,-43.88766763,0.3227893501}, /*cfy*/
          {-34.57922245,0.09309688068,1158.778201,2.273915455,-0.003677890547,16.40365676}, /*cmz*/
          {2.143942924,-24.67333359,2.866064216,3.447392258} /*cfz*/
     },
     {
          2462279.5,
          {43.24764685,0.04318109993,1221.787737,2.803214808,-0.01047376506,17.58842884}, /*cmx*/
          {2.877539629,1.2741757,1.372614342,0.3497441997}, /*cfx*/
          {11.58376695,-0.01046418839,438.3314243,-1.046665124,-0.004425803184,6.59042781}, /*cmy*/
          {1.345891648,3.617500581,-5.603636094,5.118124862}, /*cfy*/
          {-27.90066186,0.07636073596,1141.049106,2.79222446,-0.01083290071,16.22927315}, /*cmz*/
          {4.443353236,2.733646493,9.066109189,1.908733833} /*cfz*/
     },
     {
          2462349.5,
          {46.51562546,-0.001897548222,1220.697018,1.257599008,-0.01835832875,17.50354377}, /*cmx*/
          {5.205821189,3.621044916,3.620929205,5.19486063}, /*cfx*/
          {10.6749959,0.0001306065729,470.4054809,-0.4149411798,-0.006546977567,6.750842535}, /*cmy*/
          {3.702270969,5.768992737,2.703508232,3.695049874}, /*cfy*/
          {-21.82082787,-0.0059957331,1126.968676,1.222164991,-0.01775786375,16.15760877}, /*cmz*/
          {0.4820571317,5.128665514,5.106408371,0.4690245656} /*cfz*/
     },
     {
          2462419.5,
          {46.15329385,-0.03916183956,1220.127849,-1.842668466,0.003133024624,17.33052425}, /*cmx*/
          {1.368160364,6.06236932,5.566897787,3.865573537}, /*cfx*/
          {10.75858245,0.00626324956,467.8204629,0.6944325974,0.001535893047,6.47323938}, /*cmy*/
          {6.150579494,2.096068185,5.230350212,2.342274664}, /*cfy*/
          {-22.7701668,-0.05625576833,1128.779311,-1.736835156,0.002147609212,16.0661009}, /*cmz*/
          {2.928149655,1.282183055,0.8189830728,5.418577873} /*cfz*/
     },
     {
          2462489.5,
          {43.35662759,0.003634802782,1220.726918,-1.230285553,-0.01914127092,17.48201471}, /*cmx*/
          {3.910137497,2.338250916,5.482853461,2.529727401}, /*cfx*/
          {11.35694827,0.0008444134895,443.6161149,0.3872327996,0.006980112259,6.386302418}, /*cmy*/
          {2.387873463,4.481942861,1.528567467,1.004489969}, /*cfy*/
          {-27.42955298,0.01097499727,1137.784945,-1.188107625,-0.01868261646,16.26441822}, /*cmz*/
          {5.474051394,3.837152177,76.05909493,4.092165782} /*cfz*/
     },
     {
          2462559.5,
          {43.72175777,0.04862782803,1220.131353,1.640386756,-0.009217302926,17.35440565}, /*cmx*/
          {0.06889648682,4.82970785,1.286860041,1.064824416}, /*cfx*/
          {11.55433069,-0.01325808429,451.9514183,-0.6832192743,0.003770439565,6.726026235}, /*cmy*/
          {4.829875317,0.9881129503,3.208341213,5.83316161}, /*cfy*/
          {-26.76839068,0.09145465403,1134.089389,1.61821049,-0.008490495267,16.05150844}, /*cmz*/
          {1.632129817,-0.02698069145,2.827257394,2.623886199} /*cfz*/
     },
     {
          2462629.5,
          {47.54099438,0.03797644917,1221.625324,2.952620709,0.005384401604,17.53493104}, /*cmx*/
          {2.3884594,0.7825927019,4.264376205,5.810011587}, /*cfx*/
          {10.68761451,-0.02601787873,490.0581548,-1.133930682,-0.003130311205,7.296391147}, /*cmy*/
          {0.895509326,2.961391698,6.690804783,4.328051362}, /*cfy*/
          {-20.17471273,0.100647141,1119.881358,2.907674403,0.005900398493,16.00332903}, /*cmz*/
          {3.9453179,2.268050676,5.673185953,1.072410478} /*cfz*/
     },
     {
          2462699.5,
          {50.15967578,0.01151720725,1220.178332,2.320660207,0.01799976181,17.38524574}, /*cmx*/
          {4.687824317,3.081081894,-0.05480132979,4.318825262}, /*cfx*/
          {8.608473034,-0.01254534144,517.9453206,-0.8301319039,-0.00661604245,7.447330108}, /*cmy*/
          {3.22209791,5.048177941,1.962548905,2.859848608}, /*cfy*/
          {-12.40387042,0.03913949427,1107.205241,2.196556054,0.01692204776,15.76139823}, /*cmz*/
          {-0.0475835373,4.60029016,1.453292896,5.861671471} /*cfz*/
     },
     {
          2462769.5,
          {51.16075606,-0.02151527665,1219.107034,-0.6676212139,0.01024580912,17.2692989}, /*cmx*/
          {0.7884209431,5.442848136,2.47764661,2.943528314}, /*cfx*/
          {7.707164688,0.01697288474,523.4290837,0.247762639,-0.003799778072,7.413754238}, /*cmy*/
          {5.619566844,1.253488405,4.378909588,1.482131684}, /*cfy*/
          {-9.529167337,-0.05864153708,1104.543006,-0.5677817229,0.010834149,15.80532688}, /*cmz*/
          {2.334066486,0.5761395557,4.022548933,4.48933649} /*cfz*/
     },
     {
          2462839.5,
          {49.63408674,-0.01111836458,1220.353131,-2.224940691,-0.01800034075,17.38867294}, /*cmx*/
          {3.313113568,1.774054359,4.916889068,1.653452761}, /*cfx*/
          {9.003347062,0.01119757694,512.8722327,0.7839878989,0.006628869063,7.247292701}, /*cmy*/
          {1.848415249,3.740482943,0.6921762844,0.1733355048}, /*cfy*/
          {-14.01234816,-0.03487970597,1109.336687,-2.126514676,-0.01732813346,15.85901106}, /*cmz*/
          {4.861844909,3.256643437,0.08457032253,3.199210389} /*cfz*/
     },
     {
          2462909.5,
          {48.71467453,0.02243427203,1219.237909,0.5901612513,-0.01496277599,17.31809881}, /*cmx*/
          {5.816730475,4.391665492,0.9507638891,0.2283168708}, /*cfx*/
          {9.89722216,-0.01930284748,508.7296501,-0.29546569,0.005581530221,7.393627786}, /*cmy*/
          {4.340103879,6.772933539,2.857548266,5.038234128}, /*cfy*/
          {-16.81338046,0.07117959213,1110.770117,0.5927984904,-0.0138232765,15.75426941}, /*cmz*/
          {1.084948095,5.752664869,2.479934856,1.779003583} /*cfz*/
     },
     {
          2462979.5,
          {50.69219476,0.02113173312,1220.634948,2.772463184,-0.00239647806,17.47106018}, /*cmx*/
          {1.889327574,0.2887300803,-4.27134088,4.984704556}, /*cfx*/
          {8.585390601,-0.03906626978,528.2715034,1.078611843,0.002607124185,7.761627943}, /*cmy*/
          {0.428633554,5.464631566,22.52904711,3.538180872}, /*cfy*/
          {-11.6619341,0.1114500825,1102.774102,2.646796342,0.002282685672,15.84345167}, /*cmz*/
          {3.435162424,1.803856269,-18.5943022,0.2429739004} /*cfz*/
     },
     {
          2463049.5,
          {52.016342,0.003382513963,1218.875724,2.990293643,0.01407065279,17.29668659}, /*cmx*/
          {4.177507011,2.573008138,-19.34731979,3.454432507}, /*cfx*/
          {5.64597974,-0.03089124047,544.7384388,1.105806205,0.00531952307,7.772417891}, /*cmy*/
          {2.742442059,1.221481356,-8.0420759,2.032082492}, /*cfy*/
          {-3.359736236,0.07932175541,1096.19856,2.776547589,-0.01287227834,15.60953368}, /*cmz*/
          {5.714554026,4.107252328,4.152936932,4.987013213} /*cfz*/
     },
     {
          2463119.5,
          {52.2633667,-3.606195929e-05,1217.530869,0.8697197046,0.01908787731,17.37124311}, /*cmx*/
          {0.2253380829,4.935088104,1.795930028,2.026715858}, /*cfx*/
          {3.20165717,0.01045919269,545.4358985,0.3181609826,0.007134957054,7.784778399}, /*cmy*/
          {5.094359326,3.432824469,0.3661005871,0.6166524276}, /*cfy*/
          {2.87573767,-0.02622948048,1095.878642,0.8283992691,-0.01791370286,15.66314239}, /*cmz*/
          {1.758351446,0.2700090263,0.2386408735,3.563602397} /*cfz*/
     },
     {
          2463189.5,
          {51.94195292,0.001610499965,1218.016177,-2.277459527,-0.008364395477,17.18015982}, /*cmx*/
          {2.696440776,1.143685609,4.208865916,0.73567965}, /*cfx*/
          {3.943713576,0.02600838615,544.1592265,-0.8840438844,-0.003562793546,7.753105315}, /*cmy*/
          {1.278583419,6.000487251,2.823663948,5.589202569}, /*cfy*/
          {0.9427016234,-0.06539801061,1096.705493,-2.2160187,0.008939530712,15.60503827}, /*cmz*/
          {4.228593317,2.673045759,2.553574204,2.273279138} /*cfz*/
     },
     {
          2463259.5,
          {51.85774444,0.002788333082,1218.060226,-0.7640539147,-0.01980281022,17.35744221}, /*cmx*/
          {5.24141275,3.624198248,0.4949373559,5.648184515}, /*cfx*/
          {6.07836501,-0.01171540738,544.925013,-0.2800223104,-0.007401907555,7.820261034}, /*cmy*/
          {3.80812361,1.990281288,5.41046348,4.215923591}, /*cfy*/
          {-4.50719742,0.03183455818,1095.734705,-0.6865352066,0.01824695525,15.59004315}, /*cmz*/
          {0.4957204355,5.22249284,5.171432469,0.9043837462} /*cfz*/
     },
     {
          2463329.5,
          {52.31560517,0.0006027621422,1218.601582,2.193155133,-0.006658104414,17.4765243}, /*cmx*/
          {1.371436154,6.07493606,2.511427431,4.15373171}, /*cfx*/
          {5.255019012,-0.04253742428,551.0044392,0.8480534241,-0.003469372856,7.952779689}, /*cmy*/
          {6.224935436,11.10304093,0.6848943132,2.742620436}, /*cfy*/
          {-2.152450887,0.1051602367,1092.90107,2.010639424,0.0064842993,15.70290177}, /*cmz*/
          {2.905932784,1.325753496,0.9699362666,5.691710377} /*cfz*/
     },
     {
          2463399.5,
          {52.17542279,-0.01891062176,1217.165746,3.240782166,0.008979774522,17.28335092}, /*cmx*/
          {3.669679404,2.075996095,5.476555709,2.602699726}, /*cfx*/
          {2.160787138,-0.04279113646,553.2093607,1.232030547,0.003825916404,7.781986955}, /*cmy*/
          {2.263379761,0.5659819421,4.147207347,1.215764245}, /*cfy*/
          {5.413397474,0.1047028928,1093.849676,2.978139853,-0.007958022565,15.64268979}, /*cmz*/
          {5.198583318,3.631442584,3.815123063,4.130736964} /*cfz*/
     },
     {
          2463469.5,
          {50.55826157,-0.004692445163,1216.244526,2.09231572,0.01985748345,17.3744349}, /*cmx*/
          {5.965277878,4.361933234,1.222362676,1.129614792}, /*cfx*/
          {-1.070518951,-0.009660761969,540.9362502,0.7910308945,0.007530826513,7.674711052}, /*cmy*/
          {4.58548114,2.692724391,-0.4269484306,6.040678493}, /*cfy*/
          {13.3508043,0.02415640422,1100.405961,1.933547598,-0.01828086741,15.76102747}, /*cmz*/
          {1.208019917,5.970026336,5.96550388,2.655733769} /*cfz*/
     },
     {
          2463539.5,
          {49.89705185,0.01882557724,1214.422475,-1.255456399,0.006340374164,17.19703071}, /*cmx*/
          {2.086026817,0.447007118,3.989999211,6.072146458}, /*cfx*/
          {-1.705645807,0.02396680275,534.2584062,-0.4972450396,0.002075508588,7.679330202}, /*cmy*/
          {0.7144168485,5.138923321,2.2114793,4.70228104}, /*cfy*/
          {14.97669929,-0.0601893757,1104.534429,-1.205885141,-0.004866330331,15.53289944}, /*cmz*/
          {3.610405146,2.103510232,2.338196114,1.323344785} /*cfz*/
     },
     {
          2463609.5,
          {51.64232407,0.001273306751,1216.467768,-2.00307994,-0.02054679731,17.43379672}, /*cmx*/
          {4.628379067,3.076957642,-0.06518082089,4.754242629}, /*cfx*/
          {0.4243257053,0.006484775129,546.8690446,-0.7609152398,-0.007804661041,7.906670852}, /*cmy*/
          {3.240889665,1.443524932,4.655399843,3.361465246}, /*cfy*/
          {9.666181431,-0.01667009067,1098.069015,-1.820205033,0.01872866941,15.69899341}, /*cmz*/
          {6.155023587,4.676198929,4.656603896,6.282595778} /*cfz*/
     },
     {
          2463679.5,
          {51.8603747,-0.0168187672,1216.038841,1.168297883,-0.01255303554,17.48571276}, /*cmx*/
          {0.826399029,5.581940692,2.199093892,3.313060516}, /*cfx*/
          {0.8934898105,-0.03386575469,553.0636855,0.4455502373,-0.005245855208,7.863390271}, /*cmy*/
          {5.714333732,4.181295566,0.4570758335,1.93050409}, /*cfy*/
          {8.461365598,0.08119957009,1093.902703,1.0283304,0.01196799961,15.68321535}, /*cmz*/
          {2.352103994,0.8210529469,0.703066592,4.840330826} /*cfz*/
     },
     {
          2463749.5,
          {50.65725619,-0.0457766276,1215.519005,3.07324299,0.004406416534,17.33632607}, /*cmx*/
          {3.158460653,1.578896096,5.556196998,1.76157834}, /*cfx*/
          {-1.525074115,-0.04156094129,544.0395396,1.193962672,-0.002743477882,7.533829673}, /*cmy*/
          {1.782336261,-0.08336191347,26.02445996,0.4084931104}, /*cfy*/
          {14.16974844,0.1091888677,1099.960462,2.815404941,-0.003362788392,15.81628344}, /*cmz*/
          {4.682715938,3.159737394,3.828287047,3.288841918} /*cfz*/
     },
     {
          2463819.5,
          {47.18574622,-0.03399862954,1215.16084,2.814334918,0.01561885144,17.34604746}, /*cmx*/
          {5.440601462,3.833325753,0.7260714453,0.2524094105}, /*cfx*/
          {-4.568595737,-0.02005394153,516.237215,1.064991113,-0.005947681147,7.18166673}, /*cmy*/
          {4.094594601,1.996390057,2.084949411,5.206321497}, /*cfy*/
          {22.27802765,0.06119416723,1113.612035,2.573856127,-0.01432136764,15.98468187}, /*cmz*/
          {0.6812158489,5.47036674,5.506743987,1.778555711} /*cfz*/
     },
     {
          2463889.5,
          {44.59562527,0.01774951124,1213.442934,0.2917088838,0.01669533208,17.30044618}, /*cmx*/
          {1.503977376,6.435181172,3.142505222,5.134345796}, /*cfx*/
          {-6.038087048,0.009673592645,492.2505525,0.1279123903,-0.00661887411,7.083094577}, /*cmy*/
          {0.180996775,4.432398796,4.354547669,3.808339442}, /*cfy*/
          {26.78382659,-0.03101649438,1125.08521,0.2899002636,-0.01547317563,15.91807779}, /*cmz*/
          {3.02968556,1.628825139,1.60344338,0.3741177563} /*cfz*/
     },
     {
          2463959.5,
          {46.53419575,0.02624018528,1215.17215,-2.463953394,-0.0137872022,17.55998106}, /*cmx*/
          {3.998791252,2.461606521,5.580184836,3.83154855}, /*cfx*/
          {-5.299785494,0.01840233174,504.9702248,-0.9336897553,0.005024648241,7.490142185}, /*cmy*/
          {2.665108395,0.5796360062,0.5645627853,2.486015904}, /*cfy*/
          {24.12235092,-0.05291023601,1119.927761,-2.189905227,0.01196840798,16.04230965}, /*cmz*/
          {5.523949312,4.091075019,4.059395954,5.360424519} /*cfz*/
     },
     {
          2464029.5,
          {48.39889634,-0.01957050107,1214.119039,-0.2095150566,-0.01803910321,17.4254422}, /*cmx*/
          {0.2501271644,4.688149565,1.753661538,2.451211864}, /*cfx*/
          {-3.843232146,-0.01638251365,526.0149402,-0.1041829046,0.007019054566,7.482301462}, /*cmy*/
          {5.180677186,2.574198618,3.069463014,1.099836125}, /*cfy*/
          {19.93401094,0.04464870563,1109.193746,-0.1941582224,0.01651400579,15.89565388}, /*cmz*/
          {1.772843947,0.3612843291,0.2715102478,3.970874283} /*cfz*/
     },
     {
          2464099.5,
          {47.2386685,-0.06546897518,1214.334935,-2.487944864,-0.004558554542,17.43395436}, /*cmx*/
          {2.638087333,-2.069029499,3.385111249,0.9277042638}, /*cfx*/
          {-5.015291492,-0.02818640846,515.6719416,0.9854863454,0.002626038111,7.049739765}, /*cmy*/
          {1.296746737,-0.7430842641,4.189960482,5.889588206}, /*cfy*/
          {22.94058899,0.09568462483,1114.345747,2.29812669,0.003454345899,16.08998316}, /*cmz*/
          {4.161852339,266.5795121,1.944420716,2.454399916} /*cfz*/
     },
     {
          2464169.5,
          {42.54422248,-0.06735181943,1213.998845,-3.077028717,0.01014874609,17.3250326}, /*cmx*/
          {4.929771367,0.195206111,6.642812954,5.682922465}, /*cfx*/
          {-7.131049639,-0.01417660047,475.9003858,1.172482814,0.004028747441,6.439565626}, /*cmy*/
          {3.620905591,1.320855512,4.788142695,4.398195437}, /*cfy*/
          {30.07712386,0.07536460515,1132.213972,2.794768233,0.009067249754,16.27138856}, /*cmz*/
          {0.1725933743,4.989383148,2.026655428,0.927631339} /*cfz*/
     },
     {
          2464239.5,
          {37.53333979,-0.005931165446,1213.92518,-1.634880159,0.0197693432,17.39749706}, /*cmx*/
          {0.9569705558,2.507193193,2.510571904,4.219796168}, /*cfx*/
          {-8.223925878,-0.0008754416512,431.4510865,0.6319339875,0.007710198,6.087104672}, /*cmy*/
          {5.968397893,3.495334306,0.3375749861,2.953437134}, /*cfy*/
          {35.92323351,0.002789199311,1150.606902,1.503442426,0.01810100695,16.52466584}, /*cmz*/
          {2.488097079,1.019257183,4.167486325,5.751808435} /*cfz*/
     },
     {
          2464309.5,
          {37.22001633,0.05249001578,1214.440408,1.727129405,-0.0006014971353,17.63446675}, /*cmx*/
          {3.386151263,4.987851559,3.848689339,2.901449658}, /*cfx*/
          {-8.403664678,0.007382300557,425.4072953,-0.693241355,0.0009793526269,6.472865358}, /*cmy*/
          {2.119119718,5.911894981,4.605546472,1.604297673}, /*cfy*/
          {36.31762184,-0.05485620241,1152.261503,-1.559826427,0.001197534467,16.49896467}, /*cmz*/
          {4.917897367,3.468076244,171.5425186,4.429729172} /*cfz*/
     },
     {
          2464379.5,
          {41.25401644,-0.001390923611,1213.615885,1.503388975,0.01994676011,17.40178967}, /*cmx*/
          {5.931865664,1.230399661,23.22379406,1.559925471}, /*cfx*/
          {-7.61633914,-0.0009739343913,461.4471015,-0.591934595,0.007770666993,6.695206768}, /*cmy*/
          {4.63614587,2.304143661,2.322878323,0.2593020011}, /*cfy*/
          {31.5860086,0.003177564533,1138.846157,-1.36756722,0.01810752107,16.29941646}, /*cmz*/
          {1.176215923,6.037797223,24.88139375,3.086136702} /*cfz*/
     },
     {
          2464449.5,
          {41.50080778,-0.06687794301,1213.775894,-1.530289775,0.009469104267,17.49083732}, /*cmx*/
          {2.10364689,3.692058152,0.282649188,0.09488589942}, /*cfx*/
          {-7.759899972,-0.009242004057,464.6248106,0.6115360119,0.003931322828,6.341982502}, /*cmy*/
          {0.8061644021,4.857244242,4.179150418,5.091357782}, /*cfy*/
          {31.68972789,0.06813629835,1136.660963,1.429110309,0.008269830025,16.47756574}, /*cmz*/
          {3.631207985,2.211502946,1.91444235,1.621541187} /*cfz*/
     },
     {
          2464519.5,
          {36.62554158,-0.08824679649,1213.323066,-2.943748821,-0.005196051685,17.30178536}, /*cmx*/
          {4.426629476,5.995102212,3.408287597,4.848780807}, /*cfx*/
          {-8.561890113,0.0006244433593,421.7166565,1.151440633,0.002721097666,5.543490429}, /*cmy*/
          {3.163029504,0.6592857008,4.635947548,3.62053706}, /*cfy*/
          {36.87558973,0.0721478371,1153.551359,2.681096372,-0.004525918969,16.60838099}, /*cmz*/
          {5.958400814,4.51214953,5.124065471,0.09897338038} /*cfz*/
     },
     {
          2464589.5,
          {29.91609272,-0.04102318811,1214.397507,-2.429369437,-0.01666924447,17.52288262}, /*cmx*/
          {0.4392039945,1.980870996,5.138415675,3.346352505}, /*cfx*/
          {-8.490133774,0.00265668987,360.7150568,0.9697750706,-0.006788341104,4.851957402}, /*cmy*/
          {5.513231952,2.747517611,2.744684871,2.151174377}, /*cfy*/
          {42.48727599,0.02757600116,1175.255045,2.243981844,0.01527371915,16.9862064}, /*cmz*/
          {1.978722625,0.4803203984,-2.65229213,4.888374592} /*cfz*/
     },
     {
          2464659.5,
          {26.58537009,0.04581013565,1213.976028,0.3019212126,-0.01224369261,17.52410926}, /*cmx*/
          {2.811596067,4.338922675,1.297994351,1.977117307}, /*cfx*/
          {-8.198401844,-0.008337495063,327.6522469,-0.1638961657,-0.004746467697,4.999042508}, /*cmy*/
          {1.637441011,4.823226537,5.26790135,0.7675399506}, /*cfy*/
          {44.6349223,-0.0281147613,1183.352477,-0.3098969596,0.01097303815,17.01487637}, /*cmz*/
          {4.354388049,2.793840331,6.135906117,3.514434557} /*cfz*/
     },
     {
          2464729.5,
          {30.68819678,0.03083651156,1213.924584,2.16447814,0.01519394335,17.48513871}, /*cmx*/
          {5.323867094,0.6368982683,3.769214136,0.652202649}, /*cfx*/
          {-8.82574042,-0.0003710183876,359.4227491,0.8782616685,0.00627233683,5.401376101}, /*cmy*/
          {4.11483641,4.596875557,1.432499872,5.704281598}, /*cfy*/
          {41.94476508,-0.02659225805,1175.37455,-2.013847016,-0.01427729583,16.8117124}, /*cmz*/
          {0.5800625985,5.4516927,2.306552826,2.18758551} /*cfz*/
     },
     {
          2464799.5,
          {33.2611662,-0.04867601024,1213.665271,-0.3229922121,0.0143571261,17.48572078}, /*cmx*/
          {1.552526982,3.19718672,6.198524158,5.535548357}, /*cfx*/
          {-8.96065499,0.004614819796,386.8651889,-0.131881457,0.005887873378,5.357627657}, /*cmy*/
          {0.3185490417,1.049087578,3.795815788,4.308131385}, /*cfy*/
          {39.98153328,0.03509383545,1165.264795,0.2936837907,-0.01327466266,16.90916143}, /*cmz*/
          {3.088393121,1.855263958,4.680296812,0.7887530945} /*cfz*/
     },
     {
          2464869.5,
          {29.59344153,-0.09481101888,1213.350605,-2.473364367,0.003323633965,17.30859051}, /*cmx*/
          {3.924858664,5.513730305,1.090142039,4.025990143}, /*cfx*/
          {-8.70269033,0.01595487818,353.6991928,-1.007723758,0.002342641453,4.515360507}, /*cmy*/
          {2.722619599,9.419897837,-1.484533071,2.874992606}, /*cfy*/
          {42.71413255,0.05728472852,1175.697103,2.265520433,-0.003405526193,16.93263791}, /*cmz*/
          {5.464755447,-2.252185981,-0.3151631238,5.56825526} /*cfz*/
     },
     {
          2464939.5,
          {22.33537061,-0.07326618921,1215.206628,-2.725368812,-0.01103964567,17.52876773}, /*cmx*/
          {-0.05744950868,1.48700178,-1.572559249,2.508773269}, /*cfx*/
          {-7.448012534,0.01723673165,284.712314,-1.131941448,0.004808264946,3.613803393}, /*cmy*/
          {5.103958524,5.226191933,-0.9226151501,1.423187094}, /*cfy*/
          {47.09970299,0.03450596606,1195.225391,2.579322514,0.01060121334,17.33642331}, /*cmz*/
          {1.49157402,-0.02205845935,-3.092562336,4.057141687} /*cfz*/
     },
     {
          2465009.5,
          {16.60659284,0.01123102569,1214.981363,-1.025110981,-0.01755154452,17.47288058}, /*cmx*/
          {2.276730735,3.848553771,0.7059404367,1.075674713}, /*cfx*/
          {-6.01451505,-0.006430928909,228.6724041,-0.4007383748,0.007394731989,3.298200602}, /*cmy*/
          {1.25227187,1.278358494,1.213503125,0.04140231733}, /*cfy*/
          {49.562432,-0.003603897433,1205.674313,0.9636763849,0.01638847732,17.34632111}, /*cmz*/
          {3.831506355,2.328740137,5.481368388,2.629896667} /*cfz*/
     },
     {
          2465079.5,
          {18.01997178,0.05974028062,1214.829681,1.88940105,0.004964416284,17.5193228}, /*cmx*/
          {4.732703404,0.02720077838,2.980782092,6.02602312}, /*cfx*/
          {-6.740974819,-0.01488919397,235.5994626,0.8146062285,-0.002503845368,3.724701675}, /*cmy*/
          {3.690535761,3.679268578,3.350187668,4.925444604}, /*cfy*/
          {49.26681841,-0.03014797058,1205.067425,-1.7515901,-0.004425807411,17.3715115}, /*cmz*/
          {6.287123522,4.840962779,1.634013645,1.290507858} /*cfz*/
     },
     {
          2465149.5,
          {22.59828181,-0.01453280067,1214.276858,0.919026164,0.01732159653,17.48260875}, /*cmx*/
          {0.9862922208,2.55276552,5.70045301,4.681013495}, /*cfx*/
          {-7.848580651,0.005016935706,281.0511353,0.3582050473,-0.007276776489,4.027305811}, /*cmy*/
          {6.150284456,6.354692936,6.298212738,3.560323925}, /*cfy*/
          {46.8683024,0.009247035113,1194.733687,-0.8755991853,-0.01628770528,17.22098172}, /*cmz*/
          {2.53487253,1.04212583,4.197559261,6.231217053} /*cfz*/
     },
     {
          2465219.5,
          {21.52181767,-0.08832551542,1213.961869,-1.704607993,0.006870591239,17.33844989}, /*cmx*/
          {3.418236132,5.034016914,1.430639907,3.208275015}, /*cfx*/
          {-7.482485052,0.02638077734,271.1842303,-0.7481067139,-0.003135317441,3.384797004}, /*cmy*/
          {2.315412098,2.462613136,1.726217614,2.180140453}, /*cfy*/
          {47.44216476,0.03771012131,1196.699711,1.572179667,-0.006806828605,17.22224492}, /*cmz*/
          {4.967985853,3.536151525,-0.08227896672,4.760909774} /*cfz*/
     },
     {
          2465289.5,
          {14.91566503,-0.09572124332,1216.17565,-2.678363089,-0.0054697785,17.48901689}, /*cmx*/
          {5.742316215,1.009609392,4.426630539,1.691563403}, /*cfx*/
          {-5.509025465,0.03328676389,206.7953189,-1.154108342,0.002792361547,2.443734452}, /*cmy*/
          {4.764494088,4.595893334,5.078776397,0.827750557}, /*cfy*/
          {50.21334755,0.02679900206,1209.57302,2.566190167,0.005686679412,17.54004643}, /*cmz*/
          {1.016771015,5.779109814,2.972831621,3.252129017} /*cfz*/
     },
     {
          2465359.5,
          {7.774124893,-0.0306052029,1216.88219,-1.95480922,-0.01689984173,17.47455422}, /*cmx*/
          {1.774229792,3.315562873,0.1708481903,0.2118182706}, /*cfx*/
          {-2.990542825,0.008971607544,141.558061,-0.8168636434,0.007474486907,1.825699694}, /*cmy*/
          {1.051149961,0.4989095654,0.4685519849,5.877499204}, /*cfy*/
          {52.0941772,0.002818868219,1217.921875,1.869761788,0.01607109759,17.51635657}, /*cmz*/
          {3.338387988,1.777193201,4.923718597,1.775347967} /*cfz*/
     },
     {
          2465429.5,
          {5.498740814,0.0608457262,1216.480118,0.8623458151,-0.006667962511,17.56236971}, /*cmx*/
          {4.17439247,5.723750566,2.760495155,5.126903543}, /*cfx*/
          {-2.370745991,-0.02564283215,122.8802719,0.4415329121,0.002591450891,1.946375025}, /*cmy*/
          {3.587073906,2.784428186,3.355390976,4.414634386}, /*cfy*/
          {52.579073,-0.01227742396,1219.198502,-0.7697532328,0.007004648787,17.65578433}, /*cmz*/
          {5.741065104,4.183919032,1.196026274,0.4115937561} /*cfz*/
     },
     {
          2465499.5,
          {10.31771141,0.02263198644,1216.214754,1.801697424,0.01603490269,17.39989343}, /*cmx*/
          {0.413676308,2.011829262,5.156080204,3.815933369}, /*cfx*/
          {-4.292971774,-0.006679330521,158.1400027,0.7568352774,-0.007243700062,2.483254098}, /*cmy*/
          {5.875681241,5.546043269,5.517127378,2.945582693}, /*cfy*/
          {51.30333944,-0.002757591532,1215.595525,-1.697378052,-0.01496201845,17.40683729}, /*cmz*/
          {1.976054373,0.4684432139,3.610742857,5.374917632} /*cfz*/
     },
     {
          2465569.5,
          {12.27664398,-0.06725273334,1215.313009,-0.6961650324,0.01139113806,17.39713997}, /*cmx*/
          {2.901423494,4.5774083,1.173254388,2.389159147}, /*cfx*/
          {-4.857292676,0.02789072418,176.0294372,-0.369006755,-0.004748296506,2.194340278}, /*cmy*/
          {2.013789969,1.796999553,1.437899108,1.622393282}, /*cfy*/
          {50.92762248,0.01599169768,1213.219584,0.6520435579,-0.01091428231,17.43320084}, /*cmz*/
          {4.461864235,3.048151278,5.920798796,3.953109307} /*cfz*/
     },
     {
          2465639.5,
          {7.375301768,-0.1030709929,1216.9794,-2.364221083,-0.001888022192,17.48814149}, /*cmx*/
          {5.264065439,0.5442788407,-38.76531097,0.8879511725}, /*cfx*/
          {-2.850491504,0.04312864339,132.5670422,-1.064772305,0.001694566868,1.516756846}, /*cmy*/
          {4.595554087,3.984831456,5.315181398,0.5324595085}, /*cfy*/
          {52.07080525,0.01078473323,1218.319631,2.263715687,-0.00275549662,17.56218352}, /*cmz*/
          {0.5459074479,5.296632068,-37.16196625,2.459562385} /*cfz*/
     },
     {
          2465709.5,
          {-0.141196515,-0.06408235947,1218.398484,-2.474701039,0.01323864861,17.48369524}, /*cmx*/
          {1.293923414,2.831853976,-3.430750672,5.662142758}, /*cfx*/
          {0.2942932902,0.02534734123,91.16940939,-1.069754312,-0.006129800485,1.361123099}, /*cmy*/
          {1.303655259,-0.1502728138,-28.39890186,6.077965262}, /*cfy*/
          {52.8433409,-0.005503197495,1221.790013,2.36425168,-0.01234729337,17.58135657}, /*cmz*/
          {2.864478056,1.25754559,-11.2678475,0.9510079837} /*cfz*/
     },
     {
          2465779.5,
          {-5.243357405,0.0314809251,1217.983573,-0.4038914173,0.0145041649,17.58540306}, /*cmx*/
          {3.650905704,5.261766424,5.24354654,4.25474827}, /*cfx*/
          {2.307723148,-0.01714336877,98.06707957,-0.1054626345,-0.006000446106,1.337369364}, /*cmy*/
          {4.232874056,2.496687462,-0.8933307753,4.79839024}, /*cfy*/
          {52.45031781,0.003391852269,1219.666077,0.4168813936,-0.0143799577,17.59446021}, /*cmz*/
          {5.224870011,3.715992413,3.672631083,5.830557432} /*cfz*/
     },
     {
          2465849.5,
          {-2.319535465,0.04848993142,1218.285078,1.929267155,-0.008808183307,17.30427492}, /*cmx*/
          {6.131489608,1.450267117,1.422731891,2.936315136}, /*cfx*/
          {0.802330398,-0.01953020226,89.65018267,0.8636293567,0.004614314331,1.372467487}, /*cmy*/
          {0.1875003138,11.03005523,1.538261395,2.997951059}, /*cfy*/
          {52.47578661,0.0004950627695,1220.535574,-1.898880862,0.008909636159,17.43791808}, /*cmz*/
          {1.420303491,6.125097412,6.039280475,4.511186244} /*cfz*/
     },
     {
          2465919.5,
          {1.822549807,-0.03374640189,1217.312137,0.4140672189,-0.01494898651,17.46765847}, /*cmx*/
          {2.37168492,3.877122036,3.907165,1.565708569}, /*cfx*/
          {-0.8618709823,0.01821742121,93.77171259,0.09504165074,0.0064066134,1.319303828}, /*cmy*/
          {2.215547185,0.9086296258,4.072197604,1.553538043}, /*cfy*/
          {52.64722396,-0.0005494108446,1220.869424,-0.4050594644,0.01437243134,17.52438522}, /*cmz*/
          {3.941522213,2.301510233,2.335467708,3.137391907} /*cfz*/
     },
     {
          2465989.5,
          {-0.5028874864,-0.09599928534,1217.722628,-1.799224481,-0.005226929609,17.49255678}, /*cmx*/
          {4.783368803,0.08517957564,-0.326331332,0.09237512601}, /*cfx*/
          {0.4255171536,0.0432910237,89.73009681,-0.8588290589,0.002308178669,1.423034695}, /*cmy*/
          {4.92446831,3.386779846,-0.6171527209,0.6607901048}, /*cfy*/
          {52.71018116,-0.008265898055,1220.713092,1.721403978,0.005720948923,17.48029988}, /*cmz*/
          {0.07157022695,4.805365294,4.255680413,1.668450884} /*cfz*/
     },
     {
          2466059.5,
          {-7.453049214,-0.08366146202,1219.278873,-2.63653742,0.008394486227,17.54211383}, /*cmx*/
          {0.8262826091,2.374942569,2.498388596,4.852424676}, /*cfx*/
          {3.576913252,0.03425970847,116.57896,-1.154870668,-0.004259575876,2.172359728}, /*cmy*/
          {1.699142497,5.541565497,2.602749061,5.971868103}, /*cfy*/
          {52.27827539,-0.0228858855,1218.870711,2.534879297,-0.007563327053,17.50052393}, /*cmz*/
          {2.401167875,0.7549418701,0.8972582988,0.1497151722} /*cfz*/
     },
     {
          2466129.5,
          {-14.04547031,-0.007658662197,1219.19228,-1.460028023,0.01673191838,17.51585425}, /*cmx*/
          {3.155371039,4.721803326,4.715503587,3.406521899}, /*cfx*/
          {6.232096624,-2.937679587e-05,169.4619575,-0.5578533584,-0.007102083942,2.542502569}, /*cmy*/
          {4.359443557,1.500375488,4.62793742,4.646988067}, /*cfy*/
          {50.35951666,-0.001673147918,1210.935971,1.455059143,-0.01661661779,17.37135144}, /*cmz*/
          {4.733047424,3.090590426,3.083644448,4.985000876} /*cfz*/
     },
     {
          2458849.5,
          {-8039.460702,776.8945093,6910.97891,-1301.925196,-52.27827218,-282.2484631}, /*cmx*/
          {-4.423539484,-9.885905562,-12.39221283,16.17368241}, /*cfx*/
          {1063.394403,-88.35206809,1437.599362,-195.9153324,7.373302604,-78.40562897}, /*cmy*/
          {-1.339347007,-7.223751765,-13.03176186,-13.21987794}, /*cfy*/
          {356.3736928,0.7832978632,1550.285072,226.7339708,-10.68542644,-170.9529738}, /*cmz*/
          {-1.409767614,-4.912185313,-4.553877961,-7.36006664} /*cfz*/
     },
     {
          2458865.5,
          {-1017.334583,129.8298323,2550.457829,263.9178268,13.49207379,-86.67191162}, /*cmx*/
          {-167.2206179,-5.776928198,-2.062328348,-0.416190832}, /*cfx*/
          {2288.897113,-235.0158489,-2803.04484,-395.76313,16.04499279,-56.13016512}, /*cmy*/
          {1.601007324,-0.4243883188,0.2140016197,-11.51609433}, /*cfy*/
          {5447.121302,-551.9286087,6528.467649,948.7763025,37.83524798,-145.6196206}, /*cmz*/
          {4.666948735,-9.908774781,0.138307664,0.878590232} /*cfz*/
     },
     {
          2458881.5,
          {4032.197347,-427.2923901,-3579.38085,732.7314062,30.07795178,49.69801632}, /*cmx*/
          {8.353907726,2.725697796,0.2018052793,3.006375942}, /*cfx*/
          {-986.3654848,77.19079686,-1298.455799,167.5995375,-6.284203355,1.912335944}, /*cmy*/
          {-1.285416418,-0.8928974281,5.870187607,-0.8491271932}, /*cfy*/
          {-1337.731466,72.62595747,-2274.448193,-254.5843401,-10.19474123,10.31660723}, /*cmz*/
          {-1.378287626,-4.419970619,5.363341816,3.24441689} /*cfz*/
     },
     {
          2458897.5,
          {-3100.433451,234.669079,2442.429692,504.1942143,-18.60742762,127.4406414}, /*cmx*/
          {0.9050777637,11.61373209,5.824760136,11.01655227}, /*cfx*/
          {-2097.103009,211.6941891,2493.901224,354.2234835,-14.60934987,78.08208829}, /*cmy*/
          {14.18477168,5.918273335,6.56201485,-31.27612282}, /*cfy*/
          {-6343.556876,617.4706774,-7026.77935,-1045.146352,-42.05422536,-201.4768077}, /*cmz*/
          {-1.587600449,2.699655721,0.1916732259,-3.189007298} /*cfz*/
     },
     {
          2458913.5,
          {-7671.806862,751.646584,6719.911122,1253.445958,-50.65466481,277.0966024}, /*cmx*/
          {8.177698429,5.848937236,6.489431197,0.5236013607}, /*cfx*/
          {1410.675897,-126.8021613,1794.057634,248.0663197,9.325601716,77.20175649}, /*cmy*/
          {-1.365586007,8.640269972,37.45319605,-3.634062546}, /*cfy*/
          {1460.500785,-112.2673179,-2769.212404,332.6480949,13.02146151,-177.3435309}, /*cmz*/
          {-4.594244891,1.953295385,5.495469717,5.377818946} /*cfz*/
     },
     {
          2458929.5,
          {357.2371203,-4.108843686,-1721.863459,-223.4474175,10.47792091,108.2001262}, /*cmx*/
          {-0.2448135624,4.60109085,4.964169554,3.000511291}, /*cfx*/
          {2032.670302,-214.2233572,2505.726714,-354.3828597,14.59649649,51.90123964}, /*cmy*/
          {4.755428148,-6.659178729,0.2732726566,-1.949817296}, /*cfy*/
          {5676.80439,-588.0171479,-6716.819082,990.7753371,-40.05538684,-153.5421441}, /*cmz*/
          {-4.740375059,2.702043702,3.336509057,0.9806804607} /*cfz*/
     },
     {
          2458945.5,
          {3628.757145,-393.6945631,3281.886763,667.3201767,-27.76843896,-39.96727604}, /*cmx*/
          {5.301905191,2.788123034,3.419334842,6.243300681}, /*cfx*/
          {-1159.591996,97.09740788,1445.067224,-190.7507984,-7.238030125,5.581981022}, /*cmy*/
          {1.856673529,8.669578142,-0.2179952205,0.3686338622}, /*cfy*/
          {-2089.421335,147.7772194,3032.759143,-346.5298994,13.12837232,-6.875680856}, /*cmz*/
          {-4.523747446,-4.125040789,2.616416299,4.363321569} /*cfz*/
     },
     {
          2458961.5,
          {-4741.25805,406.7468374,-3768.141407,-760.1563628,28.46888612,-126.2607771}, /*cmx*/
          {4.391896878,2.403354677,2.965147688,-10.55715077}, /*cfx*/
          {-1305.610383,136.7360253,1673.713616,227.5480379,-9.828878337,-62.28989848}, /*cmy*/
          {1.638497342,-0.2218044869,12.98950989,3.436374222}, /*cfy*/
          {-5067.63614,503.4461946,-5725.370375,-841.0852307,34.80466067,182.4863292}, /*cmz*/
          {-1.578087263,2.784083542,3.423912015,25.21767614} /*cfz*/
     },
     {
          2458977.5,
          {-6139.789784,622.4643162,-5285.460877,-1023.845488,-42.49340492,-253.7602893}, /*cmx*/
          {5.14656788,-16.04759419,-18.53454974,-2.380372249}, /*cfx*/
          {2198.769089,-210.7453204,2553.854705,-374.5373238,14.44212143,-88.25964351}, /*cmy*/
          {-1.357147937,11.94875723,12.54736366,-0.1601453337}, /*cfy*/
          {4267.385079,-398.8159906,5562.067897,750.1684605,-28.38576049,208.1537815}, /*cmz*/
          {-1.419987671,2.41148945,-9.591047809,2.685992803} /*cfz*/
     },
     {
          2458993.5,
          {3317.035945,-304.890703,2850.453803,598.3114032,-22.88522601,-159.4464839}, /*cmx*/
          {4.258552871,2.390873128,-3.359328211,0.268693984}, /*cfx*/
          {1496.449258,-168.2348512,-1985.110575,-270.6741017,-11.65232451,-46.05899432}, /*cmy*/
          {7.945591938,-0.2416715402,16.13219861,-4.68249417}, /*cfy*/
          {5073.987166,-550.592042,-6179.285046,-899.2104491,-37.541891,144.640975}, /*cmz*/
          {7.872644545,-0.3381489524,-9.108054468,-1.859088687} /*cfz*/
     },
     {
          2459009.5,
          {2385.887052,-285.9316348,-2212.883908,-478.842915,20.95251077,21.28171772}, /*cmx*/
          {2.49185573,-6.44947294,0.4844016364,3.082939117}, /*cfx*/
          {-1514.520595,137.6650724,1761.772013,247.0467567,-9.688481686,-12.04010854}, /*cmy*/
          {102.4329988,5.698062821,-12.55604771,3.756711908}, /*cfy*/
          {-3417.639444,290.3530925,-4275.862837,547.0282467,21.00642344,27.36927228}, /*cmz*/
          {4252.392563,11.87507299,9.300259158,0.7449868506} /*cfz*/
     },
     {
          2459025.5,
          {-6348.131679,586.6283771,-5376.480187,-1027.250426,39.80348088,-147.8582567}, /*cmx*/
          {-8.001218529,-3.716681599,3.169288174,2.542600905}, /*cfx*/
          {-57.5540831,17.50978389,472.5474522,-78.9966044,3.850435836,43.28091}, /*cmy*/
          {8.067518492,4.077365678,-1.807210046,0.700747151}, /*cfy*/
          {-1976.573857,215.5226817,2762.776248,-372.675305,-17.32402385,133.8471362}, /*cmz*/
          {7.865983651,3.16814302,0.6441018119,6.678153222} /*cfz*/
     },
     {
          2459041.5,
          {-2039.073858,236.8277477,1896.977886,411.3182971,-19.4199382,-199.4188318}, /*cmx*/
          {-3.420189821,0.1093092737,0.7501593664,4.460735094}, /*cfx*/
          {2831.938533,-284.0636754,3142.837544,482.1773559,19.16222973,104.7552629}, /*cmy*/
          {-1.301574195,2.647075955,0.1365103926,3.337361488}, /*cfy*/
          {6832.132065,-676.6301045,-7972.342393,-1169.77826,-45.80031424,254.7071371}, /*cmz*/
          {8.067196092,-0.549299077,3.211119421,3.140958028} /*cfz*/
     },
     {
          2459057.5,
          {6158.065546,-612.2367632,-5632.120785,1058.742805,41.83810631,-209.7415722}, /*cmx*/
          {1.444938767,2.616300072,6.369430547,0.6116496542}, /*cfx*/
          {251.1112227,-50.49478,822.516439,-100.2907595,-5.216484898,48.28163698}, /*cmy*/
          {23.79586412,0.5052828902,4.21691468,-0.6918547661}, /*cfy*/
          {2315.234221,-295.2594163,-3588.917116,-472.8320003,-21.71796396,120.9795319}, /*cmz*/
          {7.929670629,6.23352274,3.761597646,-1.162102061} /*cfz*/
     },
     {
          2459073.5,
          {212.1202011,-81.69342533,1671.4695,-204.2240023,-10.42310623,-14.15306533}, /*cmx*/
          {6.92620371,0.6457323903,4.317632918,4.156923355}, /*cfx*/
          {-1714.626221,166.009731,-1922.175998,283.1780132,-11.50978153,-15.07932875}, /*cmy*/
          {5.139455588,-0.436693853,0.1939843826,10.24910753}, /*cfy*/
          {-4262.164222,395.7100544,-4971.702945,690.2260631,27.49778258,41.26975413}, /*cmz*/
          {-1.233034223,-0.5097284915,3.247208524,0.8300270704} /*cfz*/
     },
     {
          2459089.5,
          {-5781.609609,560.0447792,5003.502489,-950.0601395,-38.27492955,152.1840032}, /*cmx*/
          {7.750303268,2.701349219,0.1859051461,24.87859266}, /*cfx*/
          {1290.515759,-116.2587624,819.5893344,228.6081902,-8.438945284,31.70956252}, /*cmy*/
          {-1.601347928,8.608494027,9.143979765,14.1542488}, /*cfy*/
          {1658.852567,-138.7411095,704.383343,344.9169858,-12.72938224,-78.91676093}, /*cmz*/
          {4.831179878,-4.233558291,2.484988749,4.206420496} /*cfz*/
     },
     {
          2459105.5,
          {2762.848344,-237.7556171,4494.262552,-515.7153767,19.26765337,186.9118647}, /*cmx*/
          {10.77685342,-13.50835198,5.831543208,2.127734426}, /*cfx*/
          {2373.595773,-251.3826669,-2658.717574,415.4533501,-17.11814405,-101.3990898}, /*cmy*/
          {8.249363427,2.774286285,3.424473247,6.813135254}, /*cfy*/
          {6612.200407,-685.5847921,7601.106328,1146.890042,-46.32195683,-257.0725464}, /*cmz*/
          {17.58240682,2.708432994,3.349158877,0.3324843809} /*cfz*/
     },
     {
          2459121.5,
          {6763.123107,-699.5640926,-6409.240999,-1167.858735,47.34191765,217.9353645}, /*cmx*/
          {-4.766019033,-0.4255853529,6.497911659,4.017878637}, /*cfx*/
          {-1190.589063,93.31321104,591.9667031,-198.9069685,7.551222809,-67.69615524}, /*cmy*/
          {1.42066195,-4.009350759,2.771490674,3.075190934}, /*cfy*/
          {-1092.722871,39.1867184,330.7947696,-244.9951276,10.63760787,-140.936201}, /*cmz*/
          {-101.7003482,1.680119648,2.0338524,2.725435353} /*cfz*/
     },
     {
          2459137.5,
          {-1620.528209,101.1273375,3024.103293,289.0983903,-11.39310168,41.6283538}, /*cmx*/
          {7.570199605,5.159950245,5.569201913,0.6937731667}, /*cfx*/
          {-1520.018324,153.552155,1710.972579,255.6649924,10.76422957,-13.18979549}, /*cmy*/
          {8.4083734,-0.3068589594,3.480302899,4.281643759}, /*cfy*/
          {-4239.677772,411.1538576,4859.429216,-694.7285745,-28.57997261,-44.0032936}, /*cmz*/
          {27.12903798,2.75150039,0.2432904577,16.73678722} /*cfz*/
     },
     {
          2459153.5,
          {-4014.797687,406.8117685,3388.03182,-680.2133969,-28.71235213,128.3464597}, /*cmx*/
          {-4.849506731,2.847002194,6.629872629,6.221065637}, /*cfx*/
          {1889.224207,-180.9848834,-1401.355278,-325.3103444,-12.46524459,-34.26916004}, /*cmy*/
          {1.621874836,5.644356971,3.090064011,-0.8974862192}, /*cfy*/
          {3617.265101,-340.4793942,2591.790779,640.3525861,-24.07604775,-66.9228631}, /*cmz*/
          {11.11278116,2.402055738,-3.320637814,-1.305137179} /*cfz*/
     },
     {
          2459169.5,
          {5364.995667,-503.1244725,6986.044769,920.8633486,34.89475173,211.1721324}, /*cmx*/
          {4.65564402,-10.10740846,6.179579439,2.554190601}, /*cfx*/
          {1383.383046,-160.2172948,1731.617718,-262.4516903,11.38946766,-84.1564774}, /*cmy*/
          {-0.9578306171,-0.1934200269,0.4626567786,7.091065417}, /*cfy*/
          {5093.34899,-555.4610065,-6125.322164,913.5032733,38.02637935,233.8718527}, /*cmz*/
          {8.260945193,-3.473142056,0.3185628373,3.688571772} /*cfz*/
     },
     {
          2459185.5,
          {6349.657662,-670.6384175,6007.434809,-1105.601392,-45.51531951,212.6801043}, /*cmx*/
          {-51.86968872,-6.655481104,3.422938821,-14.67477478}, /*cfx*/
          {-1900.758061,167.0846533,-1294.42824,306.4550846,-11.79010446,-78.1212079}, /*cmy*/
          {23.58222922,5.614675303,6.189716821,3.298125915}, /*cfy*/
          {-3112.343312,239.8595432,-1646.95603,503.9794612,-19.14712259,172.6138314}, /*cmz*/
          {-1.506960045,-7.150429126,5.923092737,-0.1335493957} /*cfz*/
     },
     {
          2459201.5,
          {-2389.221665,182.3409054,3751.403747,-405.9486307,15.46420364,57.90819523}, /*cmx*/
          {1.385353036,-4.025283587,2.734290528,-5.629780109}, /*cfx*/
          {-1268.462541,130.5461501,1468.85139,215.7613843,-9.30624292,11.86533597}, /*cmy*/
          {2.208308654,-0.2197271497,0.4279915096,1.450800321}, /*cfy*/
          {-4177.437428,411.1104083,4818.352801,-686.5699492,-28.74807415,47.55007477}, /*cmz*/
          {8.31392827,2.812534813,6.591582651,-67.9276229} /*cfz*/
     },
     {
          2459217.5,
          {-3032.011126,320.4379527,-2391.33131,536.8232505,23.51174223,109.85804}, /*cmx*/
          {54.78836681,6.09764467,3.60150981,6.295276997}, /*cfx*/
          {1853.115643,-181.7641797,-1406.62181,-320.7739514,12.49688031,33.08507409}, /*cmy*/
          {1.668895681,5.697540936,18.8615231,2.452023047}, /*cfy*/
          {4176.131297,-402.8689823,-3180.635015,735.1693608,28.10515884,67.8479501}, /*cmz*/
          {8.013319031,2.466067273,6.185640382,-4.159230078} /*cfz*/
     },
     {
          2459233.5,
          {6127.035389,-578.8692114,7668.751886,1040.89107,-39.69791732,219.7792259}, /*cmx*/
          {4.668940373,2.501298237,3.092955718,2.646445552}, /*cfx*/
          {845.1945042,-107.8213599,1270.668739,-179.9987994,8.138866002,-70.98164416}, /*cmy*/
          {-0.7930688759,12.52361921,13.16978625,26.06442543}, /*cfy*/
          {4438.724895,-499.5412418,-5633.626853,-818.35774,-34.58668869,-226.0433363}, /*cmz*/
          {2.018462586,-0.2793230953,3.513596271,32.02664677} /*cfz*/
     },
     {
          2459249.5,
          {6394.478193,-673.9198432,5881.502231,-1108.879751,45.78502571,218.2193953}, /*cmx*/
          {-58.13881146,-0.3631748943,0.2933794324,16.75341913}, /*cfx*/
          {-1940.092045,172.9318228,1381.092,-310.4131279,12.0117465,-75.24445643}, /*cmy*/
          {1.636638246,2.507091653,3.094505222,3.336428181}, /*cfy*/
          {-3693.236092,294.0440437,2230.221144,-588.4379121,22.36697126,-187.1001643}, /*cmz*/
          {-4.58737415,8.611262352,2.857260864,3.03213647} /*cfz*/
     },
     {
          2459265.5,
          {-2330.149214,179.2825765,3721.808335,407.982928,-15.54114713,62.51444077}, /*cmx*/
          {1.338752465,-0.8968233896,5.854127816,0.5955098042}, /*cfx*/
          {-1155.714051,118.4860023,-1354.040976,-195.7344851,8.471347864,12.13302439}, /*cmy*/
          {-0.9466908617,-9.631005441,-2.701300298,-4.773100352}, /*cfy*/
          {-4417.347388,433.0914848,-5133.586492,723.5732876,-30.29526293,55.1688229}, /*cmz*/
          {-1.138396482,-0.3272159709,-43.67381739,-4353.044586} /*cfz*/
     },
     {
          2459281.5,
          {-3023.152245,323.7529113,2248.724295,-542.6350332,-23.78513755,-105.837534}, /*cmx*/
          {-11.16624631,9.236064375,6.739519052,9.415639684}, /*cfx*/
          {1644.830357,-162.302336,1263.524526,286.6754766,11.19163172,28.73061388}, /*cmy*/
          {4.844099458,-3.724130918,6.29760154,2.473343407}, /*cfy*/
          {4184.946195,-404.5188073,-3283.177151,-741.715547,28.36067801,-65.27455748}, /*cmz*/
          {14.33430405,5.600792077,-0.1082151286,-1.018814185} /*cfz*/
     },
     {
          2459297.5,
          {6001.629703,-559.6960371,7451.32845,-1013.933528,-38.55088664,-215.1052052}, /*cmx*/
          {4.635807952,-0.656852322,9.355046749,-0.5607021284}, /*cfx*/
          {798.0476767,-101.3235664,-1204.370524,168.6974523,7.587738441,64.37697851}, /*cmy*/
          {2.295681123,-53.47138154,-11.98302184,-2.249829579}, /*cfy*/
          {4800.745968,-536.3806328,-6125.127238,881.0549238,-37.01516705,-234.840761}, /*cmz*/
          {1.977027088,2.843866699,3.494385778,-49.70759507} /*cfz*/
     },
     {
          2459313.5,
          {6833.221789,-710.7534636,6111.293376,1172.261451,48.16939702,-230.0857001}, /*cmx*/
          {-7.858984244,2.762925232,0.274637376,13.54660989}, /*cfx*/
          {-1730.807755,152.5510917,1230.749639,276.2502398,10.65111029,68.46097107}, /*cmy*/
          {1.657461627,-6.933792663,-3.208985635,0.1482547783}, /*cfy*/
          {-3420.779524,262.2876744,-2019.431691,-546.4574646,20.7437956,-187.587935}, /*cmz*/
          {11.17226719,21.12574124,2.785505721,-3.329686938} /*cfz*/
     },
     {
          2459329.5,
          {-1940.18164,141.4172822,-3385.501452,-358.7381238,-13.84911549,-60.35929275}, /*cmx*/
          {4.382820748,2.143698015,5.718326693,3.677510119}, /*cfx*/
          {-1160.696852,117.6933873,-1350.047622,194.1889218,8.362045321,13.17845797}, /*cmy*/
          {-1.005399288,-6.518135069,-2.730089996,1.434366063}, /*cfy*/
          {-4693.63333,456.1999645,-5483.299364,-765.6850442,-31.83649481,-61.59454949}, /*cmz*/
          {11.38583421,2.790772542,0.2829918097,16.86762373} /*cfz*/
     },
     {
          2459345.5,
          {-3388.007102,359.4945179,-2494.550964,-602.7864817,-25.97734194,-109.6670983}, /*cmx*/
          {-1.693444943,-3.379504616,6.687073197,3.079355752}, /*cfx*/
          {1520.479481,-149.5611952,1182.330172,266.0987154,-10.32975583,-25.58512552}, /*cmy*/
          {4.858622437,-3.743198184,3.135261646,-19.5696822}, /*cfy*/
          {4035.619453,-387.4853286,-3230.137548,720.9922315,27.36196816,62.1229937}, /*cmz*/
          {8.073073743,2.431941697,6.139292438,-4.262147541} /*cfz*/
     },
     {
          2459361.5,
          {5649.810696,-519.3986375,-7043.49628,951.4324168,-36.05213868,-209.4797435}, /*cmx*/
          {-601.7268099,2.455964836,3.034528138,5.636873868}, /*cfx*/
          {956.999688,-115.8815002,-1336.117342,190.3078723,-8.395589869,-65.1061639}, /*cmy*/
          {2.186657765,-3.288773323,3.647675227,-18.04612417}, /*cfy*/
          {5292.246294,-582.5641581,6675.226194,960.2574904,40.01074456,-244.3357978}, /*cmz*/
          {5.076872744,-3.469221595,-5.960594249,31.91441573} /*cfz*/
     },
     {
          2459377.5,
          {7050.123054,-729.1053564,6228.218553,-1203.780602,-49.33973153,235.9851366}, /*cmx*/
          {-7.851949877,-0.385183312,3.406490829,450.1960973}, /*cfx*/
          {-1655.498639,143.9191164,1169.434902,265.1168217,10.15993182,-67.87851659}, /*cmy*/
          {1.663558458,-0.6756668898,3.042657065,-3.043606891}, /*cfy*/
          {-3165.078317,235.4641297,1817.576604,510.5296527,-19.35708036,-185.531818}, /*cmz*/
          {45.76557244,-0.9047082468,-0.4129746362,2.907382965} /*cfz*/
     },
     {
          2459393.5,
          {-1822.416681,129.8647006,3284.080226,341.6248818,13.32564825,59.49182732}, /*cmx*/
          {7.490345536,5.248982136,2.533590252,0.5370916626}, /*cfx*/
          {-1255.240331,126.6411062,-1451.396103,208.2005812,-8.955073405,-14.68603141}, /*cmy*/
          {-1.038842867,-0.2543548901,0.3944786483,-8.01989164}, /*cfy*/
          {-4733.854272,458.9210873,-5547.84006,770.6967302,-31.96165174,-61.94225594}, /*cmz*/
          {11.37241415,5.921459605,6.557248546,10.57901051} /*cfz*/
     },
     {
          2459409.5,
          {-3505.770123,369.9431424,-2596.267955,621.5669754,26.61265584,112.6543477}, /*cmx*/
          {-51.94997319,-19.09975719,3.529591346,6.204718784}, /*cfx*/
          {1591.912868,-156.1997739,1244.022017,279.0050583,10.77395428,-26.20295583}, /*cmy*/
          {-1.423285522,8.811961678,6.266164739,5.524590933}, /*cfy*/
          {4003.312435,-383.747264,-3218.268332,-716.724996,27.07559089,-61.54342691}, /*cmz*/
          {8.075158199,5.569404889,6.134345202,5.131909538} /*cfz*/
     },
     {
          2459425.5,
          {5676.898702,-523.4512592,7074.682511,-954.3209238,-36.25270418,210.1078242}, /*cmx*/
          {-171.3238865,-0.6812664241,-3.242648332,2.510878507}, /*cfx*/
          {1058.951572,-127.2397939,-1462.548573,208.3641679,-9.175198792,-70.40963447}, /*cmy*/
          {2.171104127,-3.303465056,3.635260154,-18.06055638}, /*cfy*/
          {5131.050576,-566.0553878,6500.07415,933.0393077,38.94464224,240.1153393}, /*cmz*/
          {5.083564407,2.816871422,6.610351558,9.934218152} /*cfz*/
     },
     {
          2459441.5,
          {6707.086782,-698.8224841,-5929.199041,1149.965585,47.36257443,228.5570191}, /*cmx*/
          {-23.56366849,2.772623581,0.2826914422,-8.426724872}, /*cfx*/
          {-1850.077321,162.241186,1322.199374,296.9739752,11.39543319,-74.54126091}, /*cmy*/
          {1.670694928,-0.6598389405,3.062600993,-3.016309601}, /*cfy*/
          {-3498.049749,271.9359537,-2140.987946,-560.9314569,-21.21623065,187.8951618}, /*cmz*/
          {4.913338385,-41.6814852,5.95583843,-0.1704453686} /*cfz*/
     },
     {
          2459457.5,
          {-2138.311776,162.5680574,-3555.497171,-381.6568673,-14.68285943,63.44679066}, /*cmx*/
          {4.416122791,2.202771488,5.804700043,0.5902669806}, /*cfx*/
          {-1291.569336,130.935724,-1508.76249,214.7047457,9.267937433,14.67364059}, /*cmy*/
          {-1.013246637,-0.2383689095,9.838499389,-4.794150656}, /*cfy*/
          {-4522.090641,441.0466899,-5314.451536,-737.226745,-30.71327517,57.69674013}, /*cmz*/
          {5.111406318,-9.770086437,6.577341874,7.493394395} /*cfz*/
     },
     {
          2459473.5,
          {-3120.675794,333.3667184,-2272.029788,-560.2528525,-24.29208555,107.4744834}, /*cmx*/
          {-8.006875637,2.932627268,6.712682624,6.233919332}, /*cfx*/
          {1714.551126,-169.0431341,1333.316814,300.4036164,-11.63437063,-28.53925759}, /*cmy*/
          {4.865184845,-3.738489381,3.14226383,5.566026963}, /*cfy*/
          {4102.120749,-396.3007738,-3281.48096,730.6216253,27.74280124,61.80720095}, /*cmz*/
          {8.074423006,-3.828128257,6.169802212,2.084610789} /*cfz*/
     },
     {
          2459489.5,
          {5979.441137,-559.0261198,-7380.860298,-1003.951439,38.36378003,211.6136822}, /*cmx*/
          {14.0598494,-0.6461971198,6.227696126,2.605969937}, /*cfx*/
          {826.1324258,-105.7867439,-1291.018344,175.8621664,7.950946752,-68.57988063}, /*cmy*/
          {2.290708624,34.49379021,-564.9000364,446.9862825}, /*cfy*/
          {4304.287872,-486.2759687,-5663.3694,-799.2680424,-33.79035294,221.5831994}, /*cmz*/
          {1.9932255,-0.2829380875,3.512217351,28.85274898} /*cfz*/
     },
     {
          2459505.5,
          {5917.144253,-624.9322446,5186.317121,1022.6444,-42.56444997,212.6077905}, /*cmx*/
          {-7.865333619,2.805053325,3.462603011,-8.32585848}, /*cfx*/
          {-2069.181913,186.0420822,1516.164605,-331.4344533,12.84340314,-78.44448342}, /*cmy*/
          {1.691564175,-3.751006183,9.41014741,3.35843337}, /*cfy*/
          {-4211.508112,348.6701975,-2837.885705,669.1528094,-25.45061828,195.6695083}, /*cmz*/
          {4.906776086,5.539545496,6.090049042,-0.05685901652} /*cfz*/
     },
     {
          2459521.5,
          {-2643.12757,218.2217211,-4012.171479,-456.7095421,17.41241854,72.65857195}, /*cmx*/
          {-171.4362209,-3.954097041,2.835019666,0.6476667398}, /*cfx*/
          {-1111.458785,114.0706407,-1351.129989,-186.8958232,-8.166850642,12.69986353}, /*cmy*/
          {-0.9400141526,-9.605951412,-5.809479835,20.60342625}, /*cfy*/
          {-4210.889451,415.1329352,-5013.668188,-688.3230413,28.97130773,-54.08674695}, /*cmz*/
          {5.144263464,2.833263495,3.477161369,4.486077041} /*cfz*/
     },
     {
          2459537.5,
          {-2336.86571,260.988183,-1545.327624,441.5629652,19.75423267,92.56243643}, /*cmx*/
          {10.73121095,-0.1079106505,-2.612553512,-0.01342956418}, /*cfx*/
          {1633.549862,-163.4912114,1258.153337,287.1865974,-11.23552545,-27.58348111}, /*cmy*/
          {4.895413414,-3.700265849,-3.097927134,-0.6208732363}, /*cfy*/
          {4196.151127,-411.4716593,-3373.511161,744.4337851,-28.5678129,60.18488685}, /*cmz*/
          {8.099590429,2.497245923,3.082165694,8.517816126} /*cfz*/
     },
     {
          2459553.5,
          {6362.570564,-602.9374049,-7702.986347,1064.140626,41.03895301,212.7281783}, /*cmx*/
          {-4.76264167,2.542046736,0.003745299913,2.729815566}, /*cfx*/
          {254.9855077,-48.83457021,-855.6556256,-96.50717806,4.74298355,56.05409514}, /*cmy*/
          {2.663927165,0.3423983874,0.9261740885,4.222233129}, /*cfy*/
          {3005.014407,-362.0123936,4470.354933,595.7931063,25.99897822,-195.9141981}, /*cmz*/
          {-1.046161974,-3.32093097,0.473538388,182.9072245} /*cfz*/
     },
     {
          2459569.5,
          {4686.673762,-506.3234897,-3906.295514,821.8253221,-34.96483022,193.7748597}, /*cmx*/
          {-73.85281763,-3.41020817,-2.744587206,-1.871941806}, /*cfx*/
          {-2129.082801,197.2902253,-1611.822901,-341.0824919,13.4037236,75.64719741}, /*cmy*/
          {-1.413860861,2.598057735,3.210413455,0.3518659052}, /*cfy*/
          {-5317.006718,466.4493191,3953.610733,844.0350447,-32.50774608,-214.0360198}, /*cmz*/
          {8.063749555,-0.6450219769,6.223520622,3.227650358} /*cfz*/
     },
     {
          2459585.5,
          {-3432.656398,308.1354141,4751.836112,584.4871126,-22.4872629,89.99638988}, /*cmx*/
          {1.426272027,5.606096536,18.7301273,0.7295522331}, /*cfx*/
          {-694.9378721,73.56952269,970.3956867,121.6828855,5.544497022,11.38897783}, /*cmy*/
          {-10.19143479,12.54358323,3.776163337,2.397155862}, /*cfy*/
          {-3678.51315,369.7009483,-4565.906819,604.8763931,26.00012953,50.98474783}, /*cmz*/
          {-1.087232197,-0.2380805597,-2.725617817,39.35316407} /*cfz*/
     },
     {
          2459601.5,
          {-1098.974738,146.5637045,556.1493555,-272.7485751,13.17877948,-68.72448532}, /*cmx*/
          {6.78895586,3.352133082,3.946350113,3.168955215}, /*cfx*/
          {1327.714928,-136.8713127,-1001.204616,236.7509718,-9.422939485,-23.09074352}, /*cmy*/
          {-4.464920742,2.649927625,3.261363603,5.795859615}, /*cfy*/
          {4286.45059,-430.2364467,-3497.075302,-761.5322792,-29.66837385,-58.45780171}, /*cmz*/
          {8.152464417,5.702453732,3.160902403,30.72096144} /*cfz*/
     },
     {
          2459617.5,
          {6705.744474,-646.3166254,7946.254589,1117.051481,43.75709331,-216.3318397}, /*cmx*/
          {-1.589624369,2.603586462,0.07963742119,-0.2416437336}, /*cfx*/
          {-478.6953386,26.6466156,680.566353,-85.23460022,3.342144347,-40.7406432}, /*cmy*/
          {0.5562705383,1.85746348,2.253498391,1.503506789}, /*cfy*/
          {916.259379,-161.0350521,2761.262999,300.9876048,14.62919529,-161.9683016}, /*cmz*/
          {-0.7154558075,3.394144683,0.8484635682,19.79180212} /*cfz*/
     },
     {
          2459633.5,
          {2533.902952,-296.5461764,1702.357006,-484.6140039,-22.13342545,-173.1758365}, /*cmx*/
          {10.85942687,6.240195853,3.764045374,1.618985982}, /*cfx*/
          {-1926.69509,184.3885351,-1482.673056,-310.4193262,12.42756593,-66.58793653}, /*cmy*/
          {4.913258003,2.675809335,9.589731297,3.688981308}, /*cfy*/
          {-6663.287128,614.7199925,-5314.177681,1065.994553,41.78672075,-240.8806597}, /*cmz*/
          {4.94597444,-0.5505639394,3.20486027,3.416896503} /*cfz*/
     },
     {
          2459649.5,
          {-4507.903546,433.2963189,-5791.849346,-764.7533984,-30.12272179,-112.4551373}, /*cmx*/
          {17.21755855,8.874912474,-6.230916046,4.001255851}, /*cfx*/
          {-116.6888912,16.13024842,547.3284363,47.89076049,-2.468332461,-15.73280699}, /*cmy*/
          {2.985988664,0.8251693594,1.326802812,-0.0004185512623}, /*cfy*/
          {-2429.37857,255.1214027,3500.733825,414.7078297,18.94118506,-52.50707831}, /*cmz*/
          {-4.072407687,6.236456455,3.759037055,-0.8205086414} /*cfz*/
     },
     {
          2459665.5,
          {578.8684374,-12.99122122,-1505.58711,191.3621546,8.408633607,38.07723447}, /*cmx*/
          {2.041116438,1.448180918,-1.347677589,0.07219374823}, /*cfx*/
          {890.8893143,-97.24056565,-623.0528225,-165.1667055,6.779350719,16.7267793}, /*cmy*/
          {1.941336255,31.03756651,6.530913162,2.786701367}, /*cfy*/
          {4124.571417,-429.1109361,3363.507789,741.9237445,-29.55579672,56.06724523}, /*cmz*/
          {5.093925184,2.65163033,9.552810936,2.673052794} /*cfz*/
     },
     {
          2459681.5,
          {6263.950515,-619.2933386,7442.245657,1047.021709,-42.04746248,212.4427733}, /*cmx*/
          {4.73439463,8.970982964,3.320133283,3.112222437}, /*cfx*/
          {-1072.986985,90.21462415,1060.901293,168.578253,-6.352893788,34.51686216}, /*cmy*/
          {1.201638653,5.542179136,6.104959525,5.27191043}, /*cfy*/
          {-2013.562206,127.2491427,-2125.612275,-337.6240206,12.74281333,-130.5261961}, /*cmz*/
          {3.706191866,1.997459635,2.418647218,7.74958073} /*cfz*/
     },
     {
          2459697.5,
          {-809.5579788,34.69136675,-1736.37385,-251.175505,10.88308382,172.8336548}, /*cmx*/
          {11.36012315,1.60857327,1.964180777,5.363655598}, /*cfx*/
          {-1456.991955,144.1354654,-1075.281949,237.4793759,9.773866116,54.54832421}, /*cmy*/
          {4.979103013,-0.366922416,3.424347046,0.8238301957}, /*cfy*/
          {-7242.700181,695.7431012,5885.244875,-1171.7137,46.93718572,-255.7465857}, /*cmz*/
          {1.845904525,2.681653789,3.31720632,3.654420746} /*cfz*/
     },
     {
          2459713.5,
          {-5212.867168,527.5806319,-6520.147145,-888.5018939,-36.01786029,125.5915433}, /*cmx*/
          {4.730587964,2.702071214,0.1941760515,1.068621528}, /*cfx*/
          {470.5526919,-43.73338654,654.1306281,93.16764932,-3.576079527,24.61574303}, /*cmy*/
          {4.074782517,2.283449981,2.780419866,3.540783011}, /*cfy*/
          {-109.0230836,29.66411991,-1945.69267,180.3059072,-9.176704632,-81.32000819}, /*cmz*/
          {-0.2259884336,1.166377842,1.575652057,-0.05225614243} /*cfz*/
     },
     {
          2459729.5,
          {2368.840273,-191.9868902,3148.16725,-402.5722463,-15.04451229,-6.821485361}, /*cmx*/
          {5.054582083,-13.44417549,-85.1865987,34.41889714}, /*cfx*/
          {474.1928119,-59.23198481,-258.9763858,-99.57414675,-4.347920397,-10.57296602}, /*cmy*/
          {2.344849121,-0.1670966823,-59.21220736,-0.3070546379}, /*cfy*/
          {3323.632973,-368.1726182,-2588.17984,-622.7895598,25.67683164,47.63685606}, /*cmz*/
          {2.114005622,5.923643457,0.2774372537,2.818342162} /*cfz*/
     },
     {
          2459745.5,
          {4254.105678,-441.8473138,5464.992975,-731.95542,30.87624721,184.2888375}, /*cmx*/
          {4.793729316,-6.584587243,-5.938664238,15.94154155}, /*cfx*/
          {-1424.37708,129.5256729,-1398.760801,-227.0522975,-8.795253017,-38.21778316}, /*cmy*/
          {-1.750189168,2.561215847,-6.258491893,2.604589261}, /*cfy*/
          {-4849.066431,416.8159656,-4309.82192,766.0880695,-28.96665536,134.7479017}, /*cmz*/
          {-1.895750653,5.585372634,6.157633162,5.315401379} /*cfz*/
     },
     {
          2459761.5,
          {-4506.831984,410.7687214,-5272.957479,769.2985281,-29.16889813,215.7306041}, /*cmx*/
          {-1.324838079,-0.7146526167,-0.1456703213,-0.326901726}, /*cfx*/
          {-883.6953486,91.70581118,519.6360918,149.7489529,-6.539894034,-47.49015068}, /*cmy*/
          {2.050345775,-6.457841055,-5.790883732,4.365336327}, /*cfy*/
          {-5901.309965,588.8429337,4524.417872,-969.4382162,-40.13670877,235.7082262}, /*cmz*/
          {1.945844424,2.798698992,-43.6711622,0.830993742} /*cfz*/
     },
     {
          2459777.5,
          {-4613.891079,491.4216944,6006.791422,-800.5898945,33.64901611,116.2568142}, /*cmx*/
          {1.665507989,2.820451512,3.478308346,-4.860251537}, /*cfx*/
          {1049.959721,-104.4815208,-1178.083971,-187.1300394,7.299615875,-36.52513401}, /*cmy*/
          {-4.957188565,-0.5886632585,-0.000748046461,0.633773513}, /*cfy*/
          {2663.696886,-252.3594553,-2917.057592,-500.357083,-19.20276634,129.0006979}, /*cmz*/
          {1.02433882,30.65201298,2.904984194,3.521593082} /*cfz*/
     },
     {
          2459793.5,
          {3665.693312,-332.6429209,-4271.227841,-608.7630854,23.45777774,17.31078949}, /*cmx*/
          {-4.348318864,5.642376275,6.228718412,3.567831227}, /*cfx*/
          {97.91572963,-25.60099613,-246.7819204,53.08801687,-2.65249313,6.109087351}, /*cmy*/
          {-14.6674855,3.56036936,4.141394456,8.869326633}, /*cfy*/
          {1879.700671,-240.7971606,1341.272881,-406.1059009,17.89173181,-31.90806522}, /*cmz*/
          {5.758802834,-0.128495332,0.5181505481,-0.3472142566} /*cfz*/
     },
     {
          2459809.5,
          {1210.906462,-156.6549671,-2538.262757,295.0163761,-14.39875666,-137.2080181}, /*cmx*/
          {-4.486423422,3.392140009,3.979733239,0.5963353399}, /*cfx*/
          {-1622.030154,153.0491521,1618.199416,261.691782,-10.40392582,-45.50841484}, /*cmy*/
          {1.459828271,-0.4819866613,0.1416659627,9.168942419}, /*cfy*/
          {-6187.250692,567.6115187,5696.986534,-989.1448627,38.59244376,-156.9471108}, /*cmz*/
          {7.683222054,2.580762569,3.189335604,2.63218499} /*cfz*/
     },
     {
          2459825.5,
          {-6727.973444,648.6392044,-7285.719289,1130.349736,-44.04997347,-256.8453143}, /*cmx*/
          {42.67591371,-0.5662238134,0.04643311967,3.165184693}, /*cfx*/
          {-173.7883514,24.0304465,-334.3082514,-64.20280039,3.285754165,-47.69352952}, /*cmy*/
          {1.093760847,3.840781611,4.352409829,4.88363563}, /*cfy*/
          {-3203.530215,337.3155069,-1966.265325,-552.5791323,-24.58442408,-197.1080966}, /*cmz*/
          {5.458658146,-9.538226519,-5.734577253,4.379136421} /*cfz*/
     },
     {
          2459841.5,
          {-3146.077564,358.5822596,-4622.552953,-575.9897252,-25.36962653,103.2271099}, /*cmx*/
          {11.17069047,-9.591684399,-5.7788255,-4.413823838}, /*cfx*/
          {1469.347422,-150.5452142,1628.320555,258.6981945,10.29671394,-45.57095554}, /*cmy*/
          {10.86241626,-3.639224764,0.1215363541,0.8022311732}, /*cfy*/
          {4409.279144,-438.2130241,-4577.140314,-781.5668166,30.52006416,-158.3294966}, /*cmz*/
          {1.315334432,-6.873247449,0.003849708478,0.5878740625} /*cfz*/
     },
     {
          2459857.5,
          {4072.79015,-384.9309769,-4543.264744,680.6378886,26.89273397,27.94207882}, /*cmx*/
          {1.982292578,-3.6794673,0.06503974907,-2.701333184}, /*cfx*/
          {-233.6194481,5.030190068,-571.6403171,-52.21855705,-2.314451192,-4.071087374}, /*cmy*/
          {-33.08097596,1.52982265,5.020694532,5.046036202}, /*cfy*/
          {654.8844146,-126.7641857,1075.197999,240.0266297,-11.80826521,-17.67615844}, /*cmz*/
          {6.864415842,-2.855032819,4.022166416,-0.577507266} /*cfz*/
     },
     {
          2459873.5,
          {-786.7780672,37.56924935,-742.4507139,-239.8108505,-10.1176125,107.0720261}, /*cmx*/
          {2.380122375,1.576296331,5.068445452,-2.201992173}, /*cfx*/
          {-1538.026857,148.2040162,-1556.482459,-249.8928646,10.17491873,46.91403038}, /*cmy*/
          {-77.06327742,9.011805876,3.365074153,12.46649722}, /*cfy*/
          {-6121.176574,575.2679855,5722.464125,986.3327175,-39.17525594,160.6170051}, /*cmz*/
          {1.437713363,-0.4972648147,0.1267859875,5.962711496} /*cfz*/
     },
     {
          2459889.5,
          {-7174.655589,705.0864987,-7663.193729,-1205.459423,47.5426005,266.1446112}, /*cmx*/
          {-7.570158825,2.623192588,-3.038105698,0.1509826768}, /*cfx*/
          {316.8112599,-24.57927347,-801.8692542,84.14539356,-3.330270284,48.5505407}, /*cmy*/
          {158.5632686,1.869420726,2.25079967,2.066529349}, /*cfy*/
          {-1607.663591,182.9597329,-1109.951362,-325.7910444,15.94271454,180.5607981}, /*cmz*/
          {6.428601771,3.365649492,3.984448615,1.488714758} /*cfz*/
     },
     {
          2459905.5,
          {-2566.680222,305.8608209,4075.314207,496.7303935,-22.27440033,-102.8713919}, /*cmx*/
          {1.77505814,18.76420706,13.15010699,-1.12446788}, /*cfx*/
          {1480.222724,-153.36359,-1647.287013,260.9099884,-10.45414813,44.89279424}, /*cmy*/
          {-4.826242529,2.666331526,3.29765269,4.007397625}, /*cfy*/
          {4872.753082,-488.3347994,-5036.453225,-860.8476209,33.718508,166.8070079}, /*cmz*/
          {7.645662305,-0.5629154136,6.327350497,3.770891868} /*cfz*/
     },
     {
          2459921.5,
          {4058.415394,-383.0631866,4536.011195,-676.4338274,26.93093446,31.16083039}, /*cmx*/
          {-1.149192252,-0.5166631622,6.363744833,-52.91785979}, /*cfx*/
          {-312.284506,13.70727145,-634.9998852,-58.64320712,2.37413113,3.333365719}, /*cmy*/
          {-20.4774508,1.783241366,2.130724758,1.515319735}, /*cfy*/
          {420.8785907,-104.9079735,1226.993173,214.9169649,-11.00677073,11.60234747}, /*cmz*/
          {7.030336125,3.588623333,4.139380539,-3.83166218} /*cfz*/
     },
     {
          2459937.5,
          {-869.07696,48.87536365,-592.3115107,247.3442301,-10.28345589,101.4925337}, /*cmx*/
          {2.399440144,4.77594549,5.142239708,-8.479379748}, /*cfx*/
          {-1337.879381,129.4817125,1343.042292,-217.3136403,-8.923612449,-41.39801644}, /*cmy*/
          {-11.09765932,2.74291585,-18.60696955,34.48612826}, /*cfy*/
          {-6036.16117,568.6407959,5564.537087,975.1132307,-38.78323872,-156.1662586}, /*cmz*/
          {14.00197629,-0.4945528757,0.1327184564,9.10771585} /*cfz*/
     },
     {
          2459953.5,
          {-7018.819014,690.9936344,7658.525943,1182.691308,-46.5524794,261.6391256}, /*cmx*/
          {-10.72093595,5.757689841,6.375972027,0.107367145}, /*cfx*/
          {306.5693486,-24.63650751,741.0791272,77.57650928,2.997590672,-41.98380909}, /*cmy*/
          {161.6970564,1.932098557,-0.816119769,5.220161447}, /*cfy*/
          {-1886.481562,210.6404141,-1253.422142,-359.0427099,17.3018235,-183.2571011}, /*cmz*/
          {6.176990455,3.274931937,3.908498614,-1.72686056} /*cfz*/
     },
     {
          2459969.5,
          {-3132.204648,363.4077717,-4616.840265,-591.9643987,25.80784307,108.4170473}, /*cmx*/
          {-1.419290072,-3.306701799,-2.639185254,-4.459933904}, /*cfx*/
          {1224.834844,-126.5498193,1350.418302,215.7920365,-8.630712567,-37.58186454}, /*cmy*/
          {-1.702340269,2.652770216,3.284791204,0.8379093892}, /*cfy*/
          {4611.740264,-456.3870979,4645.86637,817.6618244,31.7758376,-165.6285153}, /*cmz*/
          {4.466199632,-10.02243171,12.56859798,0.5540837418} /*cfz*/
     },
     {
          2459985.5,
          {3957.398482,-363.1683202,-4554.238627,652.0446628,-25.73602794,-31.32007296}, /*cmx*/
          {1.956334467,2.58770658,3.170998998,88.48180025}, /*cfx*/
          {-212.090886,6.93618805,487.94876,-44.48797648,1.851403142,-2.451875069}, /*cmy*/
          {152.2418295,1.643357667,1.969663032,4.766517877}, /*cfy*/
          {918.2215044,-151.1924754,-1190.171098,-268.6755149,-13.24233288,12.33100438}, /*cmz*/
          {3.418533614,-6.087472718,3.939313438,2.743009708} /*cfz*/
     },
     {
          2460001.5,
          {152.6301134,-46.47870127,1357.942105,-208.2395555,10.23582514,110.0740326}, /*cmx*/
          {4.933004676,0.9104547106,1.35469058,3.856882611}, /*cfx*/
          {-1103.184747,106.1964209,1084.425731,-178.2810152,-7.290670385,32.90707854}, /*cmy*/
          {-633.1448762,2.721733548,0.2190077253,18.73425344}, /*cfy*/
          {-6060.473352,565.7600397,5406.686059,-977.9853569,-38.56295297,149.2388351}, /*cmz*/
          {7.701257157,-3.669866461,0.09327908446,5.863080697} /*cfz*/
     },
     {
          2460017.5,
          {-6546.02896,640.3705863,-7429.39481,1109.692247,-43.30009484,250.3134129}, /*cmx*/
          {-45.30342874,5.724193932,6.333721538,-0.0140860135}, /*cfx*/
          {146.6443358,-10.04404156,497.1901005,50.4050713,2.059377854,32.24517743}, /*cmy*/
          {10.81825595,1.722489249,5.217870279,1.973815755}, /*cfy*/
          {-2967.725643,316.533235,-2022.274204,513.7524829,-23.22129324,195.5922497}, /*cmz*/
          {5.59510103,-12.65825817,0.56731364,-5.075638012} /*cfz*/
     },
     {
          2460033.5,
          {-3878.070012,436.0348736,5298.936287,712.9005572,-30.31572653,118.2317412}, /*cmx*/
          {1.6619952,-6.532770859,0.4135329207,-105.2244368}, /*cfx*/
          {926.5270527,-95.19484046,1008.086912,162.9594484,6.496226861,28.9948208}, /*cmy*/
          {35.97692567,2.637425365,18.97339759,3.939382607}, /*cfy*/
          {4005.586294,-387.7409078,3871.431255,714.8630543,27.51280628,158.4579295}, /*cmz*/
          {4.384956982,8.768950422,6.209506505,3.589210074} /*cfz*/
     },
     {
          2460049.5,
          {3781.316507,-336.7196461,-4514.110706,-615.6883224,-24.01770198,29.6375021}, /*cmx*/
          {33.32716406,5.680276415,9.395242814,-2.556396686}, /*cfx*/
          {-122.226599,1.33923892,342.1364741,-31.13642668,-1.380785138,2.056424162}, /*cmy*/
          {51.63577441,1.443683871,4.914911682,1.788682231}, /*cfy*/
          {1526.307671,-205.4708389,-1437.156656,-346.0424064,-16.08223713,-16.28625496}, /*cmz*/
          {2.905859442,-0.0145716776,3.760214019,-0.2528505667} /*cfz*/
     },
     {
          2460065.5,
          {1085.876421,-132.7219552,2144.211244,266.6482615,13.02172155,-120.0134277}, /*cmx*/
          {4.781700595,3.45961527,0.9000670816,0.532046046}, /*cfx*/
          {-872.4328137,83.5827143,848.4231658,140.7783901,5.718420838,25.40215956}, /*cmy*/
          {20.29752595,5.850169802,3.344212155,18.6907622}, /*cfy*/
          {-5874.746467,543.4355119,5067.112724,-947.3836527,-37.04068039,-140.1426445}, /*cmz*/
          {1.398124204,2.582445826,0.05414768046,2.606951468} /*cfz*/
     },
     {
          2460081.5,
          {-6117.694613,596.2956116,7177.196843,1044.050435,40.51614245,-240.6471481}, /*cmx*/
          {14.36833545,-0.5830414926,3.163419163,3.046905483}, /*cfx*/
          {83.63079116,-4.718478493,-368.4399482,-36.89389916,-1.589571133,25.93770066}, /*cmy*/
          {13.91007297,4.727634434,1.930299555,1.918500845}, /*cfy*/
          {-3508.080715,369.5126853,-2606.322803,599.5576139,-26.37354518,202.6270298}, /*cmz*/
          {5.454208187,-19.0174699,0.493975673,1.09611274} /*cfz*/
     },
     {
          2460097.5,
          {-3995.996287,447.4999358,-5362.839647,730.3209188,30.97960209,121.9752271}, /*cmx*/
          {4.772690654,12.29756505,-2.74848666,-17.31151549}, /*cfx*/
          {796.1726168,-81.64698367,-856.6913435,-140.3241052,5.570185485,25.26247329}, /*cmy*/
          {20.27193828,5.780388743,0.120650527,3.923088275}, /*cfy*/
          {3792.039016,-363.6284621,3515.748139,-674.9791003,25.94730877,156.4986341}, /*cmz*/
          {4.355211781,-0.6697977537,6.187197193,3.5562288} /*cfz*/
     },
     {
          2460113.5,
          {3736.142573,-331.6056112,4535.34124,603.7326781,-23.4995898,29.20567095}, /*cmx*/
          {5.036170774,8.815213545,3.113978607,-2.422514348}, /*cfx*/
          {-99.55212295,0.2431615296,-296.2378929,26.25033946,-1.229670745,2.223658946}, /*cmy*/
          {17.05345257,4.542889061,4.888834143,1.578085866}, /*cfy*/
          {1631.862026,-212.5712019,-1560.494134,357.4887827,-16.27559206,-16.29515601}, /*cmz*/
          {2.829452684,9.369944239,3.729909771,-0.4044675743} /*cfz*/
     },
     {
          2460129.5,
          {915.6268284,-114.0448379,-1931.39017,-240.0177841,11.90503767,-114.9564383}, /*cmx*/
          {7.881631452,0.4017848402,0.9538073453,0.5313129553}, /*cfx*/
          {-797.0008508,76.30669929,-772.2222797,-129.3067181,5.219352476,23.17634681}, /*cmy*/
          {10.8633125,59.26388494,3.349481262,12.38403009}, /*cfy*/
          {-5666.00807,525.8953261,4819.821267,915.374128,-35.81006306,-135.8773327}, /*cmz*/
          {1.396320561,-0.551334157,0.05955930601,2.602144107} /*cfz*/
     },
     {
          2460145.5,
          {-6293.052195,619.5622567,7367.57775,-1075.593516,41.997525,-243.3351637}, /*cmx*/
          {1.811654811,2.582394696,3.19664933,3.119609104}, /*cfx*/
          {147.2782652,-10.96344727,-434.7014285,42.35782271,-1.740649718,26.86782045}, /*cmy*/
          {13.94762919,1.788362294,2.150967549,1.972799478}, /*cfy*/
          {-2593.440569,281.9811832,-1972.925591,466.2595202,21.13857401,-189.0178465}, /*cmz*/
          {5.73521887,18.79515003,22.59466081,4.359594135} /*cfz*/
     },
     {
          2460161.5,
          {-3005.471403,353.4176237,-4398.434421,-569.7892579,-24.98064058,112.8302491}, /*cmx*/
          {4.781678466,-3.320803427,-5.793835451,-4.486967474}, /*cfx*/
          {916.746365,-94.71333177,-972.8853869,161.8701897,-6.448720248,29.14921187}, /*cmy*/
          {20.29650098,2.667836188,3.292980159,3.971643606}, /*cfy*/
          {4464.064081,-437.897495,4113.546057,-780.2792388,30.40372244,-167.3150641}, /*cmz*/
          {4.455342315,5.691041926,0.002312261261,0.5299965034} /*cfz*/
     },
     {
          2460177.5,
          {3927.606704,-360.4175454,-4686.188643,635.7093237,25.06210209,31.09295364}, /*cmx*/
          {1.929596289,2.594525348,0.06067300231,3.976810774}, /*cfx*/
          {-195.6777214,8.682931138,417.9525312,-35.01304776,1.481082812,4.120376995}, /*cmy*/
          {39.12589537,1.809326546,2.176147599,1.2455016}, /*cfy*/
          {846.9097161,-136.2651888,-1357.891462,245.9710537,-11.78921636,14.01035347}, /*cmz*/
          {3.398279297,3.325044937,3.949371488,14.52303988} /*cfz*/
     },
     {
          2460193.5,
          {-615.8943441,36.18015225,481.787842,-212.6538236,-8.803547428,-89.8213808}, /*cmx*/
          {4.714128121,1.611135698,5.087267024,0.8059849487}, /*cfx*/
          {-805.4623154,78.07619121,-782.522687,-131.7394333,5.395841967,-25.4307209}, /*cmy*/
          {-8.005962247,2.769193375,15.97085186,3.018322121}, /*cfy*/
          {-5275.016567,499.6335225,-4533.695381,856.6226732,-34.04897046,134.2459975}, /*cmz*/
          {4.548366475,-0.4909780695,0.1283361892,12.17051037} /*cfz*/
     },
     {
          2460209.5,
          {-6368.572408,643.0759244,-7327.472267,-1092.437308,-43.4104834,-244.9747928}, /*cmx*/
          {-7.561832843,2.650448606,0.1396039421,3.327359614}, /*cfx*/
          {522.1468143,-47.9899776,852.8041167,-96.87966266,3.639727657,-33.37857074}, /*cmy*/
          {-7.890375902,5.430704099,-0.3340750699,5.468525951}, /*cfy*/
          {-124.8025225,40.12730937,-1946.057167,-201.2731523,9.972601124,162.8534991}, /*cmz*/
          {0.8715777448,4.154810912,4.581757997,1.652808173} /*cfz*/
     },
     {
          2460225.5,
          {-778.5133215,135.7581382,-2259.493753,246.8520544,12.46362695,-109.7522489}, /*cmx*/
          {4.832659253,0.3381947405,4.092530143,-0.7399537243}, /*cfx*/
          {998.2011857,-106.3493918,-1074.233728,-177.0785418,7.226145101,-32.11985456}, /*cmy*/
          {1.468998716,5.882336262,6.524558589,1.045831411}, /*cfy*/
          {5181.67687,-525.9192751,-4903.260935,898.7834833,-35.79112364,175.6629342}, /*cmz*/
          {7.695094974,2.647411689,3.270256143,3.882471572} /*cfz*/
     },
     {
          2460241.5,
          {3887.281369,-371.8004358,-4560.917203,634.6395374,-25.64266938,-30.42287679}, /*cmx*/
          {2.009982412,2.694216597,3.324529292,-5.285473026}, /*cfx*/
          {-449.3063302,34.04162117,-694.8578805,69.71475332,-2.655979807,-7.425797381}, /*cmy*/
          {-1.558048338,-0.8332834811,5.970983923,4.232255153}, /*cfy*/
          {-561.3685576,3.728489663,2035.392543,-154.0916091,7.123635274,26.18800986}, /*cmz*/
          {26.23273244,1.406397105,1.77897874,1.134207609} /*cfz*/
     },
     {
          2460257.5,
          {-2457.264628,223.2920956,1271.428779,448.1253965,-16.60612883,65.82051509}, /*cmx*/
          {-17.17833546,5.441318195,12.24859921,4.552267488}, /*cfx*/
          {-509.3843399,51.374941,-520.6536479,-85.85561031,-3.769348912,22.0383867}, /*cmy*/
          {4.455028682,2.964348027,6.743818036,0.06117379161}, /*cfy*/
          {-4091.777412,400.2268986,3527.994336,673.6415486,-27.63569308,-119.9941744}, /*cmz*/
          {7.66154496,5.897841793,0.2486172384,15.49319889} /*cfz*/
     },
     {
          2460273.5,
          {-5214.5082,549.0776219,-6121.557895,913.0095588,-37.26781505,223.2084388}, /*cmx*/
          {-1.179045072,5.885144213,6.530234265,0.4302452618}, /*cfx*/
          {938.1454855,-91.70555913,1266.514668,-163.5720731,6.289690067,38.18612258}, /*cmy*/
          {-1.494347551,-0.6257782894,6.257210228,2.787917204}, /*cfy*/
          {2632.033224,-236.8113975,4307.908271,480.1393139,-17.94279155,-160.566265}, /*cmz*/
          {-8.007589885,8.57145255,2.808951757,5.375176899} /*cfz*/
     },
     {
          2460289.5,
          {1828.067959,-125.4381022,288.975627,-310.5278431,11.96319357,136.1666891}, /*cmx*/
          {4.538880487,5.262007958,5.709052574,2.966718611}, /*cfx*/
          {620.9129734,-71.40485887,-726.722741,-115.0612545,4.937256534,-24.98252764}, /*cmy*/
          {7.716347875,-0.2642838728,0.4024971856,1.482781468}, /*cfy*/
          {4939.29317,-519.2737243,4744.72703,863.3780502,-35.2139026,-168.1854082}, /*cmz*/
          {-26.82470553,2.736989458,3.382038132,0.9947275322} /*cfz*/
     },
     {
          2460305.5,
          {3368.966894,-333.4387858,-4037.800526,-554.1482376,23.13996476,-25.60776164}, /*cmx*/
          {14.68832554,5.951075213,6.59890082,-187.0697312}, /*cfx*/
          {-598.7539281,52.55486532,-817.6916811,-94.1739929,3.647824587,-8.873137463}, /*cmy*/
          {4.840933458,8.818004717,9.422900253,4.24310632}, /*cfy*/
          {-1980.583056,151.6069126,3306.484476,-319.2690286,12.16951063,-47.85742817}, /*cmz*/
          {13.98255644,2.282893994,2.785582534,4.093541376} /*cfz*/
     },
     {
          2460321.5,
          {-3533.355274,342.7035633,2326.048791,620.5207841,-23.76375148,-61.55790408}, /*cmx*/
          {8.005335331,5.631193125,6.215119427,-4.241424334}, /*cfx*/
          {-21.37683078,4.458142438,-147.0308761,26.44412952,-1.297482086,-11.85286845}, /*cmy*/
          {3.497814848,1.070919611,1.41799881,-15.3188528}, /*cfy*/
          {-2352.185808,243.8864844,1973.923741,408.3212663,-17.84151438,-92.59606823}, /*cmz*/
          {7.485925243,-6.465812083,6.744096501,3.084258064} /*cfz*/
     },
     {
          2460337.5,
          {-3097.147506,356.3973372,4181.49569,-584.0828026,25.05169433,185.3637689}, /*cmx*/
          {2.163325253,2.902375146,3.557878838,0.7050279603}, /*cfx*/
          {863.1639556,-87.98758864,-1121.097361,-150.8710373,5.970072866,-32.92303186}, /*cmy*/
          {1.734290023,5.780275418,12.69667707,-6.265083601}, /*cfy*/
          {4587.630726,-439.7687499,6178.608355,786.7355158,30.16588128,-179.4439616}, /*cmz*/
          {23.53812654,-3.774958129,6.242658333,5.806815317} /*cfz*/
     },
     {
          2460353.5,
          {3988.576304,-347.7210471,-2392.741475,635.8840811,-24.46647114,171.9455376}, /*cmx*/
          {14.26636763,2.482809318,3.062260239,3.304294269}, /*cfx*/
          {35.21527321,-11.93652215,-178.1335208,24.99689827,-1.35177194,-17.11055364}, /*cmy*/
          {0.9537480842,3.735484122,4.270873928,2.282956787}, /*cfy*/
          {3684.922515,-407.230282,-3516.897766,-663.2174157,-28.02644207,150.6029531}, /*cmz*/
          {13.9863138,-6.571692069,3.516122095,-1.817034805} /*cfz*/
     },
     {
          2460369.5,
          {2467.926274,-252.5177458,3267.010018,-411.8827999,-18.05732411,25.68731523}, /*cmx*/
          {5.432327074,-6.457718436,-2.653968014,-0.8605616725}, /*cfx*/
          {-486.8019448,45.90830216,641.8459084,77.89111565,-3.114163278,-6.595574356}, /*cmy*/
          {-48.45238607,-0.4621852466,0.1871306017,4.461917268}, /*cfy*/
          {-3145.053708,279.9634477,4455.942359,-508.675733,-19.75984172,69.19059416}, /*cmz*/
          {1.537125813,2.518725446,6.241842769,0.9723673921} /*cfz*/
     },
     {
          2460385.5,
          {-3781.038848,383.0476089,-2596.88238,-669.1486451,-26.3407958,-62.69787312}, /*cmx*/
          {11.22070954,15.16204362,6.344956353,2.417016578}, /*cfx*/
          {259.2289973,-24.37076968,235.9045701,-49.48834385,-1.807185,4.5329889}, /*cmy*/
          {-7.306090238,11.75969911,40.54465707,1.246552333}, /*cfy*/
          {-601.7354831,81.52123538,852.0196254,181.5157637,9.124967836,-62.03935588}, /*cmz*/
          {6.478183903,0.4786859212,4.158577052,3.231123025} /*cfz*/
     },
     {
          2460401.5,
          {-714.7703608,130.9167145,2440.724757,248.141962,12.1806883,149.259507}, /*cmx*/
          {2.678154866,0.2933988415,4.026132166,7.334884944}, /*cfx*/
          {427.7454777,-46.93775245,598.4081897,78.436125,3.245469749,-20.40755298}, /*cmy*/
          {-1.258265787,2.786800343,0.3048952062,0.4009868632}, /*cfy*/
          {5449.120077,-536.7971574,6987.258962,926.6814288,36.34306626,-194.2958276}, /*cmz*/
          {4.744902785,2.604953304,0.08076306255,-0.2052526821} /*cfz*/
     },
     {
          2460417.5,
          {5322.529393,-491.2970093,-3701.349213,850.9678714,33.44584938,198.0811666}, /*cmx*/
          {8.031349414,2.597606002,0.07078589721,3.520576012}, /*cfx*/
          {-317.6320456,26.37657766,227.7236373,50.63765481,1.909128758,-15.61256972}, /*cmy*/
          {-4.268332741,5.574374379,28.10828354,3.062318016}, /*cfy*/
          {1855.086934,-231.659343,1754.260672,378.9548466,17.33676959,-137.699954}, /*cmz*/
          {4.343336187,3.103965182,6.911747453,1.746943886} /*cfz*/
     },
     {
          2460433.5,
          {1336.925013,-144.6744442,2456.023717,-245.9022979,-11.8648304,40.65579283}, /*cmx*/
          {-0.5502992374,0.150790938,3.938943804,-0.1785967538}, /*cfx*/
          {-260.2542701,25.87073499,358.5358133,-42.25554298,-1.783116874,-3.598827763}, /*cmy*/
          {2.013721369,-9.710210503,0.3943246466,5.115228589}, /*cfy*/
          {-3900.763679,369.6988721,-5228.207638,-640.1869804,25.43395644,-84.13201943}, /*cmz*/
          {161.8204099,2.627482068,3.241338774,4.199869252} /*cfz*/
     },
     {
          2460449.5,
          {-3528.118041,372.1778538,-2379.847715,-637.8330953,-25.72030692,-60.4843436}, /*cmx*/
          {5.025153892,2.681128575,0.160959519,2.613694238}, /*cfx*/
          {285.7093365,-28.77743342,232.2977363,51.75209451,2.00152127,3.667812398}, /*cmy*/
          {23.98142155,-3.719781321,6.293829169,2.288426614}, /*cfy*/
          {783.724695,-50.45638233,-1524.772675,198.4722562,-8.013697843,36.82049425}, /*cmz*/
          {2.286899088,1.77493503,2.13443956,0.2561502165} /*cfz*/
     },
     {
          2460465.5,
          {1352.484356,-69.92750113,2204.647542,244.4789825,9.651546038,-129.4007416}, /*cmx*/
          {3.600475569,1.82628933,5.344179103,4.59846683}, /*cfx*/
          {85.81855261,-13.29943929,-225.4169758,-23.40492919,-1.106965,-11.71946907}, /*cmy*/
          {2.321279081,0.1053027864,3.880587338,7.146531607}, /*cfy*/
          {5412.733693,-544.8004093,6917.997925,922.7251435,-36.9018328,197.3565513}, /*cmz*/
          {4.782335717,2.673241438,3.303997792,3.11834515} /*cfz*/
     },
     {
          2460481.5,
          {5851.715668,-555.3403163,-4213.09431,940.5817901,-37.52630304,-210.5100613}, /*cmx*/
          {1.779165931,2.662484369,3.293230963,0.5405951967}, /*cfx*/
          {-393.9056188,35.7319219,294.2935575,-62.60066398,2.447429095,-15.20646729}, /*cmy*/
          {1.867204488,2.57071355,-3.10574336,3.375476164}, /*cfy*/
          {53.34620367,-54.42287551,825.6230492,-179.7807786,9.224877354,140.1608459}, /*cmz*/
          {2.969063334,0.8763875866,1.342945175,-0.9796891843} /*cfz*/
     },
     {
          2460497.5,
          {230.9371589,-36.20570893,1990.423186,-149.7003085,7.739239547,-60.0265085}, /*cmx*/
          {-0.06100198473,1.0219947,1.465144988,3.280676571}, /*cfx*/
          {-174.9558647,18.03777,-260.6899321,-29.26264862,-1.316953219,-3.628371491}, /*cmy*/
          {-0.950375128,9.338332181,0.5674030309,-0.7966880484}, /*cfy*/
          {-4208.149854,412.1931428,5558.418553,697.1629304,-28.18235446,90.03162693}, /*cmz*/
          {1.641650895,5.833832421,-62.65041343,1.168621551} /*cfz*/
     },
     {
          2460513.5,
          {-3106.887334,340.6834744,-1976.969975,577.6954283,-23.79525551,56.89943668}, /*cmx*/
          {5.109493529,5.898080178,6.528111071,-0.4283838658}, /*cfx*/
          {278.6828303,-28.81436027,-221.6608224,-49.96026496,2.012442957,3.336396783}, /*cmy*/
          {8.300199265,-19.37225803,-6.194978097,2.589999298}, /*cfy*/
          {1701.390857,-141.2249651,2288.438433,316.8860253,11.87591911,-20.7382154}, /*cmz*/
          {-1.039494073,2.182461793,-0.4866178517,3.65736009} /*cfz*/
     },
     {
          2460529.5,
          {2826.077791,-216.5055033,3083.156789,445.4053866,-16.56366112,126.7897558}, /*cmx*/
          {4.094138079,8.545274471,2.772888762,1.816684832}, /*cfx*/
          {48.07948606,-9.970221664,207.5956463,19.52747798,-0.9517367497,-11.62192548}, /*cmy*/
          {-0.7159143308,-2.771184391,-2.223515951,-11.66984955}, /*cfy*/
          {4923.274187,-506.6437051,6432.614318,847.154838,34.49565294,192.9434788}, /*cmz*/
          {11.10180597,2.730942652,6.512225013,-3.030004482} /*cfz*/
     },
     {
          2460545.5,
          {5835.59097,-562.9774045,4173.979755,942.1569848,-38.02356538,211.5888027}, /*cmx*/
          {4.934324431,2.705841652,3.345400138,3.808175314}, /*cfx*/
          {-472.0326114,42.56890745,-369.7983031,74.53655512,-2.914975589,-18.53056804}, /*cmy*/
          {5.016378946,-0.5988354095,0.01127309094,-2.986505233}, /*cfy*/
          {-1291.122039,79.11624617,1704.686977,-255.5997232,-10.1371222,150.4373166}, /*cmz*/
          {2.191837997,1.913054759,5.447268343,-0.6881283826} /*cfz*/
     },
     {
          2460561.5,
          {-543.6212447,41.05655195,-2036.112794,-189.5432553,8.056647161,72.53938251}, /*cmx*/
          {3.519878675,1.781690562,2.145782834,0.2889219289}, /*cfx*/
          {-269.1529319,27.73084852,383.2747445,-44.68576723,-1.991398908,5.632701247}, /*cmy*/
          {2.063225225,-3.275426376,0.5139970263,-10.48225239}, /*cfy*/
          {-4188.010999,416.309141,5553.642186,-697.0255878,-28.45069248,88.1545055}, /*cmz*/
          {1.675994146,2.729710553,6.51001044,1.262584581} /*cfz*/
     },
     {
          2460577.5,
          {-2747.845583,310.4341492,1608.012584,-523.293127,-21.9594075,-54.19365847}, /*cmx*/
          {2.022433087,2.811118214,0.3035291946,2.763326281}, /*cfx*/
          {361.6608497,-36.79778909,312.2364427,64.28778244,2.561625933,-3.520305467}, /*cmy*/
          {24.03859789,21.43651151,6.334869565,-0.5984106187}, /*cfy*/
          {2147.431605,-187.6941798,2638.431616,384.5198903,-14.4568557,-13.93765001}, /*cmz*/
          {-1.071660064,14.86860678,2.812662422,4.048060972} /*cfz*/
     },
     {
          2460593.5,
          {3491.505225,-284.7788002,3662.766289,548.6301281,20.53427467,-128.3264219}, /*cmx*/
          {-2.044707736,2.361518082,6.051999349,5.146634915}, /*cfx*/
          {120.6759063,-18.53446938,322.1960789,-32.61862975,-1.549261647,-16.18403603}, /*cmy*/
          {-0.9306987013,0.146236618,3.89692132,7.062131845}, /*cfy*/
          {4438.52444,-464.4433444,5967.067167,772.8650886,-31.77922564,185.3327009}, /*cmz*/
          {4.846331855,2.768804305,3.413193191,-2.954505512} /*cfz*/
     },
     {
          2460609.5,
          {5654.325236,-547.8199635,-3979.825832,911.6684435,37.01204824,-206.809691}, /*cmx*/
          {1.791634554,2.718811302,6.50353723,0.7124356021}, /*cfx*/
          {-581.3851876,52.38890894,-475.6573964,-92.27587751,-3.581117673,-23.26531548}, /*cmy*/
          {5.04979848,2.540005077,62.8319148,3.251828337}, /*cfy*/
          {-1691.483102,120.0420516,2016.5199,-302.357538,11.62219905,152.3672842}, /*cmz*/
          {2.125245079,2.080077812,2.515965056,-0.59950212} /*cfz*/
     },
     {
          2460625.5,
          {-623.5271597,49.45590759,2068.357343,-200.1041907,-8.219847392,-72.36209719}, /*cmx*/
          {0.4320518717,1.833881499,5.349389237,3.43276648}, /*cfx*/
          {-313.8197565,32.17480287,-458.6400349,52.22373146,2.282584863,-6.333460642}, /*cmy*/
          {-1.127088007,-6.461082579,-2.654434238,-1.058097141}, /*cfy*/
          {-4113.110339,408.9872636,5481.202379,-687.689057,-27.97264985,85.67555589}, /*cmz*/
          {1.681258076,2.731668415,0.2261312114,1.258948997} /*cfz*/
     },
     {
          2460641.5,
          {-2691.271116,304.4914717,-1554.920062,-511.162077,21.57842468,52.25249034}, /*cmx*/
          {5.178709346,2.810259431,3.444348676,-0.36970385}, /*cfx*/
          {386.0312102,-38.93819561,344.04164,-69.21928252,-2.708310881,3.929401088}, /*cmy*/
          {-13.63867373,24.57420392,3.174584885,2.437987195}, /*cfy*/
          {2070.483337,-179.6585381,2576.463157,370.2212378,-13.99624416,-13.16703707}, /*cmz*/
          {-1.059519538,21.14894843,2.800037618,4.038073194} /*cfz*/
     },
     {
          2460657.5,
          {3237.152801,-259.9724247,-3400.556334,509.2808778,-18.98166737,122.716741}, /*cmx*/
          {1.050337836,2.338910309,2.885324714,1.947576366}, /*cfx*/
          {98.03850039,-16.15374202,303.9626875,29.81771328,1.438415512,15.58936013}, /*cmy*/
          {-7.196151776,3.333901149,0.817993642,-8.602870345}, /*cfy*/
          {4413.297411,-458.8939466,5922.63226,767.0982032,-31.36205978,180.6543354}, /*cmz*/
          {4.83277869,2.761511514,3.404668872,3.300178162} /*cfz*/
     },
     {
          2460673.5,
          {5611.545595,-539.0968447,-3955.243631,898.5119458,-36.35649017,203.9361379}, /*cmx*/
          {8.084324506,2.698459342,3.33929441,3.791067208}, /*cfx*/
          {-520.7153469,47.46253789,-425.4890506,83.16873972,-3.225307011,20.40145167}, /*cmy*/
          {-1.210700355,-0.565780769,6.318147257,0.1755671739}, /*cfy*/
          {-1130.321413,66.89389731,1614.431161,-227.9798619,9.300640205,144.1007213}, /*cmz*/
          {2.234776776,1.868876962,2.245042357,-0.7215122597} /*cfz*/
     },
     {
          2460689.5,
          {-139.292236,2.265294859,1940.285669,-159.2347806,7.25894991,64.70211885}, /*cmx*/
          {0.1292128904,1.442193079,1.800944418,0.1788325907}, /*cfx*/
          {-197.2587769,20.3435894,-318.8485384,33.25795262,-1.46882626,4.459690084}, /*cmy*/
          {-1.049507887,18.7116731,6.83986824,2.434375995}, /*cfy*/
          {-4066.350714,402.3973572,5437.519445,-683.993112,27.53710163,87.0196133}, /*cmz*/
          {1.643985601,2.705249051,3.334149455,1.178201379} /*cfz*/
     },
     {
          2460705.5,
          {-2833.086279,314.3517581,-1761.135236,528.8385529,-22.09292175,-49.37869314}, /*cmx*/
          {5.198646261,5.910543695,0.2577933691,2.726774141}, /*cfx*/
          {287.0090706,-29.49356974,244.6745535,52.50623694,-2.037324266,-3.533930689}, /*cmy*/
          {42.92750408,15.19614571,3.225547915,5.568114839}, /*cfy*/
          {1666.765478,-136.1985152,2314.665498,-303.0094982,-11.49756166,-15.93067092}, /*cmz*/
          {-1.035596284,11.63211235,2.669026131,3.595726639} /*cfz*/
     },
     {
          2460721.5,
          {2574.863118,-194.1672027,2730.660766,406.0014325,15.02851829,-114.8285287}, /*cmx*/
          {4.017410783,8.530143265,1061.481557,4.89632933}, /*cfx*/
          {-57.98431701,0.9016061177,-137.7412964,-13.7988647,0.6607278764,9.722897882}, /*cmy*/
          {2.95833906,1.39909413,1.755072055,-1.934656652}, /*cfy*/
          {4565.819789,-465.6690308,6002.298021,-783.5596074,-31.72576907,-176.4314802}, /*cmz*/
          {4.789044035,5.874122387,3.372151854,-6.208889904} /*cfz*/
     },
     {
          2460737.5,
          {5500.693286,-523.2670445,3917.861298,876.01248,35.24083662,-200.6298826}, /*cmx*/
          {-1.306033445,2.67668825,6.45463346,0.5655648089}, /*cfx*/
          {-403.5744541,38.34685775,-310.5760887,-65.70563726,-2.591774871,14.85777098}, /*cmy*/
          {99.28429601,8.960006784,0.1593884119,0.4952674536}, /*cfy*/
          {-459.2008293,4.981153899,1231.924583,167.6823771,7.908703124,-137.0272825}, /*cmz*/
          {2.387165776,4.564279697,1.781403531,2.251010228} /*cfz*/
     },
     {
          2460753.5,
          {225.1865108,-32.50176932,-1933.690975,-143.58327,-7.165550749,-60.48879832}, /*cmx*/
          {2.971686302,1.040346509,4.607039451,3.22538675}, /*cfx*/
          {23.11441135,-1.652436898,115.8258108,9.075311146,0.4473167337,4.908816469}, /*cmy*/
          {3.213210065,1.72374668,5.206944989,3.44138264}, /*cfy*/
          {-3913.101686,388.3221493,5276.668052,-662.7098394,-26.56137895,-88.85897637}, /*cmz*/
          {1.595725485,-41.29563258,0.1716983107,4.280289214} /*cfz*/
     },
     {
          2460769.5,
          {-2824.042086,310.0958019,1873.987673,523.771419,21.65718563,43.83931313}, /*cmx*/
          {2.118546335,5.887158187,3.373954037,-0.4810752223}, /*cfx*/
          {162.7277813,-18.44561915,-97.39071684,32.00980904,-1.287995003,-3.287449107}, /*cmy*/
          {2.130884731,2.812795865,3.448920056,-0.5753607877}, /*cfy*/
          {1389.247318,-105.9945637,2175.745465,254.6989565,9.700909995,18.13611115}, /*cmz*/
          {-1.036748289,-4.154701715,5.707165311,0.1090845034} /*cfz*/
     },
     {
          2460785.5,
          {2335.278557,-172.6505438,-2393.845177,-367.2698839,-13.60427054,108.3644969}, /*cmx*/
          {0.7792499878,11.64693332,2.728424688,1.676324801}, /*cfx*/
          {-280.1881541,24.29755779,-289.6920002,43.79769365,1.674642983,-9.064079031}, /*cmy*/
          {-1.902175467,-0.6611901801,3.043140364,2.269043534}, /*cfy*/
          {4392.041335,-443.1181093,5730.632007,745.957862,30.20309357,167.2255505}, /*cmz*/
          {4.753497122,2.726420652,6.506623567,3.175597868} /*cfz*/
     },
     {
          2460801.5,
          {5251.895797,-500.8728448,3772.533175,-837.975112,-33.73257516,195.2399549}, /*cmx*/
          {5.02894831,5.827754095,3.323424899,3.711112535}, /*cfx*/
          {-289.3227028,29.24912304,176.5191416,-48.57251726,-2.018245654,-12.65708244}, /*cmy*/
          {14.37671999,2.847096859,0.3617658612,4.212811116}, /*cfy*/
          {-645.3332142,28.60118689,1513.519551,-179.7066864,-7.843380624,135.5186015}, /*cmz*/
          {2.209574796,1.642146279,5.134644045,-0.8628631636} /*cfz*/
     },
     {
          2460817.5,
          {-187.0780085,9.526515203,-1780.270095,143.0535273,6.495997398,68.87303533}, /*cmx*/
          {3.109237489,4.669700034,1.886149274,0.1819308778}, /*cfx*/
          {212.2348494,-20.95990229,-276.8012716,-37.65613142,-1.479772669,-7.764042917}, /*cmy*/
          {1.229793287,5.684000929,9.396935095,0.7673961436}, /*cfy*/
          {-3706.457055,374.9665883,5057.768068,-631.4054466,25.56724713,88.71718238}, /*cmz*/
          {1.57850997,2.710110792,3.345068234,1.219740235} /*cfz*/
     },
     {
          2460833.5,
          {-2490.979742,279.1093943,1664.016033,-469.9199293,-19.49439896,-37.07125581}, /*cmx*/
          {2.258927572,-3.50216201,0.2747358479,2.600475899}, /*cfx*/
          {44.39236818,-7.857554472,-49.20293502,14.96065047,0.7058569794,2.900050272}, /*cmy*/
          {4.82015869,3.352110013,0.8192991857,-16.20577641}, /*cfy*/
          {1652.906877,-132.70445,2464.780124,285.3803511,-10.7297898,-13.57610983}, /*cmz*/
          {-1.080273146,-4.038684888,2.737210793,-9.626613691} /*cfz*/
     },
     {
          2460849.5,
          {3000.092366,-244.1136381,-2774.410285,467.3798134,17.50732339,-104.0315018}, /*cmx*/
          {0.9859831338,2.372336452,6.063519148,5.05104158}, /*cfx*/
          {-379.2471714,35.41557872,-423.9706771,-60.9168489,2.405559856,11.74080333}, /*cmy*/
          {4.549894349,-9.946873183,3.236545444,-0.3656748153}, /*cfy*/
          {3606.649885,-368.8062867,4894.816788,614.0141257,-25.39096135,151.3783842}, /*cmz*/
          {4.753697989,2.781299355,3.424595529,3.258101128} /*cfz*/
     },
     {
          2460865.5,
          {4577.718336,-445.9879897,3157.083269,738.3118791,-30.18311031,-182.4697206}, /*cmx*/
          {5.116030072,9.03551614,34.81617,0.7451123314}, /*cfx*/
          {-107.5690095,11.96984788,-14.85429483,20.32718195,-0.9726240861,10.68781555}, /*cmy*/
          {1.98105806,-6.161943021,0.7570924408,1.63808954}, /*cfy*/
          {-2103.84424,179.129411,2896.612851,370.8568658,13.95032062,146.5650577}, /*cmz*/
          {1.980138014,30.55752787,2.797638789,-0.5211040397} /*cfz*/
     },
     {
          2460881.5,
          {-1574.671379,151.6911898,-2059.657663,308.7387157,-11.84346941,-93.55919614}, /*cmx*/
          {3.865678149,-13.36833596,-69.40523483,3.601504666}, /*cfx*/
          {247.0845399,-25.33177168,325.4060531,43.57976826,-1.730308238,7.684369321}, /*cmy*/
          {23.33324261,-3.66118444,9.53397501,4.113707214}, /*cfy*/
          {-3160.520289,333.425725,4543.297625,544.3998966,-22.75770552,81.67337489}, /*cmz*/
          {1.614654384,5.940063375,0.3114831072,1.525719887} /*cfz*/
     },
     {
          2460897.5,
          {-1592.83758,197.8166883,995.4041582,-331.3155408,14.25202496,29.56607833}, /*cmx*/
          {2.802026658,-3.345642253,3.586977092,5.584869908}, /*cfx*/
          {-33.93308182,-0.003368990173,123.4199168,-9.388674644,0.4267735773,1.648351109}, /*cmy*/
          {1.774936222,1.398287027,1.683235545,27.65998701}, /*cfy*/
          {2398.715144,-213.7941649,3106.003227,398.5000292,15.22608165,6.372097056}, /*cmz*/
          {-1.093862876,8.740586503,6.175856878,5.073625425} /*cfz*/
     },
     {
          2460913.5,
          {4031.921224,-358.7229555,-3725.737133,-634.5917616,24.51184901,111.9986256}, /*cmx*/
          {1.225856324,-0.6026014455,11711.84826,2.384543607}, /*cfx*/
          {-281.1280114,26.67109411,-317.1486584,45.31038837,-1.819721314,8.94244833}, /*cmy*/
          {4.535007303,5.817613995,0.1791083354,18.63557039}, /*cfy*/
          {1758.589398,-196.1608937,3096.732033,324.9002762,-14.65078304,120.3554074}, /*cmz*/
          {4.817432668,3.033211388,3.675439805,204.5846985} /*cfz*/
     },
     {
          2460929.5,
          {2538.612002,-259.1240056,1265.199687,424.4592242,-18.44125975,149.3629636}, /*cmx*/
          {5.592744185,-15.88383192,3.628690761,4.330329623}, /*cfx*/
          {-18.97266316,2.539401762,-87.94339604,-8.149612351,0.4350432209,7.710582944}, /*cmy*/
          {1.651264145,4.087428076,4.483752954,1.844335094}, /*cfy*/
          {-3980.079964,378.496514,4572.311083,670.583312,-25.95600874,174.0967118}, /*cmz*/
          {1.940710371,-0.5985854032,6.289888732,-0.05421947095} /*cfz*/
     },
     {
          2460945.5,
          {-3102.598436,317.0784195,-3344.689836,-551.2298418,21.8149013,118.3546598}, /*cmx*/
          {4.346033572,-3.679449931,3.207548379,0.7732875928}, /*cfx*/
          {199.584498,-20.80047087,247.7890999,35.94611904,1.415600953,6.602071911}, /*cmy*/
          {10.73050965,2.628945747,6.406983745,4.083749531}, /*cfy*/
          {-1508.557361,180.5381353,-2974.443196,285.837824,-13.15881261,73.41660656}, /*cmz*/
          {4.854549529,6.214334468,6.888910608,2.266116237} /*cfz*/
     },
     {
          2460961.5,
          {-58.72538343,51.91540512,-1359.883912,128.7279087,-6.429045478,23.71280477}, /*cmx*/
          {20.02484363,0.6060440572,1.142692007,5.068467576}, /*cfx*/
          {-33.55492505,0.3975041694,112.2302902,-7.610360688,-0.3517242088,1.160285388}, /*cmy*/
          {-4.736251179,1.545406029,4.978221224,1.80620108}, /*cfy*/
          {2860.64446,-274.2319052,-3387.758356,477.663546,-18.9233078,-9.024131523}, /*cmz*/
          {2.119304868,8.910046645,3.247171468,-5.38476566} /*cfz*/
     },
     {
          2460977.5,
          {3966.92917,-371.6376692,-3849.09313,632.3303636,-25.32231908,-116.8154867}, /*cmx*/
          {13.87701813,2.672450862,3.293909374,5.917839222}, /*cfx*/
          {-226.3714728,21.36399458,-232.3295242,-36.32032109,1.457417764,-6.969120262}, /*cmy*/
          {-1.82211376,8.976675197,3.326562769,-72.54274563}, /*cfy*/
          {-756.3406122,48.19737423,724.6536076,-177.4452644,6.977140537,79.28437117}, /*cmz*/
          {350.845711,1.810828098,2.163306992,4.068818813} /*cfz*/
     },
     {
          2460993.5,
          {-375.6019382,24.94453323,2137.113348,-162.4462629,6.957191039,-126.0065902}, /*cmx*/
          {-4.887641949,1.60890605,1.972092636,1.920274679}, /*cfx*/
          {41.67622124,-3.404512533,147.8553572,11.82443136,-0.4761143858,-7.81387324}, /*cmy*/
          {-1.652053154,1.860745117,2.251859031,-1.11834577}, /*cfy*/
          {-4330.997465,433.844037,-4727.32204,-733.8322333,29.353219,180.9180433}, /*cmz*/
          {5.156649653,2.675084274,3.309787559,0.3193931447} /*cfz*/
     },
     {
          2461009.5,
          {-3419.725639,365.4139192,-3802.469934,-608.8289089,-24.80469615,-120.3122632}, /*cmx*/
          {-1.812447462,2.724699366,0.2227632693,4.221029828}, /*cfx*/
          {212.1694825,-22.94623226,241.9812626,37.83093634,-1.557534901,-7.44756802}, /*cmy*/
          {4.497338719,2.755146759,3.391944138,1.17146923}, /*cfy*/
          {706.4093178,-37.26013544,-878.3616272,156.0932645,-6.520089362,94.42613525}, /*cmz*/
          {-1.038165067,1.839290997,2.200665603,3.009280466} /*cfz*/
     },
     {
          2461025.5,
          {1325.381133,-86.66420761,2622.220864,207.968977,7.958332422,-28.7390337}, /*cmx*/
          {17.25580042,2.144860413,5.741642917,1.344469565}, /*cfx*/
          {-117.2138577,8.99585976,194.7190762,-17.6742149,-0.6903310256,-2.157609863}, /*cmy*/
          {1.649425198,-60.50008865,-0.2450584751,4.538213997}, /*cfy*/
          {2601.657821,-261.5011489,3046.940766,-440.0308142,18.17367106,-7.680578215}, /*cmz*/
          {5.40443291,-0.3724715132,-6.017557243,-5.151734428} /*cfz*/
     },
     {
          2461041.5,
          {2812.358368,-272.9627244,2885.326331,455.6250821,-19.06054962,101.3325267}, /*cmx*/
          {4.402841968,2.817067415,3.458824162,21.85806272}, /*cfx*/
          {-135.5933258,13.40056827,159.4273245,22.10571753,-0.9670950566,-6.516991234}, /*cmy*/
          {1.26776005,-6.464484693,6.705647024,9.444807413}, /*cfy*/
          {-2382.045689,216.061256,-1049.08058,409.7954886,-15.40764889,-61.92881367}, /*cmz*/
          {4.439227531,5.537254531,-0.1904551331,1.629270729} /*cfz*/
     },
     {
          2461057.5,
          {-2344.1843,224.8828362,4028.969749,-428.5828075,16.14292066,134.7475884}, /*cmx*/
          {1.59733455,2.394827161,2.94839921,5.607389467}, /*cfx*/
          {260.2072679,-25.79010144,359.4548327,45.00510458,-1.769065676,-11.41089965}, /*cmy*/
          {4.887129997,-3.755118404,3.144008706,-0.2238484441}, /*cfy*/
          {-3322.484452,350.7276691,-3764.304226,-578.3676715,23.94957071,-162.9764736}, /*cmz*/
          {5.311360758,-3.493983926,3.43750084,3.735216543} /*cfz*/
     },
     {
          2461073.5,
          {-2870.487948,321.3379611,3326.00299,526.1847778,-21.9967832,112.9862619}, /*cmx*/
          {1.327026233,-0.3250447729,6.617847555,1.354832242}, /*cfx*/
          {62.47908844,-9.92280071,140.8077823,-16.36024203,0.8025683539,-7.364285284}, /*cmy*/
          {4.484490089,0.2351942106,0.8170975503,2.217515354}, /*cfy*/
          {2261.833408,-193.6052495,818.4642835,-372.9337882,-14.28126142,-120.4139269}, /*cmz*/
          {4.349762886,11.83410467,15.5283333,0.1877769179} /*cfz*/
     },
     {
          2461089.5,
          {2089.109782,-167.1853537,3376.13236,-327.8324503,12.49318138,38.18810148}, /*cmx*/
          {4.762873253,11.83923339,-0.192552834,4.277481781}, /*cfx*/
          {-253.4545495,23.62023126,326.6637139,-39.37664172,1.63174268,-2.883916316}, /*cmy*/
          {1.935692118,2.665119197,135.2592586,4.593959178}, /*cfy*/
          {2174.465097,-224.3450358,2700.825645,370.8124771,15.92836655,-8.091131613}, /*cmz*/
          {11.82937392,2.891755071,0.3931009262,8.388437597} /*cfz*/
     },
     {
          2461105.5,
          {1786.687715,-179.7914185,1952.497205,301.660255,-13.35854763,83.08601099}, /*cmx*/
          {4.2364781,2.997984064,3.648042207,3.12838794}, /*cfx*/
          {105.1037493,-9.598125812,43.05193879,22.66942526,-0.7986093179,4.890111643}, /*cmy*/
          {-0.4682775736,-4.158368717,2.624793567,7.120402811}, /*cfy*/
          {-2940.429386,281.2992396,-1586.386823,-504.7531819,-19.48143477,59.81462785}, /*cmz*/
          {4.645399878,-3.775750392,6.239396817,5.168440468} /*cfz*/
     },
     {
          2461121.5,
          {-3198.554592,314.0007221,4867.772561,565.2454711,-21.6265904,144.5147076}, /*cmx*/
          {1.626270124,-0.6325136141,-0.04398072072,-0.4516308276}, /*cfx*/
          {396.6001838,-41.75823067,-503.6090246,68.88940309,-2.82768306,17.88128596}, /*cmy*/
          {14.5254672,2.705803582,3.352019755,3.462513628}, /*cfy*/
          {-2339.074288,263.414102,-3037.558924,429.6286499,18.42999661,146.7545289}, /*cmz*/
          {-0.8026843976,-6.522512151,3.554020494,0.7637532668} /*cfz*/
     },
     {
          2461137.5,
          {-2391.084207,277.1511795,2787.077831,451.5278317,19.26663364,110.8840821}, /*cmx*/
          {1.279212845,6.024498147,3.552475911,1.515372971}, /*cfx*/
          {-208.3150782,15.35093878,54.63917172,-35.00873839,1.298051126,14.00669638}, /*cmy*/
          {-10.45393148,-10.33806705,2.73122135,-0.1138249468}, /*cfy*/
          {2990.075241,-265.9802485,1443.790021,-482.4040712,-18.69651362,134.3780724}, /*cmz*/
          {4.64990899,-0.6418674411,3.087289815,3.431972015} /*cfz*/
     },
     {
          2461153.5,
          {2386.076003,-200.5006007,3693.997983,-380.4955313,14.5958134,45.30693004}, /*cmx*/
          {4.756167452,-0.6605499463,6.175922443,4.212047523}, /*cfx*/
          {-348.332053,34.10643845,439.8683404,-55.62690747,-2.37766523,3.217143616}, /*cmy*/
          {14.70474016,-3.472008985,6.604192161,14.28968271}, /*cfy*/
          {1981.790794,-205.0463567,2622.359072,-337.3039935,14.80443844,12.837407}, /*cmz*/
          {5.59396963,-0.179823189,-5.821211975,-0.7216499174} /*cfz*/
     },
     {
          2461169.5,
          {1320.837904,-137.9654209,1496.421771,237.477122,-10.99031189,-72.96962692}, /*cmx*/
          {4.044502986,3.140364617,3.782980291,0.01797671254}, /*cfx*/
          {327.1925306,-31.70561467,174.707302,59.1167566,2.230666635,-6.163919861}, /*cmy*/
          {17.55082566,2.433004434,6.157384454,4.785872996}, /*cfy*/
          {-3027.108719,296.5210331,-1691.188963,525.3104307,20.49050603,-57.37407624}, /*cmz*/
          {4.756710926,5.684202904,-3.142223018,234.6316786} /*cfz*/
     },
     {
          2461185.5,
          {-3492.768308,343.5997138,-5148.867488,611.348365,-23.51988785,-148.0216064}, /*cmx*/
          {4.753641312,-0.6044570002,-0.007444552566,2.741877348}, /*cfx*/
          {425.5938929,-47.12879203,-573.1698583,-76.81804473,-3.231433827,-22.94564801}, /*cmy*/
          {14.68091149,-0.3281985452,-2.8182043,0.549276983}, /*cfy*/
          {-1926.081122,227.6158073,-2852.158162,371.8719364,16.25579057,140.7919092}, /*cmz*/
          {-7.026211898,-0.1766486613,-8.951081683,7.095523548} /*cfz*/
     },
     {
          2461201.5,
          {-2293.490575,266.7367888,-2552.136762,434.1381062,-18.63545785,-112.9072434}, /*cmx*/
          {4.389519333,-0.2403543854,0.4301019958,4.678822026}, /*cfx*/
          {-394.6442837,32.77377176,-166.8130863,62.88512979,-2.390776101,-20.03667815}, /*cmy*/
          {-32.73531896,5.550166829,6.110867711,3.221826102}, /*cfy*/
          {3210.297719,-285.6867487,1626.233839,512.8202983,-19.89767906,139.298358}, /*cmz*/
          {-1.525617451,2.514404598,-3.176074318,3.431802612} /*cfz*/
     },
     {
          2461217.5,
          {2430.932654,-207.0084252,-3761.342311,-390.9595881,15.04175831,-49.16600403}, /*cmx*/
          {1.582071944,5.629942898,-0.09542274242,1.046094436}, /*cfx*/
          {-391.6527392,38.68287404,511.0020135,-63.6357855,2.717758147,3.372762126}, /*cmy*/
          {2.217827912,2.864868349,3.510110525,-4.38906972}, /*cfy*/
          {1996.985203,-204.7596827,2705.249147,336.4550291,-14.79769045,16.0559707}, /*cmz*/
          {43.26074932,-3.314436422,-2.669660079,-0.7328673896} /*cfz*/
     },
     {
          2461233.5,
          {1234.610263,-131.3572583,-1356.841578,228.1760691,-10.65402727,-70.10303401}, /*cmx*/
          {0.8120756763,3.17432011,3.808688409,6.284253005}, /*cfx*/
          {418.4225261,-40.98309817,-233.9662494,74.69711334,-2.870164537,-7.445491712}, /*cmy*/
          {26.97769002,2.482609598,3.061212978,5.013951018}, /*cfy*/
          {-2998.380487,296.2066646,-1695.679356,-525.4599192,-20.49204734,-54.85932905}, /*cmz*/
          {4.83234263,2.548073712,0.004286042211,2.157438037} /*cfz*/
     },
     {
          2461249.5,
          {-3574.119227,350.4961348,5214.998075,621.7351814,-23.97508013,-148.7978861}, /*cmx*/
          {1.593101321,-0.6030522718,-0.004019736404,2.735462231}, /*cfx*/
          {407.3681141,-46.20442639,583.6667445,-76.02768272,3.201604146,23.77064195}, /*cmy*/
          {5.307165327,-0.284372352,0.3672915122,10.03343329}, /*cfy*/
          {-1899.09613,226.869012,2920.85529,-371.7512318,16.27762204,-141.3923377}, /*cmz*/
          {2.375411972,-3.316086068,3.620325717,10.22661846} /*cfz*/
     },
     {
          2461265.5,
          {-2316.54767,267.8463145,2484.847858,434.9168094,-18.66497455,-113.8672488}, /*cmx*/
          {1.237500401,-0.2400653662,0.4268663006,4.669279648}, /*cfx*/
          {-396.9121046,33.20202593,-163.4395198,61.78254062,2.375595379,19.61372369}, /*cmy*/
          {-296.5457845,11.86383715,9.280073265,0.1045719309}, /*cfy*/
          {3254.67277,-289.0041885,-1661.72869,519.0574893,-20.0839673,-140.8092555}, /*cmz*/
          {1.667176947,-3.765921374,3.108632964,0.2795256781} /*cfz*/
     },
     {
          2461281.5,
          {2435.988776,-208.8714937,3774.080144,-390.8705215,-15.11318813,-50.49564132}, /*cmx*/
          {4.711135875,5.633905178,3.057226079,1.062811177}, /*cfx*/
          {-356.0685899,34.89221322,478.3170612,-58.50619569,-2.449533364,2.830836949}, /*cmy*/
          {2.219202595,2.859709014,0.3560762413,-4.387182283}, /*cfy*/
          {1969.902656,-201.5587908,-2716.886592,330.5354058,-14.53741252,-17.19727529}, /*cmz*/
          {46.39507031,-3.316707055,-2.664324088,2.496401076} /*cfz*/
     },
     {
          2461297.5,
          {1155.769927,-123.8841291,1296.218271,217.701469,10.23252407,68.81315449}, /*cmx*/
          {3.898504538,3.209712565,0.6911462366,9.424025247}, /*cfx*/
          {357.8305532,-35.05492217,199.8249077,63.97925981,2.472904448,-6.429865019}, /*cmy*/
          {-32.64284119,2.486600616,6.19241994,5.013851034}, /*cfy*/
          {-2983.484997,295.5472898,1685.110275,-525.4287018,-20.45852602,-54.59483331}, /*cmz*/
          {1.709514855,2.553911994,0.009579832845,2.159283214} /*cfz*/
     },
     {
          2461313.5,
          {-3579.038342,351.7151731,-5217.332489,621.3087403,24.02758474,148.7015599}, /*cmx*/
          {4.738161887,-0.598168499,3.145051973,-0.3879587408}, /*cfx*/
          {339.5564109,-38.42002627,-498.1551109,-63.99600933,-2.665373724,19.34749549}, /*cmy*/
          {2.140213711,-0.2933555538,3.496333545,28.84657997}, /*cfy*/
          {-1809.271208,218.4186089,2860.116218,-358.6714224,-15.78824766,140.115881}, /*cmz*/
          {2.399655295,-3.30120985,0.4965581579,7.10802039} /*cfz*/
     },
     {
          2461329.5,
          {-2124.633342,248.6764383,-2338.121264,402.908134,17.40355651,109.6616742}, /*cmx*/
          {4.345049385,-0.2204527185,-2.695450814,1.579019256}, /*cfx*/
          {-272.9184323,22.05967413,96.93631551,-41.64575764,1.605699811,14.56825535}, /*cmy*/
          {335.1584152,2.40412641,-3.337518381,0.03679429349}, /*cfy*/
          {3258.51536,-291.4447493,-1657.50198,-520.7516415,20.18985498,139.7704794}, /*cmz*/
          {1.66887042,-0.6088463173,6.268551219,3.453337954} /*cfz*/
     },
     {
          2461345.5,
          {2460.988396,-213.3009463,-3796.401304,-393.3533048,-15.25169191,50.06957105}, /*cmx*/
          {1.587565301,5.65420851,3.086492918,4.24314426}, /*cfx*/
          {-292.6676353,28.36984413,395.8297638,47.83088326,-1.99331529,-2.591636233}, /*cmy*/
          {-3321.643199,-0.3086808553,0.3244762061,4.927188181}, /*cfy*/
          {1786.776482,-184.0304917,-2566.588541,-301.7287546,-13.36622346,17.55348665}, /*cmz*/
          {2.470594395,-6.432193735,-2.636584448,-0.4192181759} /*cfz*/
     },
     {
          2461361.5,
          {944.2022455,-103.0080495,-1214.158936,187.2181822,9.01916624,-64.43941437}, /*cmx*/
          {0.641297804,3.303379261,0.7732275929,0.0187736646}, /*cfx*/
          {259.4197129,-25.46034626,-146.1913588,-46.96129627,1.805083568,4.524031609}, /*cmy*/
          {-4.250314321,5.6014232,6.169015923,1.691321099}, /*cfy*/
          {-2919.792383,290.7797885,1605.320906,-514.1986436,20.13226345,53.96332147}, /*cmz*/
          {1.703382967,-9.998213516,-122.4952208,5.336454933} /*cfz*/
     },
     {
          2461377.5,
          {-3466.322692,342.1653784,5100.1947,603.379183,23.3625949,-144.4384189}, /*cmx*/
          {1.607356507,-0.5855756854,3.159540615,2.785362506}, /*cfx*/
          {307.4928381,-34.30866215,-446.0624334,56.70423044,-2.369101952,16.6749398}, /*cmy*/
          {39.78000437,2.811716792,3.457846558,3.634811588}, /*cfy*/
          {-1515.525613,189.04636,-2623.397072,311.3781098,13.90940616,-132.0762388}, /*cmz*/
          {-0.6588864545,-12.67386525,-8.880954957,4.013888433} /*cfz*/
     },
     {
          2461393.5,
          {-1776.871096,212.804895,2048.861128,-345.3921008,15.08582412,-102.8757753}, /*cmx*/
          {1.122541114,-3.328896422,-8.940815767,4.799610745}, /*cfx*/
          {-254.6176641,20.45794221,103.4084643,39.88300316,-1.510118564,13.87630887}, /*cmy*/
          {-16.69943372,5.521927707,31.20937369,0.006374711376}, /*cfy*/
          {3186.815692,-287.0867346,1584.815453,-507.5257041,19.79676645,-135.2702363}, /*cmz*/
          {4.825529192,-0.5908283445,-6.272786693,0.3530401444} /*cfz*/
     },
     {
          2461409.5,
          {2449.837717,-215.9534558,3789.750113,393.4527305,-15.27259737,-50.37222944}, /*cmx*/
          {4.736595559,2.539848726,-3.162603055,1.133321501}, /*cfx*/
          {-286.475234,28.03980264,-392.2336391,-45.7584299,-1.972796942,3.138426641}, /*cmy*/
          {2304.950293,2.854811494,0.3650040238,2.015738958}, /*cfy*/
          {1544.421551,-159.5228494,2396.396752,-262.1665066,11.76624417,-19.83501868}, /*cmz*/
          {5.678554429,31.31579716,31.96473698,2.917213892} /*cfz*/
     },
     {
          2461425.5,
          {667.2899041,-76.57958236,1110.365757,-149.794629,7.467319489,56.97106522}, /*cmx*/
          {3.549872866,0.3102329699,0.8996481062,3.154106161}, /*cfx*/
          {293.6961461,-29.28969401,168.1911566,53.38230574,2.041832613,-4.670261232}, /*cmy*/
          {11.4483733,2.483307341,6.223589392,4.858987126}, /*cfy*/
          {-2734.030669,275.7407781,-1433.230925,-483.1561352,-19.06420948,49.81077618}, /*cmz*/
          {4.894674011,2.585733097,6.332572091,5.358701529} /*cfz*/
     },
     {
          2461441.5,
          {-3338.048545,330.4549623,4943.929765,-580.6957268,22.56048136,137.9296935}, /*cmx*/
          {1.60471836,2.576380812,3.183295266,-0.3164171766}, /*cfx*/
          {293.6244382,-34.10602773,459.9893073,-55.13630156,-2.387222824,-18.83659468}, /*cmy*/
          {11.60194887,-0.2703943203,3.524018523,0.6042880574}, /*cfy*/
          {-1017.695531,140.0962634,-2316.118241,-235.7479983,-10.88148928,-118.9874644}, /*cmz*/
          {5.753396626,3.156157385,6.933611228,4.080393959} /*cfz*/
     },
     {
          2461457.5,
          {-1235.395612,156.6762886,1546.130498,-256.1864055,11.57188283,96.88344344}, /*cmx*/
          {0.9082507738,9.33977556,3.729843292,1.802349814}, /*cfx*/
          {-430.1801639,37.33636257,-222.0955129,68.49741742,2.621380523,-19.66884682}, /*cmy*/
          {11.36221951,5.635789853,3.093063098,3.33615743}, /*cfy*/
          {3196.26806,-291.241209,1607.052374,-506.4553547,19.92240648,-132.3815107}, /*cmz*/
          {4.903720607,-0.5562532429,6.338604095,0.4156571717} /*cfz*/
     },
     {
          2461473.5,
          {2498.955057,-227.9335605,3852.034004,405.4172757,-15.88424582,53.42248697}, /*cmx*/
          {4.734238522,2.587182455,-3.099315016,4.327702849}, /*cfx*/
          {-279.4372842,28.06053789,-430.6499775,-44.53097617,2.027948279,-4.518935109}, /*cmy*/
          {5.477591707,-3.297255026,-2.631301743,-0.5126620277}, /*cfy*/
          {1137.177474,-118.2344429,-2160.232852,197.2803401,-9.171407019,-26.58050057}, /*cmz*/
          {-22.48492086,3.170127186,3.812469444,3.144735237} /*cfz*/
     },
     {
          2461489.5,
          {167.3508628,-29.46843375,1093.077537,-104.4353151,5.339456083,45.74164353}, /*cmx*/
          {3.050503355,0.8487708995,1.29918374,-3.14194632}, /*cfx*/
          {421.9928396,-43.3045573,235.7086335,76.35137429,-2.975274112,6.439213729}, /*cmy*/
          {11.43278628,-3.716581627,-3.096428464,-4.263326721}, /*cfy*/
          {-2482.087936,256.6116595,1237.851872,444.2002988,-17.69712845,44.3732218}, /*cmz*/
          {-4.402136489,-0.516654937,-6.186841803,-0.87679987} /*cfz*/
     },
     {
          2461505.5,
          {-3250.282612,324.612992,4805.659999,562.308004,-22.12047452,132.7125269}, /*cmx*/
          {1.608747794,5.762711448,6.379825731,-0.2068858595}, /*cfx*/
          {144.1789448,-21.89999108,-421.3898569,-36.45774765,1.761893458,-20.94928757}, /*cmy*/
          {-3.730120152,0.07028483788,0.6951251903,7.183096678}, /*cfy*/
          {-108.3281892,51.13089732,-1900.437278,-124.9013813,6.288922914,100.9291425}, /*cmz*/
          {-0.1841660441,3.749024103,-2.026773977,1.130423471} /*cfz*/
     },
     {
          2461521.5,
          {-238.2920779,55.23351645,1070.192049,-119.4057715,6.162818873,94.55990149}, /*cmx*/
          {0.1283453643,3.670928635,4.235476889,2.134679388}, /*cfx*/
          {-677.582898,62.24632823,382.8265221,-108.2241893,4.253121086,-27.71698053}, /*cmy*/
          {1.908119589,2.609461009,3.235090412,3.58487288}, /*cfy*/
          {3267.646545,-304.8107061,1712.585125,518.5500858,-20.68558498,131.720804}, /*cmz*/
          {4.997483231,2.649700699,9.559553816,3.69653144} /*cfz*/
     },
     {
          2461537.5,
          {2597.078066,-248.6577491,3967.601567,426.8271349,17.08758107,57.01447491}, /*cmx*/
          {4.753887261,-3.61920049,0.1434707212,4.457178898}, /*cfx*/
          {-140.3542645,14.91680996,-412.2252338,26.65370555,-1.398569925,-8.59363415}, /*cmy*/
          {-0.3936452472,0.3617149402,0.9617783928,0.1088480808}, /*cfy*/
          {361.4640107,-40.77820643,-1803.993055,-100.9102906,5.224009242,40.58970762}, /*cmz*/
          {2.980521916,0.688357576,1.205583851,0.2825704877} /*cfz*/
     },
     {
          2461553.5,
          {-637.3558082,48.32630585,1498.414793,-142.3741981,-5.508445374,30.66639533}, /*cmx*/
          {2.513839427,1.943951776,5.483676592,-3.12795924}, /*cfx*/
          {489.8528158,-52.52796679,-247.1121862,90.13422016,-3.604322249,8.267677396}, /*cmy*/
          {8.410119367,2.670880171,3.303139611,2.255361201}, /*cfy*/
          {-2104.270279,227.3845722,941.5598241,-387.3271564,15.69930159,-39.45442093}, /*cmz*/
          {2.091747362,2.703849591,3.329934973,2.345991292} /*cfz*/
     },
     {
          2461569.5,
          {-2855.736565,292.2790372,4366.556174,-494.9323607,-19.99178994,124.9309968}, /*cmx*/
          {1.639937781,2.702359864,6.476122771,-0.01009897994}, /*cfx*/
          {-216.0938897,11.90562538,415.8408253,-35.86177968,1.378515791,20.31150489}, /*cmy*/
          {0.319832495,1.937877696,2.313296248,4.567989607}, /*cfy*/
          {1192.232476,-78.49022701,-1917.172703,188.2522492,-7.044525274,-84.94738011}, /*cmz*/
          {0.5145276819,2.094004766,2.541361595,4.706325566} /*cfz*/
     },
     {
          2461585.5,
          {1273.046484,-99.27915548,1860.178633,-217.2476423,8.183932186,106.1372725}, /*cmx*/
          {-0.8093302376,-7.204989558,5.850051285,2.64589097}, /*cfx*/
          {-747.9453447,71.6049357,-391.4490867,-120.069189,4.868120992,31.36206291}, /*cmy*/
          {5.134109437,2.727864124,-2.911940158,0.7521344924}, /*cfy*/
          {2961.169283,-284.9532765,1440.933563,474.2099364,-19.37615866,-126.0209786}, /*cmz*/
          {5.117500976,2.748088994,3.392332971,0.8117310367} /*cfz*/
     },
     {
          2461601.5,
          {2394.040264,-241.9570178,3796.810069,-399.9966416,-16.59566064,55.94688644}, /*cmx*/
          {4.809838135,5.913868835,3.419821651,4.771127256}, /*cfx*/
          {170.3692288,-16.28644917,431.4768175,39.56908543,-1.543690445,15.10183273}, /*cmy*/
          {3.574513667,2.155306136,2.59323718,3.652479426}, /*cfy*/
          {-828.8826887,79.99414754,-1850.43248,179.5018419,6.918735122,-62.49453719}, /*cmz*/
          {3.686899782,-0.9210324439,2.689650277,3.701204585} /*cfz*/
     },
     {
          2461617.5,
          {-1543.60073,140.7043635,2161.433744,-270.3651409,-10.17190102,-14.79771205}, /*cmx*/
          {2.284956244,8.677779021,12.37840397,-56.44816895}, /*cfx*/
          {366.4260341,-43.02176568,-130.9024596,-72.53737976,-3.022131443,8.411056996}, /*cmy*/
          {2.754857338,-0.3093873603,3.470362945,-3.938876763}, /*cfy*/
          {-1399.288609,166.7909986,424.7302386,-280.3790867,11.78155394,-34.40506737}, /*cmz*/
          {2.887865554,2.858340162,3.500475865,-3.918774017} /*cfz*/
     },
     {
          2461633.5,
          {-1702.882777,187.5538158,3210.229085,309.841227,-13.34557201,-106.1264434}, /*cmx*/
          {1.724734756,-0.2594336276,0.3881855817,-2.857706224}, /*cfx*/
          {-579.0150822,48.92719241,633.8843165,89.1847522,3.405038605,20.5427084}, /*cmy*/
          {0.9832626705,5.600855284,3.030461875,5.256746946}, /*cfy*/
          {2447.051599,-208.8725719,2717.071713,378.5227075,-14.44420711,-85.70782154}, /*cmz*/
          {4.167747849,-79.20392594,3.051812877,5.315226792} /*cfz*/
     },
     {
          2461649.5,
          {2773.73004,-258.079155,3088.858506,-458.9056449,-17.73801208,-131.2074698}, /*cmx*/
          {-1.02375413,5.682876539,9.428072578,-0.009768069265}, /*cfx*/
          {-440.680067,44.0480358,-123.1730513,72.12062377,-3.119135149,26.46307328}, /*cmy*/
          {5.943223941,18.65880744,0.461756616,1.219222611}, /*cfy*/
          {1723.40533,-173.3042878,-401.2735179,-285.6854128,12.43411326,-109.6811797}, /*cmz*/
          {2.952194,-12.73193688,0.493446013,1.275591274} /*cfz*/
     },
     {
          2461665.5,
          {1432.769547,-157.6474059,2884.099236,252.1494975,-11.32382989,-53.95566453}, /*cmx*/
          {4.930264417,-9.573103128,-8.901071657,2.295229838}, /*cfx*/
          {441.0280345,-45.01321257,-589.2172719,-80.08732987,3.150709993,18.7940741}, /*cmy*/
          {7.286884882,5.676633945,6.267351147,3.939081716}, /*cfy*/
          {-2055.484989,210.1883039,-2717.125036,372.1850224,-14.63158777,-83.59884508}, /*cmz*/
          {4.214531965,-0.5781778562,6.293814537,3.971496458} /*cfz*/
     },
     {
          2461681.5,
          {-2106.996537,205.6025834,2506.322791,363.3265184,14.16692796,4.505834473}, /*cmx*/
          {2.277171884,-0.5583508222,-3.086793428,-14.80511813}, /*cfx*/
          {102.4458591,-17.89684787,200.3525172,32.46568535,-1.506822509,6.425948413}, /*cmy*/
          {7.577954718,3.271112347,3.866359258,8.543534759}, /*cfy*/
          {-296.0531687,64.48022423,-993.833227,-124.1520149,5.878495659,28.6089089}, /*cmz*/
          {1.453830999,3.390150328,3.992848255,5.365856522} /*cfz*/
     },
     {
          2461697.5,
          {54.09868989,20.06688655,-1529.131213,-94.60674387,-4.757065034,-77.91683074}, /*cmx*/
          {5.15765297,4.129404335,1.372516181,-8.67740455}, /*cfx*/
          {-633.6539195,57.68390736,682.3926143,98.87801367,-3.917480699,19.98496681}, /*cmy*/
          {7.466020479,-0.532270768,0.08269757528,5.734270494}, /*cfy*/
          {2930.124951,-268.366351,3256.831866,-460.4272769,18.23648081,95.24399784}, /*cmz*/
          {4.358499057,-0.5120656209,0.09999735357,2.645781755} /*cfz*/
     },
     {
          2461713.5,
          {3249.54183,-319.0354533,3341.138347,541.7778717,-21.62499167,-142.8984564}, /*cmx*/
          {-19.8408097,2.670811122,3.303889108,0.354449784}, /*cfx*/
          {-32.33044227,4.425941907,-314.2765142,-21.67302009,1.057216258,20.66103751}, /*cmy*/
          {1.493132298,4.170752741,4.579864114,1.817037116}, /*cfy*/
          {-155.1240108,8.746597437,1760.161355,112.7649939,-4.994517098,100.8852675}, /*cmz*/
          {1.604007706,4.609485439,4.975244084,5.094079368} /*cfz*/
     },
     {
          2461729.5,
          {75.22258081,-26.8150156,-1610.895751,-95.99335644,5.020592606,-66.82301434}, /*cmx*/
          {8.362234738,0.9569113262,1.40212193,2.94673337}, /*cfx*/
          {507.5814436,-53.37629582,-637.8631757,90.95484945,-3.637098657,18.29712053}, /*cmy*/
          {7.488108342,2.648780812,3.273692867,4.140110906}, /*cfy*/
          {-2576.285278,273.1260659,3325.744493,462.3703168,18.62324355,90.05460181}, /*cmz*/
          {1.258281891,5.822402617,3.307785713,1.079296811} /*cfz*/
     },
     {
          2461745.5,
          {-2102.092408,214.4867936,-2371.232897,366.5204993,-14.83972111,5.180613135}, /*cmx*/
          {-0.758781941,5.84883558,6.47657611,5.122604263}, /*cfx*/
          {-87.3345674,1.071131739,-342.078899,-18.98553953,0.8526783559,4.725790297}, /*cmy*/
          {4.726688856,1.453805551,1.803044645,1.941581174}, /*cfy*/
          {704.5719569,-32.46407545,1942.341643,-116.908218,-4.681730511,23.61673814}, /*cmz*/
          {4.837461368,4.97303625,2.211333883,5.08417015} /*cfz*/
     },
     {
          2461761.5,
          {1339.87116,-108.1908889,691.3339026,-225.5545764,-8.364055246,61.11036816}, /*cmx*/
          {3.074886337,5.384533265,2.746933652,-5.013267015}, /*cfx*/
          {-545.81059,51.06274721,-607.0348683,-86.44193023,-3.476287241,-18.35813164}, /*cmy*/
          {4.366052692,8.985091185,0.1908289676,21.65441543}, /*cfy*/
          {2585.656492,-244.155173,3044.2616,-410.9217698,-16.73902193,-93.13716408}, /*cmz*/
          {4.393888592,5.874136741,3.367946463,6.036521866} /*cfz*/
     },
     {
          2461777.5,
          {2902.102788,-294.3007041,2960.217829,-487.6028704,-19.98021659,137.7972719}, /*cmx*/
          {-0.8860005075,5.89315209,3.393236441,3.70351972}, /*cfx*/
          {184.3383752,-17.24235886,-511.4655159,-39.67609501,1.503714888,-21.16235407}, /*cmy*/
          {1.62320922,-1.00379735,5.73029538,5.32800653}, /*cfy*/
          {-1319.853992,126.634395,2895.880446,257.5365829,-9.595579945,-106.7825415}, /*cmz*/
          {1.702900896,11.71995398,-0.3331343046,2.368053046} /*cfz*/
     },
     {
          2461793.5,
          {-684.0269413,46.98450845,-1006.491727,146.3062076,5.807492281,78.65039037}, /*cmx*/
          {2.458514935,5.077751297,2.349476229,0.02347863118}, /*cfx*/
          {575.1336767,-61.55932205,-710.31893,-104.3638961,4.188682443,-20.22165525}, /*cmy*/
          {1.283184068,5.847352989,6.478684726,1.102101052}, /*cfy*/
          {-2573.712597,279.0792931,3372.194034,468.9659575,-19.02463045,-89.59749974}, /*cmz*/
          {1.298734203,5.866006566,6.508968139,4.349374976} /*cfz*/
     },
     {
          2461809.5,
          {-2016.970091,208.2705725,-2311.443836,-350.8123719,14.57719293,-3.532204672}, /*cmx*/
          {-0.6995396081,2.773255878,3.397945421,2.324670514}, /*cfx*/
          {-193.8520655,10.64157261,-464.2020978,30.18714073,-1.214726427,-5.188938001}, /*cmy*/
          {4.777319862,5.157674568,5.541097385,4.769992462}, /*cfy*/
          {1094.233762,-70.5327698,2318.806752,-169.426796,6.395928148,-22.06107003}, /*cmz*/
          {4.855740768,5.30224842,5.734979963,1.677355975} /*cfz*/
     },
     {
          2461825.5,
          {1707.976867,-148.3180334,669.2174231,284.611256,10.72589529,-56.05350829}, /*cmx*/
          {3.643559626,8.631094591,6.043357195,-7.968621508}, /*cfx*/
          {-578.9978101,54.75332545,-648.8149185,92.95935826,3.759100489,-20.293819}, /*cmy*/
          {4.363316746,5.893991141,3.390423115,2.879477073}, /*cfy*/
          {2353.02248,-224.2736539,2774.395051,-376.6689899,-15.51608791,-87.69146756}, /*cmz*/
          {4.369554122,5.917220161,3.424366216,6.102385875} /*cfz*/
     },
     {
          2461841.5,
          {2766.308385,-285.0166758,-2969.55659,-467.8510858,-19.31474838,-135.7541873}, /*cmx*/
          {2.270189266,-6.654041531,9.694034556,0.5764777525}, /*cfx*/
          {302.3651933,-28.97577377,-688.6488033,-58.98804309,2.219427589,-25.78249224}, /*cmy*/
          {1.627059199,11.70494247,24.76209627,5.426847934}, /*cfy*/
          {-1492.430193,145.0878471,3085.508685,285.5995022,-10.62220086,-106.6304863}, /*cmz*/
          {1.677076537,5.500468884,12.31066294,2.407672046} /*cfz*/
     },
     {
          2461857.5,
          {-714.9913041,46.28165723,942.8003957,147.1131346,5.849763758,-80.3079668}, /*cmx*/
          {-13.37271198,-1.239508581,2.327434013,3.116955056}, /*cfx*/
          {709.4338979,-76.18941967,-856.8369282,-129.5013616,5.19382683,-25.1597178}, /*cmy*/
          {1.288341462,5.855442116,6.490356968,1.108917096}, /*cfy*/
          {-2599.005423,281.4258118,3274.868284,475.1611088,-19.19516864,-91.89092574}, /*cmz*/
          {1.280111868,5.857834461,6.503572152,4.311551538} /*cfz*/
     },
     {
          2461873.5,
          {-2119.844702,214.1388704,2514.1482,-361.3483671,15.01849501,2.877290471}, /*cmx*/
          {21.23200747,2.768995087,3.385357747,0.6247186361}, /*cfx*/
          {-242.2376934,13.40317855,-575.9556168,38.05414819,-1.520395468,-6.307442341}, /*cmy*/
          {4.735597921,5.181816299,5.549576368,4.653539389}, /*cfy*/
          {983.3592396,-58.87225534,2228.569135,-156.0765591,5.930615921,-21.81175695}, /*cmz*/
          {4.77230567,5.240950117,5.631539194,1.556042255} /*cfz*/
     },
     {
          2461889.5,
          {1481.947232,-128.7611447,-418.9517911,-254.2350649,9.587790762,-54.52076926}, /*cmx*/
          {0.1819049567,5.432219429,-6.59436565,-8.119317284}, /*cfx*/
          {-712.1122732,67.47055108,-766.6302041,114.5950619,4.640830067,-24.12935688}, /*cmy*/
          {4.344004693,5.890571069,3.391652585,2.866033208}, /*cfy*/
          {2456.599124,-233.6124482,2690.817521,-393.1185208,-16.10436938,-84.87499295}, /*cmz*/
          {4.340166201,5.896095372,3.404430841,6.04718576} /*cfz*/
     },
     {
          2461905.5,
          {2890.276382,-298.2371762,-3306.783821,-492.0761355,20.13456045,-137.8825916}, /*cmx*/
          {2.200051598,5.886246188,0.2388068425,0.4755452813}, /*cfx*/
          {316.1345048,-30.0028847,-789.2976346,-64.1909426,-2.4023323,-30.165008}, /*cmy*/
          {1.567777303,-7.186683615,2.709427313,5.345442135}, /*cfy*/
          {-1140.011784,109.0370535,2752.933728,-231.1742001,8.539812756,-100.8203701}, /*cmz*/
          {1.585112412,27.40527662,2.762233414,2.245568045} /*cfz*/
     },
     {
          2461921.5,
          {-403.9632751,11.32531588,-1165.385715,113.8017763,-5.019465955,-77.03544766}, /*cmx*/
          {-10.59203308,4.659565265,5.050352825,2.960579307}, /*cfx*/
          {835.0147183,-89.00933304,-967.9612014,-151.6361271,-6.069940054,-30.10519262}, /*cmy*/
          {1.254506063,-0.4463220333,3.33095597,1.054533652}, /*cfy*/
          {-2638.618771,281.6492555,3096.13401,-478.2062992,19.19242811,-95.07561441}, /*cmz*/
          {1.24011437,2.689259757,3.330328741,4.206894542} /*cfz*/
     },
     {
          2461937.5,
          {-2242.62314,220.0673709,-2763.603509,-374.6666117,15.38651554,-5.961917221}, /*cmx*/
          {-7.129426939,-16.1148316,3.346377024,29.52149959}, /*cfx*/
          {-221.7060683,9.839458036,-622.2761038,37.65626261,1.549747513,-7.118086409}, /*cmy*/
          {-7.929236205,5.013447661,2.198780064,4.643916216}, /*cfy*/
          {686.3935234,-29.98523525,1964.723063,119.8113334,-4.846182954,-21.58164978}, /*cmz*/
          {-1.650419525,1.855271799,2.176021247,1.526383068} /*cfz*/
     },
     {
          2461953.5,
          {1080.3979,-91.10309042,389.1664376,-199.3613925,-7.490525826,-56.11446929}, /*cmx*/
          {2.209166213,-7.268130603,2.648229061,4.219614823}, /*cfx*/
          {-822.8572877,77.73289341,-838.9075084,131.7343455,5.332847455,-26.71095625}, /*cmy*/
          {-1.971651202,5.867035667,3.365181862,2.805074485}, /*cfy*/
          {2548.818808,-240.8999714,2582.71608,406.6788701,16.50614752,-82.05049956}, /*cmz*/
          {4.306735032,2.721035061,6.504875229,5.947522676} /*cfz*/
     },
     {
          2461969.5,
          {2942.867926,-303.5731596,3556.70156,-505.5500564,-20.50903647,-138.3606601}, /*cmx*/
          {-19.84566443,-0.4221857587,3.35428685,0.3883414856}, /*cfx*/
          {282.7987278,-26.26473678,-812.3538316,-61.27742732,-2.296381461,-32.15131442}, /*cmy*/
          {1.491794237,5.296859939,2.606615751,5.251242491}, /*cfy*/
          {-803.9289175,74.25590969,2419.259866,-179.1797403,-6.70218821,-96.6387348}, /*cmz*/
          {1.476663845,2.131623343,5.715348775,2.086271457} /*cfz*/
     },
     {
          2461985.5,
          {-286.4118482,-2.322090741,1253.214766,103.4231619,4.855922463,-76.41823977}, /*cmx*/
          {-1.348441486,4.47891175,1.722576244,2.883232534}, /*cfx*/
          {866.5917848,-92.07893723,-968.0847653,-155.9510506,-6.271940663,-31.97847459}, /*cmy*/
          {7.499171582,5.832616979,3.326684436,1.039841885}, /*cfy*/
          {-2611.465055,276.6350568,2888.641196,-468.9687548,-18.82309982,-96.53081403}, /*cmz*/
          {7.491864541,2.683960331,6.460933923,4.161840282} /*cfz*/
     },
     {
          2462001.5,
          {-2245.772581,217.7978232,2857.938925,-371.449583,-15.15136156,-7.252009574}, /*cmx*/
          {2.259472953,2.718878639,0.196202896,36.15043036}, /*cfx*/
          {-214.7097016,9.212220072,-644.1789559,37.51781354,1.525023213,-7.747980996}, /*cmy*/
          {-1.705831642,4.962220523,2.166139029,4.64696655}, /*cfy*/
          {589.36858,-22.05224649,-1889.945514,107.5861309,4.499826958,-23.16446808}, /*cmz*/
          {1.407097316,1.751706906,5.225800507,1.493604501} /*cfz*/
     },
     {
          2462017.5,
          {1019.153046,-86.66761226,374.7918022,193.5109696,7.169779666,55.62365644}, /*cmx*/
          {8.195843026,2.154352357,5.770930089,13.60683436}, /*cfx*/
          {-797.1372534,75.35114547,-796.4038086,126.8191317,-5.170812644,26.42539015}, /*cmy*/
          {4.269910066,5.868896206,6.50280941,-0.3548726161}, /*cfy*/
          {2447.081986,-231.0041899,-2411.904871,389.8905773,-15.81058488,79.82306142}, /*cmz*/
          {7.411087508,2.720989661,-2.929663925,-66.35008859} /*cfz*/
     },
     {
          2462033.5,
          {2749.436158,-286.7225851,3447.164783,478.4152622,19.47105771,134.2965497}, /*cmx*/
          {-7.258034321,2.731281553,6.515671223,3.567362476}, /*cfx*/
          {353.8879673,-33.42025284,-875.3852652,70.93346439,2.644349742,31.33811528}, /*cmy*/
          {1.500024217,303.8412097,5.89730562,2.203625419}, /*cfy*/
          {-1008.114236,94.42469853,-2608.444388,-204.7228554,7.683563002,96.41441814}, /*cmz*/
          {4.620338716,-4.068480139,2.705055132,-0.9807043931} /*cfz*/
     },
     {
          2462049.5,
          {-782.2028625,48.11073056,-765.2697797,-143.8353432,-5.661747598,83.13573103}, /*cmx*/
          {1.828832344,1.983540043,5.519836512,-0.08999095159}, /*cfx*/
          {764.3663364,-82.53045599,-861.7518567,137.2178923,5.612074558,29.19295774}, /*cmy*/
          {7.473285404,2.729650329,6.512922592,4.296741954}, /*cfy*/
          {-2473.048046,266.0783415,-2740.802377,-444.331233,18.08663139,94.16853602}, /*cmz*/
          {4.34240128,2.728778443,3.366042801,1.131672269} /*cfz*/
     },
     {
          2462065.5,
          {-2048.642992,202.0803221,-2675.890592,340.4328696,-14.00906843,6.152668848}, /*cmx*/
          {-0.8124133663,5.8990628,6.536287122,2.326452423}, /*cfx*/
          {-296.8273713,18.94258569,-698.9793976,-46.4206849,-1.747357107,8.239257852}, /*cmy*/
          {4.645866519,2.116120953,5.712849662,1.463542416}, /*cfy*/
          {941.2970732,-59.32408255,-2227.637804,145.7767958,-5.598108389,27.39505108}, /*cmz*/
          {1.494403934,2.112368557,2.56049205,4.581250815} /*cfz*/
     },
     {
          2462081.5,
          {1473.310226,-133.9774134,162.3018298,261.6993673,-9.684901735,-50.30868594}, /*cmx*/
          {3.740959259,8.632475896,15.45105757,10.7504542}, /*cfx*/
          {-605.3252761,57.88359581,-641.3831715,-96.13438195,-4.010026706,22.81234956}, /*cmy*/
          {4.197077462,9.075164209,0.2859316393,-0.2751566068}, /*cfy*/
          {2015.613086,-192.4737193,-2124.392988,321.7708046,-13.3287679,75.55092356}, /*cmz*/
          {7.345498847,2.791172086,3.422600336,-3.429702169} /*cfz*/
     },
     {
          2462097.5,
          {2063.467853,-224.1748803,2790.396381,370.2931001,15.45202982,-120.1939065}, /*cmx*/
          {-0.8031855067,2.814666069,6.611744615,0.6279842504}, /*cfx*/
          {508.2290019,-49.79679561,-979.1092752,92.7594915,3.516722096,29.63113585}, /*cmy*/
          {1.587921301,2.430878926,6.145625171,2.492953119}, /*cfy*/
          {-1722.323927,168.6085956,-3301.729958,-312.4722325,11.89096056,100.735644}, /*cmz*/
          {4.729499647,2.430291379,3.001474853,5.630753262} /*cfz*/
     },
     {
          2462113.5,
          {-1671.617197,141.3733071,-234.2274222,272.8046437,-10.36164563,-95.59336495}, /*cmx*/
          {3.80620299,5.553785193,12.38144574,3.350054501}, /*cfx*/
          {564.9979207,-63.79928289,-693.332759,-104.1364523,-4.362372858,24.52313989}, /*cmy*/
          {1.146849162,-0.3255921042,3.469379689,4.558055149}, /*cfy*/
          {-1931.111448,218.5355369,-2376.524411,357.2101815,-14.97836373,84.30344602}, /*cmz*/
          {4.293915519,-0.3188445126,0.3325279388,1.426283521} /*cfz*/
     },
     {
          2462129.5,
          {-1548.276506,158.2627746,-2231.238511,-261.9277526,11.14982707,-10.69128488}, /*cmx*/
          {-0.5993216884,2.872490664,3.523780555,0.1795372074}, /*cfx*/
          {-428.9488689,34.06578186,-798.8170927,65.54136995,-2.502271669,9.212871629}, /*cmy*/
          {4.758149942,11.83343895,-12.75178887,1.392185457}, /*cfy*/
          {1492.498955,-119.034591,-2762.291326,-227.4600759,-8.685125718,31.63969213}, /*cmz*/
          {1.624819562,36.97364438,-22.16350139,4.546148734} /*cfz*/
     },
     {
          2462145.5,
          {1916.995288,-184.444938,557.3083034,331.8428673,-12.66645559,46.5012234}, /*cmx*/
          {4.440344086,2.504089013,3.090702437,-280.9694093}, /*cfx*/
          {-343.6864679,33.61310623,-460.339887,-56.2408087,2.453865653,18.21256351}, /*cmy*/
          {3.98222263,2.984106641,-2.662876779,-62.99138532}, /*cfy*/
          {1153.163148,-112.9892514,-1571.420161,188.6906947,8.320902918,62.23131332}, /*cmz*/
          {0.8382077771,2.995968264,-5.79329164,3238.840727} /*cfz*/
     },
     {
          2462161.5,
          {894.0088564,-114.1190137,-1973.295986,189.5295418,-8.597379169,98.2181619}, /*cmx*/
          {2.787107262,3.084633519,3.73614196,-2.18565607}, /*cfx*/
          {662.0637678,-66.79923103,-1120.203264,-116.7035207,4.548748324,31.28930254}, /*cmy*/
          {1.668181159,-0.5780946041,0.02493776406,-3.476648393}, /*cfy*/
          {-2245.440064,226.9548013,-3797.984439,397.3654148,15.46162363,105.5014085}, /*cmz*/
          {4.816315614,-0.5738779698,-3.107422536,5.968316599} /*cfz*/
     },
     {
          2462177.5,
          {-2379.112234,217.9072232,851.289625,383.8102451,14.99822983,106.2088146}, /*cmx*/
          {1.432414562,-0.5705991861,3.174570639,0.4667074546}, /*cfx*/
          {318.0203833,-40.95974863,-514.4712459,-66.87465079,-2.953939113,23.27091615}, /*cmy*/
          {0.9617373684,-6.402555381,-2.601223004,4.984153062}, /*cfy*/
          {-980.0224797,127.7611225,-1665.207727,207.1064831,9.2713331,74.85458062}, /*cmz*/
          {4.074386314,-25.2475557,-21.43984165,1.86946407} /*cfz*/
     },
     {
          2462193.5,
          {-831.6741298,89.68326694,-1832.221699,149.9988148,-6.947936905,22.41507475}, /*cmx*/
          {6.052412724,0.01100510016,0.6555542925,3.62227131}, /*cfx*/
          {-595.2971957,52.5135601,-986.2901102,-92.38517498,3.651152675,11.49184325}, /*cmy*/
          {4.841838645,-3.69645978,3.180185518,1.422893831}, /*cfy*/
          {1865.489574,-164.2796833,-3128.291066,291.1669427,-11.37880872,35.0641638}, /*cmz*/
          {1.70000238,-3.706650134,-3.107918788,4.579324778} /*cfz*/
     },
     {
          2462209.5,
          {1947.252459,-197.6375071,593.4268074,340.9879466,13.42648272,-44.57184103}, /*cmx*/
          {4.548643816,2.614353536,0.08849206398,17.80817894}, /*cfx*/
          {-50.41717991,5.794226013,-367.8930635,23.37182635,-1.112568142,14.23782402}, /*cmy*/
          {3.392310408,0.8651614401,1.321428141,-6.30930231}, /*cfy*/
          {164.000764,-19.187757,-1147.79975,-70.93784914,3.525957041,-43.71783717}, /*cmz*/
          {0.2451406244,0.8656342061,1.302228172,-0.00378023355} /*cfz*/
     },
     {
          2462225.5,
          {-424.6361953,12.5633897,1827.548647,-95.13833142,-4.033283427,-80.94978059}, /*cmx*/
          {0.3752635228,1.577978099,5.064120116,1.410627025}, /*cfx*/
          {763.6630284,-79.56639403,-1267.1842,-134.5409586,-5.38624683,35.51295133}, /*cmy*/
          {1.73394956,12.09507131,3.293385785,3.092272078}, /*cfy*/
          {-2255.65538,234.8545211,-3771.156336,-400.2235053,15.93798902,-104.491526}, /*cmz*/
          {4.869565147,8.951100093,3.29574852,3.091559308} /*cfz*/
     },
     {
          2462241.5,
          {-2672.383803,253.495538,-1103.125786,-429.3771259,17.20470496,-111.2199863}, /*cmx*/
          {4.718955103,2.668781832,3.300083257,3.839392799}, /*cfx*/
          {-69.05144621,-3.988480375,-376.01824,28.9776248,1.401790245,27.32136172}, /*cmy*/
          {0.1999309043,4.280863973,1.558478425,5.545093218}, /*cfy*/
          {150.1453482,15.121541,-1109.493088,77.57585909,-3.937714587,-76.58901401}, /*cmz*/
          {3.348497418,1.065122205,1.486658714,5.523072412} /*cfz*/
     },
     {
          2462257.5,
          {1.378565122,5.842279992,1742.976793,74.94590209,-3.583500445,-37.9899323}, /*cmx*/
          {3.410185864,1.272167964,1.644403972,0.6199255399}, /*cfx*/
          {-720.4854225,67.69663462,-1169.031349,-114.1959431,-4.638149627,13.66350756}, /*cmy*/
          {4.902563048,2.704982186,0.1873943582,1.606363972}, /*cfy*/
          {1966.63107,-184.2496015,-3233.526372,-314.0592143,12.59956637,-37.17736515}, /*cmz*/
          {1.741277343,5.828255656,6.45421954,1.583823103} /*cfz*/
     },
     {
          2462273.5,
          {1609.98801,-175.0611852,-267.7549015,-293.8379728,11.96564225,-41.0568072}, /*cmx*/
          {1.46686192,5.870025831,0.2227307036,-7.16038026}, /*cfx*/
          {282.0454178,-26.61108116,-488.7683602,-55.83378486,2.088074595,9.681978835}, /*cmy*/
          {2.718559178,-7.1976985,5.889216508,-12.41599799}, /*cfy*/
          {-689.4873816,63.65593298,-1324.920485,-140.164213,-5.231161924,26.67856004}, /*cmz*/
          {-0.4115508017,2.194658319,5.820836002,-3.013036151} /*cfz*/
     },
     {
          2462289.5,
          {-1608.848353,129.3003424,2380.401711,251.1784187,9.375934328,-77.0867796}, /*cmx*/
          {0.8790614258,11.7890929,9.197629496,1.931174853}, /*cfx*/
          {660.9792747,-72.58697545,-1222.584804,-120.3432079,4.992606007,36.89660638}, /*cmy*/
          {1.806022326,-0.3444614787,6.579075878,-2.927034485}, /*cfy*/
          {-1795.22612,194.9968416,-3274.107865,-326.0434385,-13.40707293,96.58253842}, /*cmz*/
          {4.918230892,2.780849652,6.565461897,0.1802411677} /*cfz*/
     },
     {
          2462305.5,
          {-2473.108611,240.2178564,-871.3119666,-396.8906472,16.33966909,-109.7594507}, /*cmx*/
          {4.829185025,9.047443515,-109.683655,4.088461364}, /*cfx*/
          {-549.2158113,44.03877416,-603.1047899,-86.807577,-3.285351544,36.31087065}, /*cmy*/
          {-0.6601669646,8.625262046,-12.82691949,-0.2704465611}, /*cfy*/
          {1248.021761,-97.78198487,-1513.40796,-198.7834517,7.512027775,90.04997866}, /*cmz*/
          {2.519181587,11.73130768,-19.16927753,2.806317686} /*cfz*/
     },
     {
          2462321.5,
          {852.2294856,-82.34188224,-2041.436001,174.1970855,-6.601045344,-54.71948004}, /*cmx*/
          {0.7161760515,-3.999300046,-3.495285091,0.7368567302}, /*cfx*/
          {-696.3700275,68.73927509,-1199.210185,112.9857706,-4.731227583,14.88029066}, /*cmy*/
          {4.960637007,-0.3270424373,0.3209470565,1.946453848}, /*cfy*/
          {1803.433286,-177.7410484,-3086.433372,294.6751313,12.19636193,38.32717113}, /*cmz*/
          {1.778423971,-3.494524803,0.2935137319,4.997421367} /*cfz*/
     },
     {
          2462337.5,
          {1064.518126,-130.0044835,-261.4619712,-214.9045957,-9.169416473,-36.30816975}, /*cmx*/
          {4.753265543,-0.2500744246,3.54107928,30.57528028}, /*cfx*/
          {559.7947446,-54.68999409,-688.6355635,-99.80249728,-3.820592335,5.462819971}, /*cmy*/
          {2.45271712,11.90431838,9.34984106,-12.11811196}, /*cfy*/
          {-1314.471228,126.3236985,-1730.149487,234.3803043,8.926626665,14.32955415}, /*cmz*/
          {-0.6947135902,11.87982646,9.31269918,72.55282277} /*cfz*/
     },
     {
          2462353.5,
          {-2437.289952,214.3168895,-2973.705486,-381.6065443,14.69959346,-84.19035063}, /*cmx*/
          {4.248725378,2.530483786,3.12902785,2.347203421}, /*cfx*/
          {347.3228345,-43.98446564,-948.3554062,73.5158086,3.301754397,33.67158719}, /*cmy*/
          {1.920990954,15.62493273,0.5623685389,-2.650840101}, /*cfy*/
          {-1041.484958,124.7079062,-2505.084323,-207.3694428,-9.102024473,84.98842762}, /*cmz*/
          {4.995711876,2.986457016,0.4948288223,0.4177030661} /*cfz*/
     },
     {
          2462369.5,
          {-1855.85185,184.8692604,246.8590427,-300.9121863,-12.90468554,-104.9486128}, /*cmx*/
          {1.948327207,2.905069821,0.4252532595,4.386088868}, /*cfx*/
          {-940.8891364,85.09608436,-921.8844991,151.1038385,-5.844862428,45.11992011}, /*cmy*/
          {-0.9078387615,-0.6039286689,6.278555504,0.0388855531}, /*cfy*/
          {2161.809518,-194.0566591,-2246.706452,-348.5858294,-13.42492742,108.2765871}, /*cmz*/
          {2.237852737,11.93716808,3.104100154,3.105537486} /*cfz*/
     },
     {
          2462385.5,
          {1603.360904,-162.024716,-2555.357654,295.1948673,11.44691497,-69.30810776}, /*cmx*/
          {-5.278560773,2.507763382,6.227657479,0.8566791787}, /*cfx*/
          {-519.7760671,54.00974813,-1049.023788,-87.44009865,3.843092404,16.13883764}, /*cmy*/
          {5.043116651,-3.320774406,-2.652988075,2.385190835}, /*cfy*/
          {1424.350691,-147.6454999,-2733.802529,-239.4441202,-10.38188667,40.71436263}, /*cmz*/
          {1.841253161,-0.2230345078,-2.701386836,5.379439803} /*cfz*/
     },
     {
          2462401.5,
          {457.9497628,-75.90581931,-843.9943259,-132.1158748,-6.108910275,32.45181775}, /*cmx*/
          {-1.452110071,0.07238552649,3.846103796,8.551290972}, /*cfx*/
          {704.796924,-70.58000486,-786.8930756,-124.3349838,-4.85007633,3.29367209}, /*cmy*/
          {2.38923258,5.729240697,3.197350224,13.65519312}, /*cfy*/
          {-1718.831137,169.7548904,-2010.487831,300.714332,11.69873651,-7.492083632}, /*cmz*/
          {-0.7772976459,5.707247374,3.173767609,-30.68791739} /*cfz*/
     },
     {
          2462417.5,
          {-2847.752205,260.2864296,3352.872187,-448.9342183,-17.7029251,93.494147}, /*cmx*/
          {1.221477985,-9.949492525,0.09176253825,5.767147281}, /*cfx*/
          {-21.41907565,-8.643420448,604.7921845,34.2464159,1.723047983,28.45744187}, /*cmy*/
          {5.307728481,4.047762842,1.346099391,22.79442659}, /*cfy*/
          {-184.5341032,43.57424128,-1694.312241,-98.20991584,-4.974482358,-74.02445611}, /*cmz*/
          {5.177472855,3.667802054,1.056342501,-2.443000574} /*cfz*/
     },
     {
          2462433.5,
          {-1009.865832,105.2869655,595.3726344,178.4404552,8.341783129,101.2411799}, /*cmx*/
          {4.821112834,-6.210671316,3.859253542,1.585221801}, /*cfx*/
          {-1116.014289,105.1128525,-1047.593289,-181.2524409,7.129131752,48.90637296}, /*cmy*/
          {162.4007787,2.619574466,933.1503428,0.2475106711}, /*cfy*/
          {2786.305911,-261.4474986,-2723.008688,-453.7230046,-17.78024867,-123.9359758}, /*cmz*/
          {2.164490049,-0.5432110629,3.215906336,0.1833588695} /*cfz*/
     },
     {
          2462449.5,
          {2107.413925,-217.0770961,-3039.185577,379.5994549,-14.97432134,77.64745289}, /*cmx*/
          {7.450050807,-3.686770537,-78.47922344,4.111716928}, /*cfx*/
          {-307.8457906,34.17793824,831.1065819,57.0133326,-2.692518099,17.55718767}, /*cmy*/
          {8.310926042,0.06437351529,0.7255174569,2.734546772}, /*cfy*/
          {949.5092873,-104.3870001,2292.297728,170.227634,-7.893631274,-45.38580708}, /*cmz*/
          {5.099021409,9.409349312,3.789217205,2.609426814} /*cfz*/
     },
     {
          2462465.5,
          {-35.95139632,-30.19922498,-1308.401732,-85.72856315,4.313724914,29.1704921}, /*cmx*/
          {4.917378254,0.7258435346,-5.068257613,2.255281408}, /*cfx*/
          {720.6492446,-73.71495647,763.430224,127.7475906,-5.079574555,-3.154053113}, /*cmy*/
          {-0.740003377,2.651730535,15.83477404,4.854893841}, /*cfy*/
          {-1898.448311,192.1009011,2073.851298,333.5069875,13.2171521,6.525523207}, /*cmz*/
          {2.372374385,-0.5087696877,3.250869165,4.664962283} /*cfz*/
     },
     {
          2462481.5,
          {-2906.616942,270.9652745,-3473.937445,-461.6522081,18.44565181,97.69845056}, /*cmx*/
          {4.417753858,2.667691939,-2.986212712,5.924632993}, /*cfx*/
          {-250.0202056,14.01450364,409.8279256,-46.59738312,1.840848472,24.59296214}, /*cmy*/
          {-0.605240443,1.851923499,2.245264704,-2.093528135}, /*cfy*/
          {478.1933702,-19.82973118,-1170.716054,-106.3067514,-4.427762918,66.79117641}, /*cmz*/
          {36.91913192,4.795262287,2.012516471,-5.327602462} /*cfz*/
     },
     {
          2462497.5,
          {-443.823662,50.29104585,-1139.217407,112.8273142,-5.811257019,100.2173406}, /*cmx*/
          {1.764481667,0.5679237895,1.106175637,1.800574701}, /*cfx*/
          {-1127.177342,107.6543369,-1032.08047,-182.9099674,7.282444772,48.6065926}, /*cmy*/
          {5.31560547,2.650957199,3.2767235,0.3388103393}, /*cfy*/
          {2993.765926,-285.5335247,2823.317114,-486.886954,19.31436056,129.6121695}, /*cmz*/
          {-0.9789526587,5.780445902,0.1209715426,3.437801025} /*cfz*/
     },
     {
          2462513.5,
          {2273.386441,-235.6022285,3234.338674,411.4161098,-16.19193178,79.77397326}, /*cmx*/
          {4.359123201,2.613078517,3.228923618,4.139549228}, /*cfx*/
          {-242.2669733,28.19420729,-755.5214166,50.06252912,-2.409222963,18.16116055}, /*cmy*/
          {11.51435789,0.2201600169,0.8420269583,2.799103136}, /*cfy*/
          {759.3722689,-86.8925502,-2123.961217,148.9055713,-7.016029906,47.57784396}, /*cmz*/
          {8.31065115,3.263895013,3.904743578,-0.4230998582} /*cfz*/
     },
     {
          2462529.5,
          {-147.7111873,-21.14560921,1411.088589,-83.79268755,4.327620681,26.32445407}, /*cmx*/
          {1.776684042,0.96588676,1.375837056,2.26861245}, /*cfx*/
          {718.896995,-73.76067843,-758.9928346,126.5107106,-5.115702965,-2.649744682}, /*cmy*/
          {2.405098266,2.671045519,9.570372005,5.005835423}, /*cfy*/
          {-1911.465725,194.0056501,-2073.62328,334.8464872,13.45005011,-6.170341098}, /*cmz*/
          {-0.7561760308,-0.4837895993,3.267955934,1.801200911} /*cfz*/
     },
     {
          2462545.5,
          {-2900.303819,270.3521326,3433.851993,462.4106582,18.43603637,96.07785286}, /*cmx*/
          {1.270835979,5.811910586,-2.977498589,5.931312206}, /*cfx*/
          {-264.0766697,15.63392376,-395.4639271,-49.56890533,1.917111328,-24.27345362}, /*cmy*/
          {-10.03092774,1.873015855,2.292478519,-5.242689089}, /*cfy*/
          {544.6628294,-27.3437356,-1102.784483,-114.0396104,-4.630353287,-64.42364185}, /*cmz*/
          {43.21713045,4.862041823,2.116760845,-2.17080849} /*cfz*/
     },
     {
          2462561.5,
          {-545.9075575,59.12948921,1065.126739,-117.2464633,-6.115666176,100.1295006}, /*cmx*/
          {4.836873952,3.590413916,1.016104326,1.742769929}, /*cfx*/
          {-1168.791632,111.8348436,1100.997997,-189.145457,7.54944778,-50.47931598}, /*cmy*/
          {-10.40826314,2.642409497,3.266504431,3.443692575}, /*cfy*/
          {2945.796439,-281.7783756,2866.358015,-478.1846491,-19.00505388,-127.9831016}, /*cmz*/
          {-0.9846720009,5.778015067,3.255171355,0.2622378461} /*cfz*/
     },
     {
          2462577.5,
          {2212.083661,-228.4762841,-3106.295078,-405.6132292,-15.77873179,80.6571705}, /*cmx*/
          {7.455043348,5.724799164,3.196383114,4.065369369}, /*cfx*/
          {-330.6378488,37.87375877,-866.7483789,65.00788158,-3.007113206,-18.98182935}, /*cmy*/
          {-1.138699771,0.0994412074,0.7280256561,-0.5005003052}, /*cfy*/
          {959.807269,-108.2430408,-2316.560876,-183.2621761,-8.240405314,-46.30611596}, /*cmz*/
          {8.222032592,6.285459895,3.790878297,2.542705189} /*cfz*/
     },
     {
          2462593.5,
          {47.41080139,-41.53247269,-1244.900881,93.50527007,5.007080929,25.18575033}, /*cmx*/
          {4.782373191,3.75017561,1.110278337,2.234843731}, /*cfx*/
          {759.7485762,-76.37543197,-846.3005016,131.4378496,5.313112982,1.838606819}, /*cmy*/
          {2.374459681,2.650467193,0.1172840183,1.562222305}, /*cfy*/
          {-1862.400522,184.3651748,-2150.845052,-321.0257996,-12.85698385,3.734069494}, /*cmz*/
          {-0.7887622237,8.918803905,0.09072625003,10.86070135} /*cfz*/
     },
     {
          2462609.5,
          {-2906.21056,267.635753,3272.316321,461.33429,18.25146418,91.54875587}, /*cmx*/
          {1.219839166,-0.4987368869,3.27594892,5.835618795}, /*cfx*/
          {-166.2120822,6.313432784,476.3735569,-42.4928058,-1.769108232,26.49999352}, /*cmy*/
          {11.65651264,1.557645188,5.085995987,-2.255173267}, /*cfy*/
          {197.1117139,3.360148118,1290.588211,91.16490226,4.177920908,65.22378287}, /*cmz*/
          {2.070611346,1.225723816,4.782366962,-5.487734581} /*cfz*/
     },
     {
          2462625.5,
          {-891.2263103,91.61034957,796.7193292,-154.174414,-7.60478976,101.4105691}, /*cmx*/
          {-1.731624215,3.285964956,0.7799976295,1.573755006}, /*cfx*/
          {-1224.614652,117.4698226,1238.969741,-199.3853157,7.925078577,53.6727325}, /*cmy*/
          {-4.141115431,8.909825803,-3.037732423,0.2238641562}, /*cfy*/
          {2780.030291,-266.4469206,2946.566778,-455.043994,-17.98293028,123.5711917}, /*cmz*/
          {11.56069051,5.756883888,3.226601855,3.302652402} /*cfz*/
     },
     {
          2462641.5,
          {2071.569716,-213.0902323,2816.473006,-383.2662591,14.80626544,81.6199444}, /*cmx*/
          {4.225260301,-0.5918516406,6.29839431,3.979119397}, /*cfx*/
          {-426.9653437,48.70328245,1008.423909,-81.84237075,3.678638438,20.60976221}, /*cmy*/
          {1.887501084,3.129743736,3.772686982,2.478587941}, /*cfy*/
          {1169.20069,-131.0947122,2518.811594,-219.0565376,9.556116194,46.78680421}, /*cmz*/
          {4.953920587,-18.95973548,-30.87225904,-0.8189103991} /*cfz*/
     },
     {
          2462657.5,
          {211.6326633,-56.9577568,-1134.390185,106.8513375,-5.518438563,24.98733072}, /*cmx*/
          {4.556947547,3.496962023,4.068106046,27.23632629}, /*cfx*/
          {808.5640455,-79.24673787,964.8361289,137.5865828,5.50742444,-1.393474993}, /*cmy*/
          {-0.8110652715,2.6285703,0.09100368703,10.24158612}, /*cfy*/
          {-1815.859858,174.1881445,2266.715837,-306.7220666,-12.15945226,2.969382387}, /*cmz*/
          {2.294524796,-3.677929225,0.05526814106,3.308477962} /*cfz*/
     },
     {
          2462673.5,
          {-2824.384246,258.1097292,-2995.274004,445.7045006,-17.58781115,86.0847721}, /*cmx*/
          {4.301520988,-0.5141735508,0.1138216218,5.751649983}, /*cfx*/
          {-113.1963696,2.093300639,524.3224282,-40.57739922,-1.785016147,-27.73747718}, /*cmy*/
          {5.163863664,1.387690583,4.908629212,0.7929380412}, /*cfy*/
          {-33.84298458,21.49508185,1398.773408,87.30316844,4.255038214,-64.55868636}, /*cmz*/
          {1.850706729,0.8629060442,4.475735068,10.08755388} /*cfz*/
     },
     {
          2462689.5,
          {-871.7413779,89.59763385,899.3721624,-152.5944763,7.466267817,101.0140131}, /*cmx*/
          {-649.135886,3.297160575,3.928275958,1.529877699}, /*cfx*/
          {-1255.461391,122.0121952,-1364.012901,-207.6089154,8.238957265,-55.84750879}, /*cmy*/
          {5.273899193,8.915558405,3.252679093,3.350965532}, /*cfy*/
          {2668.074559,-258.8733885,3069.394009,-444.2299521,17.50929711,-120.80714}, /*cmz*/
          {-1.03159194,5.753064979,25.21519345,0.1194339412} /*cfz*/
     },
     {
          2462705.5,
          {2118.675922,-218.8267952,2674.247063,-388.1643301,-15.12168279,85.24541789}, /*cmx*/
          {-8.366414851,-0.571759409,3.179023745,3.977693128}, /*cfx*/
          {-347.630056,42.44398893,-964.664883,72.01451013,-3.330468768,-22.93112089}, /*cmy*/
          {4.972397304,0.06106988276,0.7068276328,-0.5919572879}, /*cfy*/
          {1018.306913,-119.463051,2366.719392,198.280271,8.805152385,-49.6713959}, /*cmz*/
          {4.878616366,28.19134724,19.42532825,2.345758611} /*cfz*/
     },
     {
          2462721.5,
          {39.33212942,-38.45782249,-1333.139953,87.79376697,4.508862177,25.98273291}, /*cmx*/
          {-8.083904608,3.713014297,1.100041001,1.887869613}, /*cfx*/
          {837.6385364,-81.70309489,-1042.527918,141.1372728,5.632529604,-1.65053618}, /*cmy*/
          {2.315130284,2.646887331,6.406151867,3.390599904}, /*cfy*/
          {-1833.381541,174.5527157,2383.065044,-304.9068685,-12.07163733,-4.765852772}, /*cmz*/
          {2.258793726,2.61774373,6.368175192,5.80790753} /*cfz*/
     },
     {
          2462737.5,
          {-2666.466997,246.1795106,2739.363604,420.5100528,16.7660663,82.99601432}, /*cmx*/
          {-5.152587882,-0.4806214497,3.28679244,5.795638513}, /*cfx*/
          {-275.8383904,19.42949686,-361.0178,-55.94764454,-2.141398158,-25.13022669}, /*cmy*/
          {-4.21996094,1.934938153,5.481451972,-30.49215233}, /*cfy*/
          {269.0233671,-11.67729496,1032.216836,89.77194114,3.842699209,-57.39819598}, /*cmz*/
          {1.792164692,1.533779943,5.023516863,16.45158261} /*cfz*/
     },
     {
          2462753.5,
          {-60.67925259,11.06480152,-1656.895258,-96.47274866,-4.672028573,97.39337278}, /*cmx*/
          {1.377269007,4.315245885,1.568186419,1.796974179}, /*cfx*/
          {-1234.760626,123.4417413,-1390.251671,-208.4508606,-8.356288085,-56.33713957}, /*cmy*/
          {5.304729804,2.681495507,6.458029533,-2.797114862}, /*cfy*/
          {2691.684275,-268.4126872,-3191.591882,456.5413063,-18.17447149,-122.3321171}, /*cmz*/
          {71.23115264,8.937493644,3.283811584,0.2423687305} /*cfz*/
     },
     {
          2462769.5,
          {2361.669826,-249.6516825,-2810.965106,425.3908746,17.01743501,90.23518933}, /*cmx*/
          {7.42442203,2.662759469,0.1449981772,4.145152689}, /*cfx*/
          {47.2880735,4.318890202,-591.8751534,35.87732886,1.781868234,-28.01699523}, /*cmy*/
          {5.074812699,1.215815139,4.741821522,-0.1859051409}, /*cfy*/
          {200.7147637,-41.69595477,-1571.488253,-90.47406321,4.70952101,-58.25554443}, /*cmz*/
          {1.770133585,0.5723501513,1.118058885,2.767893252} /*cfz*/
     },
     {
          2462785.5,
          {-698.1643994,36.24082198,-2031.324474,-106.4677035,-4.219876505,30.09767085}, /*cmx*/
          {4.655294207,1.927728401,5.508480009,1.649483685}, /*cfx*/
          {764.1614195,-76.76503555,-978.9870831,-129.7815209,-5.256085059,-3.247791564}, /*cmy*/
          {2.416929622,5.869955911,3.37642076,3.687270347}, /*cfy*/
          {-1775.464338,174.1748493,-2326.346232,-295.769019,11.90277984,-6.502270781}, /*cmz*/
          {-0.8138303726,2.695653869,3.340490212,6.236105264} /*cfz*/
     },
     {
          2462801.5,
          {-2137.573053,202.8029225,-2351.771111,-338.7000911,-14.00457224,79.16907489}, /*cmx*/
          {4.23330844,2.779404617,6.550443005,-0.2849090019}, /*cfx*/
          {-655.9129988,58.86057411,174.2524662,-112.4140841,4.191716021,-21.06512655}, /*cmy*/
          {0.4589811929,8.680819497,15.50871004,7.740740479}, /*cfy*/
          {1182.049168,-104.6740073,-228.5642877,-210.1464491,-7.72745691,-46.07806813}, /*cmz*/
          {-0.4000299497,5.463569674,21.69023163,4.380699995} /*cfz*/
     },
     {
          2462817.5,
          {1526.697293,-148.2585752,-3174.408776,-284.7449187,-10.80081599,104.8484178}, /*cmx*/
          {1.610418488,-0.7845269346,9.195764543,2.409895252}, /*cfx*/
          {-912.8973426,96.42811727,1084.554381,160.2558285,-6.648758784,-50.82064368}, /*cmy*/
          {2.379562321,-12.90056491,0.3237474588,3.814603574}, /*cfy*/
          {2232.245406,-234.06697,2715.101473,-390.4325298,-16.03305835,-116.5513529}, /*cmz*/
          {-7.148069406,5.908043967,3.42139756,0.5639590094} /*cfz*/
     },
     {
          2462833.5,
          {2011.149021,-226.9619404,-2640.247854,370.6482721,-15.51125933,84.16543165}, /*cmx*/
          {1.181560525,2.808519826,3.454850904,4.560354754}, /*cfx*/
          {657.287012,-58.07681652,-215.0793563,110.687979,4.21914421,-37.57432233}, /*cmy*/
          {0.382932838,2.439312262,12.40903,0.3023887545}, /*cfy*/
          {-1253.841264,105.1431773,-339.911478,-211.7455318,-7.992068005,-81.07010574}, /*cmz*/
          {-3.401305042,14.93329362,-0.2592578964,3.334679465} /*cfz*/
     },
     {
          2462849.5,
          {-1709.002982,141.9035771,-3001.552049,255.7082361,-9.949910879,34.59948299}, /*cmx*/
          {4.846400008,5.61715188,6.214836307,1.539170596}, /*cfx*/
          {446.2775391,-48.69225607,-732.1309108,80.78598218,3.473801535,-8.013744613}, /*cmy*/
          {2.842084755,-3.34145306,6.763367106,3.936312702}, /*cfy*/
          {-1198.101442,125.8511311,1817.828678,207.9285124,8.799706797,-15.65690688}, /*cmz*/
          {-3.61066908,-0.2636060936,3.557733809,0.6181732237} /*cfz*/
     },
     {
          2462865.5,
          {-842.7132292,83.69731277,-1511.666549,-145.8062068,6.849678596,61.94199375}, /*cmx*/
          {3.958452865,3.227227225,3.830358538,18.85903651}, /*cfx*/
          {-913.3475069,88.39697572,414.3447256,155.153203,-6.040908852,-21.64895844}, /*cmy*/
          {1.143407526,-0.5499802273,0.0520238654,2.133996059}, /*cfy*/
          {1979.557279,-191.3059402,-788.2064612,-339.6108412,-13.10863203,-46.01442137}, /*cmz*/
          {1.211793974,-0.5779122527,3.158994059,5.149054941} /*cfz*/
     },
     {
          2462881.5,
          {2657.670487,-271.0075853,-4256.195833,-469.2628776,18.40905833,122.5599184}, /*cmx*/
          {1.747072111,-0.5584728583,0.0584028188,2.940881233}, /*cfx*/
          {-211.7354999,30.38659102,-696.8927936,-56.34196327,2.743101728,-40.28747315}, /*cmy*/
          {6.373637856,3.372912479,3.995870274,4.352086802}, /*cfy*/
          {756.800174,-97.18811763,1679.895317,-166.0238542,7.685566686,-94.36714586}, /*cmz*/
          {6.106569639,6.303790809,0.6759765315,1.077132238} /*cfz*/
     },
     {
          2462897.5,
          {727.7551004,-107.8937236,-1726.51209,176.4344756,-8.241584382,76.8745144}, /*cmx*/
          {0.9901940662,3.162534839,3.816862692,5.219134111}, /*cfx*/
          {1053.732002,-101.34629,551.0282086,-175.251421,6.924471445,-44.4339782}, /*cmy*/
          {4.360296217,-0.5149373342,0.1005228079,0.6499253405}, /*cfy*/
          {-2303.026023,217.6430738,-1065.696031,-379.6862504,14.92752535,-99.47139367}, /*cmz*/
          {4.395701972,2.60332442,22.06134381,3.71455338} /*cfz*/
     },
     {
          2462913.5,
          {-2253.690546,205.0104177,-3513.55823,349.6401604,13.97438809,36.09335889}, /*cmx*/
          {4.961804924,-0.4956736009,3.27407057,1.58569611}, /*cfx*/
          {2.263368786,-6.077755674,701.3937258,29.50418296,-1.519787556,-14.67235943}, /*cmy*/
          {0.484154733,4.173684466,4.622114961,3.963054761}, /*cfy*/
          {-243.5975909,35.28716964,1536.879052,77.79190804,-3.990630387,-30.0681779}, /*cmz*/
          {3.389954564,0.5313599664,1.108692681,0.7437075885} /*cfz*/
     },
     {
          2462929.5,
          {495.4845401,-45.97012767,-1083.541747,-131.2589211,-5.054712956,-38.64472191}, /*cmx*/
          {3.120949283,5.099125169,2.362372459,3.491185363}, /*cfx*/
          {-856.0459695,88.04281754,399.4477743,-149.0745243,6.052278288,22.3092774}, /*cmy*/
          {7.371596549,2.720717014,9.637279135,-0.6626475464}, /*cfy*/
          {1960.84532,-201.1500827,-841.9671964,341.9307298,-13.80980033,-47.81298619}, /*cmz*/
          {1.206259314,2.693495116,3.320904424,5.554517024} /*cfz*/
     },
     {
          2462945.5,
          {2682.995024,-285.0054436,-4264.58228,-480.3516113,-19.33128261,-126.3007886}, /*cmx*/
          {1.828588801,5.838588091,3.331253215,0.09881358251}, /*cfx*/
          {462.4818056,-34.9702741,-991.1234658,-79.76976113,-2.978987,37.56881308}, /*cmy*/
          {0.9265238121,-0.9837664396,2.62401286,1.804883005}, /*cfy*/
          {-738.4430537,47.16797079,-1942.379156,-135.4900421,5.192194677,-81.70600589}, /*cmz*/
          {3.882308539,1.961012171,2.370738361,1.643991386} /*cfz*/
     },
     {
          2462961.5,
          {-565.6923287,18.81600094,-1060.107275,106.4493526,4.619339474,-87.38972025}, /*cmx*/
          {0.2465207771,4.816532594,2.034193277,2.598479937}, /*cfx*/
          {1167.975046,-115.6954949,-648.1975504,-194.0632541,-7.868496345,47.85429622}, /*cmy*/
          {1.306862149,5.856168392,3.356843244,4.036479987}, /*cfy*/
          {-2582.414123,251.5066279,-1327.929892,-423.2693964,17.08791769,-105.0344098}, /*cmz*/
          {4.515946123,2.690095432,3.327353315,3.944994124} /*cfz*/
     },
     {
          2462977.5,
          {-2361.874331,224.0964915,-3629.321544,374.7422655,-15.29027777,-38.27163158}, /*cmx*/
          {5.009349767,5.884846895,0.2404249613,4.847871133}, /*cfx*/
          {-374.7999317,32.15228215,948.028737,-71.72840055,2.730740345,21.60218448}, /*cmy*/
          {7.203708218,2.224756397,2.698436425,0.8254819591}, /*cfy*/
          {509.1545122,-40.98402119,-1820.779828,116.1584153,-4.527614764,-42.96280985}, /*cmz*/
          {-5.564115013,2.012023123,2.426395054,0.7467869173} /*cfz*/
     },
     {
          2462993.5,
          {1293.706605,-125.2721638,-1434.209658,245.8865667,9.366605135,23.65405083}, /*cmx*/
          {2.5641861,-3.935224622,43.71473441,32.11791747}, /*cfx*/
          {-683.5756773,75.86576373,-253.5522523,125.7834285,-5.356524482,-20.94973592}, /*cmy*/
          {10.20655029,12.27170009,0.3569980007,2.616616748}, /*cfy*/
          {1615.943144,-177.1320725,526.9240928,294.1475099,-12.38195633,-43.66160838}, /*cmz*/
          {4.248333062,2.79822477,3.443568816,-0.5808197448} /*cfz*/
     },
     {
          2463009.5,
          {2344.693855,-258.1716245,-3947.506056,430.5838685,17.69966059,-123.0256772}, /*cmx*/
          {1.865049152,2.782554485,6.566255025,0.2564512463}, /*cfx*/
          {933.7966176,-80.75097776,-1373.291966,-151.816088,5.706436839,-41.28906707}, /*cmy*/
          {-5.123272726,5.566400126,6.133046205,5.32138884}, /*cfy*/
          {-1661.934412,136.47485,-2528.336627,-268.370929,-9.978297915,-82.56428156}, /*cmz*/
          {-2.115836067,2.349609227,24.88675261,1.997794525} /*cfz*/
     },
     {
          2463025.5,
          {-1386.031979,101.3113042,-1313.096145,213.8603221,-8.171467388,-102.2207101}, /*cmx*/
          {-0.4909211118,-0.8961752661,5.87894872,2.819052984}, /*cfx*/
          {1167.092549,-116.8855041,-592.4091518,192.7955992,7.980000053,-50.4112221}, /*cmy*/
          {-11.21621671,2.773690914,6.570617265,1.047678129}, /*cfy*/
          {-2624.903427,257.5185632,-1286.95887,-426.685127,-17.50188578,-108.7523726}, /*cmz*/
          {-33.07883391,-3.545887056,12.81171786,4.060422037} /*cfz*/
     },
     {
          2463041.5,
          {-2409.578944,234.7922896,-3714.920258,-389.8250436,16.09753073,-42.914847}, /*cmx*/
          {5.001586202,21.64371375,3.43744111,4.898654226}, /*cfx*/
          {-602.3260955,56.29456122,-1139.936099,-110.9756305,4.205730222,-26.89325818}, /*cmy*/
          {-2.0960718,8.669353964,2.924428853,3.957984203}, /*cfy*/
          {892.5732256,-81.91009533,2041.207729,-179.4443336,6.753572362,-52.13636687}, /*cmz*/
          {-2.294278942,-0.8905449582,5.886016567,0.7166643801} /*cfz*/
     },
     {
          2463057.5,
          {1667.317288,-161.3255433,-1805.306061,-303.5925334,11.6963025,16.49986948}, /*cmx*/
          {2.387995598,-0.7123666142,6.117862654,0.9376793435}, /*cfx*/
          {-560.3724071,67.21925946,-146.5939454,110.6812801,-4.909377936,-19.20996297}, /*cmy*/
          {3.380817073,-0.1908394878,0.4633764916,2.659112557}, /*cfy*/
          {1417.303001,-164.2343911,275.5152993,270.4270024,-11.69137279,-39.49410702}, /*cmz*/
          {4.343779601,59.41485012,3.516630713,-0.5409642723} /*cfz*/
     },
     {
          2463073.5,
          {2193.969937,-245.4368206,-3812.034663,-408.1430899,17.00833789,-122.7105756}, /*cmx*/
          {1.854737595,-6.592956035,6.619356633,6.595360096}, /*cfx*/
          {1197.730484,-105.8123389,-1571.103979,-192.6191573,-7.326043108,-44.75381328}, /*cmy*/
          {-5.065858181,-13.22249336,3.073659101,5.470178812}, /*cfy*/
          {-2138.142102,180.7373243,-2803.030071,-340.0394852,12.77265062,-86.20676793}, /*cmz*/
          {-14.61882528,2.420891941,2.991499553,2.124466181} /*cfz*/
     },
     {
          2463089.5,
          {-1770.850016,140.2744248,-1696.622975,276.7332053,-10.53011399,-113.1488912}, /*cmx*/
          {-0.7421965373,5.475644641,-56.83124998,2.865094424}, /*cfx*/
          {1192.575599,-119.4616739,558.419162,195.501654,8.173427409,-53.26051798}, /*cmy*/
          {-26.82742472,-3.479693886,0.3209014304,1.096361998}, /*cfy*/
          {-2769.407822,271.2700554,1342.260045,447.1318729,-18.43242551,-115.737541}, /*cmz*/
          {1.612734122,-0.3852900857,0.2671098075,4.079538202} /*cfz*/
     },
     {
          2463105.5,
          {-2520.464105,249.377988,-3861.414951,413.1418509,-17.15576155,-48.56941616}, /*cmx*/
          {4.967919089,-0.3340404964,-18.53765753,4.87300442}, /*cfx*/
          {-679.242032,64.90331354,1192.795311,-125.9563318,-4.793545809,-29.60355834}, /*cmy*/
          {-5.231819096,-10.15541987,-75.58061841,3.93389964}, /*cfy*/
          {994.4409731,-93.52704206,2075.753326,-201.0119048,7.594951864,-57.21099982}, /*cmz*/
          {-2.308418428,-0.8652773045,5.918194481,0.6747704128} /*cfz*/
     },
     {
          2463121.5,
          {1828.370831,-175.2593652,-2040.8907,328.8312138,-12.64296036,13.65855282}, /*cmx*/
          {2.313359501,8.725313255,2.994904627,0.9858913688}, /*cfx*/
          {-527.6667378,65.82110142,91.52014822,108.8966719,4.881837237,18.38358578}, /*cmy*/
          {-0.1483304612,-6.431268846,-2.64034259,30.93575382}, /*cfy*/
          {1408.830865,-166.8673434,-229.4567727,275.7736875,11.94807879,-38.10434363}, /*cmz*/
          {1.757700459,9.17073704,6.676951903,-6.823859869} /*cfz*/
     },
     {
          2463137.5,
          {2246.91897,-251.3429854,-3863.328658,-416.2312551,-17.49341282,126.5105209}, /*cmx*/
          {1.831741471,-0.2953139047,3.495129888,-2.818568023}, /*cfx*/
          {1333.707364,-118.2771847,-1654.979979,212.9134202,8.145926077,46.97627874}, /*cmy*/
          {1.23250636,-3.781278882,6.23527417,2.372070315}, /*cfy*/
          {-2404.362116,204.3690964,-2939.565823,379.0697274,-14.33012667,-90.33286696}, /*cmz*/
          {10.53114329,-0.7027078929,6.153795537,2.158647135} /*cfz*/
     },
     {
          2463153.5,
          {-1994.330257,161.9150288,-1951.604724,-316.6968123,-11.99106139,121.5240057}, /*cmx*/
          {-0.8485651233,8.639541824,-0.2485899096,-0.2665387727}, /*cfx*/
          {1248.268644,-125.0564053,-585.3318283,204.4743374,-8.558136337,56.03346182}, /*cmy*/
          {-17.31386977,2.816567504,3.474562049,4.244547975}, /*cfy*/
          {-2951.52629,289.3287695,1485.05607,-476.9466096,-19.64939745,-123.116044}, /*cmz*/
          {1.690061567,2.766868733,6.559555039,4.080388291} /*cfz*/
     },
     {
          2463169.5,
          {-2563.256665,255.4077182,-3918.647768,-420.9502616,-17.60889264,51.5238851}, /*cmx*/
          {4.956443748,-3.468243627,6.607434107,1.754121286}, /*cfx*/
          {-717.2754339,68.90617061,-1216.096421,-132.6979103,-5.082808689,30.94814891}, /*cmy*/
          {-2.086681915,2.420078081,-182.3853288,0.7857532625}, /*cfy*/
          {1080.561724,-102.299381,-2122.73995,215.4802737,8.220335181,-60.49643121}, /*cmz*/
          {-30.57318503,-3.986542303,5.941223667,0.6685676306} /*cfz*/
     },
     {
          2463185.5,
          {1959.399798,-188.0901983,-2169.212702,-351.7932851,-13.46022315,-13.20068402}, /*cmx*/
          {2.274224013,5.592608485,9.295922459,4.217730161}, /*cfx*/
          {-511.7118053,64.94137881,-79.4981291,108.6163789,4.866114769,-18.44756116}, /*cmy*/
          {2.744110616,12.44431486,-2.61971488,197.4427932}, /*cfy*/
          {1391.960412,-166.6766459,221.4837202,277.8336276,12.0054727,38.72570617}, /*cmz*/
          {-1.20847526,-3.375606717,6.693056551,-3.677593717} /*cfz*/
     },
     {
          2463201.5,
          {2186.464024,-247.7380613,-3809.237326,407.7889231,17.32903903,-128.7606611}, /*cmx*/
          {1.846619069,2.869277798,0.3802240974,-5.918804143}, /*cfx*/
          {1439.016614,-128.6310579,-1748.153211,229.3352581,8.821176767,-49.2986856}, /*cmy*/
          {403.3845585,2.517612236,6.254030344,5.566542302}, /*cfy*/
          {-2664.061772,229.7855408,3168.079716,-419.3749551,-15.96886092,95.36563288}, /*cmz*/
          {-5.128944068,2.464053738,12.46752986,5.374754383} /*cfz*/
     },
     {
          2463217.5,
          {-2268.595758,188.4800927,-2139.874177,-360.9722659,13.67768774,-128.1968397}, /*cmx*/
          {-0.9106044299,2.393428032,9.227082814,2.930171523}, /*cfx*/
          {1244.943138,-125.4250536,-585.0662561,204.8499308,-8.610589314,-56.93696384}, /*cmy*/
          {-11.03102774,15.39949753,3.491631656,1.138388251}, /*cfy*/
          {-2954.88326,291.5695722,1493.425692,479.8344227,19.85221711,125.0057852}, /*cmz*/
          {1.681262387,-0.3569259233,3.436691546,0.9835679061} /*cfz*/
     },
     {
          2463233.5,
          {-2479.684078,247.8384503,-3830.133489,406.8405389,-17.10105998,-50.28255741}, /*cmx*/
          {4.978950385,-0.3098080552,0.3442632984,4.978135506}, /*cfx*/
          {-779.036246,75.10146087,-1275.192758,142.4382131,-5.465231515,-31.69462792}, /*cmy*/
          {-2.046315125,5.582847399,12.42357358,3.94220583}, /*cfy*/
          {1258.739198,-120.0643991,2272.701796,242.3594058,9.246113685,62.80656711}, /*cmz*/
          {-2.218348233,153.1433081,-0.270930622,3.83882323} /*cfz*/
     },
     {
          2463249.5,
          {2070.15536,-200.304587,-2219.698487,-370.7887876,14.25714723,12.92259154}, /*cmx*/
          {2.261270652,5.615321189,6.181739114,1.294689284}, /*cfx*/
          {-466.5834793,60.86654743,-111.8793543,102.2355265,4.648933469,-18.09871971}, /*cmy*/
          {2.473822951,12.48590409,3.703023703,34.09439504}, /*cfy*/
          {1280.77328,-156.6643038,-113.1832772,-261.0688579,-11.44193521,-38.25891089}, /*cmz*/
          {1.823846281,-0.1975033254,22.43745875,-6.795961675} /*cfz*/
     },
     {
          2463265.5,
          {1967.789169,-227.7770118,-3598.711824,375.6417417,-16.08130437,125.1814805}, /*cmx*/
          {1.876382051,2.907766475,3.560662303,-2.729637739}, /*cfx*/
          {1494.012471,-134.525087,-1805.173226,238.8283049,9.200526458,-50.11675294}, /*cmy*/
          {7.566250988,2.53323036,-0.00747885482,5.618283125}, /*cfy*/
          {-2823.74392,246.8716505,3334.198506,446.5512142,-17.05037828,-96.99660414}, /*cmz*/
          {-23.93824477,18.19605738,-0.06435199728,2.310687365} /*cfz*/
     },
     {
          2463281.5,
          {-2398.774139,202.5135074,-2236.021079,-379.1755636,14.46753115,129.6563022}, /*cmx*/
          {-0.9327965341,2.420267295,2.97683032,-0.1785782397}, /*cfx*/
          {1211.266423,-122.199027,-550.3199686,198.9690142,-8.41371662,-56.57760326}, /*cmy*/
          {-4.756747537,-3.442003603,3.503947228,1.162022031}, /*cfy*/
          {-2854.749537,282.2405536,-1400.27611,-462.1779486,19.2518168,-122.7771691}, /*cmz*/
          {4.814477321,2.792926769,3.449134499,4.15408522} /*cfz*/
     },
     {
          2463297.5,
          {-2398.674744,241.1236486,-3755.143663,396.5200698,-16.632417,49.70172024}, /*cmx*/
          {4.979695333,-0.2983911276,0.3534582276,1.871384813}, /*cfx*/
          {-834.5961685,81.19318654,-1319.549034,152.5638165,-5.835485372,-32.86214122}, /*cmy*/
          {-2.026567883,18.167348,6.167525017,3.936441202}, /*cfy*/
          {1368.234427,-131.9766168,2340.738706,-261.4989757,9.909723239,-64.5215162}, /*cmz*/
          {4.098393135,11.79853367,-0.2277828015,0.6944279018} /*cfz*/
     },
     {
          2463313.5,
          {2091.944112,-201.8953731,-2280.387626,-370.730305,14.35712659,-10.59900135}, /*cmx*/
          {2.257520509,5.632845538,6.1996295,4.500674177}, /*cfx*/
          {-418.7836888,56.91849172,-146.5269788,95.23943519,4.405599019,-16.92808438}, /*cmy*/
          {2.098233453,6.23663395,3.738761568,-9.916879619}, /*cfy*/
          {1174.519922,-147.3309907,-63.28559043,243.3960784,-10.83080735,35.28657882}, /*cmz*/
          {3.131509272,2.966462894,3.613468757,-3.671686068} /*cfz*/
     },
     {
          2463329.5,
          {1745.929176,-204.3006638,-3362.606789,339.4311201,-14.62436009,-118.5275854}, /*cmx*/
          {1.868897461,2.946280725,3.597369251,-5.856263315}, /*cfx*/
          {1527.635077,-137.8034248,-1806.61687,244.0078281,9.415895705,-49.7503896}, /*cmy*/
          {7.563579778,2.547176268,0.0114718493,-0.6348187415}, /*cfy*/
          {-2862.628684,251.0707938,3288.072338,452.6323634,-17.29902286,94.29102971}, /*cmz*/
          {20.04233457,-0.63944911,6.239762095,5.480815232} /*cfz*/
     },
     {
          2463345.5,
          {-2541.732183,220.6662448,-2493.188389,-404.0032216,15.50260965,-131.4544387}, /*cmx*/
          {-0.9737626601,2.454133742,3.020076687,2.987795551}, /*cfx*/
          {1123.369421,-113.3170832,-429.665889,183.5135612,7.850315363,-55.94370231}, /*cmy*/
          {20.44066479,-3.413897751,0.3943090117,1.205435081}, /*cfy*/
          {-2696.750683,266.2307063,1223.377224,433.4377082,18.19469589,120.2139338}, /*cmz*/
          {1.764022847,-12.89947611,3.468426252,1.034011524} /*cfz*/
     },
     {
          2463361.5,
          {-2227.914863,228.7558514,-3616.509518,374.4911987,-15.79742888,-51.64935802}, /*cmx*/
          {4.954178893,-0.2736381729,0.3819817374,5.087255115}, /*cfx*/
          {-943.1260063,93.81288908,-1383.776297,-171.3774318,-6.605430921,-36.00760382}, /*cmy*/
          {-8.284541401,2.506472913,6.232926678,3.952431114}, /*cfy*/
          {1556.318016,-153.5706172,-2391.82773,293.1472042,11.15863116,70.22149657}, /*cmz*/
          {0.9839100584,2.429016844,12.4158099,3.838777169} /*cfz*/
     },
     {
          2463377.5,
          {2169.562336,-208.3384589,-2462.323711,-377.5469634,14.70790824,6.097014175}, /*cmx*/
          {2.236893938,5.666063647,6.242197838,1.448849557}, /*cfx*/
          {-288.4601804,45.33138777,-274.5725689,77.66093969,3.723650069,-14.65414892}, /*cmy*/
          {-4.569585096,0.08391604387,3.853547149,2.550883951}, /*cfy*/
          {960.4174481,-128.3772016,-285.8498643,211.7805982,9.61404234,-30.24688163}, /*cmz*/
          {10.33164663,-15.82103066,-12.03232806,-6.900257288} /*cfz*/
     },
     {
          2463393.5,
          {1237.694921,-151.8843637,-2817.76848,257.1325224,11.49112296,106.6501327}, /*cmx*/
          {1.864441416,-3.210716338,0.5761482407,-8.935052727}, /*cfx*/
          {1580.884069,-144.0824302,-1798.043255,251.6096558,9.811017758,-49.51493276}, /*cmy*/
          {20.13802947,2.583363931,0.05596882302,5.742073338}, /*cfy*/
          {-3014.718483,267.8084964,3276.415887,475.4622321,18.32826902,-92.92115295}, /*cmz*/
          {13.77178365,-6.886368384,-3.140111353,2.424556602} /*cfz*/
     },
     {
          2463409.5,
          {-3030.100107,277.232993,-3121.338074,490.7803483,19.01919854,140.640174}, /*cmx*/
          {-1.049297716,-6.896326722,3.119543311,-0.03733469662}, /*cfx*/
          {788.5182345,-80.94230879,78.47557882,-130.6670686,5.852292827,-52.39469667}, /*cmy*/
          {5.139431798,-12.69624451,-5.745883137,1.39696675}, /*cfy*/
          {-2194.174205,218.8261323,-745.9547644,353.4109093,15.20938943,-114.5365902}, /*cmz*/
          {5.198601811,-6.53685572,-2.729886207,4.308443706} /*cfz*/
     },
     {
          2463425.5,
          {-1673.015976,182.0276444,-3105.656201,-293.8411289,-12.86340874,55.92185157}, /*cmx*/
          {4.953678824,-9.590495578,-5.781344501,2.231867175}, /*cfx*/
          {-1144.441603,117.233255,1514.508483,204.7765419,8.057935051,-40.57011808}, /*cmy*/
          {-11.34504153,-0.5487026367,-3.07923986,4.041096878}, /*cfy*/
          {2064.298304,-209.3052074,-2681.57859,-375.8001983,-14.59525132,-82.61068819}, /*cmz*/
          {1.100881961,-0.605308114,3.130555504,0.7682411585} /*cfz*/
     },
     {
          2463441.5,
          {2376.994961,-230.419114,-2732.824648,-406.5488441,16.04276763,-2.902767013}, /*cmx*/
          {2.217291825,-6.829678821,0.05329125981,5.791573986}, /*cfx*/
          {10.86982776,16.87143759,565.1720319,-46.57980173,-2.392309451,11.45467039}, /*cmy*/
          {-1.497800347,3.878894047,1.215535401,5.440650735}, /*cfy*/
          {444.7460448,-80.72759992,781.6573641,141.9592414,6.898709736,-24.23809575}, /*cmz*/
          {-99.26218059,3.308382545,0.785463843,11.72569729} /*cfz*/
     },
     {
          2463457.5,
          {149.6677106,-43.1564558,1708.776703,123.2410986,-6.188005667,87.11794715}, /*cmx*/
          {5.108566982,-2.442057207,4.325254345,-27.56393471}, /*cfx*/
          {1546.81656,-144.2163112,-1718.248591,-246.2594157,-9.808178537,-49.0015762}, /*cmy*/
          {-17.53421274,-0.4873835261,-3.003718876,-0.358578016}, /*cfy*/
          {-3223.94616,294.6332638,3352.700224,509.9326693,20.03503285,-95.8647017}, /*cmz*/
          {-11.3127307,-0.5322682823,3.225802043,2.619799301} /*cfz*/
     },
     {
          2463473.5,
          {-3664.958749,353.4887228,-3830.385014,606.1437691,-23.92530219,155.4902785}, /*cmx*/
          {11.48138559,-0.5211273199,0.09890375419,-6.095885897}, /*cfx*/
          {92.43800828,-13.0866406,-612.6667829,51.57715944,2.609786944,-48.46226787}, /*cmy*/
          {-1.525423743,4.097802397,1.393643867,1.856639427}, /*cfy*/
          {-962.7850877,101.7373398,663.4627575,-175.1652885,-8.429160554,-105.0348659}, /*cmz*/
          {-39.75178165,3.289834204,0.7848499338,4.685746433} /*cfz*/
     },
     {
          2463489.5,
          {-367.0960092,60.57915112,-1867.258053,-122.9581992,6.443603348,71.13979919}, /*cmx*/
          {11.35541391,3.680088889,4.247876959,2.781144934}, /*cfx*/
          {-1304.765426,138.5363333,-1638.465417,-232.2053914,-9.401174952,-43.77861872}, /*cmy*/
          {17.02964224,2.698153803,-6.092067313,4.242036784}, /*cfy*/
          {2728.3942,-285.1064899,-3206.809106,-485.8417892,-19.4239991,-96.83285548}, /*cmz*/
          {1.254763265,-0.4870444069,3.277458598,0.9445909318} /*cfz*/
     },
     {
          2463505.5,
          {2474.072385,-247.6408948,-2821.963088,-422.7214787,-17.09396002,-3.929667385}, /*cmx*/
          {2.264288904,-0.4411847796,-2.951732132,6.546332128}, /*cfx*/
          {478.9558515,-29.53057437,-1008.457965,75.03099959,2.883845151,-10.37743741}, /*cmy*/
          {1.707822319,2.079723494,-0.613954488,1.764878866}, /*cfy*/
          {-510.8001628,11.57177359,-1692.361659,102.5873221,4.510159201,-22.31306329}, /*cmz*/
          {-1.618523271,4.69907801,1.922543426,4.939818061} /*cfz*/
     },
     {
          2463521.5,
          {-1502.221219,122.4330904,563.8094436,-262.1109805,9.645147659,67.20192555}, /*cmx*/
          {0.2013412899,14.7896055,2.709883395,-14.44174117}, /*cfx*/
          {1227.864221,-118.1192268,-1421.899545,196.9363225,8.162405878,45.88884287}, /*cmy*/
          {1.320611044,2.783397995,6.560263264,9.303894158}, /*cfy*/
          {-2958.430594,279.9605178,-3114.194927,471.5231886,-19.16094691,97.23454124}, /*cmz*/
          {4.428155607,-0.4203554389,0.2078396422,6.019208239} /*cfz*/
     },
     {
          2463537.5,
          {-3558.781177,360.8518719,3702.61487,-603.3116638,24.51651394,159.8105305}, /*cmx*/
          {2.139898139,2.732033611,3.378198821,-5.774667294}, /*cfx*/
          {-858.9129447,82.35061179,-1538.149221,159.028914,6.010256472,55.23051752}, /*cmy*/
          {4.8596686,5.505961012,9.198687515,5.652685842}, /*cfy*/
          {1111.028265,-102.4184932,-2628.063544,230.1484569,8.686358046,109.0236324}, /*cmz*/
          {1.597177003,-4.11524462,5.794759547,2.232804249} /*cfz*/
     },
     {
          2463553.5,
          {1753.875801,-150.3293608,-689.7461687,305.1586841,11.59028172,108.3240948}, /*cmx*/
          {0.5922732987,14.92922471,-0.2665983358,3.324110977}, /*cfx*/
          {-1105.334854,125.8273272,-1494.072098,-203.1438699,8.608481624,42.37068324}, /*cmy*/
          {4.516228898,2.845002671,3.500524114,1.51314827}, /*cfy*/
          {2709.848565,-298.5472661,-3282.881587,487.9530552,20.29570091,97.90097172}, /*cmz*/
          {1.342166836,2.786140138,12.8578896,4.436527196} /*cfz*/
     },
     {
          2463569.5,
          {1957.594524,-209.6129682,-2318.041799,-347.6069789,14.72189478,4.08746146}, /*cmx*/
          {8.789123535,-0.2747162532,0.3862086316,0.9756812334}, /*cfx*/
          {1012.55284,-84.79785182,-1514.718134,-155.9807886,6.058181724,13.30065504}, /*cmy*/
          {1.80606811,5.623826259,6.20617121,4.524813934}, /*cfy*/
          {-1752.933751,137.6913697,-2875.292719,267.3739097,-10.26177711,28.77086291}, /*cmz*/
          {4.842078016,11.80655987,-0.2056369228,1.380684158} /*cfz*/
     },
     {
          2463585.5,
          {-3005.024802,279.0312388,1756.29887,502.7274386,-19.21020965,-69.85667724}, /*cmx*/
          {1.279654147,5.661254178,6.245510042,20.91520078}, /*cfx*/
          {522.6026082,-53.46795085,-830.6376036,92.68982713,-4.342745159,-37.05759667}, /*cmy*/
          {1.200357551,3.206469031,3.813068573,6.473361838}, /*cfy*/
          {-1692.907153,167.6922868,-2092.826947,-278.4625642,12.2815227,83.35812042}, /*cmz*/
          {4.353212678,2.979734532,3.611197248,12.60091882} /*cfz*/
     },
     {
          2463601.5,
          {-1954.667564,217.2394985,-2267.391586,358.6061343,15.65592448,-138.836851}, /*cmx*/
          {5.726051598,-0.1734167343,9.916005193,4.104392999}, /*cfx*/
          {-1611.535305,162.4092218,-2263.344168,282.0609846,-11.03376841,-70.04228646}, /*cmy*/
          {4.943135996,-0.5645285741,0.05052964582,3.011188881}, /*cfy*/
          {2994.515952,-297.9142673,-4437.77978,-527.3400702,-20.40343398,136.1488331}, /*cmz*/
          {1.731638944,-0.6145049063,3.129986211,2.838510032} /*cfz*/
     },
     {
          2463617.5,
          {3505.737852,-335.3790473,2295.958936,589.1920483,23.11634611,-141.7707248}, /*cmx*/
          {4.495776915,-35.10681975,6.336284799,0.52636968}, /*cfx*/
          {-416.875111,62.85634631,-930.2234212,-102.606621,4.905577356,-41.74913006}, /*cmy*/
          {4.449662987,3.230753083,3.881086903,5.302434781}, /*cfy*/
          {1517.900621,-192.7439938,-2354.83686,307.2728348,-13.76119224,88.73141539}, /*cmz*/
          {1.31302516,-9.551546784,-8.885642675,5.000290947} /*cfz*/
     },
     {
          2463633.5,
          {940.1302647,-118.6058521,-1727.122186,-202.4637565,-9.592553472,-17.21302362}, /*cmx*/
          {3.097406117,-6.191940771,3.877626596,3.859549016}, /*cfx*/
          {1341.738237,-121.4348758,-1812.883189,-211.409608,8.428886978,-15.49354877}, /*cmy*/
          {1.895563692,-0.5097961752,0.1031051128,1.299417277}, /*cfy*/
          {-2589.805237,228.1110733,-3636.019534,405.308451,15.95431768,34.49514602}, /*cmz*/
          {4.953945596,-0.5638637257,-3.105743687,1.249593063} /*cfz*/
     },
     {
          2463649.5,
          {-3435.531926,333.9034085,2261.405692,-577.4956078,-22.87435994,-79.47536897}, /*cmx*/
          {1.357616635,-3.649193199,0.1075237938,-54.05442854}, /*cfx*/
          {-215.6119815,17.65267804,-323.6396767,71.95224399,-2.876353255,-26.01977435}, /*cmy*/
          {0.4020345909,4.892421063,5.24969553,6.872538403}, /*cfy*/
          {-193.5639601,25.63672064,-970.2184376,-114.9813072,-5.667326662,-59.95710274}, /*cmz*/
          {3.90260768,4.091686104,1.360219664,9.781054797} /*cfz*/
     },
     {
          2463665.5,
          {-217.6391508,51.77389866,-1837.514045,143.3309205,7.27825963,-121.9283761}, /*cmx*/
          {6.683438847,0.7247160262,4.352961851,-1.74114796}, /*cfx*/
          {-1787.878413,185.9168689,-2424.316376,314.7521321,-12.55649576,-76.22515349}, /*cmy*/
          {5.005230947,5.808290667,6.43843808,3.262456613}, /*cfy*/
          {3624.087537,-371.475077,5019.596317,636.1080261,-25.09951601,-151.3255494}, /*cmz*/
          {-1.345538371,2.627687027,-3.033446712,-0.02339725847} /*cfz*/
     },
     {
          2463681.5,
          {4152.740953,-406.6103156,2976.007382,695.0964238,27.72143668,-154.7272054}, /*cmx*/
          {4.571710356,2.647940806,0.1329196774,0.6714841982}, /*cfx*/
          {129.3527564,10.60797652,-480.1002305,-59.4654974,3.003897243,-46.8089544}, /*cmy*/
          {4.170117864,4.260965087,4.679227563,-0.6007854522}, /*cfy*/
          {527.8618087,-99.48958599,1527.463616,-176.7620292,8.767515813,-91.75820059}, /*cmz*/
          {4.319705873,0.268529164,0.8997991948,2.228613914} /*cfz*/
     },
     {
          2463697.5,
          {427.5895583,-69.73114415,-1741.857636,-148.1074165,-7.645096436,-24.53019671}, /*cmx*/
          {3.44615344,0.5443165895,4.216317445,3.708481057}, /*cfx*/
          {1450.065493,-134.2607192,1909.528761,231.2851165,-9.32770354,17.26798517}, /*cmy*/
          {-1.216094927,2.694122576,3.30900436,4.417128319}, /*cfy*/
          {-2905.330591,263.1604822,3927.982068,-461.5788472,-18.3589293,-39.42992722}, /*cmz*/
          {1.840795253,2.643111332,0.1035934207,4.334438239} /*cfz*/
     },
     {
          2463713.5,
          {-3411.120477,339.844629,2229.173236,-579.7827322,-23.39267192,79.62137821}, /*cmx*/
          {1.395721049,2.674899691,0.1608867311,5.763496408}, /*cfx*/
          {-530.7099844,48.82898894,377.9805066,112.7594391,4.262265869,-20.85615976}, /*cmy*/
          {2.62752042,-1.014459862,2.585164624,0.8469520383}, /*cfy*/
          {427.5713712,-34.30609131,755.2517275,148.1202862,6.145849171,48.52875984}, /*cmz*/
          {0.06554366577,1.713900658,5.215959012,-5.757853154} /*cfz*/
     },
     {
          2463729.5,
          {319.5778931,3.436079278,-2061.307422,146.6140655,6.670207301,121.0769837}, /*cmx*/
          {6.888823824,1.340991592,4.827176003,1.506586722}, /*cfx*/
          {-1806.79692,190.0514051,-2458.990274,320.3480429,12.84222722,77.41127268}, /*cmy*/
          {-1.27630869,5.837236453,3.327543936,0.1741893332}, /*cfy*/
          {3823.337901,-394.6787409,5254.851933,672.827983,26.6381278,157.1262795}, /*cmz*/
          {4.931954991,2.652758845,6.417637295,3.161519489} /*cfz*/
     },
     {
          2463745.5,
          {4391.054517,-426.2742661,-3095.737527,-727.4977255,-29.02798894,162.1389487}, /*cmx*/
          {7.758487517,12.06694587,3.272321018,3.788135423}, /*cfx*/
          {182.5437904,6.022064106,-421.6316821,-61.19740148,-3.037778952,48.26165229}, /*cmy*/
          {4.016567235,4.364939308,1.629888997,2.533653393}, /*cfy*/
          {557.5336507,-104.4170918,1485.225632,-188.4687922,-9.281983808,96.90497316}, /*cmz*/
          {4.284078557,0.2548931838,4.037137686,-0.9564434361} /*cfz*/
     },
     {
          2463761.5,
          {679.5594013,-92.04771544,1814.753165,175.5371535,8.925283845,23.37098173}, /*cmx*/
          {6.378452809,3.547593979,0.9619751809,0.3221251314}, /*cfx*/
          {1482.075701,-136.929709,1951.814934,237.5165672,9.538936624,-19.37215201}, /*cmy*/
          {-1.254476172,2.69093186,0.1586002517,1.20775942}, /*cfy*/
          {-3027.999329,273.4381896,4099.610642,-484.4008942,-19.17238645,45.40116123}, /*cmz*/
          {1.794814847,2.634318822,6.369473783,1.115376477} /*cfz*/
     },
     {
          2463777.5,
          {-3535.969166,354.6388382,-2263.082302,606.1976481,24.44250781,77.37622973}, /*cmx*/
          {4.617473124,-0.481961897,3.285442595,5.742403251}, /*cfx*/
          {-481.7835955,43.61599458,413.8113554,-105.9540417,-4.05839872,19.88281727}, /*cmy*/
          {2.609556382,2.077303348,5.654257505,3.929034923}, /*cfy*/
          {253.9263684,-15.47847734,812.8363789,137.926517,6.175265861,-49.69638238}, /*cmz*/
          {0.067236399,1.502315563,4.996442232,3.581219739} /*cfz*/
     },
     {
          2463793.5,
          {-143.7448273,54.74653182,1948.466931,-156.0491031,-7.833154035,127.6261239}, /*cmx*/
          {3.378946686,3.916995647,1.231162611,1.331255403}, /*cfx*/
          {-1857.829817,193.6798728,-2522.331711,-328.6070451,-13.09233492,-76.86540001}, /*cmy*/
          {4.958598765,2.679014038,6.449235344,-3.036644132}, /*cfy*/
          {4053.932154,-413.4288151,5553.229668,710.6750948,-27.94007625,-161.6506162}, /*cmz*/
          {4.878633887,8.914623111,3.249672441,-0.07053942238} /*cfz*/
     },
     {
          2463809.5,
          {4434.981442,-420.4205967,-2974.389064,724.6324088,-28.67732045,166.4861132}, /*cmx*/
          {1.5218114,8.890419486,3.229491123,3.673650887}, /*cfx*/
          {-64.8069117,30.06243643,-548.3792784,68.77547417,3.575925486,-46.29710556}, /*cmy*/
          {4.178836242,0.5866436877,4.292785404,-0.8144363341}, /*cfy*/
          {1223.928978,-170.1868976,1903.502172,282.6274133,-13.00592395,-103.3436079}, /*cmz*/
          {4.369630554,15.69920877,3.806521969,1.934540436} /*cfz*/
     },
     {
          2463825.5,
          {1274.72393,-146.2799178,2086.251267,-247.0899616,11.82462471,19.22285825}, /*cmx*/
          {5.980117198,0.1092554466,0.72811361,-0.0708029572}, /*cfx*/
          {1439.389488,-131.4580823,1916.114208,230.8408674,9.18493581,-20.67293169}, /*cmy*/
          {-1.319993892,2.655935085,0.1171599595,1.13515901}, /*cfy*/
          {-2993.369108,266.1721044,4135.965718,-480.5062762,-18.82538476,-49.93944588}, /*cmz*/
          {1.718847083,2.589676664,0.03085152391,4.185045907} /*cfz*/
     },
     {
          2463841.5,
          {-3673.98131,367.1256521,-2343.518589,-634.0444494,25.29321166,74.23807799}, /*cmx*/
          {4.701756471,2.624632025,3.241773443,5.654710741}, /*cfx*/
          {-284.0072994,23.5716911,373.9679787,-79.88928713,-3.212991933,20.83391871}, /*cmy*/
          {2.848807803,1.838458841,5.349846515,3.732933021}, /*cfy*/
          {-253.2286354,36.26004936,895.1992945,134.2389079,6.839944119,57.10786631}, /*cmz*/
          {0.3879215338,0.848028789,4.4462337,6.561742837} /*cfz*/
     },
     {
          2463857.5,
          {-897.0865266,132.8248854,2153.603512,235.7615548,-11.38553984,-139.1883747}, /*cmx*/
          {2.872701728,0.2043480599,0.808226382,-2.021958735}, /*cfx*/
          {-1875.31272,192.7409686,-2530.724145,-329.4522343,-13.0395558,-74.95256339}, /*cmy*/
          {4.906109172,2.649733746,6.415537058,9.433684864}, /*cfy*/
          {4191.982106,-420.5360895,5731.725695,-730.5944554,28.51644547,164.0986195}, /*cmz*/
          {23.67145688,5.739462156,-6.214498057,2.955719489} /*cfz*/
     },
     {
          2463873.5,
          {4417.525761,-410.7314981,-2857.050742,715.8327726,-28.08816956,-169.3954191}, /*cmx*/
          {1.570628757,2.58041995,3.192696073,0.4372119442}, /*cfx*/
          {-278.9353369,50.29260442,-652.2610269,89.63032225,4.415021317,-45.42661282}, /*cmy*/
          {4.276963272,0.2434960147,4.021368619,-0.9961158227}, /*cfy*/
          {1786.912871,-224.3244513,2231.84252,365.0673111,16.25202129,111.1316608}, /*cmz*/
          {4.418582966,-9.547196616,-18.29887096,4.892059139} /*cfz*/
     },
     {
          2463889.5,
          {1616.895495,-176.9280813,2362.891685,292.548288,-13.54635271,-19.10474471}, /*cmx*/
          {-0.4983671894,3.133421612,3.778136641,2.847329953}, /*cfx*/
          {1406.214721,-127.8179978,-1882.845415,224.8794011,8.941479513,-21.67506268}, /*cmy*/
          {1.774974379,2.633848726,0.09484092359,1.115753684}, /*cfy*/
          {-2953.124916,260.8962575,4139.000496,-473.7729444,-18.5259757,52.88933101}, /*cmz*/
          {1.66483184,-3.723048186,0.0008434030381,1.027202962} /*cfz*/
     },
     {
          2463905.5,
          {-3731.973153,372.4821445,-2398.90611,648.5993637,25.64315334,-72.99869055}, /*cmx*/
          {4.751636778,-0.529875352,-3.060165245,8.743613347}, /*cfx*/
          {-197.2987231,14.8060899,-363.5900056,-70.95674201,-2.938729673,21.5259517}, /*cmy*/
          {-0.203120151,1.67764569,5.171309276,3.630697619}, /*cfy*/
          {-469.8185797,58.59268743,932.5718929,150.0717166,7.602897032,-61.16909027}, /*cmz*/
          {0.4774074657,0.6094580011,4.254994839,9.633896238} /*cfz*/
     },
     {
          2463921.5,
          {-1009.897516,146.2204897,2273.319411,-257.3616183,-12.33064997,144.431238}, /*cmx*/
          {2.784233694,3.293429752,0.7745645235,13.65827762}, /*cfx*/
          {-1935.443406,198.0568424,2589.356752,-337.977165,-13.40235701,76.42502995}, /*cmy*/
          {8.028930369,2.642410301,6.408213085,-0.0111811656}, /*cfy*/
          {4352.009916,-434.6733482,-5893.017921,754.3934893,-29.50671653,-168.4430582}, /*cmz*/
          {1.662621899,-22.54163812,-3.078178867,-0.1998736443} /*cfz*/
     },
     {
          2463937.5,
          {4694.228853,-439.9712354,-3109.418448,-763.078265,-29.98575058,176.7197185}, /*cmx*/
          {1.605904841,-0.5381417648,3.217144896,3.613051396}, /*cfx*/
          {-175.7939609,40.70619984,553.2733271,79.79909952,4.040086825,47.70979971}, /*cmy*/
          {1.021265716,0.4317922328,4.158742648,2.215457361}, /*cfy*/
          {1522.952129,-199.099222,-1945.479552,323.4351895,-14.75764467,-112.0598579}, /*cmz*/
          {1.221318348,9.377102066,3.757979164,1.837493723} /*cfz*/
     },
     {
          2463953.5,
          {1245.786106,-141.6384293,2169.366049,239.7294785,11.46968045,25.30165938}, /*cmx*/
          {-0.3489379216,3.250953655,0.7582894643,0.02924497447}, /*cfx*/
          {1501.598673,-138.6705188,-1989.811101,239.3566642,-9.628396591,23.33559084}, /*cmy*/
          {1.784448554,-3.623239052,-3.006820773,4.324684238}, /*cfy*/
          {-3152.340084,284.7356249,-4333.043037,503.7654929,19.92927451,-55.73937383}, /*cmz*/
          {4.823468441,12.01825393,-21.93729487,4.230914442} /*cfz*/
     },
     {
          2463969.5,
          {-3690.387286,373.1045847,-2365.869351,646.1389065,25.70233287,75.57230409}, /*cmx*/
          {4.753687804,-0.4920607451,3.264911481,5.68229197}, /*cfx*/
          {-418.3925687,36.65531168,-469.4457862,-98.59069144,3.722423662,-19.37226646}, /*cmy*/
          {-0.6022224569,1.992980428,2.414177918,0.6259418237}, /*cfy*/
          {91.5335035,3.803641894,-866.8994802,-139.7109132,-6.405954587,52.96330793}, /*cmz*/
          {3.071062587,4.421716917,-4.655978145,0.3127759846} /*cfz*/
     },
     {
          2463985.5,
          {113.3903068,36.76578516,2050.172751,-161.7428742,-8.089132831,133.8689505}, /*cmx*/
          {3.362043833,4.098937949,1.38655887,1.34990836}, /*cfx*/
          {-1984.341256,206.2352153,2659.168132,-348.0303015,13.96967784,80.55979938}, /*cmy*/
          {8.063138272,2.679673508,3.312494236,-6.17958261}, /*cfy*/
          {4476.85893,-454.2164424,-5995.249999,776.7795094,30.7584965,173.2108557}, /*cmz*/
          {1.700846832,-3.65087808,0.1153069145,3.079082047} /*cfz*/
     },
     {
          2464001.5,
          {4980.59483,-479.501007,-3420.701057,815.1143889,32.51122236,181.3893166}, /*cmx*/
          {1.616352087,2.663701261,-18.69975207,3.771130564}, /*cfx*/
          {391.3088618,-14.71307965,354.4491646,79.09413115,-3.347343288,53.71937264}, /*cmy*/
          {-0.08357715693,1.712409448,2.069342192,2.567977649}, /*cfy*/
          {252.0576739,-74.83865892,-1029.815655,-162.4652105,-8.391382038,110.6779029}, /*cmz*/
          {0.7438023572,0.5744168449,4.261850336,5.360284541} /*cfz*/
     },
     {
          2464017.5,
          {240.0783596,-43.68814014,1919.832633,-137.8268011,-7.183859888,41.00719998}, /*cmx*/
          {0.2130812491,0.8708846766,-1.793276372,0.3717811387}, /*cfx*/
          {1561.656922,-148.3576834,2063.027842,-250.1898476,10.2173389,-23.48549302}, /*cmy*/
          {23.83069891,-12.98403396,0.2168966597,7.621127273}, /*cfy*/
          {-3374.297691,315.7848638,4530.839459,-541.720309,-21.78233308,57.13599123}, /*cmz*/
          {1.74343743,2.667256778,0.1482694911,1.204199818} /*cfz*/
     },
     {
          2464033.5,
          {-3222.567479,337.3203959,-1925.566458,574.2468272,-23.4127141,72.91251804}, /*cmx*/
          {4.740800904,5.869529544,-6.069304184,5.816455997}, /*cfx*/
          {-831.2904778,78.57107999,759.4693282,158.6031254,5.915712874,14.20254799}, /*cmy*/
          {2.200341653,5.448203821,-3.454972962,4.231237668}, /*cfy*/
          {1096.380828,-96.22264691,1331.221787,235.7656285,8.831328886,-35.34438704}, /*cmz*/
          {-0.7558074524,2.080840764,5.664658675,3.749876891} /*cfz*/
     },
     {
          2464049.5,
          {1866.575222,-137.5010057,-2884.873397,313.4691526,11.67045065,123.3884367}, /*cmx*/
          {0.9338530507,2.149617081,-0.5213125678,1.797305283}, /*cfx*/
          {-1662.480492,179.508219,-2346.028666,299.2344581,12.27977868,-76.17520486}, /*cmy*/
          {-7.572562003,5.901491895,3.403864944,-2.849679174}, /*cfy*/
          {4074.52052,-425.3932345,5571.454741,716.3589007,28.89250122,167.6361818}, /*cmz*/
          {4.900217429,2.702856414,6.48009088,-3.018213031} /*cfz*/
     },
     {
          2464065.5,
          {4736.460953,-467.156125,3192.348183,777.8629797,31.68663336,176.3843922}, /*cmx*/
          {4.777623741,2.732673667,6.518307086,3.970465437}, /*cfx*/
          {1141.726686,-91.51295044,857.9983498,-180.4775844,6.830345639,-63.40385035}, /*cmy*/
          {-13.57854511,11.7850034,-6.531268328,-0.1978443186}, /*cfy*/
          {-1414.61842,92.74863274,1277.887386,-238.721546,-9.212786005,124.0005439}, /*cmz*/
          {2.406138809,2.075237244,5.649864517,-0.4872751006} /*cfz*/
     },
     {
          2464081.5,
          {-971.3657575,79.85928031,-2372.959362,-218.7432827,-8.565175556,63.26588395}, /*cmx*/
          {3.940759149,2.055264982,5.617068303,0.5405548728}, /*cfx*/
          {1396.867697,-137.1405674,1901.932581,226.6987344,9.464040742,21.90114651}, /*cmy*/
          {-1.23699811,2.812010575,0.3212372377,-1.52225097}, /*cfy*/
          {-3369.004922,327.141111,4537.924186,-547.9819149,-22.47140916,-58.24386359}, /*cmz*/
          {1.794637323,2.749039682,6.52894511,-1.758893471} /*cfz*/
     },
     {
          2464097.5,
          {-2346.752913,263.418402,1081.467056,441.199162,-18.71191359,-61.28007205}, /*cmx*/
          {1.619408298,-0.2938525415,6.629115921,2.763503201}, /*cfx*/
          {-1130.875074,110.7767465,-1017.602826,204.6171622,7.819077509,-11.18799794}, /*cmy*/
          {-1.040276792,-0.6687191588,-34.65646082,1.799014528}, /*cfy*/
          {1990.507927,-187.112378,2064.543214,-364.8932448,13.76277535,20.2541433}, /*cmz*/
          {-0.9835326673,11.78989963,18.61154041,1.164210381} /*cfz*/
     },
     {
          2464113.5,
          {3496.417311,-302.4469292,4175.905396,-560.465771,21.14808524,-127.5823124}, /*cmx*/
          {79.76959429,5.5793629,6.152975389,5.391821584}, /*cfx*/
          {-946.6224422,112.3119227,-1627.694177,-186.466288,-8.048219113,-62.06992911}, /*cmy*/
          {5.121061947,2.928882516,-5.84271026,-2.607042617}, /*cfy*/
          {3062.390475,-335.1314752,4566.798859,557.1074376,-23.18450427,151.1009919}, /*cmz*/
          {4.96618035,2.810476228,3.456379189,-2.820636468} /*cfz*/
     },
     {
          2464129.5,
          {3810.137219,-385.3109476,-2241.469327,629.7239795,-26.49629326,-164.0698752}, /*cmx*/
          {-17.15982652,2.834165159,3.493381535,1.085613839}, /*cfx*/
          {1755.328862,-158.2035837,1451.435088,279.9551801,10.85901954,-72.60972967}, /*cmy*/
          {36.52964332,2.546919135,-37.6973208,0.09966128388}, /*cfy*/
          {-3163.092538,273.7040054,-2863.713687,-506.9416877,19.37439073,152.7767695}, /*cmz*/
          {-1.120257287,2.449202611,3.017054163,-0.1394112249} /*cfz*/
     },
     {
          2464145.5,
          {-2286.741442,218.9436407,-3336.364165,-420.9815771,-16.11842011,-90.07218415}, /*cmx*/
          {-8.285318804,2.426223421,-150.9603314,3.805739292}, /*cfx*/
          {975.5275,-100.2875086,1480.383987,-163.1307328,7.110308724,-20.60152927}, /*cmy*/
          {-32.55871983,-6.467038039,-12.08285962,2.122569909}, /*cfy*/
          {-3009.956569,305.2713694,-4239.337639,500.3872465,-21.11638456,59.16596658}, /*cmz*/
          {4.983014478,-0.2928565459,0.3612999374,-4.594438276} /*cfz*/
     },
     {
          2464161.5,
          {-1246.308548,166.3787185,48.76383509,-281.7915299,12.86115387,44.69101197}, /*cmx*/
          {-3.222993202,-3.194861259,-2.55818595,5.9176987}, /*cfx*/
          {-1210.688147,122.1282284,1100.526921,-216.5032552,-8.483498662,10.86314449}, /*cmy*/
          {-10.45898572,-22.5443786,0.04367300625,5.524519018}, /*cfy*/
          {2669.443237,-258.6521662,2714.008106,-470.5735362,18.19201626,-15.41520318}, /*cmz*/
          {-1.041826815,5.650874926,6.231700379,5.255481778} /*cfz*/
     },
     {
          2464177.5,
          {4606.372323,-420.1261694,5094.887352,-737.6509466,28.57962457,140.3554299}, /*cmx*/
          {17.06452487,-0.5807206804,0.02689889753,2.601893925}, /*cfx*/
          {-62.61959237,25.53403417,-782.8479346,65.44402767,3.293137027,44.59393616}, /*cmy*/
          {-7.06473643,-5.682895307,4.257963139,7.182969423}, /*cfy*/
          {1479.050137,-185.7368479,-3031.870853,-314.0931017,-14.16422988,-125.9228778}, /*cmz*/
          {-35.74922906,-25.19636165,3.7194108,38.2742619} /*cfz*/
     },
     {
          2464193.5,
          {2100.814419,-223.6759994,-526.7256564,367.2374851,16.75004061,149.6392147}, /*cmx*/
          {1.997511663,9.37230004,6.89211844,4.604006408}, /*cfx*/
          {1991.727489,-189.3572772,-1714.368427,322.58735,12.79984637,75.62133486}, /*cmy*/
          {-4.327889086,-3.636763374,0.1285543935,3.484812712}, /*cfy*/
          {-4678.867361,437.3086024,4388.877695,-760.4983883,-29.74356437,-186.1012789}, /*cmz*/
          {1.946691567,-3.702153222,0.04923036734,3.267429852} /*cfz*/
     },
     {
          2464209.5,
          {-3554.019991,357.2541098,4436.720153,-632.2483865,24.78818706,116.632344}, /*cmx*/
          {-4.959832157,2.576185413,229.3720893,0.7901282387}, /*cfx*/
          {379.4782294,-44.31050536,-901.4325199,-78.60799005,-3.88086709,24.04268272}, /*cmy*/
          {-4.059952017,0.2583280346,4.034660556,-0.4125808735}, /*cfy*/
          {-2111.90838,229.4087314,-3434.759234,371.3516149,16.57648764,-63.26641403}, /*cmz*/
          {17.62881625,-62.94842101,-121.9724707,-0.9695948313} /*cfz*/
     },
     {
          2464225.5,
          {-57.01026531,57.06434923,1155.495875,151.3422866,-7.701604351,27.80225496}, /*cmx*/
          {23.58968209,0.6738233999,1.166697324,-88.49165298}, /*cfx*/
          {-1109.920124,115.7964062,1014.775244,-199.7515929,-8.046149533,-9.950018863}, /*cmy*/
          {8.456884099,2.691192004,-6.115504652,2.709722711}, /*cfy*/
          {3072.822817,-305.5638249,3112.91279,536.4087108,-21.23194661,18.68669602}, /*cmz*/
          {-1.032096574,2.613605322,-3.06306572,2.779150053} /*cfz*/
     },
     {
          2464241.5,
          {4937.656827,-464.5858511,-5338.649538,794.0219615,-31.52472023,149.9985326}, /*cmx*/
          {7.702826455,2.648728992,3.272980901,-3.431351094}, /*cfx*/
          {689.4460197,-50.50544771,-513.1920004,112.3780097,4.172391456,33.73665705}, /*cmy*/
          {0.5268595567,-4.129468165,-0.5145921436,20.28238071}, /*cfy*/
          {-428.0063104,-0.5952155412,1351.022144,-156.2084453,7.125160897,-100.0242272}, /*cmz*/
          {-0.718293097,1.309759394,1.660161964,0.9548352332} /*cfz*/
     },
     {
          2464257.5,
          {-168.3775441,-2.828975944,1787.506107,-182.4053901,8.517344422,148.6987318}, /*cmx*/
          {1.578151253,1.340023008,1.705403436,5.101767892}, /*cfx*/
          {1881.130574,-185.2398818,1626.799757,309.1435517,12.54469091,73.67197969}, /*cmy*/
          {5.138407035,2.72527256,6.50843393,3.70502502}, /*cfy*/
          {-5485.986095,534.167199,-5204.526785,-904.6206521,-36.07639141,-209.6388944}, /*cmz*/
          {-1.190114993,-16.18649168,0.1522084303,3.487623262} /*cfz*/
     },
     {
          2464273.5,
          {-4475.55756,463.7096873,5327.66759,790.0663977,-31.66692076,135.6939184}, /*cmx*/
          {20.27903625,5.80859289,0.1508311499,0.937375427}, /*cfx*/
          {-234.7187088,15.49576011,-486.1568083,-69.30468938,-2.920188474,33.32991073}, /*cmy*/
          {2.995092608,1.790781573,5.293863704,-0.0009259734964}, /*cfy*/
          {-675.7841274,95.51440713,2142.103203,189.3919853,9.770734163,-79.29302304}, /*cmz*/
          {2.14158992,-5.811012692,4.19584425,-0.4319188168} /*cfz*/
     },
     {
          2464289.5,
          {1126.98347,-56.50943885,2292.754419,-198.9529868,7.951876422,17.56822399}, /*cmx*/
          {4.821001401,4.991635838,5.375289134,5.169085831}, /*cfx*/
          {-975.1010947,106.337703,-889.4283868,-179.2989871,7.462452593,-8.299565416}, /*cmy*/
          {5.429236773,2.79391109,3.432571543,2.877664518}, /*cfy*/
          {3134.174208,-321.6186856,-3144.661851,-551.5865285,-22.33814398,20.82858136}, /*cmz*/
          {-10.402494,-56.98501875,-2.95245343,3.046365} /*cfz*/
     },
     {
          2464305.5,
          {4518.227728,-436.4928135,4959.869382,-732.3566573,29.90155375,151.4028259}, /*cmx*/
          {4.598109798,5.879980801,6.514854596,9.332911454}, /*cfx*/
          {1263.210888,-108.6845315,939.9024489,202.6980206,-7.609043911,-34.48510312}, /*cmy*/
          {4.297150461,2.421817036,2.987295143,5.095884582}, /*cfy*/
          {-2254.121379,179.8096806,1335.366391,375.752325,-13.87539876,-87.3979598}, /*cmz*/
          {-5.46016945,5.381972121,-0.4013167404,-29.93078714} /*cfz*/
     },
     {
          2464321.5,
          {-2455.289912,224.684204,-4023.797651,462.5906545,-17.32453034,169.7105493}, /*cmx*/
          {-1.464015422,11.69727708,5.92984184,5.564854246}, /*cfx*/
          {1683.870463,-170.7172882,-1420.285347,281.1373191,11.70881647,-74.17083309}, /*cmy*/
          {-48.17683838,2.807845514,0.3215889375,0.7774549702}, /*cfy*/
          {-5349.733801,535.950884,5006.391951,893.4287022,-36.33658847,-214.2228609}, /*cmz*/
          {2.001825241,5.877073267,6.521568487,-2.589229028} /*cfz*/
     },
     {
          2464337.5,
          {-4780.768997,508.1692332,-5729.512415,847.1241194,-34.59578162,141.1301795}, /*cmx*/
          {4.636239627,5.876058489,6.516780296,-11.46272852}, /*cfx*/
          {-820.3530672,73.87146342,704.0089357,-153.5846742,-5.826620678,-46.29031839}, /*cmy*/
          {-5.425022868,-16.53409025,5.965099206,3.374771098}, /*cfy*/
          {871.9671783,-57.0205292,-1134.353365,-216.0984276,8.933189794,-103.1599895}, /*cmz*/
          {-0.1683216884,5.002861413,5.372478163,-0.05526583357} /*cfz*/
     },
     {
          2464353.5,
          {2091.242548,-152.4490108,-3187.745324,331.8991842,12.5510922,17.97030407}, /*cmx*/
          {1.748265932,2.2379652,5.870228656,-1.820007622}, /*cfx*/
          {-871.7498584,100.4114054,-792.4452756,167.2765688,-7.204659264,7.258978656}, /*cmy*/
          {-0.6892162125,-6.526882587,12.97065625,-0.2235499071}, /*cfy*/
          {2878.266714,-306.7426567,-2830.518939,-518.6125118,-21.5407401,20.52928906}, /*cmz*/
          {2.254888138,5.931920375,3.425300626,3.136425304} /*cfz*/
     },
     {
          2464369.5,
          {3733.634068,-369.6470302,-4295.256903,614.8974189,-25.85861699,145.0855837}, /*cmx*/
          {1.480179239,-3.449100772,3.477983796,3.205635597}, /*cfx*/
          {1731.260022,-155.3790591,1376.936756,-278.8889245,-10.67415833,-41.69971722}, /*cmy*/
          {4.44333467,-13.20005242,9.382386891,-0.8663270611}, /*cfy*/
          {-3489.414796,303.8565966,2431.516971,568.616103,21.40695635,-90.74808592}, /*cmz*/
          {1.216575147,5.55550272,2.976515728,-4.359448831} /*cfz*/
     },
     {
          2464385.5,
          {-3774.160046,358.9271331,-5277.946312,-669.884426,25.33174283,189.4705829}, /*cmx*/
          {4.859888031,2.422479224,2.987375667,-0.4827233502}, /*cfx*/
          {1500.230151,-155.5229822,-1219.132206,253.8370205,10.84384572,-75.88071556}, /*cmy*/
          {2.209745018,-3.396623574,0.4044583767,-61.89691203}, /*cfy*/
          {-4825.762434,491.8101959,4402.227876,-810.6139792,-33.54732269,-207.132987}, /*cmz*/
          {-10.50531883,2.789178551,0.2980492516,3.832569751} /*cfz*/
     },
     {
          2464401.5,
          {-4782.721819,514.8205993,-5819.979368,854.6358513,35.09002333,-140.7819401}, /*cmx*/
          {4.66533632,-0.3795283657,15.97616013,-8.244107052}, /*cfx*/
          {-1132.03936,105.2894776,974.2108577,-203.9469246,-7.783974347,-53.70081036}, /*cmy*/
          {1.068227417,-72.99541025,-6.473254868,-2.824363742}, /*cfy*/
          {1567.293142,-126.8411373,-1258.54034,309.2524978,11.90529947,-114.6481543}, /*cmz*/
          {-5.803874564,2.136777332,5.733395132,0.06295481083} /*cfz*/
     },
     {
          2464417.5,
          {2391.696748,-181.3781217,3452.224452,380.4856415,-14.40470601,-19.393399}, /*cmx*/
          {-1.372385409,90.27231241,2.803798143,1.008090067}, /*cfx*/
          {-833.5878536,98.41265223,-765.0387061,164.0789511,7.210592195,7.298177841}, /*cmy*/
          {5.683302485,12.37841307,-2.691535959,-0.1109051389}, /*cfy*/
          {2764.955959,-299.005969,2692.591642,502.6994974,21.25831271,21.37224758}, /*cmz*/
          {-0.8468342859,2.829850765,6.602827093,3.266680144} /*cfz*/
     },
     {
          2464433.5,
          {3606.978426,-358.7380393,4171.78335,-599.2191387,-25.30138818,143.380899}, /*cmx*/
          {4.627048786,5.997351085,3.505158618,9.521152241}, /*cfx*/
          {1876.963775,-169.9831629,1505.513079,302.305122,-11.65907022,-44.00964218}, /*cmy*/
          {4.472805459,2.520227552,3.118159543,-0.7894681236}, /*cfy*/
          {-3780.887003,333.5332634,-2704.85809,-615.8859595,-23.33967459,-91.97649671}, /*cmz*/
          {4.407310405,2.432167551,6.148479101,-4.270306099} /*cfz*/
     },
     {
          2464449.5,
          {-3647.823756,346.3076055,5183.632913,651.8008782,24.56368647,187.6945529}, /*cmx*/
          {1.706892604,5.554073161,2.968261808,-0.5238328772}, /*cfx*/
          {1537.007324,-159.3536089,-1267.349261,258.72098,11.042424,76.20227201}, /*cmy*/
          {2.19524104,-3.401764794,0.3958509944,4.052690371}, /*cfy*/
          {-5015.677747,510.6146734,4622.893975,-838.4950755,34.67422172,211.1264692}, /*cmz*/
          {2.042225959,9.062692543,3.427593935,6.940492296} /*cfz*/
     },
     {
          2464465.5,
          {-5040.845686,538.0716321,6012.557741,901.0187327,-36.65800618,148.0411024}, /*cmx*/
          {1.512843009,5.880392513,0.2421864061,-24.03516577}, /*cfx*/
          {-990.5021122,90.03682921,832.0697927,-179.756494,-6.855168803,50.3886958}, /*cmy*/
          {0.9797158936,8.631225077,6.026955325,0.2541292215}, /*cfy*/
          {1157.594463,-81.77672752,-1134.648291,257.5199513,-10.23171251,110.2480106}, /*cmz*/
          {0.09701999933,1.942934304,2.355341021,3.091789438} /*cfz*/
     },
     {
          2464481.5,
          {2044.828541,-142.4223779,-3152.585043,329.7516137,12.50813862,16.91887636}, /*cmx*/
          {1.717889574,2.210180998,5.796802395,-2.148682524}, /*cfx*/
          {-897.4777226,102.3477149,-837.5761221,171.3449029,7.44223672,-8.052097941}, /*cmy*/
          {5.584636634,-0.2260377595,3.543526191,3.183355538}, /*cfy*/
          {3052.295924,-321.5076459,-3032.258682,543.0830742,-22.81904362,-24.82206167}, /*cmz*/
          {2.229155166,27.92992942,9.702818466,6.536440341} /*cfz*/
     },
     {
          2464497.5,
          {4303.515344,-421.3154628,-4692.625258,707.2133432,29.27994866,150.7333589}, /*cmx*/
          {1.47347806,2.794110154,25.43283902,9.436308729}, /*cfx*/
          {1672.067084,-150.1562066,1292.040496,-269.3637647,10.34361559,38.96595713}, /*cmy*/
          {4.456774153,5.628077736,-0.06455458616,-4.042603389}, /*cfy*/
          {-3327.750597,288.090468,2201.042843,-547.6981368,20.58999582,87.41817121}, /*cmz*/
          {1.211324759,2.366532925,2.925392319,-1.336161606} /*cfz*/
     },
     {
          2464513.5,
          {-2673.684965,247.2273589,4321.484353,503.1449052,18.76573006,175.4228434}, /*cmx*/
          {1.64459866,5.442653985,9.095431831,-0.7358286861}, /*cfx*/
          {1634.715629,-167.8182456,-1427.514441,273.4532534,-11.46477847,-73.44971196}, /*cmy*/
          {33.52383486,2.829061049,3.480219787,7.068825562}, /*cfy*/
          {-5639.873233,569.3984058,5431.766833,-940.7107048,38.40870544,224.23071}, /*cmz*/
          {8.269080101,2.737362389,3.379346312,0.527714489} /*cfz*/
     },
     {
          2464529.5,
          {-5275.005133,555.0759012,6057.287667,938.5661642,37.79583709,-157.9539868}, /*cmx*/
          {1.480786828,5.843238031,3.340175503,-2.167388824}, /*cfx*/
          {-689.1192669,58.94420171,546.8112668,-128.8637193,4.936020408,-42.37097547}, /*cmy*/
          {0.7280863253,2.228409354,2.725841855,3.276246905}, /*cfy*/
          {338.374986,6.086205383,-1370.827856,188.4340676,-8.841669815,102.9818215}, /*cmz*/
          {-0.6744690761,1.345264597,1.733328158,2.870614366} /*cfz*/
     },
     {
          2464545.5,
          {1478.25203,-82.74295735,2667.188194,-252.3686282,-9.913443635,-13.98468294}, /*cmx*/
          {-1.532560459,5.1299259,2.355907448,1.177266786}, /*cfx*/
          {-912.708046,99.92388702,-881.9915865,168.4850698,7.172524099,7.870158353}, /*cmy*/
          {5.476365308,-0.2805794113,3.484402916,0.1248454684}, /*cfy*/
          {3402.922322,-346.2378142,3510.402651,-590.8507481,24.44040742,-27.3467285}, /*cmz*/
          {-0.9887461173,5.889487337,0.2215736412,6.626370848} /*cfz*/
     },
     {
          2464561.5,
          {4919.267082,-475.1484812,-5067.029632,-800.7445844,-32.66667481,-154.9183132}, /*cmx*/
          {1.455042615,5.88462798,-2.89856745,12.47947706}, /*cfx*/
          {1334.697547,-118.5809693,975.1432494,-215.9983692,-8.230059997,31.91925479}, /*cmy*/
          {4.432981565,5.587913528,3.024015337,2.082870727}, /*cfy*/
          {-2631.822381,220.3647288,-1480.486936,-446.6311662,16.61697911,85.84049829}, /*cmz*/
          {4.231436761,2.259508269,-3.500147135,-1.62084872} /*cfz*/
     },
     {
          2464577.5,
          {-1949.492169,173.7551999,-3689.510797,-397.4705544,14.88348188,-168.9567351}, /*cmx*/
          {-1.582846386,2.167370695,2.630121643,2.228878585}, /*cfx*/
          {1511.560298,-155.0355192,1387.783886,254.1399162,10.55884673,-65.70116075}, /*cmy*/
          {5.215758411,2.804772684,0.3124641689,6.994872379}, /*cfy*/
          {-5981.022357,602.857359,-6024.652274,-1003.115526,40.61734273,-233.2051011}, /*cmz*/
          {5.096716006,2.712550644,3.351083684,-96.95236322} /*cfz*/
     },
     {
          2464593.5,
          {-5373.816123,562.3498244,-5946.702356,-951.4034037,38.25137697,-165.3845073}, /*cmx*/
          {4.603500337,2.690216218,3.325832424,4.065792762}, /*cfx*/
          {-588.0382387,49.04195961,-414.9193943,-108.7077861,-4.171635005,-37.42238951}, /*cmy*/
          {3.841115585,2.216641453,5.844873475,3.236880594}, /*cfy*/
          {97.02805503,35.38288464,-1526.028552,184.7982768,-9.237965499,-105.2025886}, /*cmz*/
          {589.6919743,1.088363051,1.517118907,-6.654945358} /*cfz*/
     },
     {
          2464609.5,
          {1304.514653,-65.45636825,2550.688569,230.4592708,-9.265760473,-16.67700773}, /*cmx*/
          {-14.18603761,1.893957708,2.252403131,1.196948018}, /*cfx*/
          {-825.4444508,89.19581828,824.1492039,-150.2221405,-6.367831406,6.202040331}, /*cmy*/
          {2.307751521,9.135026827,6.623176452,0.2288131952}, /*cfy*/
          {3576.969804,-358.1828591,-3807.952693,-612.4102276,25.14771525,27.07984803}, /*cmz*/
          {-4.162788682,5.874916615,6.493492162,3.612377824} /*cfz*/
     },
     {
          2464625.5,
          {4849.152974,-468.4443772,-4843.617448,787.877521,-32.18818194,151.211505}, /*cmx*/
          {-4.842736256,2.745611007,3.383405571,15.59807165}, /*cfx*/
          {1182.557068,-106.1980786,-851.4013644,193.0917984,7.337099706,-27.5921715}, /*cmy*/
          {1.328682338,2.458207558,6.179035624,-1.050681619}, /*cfy*/
          {-2618.46881,222.4267305,1401.829152,-451.2024211,16.70264374,84.6370856}, /*cmz*/
          {1.17632603,8.547278593,-3.500231276,-1.649063543} /*cfz*/
     },
     {
          2464641.5,
          {-2632.354189,241.67282,4384.243443,-497.9486503,-18.62013798,174.9761772}, /*cmx*/
          {-4.725992607,8.560081199,-0.3518532544,5.472565732}, /*cfx*/
          {1220.699187,-127.5794485,-1153.963277,-208.9332079,-8.787217148,57.71882344}, /*cmy*/
          {8.414676184,-0.3015929173,3.495521325,-8.646943483}, /*cfy*/
          {-5761.509553,589.0395717,5975.271272,-979.1515304,39.85537266,-232.7955452}, /*cmz*/
          {1.974205479,2.733480391,3.377301151,-2.660072156} /*cfz*/
     },
     {
          2464657.5,
          {-5344.423242,568.0958648,5827.37734,-945.5637824,-38.5525234,167.7971438}, /*cmx*/
          {617.2313668,2.733850284,6.517800983,1.031435788}, /*cfx*/
          {-859.9972443,76.9802581,597.7862561,-149.1946951,5.684608619,41.52584745}, /*cmy*/
          {1.165825707,8.683475092,1624.007231,0.2237789544}, /*cfy*/
          {1299.511211,-82.38930196,-704.0685895,264.809132,-10.62524,-125.1867479}, /*cmz*/
          {-0.1162077062,1.94454445,2.334931601,-0.1506440052} /*cfz*/
     },
     {
          2464673.5,
          {2060.331108,-144.1633568,3288.762527,-327.1512874,12.48590429,29.59017963}, /*cmx*/
          {-1.560348599,-7.21977013,5.821036309,4.155971187}, /*cfx*/
          {-690.4342938,77.13626673,-716.0929922,127.7273357,-5.564422283,-3.215348045}, /*cmy*/
          {5.56396354,-0.2126300076,0.4387485501,3.599033929}, /*cfy*/
          {3388.016891,-346.0312159,-3663.377287,582.5923375,24.21858391,21.87377654}, /*cmz*/
          {27.30630848,-3.494413113,-125.3787271,3.82290357} /*cfz*/
     },
     {
          2464689.5,
          {3642.978361,-360.3146473,3707.52153,600.2814,-25.39023901,135.4243816}, /*cmx*/
          {4.555334317,-3.426860422,3.494448746,3.153681792}, /*cfx*/
          {1348.213891,-125.4992667,1015.456457,222.4212254,8.541295395,-29.48046485}, /*cmy*/
          {4.557113072,2.538384671,6.279492901,-44.78023965}, /*cfy*/
          {-3728.982608,339.3809852,2446.438629,-629.2385066,-23.62404794,84.81735242}, /*cmz*/
          {1.420261904,2.429952486,-0.1447101912,-13.79397388} /*cfz*/
     },
     {
          2464705.5,
          {-4846.849822,470.1562358,6541.540145,-846.1899227,32.43769686,204.992586}, /*cmx*/
          {1.647604137,8.771311477,3.078310945,-0.4064504547}, /*cfx*/
          {691.2276676,-78.96881254,-728.9867911,-130.5870482,-5.912430937,-53.0153896}, /*cmy*/
          {2.542388133,106.7384748,-84.23710292,-5.194292261}, /*cfy*/
          {-4148.734486,445.8764895,4428.453902,733.0369443,-30.89601452,-208.04676}, /*cmz*/
          {2.135408787,-0.2918941726,-1023.792192,-14.96486448} /*cfz*/
     },
     {
          2464721.5,
          {-4108.086522,464.6590093,-4750.578457,-751.4181795,-31.89941557,-150.0014719}, /*cmx*/
          {4.637395817,2.860095659,0.3778575795,-1.736597778}, /*cfx*/
          {-1529.176516,146.7963043,1215.240406,-258.9509333,10.09970291,-56.66276633}, /*cmy*/
          {1.442982236,2.577024258,-3.104291024,3.622980135}, /*cfy*/
          {3854.072741,-346.2012767,-2515.507262,-643.7127597,-24.67305344,-168.5096161}, /*cmz*/
          {1.40687909,5.612423611,9.318851031,-6.038755822} /*cfz*/
     },
     {
          2464737.5,
          {3467.966833,-295.938148,-4628.582225,-543.4307644,-21.12515527,-48.73318881}, /*cmx*/
          {-35.98819257,5.638834586,9.360717605,0.9790638883}, /*cfx*/
          {-346.6241417,46.73805918,-543.5819596,80.41072959,-3.878109779,-3.692091589}, /*cmy*/
          {6.181266646,0.1351279327,0.7835998099,0.496027845}, /*cfy*/
          {2319.310704,-254.7451318,2676.439506,420.8454338,18.42155425,-6.945381987}, /*cmz*/
          {5.58801446,-3.315681354,-12.07947694,14.24992873} /*cfz*/
     },
     {
          2464753.5,
          {962.9563463,-108.3696206,-1387.430318,225.8087996,11.11147311,-94.45098431}, /*cmx*/
          {-5.164963505,3.531836686,0.929147033,6.599819578}, /*cfx*/
          {1508.148418,-146.7263508,1164.389044,252.124255,-9.985433222,-35.35185093}, /*cmy*/
          {4.604086444,2.654330343,3.273704244,12.09891467}, /*cfy*/
          {-4649.209797,447.5744837,-3396.048916,783.651491,-30.46100983,97.03505828}, /*cmz*/
          {4.65183698,-0.5591142621,0.04563275083,-6.973289419} /*cfz*/
     },
     {
          2464769.5,
          {-6292.586771,637.4111531,7909.412192,1089.343634,43.04061276,-235.9663856}, /*cmx*/
          {1.740980493,-0.5167923034,3.249803526,3.134925346}, /*cfx*/
          {-436.9686077,29.85320964,939.853141,-92.01522852,3.612470391,-49.5889573}, /*cmy*/
          {-5.264888549,1.901768276,2.296434077,1.790676539}, /*cfy*/
          {-643.940002,111.6415065,2033.384594,-237.7273558,11.96187823,160.3430107}, /*cmz*/
          {3.155192052,3.598359566,4.162878024,1.304469245} /*cfz*/
     },
     {
          2464785.5,
          {-1112.489221,180.6080531,2057.563422,-309.0605032,-15.12843193,-134.1302185}, /*cmx*/
          {1.368048117,3.34380107,0.8367002956,-1.032525486}, /*cfx*/
          {-1921.519458,193.3094136,1609.328576,-325.032498,13.08660803,-65.27230476}, /*cmy*/
          {-4.759471966,2.695450566,3.329518874,3.918739336}, /*cfy*/
          {5755.166371,-556.1874551,-4454.056616,-955.6863552,37.81570185,202.1299372}, /*cmz*/
          {1.546307578,-0.5108724161,0.1081208909,3.703677412} /*cfz*/
     },
     {
          2464801.5,
          {4328.697639,-400.2019867,5426.183535,-689.876302,27.65320212,-60.67336233}, /*cmx*/
          {4.95142836,-0.4862213889,12.69968014,1.085496524}, /*cfx*/
          {270.9943194,-13.78377701,763.9099612,62.58882619,-2.644488615,-13.90881976}, /*cmy*/
          {-2.173368154,1.767255044,2.139306613,0.6542435071}, /*cfy*/
          {585.565036,-90.61754118,1830.717723,188.2468186,-9.655549132,27.64759039}, /*cmz*/
          {6.418560947,3.634736328,4.208265533,0.3230561991} /*cfz*/
     },
     {
          2464817.5,
          {-1648.604701,148.3443544,1392.975008,-341.8925015,-12.64307823,51.76113526}, /*cmx*/
          {2.187222006,2.128847565,5.73674149,4.041633456}, /*cfx*/
          {1093.681851,-112.9447272,-789.2659807,189.1398885,7.898284514,-31.72648083}, /*cmy*/
          {1.419083578,2.813818356,0.3067699859,6.057609122}, /*cfy*/
          {-4110.377929,417.1997128,-2932.099802,708.2283029,-28.61860209,95.88752365}, /*cmz*/
          {4.674400048,-0.4314692638,0.1965506247,5.89249675} /*cfz*/
     },
     {
          2464833.5,
          {-5536.410151,587.6908833,7127.040784,-980.3051906,-39.89328628,-228.9786552}, /*cmx*/
          {-312.3305824,2.734810845,6.518212886,-2.86609147}, /*cfx*/
          {-1433.64578,131.1309325,1834.201138,-240.0402573,-9.118093609,-54.55747228}, /*cmy*/
          {-86.54048682,2.453880941,6.176401904,2.465274743}, /*cfy*/
          {2790.965061,-226.8196792,-3891.597512,472.0908859,-17.5390873,149.7053758}, /*cmz*/
          {1.17182146,8.536013149,2.761449621,2.005328358} /*cfz*/
     },
     {
          2464849.5,
          {1958.451682,-123.4738116,1141.101053,330.265244,12.82885688,-160.2996878}, /*cmx*/
          {-7.194079414,2.046502731,5.613636429,-0.4325095194}, /*cfx*/
          {-1538.103209,161.0815104,-1266.566607,263.0159463,10.9609044,-56.91610002}, /*cmy*/
          {-7.889586236,-0.3397964518,3.456792562,-2.052255777}, /*cfy*/
          {6103.302078,-609.1224494,4814.526519,1016.470554,-41.19795272,210.2047539}, /*cmz*/
          {4.736049805,2.717064343,3.359440142,3.940701416} /*cfz*/
     },
     {
          2464865.5,
          {4455.351987,-429.5615084,-5550.010215,720.0783963,29.58788898,-65.47453827}, /*cmx*/
          {1.868970492,2.755821413,6.534949473,-5.013410946}, /*cfx*/
          {737.4105783,-63.7160887,-1125.052122,-126.2950287,4.822414833,-21.00015763}, /*cmy*/
          {1.327821915,-69.88530497,-0.2286415846,0.7447421871}, /*cfy*/
          {-997.5197569,68.69102669,-2484.892288,-229.9578413,9.289788186,57.73049299}, /*cmz*/
          {4.037609866,1.930138233,2.314260353,0.5002557381} /*cfz*/
     },
     {
          2464881.5,
          {-3079.088342,295.4389676,-2698.801856,559.220547,21.14866871,37.17114665}, /*cmx*/
          {-1.165861951,5.548135508,9.246335242,4.850102358}, /*cfx*/
          {467.3087256,-55.07534429,-252.3013771,93.88577143,-4.326837616,-20.87472978}, /*cmy*/
          {7.317511991,-3.158426133,3.744598215,6.224592624}, /*cfy*/
          {-2971.716179,323.8008453,1830.768611,-540.7152264,-22.88095905,80.94537339}, /*cmz*/
          {7.817576671,2.85032302,0.3508186228,6.043066926} /*cfz*/
     },
     {
          2464897.5,
          {-3931.17731,444.7003465,-5581.997956,-733.4517559,30.962721,204.5634781}, /*cmx*/
          {-1.220499794,2.86080274,3.51149183,-5.79910131}, /*cfx*/
          {-1672.936588,159.6172557,-2001.592013,278.2606225,-10.83510563,-54.4254965}, /*cmy*/
          {-1.61697848,-0.5691696285,0.04600501241,2.816844768}, /*cfy*/
          {4997.777967,-448.2454425,-5874.761451,816.5848586,-30.98964525,169.6114055}, /*cmz*/
          {1.378296545,2.470682223,-3.228405158,2.436954936} /*cfz*/
     },
     {
          2464913.5,
          {4087.195918,-339.7064952,-3181.802873,647.4599809,24.62635357,196.2798024}, /*cmx*/
          {27.03222926,2.398128679,6.091312175,2.989386667}, /*cfx*/
          {-882.9541687,97.44321278,660.7649334,-156.1678338,6.844732325,43.53158101}, /*cmy*/
          {39.19284198,-3.334275277,-8.95033363,1.419439294}, /*cfy*/
          {5698.412379,-579.4241572,-4339.12625,-951.706358,39.38080402,-209.3569232}, /*cmz*/
          {7.915052167,-0.3578219064,0.2976740641,0.9789881721} /*cfz*/
     },
     {
          2464929.5,
          {4353.491656,-431.1311635,5496.463539,-712.7019059,-29.80853407,69.81442976}, /*cmx*/
          {-7.530757561,-0.3206098495,3.468033711,123.9575783}, /*cfx*/
          {879.4821591,-82.11150696,-1191.065956,149.2680509,-5.79656624,22.3530422}, /*cmy*/
          {1.447951081,2.519337341,-3.172075475,3.955684326}, /*cfy*/
          {-2107.460191,184.7594974,-3379.362974,-396.2878675,-15.08652464,-82.57631965}, /*cmz*/
          {4.284732933,2.291067843,5.929519958,3.701660028} /*cfz*/
     },
     {
          2464945.5,
          {-3686.25313,359.8300911,3351.694788,657.4492373,-25.31232775,-37.3941762}, /*cmx*/
          {-16.88793213,5.631316466,-0.0749693703,2.21232077}, /*cfx*/
          {63.26229643,-15.56642377,-179.4607949,-43.27729123,2.190045845,-11.75485199}, /*cmy*/
          {5.510097848,0.706372101,1.158117534,0.07070693095}, /*cfy*/
          {-2093.625238,250.1310666,942.3755471,418.7948765,-18.61288354,66.60319938}, /*cmz*/
          {14.12443059,-0.1425445704,-5.782967769,-0.1664539456} /*cfz*/
     },
     {
          2464961.5,
          {-2745.223012,334.5341939,4481.452776,-555.3054246,24.40218244,187.3113583}, /*cmx*/
          {-23.13512662,2.997780685,3.647449112,6.898976606}, /*cfx*/
          {-1452.852293,141.2629973,-1707.844389,-241.8489699,9.560401526,-46.72303073}, /*cmy*/
          {10.99045816,2.630631588,3.258334101,2.988850732}, /*cfy*/
          {6143.438624,-563.3048712,6874.726186,998.7069822,-38.41226483,186.960841}, /*cmz*/
          {4.575081648,2.533603218,-3.14729048,2.619401682} /*cfz*/
     },
     {
          2464977.5,
          {5269.12517,-461.2357388,4443.070659,-839.2053747,-32.20002552,222.0247483}, /*cmx*/
          {-1.282025649,-0.6652949228,9.338782732,3.092662143}, /*cfx*/
          {-442.4182075,52.82921139,268.5185734,-86.16391089,4.03621534,34.2069031}, /*cmy*/
          {7.649272234,3.162251076,3.820378809,1.67850885}, /*cfy*/
          {5365.948161,-550.7343183,3906.952911,-897.3542048,37.68656513,-212.0010753}, /*cmz*/
          {-1.468949605,5.971925752,0.35025656,-49.18417726} /*cfz*/
     },
     {
          2464993.5,
          {4369.539184,-439.6457935,5566.67048,-722.6133843,30.508594,-75.9055151}, /*cmx*/
          {-1.24986405,-0.2901737925,0.3616649274,20.35943659}, /*cfx*/
          {851.8298566,-81.74520315,-1102.616713,-145.0627375,5.693347917,21.17745913}, /*cmy*/
          {1.499287595,-0.563268695,0.0402163792,3.9842519}, /*cfy*/
          {-2707.709547,248.5296036,-3899.227584,498.6225439,19.02673476,-98.77747727}, /*cmz*/
          {4.354409912,24.36844915,-15.94303129,-2.57167966} /*cfz*/
     },
     {
          2465009.5,
          {-3977.426996,389.5642994,3717.111064,705.6545523,-27.33012091,38.98487284}, /*cmx*/
          {-10.60735255,5.659740748,6.242693891,5.5690298}, /*cfx*/
          {-84.83703086,-0.2927933337,-260.8768629,36.43543596,-1.67293816,-7.182868339}, /*cmy*/
          {5.176221671,4.47466462,4.812932215,0.1476467344}, /*cfy*/
          {-1690.272542,217.6602233,518.1168842,-370.5845457,-16.95541313,59.37913081}, /*cmz*/
          {1.69809322,3.099055432,-5.691970529,-0.1385399249} /*cfz*/
     },
     {
          2465025.5,
          {-2287.819251,292.2473419,-4070.454924,-491.1258599,-22.1525012,-183.2233257}, /*cmx*/
          {-13.67910667,-3.200728271,0.5853726154,-2.47267193}, /*cfx*/
          {-1288.246206,126.052218,-1502.124488,-214.5339182,8.521497531,-41.54133049}, /*cmy*/
          {11.00597459,8.939437448,3.285160023,3.043739149}, /*cfy*/
          {6706.580129,-618.4151651,-7330.002648,-1086.749036,-42.0388535,197.2920257}, /*cmz*/
          {-11.117237,-0.5882158463,-3.122939854,2.679281657} /*cfz*/
     },
     {
          2465041.5,
          {5915.212414,-526.6993404,5153.539063,-948.0728808,-36.46579243,-238.848266}, /*cmx*/
          {-1.29748633,-6.923839212,15.65542352,-0.01194443159}, /*cfx*/
          {-352.2494352,43.5937475,189.4827961,73.88999255,-3.520923219,32.81767681}, /*cmy*/
          {7.641570938,0.1104534732,0.7624955195,1.736657138}, /*cfy*/
          {5288.569622,-545.3999005,-3771.324787,-886.1176004,-37.47479716,217.359778}, /*cmz*/
          {-4.579131008,-0.2856991815,-9.047822335,60.81544949} /*cfz*/
     },
     {
          2465057.5,
          {4448.924162,-450.8882299,-5670.187151,-738.4910236,31.34971393,-79.88291822}, /*cmx*/
          {-10.67710899,-6.561623352,0.3771876797,32.95450346}, /*cfx*/
          {904.5973551,-87.2600697,1143.319064,-154.8767988,6.093268549,23.11666828}, /*cmy*/
          {-1.629343845,-0.5469916748,6.331905736,3.957332695}, /*cfy*/
          {-3008.4995,279.6829702,4163.128749,549.6103806,-21.07268977,107.0684222}, /*cmz*/
          {1.240374194,11.83051908,-6.479866414,0.5736003997} /*cfz*/
     },
     {
          2465073.5,
          {-4202.060459,412.6822004,3954.736342,744.9187587,-28.87009002,41.84892244}, /*cmx*/
          {-23.1832503,-0.6112323239,6.258933961,5.655008824}, /*cfx*/
          {-94.12220919,-0.3056436722,272.5446406,38.41801611,-1.794989686,-6.929951877}, /*cmy*/
          {1.992142204,4.460552547,4.826403317,0.1169862933}, /*cfy*/
          {-1540.708932,205.6321821,-375.9045029,-356.3278964,16.46193582,-58.22353139}, /*cmz*/
          {4.970131864,3.149245696,-2.509228742,3.021368067} /*cfz*/
     },
     {
          2465089.5,
          {-2082.009807,274.7456716,3893.47751,465.3860852,-21.33363863,183.905626}, /*cmx*/
          {-10.50854901,6.272019982,6.912800353,-5.578106585}, /*cfx*/
          {-1470.449651,143.3010629,-1696.239708,244.2850714,9.683243809,46.74857527}, /*cmy*/
          {11.00191959,5.795368,3.278575612,12.44581119}, /*cfy*/
          {6990.882139,-647.2048762,-7598.509813,-1132.024769,43.92598985,-204.3197721}, /*cmz*/
          {-11.10597152,-0.5799362229,0.02842163085,5.851865365} /*cfz*/
     },
     {
          2465105.5,
          {6327.72725,-567.8884054,-5527.577538,1016.472165,39.17027627,248.9110672}, /*cmx*/
          {-4.448790117,2.515837224,6.250261775,3.164779942}, /*cfx*/
          {-471.3744823,56.88382625,-268.2006793,95.88478387,4.488359006,-39.5986621}, /*cmy*/
          {10.9055069,6.344051345,3.860689722,-1.453623438}, /*cfy*/
          {5145.817774,-534.0082674,-3645.925923,-866.549101,36.83835147,217.2545503}, /*cmz*/
          {-4.574742785,-0.2675243496,0.3955547509,745.7211076} /*cfz*/
     },
     {
          2465121.5,
          {4446.220288,-451.3053609,5653.308271,738.2651792,31.42016538,-79.43778178}, /*cmx*/
          {111.8579201,-3.411156837,0.3870278892,20.40543271}, /*cfx*/
          {1066.066759,-102.6222861,-1345.264613,-183.0031134,-7.195887001,-27.71649792}, /*cmy*/
          {-36.19711495,5.728923263,3.180025864,0.7950504993}, /*cfy*/
          {-3131.000923,291.515825,4289.341771,568.6445561,21.8193018,108.3021445}, /*cmz*/
          {1.262593574,150.0720438,2.96073103,0.5810932482} /*cfz*/
     },
     {
          2465137.5,
          {-4306.083016,424.3160805,4018.754868,-764.0110605,-29.67713012,44.73038667}, /*cmx*/
          {-23.189531,2.537793568,6.267038663,-0.5988210161}, /*cfx*/
          {-72.34337045,-4.348707704,-288.6595464,44.67171095,2.144728609,9.120016571}, /*cmy*/
          {-1.142197621,4.30566061,1.541874064,3.261293738}, /*cfy*/
          {-1499.704041,201.7600044,-351.4920641,-351.4155386,-16.35060803,-59.01423515}, /*cmz*/
          {4.917635784,3.168125978,0.6483192476,3.054491346} /*cfz*/
     },
     {
          2465153.5,
          {-2018.171045,269.2550731,3839.091056,-458.1808542,-21.02543842,-183.2117289}, /*cmx*/
          {-10.49234722,3.143661938,6.92430327,-2.42376973}, /*cfx*/
          {-1711.69704,166.3461545,-1966.840324,-283.9811329,-11.25476552,54.01943424}, /*cmy*/
          {10.99514476,2.646579464,6.414141421,-0.1322410238}, /*cfy*/
          {6970.780337,-646.1160236,-7602.575876,-1130.492725,-43.84994563,-203.9342496}, /*cmz*/
          {-17.38529097,-0.5787530023,3.172171417,5.859297437} /*cfz*/
     },
     {
          2465169.5,
          {6285.579895,-563.7674067,-5465.094623,-1007.338152,38.86541289,-247.1084025}, /*cmx*/
          {-4.448763161,-0.6262036727,6.24895062,0.02208487216}, /*cfx*/
          {-525.4446503,62.8972511,290.4410822,-104.7403408,-4.924111614,-43.10529939}, /*cmy*/
          {1.46977043,3.195427167,6.99264803,-1.462697558}, /*cfy*/
          {5136.108918,-532.4404066,3654.30035,-864.1047395,-36.74156543,-215.6390779}, /*cmz*/
          {-7.721793598,-0.2719255879,-2.749348479,38.85692258} /*cfz*/
     },
     {
          2465185.5,
          {4535.725551,-459.2444542,-5737.981756,-754.2077453,31.93752766,-80.9634723}, /*cmx*/
          {-10.67128288,-0.2770107725,0.3752067871,14.07436768}, /*cfx*/
          {1073.735233,-103.2510076,-1372.089776,184.8355193,-7.24088324,-27.85038368}, /*cmy*/
          {-4.798070212,-16.27758139,3.168973967,0.7893481852}, /*cfy*/
          {-2969.054413,274.8110069,-4140.292172,546.0390008,-20.8320442,-105.4742182}, /*cmz*/
          {-1.899757142,11.81974774,-6.494045835,3.695218552} /*cfz*/
     },
     {
          2465201.5,
          {-4193.127272,411.0527201,-3945.416566,742.4325784,-28.84750133,-42.189856}, /*cmx*/
          {-26.32627737,5.6704365,6.253836344,2.518224128}, /*cfx*/
          {-49.92908504,-6.705749412,-276.1720024,-44.64086628,2.166514071,9.805803242}, /*cmy*/
          {-1.146113697,-5.19589648,1.455037914,3.284426622}, /*cfy*/
          {-1672.041767,218.9769992,515.035138,-374.6007103,17.292554,60.088971}, /*cmz*/
          {1.809631893,3.119096713,-2.533501904,-0.08339842452} /*cfz*/
     },
     {
          2465217.5,
          {-2230.958665,286.8204199,4019.867607,-485.0906458,21.92861467,182.6849314}, /*cmx*/
          {-10.53772529,78.49778106,-52.80680646,6.95615638}, /*cfx*/
          {-1599.737072,155.2472768,1834.495007,265.0343022,-10.51921614,50.3636456}, /*cmy*/
          {7.845753386,-0.4972007427,6.414944602,-0.1300312055}, /*cfy*/
          {6781.410883,-624.7072306,7351.087158,-1098.233693,42.46654765,197.0516681}, /*cmz*/
          {36.00656387,-0.5872311872,0.02063111536,2.681571322} /*cfz*/
     },
     {
          2465233.5,
          {6063.376822,-543.4575273,-5364.82713,-972.3019861,37.49767697,241.9045302}, /*cmx*/
          {-4.440104005,-0.6330849487,-6.326969357,3.132591323}, /*cfx*/
          {-384.753364,47.35861801,162.733305,-79.90163374,3.873102354,37.48177203}, /*cmy*/
          {13.90285926,3.289871502,3.927308338,1.737457912}, /*cfy*/
          {5224.34541,-537.8298909,-3683.549604,-873.427224,-37.06318516,-217.314737}, /*cmz*/
          {-4.560737726,-0.2816839677,3.52422113,51.39117211} /*cfz*/
     },
     {
          2465249.5,
          {4585.514156,-465.70774,-5831.511401,-765.9780157,32.31139702,84.99817546}, /*cmx*/
          {-35.83050505,-0.2848737997,0.3660796663,23.47675665}, /*cfx*/
          {927.462045,-90.15251037,-1183.456413,159.6287111,-6.27396914,23.78103066}, /*cmy*/
          {-4.79813151,2.582018707,3.191181495,3.964071045}, /*cfy*/
          {-2906.384187,270.5824582,4036.596603,-540.8117101,20.58421081,-108.0938968}, /*cmz*/
          {1.211998971,14.95219009,9.202919069,3.671404303} /*cfz*/
     },
     {
          2465265.5,
          {-4052.076589,394.0761535,3925.39435,713.6192093,27.7039931,36.51687631}, /*cmx*/
          {-16.88738265,5.665716632,9.389310492,-0.615905785}, /*cfx*/
          {-107.0800431,0.9042135468,-293.6530257,-38.16611852,1.685904333,-7.050177302}, /*cmy*/
          {-1.221671061,1.38841882,1.701461583,0.1607568402}, /*cfy*/
          {-1687.064704,222.6510246,-526.6748036,378.5568934,-17.40625958,56.63228737}, /*cmz*/
          {5.169976444,-0.03627960303,0.5974388866,-0.1143427711} /*cfz*/
     },
     {
          2465281.5,
          {-1959.957337,256.0067507,-3730.085238,-439.1622288,20.09147172,-173.3868262}, /*cmx*/
          {-19.97590688,9.427733975,3.780989134,-2.470190013}, /*cfx*/
          {-1193.916959,116.8825492,1373.466231,-197.8272792,-7.936646033,-38.64290856}, /*cmy*/
          {7.854384335,8.953636305,0.164327375,3.083662631}, /*cfy*/
          {6764.900328,-622.2198221,7193.817668,1091.423903,-42.27914566,192.6905152}, /*cmz*/
          {-7.984481491,2.561108346,3.170306463,2.68513536} /*cfz*/
     },
     {
          2465297.5,
          {6402.570265,-585.013456,-5885.33701,-1034.332097,40.05817107,-248.2765118}, /*cmx*/
          {-4.435361458,-0.6065751027,6.274265071,0.02661783481}, /*cfx*/
          {3.120742778,6.64926803,-182.8553461,35.96329391,1.78000603,-27.57366588}, /*cmy*/
          {-4.33496266,1.12253915,4.648238851,5.204764148}, /*cfy*/
          {4640.97465,-480.3418645,-3031.944087,778.1274818,-33.46455381,211.7343742}, /*cmz*/
          {-23.34816197,-3.380659723,-2.714428361,-1.951040574} /*cfz*/
     },
     {
          2465313.5,
          {4178.365084,-433.6066179,-5496.748791,-707.2119517,30.19411094,-85.74761756}, /*cmx*/
          {-104.9482456,18.60112604,0.4100047969,-67.47949734}, /*cfx*/
          {744.3986426,-74.50476345,932.9717651,-127.2949712,-5.100239486,-18.16210719}, /*cmy*/
          {4.681707489,5.791897801,3.283775521,0.9649608342}, /*cfy*/
          {-3548.114797,341.4360663,-4530.856132,644.646706,-24.76848066,124.6911721}, /*cmz*/
          {-8.152277751,-0.6779184039,6.168981127,0.582422518} /*cfz*/
     },
     {
          2465329.5,
          {-4113.209772,402.0809253,-4082.710705,718.6084191,-28.09354825,-33.44940512}, /*cmx*/
          {-13.72418393,5.703800171,6.297458125,-3.556845783}, /*cfx*/
          {-247.759138,17.95787209,367.3362823,44.93548092,1.636400818,2.338027642}, /*cmy*/
          {1.874488195,5.2245645,2.526488393,3.447256867}, /*cfy*/
          {-1063.689777,166.0837664,324.3516695,-296.508537,14.17918834,-43.74502732}, /*cmz*/
          {-2.593185818,3.280560814,3.892985616,2.974745582} /*cfz*/
     },
     {
          2465345.5,
          {-460.9556121,106.6622891,-2322.217937,-253.517386,12.67301089,146.7806451}, /*cmx*/
          {-7.212142978,3.681400837,4.204690644,0.8433631649}, /*cfx*/
          {-659.1442068,66.89587386,-795.8961716,110.9967187,4.604011582,24.99938543}, /*cmy*/
          {-1.520761158,5.910600895,3.417197651,-6.132679462}, /*cfy*/
          {6933.005107,-646.858663,7233.583376,1117.867283,43.83953633,-195.1609882}, /*cmz*/
          {17.17037457,-9.961047234,0.08118022077,5.944293938} /*cfz*/
     },
     {
          2465361.5,
          {7387.958769,-700.2103445,6983.999361,-1207.342885,47.38877307,269.3297496}, /*cmx*/
          {-7.56931607,-0.5400393825,0.07738164226,3.322379735}, /*cfx*/
          {413.2850257,-36.50096942,513.2062981,72.9429482,2.722958755,22.98709068}, /*cmy*/
          {-1.333166391,8.631673288,-6.53845715,2.679153672}, /*cfy*/
          {2592.919799,-283.5046196,-1031.722069,469.477341,21.72655838,-192.6691941}, /*cmz*/
          {2.134278231,-3.133915853,6.947801583,1.486364938} /*cfz*/
     },
     {
          2465377.5,
          {2676.286076,-297.6299706,4095.598714,480.5243674,21.80592108,84.62674083}, /*cmx*/
          {-13.75685337,9.356465746,6.884720873,-0.9945302047}, /*cfx*/
          {531.6447585,-55.6200333,675.7952035,-91.44487962,3.78423536,12.76304248}, /*cmy*/
          {4.778981233,-0.3720153185,0.284220023,-1.865865041}, /*cfy*/
          {-4944.038454,495.7452101,5782.276218,-871.4405661,-34.29689298,-153.2024562}, /*cmz*/
          {-4.879289421,15.15595082,6.335953765,3.874308555} /*cfz*/
     },
     {
          2465393.5,
          {-4187.44689,421.331814,4162.862447,-731.7077268,29.19136543,-33.45529125}, /*cmx*/
          {-10.53000693,2.652866719,15.83714669,3.038177405}, /*cfx*/
          {-347.0076717,30.59762812,-413.7394449,58.01586599,-2.202645156,1.245349907}, /*cmy*/
          {-1.234121068,11.86372343,12.42881032,0.1505842839}, /*cfy*/
          {394.1087323,26.6932969,1594.606702,183.1479756,8.857764608,-22.27455411}, /*cmz*/
          {-7.911109482,1.103692672,4.646135136,8.954896514} /*cfz*/
     },
     {
          2465409.5,
          {2398.247403,-177.6815728,-1534.795913,414.2772212,-15.33114628,114.274152}, /*cmx*/
          {-5.534419571,20.95862935,2.564515564,1.388185187}, /*cfx*/
          {-215.9299524,24.70236664,341.0388066,-42.01999292,1.921441583,15.1882684}, /*cmy*/
          {1.733906261,3.119423346,3.754791443,75.87532443}, /*cfy*/
          {6373.535682,-611.8602593,-6676.352487,-1034.426896,-41.6662711,193.3477795}, /*cmz*/
          {-17.34849467,5.836430582,3.32486166,9.299690916} /*cfz*/
     },
     {
          2465425.5,
          {7674.37116,-757.2924782,-7242.076644,1272.497791,-51.12321396,281.207017}, /*cmx*/
          {8.185997478,2.693989334,3.333237597,3.584662649}, /*cfx*/
          {652.4377774,-62.42001274,717.3426169,-109.6197565,4.256592398,25.43379434}, /*cmy*/
          {4.957249362,-0.594328201,0.009238864774,3.077619166}, /*cfy*/
          {-1358.391437,104.502836,-3013.446721,338.9604423,13.38500308,188.4283549}, /*cmz*/
          {-20.42387183,5.032016885,2.288524912,5.284888608} /*cfz*/
     },
     {
          2465441.5,
          {-560.2908568,17.8813868,1427.840887,-221.3829256,10.1794005,116.6114151}, /*cmx*/
          {-0.3848010314,1.57004363,1.915955718,-0.17071737}, /*cfx*/
          {407.0858167,-45.55092939,554.8206256,73.45300836,3.166718994,12.22801117}, /*cmy*/
          {11.14131794,-3.357006465,0.445169609,-26.59833552}, /*cfy*/
          {-5877.40821,615.4547038,6759.633725,1029.245507,41.8084405,168.7684132}, /*cmz*/
          {-11.05289304,5.853121993,3.348257892,0.9934871063} /*cfz*/
     },
     {
          2465457.5,
          {-3556.276574,380.859889,3484.613593,641.0236088,-26.57865983,-26.2223544}, /*cmx*/
          {2.190910252,-0.3421149139,0.3037543937,3.246125288}, /*cfx*/
          {-464.2301712,43.12754522,-524.1395413,-76.1504845,-3.037288959,3.601522453}, /*cmy*/
          {-38.9005662,2.588954962,6.331654329,-5.643743761}, /*cfy*/
          {2455.505404,-181.2636204,-3548.541592,389.6074523,-14.75581264,21.41547516}, /*cmz*/
          {-4.580406583,2.240433315,2.747533145,4.322602135} /*cfz*/
     },
     {
          2465473.5,
          {5351.560206,-482.1602356,-4164.925577,-874.3360035,33.21966787,122.190194}, /*cmx*/
          {32.79834399,-0.6603210841,6.203852736,-4.062750498}, /*cfx*/
          {60.57960801,-1.820989528,92.59541803,27.26892533,1.166958612,-12.730561}, /*cmy*/
          {14.66218786,1.412255597,4.907865151,3.970759588}, /*cfy*/
          {3829.576386,-386.7134617,-4318.988976,-642.3578106,27.63289727,-160.3786504}, /*cmz*/
          {1.523427376,-0.239481413,0.4013574594,6.450095345} /*cfz*/
     },
     {
          2465489.5,
          {5286.947894,-551.1413444,-4801.788531,905.2525442,-38.12652647,-245.2629072}, /*cmx*/
          {2.091344211,2.852480032,3.512156968,7.116966246}, /*cfx*/
          {983.7427832,-97.69521873,-1070.834106,165.8238589,-6.580685829,-36.17395183}, /*cmy*/
          {-10.73200214,8.91416147,3.257805936,0.1590437426}, /*cfy*/
          {-5647.820184,542.8939363,-7151.475515,981.4070592,-37.55286915,-238.4189094}, /*cmz*/
          {4.849246168,5.624337892,-0.06966355655,2.810143249} /*cfz*/
     },
     {
          2465505.5,
          {-4237.309567,395.5889693,3403.00563,734.1571584,-28.26622781,-178.8522972}, /*cmx*/
          {1.292040556,5.617729157,6.18393897,3.472725502}, /*cfx*/
          {196.221791,-28.20078986,-398.6933021,-47.99413825,2.339795531,-16.36976017}, /*cmy*/
          {14.36181026,0.2023686402,0.8346940888,2.289844743}, /*cfy*/
          {-4647.258594,520.574539,5737.369669,841.7589292,35.6834916,148.9327411}, /*cmz*/
          {7.859190387,-0.2884977291,3.51500273,1.423064575} /*cfz*/
     },
     {
          2465521.5,
          {-1997.97646,245.3889483,-2144.742496,410.3560278,18.46871109,5.86874988}, /*cmx*/
          {5.792555008,6.209421833,3.725116716,0.02110044592}, /*cfx*/
          {-633.9942026,61.2079321,708.3886223,-104.360868,-4.239796955,5.44997464}, /*cmy*/
          {360.1325179,2.693854203,6.464924763,0.8431001715}, /*cfy*/
          {4042.293733,-353.2430517,-5005.882114,641.5978391,24.99168973,42.61672078}, /*cmz*/
          {-4.476829264,8.807313498,6.25451886,4.017497493} /*cfz*/
     },
     {
          2465537.5,
          {6244.331005,-593.7759432,5139.539416,1028.846188,40.50521508,142.5326917}, /*cmx*/
          {4.616794819,2.614357988,0.08656298093,-9.890867846}, /*cfx*/
          {463.9454499,-41.24048582,287.5373372,-82.88924388,-3.064749837,12.18612572}, /*cmy*/
          {-1.632566472,5.432226372,9.097790123,1.546084615}, /*cfy*/
          {397.5086172,-61.76889016,-1117.359462,-222.5452446,-11.05318213,-105.920102}, /*cmz*/
          {1.387338866,0.8317246816,4.409208746,0.5753810524} /*cfz*/
     },
     {
          2465553.5,
          {1646.633346,-205.8055458,-2034.064175,-369.5911817,-17.90641158,198.5869281}, /*cmx*/
          {2.97567152,0.2081688752,3.96938535,-1.822571556}, /*cfx*/
          {1042.839483,-107.7493717,-1144.230204,-179.7300813,-7.287591888,40.81677361}, /*cmy*/
          {14.47477523,5.866679016,3.369188271,9.841052061}, /*cfy*/
          {-7516.31856,751.7046034,-8900.904614,1292.351118,-50.75541461,-276.0209586}, /*cmz*/
          {-1.37265409,5.74899781,0.08610685173,3.150053193} /*cfz*/
     },
     {
          2465569.5,
          {-6161.576833,602.4761517,5330.814294,-1048.154271,41.24877522,213.8813558}, /*cmx*/
          {1.458356832,2.598790546,9.49437884,0.5457650198}, /*cfx*/
          {-238.2982491,14.53174794,58.24510078,44.8636871,1.805289767,21.28234007}, /*cmy*/
          {0.3296476499,5.109332661,2.356850638,-0.2361779025}, /*cfy*/
          {-2558.03724,327.315804,3798.877006,528.1276196,23.91038698,135.1983019}, /*cmz*/
          {7.882541283,12.49400785,10.02377003,-4.381632388} /*cfz*/
     },
     {
          2465585.5,
          {-773.2527037,130.0243417,-1742.670784,250.893976,-12.66530451,13.49741735}, /*cmx*/
          {6.476404042,0.3784688281,0.9665454312,3.4568435}, /*cfx*/
          {-558.9929332,55.93302562,628.3619033,94.15877699,-3.886002618,-4.356555152}, /*cmy*/
          {2.094287006,-0.346591976,-112.8005569,-46.12145502}, /*cfy*/
          {4662.176107,-426.3286857,5557.180382,747.9402339,-29.77059896,55.00999381}, /*cmz*/
          {-1.285372217,2.627682264,3.234097062,4.037392704} /*cfz*/
     },
     {
          2465601.5,
          {5811.236638,-568.7841571,4749.004752,970.0304498,-39.07587902,-140.3940823}, /*cmx*/
          {4.64094123,2.683173239,3.310785475,5.985919485}, /*cfx*/
          {645.6496675,-60.84906685,478.5181582,-110.9860286,4.230112611,12.48890645}, /*cmy*/
          {4.738133779,5.619041761,-0.09294958945,-10.38359963}, /*cfy*/
          {-1528.772168,127.61273,835.9060834,-347.6573116,13.25717538,-76.60617505}, /*cmz*/
          {-4.283648165,1.965590148,2.379599915,0.9785500971} /*cfz*/
     },
     {
          2465617.5,
          {-339.9682993,-14.87041465,-2431.985764,-250.9043025,11.78920243,-185.6945757}, /*cmx*/
          {3.882146067,1.266404419,1.629558155,1.606676308}, /*cfx*/
          {637.5462403,-69.27827445,-722.2703957,114.8294009,-4.795564222,30.35065771}, /*cmy*/
          {2.045660285,2.842310819,3.499191464,16.38678563}, /*cfy*/
          {-7802.258001,794.7929085,-9205.681275,-1347.641714,53.52390248,285.5127113}, /*cmz*/
          {11.21710158,8.937238396,3.28231044,0.1289349241} /*cfz*/
     },
     {
          2465633.5,
          {-6806.696244,669.4324679,-5895.441428,1150.945221,-45.57356846,-228.1892769}, /*cmx*/
          {4.641786527,5.765905045,0.1059041045,3.735013989}, /*cfx*/
          {-458.3303996,39.69454786,-284.1450268,74.42131441,-2.858345054,20.54389434}, /*cmy*/
          {-1.634527497,5.581235121,-31.57330398,0.1314641069}, /*cfy*/
          {-1674.061487,245.6598749,2925.902478,412.2706989,-19.52206956,140.0228594}, /*cmz*/
          {7.870137953,0.09715175755,0.7566061476,2.078353604} /*cfz*/
     },
     {
          2465649.5,
          {-590.6316143,110.409443,1834.269571,-234.4571862,12.13751447,-20.27791572}, /*cmx*/
          {3.423329521,3.678677535,4.220903207,0.1201113558}, /*cfx*/
          {-304.6988467,32.1781999,-354.1601788,54.025446,-2.28582195,1.611858327}, /*cmy*/
          {24.27711232,-0.2172515364,-5.841400928,13.94459152}, /*cfy*/
          {4880.62625,-448.8275059,5801.60359,784.9749212,31.38813961,62.9333705}, /*cmz*/
          {4.992363546,15.21678004,6.397382569,4.03941827} /*cfz*/
     },
     {
          2465665.5,
          {5656.262544,-560.0799494,-4530.935946,-953.0846232,38.61554109,-135.2786555}, /*cmx*/
          {1.519544697,-0.4474226978,0.182579392,6.007434219}, /*cfx*/
          {528.2927065,-51.09967557,-410.8483083,90.08260851,3.5096935,-10.83225749}, /*cmy*/
          {7.882777508,2.586335734,0.03627405032,-0.5920219255}, /*cfy*/
          {-1829.75026,158.1047068,1235.596655,-390.459889,-14.79305437,-69.8941039}, /*cmz*/
          {-4.325402168,2.046381468,5.625333571,1.05774867} /*cfz*/
     },
     {
          2465681.5,
          {-387.1212649,-15.68760553,2466.647698,256.0973673,-11.99124311,-186.9364594}, /*cmx*/
          {6.958054212,4.409390083,4.76890477,1.573200974}, /*cfx*/
          {161.1597672,-20.85700085,235.1015445,-37.28769287,-1.726220444,-16.91576893}, /*cmy*/
          {-0.5412259404,0.08107529377,3.874165971,1.151490612}, /*cfy*/
          {-7969.320459,812.8671551,9477.089199,-1378.725064,-54.72632651,-289.1417362}, /*cmz*/
          {8.060947649,2.655138282,6.424358855,3.253110888} /*cfz*/
     },
     {
          2465697.5,
          {-6923.620144,672.1534398,5840.277357,-1161.439255,45.81856179,-234.4988903}, /*cmx*/
          {7.79507328,2.607513484,3.22771183,3.676392533}, /*cfx*/
          {-504.8966727,48.64557478,-405.5761407,-83.78154735,3.30341494,-17.42640788}, /*cmy*/
          {4.699296939,2.620542217,3.224942698,3.647180105}, /*cfy*/
          {-2173.602032,297.1943792,-3316.07255,-490.2721782,-22.59177142,-146.9436916}, /*cmz*/
          {4.711232053,3.144619377,6.955562675,-1.190446325} /*cfz*/
     },
     {
          2465713.5,
          {-1170.049664,163.0238369,-1978.42378,293.4917101,-14.64933313,-17.27913631}, /*cmx*/
          {6.20134926,0.2792935352,0.8800117567,-0.2749344734}, /*cfx*/
          {-49.15711991,8.203881201,133.6755381,16.7040611,-0.8299413865,-1.711656212}, /*cmy*/
          {3.252565795,0.4102104901,1.040058391,0.4242623196}, /*cfy*/
          {4904.378912,-445.1420918,-5899.188937,-787.5908036,-31.28709868,-67.88166457}, /*cmz*/
          {1.809975806,5.767183501,3.222499547,0.8563087602} /*cfz*/
     },
     {
          2465729.5,
          {5871.729482,-579.9325044,4653.042381,992.5341154,-39.89642231,132.7803267}, /*cmx*/
          {4.683396664,2.66658476,3.29157618,2.807646098}, /*cfx*/
          {388.1512366,-38.51150404,-313.739359,66.01064985,-2.665351659,-9.790544112}, /*cmy*/
          {1.541951156,2.724091286,3.343291179,6.023240451}, /*cfy*/
          {-1207.51098,96.27001015,-860.4933605,314.4305416,12.41380092,73.90415807}, /*cmz*/
          {-0.9337187858,4.981697402,2.220561603,3.999814152} /*cfz*/
     },
     {
          2465745.5,
          {573.9946372,-115.2018576,-2219.544184,-282.4586149,14.35677281,195.2835377}, /*cmx*/
          {3.313129741,0.6364923507,1.142868552,4.52897728}, /*cfx*/
          {-178.0964036,14.13880581,288.2044517,-33.24443043,1.264184933,-13.63486262}, /*cmy*/
          {7.490268354,2.087776964,2.542175645,1.971547753}, /*cfy*/
          {-8105.458149,819.8458804,9710.083374,-1399.696331,55.22991369,289.6395094}, /*cmz*/
          {26.87894153,8.916237912,3.256647224,0.03216294728} /*cfz*/
     },
     {
          2465761.5,
          {-6715.981427,640.5147413,5480.477237,-1119.27317,43.85165289,234.4959589}, /*cmx*/
          {1.511791203,2.578454958,3.189665971,0.4502923403}, /*cfx*/
          {-527.8028424,53.47775487,478.4231062,-90.09866057,3.622382244,-17.00098595}, /*cmy*/
          {7.823645374,2.69051124,3.323432054,3.90266333}, /*cfy*/
          {-3119.877882,389.7532397,-4105.422806,632.4826497,-28.10724475,155.9186914}, /*cmz*/
          {4.704983076,-18.97055072,-18.29749314,-4.53326872} /*cfz*/
     },
     {
          2465777.5,
          {-1796.946216,220.2962628,-2322.809188,371.2933366,-17.64072207,14.43359347}, /*cmx*/
          {5.884667477,0.0790973291,0.7174806094,8.648077012}, /*cfx*/
          {56.15947513,-1.417545571,-169.1318904,15.25827981,-0.6854597524,-2.474524334}, /*cmy*/
          {82.68653049,1.564826977,1.910974459,0.5420858528}, /*cfy*/
          {4782.428905,-427.8277697,-5841.326095,-765.4655011,30.21620348,68.88702072}, /*cmz*/
          {1.769648115,-0.5489440395,0.04215672842,3.979108817} /*cfz*/
     },
     {
          2465793.5,
          {6031.230156,-592.3191154,4762.729437,1020.857423,-40.64771329,131.0818763}, /*cmx*/
          {4.696239273,2.642115142,3.261066214,2.742642492}, /*cfx*/
          {344.0624805,-34.61677046,281.4770921,58.28102532,2.4303424,-9.629994843}, /*cmy*/
          {-1.652985437,2.781771517,0.2783237663,6.162691669}, /*cfy*/
          {-557.2180903,32.12003698,-545.7148612,253.8043407,-10.9097552,-81.59482895}, /*cmz*/
          {-0.3281094862,4.660040845,5.001612763,0.6806850125} /*cfz*/
     },
     {
          2465809.5,
          {1123.433006,-171.2263666,-2336.186098,-336.7516528,16.77998545,202.3891075}, /*cmx*/
          {3.018479592,0.3705813495,0.9506508798,4.435817583}, /*cfx*/
          {-185.6206569,15.2575126,300.0430969,-34.98096936,-1.287569918,-12.74592935}, /*cmy*/
          {1.270057917,14.73348313,5.78702451,2.03247392}, /*cfy*/
          {-8145.399598,819.5169279,9789.782854,1404.011039,55.25859959,-289.9171947}, /*cmz*/
          {33.14444473,5.760374916,3.240784509,-3.153360533} /*cfz*/
     },
     {
          2465825.5,
          {-6689.347812,635.5490672,5399.005531,-1113.308081,43.54175126,235.7978525}, /*cmx*/
          {1.517596217,2.575077077,-21.95021977,0.4331686193}, /*cfx*/
          {-454.7158299,45.06334226,-403.1211545,-76.97493051,-3.066728729,14.88050713}, /*cmy*/
          {4.63654489,2.632520316,6.408824218,6.922708369}, /*cfy*/
          {-3337.326882,410.9911359,-4258.319166,663.853936,-29.39876728,-159.6042326}, /*cmz*/
          {4.700845458,-0.1382080728,-12.03358037,-7.714164104} /*cfz*/
     },
     {
          2465841.5,
          {-1770.417257,217.2796366,-2331.752309,366.8698943,-17.35771201,13.65796527}, /*cmx*/
          {5.886642685,0.0753320511,-5.561372441,2.528165504}, /*cfx*/
          {-54.71579458,8.637198936,117.6088819,16.85601119,0.8695802439,0.9905823466}, /*cmy*/
          {3.305964433,0.4457356656,4.115099769,2.755625246}, /*cfy*/
          {4792.317332,-430.0535042,-5866.408719,-764.6125131,30.23561599,-68.57644912}, /*cmz*/
          {1.765372013,5.734925012,0.04942431291,0.8761996805} /*cfz*/
     },
     {
          2465857.5,
          {5941.648758,-584.7992624,4680.03981,1007.617388,-40.12674218,130.810353}, /*cmx*/
          {4.697375737,2.65113459,-3.013560213,2.74840074}, /*cfx*/
          {357.9791922,-35.51499047,-280.7809403,60.23415005,2.4415729,-8.010931522}, /*cmy*/
          {1.523212879,2.666879652,0.1607468795,5.972934206}, /*cfy*/
          {-739.7713164,50.42022653,-640.3781769,267.6319286,-11.01776678,79.45775566}, /*cmz*/
          {-0.5679483857,4.772341599,5.11555612,3.847527575} /*cfz*/
     },
     {
          2465873.5,
          {282.8891007,-87.98277991,-2276.843802,-268.1470164,13.59521337,194.1317767}, /*cmx*/
          {3.408829154,0.7760131152,1.253239456,4.563403542}, /*cfx*/
          {72.52489212,-10.97898259,147.5002795,-20.59230652,-1.035476029,-12.54513018}, /*cmy*/
          {6.171944252,0.3758475223,4.075868023,1.267389932}, /*cfy*/
          {-8116.523775,821.9205405,9740.660076,1400.393921,-55.39105118,290.8117049}, /*cmz*/
          {14.30933473,5.776546648,150.9162696,-6.240675811} /*cfz*/
     },
     {
          2465889.5,
          {-7025.366947,677.273175,5768.572826,1171.099384,-46.13236278,240.3536846}, /*cmx*/
          {1.535456033,5.749351985,0.08210332157,0.5090835321}, /*cfx*/
          {-421.0464071,39.13129128,-328.6165226,69.6671492,-2.70295172,-15.44043284}, /*cmy*/
          {4.647779698,-0.6092609167,-0.004196015769,3.484674374}, /*cfy*/
          {-2359.904688,315.796255,-3351.512115,514.6329688,-23.6792547,-152.9407696}, /*cmz*/
          {4.682617501,6.265631634,6.932428805,-1.240953854} /*cfz*/
     },
     {
          2465905.5,
          {-1046.308405,147.2891516,-2017.907613,-272.2541969,13.59348043,20.87324959}, /*cmx*/
          {6.227174039,3.455878144,4.06652763,3.167557957}, /*cfx*/
          {-168.1855008,18.99345751,200.9438658,31.06184701,-1.433855538,1.426426568}, /*cmy*/
          {2.506503013,6.244225257,-37.08376677,-10.53743146}, /*cfy*/
          {4937.9895,-452.3573002,-5990.356107,-789.1779632,31.4734816,-69.33525299}, /*cmz*/
          {1.795446017,30.90793511,12.66921352,0.949376321} /*cfz*/
     },
     {
          2465921.5,
          {5415.233291,-541.3662769,4193.539563,-924.5389916,37.27616232,125.4196899}, /*cmx*/
          {4.694862699,-0.4489073538,0.1758984606,2.818161665}, /*cfx*/
          {404.9701742,-40.00482548,-310.9187345,69.28868147,-2.733284521,8.247004637}, /*cmy*/
          {-61.23840219,2.62212439,-3.046527276,2.654504644}, /*cfy*/
          {-1655.180811,142.2870275,1324.413547,366.0596703,-13.72155739,65.05824077}, /*cmz*/
          {-4.212525663,5.162251623,5.589624327,4.079159546} /*cfz*/
     },
     {
          2465937.5,
          {-1524.475376,91.95922882,3114.741975,331.6045009,-13.18612687,179.8265468}, /*cmx*/
          {0.9162101843,4.95846321,5.3343911,4.857315447}, /*cfx*/
          {41.16276455,-8.797512122,169.6778905,-20.75180022,1.053346999,13.8936244}, /*cmy*/
          {-6.306955585,0.5598850335,1.102351489,4.454299506}, /*cfy*/
          {-7641.088804,786.8854951,9233.501435,-1327.133051,-53.0659621,282.1840049}, /*cmz*/
          {8.060110289,8.958548255,6.450545535,0.1541166084} /*cfz*/
     },
     {
          2465953.5,
          {-7302.025513,717.0061682,6061.034617,1217.794212,-48.55351284,242.9028877}, /*cmx*/
          {1.563996284,5.796827129,6.426404084,0.6297233762}, /*cfx*/
          {-518.5409427,50.01240039,-414.2149781,-85.6200804,3.382890334,17.6378833}, /*cmy*/
          {-1.546755217,2.634438466,15.81682239,0.5326528236}, /*cfy*/
          {-509.4991545,132.7859953,1596.979343,275.7979994,14.16962973,151.6614024}, /*cmz*/
          {1.405464824,0.5098985565,4.225132841,2.25386078} /*cfz*/
     },
     {
          2465969.5,
          {49.75727731,36.79107436,-2093.3852,-189.3238495,9.591971426,40.0791272}, /*cmx*/
          {0.5182964623,4.22965846,4.648833143,3.482397422}, /*cfx*/
          {-7.425039234,3.436853556,143.073482,12.5989325,-0.6557582675,2.985481347}, /*cmy*/
          {3.49772674,0.91406685,1.440066015,3.570241753}, /*cfy*/
          {5038.121991,-474.4525305,6087.141469,809.5399463,32.73810149,71.89914464}, /*cmz*/
          {4.972311383,-3.589198925,0.178045366,4.211074643} /*cfz*/
     },
     {
          2465985.5,
          {4396.232026,-454.8500155,3210.969375,767.681205,-31.66911777,110.3331895}, /*cmx*/
          {4.697947865,2.765516714,3.399236738,2.903369998}, /*cfx*/
          {297.638642,-30.68686489,-218.5944445,52.44255378,-2.134116164,-7.934691524}, /*cmy*/
          {1.571882803,9.068129991,-34.29693865,6.018390467}, /*cfy*/
          {-2758.126159,255.5546646,2348.632712,519.9389683,19.34738767,-49.36630979}, /*cmz*/
          {-4.349593997,5.423454176,-9.76803967,1.380447285} /*cfz*/
     },
     {
          2466001.5,
          {-3739.930561,313.5846902,-4901.310663,630.1768809,23.43748507,177.638631}, /*cmx*/
          {4.397053279,-0.8420679702,9.109086684,5.247348914}, /*cfx*/
          {-379.9643358,34.44816305,-460.4051439,-62.30727356,2.391831132,-14.45684333}, /*cmy*/
          {-1.725692199,2.429742267,-3.285955143,2.430396434}, /*cfy*/
          {-6453.036742,684.4400338,-8054.415335,1140.585589,46.4716937,-260.3709098}, /*cmz*/
          {4.967797679,5.881377027,-2.900877916,3.442118944} /*cfz*/
     },
     {
          2466017.5,
          {-7076.448584,708.9885955,5792.497169,1181.450226,47.92463101,238.1171673}, /*cmx*/
          {1.600570241,5.859677781,3.362030829,0.7992261973}, /*cfx*/
          {-403.1678583,43.50075527,-347.8364234,70.76020055,-2.970321597,-15.56545812}, /*cmy*/
          {-1.544679594,-0.2721729165,0.3754847173,4.353988137}, /*cfy*/
          {2075.414232,-127.4181919,-1141.287162,-354.7409796,-13.90701174,-172.8019349}, /*cmz*/
          {2.128301667,5.154670199,2.430161123,-0.4516256326} /*cfz*/
     },
     {
          2466033.5,
          {1551.859397,-119.602079,2997.479943,-311.6612344,-12.17365562,70.23940193}, /*cmx*/
          {-2.111828823,5.23340942,2.523313693,3.663352976}, /*cfx*/
          {358.1084407,-33.14515849,-450.2104215,57.58532566,-2.326604396,-8.309037715}, /*cmy*/
          {7.829933239,8.864167849,9.46108588,0.9235589635}, /*cfy*/
          {4870.030177,-474.0476878,-5951.976025,-789.0565625,-32.58718673,-72.70253641}, /*cmz*/
          {8.156338614,-0.369179591,3.415997122,-4.997483724} /*cfz*/
     },
     {
          2466049.5,
          {2892.566671,-323.1485885,-1744.549529,541.3966345,-23.37960909,86.20743038}, /*cmx*/
          {-111.5500077,2.912508816,-46.71237886,-3.287707577}, /*cfx*/
          {-48.59160308,2.262405001,-101.7196987,-18.93197285,0.7699687653,4.567625885}, /*cmy*/
          {5.36316582,1.462315467,1.862145382,3.383176186}, /*cfy*/
          {-3747.890541,361.7696896,-3321.019191,-673.1538423,-25.60208371,43.92705558}, /*cmz*/
          {-32.64414664,8.72752904,6.152622592,5.172205719} /*cfz*/
     },
     {
          2466065.5,
          {-5898.557677,534.7165558,-6831.682769,965.1041813,36.78628459,194.3685231}, /*cmx*/
          {-8.009942718,-0.6569256628,-3.210831965,5.645978301}, /*cfx*/
          {-694.0837719,70.47016207,-837.4683759,-117.5280825,-4.745709058,24.80800958}, /*cmy*/
          {11.10804232,8.96215896,0.1661566114,0.05288356406}, /*cfy*/
          {-4235.585091,480.4091832,-5896.666441,791.9301393,-33.59733546,-220.8885754}, /*cmz*/
          {312.9441041,-0.272726971,0.3795899686,-15.1960404} /*cfz*/
     },
     {
          2466081.5,
          {-5709.925727,589.0867787,-4378.312227,-962.5154955,-40.21757359,-217.3492176}, /*cmx*/
          {-7.789993762,2.817249738,0.3345654493,-2.076333841}, /*cfx*/
          {156.3935263,-7.694791266,-149.601089,33.77125847,1.368826114,19.46735208}, /*cmy*/
          {2.083961365,1.764303372,5.297764131,2.44994563}, /*cfy*/
          {4947.244569,-424.5073483,-3951.464803,-786.72256,30.04876953,-216.2518432}, /*cmz*/
          {14.41839204,5.591592097,6.161087915,-6.351585331} /*cfz*/
     },
     {
          2466097.5,
          {3405.792163,-317.7343174,4595.068667,-596.5634707,23.03952234,-107.6089211}, /*cmx*/
          {-1.818808499,5.602062856,18.73026255,0.6792817126}, /*cfx*/
          {616.4277083,-61.2781704,-759.0931289,100.3841968,-4.190297766,11.86125182}, /*cmy*/
          {14.32724169,2.771882581,3.418250109,4.434891994}, /*cfy*/
          {4007.090663,-406.4358628,5155.687226,-659.6553027,-28.24630151,68.19235042}, /*cmz*/
          {-1.191325044,6.031552872,3.553552377,-1.437679767} /*cfz*/
     },
     {
          2466113.5,
          {1035.533807,-154.1104814,158.3438307,284.6162065,-13.71635111,55.68230622}, /*cmx*/
          {2.814626259,3.336930238,3.934530091,3.083082615}, /*cfx*/
          {-441.1384739,41.72845225,446.0547289,77.80089241,-2.95937548,-3.022982675}, /*cmy*/
          {-4.337186903,5.570280028,6.146803464,2.082540442}, /*cfy*/
          {-4283.013639,428.0788676,3842.892178,762.0259614,29.75085219,-47.94930285}, /*cmz*/
          {39.64509908,5.706030958,3.160712206,2.551250797} /*cfz*/
     },
     {
          2466129.5,
          {-7188.78545,678.1461057,8016.713619,-1174.24314,-45.91604892,216.4291806}, /*cmx*/
          {14.06782482,52.85663057,0.06377234777,5.964501172}, /*cfx*/
          {-487.7493078,55.63000377,704.8112006,-91.11855707,-3.94765629,-27.08746988}, /*cmy*/
          {1.872964732,2.914825844,-5.860226454,-21.50292104}, /*cfy*/
          {-1083.618103,179.5600968,3003.261371,-333.3826919,-16.19602833,-169.9611415}, /*cmz*/
          {-4.020677947,3.370890984,0.8298744272,-8.565351962} /*cfz*/
     },
     {
          2466145.5,
          {-2918.482626,325.2198154,1590.884633,-530.9375844,24.04208738,187.9925722}, /*cmx*/
          {1.643717908,9.361360899,10.02502446,7.797398177}, /*cfx*/
          {804.5099952,-72.28490163,-734.4854557,130.27469,5.002534364,-32.60890138}, /*cmy*/
          {14.41486452,140.7325384,-0.04796943378,-6.312523927}, /*cfy*/
          {7163.570804,-665.3257542,6135.723243,-1153.467438,-45.16599091,-259.625594}, /*cmz*/
          {-1.305369703,-0.549336757,3.206762264,0.2252283101} /*cfz*/
     },
     {
          2458849.5,
          {-160.3375214,0.1842398407,3582.58862,10.34099477,-0.03760277579,51.22674609}, /*cmx*/
          {5.479555489,3.756822294,3.737122433,3.090515211}, /*cfx*/
          {-4.36170739,0.1119148691,639.0472963,3.960840066,-0.01442746198,5.686987624}, /*cmy*/
          {1.383711563,-7.802874491,4.672845907,5.298223937}, /*cfy*/
          {-63.42343742,0.1839749134,3574.757188,-8.925204347,-0.0312910762,51.36559317}, /*cmz*/
          {0.7418106445,-4.167516516,5.153699193,4.694368252} /*cfz*/
     },
     {
          2458949.5,
          {-100.1316344,-0.5888794774,3500.447103,2.243528762,-0.02939240281,53.54873253}, /*cmx*/
          {0.6416946591,6.413192565,5.874567956,0.1609040998}, /*cfx*/
          {0.9583904931,0.01068156095,376.6209516,-0.3926829746,-0.009851878234,8.803817711}, /*cmy*/
          {2.825659253,10.76267872,0.3632150101,2.060804336}, /*cfy*/
          {-88.57959107,0.3987188809,3510.437654,1.07906559,-0.0170230546,56.50724527}, /*cmz*/
          {2.190020958,2.694754343,1.035317557,1.713384329} /*cfz*/
     },
     {
          2459049.5,
          {-149.3833666,0.04763036092,3542.512059,6.729146174,0.04749762967,50.82027984}, /*cmx*/
          {2.319737892,3.914961236,0.7803935783,3.481935588}, /*cfx*/
          {5.426701997,0.01346563595,461.734217,2.616476234,0.01837353021,8.384033089}, /*cmy*/
          {4.506677086,11.28394764,1.867845001,5.625831456}, /*cfy*/
          {-45.86023982,0.01079938913,3550.274231,5.988424373,0.0421744221,51.59488345}, /*cmz*/
          {3.885224472,11.84472487,2.40425571,5.035884098} /*cfz*/
     },
     {
          2459149.5,
          {-112.4198233,-0.3765481634,3585.588645,-4.775157874,0.01330123128,50.64510444}, /*cmx*/
          {4.012902256,5.313320497,2.780146081,0.3757024036}, /*cfx*/
          {4.518489507,-0.06405759649,555.1589487,-2.377256736,0.003998784526,6.681281983}, /*cmy*/
          {6.208730109,0.3583532945,2.584154663,2.371724857}, /*cfy*/
          {-68.68655453,0.04849739377,3580.496996,-6.015037881,0.003159536338,53.10531374}, /*cmz*/
          {5.587151656,0.6916570004,4.482967302,1.90523215} /*cfz*/
     },
     {
          2459249.5,
          {-140.7323227,0.1297441009,3586.881774,-9.255894661,0.04251473057,51.10208245}, /*cmx*/
          {5.485859322,0.6333843013,6.900893344,3.421159529}, /*cfx*/
          {-8.118065358,0.06461842761,325.2453034,-3.781034111,0.01777774045,2.160066592}, /*cmy*/
          {1.238192474,1.475303827,1.422802668,5.11150853}, /*cfy*/
          {-88.7901402,0.1084549785,3582.036116,-8.606714534,0.03919538438,51.78508369}, /*cmz*/
          {0.765094195,2.181897999,14.71443765,5.007600972} /*cfz*/
     },
     {
          2459349.5,
          {-84.19695,-0.658182105,3512.382281,2.902132874,0.01550012288,54.82757547}, /*cmx*/
          {0.6892376598,1.599299813,3.412347442,0.5367258654}, /*cfx*/
          {-4.524955957,-0.007329109969,113.907583,1.554538987,0.003243507851,6.650854516}, /*cmy*/
          {2.336981576,2.843779949,17.11107682,2.059622655}, /*cfy*/
          {-124.5079929,0.5285200068,3510.481612,4.358444023,-0.01011185842,57.21357342}, /*cmz*/
          {2.240804811,3.548976918,2.825826271,2.058725413} /*cfz*/
     },
     {
          2459449.5,
          {-125.1577013,-0.08698981917,3568.434338,3.959799567,0.04197998903,50.55010689}, /*cmx*/
          {2.419220421,4.066866702,7.168608508,3.817656218}, /*cfx*/
          {5.709424542,-0.1021174832,267.017121,1.708935442,-0.01784728184,4.408094015}, /*cmy*/
          {4.381164954,5.017832059,11.23726489,5.85552584}, /*cfy*/
          {-59.01317151,-0.2200365384,3568.452045,4.189368944,-0.04274929639,50.12418865}, /*cmz*/
          {3.984548859,5.708182237,11.93554041,5.363915881} /*cfz*/
     },
     {
          2459549.5,
          {-98.97003438,-0.3108429015,3602.924178,-6.579103447,0.005922871915,51.57031523}, /*cmx*/
          {4.04680456,5.364944624,-171.8302266,0.6494493188}, /*cfx*/
          {1.769134751,-0.1004991119,267.4965356,-2.994780692,0.002433051503,2.785775734}, /*cmy*/
          {6.003593419,0.1007849705,1.008023102,1.854911923}, /*cfy*/
          {-101.0854564,0.05522299324,3605.537711,-8.011683549,0.009984379052,53.75650333}, /*cmz*/
          {5.630940224,0.7322178216,0.6453561815,2.174664084} /*cfz*/
     },
     {
          2459649.5,
          {-111.3649342,0.02034451494,3570.744102,-7.317072242,0.04228721073,51.8950371}, /*cmx*/
          {5.500315437,0.6842807418,6.960788874,3.776498791}, /*cfx*/
          {-3.435247236,-0.01311394095,-92.11536337,-3.049786487,0.01825498404,2.849607761}, /*cmy*/
          {9.132697388,1.408720209,-4.915364508,3.807201634}, /*cfy*/
          {-105.3782723,-0.02221743341,3569.215026,-7.524453035,0.04340243511,52.23949916}, /*cmz*/
          {0.7893423802,2.285728177,2.290653813,5.337417432} /*cfz*/
     },
     {
          2459749.5,
          {-75.11536137,-0.5688704156,3526.563441,5.094434222,-0.01653992109,55.50209797}, /*cmx*/
          {0.7558657778,2.108307515,1.712547603,0.8929124735}, /*cfx*/
          {-5.833639996,-0.02286283596,-194.0998022,2.794099673,-0.009350386586,4.783419011}, /*cmy*/
          {3.558426015,2.927347178,2.776755707,1.786343386}, /*cfy*/
          {-146.9495309,0.5304730521,3511.410451,6.962997865,-0.02661058885,55.97682231}, /*cmz*/
          {2.30958572,3.728298355,3.590510207,2.40364181} /*cfz*/
     },
     {
          2459849.5,
          {-100.9755839,-0.1360758359,3584.46349,0.9571036588,-0.03193801914,51.01722038}, /*cmx*/
          {2.510277191,4.664997036,4.110556361,4.131061134}, /*cfx*/
          {7.344619767,-0.1608800152,120.382879,0.5220295869,-0.0141193326,1.139520675}, /*cmy*/
          {9.701761959,5.536936184,4.85701591,4.896613026}, /*cfy*/
          {-75.52002464,-0.3788409653,3578.329224,1.723521532,-0.03767821802,49.42381371}, /*cmz*/
          {4.074350289,5.976231418,5.710618897,5.68503114} /*cfz*/
     },
     {
          2459949.5,
          {-79.19438223,-0.2434489029,3603.589146,-7.702903413,0.01418747547,52.13621838}, /*cmx*/
          {4.075834184,5.390883306,5.055891453,0.9257608453}, /*cfx*/
          {4.278251056,-0.1081376082,138.4998604,-3.35445667,0.005772732378,4.695751609}, /*cmy*/
          {4.197513444,6.11000818,-0.1406248327,0.6511607271}, /*cfy*/
          {-129.2105491,0.07832529154,3615.939389,9.357612714,0.02162422311,53.78204653}, /*cmz*/
          {5.661446517,3.888307163,0.7127279431,2.443230177} /*cfz*/
     },
     {
          2460049.5,
          {-73.24652043,-0.1565831175,3535.156066,-4.609199664,0.03595798382,53.64700068}, /*cmx*/
          {5.523126191,0.8168278358,0.7977193176,4.140375592}, /*cfx*/
          {8.695509304,-0.1186248321,355.2863781,-1.871241041,0.01546281912,6.263350133}, /*cmy*/
          {4.922734595,1.515589071,1.401265606,3.833083291}, /*cfy*/
          {-112.8922943,-0.2051024977,3538.638138,5.68983708,0.04264212628,52.66982243}, /*cmz*/
          {0.8144178325,5.605447248,2.463654682,5.686435341} /*cfz*/
     },
     {
          2460149.5,
          {-69.7339378,-0.3624773704,3535.148508,6.440437593,-0.03017621411,54.81511194}, /*cmx*/
          {0.8387712491,2.35439108,2.285093643,1.222223961}, /*cfx*/
          {-3.060928817,-0.02665585775,415.0843797,3.324523104,-0.01630084854,4.89341951}, /*cmy*/
          {0.2716774486,2.928903724,2.898241957,1.234162666}, /*cfy*/
          {-154.2779412,0.3855202803,3515.833061,-7.991698511,-0.04019044384,53.72877363}, /*cmz*/
          {2.393944876,0.7213383529,3.830580167,2.749646002} /*cfz*/
     },
     {
          2460249.5,
          {-76.42850107,-0.1145646304,3587.745366,-2.308791665,-0.02027114127,51.73697699}, /*cmx*/
          {2.587808339,3.77913007,4.188626912,4.424731843}, /*cfx*/
          {10.72643648,-0.1511682062,272.1962867,-1.128116761,-0.008421623745,4.68703046}, /*cmy*/
          {2.277184519,4.223693386,4.721817146,3.891277991}, /*cfy*/
          {-92.71409429,-0.4680639519,3581.098292,1.249497074,-0.02907423084,49.52280321}, /*cmz*/
          {4.147433551,2.020796528,5.750566626,5.989625888} /*cfz*/
     },
     {
          2460349.5,
          {-54.22258393,-0.1879693975,3586.459467,-8.272329302,0.02398498815,52.36090715}, /*cmx*/
          {4.102623127,5.419724297,5.264735652,1.209060508}, /*cfx*/
          {11.65116525,-0.09476102395,430.2681222,-3.528968129,0.01050722091,8.988646626}, /*cmy*/
          {3.5483159,5.847389996,-0.5216885008,0.6191702746}, /*cfy*/
          {-150.6070852,0.11009947,3606.70274,-10.04384251,0.03217269521,53.27384644}, /*cmz*/
          {5.680047007,13.31916967,0.7236144753,2.717697638} /*cfz*/
     },
     {
          2460449.5,
          {-29.17511278,-0.3841213695,3487.051988,-1.562644336,0.02364435737,55.62677091}, /*cmx*/
          {5.553320815,1.465254876,1.05667808,4.497448911}, /*cfx*/
          {25.06823718,-0.2279969758,639.1083907,-0.8824827465,0.009986404157,9.752025906}, /*cmy*/
          {4.83110934,2.474990788,1.639878897,4.068832433}, /*cfy*/
          {-114.2808504,-0.3969920704,3500.795119,-3.264876195,0.03567587987,53.15636178}, /*cmz*/
          {0.8397595073,2.848943824,2.690510215,6.053299037} /*cfz*/
     },
     {
          2460549.5,
          {-62.71169548,-0.1143803642,3532.520887,-6.426548115,-0.04012348265,52.84702732}, /*cmx*/
          {0.9322963559,5.664724759,2.509255095,1.533588933}, /*cfx*/
          {2.933838687,-0.005525450432,613.7885738,-2.997636009,-0.01948961003,7.262364323}, /*cmy*/
          {0.293156478,12.31678743,2.87317862,1.012612835}, /*cfy*/
          {-150.1511498,0.1466903165,3522.599271,7.309827894,-0.04660980701,51.58557715}, /*cmz*/
          {2.486547235,-21.14092484,3.992355951,3.086265177} /*cfz*/
     },
     {
          2460649.5,
          {-49.24599309,-0.06580941849,3578.467405,4.783696567,-0.00880485293,52.40478114}, /*cmx*/
          {2.64992868,0.8145349705,4.345251206,4.702543528}, /*cfx*/
          {16.66875849,-0.09128070329,527.5514235,2.31741918,-0.002237974951,9.353356195}, /*cmy*/
          {2.080601537,1.127273026,4.458826223,4.05292214}, /*cfy*/
          {-107.6414169,-0.4951627532,3574.785581,-3.68379689,-0.01873423076,49.99679545}, /*cmz*/
          {4.199722698,-0.786490068,5.820401528,-0.01129492136} /*cfz*/
     },
     {
          2460749.5,
          {-26.40302375,-0.1352709146,3554.07815,8.40586821,-0.03294118525,52.3649253}, /*cmx*/
          {4.127196794,2.324217543,8.535198925,1.499841542}, /*cfx*/
          {22.2089566,-0.06813657902,728.9241747,3.504995211,0.0147795105,12.72826562}, /*cmy*/
          {3.441201982,2.476816418,-0.7217979274,0.8057827672}, /*cfy*/
          {-162.14024,0.1256021598,3576.679627,-10.01877671,0.04091602432,52.47482757}, /*cmz*/
          {5.687553506,0.7651336617,0.7413936223,3.005725308} /*cfz*/
     },
     {
          2460849.5,
          {14.80278816,-0.5978352382,3438.74237,-2.867072016,-0.01094364552,56.55434372}, /*cmx*/
          {5.591105886,3.423806754,5.1546492,4.83994639}, /*cfx*/
          {40.81453194,-0.2964190986,878.4204881,-1.775401875,-0.006086775139,12.84794709}, /*cmy*/
          {4.82942149,3.546844797,-0.5195500931,4.315890424}, /*cfy*/
          {-114.4731579,-0.5253263033,3469.443354,1.889741982,0.02256804641,53.79709662}, /*cmz*/
          {0.8659588434,7.40427355,3.081672467,6.425163085} /*cfz*/
     },
     {
          2460949.5,
          {-49.8787779,0.1110976206,3518.632098,-5.085158811,0.04319179776,50.4336883}, /*cmx*/
          {1.027836055,5.798738557,5.772011091,1.837248737}, /*cfx*/
          {10.75957551,0.04898968716,795.6814008,-2.003595962,0.01875387807,10.21647872}, /*cmy*/
          {0.3432376199,5.9467253,12.18668045,1.10840116}, /*cfy*/
          {-141.2337194,-0.08615276204,3526.523928,5.24108042,0.04585272689,50.07919981}, /*cmz*/
          {2.576666575,4.1293771,7.257207315,3.401786649} /*cfz*/
     },
     {
          2461049.5,
          {-17.4685852,-0.03064333466,3559.976301,6.824835968,-0.003373601107,52.81326233}, /*cmx*/
          {2.695962059,0.8775177348,0.2623681454,4.966206121}, /*cfx*/
          {25.49574145,-0.015389029,790.0016097,3.178621735,-0.003268262227,13.80345366}, /*cmy*/
          {2.01745139,1.009190419,1.417916856,4.267324365}, /*cfy*/
          {-117.4219663,-0.4727999022,3557.84225,-5.813011311,0.00813728559,50.50518655}, /*cmz*/
          {4.229992972,5.545657807,2.996805254,0.2499832819} /*cfz*/
     },
     {
          2461149.5,
          {1.181549575,-0.05998648215,3510.922248,8.099670932,-0.04059155554,52.09939684}, /*cmx*/
          {4.147208186,2.398679516,8.664202823,1.799496138}, /*cfx*/
          {32.81182023,-0.02413944482,980.1919263,3.21538641,0.01748265055,15.57993232}, /*cmy*/
          {3.399044524,2.294541625,-0.8465379594,1.061643312}, /*cfy*/
          {-160.2338146,0.08522302432,3529.067498,-9.1258964,0.04622583652,51.90950095}, /*cmz*/
          {5.684183152,0.800112281,7.069722858,3.31434551} /*cfz*/
     },
     {
          2461249.5,
          {50.58302584,-0.7012283496,3404.078351,-5.914397906,0.01985459669,55.47973438}, /*cmx*/
          {5.638137544,3.751535665,3.424944687,5.17063431}, /*cfx*/
          {51.46077683,-0.2832005912,1062.262954,-2.880313738,-0.01059563843,15.25621876}, /*cmy*/
          {4.862050474,3.716128566,0.3618891959,4.551052826}, /*cfy*/
          {-116.9878294,-0.53111704,3453.264541,4.313938187,0.01293646402,54.24051863}, /*cmz*/
          {0.8960277644,2.102857689,16.9084047,0.4909625004} /*cfz*/
     },
     {
          2461349.5,
          {-30.11715645,0.2885089291,3497.757794,-2.835313283,0.04031848626,48.46579566}, /*cmx*/
          {1.114754576,5.93794598,5.838930472,2.136059881}, /*cfx*/
          {19.30193583,0.1269844492,968.3594001,-0.7411573634,-0.01555678073,13.04856518}, /*cmy*/
          {0.3916401621,5.75543263,2.55680744,1.3328776}, /*cfy*/
          {-132.4359692,-0.2283622,3522.291397,2.37012327,0.03946063806,49.21165736}, /*cmz*/
          {2.653367921,4.354454627,7.344563381,3.690662791} /*cfz*/
     },
     {
          2461449.5,
          {19.15952264,-0.02998290046,3537.481794,8.512210967,-0.01385715793,52.92220557}, /*cmx*/
          {2.724802095,-5.375253641,0.7935188008,5.217538569}, /*cfx*/
          {35.93458383,0.04797450281,1027.394471,3.632631401,0.007211958765,17.39301156}, /*cmy*/
          {1.980697984,7.10695107,4.266372514,4.484925469}, /*cfy*/
          {-119.5420581,-0.4181369103,3532.571747,7.489903044,-0.006666533242,50.87195382}, /*cmz*/
          {4.239251986,-123.2513134,1.677663981,0.4947793401} /*cfz*/
     },
     {
          2461549.5,
          {25.92555218,0.0598239598,3463.66415,7.185325216,-0.04552058885,51.50004182}, /*cmx*/
          {4.158885152,2.512811592,2.526057661,2.114026634}, /*cfx*/
          {39.69877154,0.04917071004,1161.31819,2.593631982,0.01777145256,17.59602377}, /*cmy*/
          {3.374798938,2.180352792,5.361201728,1.354704204}, /*cfy*/
          {-141.9215871,-0.05182420276,3471.411731,7.157103802,0.04564524645,52.08760304}, /*cmz*/
          {5.670453829,-2.254686229,7.160164593,3.643568937} /*cfz*/
     },
     {
          2461649.5,
          {72.30370993,-0.6204334645,3392.092082,-7.862003685,0.03525423934,52.80173064}, /*cmx*/
          {5.695170508,3.930880646,3.834430427,5.491982914}, /*cfx*/
          {55.3389313,-0.1856742072,1188.755791,-3.380441061,-0.01600978234,16.93433647}, /*cmy*/
          {4.913530347,3.706812571,0.5383718924,4.779604646}, /*cfy*/
          {-121.2023477,-0.4095792722,3450.79987,-6.81771743,-0.02704710222,53.56419221}, /*cmz*/
          {0.9341429287,5.541710538,2.245653199,0.795934411} /*cfz*/
     },
     {
          2461749.5,
          {-4.676031724,0.4220007011,3475.488417,0.3828019484,0.03382988435,47.30405813}, /*cmx*/
          {1.182826841,16.42198718,5.865982884,2.422406815}, /*cfx*/
          {27.95098991,0.1977193512,1128.185295,0.4496284979,-0.01159727142,15.55368387}, /*cmy*/
          {0.4255006362,5.77179423,2.25118994,1.596149176}, /*cfy*/
          {-123.9843237,-0.2541854904,3509.303832,1.051776107,-0.0295236568,48.8664509}, /*cmz*/
          {2.708459979,0.4228160654,4.255305649,3.956037044} /*cfz*/
     },
     {
          2461849.5,
          {58.74769684,-0.06271622737,3516.525331,9.90185455,-0.02538386534,52.73254545}, /*cmx*/
          {2.734456964,44.90431221,0.8602335267,5.458380987}, /*cfx*/
          {44.93576869,0.0870879627,1210.139735,-3.730960568,0.009633554298,19.5836407}, /*cmy*/
          {1.946881639,-2.569409937,3.93102442,4.700880368}, /*cfy*/
          {-112.4163819,-0.3479185501,3505.948782,-8.68811057,0.01747249007,51.13587875}, /*cmz*/
          {4.230393368,5.553635572,5.295717289,0.7309844227} /*cfz*/
     },
     {
          2461949.5,
          {47.33772683,0.215550408,3422.980113,5.382971716,-0.04494740265,50.57875483}, /*cmx*/
          {4.15862876,2.693574168,2.691941768,2.452129766}, /*cfx*/
          {40.19368599,0.1547935559,1257.593038,-1.652626521,0.01522389082,18.92729784}, /*cmy*/
          {3.356439167,5.371652552,5.346244551,1.664972738}, /*cfy*/
          {-107.2682699,-0.2959925467,3416.153271,-4.131590005,0.03725274786,53.13984159}, /*cmz*/
          {5.649050601,1.138353692,1.052211194,3.9817582} /*cfz*/
     },
     {
          2462049.5,
          {80.77620965,-0.3634971155,3402.275904,-8.215338567,0.04584164918,49.78735425}, /*cmx*/
          {5.758895756,4.087452195,4.065305914,5.798393796}, /*cfx*/
          {54.27386781,-0.05205778196,1262.15791,3.189813082,-0.01877794668,17.84434802}, /*cmy*/
          {4.97310166,0.4570073719,0.4938545225,5.011420801}, /*cfy*/
          {-122.6258023,-0.2132122785,3453.889776,7.882361394,-0.04274344782,51.45540952}, /*cmz*/
          {0.9821309167,2.566353815,2.534107764,1.0572606} /*cfz*/
     },
     {
          2462149.5,
          {24.22768132,0.5212539714,3458.187167,2.501534142,0.02558338739,46.85439981}, /*cmx*/
          {1.224372219,5.756713874,5.861622238,2.689852068}, /*cfx*/
          {35.72353859,0.2256344734,1256.989681,-1.430738135,-0.00760882668,17.43795867}, /*cmy*/
          {0.4393817144,2.231841038,1.844765841,1.8553182}, /*cfy*/
          {-112.2527645,-0.1948694356,3493.559504,-3.866886081,-0.01797357623,49.05068642}, /*cmz*/
          {2.738206372,4.046266786,4.281986746,4.201617602} /*cfz*/
     },
     {
          2462249.5,
          {97.09498736,-0.1075991104,3501.696973,10.88612768,-0.03727554186,52.26057548}, /*cmx*/
          {2.722845079,0.9278358459,0.8894574131,5.69663331}, /*cfx*/
          {48.92826245,0.102957189,1310.874837,-3.623257587,0.01144393851,20.04093069}, /*cmy*/
          {1.907965261,3.386493303,3.490802346,4.918693341}, /*cfy*/
          {-96.07407221,-0.2705545551,3486.585938,-9.387393178,0.02891591439,51.3560535}, /*cmz*/
          {4.208036803,5.55738292,5.422815771,0.966504994} /*cfz*/
     },
     {
          2462349.5,
          {67.32384367,0.3585902101,3403.0059,2.660299337,-0.03585248311,49.82793049}, /*cmx*/
          {4.146226354,3.143121941,2.906358279,2.812900686}, /*cfx*/
          {34.161679,0.272727333,1262.78901,-0.9025749489,0.01042936901,19.60930562}, /*cmy*/
          {3.340482123,6.189513712,5.500130191,1.97406329}, /*cfy*/
          {-62.13133704,-0.5904805901,3379.220199,1.916398237,0.0226273493,54.18093715}, /*cmz*/
          {5.626899095,-32.04003785,1.481261953,4.308589128} /*cfz*/
     },
     {
          2462449.5,
          {83.33731363,-0.02726248899,3426.207252,6.985230807,0.04982074018,47.56816877}, /*cmx*/
          {5.821233256,7.374742358,4.229565084,6.079451366}, /*cfx*/
          {51.56058808,0.04420839465,1287.25968,2.490895395,0.01889953206,17.86254087}, /*cmy*/
          {5.029808051,6.525447226,-2.83067672,5.255638247}, /*cfy*/
          {-116.3604271,-0.00903198777,3456.920783,-7.074632817,0.05005062037,48.65327954}, /*cmz*/
          {1.036272948,5.822134859,-0.4796574652,1.294937219} /*cfz*/
     },
     {
          2462549.5,
          {53.93401976,0.5861750132,3453.452231,-4.899845807,0.01623227472,47.04222804}, /*cmx*/
          {1.235507351,2.676430852,5.842394923,2.935878193}, /*cfx*/
          {40.51364805,0.1917354651,1326.11285,-2.30162711,0.00361776509,18.29415476}, /*cmy*/
          {0.4315444083,1.862842488,4.308909214,2.0913613}, /*cfy*/
          {-92.88203964,-0.1058345708,3485.374474,6.316899643,0.006154158243,49.69609016}, /*cmz*/
          {2.743914175,0.9769735867,1.204826562,4.432828847} /*cfz*/
     },
     {
          2462649.5,
          {127.6132139,-0.1231186821,3494.743887,-11.12145618,-0.04771774539,51.60457223}, /*cmx*/
          {2.689812307,4.075930809,0.9159300313,5.946425702}, /*cfx*/
          {46.09205207,0.09569765473,1307.53718,-3.506143637,-0.01416721603,18.82862787}, /*cmy*/
          {1.861693766,3.003609939,6.158937061,5.14564922}, /*cfy*/
          {-72.73932024,-0.1779314146,3479.597261,9.533730374,0.03943698904,51.4764884}, /*cmz*/
          {4.17828292,2.43428538,5.513461484,1.212028952} /*cfz*/
     },
     {
          2462749.5,
          {88.22308815,0.42606715,3414.282028,2.382038852,-0.01880905134,49.70329217}, /*cmx*/
          {4.128413326,5.011392897,3.383573216,3.166373541}, /*cfx*/
          {24.44683118,0.3582370926,1181.676409,1.758130003,0.007198448051,19.42887312}, /*cmy*/
          {3.32735064,3.918837396,-75.44506393,2.266509821}, /*cfy*/
          {-18.1023452,-0.8087196687,3373.55202,-4.852045581,0.01630561077,53.87708364}, /*cmz*/
          {5.615294813,3.564740162,15.32202742,4.613350691} /*cfz*/
     },
     {
          2462849.5,
          {88.25599684,0.2606878556,3455.359576,4.528709667,0.0473138239,46.38107036}, /*cmx*/
          {5.872161222,1.232740272,4.330958382,0.05039131789}, /*cfx*/
          {49.01070971,0.04979941426,1262.242075,1.556022554,0.01745316558,16.89193963}, /*cmy*/
          {5.072662751,6.159791138,-135.0751156,5.513283429}, /*cfy*/
          {-100.3740653,0.1664753801,3461.456741,-4.771191885,0.04824136823,46.41825329}, /*cmz*/
          {1.088050671,5.90959553,5.861730426,1.533214656} /*cfz*/
     },
     {
          2462949.5,
          {81.22614265,0.605144565,3468.322623,-6.92935773,0.005694317378,47.80691202}, /*cmx*/
          {1.217385844,2.658790754,5.912879671,3.163808951}, /*cfx*/
          {39.94755555,0.1039738223,1304.477088,-3.127612026,-0.002958667165,17.68131412}, /*cmy*/
          {0.4020863919,1.499171093,-0.7622265923,2.295327417}, /*cfy*/
          {-63.7158375,-0.03293374644,3493.515742,8.195111278,-0.005463578809,50.72482766}, /*cmz*/
          {2.731272929,0.9902124424,0.9031685691,4.656702127} /*cfz*/
     },
     {
          2463049.5,
          {142.9480533,-0.05957396493,3493.649516,-10.13765007,0.05331374147,51.01355632}, /*cmx*/
          {2.639834152,4.09812878,4.09667491,-0.05626757799}, /*cfx*/
          {38.21967092,0.05426020648,1188.33863,-3.42522007,0.01793798331,16.4162725}, /*cmy*/
          {1.810449887,2.653994718,-9.908390763,5.388013104}, /*cfy*/
          {-46.10711516,-0.05261485932,3483.658691,9.001168464,-0.04739083619,51.31517273}, /*cmz*/
          {4.147516657,2.479481374,2.468478034,1.477911208} /*cfz*/
     },
     {
          2463149.5,
          {109.6880673,0.3904368387,3452.792273,5.820901304,-0.01637219837,49.87267823}, /*cmx*/
          {4.118137397,5.555612811,5.06888464,3.47138576}, /*cfx*/
          {15.46136744,0.3614514728,1031.28549,2.978810066,-0.01153314699,17.94929646}, /*cmy*/
          {3.318643476,3.990110293,-2.500815547,2.538713749}, /*cfy*/
          {13.45315522,-0.8255434381,3400.437911,-7.664251773,0.02989586988,51.88188813}, /*cmz*/
          {5.625098075,3.822009409,3.591817703,4.896655221} /*cfz*/
     },
     {
          2463249.5,
          {98.83644488,0.4114692784,3487.063887,1.442454467,-0.03940864228,46.14945076}, /*cmx*/
          {5.904057763,1.533329988,1.220776224,0.2900416535}, /*cfx*/
          {45.78669606,-0.03603187958,1175.810975,0.6577556694,-0.01536693251,14.95309813}, /*cmy*/
          {5.092054835,5.367786177,5.924085257,5.779115069}, /*cfy*/
          {-75.69038462,0.3106879216,3472.900673,-1.828889493,0.04054575489,45.425942}, /*cmz*/
          {1.128978267,6.024743909,5.869980602,1.78251425} /*cfz*/
     },
     {
          2463349.5,
          {102.2653822,0.5684870359,3503.835151,8.431760573,0.006328807243,49.07049146}, /*cmx*/
          {1.177485077,5.744318913,2.292621677,3.381753418}, /*cfx*/
          {33.14056201,-0.003153563129,1169.663218,3.801481227,0.006752561281,15.313399}, /*cmy*/
          {0.3519330068,-1.985540382,1.518938694,2.463751901}, /*cfy*/
          {-25.60861857,-0.00108105785,3519.981486,-9.522217688,-0.01654278044,51.89511245}, /*cmz*/
          {2.708367111,4.11678158,0.9494618617,4.880905379} /*cfz*/
     },
     {
          2463449.5,
          {138.2941646,0.1164460386,3492.952803,7.646885457,0.05044641367,51.06764722}, /*cmx*/
          {2.583146612,1.031890576,10.45481837,0.2625109589}, /*cfx*/
          {30.03797444,-0.03621024265,958.8978848,3.09976723,0.02052807309,13.47755734}, /*cmy*/
          {1.759936072,5.591159786,2.465961463,5.646974695}, /*cfy*/
          {-19.5262392,0.1115126923,3492.909279,-7.607684205,-0.05039217543,50.53954402}, /*cmz*/
          {4.120885984,5.709908302,2.58423704,1.775213495} /*cfz*/
     },
     {
          2463549.5,
          {128.0814622,0.2777295837,3499.977195,-8.19256744,-0.03583584777,49.63414682}, /*cmx*/
          {4.127366132,2.573810991,5.636204277,3.713133286}, /*cfx*/
          {10.31562123,0.2635946741,836.2695713,-3.712428952,-0.01763544253,14.98343596}, /*cmy*/
          {3.312973075,0.7678898304,3.886213703,2.800390557}, /*cfy*/
          {29.26777926,-0.6131690894,3448.46884,8.755358166,0.04226562734,49.34359315}, /*cmz*/
          {5.659959634,0.8412770749,3.909833966,5.167931147} /*cfz*/
     },
     {
          2463649.5,
          {111.9221729,0.4078295121,3522.294143,1.88915291,-0.02817233876,46.79495755}, /*cmx*/
          {5.91537974,4.075057535,1.182890481,0.527518996}, /*cfx*/
          {39.71248521,-0.1587595535,1013.349463,0.6760375038,-0.01271976977,12.14080224}, /*cmy*/
          {5.080528022,3.362705862,5.536466937,6.037155254}, /*cfy*/
          {-44.7468222,0.4303276056,3494.747997,-1.019343714,0.03088346432,45.64819555}, /*cmz*/
          {1.155343282,2.552204389,5.836846985,2.041059549} /*cfz*/
     },
     {
          2463749.5,
          {113.7187284,0.4812237991,3549.318926,9.306257475,0.01842328954,50.48092631}, /*cmx*/
          {1.129129596,5.671959485,2.357409544,3.602641873}, /*cfx*/
          {21.91989844,-0.08480567116,920.712101,4.159824826,0.01015708825,11.35809229}, /*cmy*/
          {0.2801600375,-2.31746247,1.005805799,2.585324315}, /*cfy*/
          {17.79580497,-0.0117742093,3557.310397,-10.35828885,-0.02733831613,52.93261455}, /*cmz*/
          {2.682853521,4.08671625,0.9199183597,5.113616174} /*cfz*/
     },
     {
          2463849.5,
          {115.4522908,0.3840158789,3487.745346,4.022393152,0.03808595112,51.95231507}, /*cmx*/
          {2.533971992,1.323848212,4.340184583,0.6010819497}, /*cfx*/
          {25.74623223,-0.1712250888,647.2170824,2.284061779,0.01953107345,10.43937205}, /*cmy*/
          {1.713953914,5.656508148,2.443710322,5.910779425}, /*cfy*/
          {6.199073499,0.2832083527,3502.798384,-5.243128387,-0.04588438211,49.23005957}, /*cmz*/
          {4.101990457,5.885379979,2.730209606,2.109993255} /*cfz*/
     },
     {
          2463949.5,
          {139.1485234,0.1364432347,3537.632225,-8.423533234,-0.04836995558,48.91436052}, /*cmx*/
          {4.159579592,2.655766751,5.784865011,3.920995211}, /*cfx*/
          {8.570877454,0.104873772,617.9724513,-3.63445895,-0.02104381048,10.86723657}, /*cmy*/
          {3.298140023,0.6486031985,3.814114011,3.064957733}, /*cfy*/
          {36.05045947,-0.2664604479,3501.043669,8.043574739,0.04738911223,47.74143783}, /*cmz*/
          {5.71440349,0.9762231666,4.101870312,5.435412679} /*cfz*/
     },
     {
          2464049.5,
          {120.797781,0.2964001885,3558.205649,4.505181516,-0.01616945572,48.17906673}, /*cmx*/
          {5.911829855,4.210861316,1.077533131,0.7697325239}, /*cfx*/
          {29.94780377,-0.2430425555,770.2189045,1.491197695,-0.009042792289,8.440443368}, /*cmy*/
          {5.028764688,2.55141957,5.173655679,-0.02763050257}, /*cfy*/
          {-10.25219679,0.5242097384,3525.1249,-3.284516676,0.02154115239,46.62761785}, /*cmz*/
          {1.169084877,2.684256469,5.777984314,2.302631557} /*cfz*/
     },
     {
          2464149.5,
          {114.5288692,0.3598188567,3585.045856,9.565735122,0.02981287215,51.71430573}, /*cmx*/
          {1.086804843,5.611552461,2.359269165,3.840986329}, /*cfx*/
          {10.22055289,-0.1116866335,585.5647045,4.191933988,0.01341535009,6.57562208}, /*cmy*/
          {0.1698863508,3.636959745,0.5301711211,2.585533456}, /*cfy*/
          {60.84372699,-0.04524698934,3590.609021,-10.69076795,-0.03750035802,53.44504455}, /*cmz*/
          {2.659746377,4.055499427,0.8929581351,5.362309563} /*cfz*/
     },
     {
          2464249.5,
          {84.12721278,0.6482795415,3478.880374,2.347682273,0.02113607139,52.91396301}, /*cmx*/
          {2.506689273,15.39884454,4.832949483,0.9272898211}, /*cfx*/
          {25.49927992,-0.3079783791,298.8268855,1.569408226,0.01501728609,7.22076319}, /*cmy*/
          {1.646651641,6.345858155,2.662037472,6.162480938}, /*cfy*/
          {32.95948846,0.3975453332,3512.982265,-2.303642048,-0.0328468721,48.05462834}, /*cmz*/
          {4.094280369,6.452996436,2.950226469,2.471780832} /*cfz*/
     },
     {
          2464349.5,
          {140.6177745,0.0009776326911,3559.21808,6.709675963,0.0499438406,48.1572405}, /*cmx*/
          {4.209158878,-0.4368419976,2.698217289,4.137815725}, /*cfx*/
          {7.158162477,-0.03184883968,386.6345139,2.778111304,0.02070202822,6.236414847}, /*cmy*/
          {3.228060841,3.651216636,6.809524487,3.347693109}, /*cfy*/
          {44.22024561,0.06803175479,3543.964594,-6.060005916,0.04597003998,47.40648746}, /*cmz*/
          {5.778085168,-71.16174283,4.22650175,5.703843735} /*cfz*/
     },
     {
          2464449.5,
          {119.0937363,0.1580920265,3587.038699,-6.412721937,0.005106417403,49.96951303}, /*cmx*/
          {5.903492102,1.060437261,3.962927308,1.016546777}, /*cfx*/
          {19.01518673,-0.248630267,462.9683438,-2.333790544,0.004227009104,3.944183892}, /*cmy*/
          {4.895502612,5.223031448,1.667208712,0.039314959}, /*cfy*/
          {24.7769698,0.5868309082,3556.921171,5.010353235,0.01286627564,47.89413624}, /*cmz*/
          {1.17476893,-0.4801087956,5.733917095,2.565908789} /*cfz*/
     },
     {
          2464549.5,
          {106.8709039,0.2122110413,3594.097756,-9.254147736,-0.03924657116,52.44481674}, /*cmx*/
          {1.060146017,2.451799054,5.542724893,4.103806533}, /*cfx*/
          {1.920839256,-0.08297273342,219.1270243,-4.001904802,-0.01723763257,2.918579703}, /*cmy*/
          {-0.1597012062,0.1936175251,3.297190693,1.943038274}, /*cfy*/
          {96.68510981,-0.0612928858,3603.012436,10.33637031,-0.04557848235,53.14401081}, /*cmz*/
          {2.640766302,0.9003278613,0.8910714618,5.638690389} /*cfz*/
     },
     {
          2464649.5,
          {57.08267414,0.7850506558,3472.009251,5.256056828,-0.01767071278,52.75490328}, /*cmx*/
          {2.511619424,3.613629297,2547.670688,1.224967249}, /*cfx*/
          {25.70647649,-0.3803801476,-55.64888106,2.26061812,-0.01147802056,3.59150889}, /*cmy*/
          {2.452579989,26.0080552,19.01850015,6.344333449}, /*cfy*/
          {62.37292359,0.4040977917,3523.786541,-2.715130945,-0.01532191206,47.86520732}, /*cmz*/
          {4.102516303,1.9436296,3.562917435,2.825709171} /*cfz*/
     },
     {
          2464749.5,
          {132.7321418,-0.1190428377,3566.361448,3.999781296,0.0438332692,47.68316026}, /*cmx*/
          {4.266655674,5.88032277,21.56067502,4.386978161}, /*cfx*/
          {4.215266965,-0.08199431927,158.6580682,1.483546923,-0.01758280495,1.601722465}, /*cmy*/
          {9.084630529,3.480056033,-568.309292,3.709249328}, /*cfy*/
          {59.62368205,0.2904763677,3569.942847,-3.474301815,-0.0403553427,47.7926493}, /*cmz*/
          {5.841486029,4.347917586,7.430430023,5.974616105} /*cfz*/
     },
     {
          2464849.5,
          {104.0273031,0.06042033559,3601.832317,-7.724112347,-0.005468152837,51.70900456}, /*cmx*/
          {5.899402869,1.023785557,4.309598716,1.268395901}, /*cfx*/
          {11.65703401,-0.1917988157,154.9774555,-3.103864186,0.001505199639,-1.996333848}, /*cmy*/
          {4.210376127,4.862334412,-1.253034124,1.316557897}, /*cfy*/
          {57.17930492,0.614098224,3580.683079,6.341161933,-0.004136040084,49.17806858}, /*cmz*/
          {1.176452342,5.749494081,2.774435131,2.830034363} /*cfz*/
     },
     {
          2464949.5,
          {94.60303309,0.03580569606,3572.241956,-8.321842308,0.04531452556,52.26803488}, /*cmx*/
          {1.051655416,2.497962988,2.496068551,4.393546181}, /*cfx*/
          {-1.144969434,-0.01657002073,-202.5974493,-3.55544943,0.02034008874,-4.529426954}, /*cmy*/
          {7.022464954,-0.03107243149,-6.348497798,4.125225829}, /*cfy*/
          {118.4414401,-0.004554897543,3582.307505,8.935976782,-0.04864188568,52.16931081}, /*cmz*/
          {2.625288119,0.9325370716,7.219037058,5.953502202} /*cfz*/
     },
     {
          2465049.5,
          {42.25546414,0.7221993475,3472.127716,7.355161093,-0.02964464139,51.38958808}, /*cmx*/
          {2.551717621,3.848023758,3.660706802,1.504204588}, /*cfx*/
          {23.03940578,-0.3447232037,-345.2405393,3.19671301,-0.01386036546,-1.044187457}, /*cmy*/
          {1.934952756,1.147276519,0.8647461774,1.473122295}, /*cfy*/
          {92.93974565,0.3106838441,3532.048282,-5.614746856,0.01761525253,48.54364609}, /*cmz*/
          {4.131608284,2.395694646,2.045490288,3.13496681} /*cfz*/
     },
     {
          2465149.5,
          {117.1722167,-0.228031252,3561.472801,1.218869964,-0.03488856267,47.65089133}, /*cmx*/
          {4.324610026,5.928970177,5.843314196,4.663146555}, /*cfx*/
          {1.187765221,-0.03978712791,-187.8125608,0.1687839735,-0.01344762417,-2.894248033}, /*cmy*/
          {4.18218192,2.824850156,3.184521934,3.830588161}, /*cfy*/
          {80.95990153,0.3828921449,3578.570348,-0.8143193198,0.0327118667,48.22339344}, /*cmz*/
          {5.898622969,4.655600506,4.293965736,-0.03441343581} /*cfz*/
     },
     {
          2465249.5,
          {77.19473611,0.02764329872,3600.312333,-8.687827527,0.01580229961,53.0685139}, /*cmx*/
          {5.90375915,26.12046981,0.9711642618,1.525288555}, /*cfx*/
          {11.14599273,-0.1130819761,-293.4402947,3.716834718,0.007248404669,-6.991270899}, /*cmy*/
          {5.553831686,1.4324855,4.537181424,1.019839344}, /*cfy*/
          {84.58884994,0.5994479152,3588.455488,7.446501077,-0.00653381642,50.30202863}, /*cmz*/
          {1.17653131,5.693286666,5.290491031,3.09616766} /*cfz*/
     },
     {
          2465349.5,
          {79.43636363,-0.1477438825,3529.020669,-6.604969532,0.04595321568,50.77862815}, /*cmx*/
          {1.058547424,2.620173841,2.63659002,4.710772003}, /*cfx*/
          {0.8358457135,0.06149577406,-527.1566122,2.68841978,0.02037073733,-7.290648533}, /*cmy*/
          {0.4149878008,3.006823104,6.127149896,4.106396166}, /*cfy*/
          {122.3555692,0.1628967935,3529.105863,6.243060694,-0.04364206484,51.18795278}, /*cmz*/
          {2.61294667,1.07145478,26.19222112,0.02189361895} /*cfz*/
     },
     {
          2465449.5,
          {38.29169407,0.4874542647,3478.86752,7.762056957,-0.03822220538,49.74461605}, /*cmx*/
          {2.621535429,4.019792137,3.96204547,1.783355595}, /*cfx*/
          {18.04482088,-0.2152664404,-593.0270696,-3.426139919,-0.01745029075,-5.118572417}, /*cmy*/
          {1.961945695,4.389555675,1.169112458,1.066343059}, /*cfy*/
          {119.9164999,0.180480245,3532.254531,-7.339846758,0.03386992136,49.28864359}, /*cmz*/
          {4.183443232,2.56532423,2.504996091,3.398358819} /*cfz*/
     },
     {
          2465549.5,
          {95.98716234,-0.3326910648,3546.516155,-1.178058175,-0.0261071611,47.81965122}, /*cmx*/
          {4.379247484,5.854159363,5.827163976,4.95059387}, /*cfx*/
          {0.9791154642,0.05706379926,-445.5192251,0.9858856875,-0.009557142283,-7.124516844}, /*cmy*/
          {3.841931309,6.434663868,2.830965881,4.152565507}, /*cfy*/
          {102.8610675,0.3791742015,3573.06347,1.803255604,0.02417392897,48.55348908}, /*cmz*/
          {5.946721961,4.17835842,4.257995147,0.2436748027} /*cfz*/
     },
     {
          2465649.5,
          {42.95563498,0.04674231591,3583.687454,-9.413227239,0.02677487339,53.6652841}, /*cmx*/
          {5.915771155,-11.5973819,0.9295190805,1.789108834}, /*cfx*/
          {17.2714787,-0.04365119995,-611.7322153,-4.05864977,0.01252659033,-11.73779311}, /*cmy*/
          {5.302030165,-1.944897814,4.323031326,1.169711314}, /*cfy*/
          {106.2453462,0.5293525092,3576.315071,8.367812078,-0.01832110358,51.2310917}, /*cmz*/
          {1.176134513,5.660169283,5.465727555,3.365477872} /*cfz*/
     },
     {
          2465749.5,
          {59.47915735,-0.2780118834,3481.806909,-3.999413509,0.03891353557,48.17432426}, /*cmx*/
          {1.076909814,-3.416956244,2.820254961,5.058769843}, /*cfx*/
          {6.937703503,0.1230567874,-805.9316053,-1.422169587,0.01614804188,-9.307681786}, /*cmy*/
          {0.3523236917,6.286089384,6.149906917,4.318048745}, /*cfy*/
          {111.3803531,0.4162090138,3460.727648,2.881725439,-0.03062850347,50.76063365}, /*cmz*/
          {2.60692461,1.652548804,1.354446283,0.3805185186} /*cfz*/
     },
     {
          2465849.5,
          {37.28083731,0.1796921397,3486.001693,6.762576313,-0.04094305292,48.6593227}, /*cmx*/
          {2.710030505,4.186147852,4.175076045,2.073314632}, /*cfx*/
          {14.3646369,-0.0497747813,-795.5984291,2.872616324,-0.01831563447,-9.290151303}, /*cmy*/
          {2.024825402,1.280783563,1.261320928,1.305797854}, /*cfy*/
          {138.6247999,0.07738314701,3522.119552,7.277168051,0.04361561849,49.36981764}, /*cmz*/
          {4.254351274,5.813157838,2.66167228,3.641908164} /*cfz*/
     },
     {
          2465949.5,
          {70.98200964,-0.435941243,3524.400981,-3.135861946,-0.01812263709,47.92005014}, /*cmx*/
          {4.428799233,5.893426069,5.821058663,5.240868604}, /*cfx*/
          {5.196422015,0.1627730614,-710.558652,-1.808039264,-0.006257329103,-10.99530096}, /*cmy*/
          {3.771084682,3.040287082,2.391544615,4.447948545}, /*cfy*/
          {119.571127,0.3268671589,3558.194224,-4.1272554,0.01471700474,48.92280345}, /*cmz*/
          {5.98491429,1.114756771,4.20474884,0.5226461772} /*cfz*/
     },
     {
          2466049.5,
          {7.445988485,0.07520941307,3552.399952,-9.72223293,0.0372846389,53.1736527}, /*cmx*/
          {5.931475157,0.9819630996,0.9549886761,2.066719353}, /*cfx*/
          {27.1046635,0.003919157494,-891.0944817,-4.01308721,0.0163847066,-15.30647778}, /*cmy*/
          {5.223201219,4.138242221,4.147565776,1.379518456}, /*cfy*/
          {123.0088459,0.3858848886,3545.195884,-8.95399195,-0.0310102978,51.77048294}, /*cmz*/
          {1.176051353,2.529516543,5.576932238,3.638974968} /*cfz*/
     },
     {
          2466149.5,
          {32.1046385,-0.2951365317,3446.397766,1.31704417,0.02377186009,45.80834879}, /*cmx*/
          {1.105797861,13.44160762,3.113107099,5.429075891}, /*cfx*/
          {15.99753308,0.1505884576,-1018.826812,-0.7454911787,0.008958533791,-11.06741435}, /*cmy*/
          {0.3491107585,13.99281094,6.402957372,4.620370702}, /*cfy*/
          {95.54256362,0.652240809,3403.787726,3.348249032,-0.01790846547,50.366678}, /*cmz*/
          {2.61540514,3.27009112,2.195132877,0.7103201324} /*cfz*/
     }

};

static unsigned idn_list[] = {2,135,209,279,353,435,540,997};
static double freq_list[] = {6.667,4.586,3.328,2.296,1.391,0.394,0.2953,0.0792};
static double delt_list[] = {55.0,100.0,105.0,100.0,90.0,70.0,16.0,100.0};

BDL_Dataset saturne_2040 = {
     8, /*nsat*/
     2458849.5, /*djj*/
     idn_list,
     freq_list,
     delt_list,
     moonrecords
};
