.\"
.\" Copyright (c) Mark J. Kilgard, 1996, 1998, 1999.
.\"
.\" See the file "man/LICENSE" for information on usage and redistribution
.\"
.TH glutVideoResizeGet 3 "November 2025" "freeglut" "freeglut"
.SH NAME
glutVideoResizeGet - retrieves GLUT video resize information represented by integers.
.SH WARNING
Not yet implemented in freeglut.
.SH SYNTAX
.nf
.LP
int glutVideoResizeGet(GLenum param);
.fi
.SH ARGUMENTS
.IP \fIparam\fP 1i
Name of video resize information to retrieve.
.TP 8
.B GLUT_VIDEO_RESIZE_POSSIBLE
Non-zero if video resizing is supported by the underlying system; zero
if not supported.  If this is zero, the other video resize GLUT calls
do nothing when called.  See the Implementation Notes sections below.
.TP 8
.B GLUT_VIDEO_RESIZE_IN_USE
.TP 8
.B GLUT_VIDEO_RESIZE_X_DELTA
.TP 8
.B GLUT_VIDEO_RESIZE_Y_DELTA
.TP 8
.B GLUT_VIDEO_RESIZE_WIDTH_DELTA
.TP 8
.B GLUT_VIDEO_RESIZE_HEIGHT_DELTA
.TP 8
.B GLUT_VIDEO_RESIZE_X
.TP 8
.B GLUT_VIDEO_RESIZE_Y
.TP 8
.B GLUT_VIDEO_RESIZE_WIDTH
.TP 8
.B GLUT_VIDEO_RESIZE_HEIGHT
.SH DESCRIPTION
glutVideoResizeGet retrieves GLUT video resizing information represented by integers. The param
parameter determines what type of video resize information to return.
.SH X IMPLEMENTATION NOTES
The current implementation uses the SGIX_video_resize GLX extension.
This extension is currently supported on SGI's InfiniteReality-based systems.
.SH WIN32 IMPLEMENTATION NOTES
The current implementation never reports that video resizing is possible.
.SH SEE ALSO
glutGet, glutSetupVideoResizing, glutStopVideoResizing, glutVideoResize, glutVideoPan
.SH AUTHOR
Mark J. Kilgard (mjk@nvidia.com)
