/*
 * meta.c - libvlc smoke test
 *
 */

/**********************************************************************
 *  Copyright (C) 2007 Rémi Denis-Courmont.                           *
 *  Copyright (C) 2008 Pierre d'Herbemont.                            *
 *  This program is free software; you can redistribute and/or modify *
 *  it under the terms of the GNU General Public License as published *
 *  by the Free Software Foundation; version 2 of the license, or (at *
 *  your option) any later version.                                   *
 *                                                                    *
 *  This program is distributed in the hope that it will be useful,   *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.              *
 *  See the GNU General Public License for more details.              *
 *                                                                    *
 *  You should have received a copy of the GNU General Public License *
 *  along with this program; if not, you can get it from:             *
 *  http://www.gnu.org/copyleft/gpl.html                              *
 **********************************************************************/

#include <string.h>

#include "test.h"
#include "media_utils.h"

#include <vlc_modules.h>

static int test_meta (const char ** argv, int argc)
{
    libvlc_instance_t *vlc;
    libvlc_media_t *media;
    char * artist;

    test_log ("Testing meta\n");

    vlc = libvlc_new (argc, argv);
    assert (vlc != NULL);

    if (!module_exists("taglib"))
        return 77;

    media = libvlc_media_new_path(SRCDIR "/samples/meta.mp3");
    assert( media );

    libvlc_media_parse_sync(vlc, media, libvlc_media_parse_local, -1);

    artist = libvlc_media_get_meta (media, libvlc_meta_Artist);

    const char *expected_artist = "mike";

    assert (artist);
    test_log ("+ got '%s' as Artist, expecting %s\n", artist, expected_artist);

    int string_compare = strcmp (artist, expected_artist);
    assert (!string_compare);

    free (artist);
    libvlc_media_release (media);
    libvlc_release (vlc);

    return 0;
}


int main (void)
{
    test_init();

    return test_meta (test_defaults_args, test_defaults_nargs);
}
