# Normal Form Grapheme equanity tests, generated from NormalizationTests.txt in
# the Unicode database by S15-nfg/mass-equality-gen.raku. Check strings that should come
# out equal under NFG do, and strings that are "tempting" to make equal but
# should not be don't. The "should not be" falls out of the definition of NFD,
# of note the notion of blocked swaps in canonical sorting.

use Test;

plan 500;

is Uni.new(0x0044, 0x0323, 0x0307).Str, Uni.new(0x44, 0x307, 0x323).Str, '0x0044, 0x0323, 0x0307 vs. 0x44, 0x307, 0x323';
is Uni.new(0x0044, 0x0323, 0x0307).Str, Uni.new(0x44, 0x307, 0x323).Str, '0x0044, 0x0323, 0x0307 vs. 0x44, 0x307, 0x323';
is Uni.new(0x0044, 0x0323, 0x0307).Str, Uni.new(0x44, 0x307, 0x323).Str, '0x0044, 0x0323, 0x0307 vs. 0x44, 0x307, 0x323';
is Uni.new(0x0044, 0x0323, 0x0307).Str, Uni.new(0x44, 0x307, 0x323).Str, '0x0044, 0x0323, 0x0307 vs. 0x44, 0x307, 0x323';
is Uni.new(0x0044, 0x031B, 0x0307).Str, Uni.new(0x44, 0x307, 0x31B).Str, '0x0044, 0x031B, 0x0307 vs. 0x44, 0x307, 0x31B';
is Uni.new(0x0044, 0x031B, 0x0323).Str, Uni.new(0x44, 0x323, 0x31B).Str, '0x0044, 0x031B, 0x0323 vs. 0x44, 0x323, 0x31B';
is Uni.new(0x0044, 0x031B, 0x0323, 0x0307).Str, Uni.new(0x44, 0x323, 0x31B, 0x307).Str, '0x0044, 0x031B, 0x0323, 0x0307 vs. 0x44, 0x323, 0x31B, 0x307';
is Uni.new(0x0044, 0x031B, 0x0323, 0x0307).Str, Uni.new(0x44, 0x323, 0x31B, 0x307).Str, '0x0044, 0x031B, 0x0323, 0x0307 vs. 0x44, 0x323, 0x31B, 0x307';
is Uni.new(0x0044, 0x031B, 0x0323, 0x0307).Str, Uni.new(0x44, 0x323, 0x31B, 0x307).Str, '0x0044, 0x031B, 0x0323, 0x0307 vs. 0x44, 0x323, 0x31B, 0x307';
is Uni.new(0x0044, 0x031B, 0x0323, 0x0307).Str, Uni.new(0x44, 0x323, 0x31B, 0x307).Str, '0x0044, 0x031B, 0x0323, 0x0307 vs. 0x44, 0x323, 0x31B, 0x307';
isnt Uni.new(0x0045, 0x0304, 0x0300, 0x0304).Str, Uni.new(0x45, 0x300, 0x304, 0x304).Str, '0x0045, 0x0304, 0x0300, 0x0304 vs. 0x45, 0x300, 0x304, 0x304';
isnt Uni.new(0x0045, 0x0300, 0x0304).Str, Uni.new(0x45, 0x304, 0x300).Str, '0x0045, 0x0300, 0x0304 vs. 0x45, 0x304, 0x300';
is Uni.new(0x05B1, 0x05B8, 0x05B9, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F).Str, Uni.new(0x5B8, 0x5B1, 0x591, 0x5B9, 0x5C3, 0x5AC, 0x5B0, 0x59F).Str, '0x05B1, 0x05B8, 0x05B9, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F vs. 0x5B8, 0x5B1, 0x591, 0x5B9, 0x5C3, 0x5AC, 0x5B0, 0x59F';
is Uni.new(0x05B0, 0x05B7, 0x05BC, 0x05A5, 0x0592, 0x05C0, 0x05AD, 0x05C4).Str, Uni.new(0x5B7, 0x5B0, 0x5A5, 0x5BC, 0x592, 0x5C0, 0x5C4, 0x5AD).Str, '0x05B0, 0x05B7, 0x05BC, 0x05A5, 0x0592, 0x05C0, 0x05AD, 0x05C4 vs. 0x5B7, 0x5B0, 0x5A5, 0x5BC, 0x592, 0x5C0, 0x5C4, 0x5AD';
isnt Uni.new(0x0308, 0x0301).Str, Uni.new(0x301, 0x308).Str, '0x0308, 0x0301 vs. 0x301, 0x308';
is Uni.new(0x0915, 0x093C).Str, Uni.new(0x915, 0x93C).Str, '0x0915, 0x093C vs. 0x915, 0x93C';
is Uni.new(0x0916, 0x093C).Str, Uni.new(0x916, 0x93C).Str, '0x0916, 0x093C vs. 0x916, 0x93C';
is Uni.new(0x0917, 0x093C).Str, Uni.new(0x917, 0x93C).Str, '0x0917, 0x093C vs. 0x917, 0x93C';
is Uni.new(0x091C, 0x093C).Str, Uni.new(0x91C, 0x93C).Str, '0x091C, 0x093C vs. 0x91C, 0x93C';
is Uni.new(0x0921, 0x093C).Str, Uni.new(0x921, 0x93C).Str, '0x0921, 0x093C vs. 0x921, 0x93C';
is Uni.new(0x0922, 0x093C).Str, Uni.new(0x922, 0x93C).Str, '0x0922, 0x093C vs. 0x922, 0x93C';
is Uni.new(0x092B, 0x093C).Str, Uni.new(0x92B, 0x93C).Str, '0x092B, 0x093C vs. 0x92B, 0x93C';
is Uni.new(0x092F, 0x093C).Str, Uni.new(0x92F, 0x93C).Str, '0x092F, 0x093C vs. 0x92F, 0x93C';
is Uni.new(0x09A1, 0x09BC).Str, Uni.new(0x9A1, 0x9BC).Str, '0x09A1, 0x09BC vs. 0x9A1, 0x9BC';
is Uni.new(0x09A2, 0x09BC).Str, Uni.new(0x9A2, 0x9BC).Str, '0x09A2, 0x09BC vs. 0x9A2, 0x9BC';
is Uni.new(0x09AF, 0x09BC).Str, Uni.new(0x9AF, 0x9BC).Str, '0x09AF, 0x09BC vs. 0x9AF, 0x9BC';
is Uni.new(0x0A32, 0x0A3C).Str, Uni.new(0xA32, 0xA3C).Str, '0x0A32, 0x0A3C vs. 0xA32, 0xA3C';
is Uni.new(0x0A38, 0x0A3C).Str, Uni.new(0xA38, 0xA3C).Str, '0x0A38, 0x0A3C vs. 0xA38, 0xA3C';
is Uni.new(0x0A16, 0x0A3C).Str, Uni.new(0xA16, 0xA3C).Str, '0x0A16, 0x0A3C vs. 0xA16, 0xA3C';
is Uni.new(0x0A17, 0x0A3C).Str, Uni.new(0xA17, 0xA3C).Str, '0x0A17, 0x0A3C vs. 0xA17, 0xA3C';
is Uni.new(0x0A1C, 0x0A3C).Str, Uni.new(0xA1C, 0xA3C).Str, '0x0A1C, 0x0A3C vs. 0xA1C, 0xA3C';
is Uni.new(0x0A2B, 0x0A3C).Str, Uni.new(0xA2B, 0xA3C).Str, '0x0A2B, 0x0A3C vs. 0xA2B, 0xA3C';
is Uni.new(0x0B21, 0x0B3C).Str, Uni.new(0xB21, 0xB3C).Str, '0x0B21, 0x0B3C vs. 0xB21, 0xB3C';
is Uni.new(0x0B22, 0x0B3C).Str, Uni.new(0xB22, 0xB3C).Str, '0x0B22, 0x0B3C vs. 0xB22, 0xB3C';
is Uni.new(0x0F71, 0x0F72).Str, Uni.new(0xF72, 0xF71).Str, '0x0F71, 0x0F72 vs. 0xF72, 0xF71';
is Uni.new(0x0F71, 0x0F74).Str, Uni.new(0xF74, 0xF71).Str, '0x0F71, 0x0F74 vs. 0xF74, 0xF71';
is Uni.new(0x0FB2, 0x0F80).Str, Uni.new(0xFB2, 0xF80).Str, '0x0FB2, 0x0F80 vs. 0xFB2, 0xF80';
is Uni.new(0x0FB3, 0x0F80).Str, Uni.new(0xFB3, 0xF80).Str, '0x0FB3, 0x0F80 vs. 0xFB3, 0xF80';
is Uni.new(0x0F71, 0x0F80).Str, Uni.new(0xF80, 0xF71).Str, '0x0F71, 0x0F80 vs. 0xF80, 0xF71';
is Uni.new(0x2ADD, 0x0338).Str, Uni.new(0x2ADD, 0x338).Str, '0x2ADD, 0x0338 vs. 0x2ADD, 0x338';
is Uni.new(0x05D9, 0x05B4).Str, Uni.new(0x5D9, 0x5B4).Str, '0x05D9, 0x05B4 vs. 0x5D9, 0x5B4';
is Uni.new(0x05F2, 0x05B7).Str, Uni.new(0x5F2, 0x5B7).Str, '0x05F2, 0x05B7 vs. 0x5F2, 0x5B7';
is Uni.new(0x05E9, 0x05C1).Str, Uni.new(0x5E9, 0x5C1).Str, '0x05E9, 0x05C1 vs. 0x5E9, 0x5C1';
is Uni.new(0x05E9, 0x05C2).Str, Uni.new(0x5E9, 0x5C2).Str, '0x05E9, 0x05C2 vs. 0x5E9, 0x5C2';
is Uni.new(0x05E9, 0x05BC, 0x05C1).Str, Uni.new(0x5E9, 0x5C1, 0x5BC).Str, '0x05E9, 0x05BC, 0x05C1 vs. 0x5E9, 0x5C1, 0x5BC';
is Uni.new(0x05E9, 0x05BC, 0x05C2).Str, Uni.new(0x5E9, 0x5C2, 0x5BC).Str, '0x05E9, 0x05BC, 0x05C2 vs. 0x5E9, 0x5C2, 0x5BC';
is Uni.new(0x05D0, 0x05B7).Str, Uni.new(0x5D0, 0x5B7).Str, '0x05D0, 0x05B7 vs. 0x5D0, 0x5B7';
is Uni.new(0x05D0, 0x05B8).Str, Uni.new(0x5D0, 0x5B8).Str, '0x05D0, 0x05B8 vs. 0x5D0, 0x5B8';
is Uni.new(0x05D0, 0x05BC).Str, Uni.new(0x5D0, 0x5BC).Str, '0x05D0, 0x05BC vs. 0x5D0, 0x5BC';
is Uni.new(0x05D1, 0x05BC).Str, Uni.new(0x5D1, 0x5BC).Str, '0x05D1, 0x05BC vs. 0x5D1, 0x5BC';
is Uni.new(0x05D2, 0x05BC).Str, Uni.new(0x5D2, 0x5BC).Str, '0x05D2, 0x05BC vs. 0x5D2, 0x5BC';
is Uni.new(0x05D3, 0x05BC).Str, Uni.new(0x5D3, 0x5BC).Str, '0x05D3, 0x05BC vs. 0x5D3, 0x5BC';
is Uni.new(0x05D4, 0x05BC).Str, Uni.new(0x5D4, 0x5BC).Str, '0x05D4, 0x05BC vs. 0x5D4, 0x5BC';
is Uni.new(0x05D5, 0x05BC).Str, Uni.new(0x5D5, 0x5BC).Str, '0x05D5, 0x05BC vs. 0x5D5, 0x5BC';
is Uni.new(0x05D6, 0x05BC).Str, Uni.new(0x5D6, 0x5BC).Str, '0x05D6, 0x05BC vs. 0x5D6, 0x5BC';
is Uni.new(0x05D8, 0x05BC).Str, Uni.new(0x5D8, 0x5BC).Str, '0x05D8, 0x05BC vs. 0x5D8, 0x5BC';
is Uni.new(0x05D9, 0x05BC).Str, Uni.new(0x5D9, 0x5BC).Str, '0x05D9, 0x05BC vs. 0x5D9, 0x5BC';
is Uni.new(0x05DA, 0x05BC).Str, Uni.new(0x5DA, 0x5BC).Str, '0x05DA, 0x05BC vs. 0x5DA, 0x5BC';
is Uni.new(0x05DB, 0x05BC).Str, Uni.new(0x5DB, 0x5BC).Str, '0x05DB, 0x05BC vs. 0x5DB, 0x5BC';
is Uni.new(0x05DC, 0x05BC).Str, Uni.new(0x5DC, 0x5BC).Str, '0x05DC, 0x05BC vs. 0x5DC, 0x5BC';
is Uni.new(0x05DE, 0x05BC).Str, Uni.new(0x5DE, 0x5BC).Str, '0x05DE, 0x05BC vs. 0x5DE, 0x5BC';
is Uni.new(0x05E0, 0x05BC).Str, Uni.new(0x5E0, 0x5BC).Str, '0x05E0, 0x05BC vs. 0x5E0, 0x5BC';
is Uni.new(0x05E1, 0x05BC).Str, Uni.new(0x5E1, 0x5BC).Str, '0x05E1, 0x05BC vs. 0x5E1, 0x5BC';
is Uni.new(0x05E3, 0x05BC).Str, Uni.new(0x5E3, 0x5BC).Str, '0x05E3, 0x05BC vs. 0x5E3, 0x5BC';
is Uni.new(0x05E4, 0x05BC).Str, Uni.new(0x5E4, 0x5BC).Str, '0x05E4, 0x05BC vs. 0x5E4, 0x5BC';
is Uni.new(0x05E6, 0x05BC).Str, Uni.new(0x5E6, 0x5BC).Str, '0x05E6, 0x05BC vs. 0x5E6, 0x5BC';
is Uni.new(0x05E7, 0x05BC).Str, Uni.new(0x5E7, 0x5BC).Str, '0x05E7, 0x05BC vs. 0x5E7, 0x5BC';
is Uni.new(0x05E8, 0x05BC).Str, Uni.new(0x5E8, 0x5BC).Str, '0x05E8, 0x05BC vs. 0x5E8, 0x5BC';
is Uni.new(0x05E9, 0x05BC).Str, Uni.new(0x5E9, 0x5BC).Str, '0x05E9, 0x05BC vs. 0x5E9, 0x5BC';
is Uni.new(0x05EA, 0x05BC).Str, Uni.new(0x5EA, 0x5BC).Str, '0x05EA, 0x05BC vs. 0x5EA, 0x5BC';
is Uni.new(0x05D5, 0x05B9).Str, Uni.new(0x5D5, 0x5B9).Str, '0x05D5, 0x05B9 vs. 0x5D5, 0x5B9';
is Uni.new(0x05D1, 0x05BF).Str, Uni.new(0x5D1, 0x5BF).Str, '0x05D1, 0x05BF vs. 0x5D1, 0x5BF';
is Uni.new(0x05DB, 0x05BF).Str, Uni.new(0x5DB, 0x5BF).Str, '0x05DB, 0x05BF vs. 0x5DB, 0x5BF';
is Uni.new(0x05E4, 0x05BF).Str, Uni.new(0x5E4, 0x5BF).Str, '0x05E4, 0x05BF vs. 0x5E4, 0x5BF';
is Uni.new(0x1D157, 0x1D165).Str, Uni.new(0x1D157, 0x1D165).Str, '0x1D157, 0x1D165 vs. 0x1D157, 0x1D165';
is Uni.new(0x1D158, 0x1D165).Str, Uni.new(0x1D158, 0x1D165).Str, '0x1D158, 0x1D165 vs. 0x1D158, 0x1D165';
isnt Uni.new(0x1D158, 0x1D165, 0x1D16E).Str, Uni.new(0x1D158, 0x1D16E, 0x1D165).Str, '0x1D158, 0x1D165, 0x1D16E vs. 0x1D158, 0x1D16E, 0x1D165';
isnt Uni.new(0x1D158, 0x1D165, 0x1D16F).Str, Uni.new(0x1D158, 0x1D16F, 0x1D165).Str, '0x1D158, 0x1D165, 0x1D16F vs. 0x1D158, 0x1D16F, 0x1D165';
isnt Uni.new(0x1D158, 0x1D165, 0x1D170).Str, Uni.new(0x1D158, 0x1D170, 0x1D165).Str, '0x1D158, 0x1D165, 0x1D170 vs. 0x1D158, 0x1D170, 0x1D165';
isnt Uni.new(0x1D158, 0x1D165, 0x1D171).Str, Uni.new(0x1D158, 0x1D171, 0x1D165).Str, '0x1D158, 0x1D165, 0x1D171 vs. 0x1D158, 0x1D171, 0x1D165';
isnt Uni.new(0x1D158, 0x1D165, 0x1D172).Str, Uni.new(0x1D158, 0x1D172, 0x1D165).Str, '0x1D158, 0x1D165, 0x1D172 vs. 0x1D158, 0x1D172, 0x1D165';
is Uni.new(0x1D1B9, 0x1D165).Str, Uni.new(0x1D1B9, 0x1D165).Str, '0x1D1B9, 0x1D165 vs. 0x1D1B9, 0x1D165';
is Uni.new(0x1D1BA, 0x1D165).Str, Uni.new(0x1D1BA, 0x1D165).Str, '0x1D1BA, 0x1D165 vs. 0x1D1BA, 0x1D165';
isnt Uni.new(0x1D1B9, 0x1D165, 0x1D16E).Str, Uni.new(0x1D1B9, 0x1D16E, 0x1D165).Str, '0x1D1B9, 0x1D165, 0x1D16E vs. 0x1D1B9, 0x1D16E, 0x1D165';
isnt Uni.new(0x1D1BA, 0x1D165, 0x1D16E).Str, Uni.new(0x1D1BA, 0x1D16E, 0x1D165).Str, '0x1D1BA, 0x1D165, 0x1D16E vs. 0x1D1BA, 0x1D16E, 0x1D165';
isnt Uni.new(0x1D1B9, 0x1D165, 0x1D16F).Str, Uni.new(0x1D1B9, 0x1D16F, 0x1D165).Str, '0x1D1B9, 0x1D165, 0x1D16F vs. 0x1D1B9, 0x1D16F, 0x1D165';
isnt Uni.new(0x1D1BA, 0x1D165, 0x1D16F).Str, Uni.new(0x1D1BA, 0x1D16F, 0x1D165).Str, '0x1D1BA, 0x1D165, 0x1D16F vs. 0x1D1BA, 0x1D16F, 0x1D165';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0301, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x301, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0301, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x301, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0301, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x301, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0301, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x301, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0302, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x302, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0302, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x302, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0302, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x302, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0302, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x302, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0303, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x303, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0303, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x303, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0303, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x303, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0303, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x303, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0304, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x304, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0304, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x304, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0304, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x304, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0304, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x304, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0305, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x305, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0305, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x305, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0305, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x305, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0305, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x305, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0306, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x306, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0306, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x306, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0306, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x306, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0306, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x306, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0307, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x307, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0307, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x307, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0307, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x307, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0307, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x307, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0308, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x308, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0308, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x308, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0308, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x308, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0308, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x308, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0309, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x309, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0309, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x309, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0309, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x309, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0309, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x309, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x030A, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x30A, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x030A, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x30A, 0x62';
is Uni.new(0x0061, 0x05AE, 0x030A, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x30A, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x030A, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x30A, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x030B, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x30B, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x030B, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x30B, 0x62';
is Uni.new(0x0061, 0x05AE, 0x030B, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x30B, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x030B, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x30B, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x030C, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x30C, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x030C, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x30C, 0x62';
is Uni.new(0x0061, 0x05AE, 0x030C, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x30C, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x030C, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x30C, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x030D, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x30D, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x030D, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x30D, 0x62';
is Uni.new(0x0061, 0x05AE, 0x030D, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x30D, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x030D, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x30D, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x030E, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x30E, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x030E, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x30E, 0x62';
is Uni.new(0x0061, 0x05AE, 0x030E, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x30E, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x030E, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x30E, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x030F, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x30F, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x030F, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x30F, 0x62';
is Uni.new(0x0061, 0x05AE, 0x030F, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x30F, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x030F, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x30F, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0310, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x310, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0310, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x310, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0310, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x310, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0310, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x310, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0311, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x311, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0311, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x311, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0311, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x311, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0311, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x311, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0312, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x312, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0312, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x312, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0312, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x312, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0312, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x312, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0313, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x313, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0313, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x313, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0313, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x313, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0313, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x313, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0314, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x314, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0314, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x314, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0314, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x314, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0314, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x314, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x0300, 0x0315, 0x0315, 0x035C, 0x0062).Str, Uni.new(0x61, 0x315, 0x300, 0x35C, 0x315, 0x62).Str, '0x0061, 0x0300, 0x0315, 0x0315, 0x035C, 0x0062 vs. 0x61, 0x315, 0x300, 0x35C, 0x315, 0x62';
is Uni.new(0x0061, 0x0300, 0x0315, 0x0315, 0x035C, 0x0062).Str, Uni.new(0x61, 0x315, 0x300, 0x35C, 0x315, 0x62).Str, '0x0061, 0x0300, 0x0315, 0x0315, 0x035C, 0x0062 vs. 0x61, 0x315, 0x300, 0x35C, 0x315, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0317, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x317, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0317, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x317, 0x62';
is Uni.new(0x0061, 0x302A, 0x0317, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x317, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0317, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x317, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0318, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x318, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0318, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x318, 0x62';
is Uni.new(0x0061, 0x302A, 0x0318, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x318, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0318, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x318, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0319, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x319, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0319, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x319, 0x62';
is Uni.new(0x0061, 0x302A, 0x0319, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x319, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0319, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x319, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x0300, 0x0315, 0x031A, 0x035C, 0x0062).Str, Uni.new(0x61, 0x315, 0x300, 0x35C, 0x31A, 0x62).Str, '0x0061, 0x0300, 0x0315, 0x031A, 0x035C, 0x0062 vs. 0x61, 0x315, 0x300, 0x35C, 0x31A, 0x62';
is Uni.new(0x0061, 0x0300, 0x031A, 0x0315, 0x035C, 0x0062).Str, Uni.new(0x61, 0x31A, 0x300, 0x35C, 0x315, 0x62).Str, '0x0061, 0x0300, 0x031A, 0x0315, 0x035C, 0x0062 vs. 0x61, 0x31A, 0x300, 0x35C, 0x315, 0x62';
is Uni.new(0x0061, 0x1DCE, 0x031B, 0x031B, 0x302A, 0x0062).Str, Uni.new(0x61, 0x31B, 0x1DCE, 0x302A, 0x31B, 0x62).Str, '0x0061, 0x1DCE, 0x031B, 0x031B, 0x302A, 0x0062 vs. 0x61, 0x31B, 0x1DCE, 0x302A, 0x31B, 0x62';
is Uni.new(0x0061, 0x1DCE, 0x031B, 0x031B, 0x302A, 0x0062).Str, Uni.new(0x61, 0x31B, 0x1DCE, 0x302A, 0x31B, 0x62).Str, '0x0061, 0x1DCE, 0x031B, 0x031B, 0x302A, 0x0062 vs. 0x61, 0x31B, 0x1DCE, 0x302A, 0x31B, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x031C, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x31C, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x031C, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x31C, 0x62';
is Uni.new(0x0061, 0x302A, 0x031C, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x31C, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x031C, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x31C, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x031D, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x31D, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x031D, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x31D, 0x62';
is Uni.new(0x0061, 0x302A, 0x031D, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x31D, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x031D, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x31D, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x031E, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x31E, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x031E, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x31E, 0x62';
is Uni.new(0x0061, 0x302A, 0x031E, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x31E, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x031E, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x31E, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x031F, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x31F, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x031F, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x31F, 0x62';
is Uni.new(0x0061, 0x302A, 0x031F, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x31F, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x031F, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x31F, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0320, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x320, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0320, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x320, 0x62';
is Uni.new(0x0061, 0x302A, 0x0320, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x320, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0320, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x320, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x0F74, 0x0321, 0x0321, 0x1DCE, 0x0062).Str, Uni.new(0x61, 0x321, 0xF74, 0x1DCE, 0x321, 0x62).Str, '0x0061, 0x0F74, 0x0321, 0x0321, 0x1DCE, 0x0062 vs. 0x61, 0x321, 0xF74, 0x1DCE, 0x321, 0x62';
is Uni.new(0x0061, 0x0F74, 0x0321, 0x0321, 0x1DCE, 0x0062).Str, Uni.new(0x61, 0x321, 0xF74, 0x1DCE, 0x321, 0x62).Str, '0x0061, 0x0F74, 0x0321, 0x0321, 0x1DCE, 0x0062 vs. 0x61, 0x321, 0xF74, 0x1DCE, 0x321, 0x62';
is Uni.new(0x0061, 0x0F74, 0x0321, 0x0322, 0x1DCE, 0x0062).Str, Uni.new(0x61, 0x321, 0xF74, 0x1DCE, 0x322, 0x62).Str, '0x0061, 0x0F74, 0x0321, 0x0322, 0x1DCE, 0x0062 vs. 0x61, 0x321, 0xF74, 0x1DCE, 0x322, 0x62';
is Uni.new(0x0061, 0x0F74, 0x0322, 0x0321, 0x1DCE, 0x0062).Str, Uni.new(0x61, 0x322, 0xF74, 0x1DCE, 0x321, 0x62).Str, '0x0061, 0x0F74, 0x0322, 0x0321, 0x1DCE, 0x0062 vs. 0x61, 0x322, 0xF74, 0x1DCE, 0x321, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0323, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x323, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0323, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x323, 0x62';
is Uni.new(0x0061, 0x302A, 0x0323, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x323, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0323, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x323, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0324, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x324, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0324, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x324, 0x62';
is Uni.new(0x0061, 0x302A, 0x0324, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x324, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0324, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x324, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0325, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x325, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0325, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x325, 0x62';
is Uni.new(0x0061, 0x302A, 0x0325, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x325, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0325, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x325, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0326, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x326, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0326, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x326, 0x62';
is Uni.new(0x0061, 0x302A, 0x0326, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x326, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0326, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x326, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x0F74, 0x0321, 0x0327, 0x1DCE, 0x0062).Str, Uni.new(0x61, 0x321, 0xF74, 0x1DCE, 0x327, 0x62).Str, '0x0061, 0x0F74, 0x0321, 0x0327, 0x1DCE, 0x0062 vs. 0x61, 0x321, 0xF74, 0x1DCE, 0x327, 0x62';
is Uni.new(0x0061, 0x0F74, 0x0327, 0x0321, 0x1DCE, 0x0062).Str, Uni.new(0x61, 0x327, 0xF74, 0x1DCE, 0x321, 0x62).Str, '0x0061, 0x0F74, 0x0327, 0x0321, 0x1DCE, 0x0062 vs. 0x61, 0x327, 0xF74, 0x1DCE, 0x321, 0x62';
is Uni.new(0x0061, 0x0F74, 0x0321, 0x0328, 0x1DCE, 0x0062).Str, Uni.new(0x61, 0x321, 0xF74, 0x1DCE, 0x328, 0x62).Str, '0x0061, 0x0F74, 0x0321, 0x0328, 0x1DCE, 0x0062 vs. 0x61, 0x321, 0xF74, 0x1DCE, 0x328, 0x62';
is Uni.new(0x0061, 0x0F74, 0x0328, 0x0321, 0x1DCE, 0x0062).Str, Uni.new(0x61, 0x328, 0xF74, 0x1DCE, 0x321, 0x62).Str, '0x0061, 0x0F74, 0x0328, 0x0321, 0x1DCE, 0x0062 vs. 0x61, 0x328, 0xF74, 0x1DCE, 0x321, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0329, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x329, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0329, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x329, 0x62';
is Uni.new(0x0061, 0x302A, 0x0329, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x329, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0329, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x329, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x032A, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x32A, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x032A, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x32A, 0x62';
is Uni.new(0x0061, 0x302A, 0x032A, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x32A, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x032A, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x32A, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x032B, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x32B, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x032B, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x32B, 0x62';
is Uni.new(0x0061, 0x302A, 0x032B, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x32B, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x032B, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x32B, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x032C, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x32C, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x032C, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x32C, 0x62';
is Uni.new(0x0061, 0x302A, 0x032C, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x32C, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x032C, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x32C, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x032D, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x32D, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x032D, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x32D, 0x62';
is Uni.new(0x0061, 0x302A, 0x032D, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x32D, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x032D, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x32D, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x032E, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x32E, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x032E, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x32E, 0x62';
is Uni.new(0x0061, 0x302A, 0x032E, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x32E, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x032E, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x32E, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x032F, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x32F, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x032F, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x32F, 0x62';
is Uni.new(0x0061, 0x302A, 0x032F, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x32F, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x032F, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x32F, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0330, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x330, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0330, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x330, 0x62';
is Uni.new(0x0061, 0x302A, 0x0330, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x330, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0330, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x330, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0331, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x331, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0331, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x331, 0x62';
is Uni.new(0x0061, 0x302A, 0x0331, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x331, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0331, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x331, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0332, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x332, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0332, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x332, 0x62';
is Uni.new(0x0061, 0x302A, 0x0332, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x332, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0332, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x332, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0333, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x333, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0333, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x333, 0x62';
is Uni.new(0x0061, 0x302A, 0x0333, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x333, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0333, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x333, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x0334, 0x0334, 0x093C, 0x0062).Str, Uni.new(0x61, 0x334, 0x93C, 0x334, 0x62).Str, '0x0061, 0x0334, 0x0334, 0x093C, 0x0062 vs. 0x61, 0x334, 0x93C, 0x334, 0x62';
is Uni.new(0x0061, 0x0334, 0x0334, 0x093C, 0x0062).Str, Uni.new(0x61, 0x334, 0x93C, 0x334, 0x62).Str, '0x0061, 0x0334, 0x0334, 0x093C, 0x0062 vs. 0x61, 0x334, 0x93C, 0x334, 0x62';
isnt Uni.new(0x0061, 0x0334, 0x0335, 0x093C, 0x0062).Str, Uni.new(0x61, 0x335, 0x334, 0x93C, 0x62).Str, '0x0061, 0x0334, 0x0335, 0x093C, 0x0062 vs. 0x61, 0x335, 0x334, 0x93C, 0x62';
isnt Uni.new(0x0061, 0x0335, 0x0334, 0x093C, 0x0062).Str, Uni.new(0x61, 0x334, 0x335, 0x93C, 0x62).Str, '0x0061, 0x0335, 0x0334, 0x093C, 0x0062 vs. 0x61, 0x334, 0x335, 0x93C, 0x62';
isnt Uni.new(0x0061, 0x0334, 0x0336, 0x093C, 0x0062).Str, Uni.new(0x61, 0x336, 0x334, 0x93C, 0x62).Str, '0x0061, 0x0334, 0x0336, 0x093C, 0x0062 vs. 0x61, 0x336, 0x334, 0x93C, 0x62';
isnt Uni.new(0x0061, 0x0336, 0x0334, 0x093C, 0x0062).Str, Uni.new(0x61, 0x334, 0x336, 0x93C, 0x62).Str, '0x0061, 0x0336, 0x0334, 0x093C, 0x0062 vs. 0x61, 0x334, 0x336, 0x93C, 0x62';
isnt Uni.new(0x0061, 0x0334, 0x0337, 0x093C, 0x0062).Str, Uni.new(0x61, 0x337, 0x334, 0x93C, 0x62).Str, '0x0061, 0x0334, 0x0337, 0x093C, 0x0062 vs. 0x61, 0x337, 0x334, 0x93C, 0x62';
isnt Uni.new(0x0061, 0x0337, 0x0334, 0x093C, 0x0062).Str, Uni.new(0x61, 0x334, 0x337, 0x93C, 0x62).Str, '0x0061, 0x0337, 0x0334, 0x093C, 0x0062 vs. 0x61, 0x334, 0x337, 0x93C, 0x62';
isnt Uni.new(0x0061, 0x0334, 0x0338, 0x093C, 0x0062).Str, Uni.new(0x61, 0x338, 0x334, 0x93C, 0x62).Str, '0x0061, 0x0334, 0x0338, 0x093C, 0x0062 vs. 0x61, 0x338, 0x334, 0x93C, 0x62';
isnt Uni.new(0x0061, 0x0338, 0x0334, 0x093C, 0x0062).Str, Uni.new(0x61, 0x334, 0x338, 0x93C, 0x62).Str, '0x0061, 0x0338, 0x0334, 0x093C, 0x0062 vs. 0x61, 0x334, 0x338, 0x93C, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0339, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x339, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0339, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x339, 0x62';
is Uni.new(0x0061, 0x302A, 0x0339, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x339, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0339, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x339, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x033A, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x33A, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x033A, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x33A, 0x62';
is Uni.new(0x0061, 0x302A, 0x033A, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x33A, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x033A, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x33A, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x033B, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x33B, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x033B, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x33B, 0x62';
is Uni.new(0x0061, 0x302A, 0x033B, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x33B, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x033B, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x33B, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x033C, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x33C, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x033C, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x33C, 0x62';
is Uni.new(0x0061, 0x302A, 0x033C, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x33C, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x033C, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x33C, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x033D, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x33D, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x033D, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x33D, 0x62';
is Uni.new(0x0061, 0x05AE, 0x033D, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x33D, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x033D, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x33D, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x033E, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x33E, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x033E, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x33E, 0x62';
is Uni.new(0x0061, 0x05AE, 0x033E, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x33E, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x033E, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x33E, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x033F, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x33F, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x033F, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x33F, 0x62';
is Uni.new(0x0061, 0x05AE, 0x033F, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x33F, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x033F, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x33F, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0301, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x301, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0301, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x301, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0301, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x301, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0301, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x301, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0342, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x342, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0342, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x342, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0342, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x342, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0342, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x342, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0313, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x313, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0313, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x313, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0313, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x313, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0313, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x313, 0x5AE, 0x315, 0x300, 0x62';
isnt Uni.new(0x0061, 0x05AE, 0x0300, 0x0308, 0x0301, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x301, 0x308, 0x315, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0308, 0x0301, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x301, 0x308, 0x315, 0x62';
isnt Uni.new(0x0061, 0x05AE, 0x0308, 0x0301, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x308, 0x5AE, 0x300, 0x301, 0x315, 0x62).Str, '0x0061, 0x05AE, 0x0308, 0x0301, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x308, 0x5AE, 0x300, 0x301, 0x315, 0x62';
is Uni.new(0x0061, 0x035D, 0x0345, 0x0345, 0x0062).Str, Uni.new(0x61, 0x345, 0x35D, 0x345, 0x62).Str, '0x0061, 0x035D, 0x0345, 0x0345, 0x0062 vs. 0x61, 0x345, 0x35D, 0x345, 0x62';
is Uni.new(0x0061, 0x035D, 0x0345, 0x0345, 0x0062).Str, Uni.new(0x61, 0x345, 0x35D, 0x345, 0x62).Str, '0x0061, 0x035D, 0x0345, 0x0345, 0x0062 vs. 0x61, 0x345, 0x35D, 0x345, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0346, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x346, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0346, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x346, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0346, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x346, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0346, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x346, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0347, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x347, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0347, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x347, 0x62';
is Uni.new(0x0061, 0x302A, 0x0347, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x347, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0347, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x347, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0348, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x348, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0348, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x348, 0x62';
is Uni.new(0x0061, 0x302A, 0x0348, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x348, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0348, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x348, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0349, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x349, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0349, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x349, 0x62';
is Uni.new(0x0061, 0x302A, 0x0349, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x349, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0349, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x349, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x034A, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x34A, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x034A, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x34A, 0x62';
is Uni.new(0x0061, 0x05AE, 0x034A, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x34A, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x034A, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x34A, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x034B, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x34B, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x034B, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x34B, 0x62';
is Uni.new(0x0061, 0x05AE, 0x034B, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x34B, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x034B, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x34B, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x034C, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x34C, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x034C, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x34C, 0x62';
is Uni.new(0x0061, 0x05AE, 0x034C, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x34C, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x034C, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x34C, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x034D, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x34D, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x034D, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x34D, 0x62';
is Uni.new(0x0061, 0x302A, 0x034D, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x34D, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x034D, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x34D, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x034E, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x34E, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x034E, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x34E, 0x62';
is Uni.new(0x0061, 0x302A, 0x034E, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x34E, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x034E, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x34E, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0350, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x350, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0350, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x350, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0350, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x350, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0350, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x350, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0351, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x351, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0351, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x351, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0351, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x351, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0351, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x351, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0352, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x352, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0352, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x352, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0352, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x352, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0352, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x352, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0353, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x353, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0353, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x353, 0x62';
is Uni.new(0x0061, 0x302A, 0x0353, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x353, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0353, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x353, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0354, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x354, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0354, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x354, 0x62';
is Uni.new(0x0061, 0x302A, 0x0354, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x354, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0354, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x354, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0355, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x355, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0355, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x355, 0x62';
is Uni.new(0x0061, 0x302A, 0x0355, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x355, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0355, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x355, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0356, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x356, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0356, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x356, 0x62';
is Uni.new(0x0061, 0x302A, 0x0356, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x356, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0356, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x356, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0357, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x357, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0357, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x357, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0357, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x357, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0357, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x357, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x0300, 0x0315, 0x0358, 0x035C, 0x0062).Str, Uni.new(0x61, 0x315, 0x300, 0x35C, 0x358, 0x62).Str, '0x0061, 0x0300, 0x0315, 0x0358, 0x035C, 0x0062 vs. 0x61, 0x315, 0x300, 0x35C, 0x358, 0x62';
is Uni.new(0x0061, 0x0300, 0x0358, 0x0315, 0x035C, 0x0062).Str, Uni.new(0x61, 0x358, 0x300, 0x35C, 0x315, 0x62).Str, '0x0061, 0x0300, 0x0358, 0x0315, 0x035C, 0x0062 vs. 0x61, 0x358, 0x300, 0x35C, 0x315, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0359, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x359, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0359, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x359, 0x62';
is Uni.new(0x0061, 0x302A, 0x0359, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x359, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0359, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x359, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x035A, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x35A, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x035A, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x35A, 0x62';
is Uni.new(0x0061, 0x302A, 0x035A, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x35A, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x035A, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x35A, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x035B, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x35B, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x035B, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x35B, 0x62';
is Uni.new(0x0061, 0x05AE, 0x035B, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x35B, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x035B, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x35B, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x0315, 0x035C, 0x035C, 0x035D, 0x0062).Str, Uni.new(0x61, 0x35C, 0x315, 0x35D, 0x35C, 0x62).Str, '0x0061, 0x0315, 0x035C, 0x035C, 0x035D, 0x0062 vs. 0x61, 0x35C, 0x315, 0x35D, 0x35C, 0x62';
is Uni.new(0x0061, 0x0315, 0x035C, 0x035C, 0x035D, 0x0062).Str, Uni.new(0x61, 0x35C, 0x315, 0x35D, 0x35C, 0x62).Str, '0x0061, 0x0315, 0x035C, 0x035C, 0x035D, 0x0062 vs. 0x61, 0x35C, 0x315, 0x35D, 0x35C, 0x62';
is Uni.new(0x0061, 0x035C, 0x035D, 0x035D, 0x0345, 0x0062).Str, Uni.new(0x61, 0x35D, 0x35C, 0x345, 0x35D, 0x62).Str, '0x0061, 0x035C, 0x035D, 0x035D, 0x0345, 0x0062 vs. 0x61, 0x35D, 0x35C, 0x345, 0x35D, 0x62';
is Uni.new(0x0061, 0x035C, 0x035D, 0x035D, 0x0345, 0x0062).Str, Uni.new(0x61, 0x35D, 0x35C, 0x345, 0x35D, 0x62).Str, '0x0061, 0x035C, 0x035D, 0x035D, 0x0345, 0x0062 vs. 0x61, 0x35D, 0x35C, 0x345, 0x35D, 0x62';
is Uni.new(0x0061, 0x035C, 0x035D, 0x035E, 0x0345, 0x0062).Str, Uni.new(0x61, 0x35D, 0x35C, 0x345, 0x35E, 0x62).Str, '0x0061, 0x035C, 0x035D, 0x035E, 0x0345, 0x0062 vs. 0x61, 0x35D, 0x35C, 0x345, 0x35E, 0x62';
is Uni.new(0x0061, 0x035C, 0x035E, 0x035D, 0x0345, 0x0062).Str, Uni.new(0x61, 0x35E, 0x35C, 0x345, 0x35D, 0x62).Str, '0x0061, 0x035C, 0x035E, 0x035D, 0x0345, 0x0062 vs. 0x61, 0x35E, 0x35C, 0x345, 0x35D, 0x62';
is Uni.new(0x0061, 0x0315, 0x035C, 0x035F, 0x035D, 0x0062).Str, Uni.new(0x61, 0x35C, 0x315, 0x35D, 0x35F, 0x62).Str, '0x0061, 0x0315, 0x035C, 0x035F, 0x035D, 0x0062 vs. 0x61, 0x35C, 0x315, 0x35D, 0x35F, 0x62';
is Uni.new(0x0061, 0x0315, 0x035F, 0x035C, 0x035D, 0x0062).Str, Uni.new(0x61, 0x35F, 0x315, 0x35D, 0x35C, 0x62).Str, '0x0061, 0x0315, 0x035F, 0x035C, 0x035D, 0x0062 vs. 0x61, 0x35F, 0x315, 0x35D, 0x35C, 0x62';
is Uni.new(0x0061, 0x035C, 0x035D, 0x0360, 0x0345, 0x0062).Str, Uni.new(0x61, 0x35D, 0x35C, 0x345, 0x360, 0x62).Str, '0x0061, 0x035C, 0x035D, 0x0360, 0x0345, 0x0062 vs. 0x61, 0x35D, 0x35C, 0x345, 0x360, 0x62';
is Uni.new(0x0061, 0x035C, 0x0360, 0x035D, 0x0345, 0x0062).Str, Uni.new(0x61, 0x360, 0x35C, 0x345, 0x35D, 0x62).Str, '0x0061, 0x035C, 0x0360, 0x035D, 0x0345, 0x0062 vs. 0x61, 0x360, 0x35C, 0x345, 0x35D, 0x62';
is Uni.new(0x0061, 0x035C, 0x035D, 0x0361, 0x0345, 0x0062).Str, Uni.new(0x61, 0x35D, 0x35C, 0x345, 0x361, 0x62).Str, '0x0061, 0x035C, 0x035D, 0x0361, 0x0345, 0x0062 vs. 0x61, 0x35D, 0x35C, 0x345, 0x361, 0x62';
is Uni.new(0x0061, 0x035C, 0x0361, 0x035D, 0x0345, 0x0062).Str, Uni.new(0x61, 0x361, 0x35C, 0x345, 0x35D, 0x62).Str, '0x0061, 0x035C, 0x0361, 0x035D, 0x0345, 0x0062 vs. 0x61, 0x361, 0x35C, 0x345, 0x35D, 0x62';
is Uni.new(0x0061, 0x0315, 0x035C, 0x0362, 0x035D, 0x0062).Str, Uni.new(0x61, 0x35C, 0x315, 0x35D, 0x362, 0x62).Str, '0x0061, 0x0315, 0x035C, 0x0362, 0x035D, 0x0062 vs. 0x61, 0x35C, 0x315, 0x35D, 0x362, 0x62';
is Uni.new(0x0061, 0x0315, 0x0362, 0x035C, 0x035D, 0x0062).Str, Uni.new(0x61, 0x362, 0x315, 0x35D, 0x35C, 0x62).Str, '0x0061, 0x0315, 0x0362, 0x035C, 0x035D, 0x0062 vs. 0x61, 0x362, 0x315, 0x35D, 0x35C, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0363, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x363, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0363, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x363, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0363, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x363, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0363, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x363, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0364, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x364, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0364, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x364, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0364, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x364, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0364, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x364, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0365, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x365, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0365, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x365, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0365, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x365, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0365, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x365, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0366, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x366, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0366, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x366, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0366, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x366, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0366, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x366, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0367, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x367, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0367, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x367, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0367, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x367, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0367, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x367, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0368, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x368, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0368, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x368, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0368, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x368, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0368, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x368, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0369, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x369, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0369, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x369, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0369, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x369, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0369, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x369, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x036A, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x36A, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x036A, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x36A, 0x62';
is Uni.new(0x0061, 0x05AE, 0x036A, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x36A, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x036A, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x36A, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x036B, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x36B, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x036B, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x36B, 0x62';
is Uni.new(0x0061, 0x05AE, 0x036B, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x36B, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x036B, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x36B, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x036C, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x36C, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x036C, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x36C, 0x62';
is Uni.new(0x0061, 0x05AE, 0x036C, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x36C, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x036C, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x36C, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x036D, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x36D, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x036D, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x36D, 0x62';
is Uni.new(0x0061, 0x05AE, 0x036D, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x36D, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x036D, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x36D, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x036E, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x36E, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x036E, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x36E, 0x62';
is Uni.new(0x0061, 0x05AE, 0x036E, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x36E, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x036E, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x36E, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x036F, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x36F, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x036F, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x36F, 0x62';
is Uni.new(0x0061, 0x05AE, 0x036F, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x36F, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x036F, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x36F, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0483, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x483, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0483, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x483, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0483, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x483, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0483, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x483, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0484, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x484, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0484, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x484, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0484, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x484, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0484, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x484, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0485, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x485, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0485, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x485, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0485, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x485, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0485, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x485, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0486, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x486, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0486, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x486, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0486, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x486, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0486, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x486, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0487, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x487, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0487, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x487, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0487, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x487, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0487, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x487, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0591, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x591, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0591, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x591, 0x62';
is Uni.new(0x0061, 0x302A, 0x0591, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x591, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0591, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x591, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0592, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x592, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0592, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x592, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0592, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x592, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0592, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x592, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0593, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x593, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0593, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x593, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0593, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x593, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0593, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x593, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0594, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x594, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0594, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x594, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0594, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x594, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0594, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x594, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0595, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x595, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0595, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x595, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0595, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x595, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0595, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x595, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0596, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x596, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0596, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x596, 0x62';
is Uni.new(0x0061, 0x302A, 0x0596, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x596, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0596, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x596, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0597, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x597, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0597, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x597, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0597, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x597, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0597, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x597, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0598, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x598, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0598, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x598, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0598, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x598, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0598, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x598, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0599, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x599, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0599, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x599, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0599, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x599, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0599, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x599, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x0316, 0x059A, 0x059A, 0x302E, 0x0062).Str, Uni.new(0x61, 0x59A, 0x316, 0x302E, 0x59A, 0x62).Str, '0x0061, 0x0316, 0x059A, 0x059A, 0x302E, 0x0062 vs. 0x61, 0x59A, 0x316, 0x302E, 0x59A, 0x62';
is Uni.new(0x0061, 0x0316, 0x059A, 0x059A, 0x302E, 0x0062).Str, Uni.new(0x61, 0x59A, 0x316, 0x302E, 0x59A, 0x62).Str, '0x0061, 0x0316, 0x059A, 0x059A, 0x302E, 0x0062 vs. 0x61, 0x59A, 0x316, 0x302E, 0x59A, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x059B, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x59B, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x059B, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x59B, 0x62';
is Uni.new(0x0061, 0x302A, 0x059B, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x59B, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x059B, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x59B, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x059C, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x59C, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x059C, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x59C, 0x62';
is Uni.new(0x0061, 0x05AE, 0x059C, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x59C, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x059C, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x59C, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x059D, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x59D, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x059D, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x59D, 0x62';
is Uni.new(0x0061, 0x05AE, 0x059D, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x59D, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x059D, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x59D, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x059E, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x59E, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x059E, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x59E, 0x62';
is Uni.new(0x0061, 0x05AE, 0x059E, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x59E, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x059E, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x59E, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x059F, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x59F, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x059F, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x59F, 0x62';
is Uni.new(0x0061, 0x05AE, 0x059F, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x59F, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x059F, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x59F, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x05A0, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x5A0, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x05A0, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x5A0, 0x62';
is Uni.new(0x0061, 0x05AE, 0x05A0, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x5A0, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x05A0, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x5A0, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x05A1, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x5A1, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x05A1, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x5A1, 0x62';
is Uni.new(0x0061, 0x05AE, 0x05A1, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x5A1, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x05A1, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x5A1, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x05A2, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x5A2, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x05A2, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x5A2, 0x62';
is Uni.new(0x0061, 0x302A, 0x05A2, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x5A2, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x05A2, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x5A2, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x05A3, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x5A3, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x05A3, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x5A3, 0x62';
is Uni.new(0x0061, 0x302A, 0x05A3, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x5A3, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x05A3, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x5A3, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x05A4, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x5A4, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x05A4, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x5A4, 0x62';
is Uni.new(0x0061, 0x302A, 0x05A4, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x5A4, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x05A4, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x5A4, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x05A5, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x5A5, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x05A5, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x5A5, 0x62';
is Uni.new(0x0061, 0x302A, 0x05A5, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x5A5, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x05A5, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x5A5, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x05A6, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x5A6, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x05A6, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x5A6, 0x62';
is Uni.new(0x0061, 0x302A, 0x05A6, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x5A6, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x05A6, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x5A6, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x05A7, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x5A7, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x05A7, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x5A7, 0x62';
is Uni.new(0x0061, 0x302A, 0x05A7, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x5A7, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x05A7, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x5A7, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x05A8, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x5A8, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x05A8, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x5A8, 0x62';
is Uni.new(0x0061, 0x05AE, 0x05A8, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x5A8, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x05A8, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x5A8, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x05A9, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x5A9, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x05A9, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x5A9, 0x62';
is Uni.new(0x0061, 0x05AE, 0x05A9, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x5A9, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x05A9, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x5A9, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x05AA, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x5AA, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x05AA, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x5AA, 0x62';
is Uni.new(0x0061, 0x302A, 0x05AA, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x5AA, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x05AA, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x5AA, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x05AB, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x5AB, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x05AB, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x5AB, 0x62';
is Uni.new(0x0061, 0x05AE, 0x05AB, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x5AB, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x05AB, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x5AB, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x05AC, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x5AC, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x05AC, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x5AC, 0x62';
is Uni.new(0x0061, 0x05AE, 0x05AC, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x5AC, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x05AC, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x5AC, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x0316, 0x059A, 0x05AD, 0x302E, 0x0062).Str, Uni.new(0x61, 0x59A, 0x316, 0x302E, 0x5AD, 0x62).Str, '0x0061, 0x0316, 0x059A, 0x05AD, 0x302E, 0x0062 vs. 0x61, 0x59A, 0x316, 0x302E, 0x5AD, 0x62';
is Uni.new(0x0061, 0x0316, 0x05AD, 0x059A, 0x302E, 0x0062).Str, Uni.new(0x61, 0x5AD, 0x316, 0x302E, 0x59A, 0x62).Str, '0x0061, 0x0316, 0x05AD, 0x059A, 0x302E, 0x0062 vs. 0x61, 0x5AD, 0x316, 0x302E, 0x59A, 0x62';
is Uni.new(0x0061, 0x1D16D, 0x05AE, 0x05AE, 0x0300, 0x0062).Str, Uni.new(0x61, 0x5AE, 0x1D16D, 0x300, 0x5AE, 0x62).Str, '0x0061, 0x1D16D, 0x05AE, 0x05AE, 0x0300, 0x0062 vs. 0x61, 0x5AE, 0x1D16D, 0x300, 0x5AE, 0x62';
is Uni.new(0x0061, 0x1D16D, 0x05AE, 0x05AE, 0x0300, 0x0062).Str, Uni.new(0x61, 0x5AE, 0x1D16D, 0x300, 0x5AE, 0x62).Str, '0x0061, 0x1D16D, 0x05AE, 0x05AE, 0x0300, 0x0062 vs. 0x61, 0x5AE, 0x1D16D, 0x300, 0x5AE, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x05AF, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x5AF, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x05AF, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x5AF, 0x62';
is Uni.new(0x0061, 0x05AE, 0x05AF, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x5AF, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x05AF, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x5AF, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x094D, 0x05B0, 0x05B0, 0x05B1, 0x0062).Str, Uni.new(0x61, 0x5B0, 0x94D, 0x5B1, 0x5B0, 0x62).Str, '0x0061, 0x094D, 0x05B0, 0x05B0, 0x05B1, 0x0062 vs. 0x61, 0x5B0, 0x94D, 0x5B1, 0x5B0, 0x62';
is Uni.new(0x0061, 0x094D, 0x05B0, 0x05B0, 0x05B1, 0x0062).Str, Uni.new(0x61, 0x5B0, 0x94D, 0x5B1, 0x5B0, 0x62).Str, '0x0061, 0x094D, 0x05B0, 0x05B0, 0x05B1, 0x0062 vs. 0x61, 0x5B0, 0x94D, 0x5B1, 0x5B0, 0x62';
is Uni.new(0x0061, 0x05B0, 0x05B1, 0x05B1, 0x05B2, 0x0062).Str, Uni.new(0x61, 0x5B1, 0x5B0, 0x5B2, 0x5B1, 0x62).Str, '0x0061, 0x05B0, 0x05B1, 0x05B1, 0x05B2, 0x0062 vs. 0x61, 0x5B1, 0x5B0, 0x5B2, 0x5B1, 0x62';
is Uni.new(0x0061, 0x05B0, 0x05B1, 0x05B1, 0x05B2, 0x0062).Str, Uni.new(0x61, 0x5B1, 0x5B0, 0x5B2, 0x5B1, 0x62).Str, '0x0061, 0x05B0, 0x05B1, 0x05B1, 0x05B2, 0x0062 vs. 0x61, 0x5B1, 0x5B0, 0x5B2, 0x5B1, 0x62';
is Uni.new(0x0061, 0x05B1, 0x05B2, 0x05B2, 0x05B3, 0x0062).Str, Uni.new(0x61, 0x5B2, 0x5B1, 0x5B3, 0x5B2, 0x62).Str, '0x0061, 0x05B1, 0x05B2, 0x05B2, 0x05B3, 0x0062 vs. 0x61, 0x5B2, 0x5B1, 0x5B3, 0x5B2, 0x62';
is Uni.new(0x0061, 0x05B1, 0x05B2, 0x05B2, 0x05B3, 0x0062).Str, Uni.new(0x61, 0x5B2, 0x5B1, 0x5B3, 0x5B2, 0x62).Str, '0x0061, 0x05B1, 0x05B2, 0x05B2, 0x05B3, 0x0062 vs. 0x61, 0x5B2, 0x5B1, 0x5B3, 0x5B2, 0x62';
is Uni.new(0x0061, 0x05B2, 0x05B3, 0x05B3, 0x05B4, 0x0062).Str, Uni.new(0x61, 0x5B3, 0x5B2, 0x5B4, 0x5B3, 0x62).Str, '0x0061, 0x05B2, 0x05B3, 0x05B3, 0x05B4, 0x0062 vs. 0x61, 0x5B3, 0x5B2, 0x5B4, 0x5B3, 0x62';
is Uni.new(0x0061, 0x05B2, 0x05B3, 0x05B3, 0x05B4, 0x0062).Str, Uni.new(0x61, 0x5B3, 0x5B2, 0x5B4, 0x5B3, 0x62).Str, '0x0061, 0x05B2, 0x05B3, 0x05B3, 0x05B4, 0x0062 vs. 0x61, 0x5B3, 0x5B2, 0x5B4, 0x5B3, 0x62';
is Uni.new(0x0061, 0x05B3, 0x05B4, 0x05B4, 0x05B5, 0x0062).Str, Uni.new(0x61, 0x5B4, 0x5B3, 0x5B5, 0x5B4, 0x62).Str, '0x0061, 0x05B3, 0x05B4, 0x05B4, 0x05B5, 0x0062 vs. 0x61, 0x5B4, 0x5B3, 0x5B5, 0x5B4, 0x62';
is Uni.new(0x0061, 0x05B3, 0x05B4, 0x05B4, 0x05B5, 0x0062).Str, Uni.new(0x61, 0x5B4, 0x5B3, 0x5B5, 0x5B4, 0x62).Str, '0x0061, 0x05B3, 0x05B4, 0x05B4, 0x05B5, 0x0062 vs. 0x61, 0x5B4, 0x5B3, 0x5B5, 0x5B4, 0x62';
is Uni.new(0x0061, 0x05B4, 0x05B5, 0x05B5, 0x05B6, 0x0062).Str, Uni.new(0x61, 0x5B5, 0x5B4, 0x5B6, 0x5B5, 0x62).Str, '0x0061, 0x05B4, 0x05B5, 0x05B5, 0x05B6, 0x0062 vs. 0x61, 0x5B5, 0x5B4, 0x5B6, 0x5B5, 0x62';
is Uni.new(0x0061, 0x05B4, 0x05B5, 0x05B5, 0x05B6, 0x0062).Str, Uni.new(0x61, 0x5B5, 0x5B4, 0x5B6, 0x5B5, 0x62).Str, '0x0061, 0x05B4, 0x05B5, 0x05B5, 0x05B6, 0x0062 vs. 0x61, 0x5B5, 0x5B4, 0x5B6, 0x5B5, 0x62';
is Uni.new(0x0061, 0x05B5, 0x05B6, 0x05B6, 0x05B7, 0x0062).Str, Uni.new(0x61, 0x5B6, 0x5B5, 0x5B7, 0x5B6, 0x62).Str, '0x0061, 0x05B5, 0x05B6, 0x05B6, 0x05B7, 0x0062 vs. 0x61, 0x5B6, 0x5B5, 0x5B7, 0x5B6, 0x62';
is Uni.new(0x0061, 0x05B5, 0x05B6, 0x05B6, 0x05B7, 0x0062).Str, Uni.new(0x61, 0x5B6, 0x5B5, 0x5B7, 0x5B6, 0x62).Str, '0x0061, 0x05B5, 0x05B6, 0x05B6, 0x05B7, 0x0062 vs. 0x61, 0x5B6, 0x5B5, 0x5B7, 0x5B6, 0x62';
is Uni.new(0x0061, 0x05B6, 0x05B7, 0x05B7, 0x05B8, 0x0062).Str, Uni.new(0x61, 0x5B7, 0x5B6, 0x5B8, 0x5B7, 0x62).Str, '0x0061, 0x05B6, 0x05B7, 0x05B7, 0x05B8, 0x0062 vs. 0x61, 0x5B7, 0x5B6, 0x5B8, 0x5B7, 0x62';
is Uni.new(0x0061, 0x05B6, 0x05B7, 0x05B7, 0x05B8, 0x0062).Str, Uni.new(0x61, 0x5B7, 0x5B6, 0x5B8, 0x5B7, 0x62).Str, '0x0061, 0x05B6, 0x05B7, 0x05B7, 0x05B8, 0x0062 vs. 0x61, 0x5B7, 0x5B6, 0x5B8, 0x5B7, 0x62';
is Uni.new(0x0061, 0x05B7, 0x05B8, 0x05B8, 0x05B9, 0x0062).Str, Uni.new(0x61, 0x5B8, 0x5B7, 0x5B9, 0x5B8, 0x62).Str, '0x0061, 0x05B7, 0x05B8, 0x05B8, 0x05B9, 0x0062 vs. 0x61, 0x5B8, 0x5B7, 0x5B9, 0x5B8, 0x62';
is Uni.new(0x0061, 0x05B7, 0x05B8, 0x05B8, 0x05B9, 0x0062).Str, Uni.new(0x61, 0x5B8, 0x5B7, 0x5B9, 0x5B8, 0x62).Str, '0x0061, 0x05B7, 0x05B8, 0x05B8, 0x05B9, 0x0062 vs. 0x61, 0x5B8, 0x5B7, 0x5B9, 0x5B8, 0x62';
is Uni.new(0x0061, 0x05B8, 0x05B9, 0x05B9, 0x05BB, 0x0062).Str, Uni.new(0x61, 0x5B9, 0x5B8, 0x5BB, 0x5B9, 0x62).Str, '0x0061, 0x05B8, 0x05B9, 0x05B9, 0x05BB, 0x0062 vs. 0x61, 0x5B9, 0x5B8, 0x5BB, 0x5B9, 0x62';
is Uni.new(0x0061, 0x05B8, 0x05B9, 0x05B9, 0x05BB, 0x0062).Str, Uni.new(0x61, 0x5B9, 0x5B8, 0x5BB, 0x5B9, 0x62).Str, '0x0061, 0x05B8, 0x05B9, 0x05B9, 0x05BB, 0x0062 vs. 0x61, 0x5B9, 0x5B8, 0x5BB, 0x5B9, 0x62';
is Uni.new(0x0061, 0x05B8, 0x05B9, 0x05BA, 0x05BB, 0x0062).Str, Uni.new(0x61, 0x5B9, 0x5B8, 0x5BB, 0x5BA, 0x62).Str, '0x0061, 0x05B8, 0x05B9, 0x05BA, 0x05BB, 0x0062 vs. 0x61, 0x5B9, 0x5B8, 0x5BB, 0x5BA, 0x62';
is Uni.new(0x0061, 0x05B8, 0x05BA, 0x05B9, 0x05BB, 0x0062).Str, Uni.new(0x61, 0x5BA, 0x5B8, 0x5BB, 0x5B9, 0x62).Str, '0x0061, 0x05B8, 0x05BA, 0x05B9, 0x05BB, 0x0062 vs. 0x61, 0x5BA, 0x5B8, 0x5BB, 0x5B9, 0x62';
is Uni.new(0x0061, 0x05B9, 0x05BB, 0x05BB, 0x05BC, 0x0062).Str, Uni.new(0x61, 0x5BB, 0x5B9, 0x5BC, 0x5BB, 0x62).Str, '0x0061, 0x05B9, 0x05BB, 0x05BB, 0x05BC, 0x0062 vs. 0x61, 0x5BB, 0x5B9, 0x5BC, 0x5BB, 0x62';
is Uni.new(0x0061, 0x05B9, 0x05BB, 0x05BB, 0x05BC, 0x0062).Str, Uni.new(0x61, 0x5BB, 0x5B9, 0x5BC, 0x5BB, 0x62).Str, '0x0061, 0x05B9, 0x05BB, 0x05BB, 0x05BC, 0x0062 vs. 0x61, 0x5BB, 0x5B9, 0x5BC, 0x5BB, 0x62';
is Uni.new(0x0061, 0x05BB, 0x05BC, 0x05BC, 0x05BD, 0x0062).Str, Uni.new(0x61, 0x5BC, 0x5BB, 0x5BD, 0x5BC, 0x62).Str, '0x0061, 0x05BB, 0x05BC, 0x05BC, 0x05BD, 0x0062 vs. 0x61, 0x5BC, 0x5BB, 0x5BD, 0x5BC, 0x62';
is Uni.new(0x0061, 0x05BB, 0x05BC, 0x05BC, 0x05BD, 0x0062).Str, Uni.new(0x61, 0x5BC, 0x5BB, 0x5BD, 0x5BC, 0x62).Str, '0x0061, 0x05BB, 0x05BC, 0x05BC, 0x05BD, 0x0062 vs. 0x61, 0x5BC, 0x5BB, 0x5BD, 0x5BC, 0x62';
is Uni.new(0x0061, 0x05BC, 0x05BD, 0x05BD, 0x05BF, 0x0062).Str, Uni.new(0x61, 0x5BD, 0x5BC, 0x5BF, 0x5BD, 0x62).Str, '0x0061, 0x05BC, 0x05BD, 0x05BD, 0x05BF, 0x0062 vs. 0x61, 0x5BD, 0x5BC, 0x5BF, 0x5BD, 0x62';
is Uni.new(0x0061, 0x05BC, 0x05BD, 0x05BD, 0x05BF, 0x0062).Str, Uni.new(0x61, 0x5BD, 0x5BC, 0x5BF, 0x5BD, 0x62).Str, '0x0061, 0x05BC, 0x05BD, 0x05BD, 0x05BF, 0x0062 vs. 0x61, 0x5BD, 0x5BC, 0x5BF, 0x5BD, 0x62';
is Uni.new(0x0061, 0x05BD, 0x05BF, 0x05BF, 0x05C1, 0x0062).Str, Uni.new(0x61, 0x5BF, 0x5BD, 0x5C1, 0x5BF, 0x62).Str, '0x0061, 0x05BD, 0x05BF, 0x05BF, 0x05C1, 0x0062 vs. 0x61, 0x5BF, 0x5BD, 0x5C1, 0x5BF, 0x62';
is Uni.new(0x0061, 0x05BD, 0x05BF, 0x05BF, 0x05C1, 0x0062).Str, Uni.new(0x61, 0x5BF, 0x5BD, 0x5C1, 0x5BF, 0x62).Str, '0x0061, 0x05BD, 0x05BF, 0x05BF, 0x05C1, 0x0062 vs. 0x61, 0x5BF, 0x5BD, 0x5C1, 0x5BF, 0x62';
is Uni.new(0x0061, 0x05BF, 0x05C1, 0x05C1, 0x05C2, 0x0062).Str, Uni.new(0x61, 0x5C1, 0x5BF, 0x5C2, 0x5C1, 0x62).Str, '0x0061, 0x05BF, 0x05C1, 0x05C1, 0x05C2, 0x0062 vs. 0x61, 0x5C1, 0x5BF, 0x5C2, 0x5C1, 0x62';
is Uni.new(0x0061, 0x05BF, 0x05C1, 0x05C1, 0x05C2, 0x0062).Str, Uni.new(0x61, 0x5C1, 0x5BF, 0x5C2, 0x5C1, 0x62).Str, '0x0061, 0x05BF, 0x05C1, 0x05C1, 0x05C2, 0x0062 vs. 0x61, 0x5C1, 0x5BF, 0x5C2, 0x5C1, 0x62';
is Uni.new(0x0061, 0x05C1, 0x05C2, 0x05C2, 0xFB1E, 0x0062).Str, Uni.new(0x61, 0x5C2, 0x5C1, 0xFB1E, 0x5C2, 0x62).Str, '0x0061, 0x05C1, 0x05C2, 0x05C2, 0xFB1E, 0x0062 vs. 0x61, 0x5C2, 0x5C1, 0xFB1E, 0x5C2, 0x62';
is Uni.new(0x0061, 0x05C1, 0x05C2, 0x05C2, 0xFB1E, 0x0062).Str, Uni.new(0x61, 0x5C2, 0x5C1, 0xFB1E, 0x5C2, 0x62).Str, '0x0061, 0x05C1, 0x05C2, 0x05C2, 0xFB1E, 0x0062 vs. 0x61, 0x5C2, 0x5C1, 0xFB1E, 0x5C2, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x05C4, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x5C4, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x05C4, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x5C4, 0x62';
is Uni.new(0x0061, 0x05AE, 0x05C4, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x5C4, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x05C4, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x5C4, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x05C5, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x5C5, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x05C5, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x5C5, 0x62';
is Uni.new(0x0061, 0x302A, 0x05C5, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x5C5, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x05C5, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x5C5, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x05B7, 0x05B8, 0x05C7, 0x05B9, 0x0062).Str, Uni.new(0x61, 0x5B8, 0x5B7, 0x5B9, 0x5C7, 0x62).Str, '0x0061, 0x05B7, 0x05B8, 0x05C7, 0x05B9, 0x0062 vs. 0x61, 0x5B8, 0x5B7, 0x5B9, 0x5C7, 0x62';
is Uni.new(0x0061, 0x05B7, 0x05C7, 0x05B8, 0x05B9, 0x0062).Str, Uni.new(0x61, 0x5C7, 0x5B7, 0x5B9, 0x5B8, 0x62).Str, '0x0061, 0x05B7, 0x05C7, 0x05B8, 0x05B9, 0x0062 vs. 0x61, 0x5C7, 0x5B7, 0x5B9, 0x5B8, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0610, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x610, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0610, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x610, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0610, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x610, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0610, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x610, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0611, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x611, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0611, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x611, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0611, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x611, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0611, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x611, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0612, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x612, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0612, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x612, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0612, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x612, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0612, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x612, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0613, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x613, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0613, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x613, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0613, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x613, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0613, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x613, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0614, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x614, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0614, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x614, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0614, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x614, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0614, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x614, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0615, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x615, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0615, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x615, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0615, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x615, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0615, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x615, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0616, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x616, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0616, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x616, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0616, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x616, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0616, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x616, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0617, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x617, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0617, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x617, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0617, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x617, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0617, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x617, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x064D, 0x0618, 0x0618, 0x0619, 0x0062).Str, Uni.new(0x61, 0x618, 0x64D, 0x619, 0x618, 0x62).Str, '0x0061, 0x064D, 0x0618, 0x0618, 0x0619, 0x0062 vs. 0x61, 0x618, 0x64D, 0x619, 0x618, 0x62';
is Uni.new(0x0061, 0x064D, 0x0618, 0x0618, 0x0619, 0x0062).Str, Uni.new(0x61, 0x618, 0x64D, 0x619, 0x618, 0x62).Str, '0x0061, 0x064D, 0x0618, 0x0618, 0x0619, 0x0062 vs. 0x61, 0x618, 0x64D, 0x619, 0x618, 0x62';
is Uni.new(0x0061, 0x0618, 0x0619, 0x0619, 0x061A, 0x0062).Str, Uni.new(0x61, 0x619, 0x618, 0x61A, 0x619, 0x62).Str, '0x0061, 0x0618, 0x0619, 0x0619, 0x061A, 0x0062 vs. 0x61, 0x619, 0x618, 0x61A, 0x619, 0x62';
is Uni.new(0x0061, 0x0618, 0x0619, 0x0619, 0x061A, 0x0062).Str, Uni.new(0x61, 0x619, 0x618, 0x61A, 0x619, 0x62).Str, '0x0061, 0x0618, 0x0619, 0x0619, 0x061A, 0x0062 vs. 0x61, 0x619, 0x618, 0x61A, 0x619, 0x62';
is Uni.new(0x0061, 0x0619, 0x061A, 0x061A, 0x0651, 0x0062).Str, Uni.new(0x61, 0x61A, 0x619, 0x651, 0x61A, 0x62).Str, '0x0061, 0x0619, 0x061A, 0x061A, 0x0651, 0x0062 vs. 0x61, 0x61A, 0x619, 0x651, 0x61A, 0x62';
is Uni.new(0x0061, 0x0619, 0x061A, 0x061A, 0x0651, 0x0062).Str, Uni.new(0x61, 0x61A, 0x619, 0x651, 0x61A, 0x62).Str, '0x0061, 0x0619, 0x061A, 0x061A, 0x0651, 0x0062 vs. 0x61, 0x61A, 0x619, 0x651, 0x61A, 0x62';
is Uni.new(0x0061, 0xFB1E, 0x064B, 0x064B, 0x064C, 0x0062).Str, Uni.new(0x61, 0x64B, 0xFB1E, 0x64C, 0x64B, 0x62).Str, '0x0061, 0xFB1E, 0x064B, 0x064B, 0x064C, 0x0062 vs. 0x61, 0x64B, 0xFB1E, 0x64C, 0x64B, 0x62';
is Uni.new(0x0061, 0xFB1E, 0x064B, 0x064B, 0x064C, 0x0062).Str, Uni.new(0x61, 0x64B, 0xFB1E, 0x64C, 0x64B, 0x62).Str, '0x0061, 0xFB1E, 0x064B, 0x064B, 0x064C, 0x0062 vs. 0x61, 0x64B, 0xFB1E, 0x64C, 0x64B, 0x62';
is Uni.new(0x0061, 0x064B, 0x064C, 0x064C, 0x064D, 0x0062).Str, Uni.new(0x61, 0x64C, 0x64B, 0x64D, 0x64C, 0x62).Str, '0x0061, 0x064B, 0x064C, 0x064C, 0x064D, 0x0062 vs. 0x61, 0x64C, 0x64B, 0x64D, 0x64C, 0x62';
is Uni.new(0x0061, 0x064B, 0x064C, 0x064C, 0x064D, 0x0062).Str, Uni.new(0x61, 0x64C, 0x64B, 0x64D, 0x64C, 0x62).Str, '0x0061, 0x064B, 0x064C, 0x064C, 0x064D, 0x0062 vs. 0x61, 0x64C, 0x64B, 0x64D, 0x64C, 0x62';
is Uni.new(0x0061, 0x064C, 0x064D, 0x064D, 0x0618, 0x0062).Str, Uni.new(0x61, 0x64D, 0x64C, 0x618, 0x64D, 0x62).Str, '0x0061, 0x064C, 0x064D, 0x064D, 0x0618, 0x0062 vs. 0x61, 0x64D, 0x64C, 0x618, 0x64D, 0x62';
is Uni.new(0x0061, 0x064C, 0x064D, 0x064D, 0x0618, 0x0062).Str, Uni.new(0x61, 0x64D, 0x64C, 0x618, 0x64D, 0x62).Str, '0x0061, 0x064C, 0x064D, 0x064D, 0x0618, 0x0062 vs. 0x61, 0x64D, 0x64C, 0x618, 0x64D, 0x62';
is Uni.new(0x0061, 0x064D, 0x0618, 0x064E, 0x0619, 0x0062).Str, Uni.new(0x61, 0x618, 0x64D, 0x619, 0x64E, 0x62).Str, '0x0061, 0x064D, 0x0618, 0x064E, 0x0619, 0x0062 vs. 0x61, 0x618, 0x64D, 0x619, 0x64E, 0x62';
is Uni.new(0x0061, 0x064D, 0x064E, 0x0618, 0x0619, 0x0062).Str, Uni.new(0x61, 0x64E, 0x64D, 0x619, 0x618, 0x62).Str, '0x0061, 0x064D, 0x064E, 0x0618, 0x0619, 0x0062 vs. 0x61, 0x64E, 0x64D, 0x619, 0x618, 0x62';
is Uni.new(0x0061, 0x0618, 0x0619, 0x064F, 0x061A, 0x0062).Str, Uni.new(0x61, 0x619, 0x618, 0x61A, 0x64F, 0x62).Str, '0x0061, 0x0618, 0x0619, 0x064F, 0x061A, 0x0062 vs. 0x61, 0x619, 0x618, 0x61A, 0x64F, 0x62';
is Uni.new(0x0061, 0x0618, 0x064F, 0x0619, 0x061A, 0x0062).Str, Uni.new(0x61, 0x64F, 0x618, 0x61A, 0x619, 0x62).Str, '0x0061, 0x0618, 0x064F, 0x0619, 0x061A, 0x0062 vs. 0x61, 0x64F, 0x618, 0x61A, 0x619, 0x62';
is Uni.new(0x0061, 0x0619, 0x061A, 0x0650, 0x0651, 0x0062).Str, Uni.new(0x61, 0x61A, 0x619, 0x651, 0x650, 0x62).Str, '0x0061, 0x0619, 0x061A, 0x0650, 0x0651, 0x0062 vs. 0x61, 0x61A, 0x619, 0x651, 0x650, 0x62';
is Uni.new(0x0061, 0x0619, 0x0650, 0x061A, 0x0651, 0x0062).Str, Uni.new(0x61, 0x650, 0x619, 0x651, 0x61A, 0x62).Str, '0x0061, 0x0619, 0x0650, 0x061A, 0x0651, 0x0062 vs. 0x61, 0x650, 0x619, 0x651, 0x61A, 0x62';
is Uni.new(0x0061, 0x061A, 0x0651, 0x0651, 0x0652, 0x0062).Str, Uni.new(0x61, 0x651, 0x61A, 0x652, 0x651, 0x62).Str, '0x0061, 0x061A, 0x0651, 0x0651, 0x0652, 0x0062 vs. 0x61, 0x651, 0x61A, 0x652, 0x651, 0x62';
is Uni.new(0x0061, 0x061A, 0x0651, 0x0651, 0x0652, 0x0062).Str, Uni.new(0x61, 0x651, 0x61A, 0x652, 0x651, 0x62).Str, '0x0061, 0x061A, 0x0651, 0x0651, 0x0652, 0x0062 vs. 0x61, 0x651, 0x61A, 0x652, 0x651, 0x62';
is Uni.new(0x0061, 0x0651, 0x0652, 0x0652, 0x0670, 0x0062).Str, Uni.new(0x61, 0x652, 0x651, 0x670, 0x652, 0x62).Str, '0x0061, 0x0651, 0x0652, 0x0652, 0x0670, 0x0062 vs. 0x61, 0x652, 0x651, 0x670, 0x652, 0x62';
is Uni.new(0x0061, 0x0651, 0x0652, 0x0652, 0x0670, 0x0062).Str, Uni.new(0x61, 0x652, 0x651, 0x670, 0x652, 0x62).Str, '0x0061, 0x0651, 0x0652, 0x0652, 0x0670, 0x0062 vs. 0x61, 0x652, 0x651, 0x670, 0x652, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0653, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x653, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0653, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x653, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0653, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x653, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0653, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x653, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0654, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x654, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0654, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x654, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0654, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x654, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0654, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x654, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0655, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x655, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0655, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x655, 0x62';
is Uni.new(0x0061, 0x302A, 0x0655, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x655, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0655, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x655, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x0656, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x656, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x0656, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x656, 0x62';
is Uni.new(0x0061, 0x302A, 0x0656, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x656, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x0656, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x656, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0657, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x657, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0657, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x657, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0657, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x657, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0657, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x657, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0658, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x658, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0658, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x658, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0658, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x658, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0658, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x658, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x0659, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x659, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x0659, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x659, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0659, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x659, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x0659, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x659, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x065A, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x65A, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x065A, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x65A, 0x62';
is Uni.new(0x0061, 0x05AE, 0x065A, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x65A, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x065A, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x65A, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x065B, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x65B, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x065B, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x65B, 0x62';
is Uni.new(0x0061, 0x05AE, 0x065B, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x65B, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x065B, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x65B, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x065C, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x65C, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x065C, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x65C, 0x62';
is Uni.new(0x0061, 0x302A, 0x065C, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x65C, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x065C, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x65C, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x065D, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x65D, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x065D, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x65D, 0x62';
is Uni.new(0x0061, 0x05AE, 0x065D, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x65D, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x065D, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x65D, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x065E, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x65E, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x065E, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x65E, 0x62';
is Uni.new(0x0061, 0x05AE, 0x065E, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x65E, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x065E, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x65E, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x302A, 0x0316, 0x065F, 0x059A, 0x0062).Str, Uni.new(0x61, 0x316, 0x302A, 0x59A, 0x65F, 0x62).Str, '0x0061, 0x302A, 0x0316, 0x065F, 0x059A, 0x0062 vs. 0x61, 0x316, 0x302A, 0x59A, 0x65F, 0x62';
is Uni.new(0x0061, 0x302A, 0x065F, 0x0316, 0x059A, 0x0062).Str, Uni.new(0x61, 0x65F, 0x302A, 0x59A, 0x316, 0x62).Str, '0x0061, 0x302A, 0x065F, 0x0316, 0x059A, 0x0062 vs. 0x61, 0x65F, 0x302A, 0x59A, 0x316, 0x62';
is Uni.new(0x0061, 0x0652, 0x0670, 0x0670, 0x0711, 0x0062).Str, Uni.new(0x61, 0x670, 0x652, 0x711, 0x670, 0x62).Str, '0x0061, 0x0652, 0x0670, 0x0670, 0x0711, 0x0062 vs. 0x61, 0x670, 0x652, 0x711, 0x670, 0x62';
is Uni.new(0x0061, 0x0652, 0x0670, 0x0670, 0x0711, 0x0062).Str, Uni.new(0x61, 0x670, 0x652, 0x711, 0x670, 0x62).Str, '0x0061, 0x0652, 0x0670, 0x0670, 0x0711, 0x0062 vs. 0x61, 0x670, 0x652, 0x711, 0x670, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x06D6, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x6D6, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x06D6, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x6D6, 0x62';
is Uni.new(0x0061, 0x05AE, 0x06D6, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x6D6, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x06D6, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x6D6, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x06D7, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x6D7, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x06D7, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x6D7, 0x62';
is Uni.new(0x0061, 0x05AE, 0x06D7, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x6D7, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x06D7, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x6D7, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x06D8, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x6D8, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x06D8, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x6D8, 0x62';
is Uni.new(0x0061, 0x05AE, 0x06D8, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x6D8, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x06D8, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x6D8, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x06D9, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x6D9, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x06D9, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x6D9, 0x62';
is Uni.new(0x0061, 0x05AE, 0x06D9, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x6D9, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x06D9, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x6D9, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x06DA, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x6DA, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x06DA, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x6DA, 0x62';
is Uni.new(0x0061, 0x05AE, 0x06DA, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x6DA, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x06DA, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x6DA, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x06DB, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x6DB, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x06DB, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x6DB, 0x62';
is Uni.new(0x0061, 0x05AE, 0x06DB, 0x0300, 0x0315, 0x0062).Str, Uni.new(0x61, 0x6DB, 0x5AE, 0x315, 0x300, 0x62).Str, '0x0061, 0x05AE, 0x06DB, 0x0300, 0x0315, 0x0062 vs. 0x61, 0x6DB, 0x5AE, 0x315, 0x300, 0x62';
is Uni.new(0x0061, 0x05AE, 0x0300, 0x06DC, 0x0315, 0x0062).Str, Uni.new(0x61, 0x300, 0x5AE, 0x315, 0x6DC, 0x62).Str, '0x0061, 0x05AE, 0x0300, 0x06DC, 0x0315, 0x0062 vs. 0x61, 0x300, 0x5AE, 0x315, 0x6DC, 0x62';

# vim: expandtab shiftwidth=4
