/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.condition;

import de.unkrig.commons.nullanalysis.Nullable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class EveryCondition
implements Condition {
    @Nullable
    private Long interval;
    private long expiration;

    public void setMilliseconds(long n) {
        if (this.interval != null) {
            throw new BuildException("Exactly one of 'milliseconds=...', 'seconds=...', 'minutes=...' and 'hours=...' must be configured");
        }
        this.interval = n;
    }

    public void setSeconds(double number) {
        this.setMilliseconds((long)(1000.0 * number));
    }

    public void setMinutes(double number) {
        this.setMilliseconds((long)(60000.0 * number));
    }

    public void setHours(double number) {
        this.setMilliseconds((long)(3600000.0 * number));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean eval() throws BuildException {
        Long interval = this.interval;
        if (interval == null) {
            throw new BuildException("Exactly one of 'seconds=...', 'minutes=...' and 'hours=...' must be configured");
        }
        long now = System.currentTimeMillis();
        EveryCondition everyCondition = this;
        synchronized (everyCondition) {
            if (now > this.expiration) {
                this.expiration = now + interval;
                return true;
            }
        }
        return false;
    }
}

