/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.lang.Comparators;
import de.unkrig.commons.nullanalysis.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public abstract class EventCounter {
    protected final Map<String, AtomicLong> events = new HashMap<String, AtomicLong>();
    protected final List<Map.Entry<String, AtomicLong>> sortedEvents = new ArrayList<Map.Entry<String, AtomicLong>>();

    public void countEvent(String eventName) {
        this.countEvent(eventName, null);
    }

    public void countEvent(String eventName, @Nullable Object arg) {
        if (arg == null) {
            this.increment(eventName, 1L);
        } else if (arg instanceof Number) {
            this.increment(eventName, 1L);
            this.increment(eventName + "_", ((Number)arg).longValue());
        } else {
            this.increment(eventName, 1L);
            this.increment(eventName + ":" + arg, 1L);
        }
    }

    private void increment(String key, long delta) {
        AtomicLong value = this.events.get(key);
        if (value == null) {
            value = new AtomicLong(delta);
            this.events.put(key, value);
            this.sortedEvents.clear();
            this.sortedEvents.addAll(this.events.entrySet());
            Collections.sort(this.sortedEvents, Comparators.keyComparator(Comparators.nullSafeComparator(Comparators.naturalOrderComparator())));
        } else {
            value.addAndGet(delta);
        }
    }
}

