/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.protocol;

import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.NoException;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.lang.protocol.Tuple2;
import de.unkrig.commons.lang.protocol.Tuple3;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class ConsumerUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Consumer<?> NOP = new Consumer<Object>(){

        @Override
        public void consume(Object subject) {
        }
    };

    private ConsumerUtil() {
    }

    public static <T, EX extends Throwable> ConsumerWhichThrows<T, EX> tee(final ConsumerWhichThrows<? super T, EX> delegate1, final ConsumerWhichThrows<? super T, EX> delegate2) {
        return new ConsumerWhichThrows<T, EX>(){

            @Override
            public void consume(T subject) throws Throwable {
                delegate1.consume(subject);
                delegate2.consume(subject);
            }
        };
    }

    public static <T> Consumer<T> tee(final Consumer<? super T> delegate1, final Consumer<? super T> delegate2) {
        return new Consumer<T>(){

            @Override
            public void consume(T subject) {
                delegate1.consume(subject);
                delegate2.consume(subject);
            }
        };
    }

    public static <T, EX extends Throwable> ConsumerWhichThrows<T, EX> tee(final Collection<ConsumerWhichThrows<? super T, EX>> delegates) {
        return new ConsumerWhichThrows<T, EX>(){

            @Override
            public void consume(T subject) throws Throwable {
                for (ConsumerWhichThrows delegate : delegates) {
                    delegate.consume(subject);
                }
            }
        };
    }

    @Deprecated
    public static <T, EX extends Throwable> ConsumerWhichThrows<T, EX> asConsumerWhichThrows(final Consumer<? super T> source) {
        return new ConsumerWhichThrows<T, EX>(){

            @Override
            public void consume(T subject) {
                source.consume(subject);
            }
        };
    }

    @Deprecated
    public static <T, EX extends Throwable> ConsumerWhichThrows<T, EX> widen(ConsumerWhichThrows<? super T, ? extends EX> source) {
        ConsumerWhichThrows<? super T, ? extends EX> result = source;
        return result;
    }

    public static <T, EX extends Throwable> ConsumerWhichThrows<T, EX> widen2(ConsumerWhichThrows<? super T, ? extends RuntimeException> source) {
        ConsumerWhichThrows<? super T, ? extends RuntimeException> result = source;
        return result;
    }

    public static <T, EX extends RuntimeException> Consumer<T> asConsumer(ConsumerWhichThrows<? super T, ? extends RuntimeException> source) {
        Consumer result = (Consumer)source;
        return result;
    }

    @NotNullByDefault(value=false)
    public static Writer characterConsumerWriter(final ConsumerWhichThrows<? super Character, IOException> delegate) {
        return new Writer(){

            @Override
            public void write(int c) throws IOException {
                delegate.consume(Character.valueOf((char)c));
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                while (len > 0) {
                    this.write(cbuf[off++]);
                    --len;
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
    }

    public static <E extends Exception> ConsumerWhichThrows<Character, E> lineAggregator(final ConsumerWhichThrows<? super String, E> delegate) {
        return new ConsumerWhichThrows<Character, E>(){
            private final StringBuilder sb = new StringBuilder();
            private boolean crPending;

            @Override
            public void consume(Character c) throws Exception {
                if (c.charValue() == '\r') {
                    delegate.consume(this.sb.toString());
                    this.sb.setLength(0);
                    this.crPending = true;
                } else if (c.charValue() == '\n') {
                    if (this.crPending) {
                        this.crPending = false;
                    } else {
                        delegate.consume(this.sb.toString());
                        this.sb.setLength(0);
                    }
                } else {
                    this.crPending = false;
                    this.sb.append(c);
                }
            }
        };
    }

    public static ConsumerWhichThrows<String, IOException> lineConsumer(File file, boolean append) throws IOException {
        return ConsumerUtil.lineConsumer(new FileWriter(file, append), true);
    }

    public static ConsumerWhichThrows<String, IOException> lineConsumer(File file, String charsetName, boolean append) throws IOException {
        return ConsumerUtil.lineConsumer(new FileOutputStream(file, append), charsetName, true);
    }

    private static ConsumerWhichThrows<String, IOException> lineConsumer(OutputStream stream, String charsetName, boolean closeOnFinalize) throws UnsupportedEncodingException {
        return ConsumerUtil.lineConsumer(new OutputStreamWriter(stream, charsetName), closeOnFinalize);
    }

    public static ConsumerWhichThrows<String, IOException> lineConsumer(final Writer writer, final boolean closeOnFinalize) {
        return new ConsumerWhichThrows<String, IOException>(){

            @Override
            public void consume(String line) throws IOException {
                writer.write(line + LINE_SEPARATOR);
                writer.flush();
            }

            protected void finalize() throws Throwable {
                if (closeOnFinalize) {
                    writer.close();
                }
            }
        };
    }

    public static Consumer<String> lineConsumer(final PrintStream printStream, final boolean closeOnFinalize) {
        return new Consumer<String>(){

            @Override
            public void consume(String line) {
                printStream.println(line);
            }

            protected void finalize() {
                if (closeOnFinalize) {
                    printStream.close();
                }
            }

            public String toString() {
                return printStream.toString();
            }
        };
    }

    public static <T> Producer<Consumer<T>> combine(final Consumer<? super T> target) {
        return new Producer<Consumer<T>>(){

            @Override
            public Consumer<T> produce() {
                return new Consumer<T>(){

                    @Override
                    public void consume(T subject) {
                        target.consume(subject);
                    }
                };
            }
        };
    }

    public static <T, EX extends Throwable> Producer<ConsumerWhichThrows<T, EX>> combineInOrder(final ConsumerWhichThrows<? super T, EX> target) {
        final LinkedList outstanding = new LinkedList();
        final HashMap postponed = new HashMap();
        return new Producer<ConsumerWhichThrows<T, EX>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ConsumerWhichThrows<T, EX> produce() {
                ConsumerWhichThrows consumer = new ConsumerWhichThrows<T, EX>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void consume(T subject) throws Throwable {
                        Queue queue = outstanding;
                        synchronized (queue) {
                            if (outstanding.isEmpty()) {
                                throw new IllegalStateException("Can consume only one subject");
                            }
                            if (outstanding.peek() == this) {
                                outstanding.remove();
                                target.consume(subject);
                                while (!outstanding.isEmpty() && postponed.containsKey(outstanding.element())) {
                                    target.consume(postponed.get(outstanding.remove()));
                                }
                            } else {
                                if (postponed.containsKey(this)) {
                                    throw new IllegalStateException("Can consume only one subject");
                                }
                                postponed.put(this, subject);
                            }
                        }
                    }
                };
                Queue queue = outstanding;
                synchronized (queue) {
                    outstanding.add(consumer);
                }
                return consumer;
            }
        };
    }

    public static <T, EX extends Throwable> List<ConsumerWhichThrows<T, EX>> splice(final int n, final ConsumerWhichThrows<? super List<T>, EX> target) {
        final ArrayList buffers = new ArrayList(n);
        ArrayList<ConsumerWhichThrows<T, EX>> consumers = new ArrayList<ConsumerWhichThrows<T, EX>>(n);
        for (int i = 0; i < n; ++i) {
            consumers.add(new ConsumerWhichThrows<T, EX>(){
                final Queue<T> buffer = new LinkedList();
                {
                    buffers.add(this.buffer);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void consume(T subject) throws Throwable {
                    List list = buffers;
                    synchronized (list) {
                        this.buffer.add(subject);
                        for (Queue b : buffers) {
                            if (!b.isEmpty()) continue;
                            return;
                        }
                        ArrayList subjects = new ArrayList(n);
                        for (Queue b : buffers) {
                            subjects.add(b.remove());
                        }
                        target.consume(subjects);
                    }
                }
            });
        }
        return consumers;
    }

    public static <T> Consumer<T> addToCollection(final Collection<T> drain) {
        return new Consumer<T>(){

            @Override
            public void consume(T subject) {
                drain.add(subject);
            }
        };
    }

    public static <EX extends Throwable> ConsumerWhichThrows<EX, EX> throwsSubject() {
        return new ConsumerWhichThrows<EX, EX>(){

            @Override
            public void consume(EX throwable) throws Throwable {
                throw throwable;
            }
        };
    }

    public static <T> Produmer<T, T> store() {
        return ConsumerUtil.store(null);
    }

    public static <T> Produmer<T, T> store(final @Nullable T initialValue) {
        return new Produmer<T, T>(){
            @Nullable
            private T store;
            {
                this.store = initialValue;
            }

            @Override
            public void consume(T subject) {
                this.store = subject;
            }

            @Override
            @Nullable
            public T produce() {
                return this.store;
            }
        };
    }

    public static <EX extends Throwable> ConsumerWhichThrows<Number, EX> cumulate(ConsumerWhichThrows<? super Long, EX> delegate) {
        return ConsumerUtil.cumulate(delegate, 0L);
    }

    public static <EX extends Throwable> ConsumerWhichThrows<Number, EX> cumulate(final ConsumerWhichThrows<? super Long, EX> delegate, final long initialCount) {
        return new ConsumerWhichThrows<Number, EX>(){
            long count;
            {
                this.count = initialCount;
            }

            @Override
            public void consume(Number n) throws Throwable {
                delegate.consume(this.count += n.longValue());
            }
        };
    }

    public static Produmer<Long, Number> cumulate() {
        return ConsumerUtil.cumulate(0L);
    }

    public static Produmer<Long, Number> cumulate(final long initialValue) {
        return new Produmer<Long, Number>(){
            long count;
            {
                this.count = initialValue;
            }

            @Override
            public void consume(Number n) {
                this.count += n.longValue();
            }

            @Override
            @Nullable
            public Long produce() {
                return this.count;
            }
        };
    }

    public static Consumer<Long> compressExponentially(final long initialLimit, final Consumer<? super Long> delegate) {
        return new Consumer<Long>(){
            long limit;
            {
                this.limit = initialLimit;
            }

            @Override
            public void consume(Long n) {
                if (n >= this.limit) {
                    delegate.consume(n);
                    do {
                        this.limit <<= 1;
                    } while (n >= this.limit);
                }
            }
        };
    }

    public static <T> Consumer<T> compress(final Consumer<T> delegate, final Predicate<T> compressable) {
        return new Consumer<T>(){

            @Override
            public void consume(T subject) {
                if (!compressable.evaluate(subject)) {
                    delegate.consume(subject);
                }
            }
        };
    }

    public static <T> Consumer<T> compress(final Consumer<? super T> delegate, final Predicate<? super T> compressable, final T compressed) {
        return new Consumer<T>(){
            int state;

            @Override
            public void consume(T subject) {
                boolean isCompressable = compressable.evaluate(subject);
                if (isCompressable) {
                    if (this.state == 1) {
                        this.state = 2;
                    }
                } else {
                    if (this.state == 2) {
                        delegate.consume(compressed);
                    }
                    delegate.consume(subject);
                    this.state = 1;
                }
            }
        };
    }

    public static <T> Consumer<T> nop() {
        return NOP;
    }

    public static <T, EX extends Throwable> Consumer<T> ignoreExceptions(final Class<EX> exceptionClass, final ConsumerWhichThrows<T, ? extends EX> delegate) {
        return new Consumer<T>(){

            @Override
            public void consume(@Nullable T subject) {
                block7: {
                    assert (subject != null);
                    try {
                        delegate.consume(subject);
                    }
                    catch (RuntimeException re) {
                        if (!exceptionClass.isAssignableFrom(re.getClass())) {
                            throw re;
                        }
                    }
                    catch (Error e) {
                        if (!exceptionClass.isAssignableFrom(e.getClass())) {
                            throw e;
                        }
                    }
                    catch (Throwable t) {
                        if ($assertionsDisabled || exceptionClass.isAssignableFrom(t.getClass())) break block7;
                        throw new AssertionError();
                    }
                }
            }
        };
    }

    public static <T, EX extends Throwable> void head(Iterable<? extends T> subject, int n, ConsumerWhichThrows<? super T, ? extends EX> delegate1, ConsumerWhichThrows<? super T, ? extends EX> delegate2) throws EX {
        ConsumerUtil.head(subject.iterator(), n, delegate1, delegate2);
    }

    public static <T, EX extends Throwable> void head(Iterator<? extends T> subject, int n, ConsumerWhichThrows<? super T, ? extends EX> delegate1, ConsumerWhichThrows<? super T, ? extends EX> delegate2) throws EX {
        ConsumerWhichThrows<T, EX> c = ConsumerUtil.head(n, delegate1, delegate2);
        while (subject.hasNext()) {
            c.consume(subject.next());
        }
    }

    public static <T, EX extends Throwable> ConsumerWhichThrows<T, EX> head(final int n, final ConsumerWhichThrows<? super T, ? extends EX> delegate1, final ConsumerWhichThrows<? super T, ? extends EX> delegate2) {
        return new ConsumerWhichThrows<T, EX>(){
            final AtomicInteger count = new AtomicInteger();

            @Override
            public void consume(T subject) throws Throwable {
                if (this.count.getAndIncrement() < n) {
                    delegate1.consume(subject);
                } else {
                    delegate2.consume(subject);
                }
            }
        };
    }

    public static <T, EX extends Throwable> ConsumerWhichThrows<T, EX> head(final int n, final ConsumerWhichThrows<T, EX> delegate) {
        return new ConsumerWhichThrows<T, EX>(){
            private final AtomicInteger remaining;
            {
                this.remaining = new AtomicInteger(n);
            }

            @Override
            public void consume(T subject) throws Throwable {
                if (this.remaining.getAndDecrement() > 0) {
                    delegate.consume(subject);
                }
            }
        };
    }

    public static <T, EX extends Throwable> void tail(Iterator<? extends T> subject, int n, ConsumerWhichThrows<? super T, ? extends EX> delegate1, ConsumerWhichThrows<? super T, ? extends EX> delegate2) throws EX {
        ArrayList<T> tmp = new ArrayList<T>();
        while (subject.hasNext()) {
            tmp.add(subject.next());
        }
        ConsumerUtil.tail(tmp, n, delegate1, delegate2);
    }

    public static <T, EX extends Throwable> void tail(Collection<? extends T> subject, int n, ConsumerWhichThrows<? super T, ? extends EX> delegate1, ConsumerWhichThrows<? super T, ? extends EX> delegate2) throws EX {
        int size = subject.size();
        Iterator<T> it = subject.iterator();
        for (int i = 0; i < size - n && it.hasNext(); ++i) {
            delegate1.consume(it.next());
        }
        while (it.hasNext()) {
            delegate2.consume(it.next());
        }
    }

    public static <T, EX extends Throwable> ConsumerWhichThrows<T, EX> count(final AtomicInteger delegate) {
        return new ConsumerWhichThrows<T, EX>(){

            @Override
            public void consume(T subject) {
                delegate.incrementAndGet();
            }
        };
    }

    public static <T1, T2, EX extends Throwable> ConsumerWhichThrows<Tuple2<T1, T2>, EX> getFirstOfTuple2(final ConsumerWhichThrows<T1, EX> delegate) {
        return new ConsumerWhichThrows<Tuple2<T1, T2>, EX>(){

            @Override
            public void consume(Tuple2<T1, T2> subject) throws Throwable {
                delegate.consume(subject.first);
            }
        };
    }

    public static <T1, T2, EX extends Throwable> ConsumerWhichThrows<Tuple2<T1, T2>, EX> getSecondOfTuple2(final ConsumerWhichThrows<T2, EX> delegate) {
        return new ConsumerWhichThrows<Tuple2<T1, T2>, EX>(){

            @Override
            public void consume(Tuple2<T1, T2> subject) throws Throwable {
                delegate.consume(subject.second);
            }
        };
    }

    public static <T1, T2, T3, EX extends Throwable> ConsumerWhichThrows<Tuple3<T1, T2, T3>, EX> getFirstOfTuple3(final ConsumerWhichThrows<T1, EX> delegate) {
        return new ConsumerWhichThrows<Tuple3<T1, T2, T3>, EX>(){

            @Override
            public void consume(Tuple3<T1, T2, T3> subject) throws Throwable {
                delegate.consume(subject.first);
            }
        };
    }

    public static <T1, T2, T3, EX extends Throwable> ConsumerWhichThrows<Tuple3<T1, T2, T3>, EX> getSecondOfTuple3(final ConsumerWhichThrows<T2, EX> delegate) {
        return new ConsumerWhichThrows<Tuple3<T1, T2, T3>, EX>(){

            @Override
            public void consume(Tuple3<T1, T2, T3> subject) throws Throwable {
                delegate.consume(subject.second);
            }
        };
    }

    public static <T1, T2, T3, EX extends Throwable> ConsumerWhichThrows<Tuple3<T1, T2, T3>, EX> getThirdOfTuple3(final ConsumerWhichThrows<T3, EX> delegate) {
        return new ConsumerWhichThrows<Tuple3<T1, T2, T3>, EX>(){

            @Override
            public void consume(Tuple3<T1, T2, T3> subject) throws Throwable {
                delegate.consume(subject.third);
            }
        };
    }

    public static <T1, T2, EX extends Throwable> ConsumerWhichThrows<Tuple2<T1, T2>, EX> put(final Map<T1, T2> delegate) {
        return new ConsumerWhichThrows<Tuple2<T1, T2>, EX>(){

            @Override
            public void consume(Tuple2<T1, T2> subject) {
                delegate.put(subject.first, subject.second);
            }
        };
    }

    public static <T extends Number> Consumer<T> add(final AtomicInteger delegate) {
        return new Consumer<T>(){

            @Override
            public void consume(T subject) {
                delegate.addAndGet(((Number)subject).intValue());
            }
        };
    }

    public static <T extends Number> Consumer<T> add(final AtomicLong delegate) {
        return new Consumer<T>(){

            @Override
            public void consume(T subject) {
                delegate.addAndGet(((Number)subject).longValue());
            }
        };
    }

    public static interface ProdumerWhichThrows<PT, PEX extends Throwable, CT, CEX extends Throwable>
    extends ProducerWhichThrows<PT, PEX>,
    ConsumerWhichThrows<CT, CEX> {
    }

    public static interface Produmer<PT, CT>
    extends ProdumerWhichThrows<PT, NoException, CT, NoException> {
    }
}

