/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.http;

import de.unkrig.commons.net.http.HttpMessage;
import de.unkrig.commons.net.http.HttpRequest;
import de.unkrig.commons.net.http.InvalidHttpMessageException;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpResponse
extends HttpMessage {
    private static final Logger LOGGER = Logger.getLogger(HttpResponse.class.getName());
    private static final Pattern STATUS_LINE_PATTERN = Pattern.compile("HTTP/(\\d+\\.\\d+) (\\d+) (.*)");
    private String httpVersion;
    private final Status status;
    private String reasonPhrase;

    public HttpResponse(InputStream bodyStream) {
        this(Status.OK, bodyStream);
    }

    public HttpResponse(Status status, String body) {
        super(status.hasBody());
        this.httpVersion = "1.1";
        this.status = status;
        this.reasonPhrase = status.getReasonPhrase();
        this.setBody(HttpMessage.body(body, this.getCharset()));
    }

    public HttpResponse(Status status, InputStream bodyStream) {
        super(status.hasBody());
        this.httpVersion = "1.1";
        this.status = status;
        this.reasonPhrase = status.getReasonPhrase();
        this.setBody(HttpMessage.body(bodyStream));
    }

    public HttpResponse(Status status, File contentsFile) throws FileNotFoundException {
        this(status, new FileInputStream(contentsFile));
    }

    public HttpResponse(Status status, HttpMessage.Body body) {
        super(status.hasBody());
        this.httpVersion = "1.1";
        this.status = status;
        this.reasonPhrase = status.getReasonPhrase();
        this.setBody(body);
    }

    private HttpResponse(String httpVersion, Status status, String reasonPhrase, InputStream in, HttpRequest.Method requestMethod, String loggingPrefix) throws IOException {
        super(in, !"0.9".equals(httpVersion), requestMethod != HttpRequest.Method.HEAD && status.hasBody() ? HttpMessage.HasBody.TRUE : HttpMessage.HasBody.FALSE, loggingPrefix);
        this.httpVersion = httpVersion;
        this.status = status;
        this.reasonPhrase = reasonPhrase;
    }

    public static HttpResponse read(InputStream in, String httpVersion, HttpRequest.Method requestMethod) throws IOException {
        return HttpResponse.read(in, httpVersion, requestMethod, ">>> ");
    }

    public static HttpResponse read(InputStream in, String httpVersion, HttpRequest.Method requestMethod, String loggingPrefix) throws IOException {
        String reasonPhrase;
        Status status;
        if ("0.9".equals(httpVersion)) {
            status = Status.OK;
            reasonPhrase = status.getReasonPhrase();
        } else {
            int statusCode;
            Matcher m;
            String statusLine = HttpMessage.readLine(in);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(loggingPrefix + "Received status line \"" + statusLine + "\"");
            }
            if (!(m = STATUS_LINE_PATTERN.matcher(statusLine)).matches()) {
                throw new InvalidHttpMessageException("Invalid status line");
            }
            httpVersion = m.group(1);
            try {
                statusCode = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException nfe) {
                throw new InvalidHttpMessageException("Invalid status code '" + m.group(2) + "'");
            }
            status = Status.fromCode(statusCode);
            if (status == null) {
                throw new InvalidHttpMessageException("Invalid status code '" + statusCode + "'");
            }
            reasonPhrase = m.group(3);
        }
        return new HttpResponse(httpVersion, status, reasonPhrase, in, requestMethod, loggingPrefix);
    }

    public void write(OutputStream out) throws IOException {
        this.write(out, "<<< ");
    }

    public void write(OutputStream out, String loggingPrefix) throws IOException {
        String statusLine = "HTTP/" + this.httpVersion + ' ' + this.status.getCode() + ' ' + this.reasonPhrase;
        LOGGER.fine(loggingPrefix + statusLine);
        out.write((statusLine + "\r\n").getBytes("ASCII"));
        this.writeHeadersAndBody(loggingPrefix, out);
    }

    public boolean isProvisional() {
        return this.status.isInformational();
    }

    public static HttpResponse redirect(String targetURI) {
        HttpResponse httpResponse = new HttpResponse(Status.SEE_OTHER, "This page has temporarily moved to '" + targetURI + "'.");
        httpResponse.setHeader("Location", targetURI);
        return httpResponse;
    }

    public static HttpResponse response(Status status) {
        return new HttpResponse(status, status.reasonPhrase);
    }

    public static HttpResponse response(Status status, String body) {
        return new HttpResponse(status, body);
    }

    public static HttpResponse response(Status status, InputStream bodyStream) {
        return new HttpResponse(status, bodyStream);
    }

    public static HttpResponse response(Status status, HttpMessage.Body body) {
        HttpResponse httpResponse = new HttpResponse(status, body);
        httpResponse.setHeader("Content-Type", "text/plain");
        return httpResponse;
    }

    public Status getStatus() {
        return this.status;
    }

    public static enum Status {
        CONTINUE(100, "Continue", false),
        SWITCHING_PROTOCOLS(101, "Switching Protocols", false),
        OK(200, "OK", true),
        CREATED(201, "Created", true),
        ACCEPTED(202, "Accepted", true),
        NON_AUTHORITATIVE_INFORMATION(203, "Non-Authoritative Information", true),
        NO_CONTENT(204, "No Content", false),
        RESET_CONTENT(205, "Reset Content", true),
        PARTIAL_CONTENT(206, "Partial Content", true),
        MULTIPLE_CHOICES(300, "Multiple Choices", true),
        MOVED_PERMANENTLY(301, "Moved Permanently", true),
        FOUND(302, "Found", true),
        SEE_OTHER(303, "See Other", true),
        NOT_MODIFIED(304, "Not Modified", false),
        USE_PROXY(305, "Use Proxy", true),
        TEMPORARY_REDIRECT(307, "Temporary Redirect", true),
        BAD_REQUEST(400, "Bad Request", true),
        UNAUTHORIZED(401, "Unauthorized", true),
        PAYMENT_REQUIRED(402, "Payment Required", true),
        FORBIDDEN(403, "Forbidden", true),
        NOT_FOUND(404, "Not Found", true),
        METHOD_NOT_ALLOWED(405, "Method Not Allowed", true),
        NOT_ACCEPTABLE(406, "Not Acceptable", true),
        PROXY_AUTHENTICATION_REQUIRED(407, "Proxy Authentication Required", true),
        REQUEST_TIMEOUT(408, "Request Time-out", true),
        CONFLICT(409, "Conflict", true),
        GONE(410, "Gone", true),
        LENGTH_REQUIRED(411, "Length Required", true),
        PRECONDITION_FAILED(412, "Precondition Failed", true),
        REQUEST_ENTITY_TOO_LARGE(413, "Request Entity Too Large", true),
        REQEST_URI_TOO_LONG(414, "Request-URI Too Large", true),
        UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type", true),
        REQUESTED_RANGE_NOT_SATISFIABLE(416, "Requested range not satisfiable", true),
        EXPECTATION_FAILED(417, "Expectation Failed", true),
        INTERNAL_SERVER_ERROR(500, "Internal Server Error", true),
        NOT_IMPLEMENTED(501, "Not Implemented", true),
        BAD_GATEWAY(502, "Bad Gateway", true),
        SERVICE_UNAVAILABLE(503, "Service Unavailable", true),
        GATEWAY_TIMEOUT(504, "Gateway Time-out", true),
        HTTP_VERSION_NOT_SUPPORTED(505, "HTTP Version not supported", true);

        private final int code;
        private final String reasonPhrase;
        private final boolean hasBody;
        private static final Map<Integer, Status> CODE_TO_STATUS;

        private Status(int code, String reasonPhrase, boolean hasBody) {
            this.code = code;
            this.reasonPhrase = reasonPhrase;
            this.hasBody = hasBody;
        }

        public int getCode() {
            return this.code;
        }

        public String getReasonPhrase() {
            return this.reasonPhrase;
        }

        public boolean hasBody() {
            return this.hasBody;
        }

        @Nullable
        public static Status fromCode(int code) {
            return CODE_TO_STATUS.get(code);
        }

        public boolean isInformational() {
            return this.code >= 100 && this.code < 200;
        }

        public String toString() {
            return this.code + " " + this.name();
        }

        static {
            CODE_TO_STATUS = new HashMap<Integer, Status>();
            for (Status status : Status.values()) {
                CODE_TO_STATUS.put(status.code, status);
            }
        }
    }
}

