/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.http.servlett;

import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.net.http.HttpRequest;
import de.unkrig.commons.net.http.HttpResponse;
import de.unkrig.commons.net.http.servlett.Servlett;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.IOException;

public class AbstractServlett
implements Servlett {
    @Override
    @Nullable
    public HttpResponse handleRequest(HttpRequest request, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) throws IOException {
        HttpResponse response;
        switch (request.getMethod()) {
            case GET: {
                response = this.get(request, sendProvisionalResponse);
                break;
            }
            case HEAD: {
                response = this.head(request, sendProvisionalResponse);
                break;
            }
            case POST: {
                response = this.post(request, sendProvisionalResponse);
                break;
            }
            case PUT: {
                response = this.put(request, sendProvisionalResponse);
                break;
            }
            case CONNECT: {
                response = this.connect(request, sendProvisionalResponse);
                if (response.getStatus().getCode() > 299) break;
                response.setAttemptUnstreaming(false);
                break;
            }
            default: {
                throw new IllegalStateException(request.toString());
            }
        }
        if (response.isProvisional()) {
            throw new IllegalStateException("Request handler method returned a provisional response: " + response);
        }
        return response;
    }

    protected HttpResponse get(HttpRequest httpRequest, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) throws IOException {
        return this.getOrPost(httpRequest, sendProvisionalResponse);
    }

    protected HttpResponse head(HttpRequest httpRequest, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) throws IOException {
        return HttpResponse.response(HttpResponse.Status.BAD_REQUEST, "Method '" + (Object)((Object)httpRequest.getMethod()) + "' not implemented");
    }

    protected HttpResponse post(HttpRequest httpRequest, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) throws IOException {
        return this.getOrPost(httpRequest, sendProvisionalResponse);
    }

    protected HttpResponse put(HttpRequest httpRequest, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) throws IOException {
        return HttpResponse.response(HttpResponse.Status.BAD_REQUEST, "Method '" + (Object)((Object)httpRequest.getMethod()) + "' not implemented");
    }

    protected HttpResponse connect(HttpRequest httpRequest, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) {
        return HttpResponse.response(HttpResponse.Status.BAD_REQUEST, "Method '" + (Object)((Object)httpRequest.getMethod()) + "' not implemented");
    }

    protected HttpResponse getOrPost(HttpRequest httpRequest, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) throws IOException {
        return HttpResponse.response(HttpResponse.Status.BAD_REQUEST, "Method '" + (Object)((Object)httpRequest.getMethod()) + "' not implemented");
    }

    @Override
    public void close() throws IOException {
    }
}

