/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text;

import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.AbstractPrinter;
import de.unkrig.commons.text.Printer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.EnumSet;

public final class Printers {
    public static final AbstractPrinter DEFAULT_PRINTER = new AbstractPrinter(){

        @Override
        public void error(@Nullable String message) {
            System.err.println(message);
        }

        @Override
        public void warn(@Nullable String message) {
            System.err.println(message);
        }

        @Override
        public void info(@Nullable String message) {
            System.out.println(message);
        }

        @Override
        public void verbose(@Nullable String message) {
            System.out.println(message);
        }

        @Override
        public void debug(@Nullable String message) {
            System.out.println(message);
        }
    };
    public static final AbstractPrinter NORMAL_PRINTER = new AbstractPrinter(){

        @Override
        public void error(@Nullable String message) {
            System.err.println(message);
        }

        @Override
        public void warn(@Nullable String message) {
            System.err.println(message);
        }

        @Override
        public void info(@Nullable String message) {
            System.out.println(message);
        }

        @Override
        public void verbose(@Nullable String message) {
        }

        @Override
        public void debug(@Nullable String message) {
        }
    };
    public static final AbstractPrinter MUTE_PRINTER = new AbstractPrinter(){

        @Override
        public void error(@Nullable String message) {
        }

        @Override
        public void warn(@Nullable String message) {
        }

        @Override
        public void info(@Nullable String message) {
        }

        @Override
        public void verbose(@Nullable String message) {
        }

        @Override
        public void debug(@Nullable String message) {
        }
    };

    private Printers() {
    }

    @Deprecated
    public static Printer get() {
        return AbstractPrinter.getContextPrinter();
    }

    public static void error(@Nullable String message) {
        Printers.get().error(message);
    }

    public static void error(String pattern, Object ... arguments) {
        AbstractPrinter.getContextPrinter().error(pattern, arguments);
    }

    public static void error(@Nullable String message, Throwable t) {
        AbstractPrinter.getContextPrinter().error(message, t);
    }

    public static void error(String pattern, Throwable t, Object ... arguments) {
        AbstractPrinter.getContextPrinter().error(pattern, t, arguments);
    }

    public static void warn(@Nullable String message) {
        AbstractPrinter.getContextPrinter().warn(message);
    }

    public static void warn(String pattern, Object ... arguments) {
        AbstractPrinter.getContextPrinter().warn(pattern, arguments);
    }

    public static void info(@Nullable String message) {
        AbstractPrinter.getContextPrinter().info(message);
    }

    public static void info(String pattern, Object ... arguments) {
        AbstractPrinter.getContextPrinter().info(pattern, arguments);
    }

    public static void verbose(@Nullable String message) {
        AbstractPrinter.getContextPrinter().verbose(message);
    }

    public static void verbose(String pattern, Object ... arguments) {
        AbstractPrinter.getContextPrinter().verbose(pattern, arguments);
    }

    public static void debug(@Nullable String message) {
        AbstractPrinter.getContextPrinter().debug(message);
    }

    public static void debug(String pattern, Object ... arguments) {
        AbstractPrinter.getContextPrinter().debug(pattern, arguments);
    }

    @Deprecated
    public static synchronized void withPrinter(Printer printer, Runnable runnable) {
        AbstractPrinter ap = printer instanceof AbstractPrinter ? (AbstractPrinter)printer : AbstractPrinter.fromPrinter(printer);
        ap.run(runnable);
    }

    @Deprecated
    public static synchronized <EX extends Throwable> void withPrinter(Printer printer, RunnableWhichThrows<EX> runnable) throws EX {
        AbstractPrinter ap = printer instanceof AbstractPrinter ? (AbstractPrinter)printer : AbstractPrinter.fromPrinter(printer);
        ap.run(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <EX extends Throwable> void redirectToFile(final @Nullable AbstractPrinter.Level level, @Nullable File file, @Nullable Charset charset, RunnableWhichThrows<EX> runnable) throws IOException, EX {
        if (level == null || file == null) {
            runnable.run();
            return;
        }
        FileOutputStream os = new FileOutputStream(file);
        final PrintWriter pw = new PrintWriter(charset == null ? new OutputStreamWriter(os) : new OutputStreamWriter((OutputStream)os, charset));
        try {
            final AbstractPrinter delegate = AbstractPrinter.getContextPrinter();
            new AbstractPrinter(){

                @Override
                public void error(@Nullable String message) {
                    if (level == AbstractPrinter.Level.ERROR) {
                        pw.println(message);
                    } else {
                        delegate.error(message);
                    }
                }

                @Override
                public void warn(@Nullable String message) {
                    if (level == AbstractPrinter.Level.WARN) {
                        pw.println(message);
                    } else {
                        delegate.warn(message);
                    }
                }

                @Override
                public void info(@Nullable String message) {
                    if (level == AbstractPrinter.Level.INFO) {
                        pw.println(message);
                    } else {
                        delegate.info(message);
                    }
                }

                @Override
                public void verbose(@Nullable String message) {
                    if (level == AbstractPrinter.Level.VERBOSE) {
                        pw.println(message);
                    } else {
                        delegate.verbose(message);
                    }
                }

                @Override
                public void debug(@Nullable String message) {
                    if (level == AbstractPrinter.Level.DEBUG) {
                        pw.println(message);
                    } else {
                        delegate.debug(message);
                    }
                }
            }.run(runnable);
            pw.close();
        }
        finally {
            try {
                pw.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <EX extends Throwable> void redirectToFile(final @Nullable EnumSet<AbstractPrinter.Level> levels, @Nullable File file, @Nullable Charset charset, @Nullable Printer delegate, RunnableWhichThrows<EX> runnable) throws IOException, EX {
        Printer delegate2;
        Printer printer = delegate2 = delegate != null ? delegate : AbstractPrinter.getContextPrinter();
        if (levels == null || levels.isEmpty() || file == null) {
            AbstractPrinter.fromPrinter(delegate2).run(runnable);
            return;
        }
        FileOutputStream os = new FileOutputStream(file);
        try {
            final PrintWriter pw = new PrintWriter(charset == null ? new OutputStreamWriter(os) : new OutputStreamWriter((OutputStream)os, charset));
            new AbstractPrinter(){

                @Override
                public void error(@Nullable String message) {
                    if (levels.contains((Object)AbstractPrinter.Level.ERROR)) {
                        pw.println(message);
                    } else {
                        delegate2.error(message);
                    }
                }

                @Override
                public void warn(@Nullable String message) {
                    if (levels.contains((Object)AbstractPrinter.Level.WARN)) {
                        pw.println(message);
                    } else {
                        delegate2.warn(message);
                    }
                }

                @Override
                public void info(@Nullable String message) {
                    if (levels.contains((Object)AbstractPrinter.Level.INFO)) {
                        pw.println(message);
                    } else {
                        delegate2.info(message);
                    }
                }

                @Override
                public void verbose(@Nullable String message) {
                    if (levels.contains((Object)AbstractPrinter.Level.VERBOSE)) {
                        pw.println(message);
                    } else {
                        delegate2.verbose(message);
                    }
                }

                @Override
                public void debug(@Nullable String message) {
                    if (levels.contains((Object)AbstractPrinter.Level.DEBUG)) {
                        pw.println(message);
                    } else {
                        delegate2.debug(message);
                    }
                }
            }.run(runnable);
            pw.close();
        }
        finally {
            try {
                os.close();
            }
            catch (Exception exception) {}
        }
    }

    @Deprecated
    public static <EX extends Throwable> void redirectInfoToFile(@Nullable File file, @Nullable Charset charset, RunnableWhichThrows<EX> runnable) throws IOException, EX {
        Printers.redirectToFile(AbstractPrinter.Level.INFO, file, charset, runnable);
    }

    @Deprecated
    public static <EX extends Throwable> void redirectInfo(@Nullable Writer writer, RunnableWhichThrows<EX> runnable) throws EX {
        AbstractPrinter.getContextPrinter().redirectInfo(writer).run(runnable);
    }

    @Deprecated
    public static <EX extends Throwable> void redirectInfo(@Nullable ConsumerWhichThrows<? super String, ? extends RuntimeException> infoConsumer, RunnableWhichThrows<? extends EX> runnable) throws EX {
        AbstractPrinter.getContextPrinter().redirectInfo(infoConsumer).run(runnable);
    }
}

