/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.FieldIdentifier;
import sun.jvm.hotspot.debugger.cdbg.FunctionType;
import sun.jvm.hotspot.debugger.cdbg.ObjectVisitor;
import sun.jvm.hotspot.debugger.cdbg.Type;
import sun.jvm.hotspot.debugger.cdbg.TypeVisitor;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicType;
import sun.jvm.hotspot.debugger.cdbg.basic.ResolveListener;

public class BasicFunctionType
extends BasicType
implements FunctionType {
    private Type returnType;
    private List argumentTypes;

    public BasicFunctionType(String name, int size, Type returnType) {
        this(name, size, returnType, 0);
    }

    protected BasicFunctionType(String name, int size, Type returnType, int cvAttributes) {
        super(name, size, cvAttributes);
        this.returnType = returnType;
    }

    @Override
    public FunctionType asFunction() {
        return this;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public int getNumArguments() {
        return this.argumentTypes == null ? 0 : this.argumentTypes.size();
    }

    @Override
    public Type getArgumentType(int i) {
        return (Type)this.argumentTypes.get(i);
    }

    public void addArgumentType(Type t) {
        if (this.argumentTypes == null) {
            this.argumentTypes = new ArrayList();
        }
        this.argumentTypes.add(t);
    }

    @Override
    Type resolveTypes(BasicCDebugInfoDataBase db, ResolveListener listener) {
        super.resolveTypes(db, listener);
        this.returnType = db.resolveType(this, this.returnType, listener, "resolving function return type");
        if (this.argumentTypes != null) {
            ListIterator<Type> iter = this.argumentTypes.listIterator();
            while (iter.hasNext()) {
                iter.set(db.resolveType(this, (Type)iter.next(), listener, "resolving function argument types"));
            }
        }
        return this;
    }

    @Override
    public void iterateObject(Address a, ObjectVisitor v, FieldIdentifier f) {
    }

    @Override
    protected Type createCVVariant(int cvAttributes) {
        BasicFunctionType t = new BasicFunctionType(this.getName(), this.getSize(), this.getReturnType(), cvAttributes);
        t.argumentTypes = this.argumentTypes;
        return t;
    }

    @Override
    public void visit(TypeVisitor v) {
        v.doFunctionType(this);
    }
}

