# Release Notes - v2.8.31

**Date**: 2026-01-27

## 📝 Executive Summary

```text
2.8.31 2026-01-27

- chore: uncomment examples directory in .gitignore.
- chore: bump version to 2.8.31.
- feat: add `--schemadir <path>` option to generate per-schema markdown documentation.
- feat: support independent schema documentation generation without requiring `--dumpdir`.
- feat: restructure specifications into `documentation/specifications/` (/hey-agent).
- feat: add specification for Performance Schema Error Log analysis.
- feat: add unused and redundant index checks via Performance Schema (sys schema) with recommendations and modeling findings.
- feat: modernize CVE retrieval script `build/updateCVElist.pl` with NVD API 2.0 (JSON-based) (Fix #867).
- feat: implement SQL modeling best practice checks (Primary Keys, Foreign Keys, Naming Conventions, Data Types).
- feat: add MySQL 8.0+ specific modeling checks (JSON indexing, Invisible Indexes).
- fix: resolve CLI option ambiguity and duplicate specification errors via unified Getopt::Long binding.
- fix: resolve tab delimiter mismatch in `tests/sql_modeling.t` mock data.
- fix: noisy system command failures when absolute paths are used for whitelisted commands (issue #874).
- fix: resolve syntax error and Perl compilation warnings in `mysqltuner.pl`.
- fix: ensure shell commands (pipes, redirections) work correctly in containers using `sh -c`.
- test: add unit test `tests/schemadir.t` to verify schema documentation logic.
- test: add unit test [tests/index_pfs_checks.t](file:///home/jmren/GIT_REPOS/MySQLTuner-perl/tests/index_pfs_checks.t) for Performance Schema index verification.
- test: add unit test [tests/sql_modeling.t](file:///home/jmren/GIT_REPOS/MySQLTuner-perl/tests/sql_modeling.t) for comprehensive schema analysis verification.
- ci: update `build/test_envs.sh` with `Schemadir` test scenario and fix logic ordering.
- ci: establish formal "Advanced Test Log Auditing" protocol and anomaly tracking.
- ci: enhance lab reports with integrated `execution.log` and collapsible panels for better readability.
- ci: harden testing suite with rigorous return code checking across all test modes (lab, container, remote).
- ci: improve laboratory error reporting to generate diagnostic reports even on startup failures.
- ci: verify MySQL 8.0 integration post-CLI refactoring.
- ci: reintroduce CVE analysis in Dockerfile with `--cvefile` support.
- ci: cleanup all `examples/` and execute full LTS test suite (MySQL, MariaDB, Percona).
- ci: update package.json test script and create remember workflow.
- ci: consolidate testing laboratory scripts into unified [build/test_envs.sh](file:///home/jmren/GIT_REPOS/MySQLTuner-perl/build/test_envs.sh) and update Makefile.
- docs: formalize tracking of Makefile and build script changes
- docs: formalize test and ci requirements in Changelog and rules
- docs: update Changelog and relax rules for docs-only updates
```

## 📈 Diagnostic Growth Indicators

| Metric | Current | Progress | Status |
| :--- | :--- | :--- | :--- |
| Total Indicators | 9 | +9 | 🚀 |
| Efficiency Checks | 0 | 0 | 🛡️ |
| Risk Detections | 1 | +1 | 🚀 |
| Information Points | 8 | +8 | 🚀 |

## 🧪 New Diagnostic Capabilities

### 🛑 New Risk Detections
- Table $dbname.$tbname has no index defined
- innodb_snapshot_isolation is OFF with REPEATABLE-READ (Stricter snapshot isolation is disabled)

### ℹ️ New Information Points
- Auto-generating raw output file: $raw_output_file
- Dumpdir: $opt{dumpdir}
- Dumping information schema
- Dumping performance schema
- Dumping sys schema
- General MyIsam metrics:
- InnoDB Snapshot Isolation: 
- SKIPPING $sys_view
- Transaction Isolation Level: $isolation
- table_definition_cache (

## 🛠️ Internal Commit History

Initial release or no previous tag found.

## ⚙️ Technical Evolutions

## ✅ Laboratory Verification Results

- [x] Automated TDD suite passed.
- [x] Multi-DB version laboratory execution validated.
- [x] Performance indicator delta analysis completed.
