/*  job_catfiles.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_CATFILES_H_
#define JOB_CATFILES_H_

#include "job.h"

namespace Reduze {

/// Job to merge files
class CatFiles: public Reduze::Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("cat_files");
		s.set_short_description("Concatenates files.");
		s.set_long_description("Job to concatenate files.");
		s.add_option("input_files", true, "sequence of strings",
				"Input file names.");
		s.add_option("output_file", true, "string", "Output file name.");
		s.add_option("delete_input_files", false, "boolean",
				"Whether to delete input files after merging.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}
	CatFiles() :
		delete_input_files_(false) {
		add_auto_options();
	}
	CatFiles(const std::list<std::string>& infiles, const std::string& ofile,
			bool delete_input_files = false) :
		input_files_(infiles), output_file_(ofile), delete_input_files_(
				delete_input_files) {
		add_auto_options();
		init();
	}
	virtual ~CatFiles() {
	}
	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;
protected:
	virtual void add_auto_options() {
		add_auto_io("input_files", input_files_);
		add_auto_io("output_file", output_file_);
		add_auto_io("delete_input_files", delete_input_files_);
	}
	virtual void init();
private:
	std::list<std::string> input_files_; // input
	std::string output_file_; // ouput
	bool delete_input_files_;
};

}

#endif /* JOB_CATFILES_H_ */
