/*  job_collectintegrals.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_COLLECTINTEGRALS_H_
#define JOB_COLLECTINTEGRALS_H_

#include "job.h"
#include "rspoint.h"

namespace Reduze {

/// Job to extract integrals from a file
class CollectIntegrals: public Reduze::Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("collect_integrals");
		s.set_short_description(
				"Collects integrals appearing in the input file.");
		s.set_long_description("" //
						"Job to collect integrals appearing in the input file"
						" The input file can contain linear combinations,"
						" equations or a list of integrals.");
		s.add_option("input_file", true, "string", "Input file name.");
		s.add_option("output_file", true, "string", "Output file name.");
		s.add_option("filter", false, "rs_generic_selection", "" //
						"Select only integrals which are in the given range."
						" Default is a full range.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}
	CollectIntegrals() {
		add_auto_options();
	}
	virtual ~CollectIntegrals() {
	}
	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;

protected:
	virtual void add_auto_options() {
		add_auto_io("input_file", input_filename_);
		add_auto_io("output_file", output_filename_);
		add_auto_io("filter", filter_);
	}
	virtual void init();

private:
	std::string input_filename_; // input
	std::string output_filename_; // ouput
	RSGenericSelection filter_;
};

}

#endif /* JOB_COLLECTINTEGRALS_H_ */
