/*  job_verifypermutationsymmetries.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_VERIFY_PERMUTATION_SYMMETRIES_H_
#define JOB_VERIFY_PERMUTATION_SYMMETRIES_H_

#include "job.h"

namespace Reduze {

/// Job to verify the global permutation symmetries of the integral families
class VerifyPermutationSymmetries: public Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("verify_permutation_symmetries");
		s.set_short_description("" //
						"Verifies the global permutation symmetries of an"
						" integral family.");
		s.set_long_description(s.short_description());
		s.add_option("integralfamily", true, "string", "" //
						"Name of the integral family");
		s.add_option("abort_on_first_error", false, "boolean", "" //
						"Whether to abort immediately after the first invalid"
						" permutation symmetry has been found. Otherwise"
						" all symmetries are checked first.");
		s.add_option("dummy_output_file", true, "string", "" //
						"An optional dummy output file to prevent this job"
						" from being performed a second time in case the option"
						" \"conditional\" is set to true");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}
	VerifyPermutationSymmetries() :
			abort_on_first_error_(true) {
		add_auto_options();
	}
	virtual ~VerifyPermutationSymmetries() {
	}
	void set_family(const std::string& family) {
		integralfamily_ = family;
	}
	void set_dummy_output_file(const std::string& dummy) {
		dummy_output_file_ = dummy;
	}

	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&, //
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;

	std::string integralfamily() const {
		return integralfamily_;
	}
	std::string dummy_output_file() const {
		return dummy_output_file_;
	}

protected:
	virtual void add_auto_options() {
		add_auto_io("integralfamily", integralfamily_);
		add_auto_io("abort_on_first_error", abort_on_first_error_);
		add_auto_io("dummy_output_file", dummy_output_file_);
	}

private:
	std::string integralfamily_;
	bool abort_on_first_error_;
	std::string dummy_output_file_;
};

}

#endif /* JOB_VERIFY_PERMUTATION_SYMMETRIES_H_ */
