/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.dangle;

import chiropraxis.dangle.GeomKinSmith;
import chiropraxis.dangle.Measurement;
import chiropraxis.dangle.Parser;
import driftwood.moldb2.CifReader;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.parser.CharWindow;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;

public class Dangle {
    boolean forcePDB = false;
    boolean forceCIF = false;
    boolean doWrap = false;
    boolean showDeviation = false;
    boolean outliersOnly = false;
    boolean doGeomKin;
    boolean doDistDevsKin = false;
    boolean doAngleDevsKin = false;
    boolean doKinHeadings = false;
    boolean ignoreDNA = false;
    boolean subgroupNotGroup = false;
    double sigmaCutoff = 4.0;
    Collection files = new ArrayList();
    Collection measurements = new ArrayList();
    boolean doHets = false;

    void fullOutput(String string, CoordinateFile coordinateFile) {
        int n;
        PrintStream printStream = System.out;
        DecimalFormat decimalFormat = new DecimalFormat("0.###");
        Measurement[] measurementArray = this.measurements.toArray(new Measurement[this.measurements.size()]);
        printStream.print("# label:model:chain:number:ins:type");
        int n2 = 999;
        for (n = 0; n < measurementArray.length; ++n) {
            if (this.ignoreDNA && measurementArray[n].getLabel().equals("c2o2") && n2 == 999) {
                n2 = n;
                continue;
            }
            printStream.print(":" + measurementArray[n].getLabel());
            if (!this.showDeviation) continue;
            printStream.print(":sigma " + measurementArray[n].getLabel());
        }
        printStream.println();
        for (n = 0; n < measurementArray.length; ++n) {
            if (this.ignoreDNA && n == n2) continue;
            printStream.println("# " + measurementArray[n]);
        }
        double[] dArray = new double[measurementArray.length];
        double[] dArray2 = new double[measurementArray.length];
        if (this.ignoreDNA && n2 != 999) {
            dArray = new double[measurementArray.length - 1];
            dArray2 = new double[measurementArray.length - 1];
        }
        for (Model model : coordinateFile.getModels()) {
            ModelState modelState = model.getState();
            String string2 = string + ":" + model.getName() + ":";
            for (Residue residue : model.getResidues()) {
                int n3;
                boolean bl = false;
                for (n3 = 0; n3 < measurementArray.length; ++n3) {
                    if (this.ignoreDNA && n3 == n2) continue;
                    dArray[n3] = measurementArray[n3].measure(model, modelState, residue, this.doHets);
                    dArray2[n3] = measurementArray[n3].getDeviation();
                    if (Double.isNaN(dArray[n3])) continue;
                    bl = true;
                    if (measurementArray[n3].getType() != Measurement.TYPE_DIHEDRAL) continue;
                    dArray[n3] = this.wrap360(dArray[n3]);
                }
                if (this.ignoreDNA && n2 != 999 && Double.isNaN(measurementArray[n2].measure(model, modelState, residue, this.doHets))) {
                    bl = false;
                }
                if (!bl) continue;
                printStream.print(string2);
                printStream.print(residue.getChain() + ":" + residue.getSequenceNumber() + ":" + residue.getInsertionCode() + ":" + residue.getName());
                for (n3 = 0; n3 < dArray.length; ++n3) {
                    printStream.print(":");
                    if (!Double.isNaN(dArray[n3])) {
                        printStream.print(decimalFormat.format(dArray[n3]));
                    } else {
                        printStream.print("__?__");
                    }
                    if (!this.showDeviation) continue;
                    printStream.print(":");
                    if (!Double.isNaN(dArray2[n3])) {
                        printStream.print(decimalFormat.format(dArray2[n3]));
                        continue;
                    }
                    printStream.print("__?__");
                }
                printStream.println();
            }
        }
    }

    void outliersOutput(String string, CoordinateFile coordinateFile) {
        PrintStream printStream = System.out;
        DecimalFormat decimalFormat = new DecimalFormat("0.###");
        Measurement[] measurementArray = this.measurements.toArray(new Measurement[this.measurements.size()]);
        printStream.println("# label:model:chain:number:ins:type:measure:value:sigmas");
        int n = 999;
        for (int i = 0; i < measurementArray.length; ++i) {
            if (!this.ignoreDNA || !measurementArray[i].getLabel().equals("c2o2") || n != 999) continue;
            n = i;
        }
        double[] dArray = new double[measurementArray.length];
        double[] dArray2 = new double[measurementArray.length];
        if (this.ignoreDNA && n != 999) {
            dArray = new double[measurementArray.length - 1];
            dArray2 = new double[measurementArray.length - 1];
        }
        for (Model model : coordinateFile.getModels()) {
            ModelState modelState = model.getState();
            String string2 = string + ":" + model.getName() + ":";
            for (Residue residue : model.getResidues()) {
                int n2;
                boolean bl = false;
                for (n2 = 0; n2 < measurementArray.length; ++n2) {
                    if (this.ignoreDNA && n2 == n) continue;
                    dArray[n2] = measurementArray[n2].measure(model, modelState, residue, this.doHets);
                    dArray2[n2] = measurementArray[n2].getDeviation();
                    if (Double.isNaN(dArray[n2])) continue;
                    bl = true;
                    if (measurementArray[n2].getType() != Measurement.TYPE_DIHEDRAL) continue;
                    dArray[n2] = this.wrap360(dArray[n2]);
                }
                if (this.ignoreDNA && n != 999 && Double.isNaN(measurementArray[n].measure(model, modelState, residue, this.doHets))) {
                    bl = false;
                }
                if (!bl) continue;
                for (n2 = 0; n2 < dArray.length; ++n2) {
                    if (Double.isNaN(dArray2[n2]) || !(Math.abs(dArray2[n2]) >= this.sigmaCutoff)) continue;
                    printStream.print(string2);
                    printStream.print(residue.getChain() + ":" + residue.getSequenceNumber() + ":" + residue.getInsertionCode() + ":" + residue.getName());
                    printStream.print(":" + measurementArray[n2].getLabel() + ":" + decimalFormat.format(dArray[n2]) + ":" + decimalFormat.format(dArray2[n2]));
                    printStream.println();
                }
            }
        }
    }

    void loadMeasures(String string) throws IOException, ParseException {
        this.measurements.addAll(new Parser().parse(new CharWindow(this.getClass().getResource(string))));
    }

    private double wrap360(double d) {
        if (this.doWrap) {
            if ((d %= 360.0) < 0.0) {
                return d + 360.0;
            }
            return d;
        }
        return d;
    }

    public void Main() throws IOException, ParseException {
        Object object;
        PdbReader pdbReader = new PdbReader();
        CifReader cifReader = new CifReader();
        if (this.measurements.isEmpty()) {
            if (this.showDeviation) {
                throw new IllegalArgumentException("Must specify measures to validate (try -protein, -rna, -dna)");
            }
            Parser parser = new Parser();
            object = parser.BUILTIN.pattern().pattern().replace('|', ' ');
            this.measurements.addAll(parser.parse(new CharWindow((String)object)));
        }
        if (this.files.isEmpty()) {
            if (this.forceCIF) {
                this.fullOutput("", cifReader.read(System.in));
            } else {
                this.fullOutput("", pdbReader.read(System.in));
            }
        } else {
            if (this.ignoreDNA) {
                this.measurements.add(Measurement.newBuiltin("c2o2"));
            }
            for (File file : this.files) {
                object = this.forceCIF ? cifReader.read(file) : (this.forcePDB ? pdbReader.read(file) : (file.getName().toLowerCase().endsWith(".cif") ? cifReader.read(file) : pdbReader.read(file)));
                if (this.doGeomKin) {
                    GeomKinSmith geomKinSmith = new GeomKinSmith((ArrayList)this.measurements, file.getName(), (CoordinateFile)object, this.doDistDevsKin, this.doAngleDevsKin, this.doKinHeadings, this.sigmaCutoff, this.ignoreDNA, this.subgroupNotGroup, this.doHets);
                    geomKinSmith.makeKin();
                    continue;
                }
                if (this.outliersOnly) {
                    this.outliersOutput(file.getName(), (CoordinateFile)object);
                    continue;
                }
                this.fullOutput(file.getName(), (CoordinateFile)object);
            }
        }
    }

    public static void main(String[] stringArray) {
        Dangle dangle = new Dangle();
        try {
            dangle.parseArguments(stringArray);
            dangle.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            dangle.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
    }

    void parseArguments(String[] stringArray) {
        for (String string : stringArray) {
            if (!string.equals("rnabb") && !string.equals("-rna") || this.ignoreDNA) continue;
            this.ignoreDNA = true;
        }
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + (String)string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("Dangle.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'Dangle.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.dangle.Dangle");
        System.err.println("Copyright (C) 2007 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        File file = new File(string);
        if (file.exists()) {
            this.files.add(file);
        } else {
            try {
                this.measurements.addAll(new Parser().parse(new CharWindow(string)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-cif")) {
            if (this.forcePDB) {
                throw new IllegalArgumentException("Can't specify both -cif and -pdb");
            }
            this.forceCIF = true;
        } else if (string.equals("-pdb")) {
            if (this.forceCIF) {
                throw new IllegalArgumentException("Can't specify both -cif and -pdb");
            }
            this.forcePDB = true;
        } else if (string.equals("-360")) {
            this.doWrap = true;
        } else if (string.equals("-validate")) {
            this.showDeviation = true;
        } else if (string.equals("-sigma")) {
            try {
                this.sigmaCutoff = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Expected -sigma=#.#");
            }
        } else if (string.equals("-prot") || string.equals("-protein") || string.equals("-proteins")) {
            try {
                this.loadMeasures("EnghHuber_IntlTblsF_1999.txt");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (string.equalsIgnoreCase("-rna")) {
            try {
                this.loadMeasures("ParkinsonBerman_ActaCrystD_1996_RNA.txt");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            if (string.equalsIgnoreCase("-dna")) {
                throw new IllegalArgumentException("No DNA parameters defined yet!");
            }
            if (string.equals("-outliers")) {
                this.showDeviation = true;
                this.outliersOnly = true;
            } else if (string.equals("-geometrykin") || string.equals("-geomkin") || string.equals("-kin")) {
                this.doGeomKin = true;
                this.doDistDevsKin = true;
                this.doAngleDevsKin = true;
            } else if (string.equals("-distancedevskin") || string.equals("-distdevskin")) {
                this.doGeomKin = true;
                this.doDistDevsKin = true;
            } else if (string.equals("-angledevskin") || string.equals("-angdevskin")) {
                this.doGeomKin = true;
                this.doAngleDevsKin = true;
            } else if (string.equals("-kinheading")) {
                this.doKinHeadings = true;
            } else if (string.equals("-sub") || string.equals("-subgroup")) {
                this.subgroupNotGroup = true;
            } else if (string.equals("-dohets") || string.equals("-hets")) {
                this.doHets = true;
            } else if (!string.equals("-dummy_option")) {
                throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
            }
        }
    }
}

