/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.kingtools.HingeTool;
import chiropraxis.mc.CaRotation;
import driftwood.gui.AngleDial;
import driftwood.gui.TablePane;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;

public class PeptideTwister2
extends JPanel
implements ActionListener {
    HingeTool parent;
    TablePane mainPanel;
    JCheckBox enableDials;
    Residue[] residues;
    AngleDial[] resDials;
    JLabel[][] resLabels;

    public PeptideTwister2(HingeTool hingeTool, Collection collection) {
        super(new BorderLayout());
        this.parent = hingeTool;
        this.residues = collection.toArray(new Residue[collection.size()]);
        this.buildGUI();
    }

    private void buildGUI() {
        int n;
        this.resDials = new AngleDial[this.residues.length - 1];
        this.resLabels = new JLabel[this.residues.length][5];
        this.mainPanel = new TablePane();
        this.mainPanel.weights(0.0, 0.0).add(this.makeHeaderLabels());
        this.mainPanel.weights(1.0, 1.0).hfill(true).vfill(true).startSubtable().center();
        for (n = 0; n < this.resLabels.length; ++n) {
            Box box = Box.createVerticalBox();
            for (int i = 0; i < this.resLabels[n].length; ++i) {
                this.resLabels[n][i] = new JLabel("?");
                this.resLabels[n][i].setAlignmentX(0.5f);
                box.add(this.resLabels[n][i]);
            }
            this.mainPanel.add(box);
        }
        this.mainPanel.endSubtable();
        this.mainPanel.newRow().skip();
        this.mainPanel.startSubtable().center();
        this.mainPanel.add(TablePane.strut(46, 92));
        for (n = 0; n < this.resDials.length; ++n) {
            this.resDials[n] = new AngleDial();
            this.resDials[n].setAlignmentX(0.0f);
            this.resDials[n].addChangeListener(this.parent);
            this.mainPanel.add(this.resDials[n]);
        }
        this.mainPanel.add(TablePane.strut(46, 92));
        this.mainPanel.endSubtable();
        this.enableDials = new JCheckBox("Enable peptide rotation and sidechain idealization", false);
        this.enableDials.addActionListener(this);
        this.add((Component)this.mainPanel, "Center");
        this.add((Component)this.enableDials, "North");
        this.updateLabels();
        this.updateEnabledState();
    }

    private Component makeHeaderLabels() {
        JLabel[] jLabelArray = new JLabel[]{new JLabel("Residue"), new JLabel("Tau dev"), new JLabel("Karplus"), new JLabel("Ramachdrn"), new JLabel("phi,psi")};
        Box box = Box.createVerticalBox();
        for (int i = 0; i < jLabelArray.length; ++i) {
            jLabelArray[i].setAlignmentX(0.0f);
            box.add(jLabelArray[i]);
        }
        return box;
    }

    void updateLabels() {
        for (int i = 0; i < this.residues.length; ++i) {
            this.parent.updateLabels(this.residues[i], this.resLabels[i]);
        }
    }

    ModelState updateConformation(ModelState modelState) {
        if (this.enableDials.isSelected()) {
            double[] dArray = new double[this.resDials.length];
            for (int i = 0; i < this.resDials.length; ++i) {
                dArray[i] = this.resDials[i].getDegrees();
            }
            boolean[] blArray = new boolean[this.residues.length];
            Arrays.fill(blArray, true);
            if (!this.parent.cbIdealizeSC.isSelected()) {
                blArray[blArray.length - 1] = false;
                blArray[0] = false;
            }
            try {
                return CaRotation.twistPeptides(this.residues, modelState, dArray, blArray);
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
                return modelState;
            }
        }
        return modelState;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.updateEnabledState();
        this.parent.stateChanged(new ChangeEvent(this));
    }

    void updateEnabledState() {
        int n;
        boolean bl = this.enableDials.isSelected();
        for (n = 0; n < this.resLabels.length; ++n) {
            for (int i = 0; i < this.resLabels[n].length; ++i) {
                this.resLabels[n][i].setEnabled(bl);
            }
        }
        for (n = 0; n < this.resDials.length; ++n) {
            this.resDials[n].setEnabled(bl);
        }
    }
}

