/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;

public class PeptideFlipFinder {
    ArrayList inputList = new ArrayList();

    public Collection findPeptideFlips(Model model, ModelState[] modelStateArray) {
        ArrayList<Residue> arrayList = new ArrayList<Residue>();
        block2: for (Residue residue : model.getResidues()) {
            int n;
            Atom atom = residue.getAtom(" C  ");
            Atom atom2 = residue.getAtom(" O  ");
            if (atom == null || atom2 == null) continue;
            ArrayList<Triple> arrayList2 = new ArrayList<Triple>();
            for (n = 0; n < modelStateArray.length; ++n) {
                try {
                    arrayList2.add(new Triple().like(modelStateArray[n].get(atom2)).sub(modelStateArray[n].get(atom)));
                    continue;
                }
                catch (AtomException atomException) {
                    // empty catch block
                }
            }
            for (n = 0; n < arrayList2.size(); ++n) {
                for (int i = n + 1; i < arrayList2.size(); ++i) {
                    if (!(((Triple)arrayList2.get(n)).angle((Triple)arrayList2.get(i)) >= 90.0)) continue;
                    arrayList.add(residue);
                    continue block2;
                }
            }
        }
        return arrayList;
    }

    public Collection findPeptideFlips2(Model model, ModelState[] modelStateArray) {
        ArrayList<Residue> arrayList = new ArrayList<Residue>();
        block6: for (Residue residue : model.getResidues()) {
            int n;
            Residue residue2 = residue.getNext(model);
            if (residue2 == null) continue;
            Triple triple = new Triple();
            int n2 = 0;
            for (int i = 0; i < modelStateArray.length; ++i) {
                try {
                    triple.add(modelStateArray[i].get(residue.getAtom(" CA ")));
                    ++n2;
                    continue;
                }
                catch (AtomException atomException) {
                    // empty catch block
                }
            }
            if (n2 == 0) continue;
            triple.div(n2);
            Triple triple2 = new Triple();
            n2 = 0;
            for (int i = 0; i < modelStateArray.length; ++i) {
                try {
                    triple2.add(modelStateArray[i].get(residue2.getAtom(" CA ")));
                    ++n2;
                    continue;
                }
                catch (AtomException atomException) {
                    // empty catch block
                }
            }
            if (n2 == 0) continue;
            triple2.div(n2);
            ArrayList<AtomState> arrayList2 = new ArrayList<AtomState>();
            for (n = 0; n < modelStateArray.length; ++n) {
                try {
                    arrayList2.add(modelStateArray[n].get(residue.getAtom(" O  ")));
                    continue;
                }
                catch (AtomException atomException) {
                    // empty catch block
                }
            }
            for (n = 0; n < arrayList2.size(); ++n) {
                for (int i = n + 1; i < arrayList2.size(); ++i) {
                    Tuple3 tuple3;
                    Tuple3 tuple32 = (Tuple3)arrayList2.get(n);
                    if (!(Math.abs(Triple.dihedral(tuple32, triple, triple2, tuple3 = (Tuple3)arrayList2.get(i))) >= 90.0)) continue;
                    arrayList.add(residue);
                    continue block6;
                }
            }
        }
        return arrayList;
    }

    public void Main() {
        PdbReader pdbReader = new PdbReader();
        for (String string : this.inputList) {
            try {
                CoordinateFile coordinateFile = pdbReader.read(new File(string));
                Model model = coordinateFile.getFirstModel();
                Collection collection = model.getStates().values();
                ModelState[] modelStateArray = collection.toArray(new ModelState[collection.size()]);
                Collection collection2 = this.findPeptideFlips(model, modelStateArray);
                for (Residue residue : collection2) {
                    System.out.println(string + " : " + residue);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.err.println("Error reading " + string);
            }
        }
    }

    public static void main(String[] stringArray) {
        PeptideFlipFinder peptideFlipFinder = new PeptideFlipFinder();
        try {
            peptideFlipFinder.parseArguments(stringArray);
            peptideFlipFinder.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            peptideFlipFinder.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("PeptideFlipFinder.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'PeptideFlipFinder.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.PeptideFlipFinder");
        System.err.println("Copyright (C) 2005 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        this.inputList.add(string);
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

