/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.sc;

import chiropraxis.sc.RotamerDef;
import driftwood.data.UberMap;
import driftwood.data.UberSet;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.util.Props;
import driftwood.util.SoftLog;
import driftwood.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class SidechainAngles2 {
    public static final String REMOTENESS = "HZEDGBA ";
    Set knownAA;
    Map chisPerAA;
    Map anglesForAA;
    Map atomsForAngle;
    Map rotamersForAA;
    Transform rot = new Transform();

    public SidechainAngles2() throws IOException {
        this.loadData();
    }

    private void loadData() throws IOException {
        Props props = new Props();
        InputStream inputStream = this.getClass().getResourceAsStream("angles.props");
        if (inputStream == null) {
            throw new IllegalArgumentException("Couldn't find resource in JAR file");
        }
        props.load(inputStream);
        inputStream.close();
        this.chisPerAA = new UberMap();
        this.anglesForAA = new UberMap();
        this.atomsForAngle = new UberMap();
        this.rotamersForAA = new UberMap();
        String[] stringArray = Strings.explode(props.getString("aminoacids"), ',');
        this.knownAA = new UberSet(Arrays.asList(stringArray));
        for (String string : this.knownAA) {
            this.loadAminoAcid(props, string);
        }
    }

    private void loadAminoAcid(Props props, String string) {
        String[] stringArray;
        String[] stringArray2;
        Integer n = new Integer(props.getInt(string + ".chis"));
        this.chisPerAA.put(string, n);
        String[] stringArray3 = Strings.explode(props.getString(string + ".angles"), ',', false, true);
        this.anglesForAA.put(string, stringArray3);
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray2 = string + "." + stringArray3[i];
            stringArray = Strings.explode(props.getString((String)stringArray2), ',');
            this.atomsForAngle.put(stringArray2, stringArray);
        }
        ArrayList<RotamerDef> arrayList = new ArrayList<RotamerDef>();
        stringArray2 = Strings.explode(props.getString(string + ".rotamers"), ',', false, true);
        stringArray = Strings.explode(props.getString(string + ".frequencies", ""), ',', false, true);
        for (int i = 0; i < stringArray2.length; ++i) {
            try {
                double[] dArray = this.explodeDoubles(props.getString(string + "." + stringArray2[i]));
                RotamerDef rotamerDef = new RotamerDef();
                rotamerDef.rotamerName = stringArray2[i];
                rotamerDef.frequency = stringArray.length > i ? stringArray[i] : "?";
                rotamerDef.chiAngles = dArray;
                arrayList.add(rotamerDef);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace(SoftLog.err);
            }
        }
        this.rotamersForAA.put(string, arrayList);
    }

    double[] explodeDoubles(String string) throws NumberFormatException {
        String[] stringArray = Strings.explode(string, ' ');
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dArray[i] = Double.parseDouble(stringArray[i]);
        }
        return dArray;
    }

    public int countChiAngles(Residue residue) {
        String string = residue.getName().toLowerCase();
        Integer n = (Integer)this.chisPerAA.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public int countAllAngles(Residue residue) {
        String string = residue.getName().toLowerCase();
        String[] stringArray = (String[])this.anglesForAA.get(string);
        if (stringArray == null) {
            return -1;
        }
        return stringArray.length;
    }

    public String[] nameAllAngles(Residue residue) {
        String string = residue.getName().toLowerCase();
        String[] stringArray = (String[])this.anglesForAA.get(string);
        if (stringArray == null) {
            return null;
        }
        return (String[])stringArray.clone();
    }

    public double measureAngle(String string, Residue residue, ModelState modelState) throws AtomException {
        AtomState[] atomStateArray = this.getAngleAtomStates(string, residue, modelState);
        return Triple.dihedral(atomStateArray[0], atomStateArray[1], atomStateArray[2], atomStateArray[3]);
    }

    public AtomState[] getAngleAtomStates(String string, Residue residue, ModelState modelState) throws AtomException {
        String string2 = (residue.getName() + "." + string).toLowerCase();
        String[] stringArray = (String[])this.atomsForAngle.get(string2);
        if (stringArray == null || stringArray.length < 4) {
            throw new IllegalArgumentException("Angle definition bad or not found for '" + string2 + "'");
        }
        AtomState[] atomStateArray = new AtomState[4];
        for (int i = 0; i < atomStateArray.length; ++i) {
            String[] stringArray2 = Strings.explode(stringArray[i], ';');
            Atom atom = null;
            for (int j = 0; atom == null && j < stringArray2.length; ++j) {
                atom = residue.getAtom(stringArray2[j]);
            }
            atomStateArray[i] = modelState.get(atom);
        }
        return atomStateArray;
    }

    protected boolean areParentAndChild(Atom atom, Atom atom2) {
        String string = atom.getName();
        String string2 = atom2.getName();
        if (string == null || string2 == null || string.length() != 4 || string2.length() != 4) {
            throw new IllegalArgumentException("Bad atom name(s)");
        }
        if (string.charAt(0) == 'H') {
            string = string.substring(3) + string.substring(0, 3);
        }
        if (string2.charAt(0) == 'H') {
            string2 = string2.substring(3) + string2.substring(0, 3);
        }
        int n = REMOTENESS.indexOf(string.charAt(2));
        if (atom.getResidue().getName().equals("MSE") && string.equals("SE  ")) {
            n = REMOTENESS.indexOf(68);
        }
        int n2 = REMOTENESS.indexOf(string2.charAt(2));
        if (atom2.getResidue().getName().equals("MSE") && string2.equals("SE  ")) {
            n2 = REMOTENESS.indexOf(68);
        }
        return n > n2 && (string.charAt(3) == ' ' || string.charAt(3) == string2.charAt(3)) || n == n2 && (string.charAt(3) == ' ' || string.charAt(3) == string2.charAt(3)) && string.charAt(1) != 'H' && string2.charAt(1) == 'H';
    }

    public ModelState setAngle(String string, Residue residue, ModelState modelState, double d) throws AtomException {
        AtomState[] atomStateArray = this.getAngleAtomStates(string, residue, modelState);
        AtomState atomState = atomStateArray[0];
        AtomState atomState2 = atomStateArray[1];
        AtomState atomState3 = atomStateArray[2];
        AtomState atomState4 = atomStateArray[3];
        double d2 = Triple.dihedral(atomState, atomState2, atomState3, atomState4);
        double d3 = d - d2;
        this.rot.likeRotation(atomState2, atomState3, d3);
        ModelState modelState2 = new ModelState(modelState);
        for (Atom atom : residue.getAtoms()) {
            atomState = modelState.get(atom);
            atomState2 = (AtomState)atomState.clone();
            if (!this.areParentAndChild(atomState3.getAtom(), atom)) continue;
            this.rot.transform(atomState2);
            modelState2.add(atomState2);
        }
        return modelState2;
    }

    public double[] measureAllAngles(Residue residue, ModelState modelState) {
        String string = residue.getName().toLowerCase();
        String[] stringArray = this.nameAllAngles(residue);
        if (stringArray == null) {
            throw new IllegalArgumentException("Unknown residue type");
        }
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                dArray[i] = this.measureAngle(stringArray[i], residue, modelState);
                continue;
            }
            catch (AtomException atomException) {
                dArray[i] = Double.NaN;
            }
        }
        return dArray;
    }

    public ModelState setAllAngles(Residue residue, ModelState modelState, double[] dArray) {
        String string = residue.getName().toLowerCase();
        String[] stringArray = this.nameAllAngles(residue);
        if (stringArray == null) {
            throw new IllegalArgumentException("Unknown residue type");
        }
        if (dArray.length < stringArray.length) {
            throw new IllegalArgumentException("Not enough angles specified");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (Double.isNaN(dArray[i])) continue;
            try {
                modelState = this.setAngle(stringArray[i], residue, modelState, dArray[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace(SoftLog.err);
                continue;
            }
            catch (AtomException atomException) {
                atomException.printStackTrace(SoftLog.err);
            }
        }
        return modelState;
    }

    public double[] measureChiAngles(Residue residue, ModelState modelState) {
        String string = residue.getName().toLowerCase();
        int n = this.countChiAngles(residue);
        if (n < 0) {
            throw new IllegalArgumentException("Unknown residue type");
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            try {
                dArray[i] = this.measureAngle("chi" + (i + 1), residue, modelState);
                continue;
            }
            catch (AtomException atomException) {
                dArray[i] = Double.NaN;
            }
        }
        return dArray;
    }

    public ModelState setChiAngles(Residue residue, ModelState modelState, double[] dArray) {
        String string = residue.getName().toLowerCase();
        int n = this.countChiAngles(residue);
        if (n < 0) {
            throw new IllegalArgumentException("Unknown residue type");
        }
        if (dArray.length < n) {
            throw new IllegalArgumentException("Not enough angles specified");
        }
        for (int i = 0; i < n; ++i) {
            try {
                modelState = this.setAngle("chi" + (i + 1), residue, modelState, dArray[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace(SoftLog.err);
                continue;
            }
            catch (AtomException atomException) {
                atomException.printStackTrace(SoftLog.err);
            }
        }
        return modelState;
    }

    public RotamerDef[] getAllRotamers(Residue residue) {
        return this.getAllRotamers(residue.getName());
    }

    public RotamerDef[] getAllRotamers(String string) {
        Collection collection = (Collection)this.rotamersForAA.get(string = string.toLowerCase());
        if (collection == null) {
            return null;
        }
        return collection.toArray(new RotamerDef[collection.size()]);
    }
}

