/*
 * Decompiled with CFR 0.152.
 */
package molikin.gui;

import driftwood.gui.TablePane2;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import molikin.gui.DrawingPane;
import molikin.gui.SelectorPane;
import molikin.logic.RibbonLogic;

public class RibbonPane
extends TablePane2
implements DrawingPane {
    CoordinateFile coordFile;
    String title;
    SelectorPane selector;
    JCheckBox cbProtein;
    JCheckBox cbNucleic;
    JCheckBox cbUntwistRibbons;
    JCheckBox cbDnaStyle;
    JComboBox cmColorBy;

    public RibbonPane(CoordinateFile coordinateFile, String string) {
        this.coordFile = coordinateFile;
        this.title = string;
        this.buildGUI();
    }

    private void buildGUI() {
        this.selector = new SelectorPane(this.coordFile);
        this.cbProtein = new JCheckBox("protein", true);
        this.cbNucleic = new JCheckBox("nucleic acids", true);
        this.cbUntwistRibbons = new JCheckBox("untwist ribbons", true);
        this.cbDnaStyle = new JCheckBox("DNA-style, not RNA", false);
        this.cmColorBy = new JComboBox<Object>(new Object[]{RibbonLogic.COLOR_BY_SEC_STRUCT, RibbonLogic.COLOR_BY_RAINBOW});
        this.hfill(true).vfill(true).addCell(this.selector, 2, 1).newRow();
        this.weights(1.0, 0.0).memorize();
        this.addCell(RibbonPane.strut(0, 6)).newRow();
        this.startSubtable(2, 1);
        this.weights(0.0, 0.0).memorize();
        this.addCell(new JLabel("Color by")).addCell(this.cmColorBy);
        this.endSubtable();
        this.addCell(RibbonPane.strut(0, 6)).newRow();
        this.addCell(this.cbProtein).skip().newRow();
        this.addCell(this.cbNucleic).skip().newRow();
        this.addCell(RibbonPane.strut(0, 6)).newRow();
        this.addCell(this.cbDnaStyle).newRow();
        this.addCell(RibbonPane.strut(0, 6)).newRow();
        this.setBorder(BorderFactory.createTitledBorder(null, "Ribbons"));
    }

    public String toString() {
        return this.title;
    }

    public Collection getSelectedModels() {
        return this.selector.getSelectedModels();
    }

    public Collection getSelectedChains() {
        return this.selector.getSelectedChains();
    }

    public void printKinemage(PrintWriter printWriter, Model model, String string, String string2, String string3) {
        Collection collection = this.selector.getSelectedModels();
        if (!collection.contains(model)) {
            return;
        }
        Collection collection2 = this.selector.getSelectedChains();
        if (!collection2.contains(string)) {
            return;
        }
        Set set = model.getChain(string);
        if (set == null) {
            return;
        }
        Set set2 = this.selector.getSelectedResidues(set);
        if (set2.size() == 0) {
            return;
        }
        RibbonLogic ribbonLogic = new RibbonLogic();
        ribbonLogic.secondaryStructure = this.coordFile.getSecondaryStructure();
        ribbonLogic.doProtein = this.cbProtein.isSelected();
        ribbonLogic.doNucleic = this.cbNucleic.isSelected();
        ribbonLogic.doUntwistRibbons = this.cbUntwistRibbons.isSelected();
        ribbonLogic.doDnaStyle = this.cbDnaStyle.isSelected();
        ribbonLogic.colorBy = this.cmColorBy.getSelectedItem();
        ribbonLogic.printKinemage(printWriter, model, set2, string3);
    }
}

