//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitrackinglayoutguide?language=objc)
    #[unsafe(super(UILayoutGuide, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UILayoutGuide")]
    pub struct UITrackingLayoutGuide;
);

#[cfg(feature = "UILayoutGuide")]
extern_conformance!(
    unsafe impl NSCoding for UITrackingLayoutGuide {}
);

#[cfg(feature = "UILayoutGuide")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UITrackingLayoutGuide {}
);

#[cfg(feature = "UILayoutGuide")]
impl UITrackingLayoutGuide {
    extern_methods!(
        #[cfg(all(feature = "NSLayoutConstraint", feature = "UIGeometry"))]
        /// Parameter `trackingConstraints`: Constraints to activate when the guide is close to the specified edge, and deactivate when it moves away. Sending nil will deactivate any currently active constraints associated with this edge and remove them from tracking.
        ///
        /// Parameter `edge`: When the tracking layout guide is close to this edge, specified constraints will change
        #[unsafe(method(setConstraints:activeWhenNearEdge:))]
        #[unsafe(method_family = none)]
        pub fn setConstraints_activeWhenNearEdge(
            &self,
            tracking_constraints: &NSArray<NSLayoutConstraint>,
            edge: NSDirectionalRectEdge,
        );

        #[cfg(all(feature = "NSLayoutConstraint", feature = "UIGeometry"))]
        #[unsafe(method(constraintsActiveWhenNearEdge:))]
        #[unsafe(method_family = none)]
        pub fn constraintsActiveWhenNearEdge(
            &self,
            edge: NSDirectionalRectEdge,
        ) -> Retained<NSArray<NSLayoutConstraint>>;

        #[cfg(all(feature = "NSLayoutConstraint", feature = "UIGeometry"))]
        /// Parameter `trackingConstraints`: Constraints to deactivate when the guide is close to the specified edge, and activate when it moves away. Sending nil will remove the constraints associated with this edge from tracking.
        ///
        /// Parameter `edge`: When the tracking layout guide is close to this edge, specified constraints will change
        #[unsafe(method(setConstraints:activeWhenAwayFromEdge:))]
        #[unsafe(method_family = none)]
        pub fn setConstraints_activeWhenAwayFromEdge(
            &self,
            tracking_constraints: &NSArray<NSLayoutConstraint>,
            edge: NSDirectionalRectEdge,
        );

        #[cfg(all(feature = "NSLayoutConstraint", feature = "UIGeometry"))]
        #[unsafe(method(constraintsActiveWhenAwayFromEdge:))]
        #[unsafe(method_family = none)]
        pub fn constraintsActiveWhenAwayFromEdge(
            &self,
            edge: NSDirectionalRectEdge,
        ) -> Retained<NSArray<NSLayoutConstraint>>;

        /// Manually remove all constraints from this guide's tracking.
        #[unsafe(method(removeAllTrackedConstraints))]
        #[unsafe(method_family = none)]
        pub fn removeAllTrackedConstraints(&self);
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "UILayoutGuide")]
impl UITrackingLayoutGuide {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
