/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Dependencies for kernel's UMH
 *
 * Notes:
 *  - None
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 14.V.2020
 *
 * Author:
 *  - Mariusz Zaborski <http://oshogbo.vexillium.org/>
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_USERMODEHELPER_KERNEL_DEP_H
#define P_LKRG_EXPLOIT_DETECTION_USERMODEHELPER_KERNEL_DEP_H

#if LINUX_VERSION_CODE < KERNEL_VERSION(3,11,0)
 #ifdef ANDROID_BUILD
   #define UMH_UNIFIFW          "/system/bin/unififw",
 #else
   #define UMH_UNIFIFW          "/usr/sbin/unififw",
 #endif /* ANDROID_BUILD */
#elif LINUX_VERSION_CODE < KERNEL_VERSION(4,18,0)
   #define UMH_LNET_UPCALL      "/usr/lib/lustre/lnet_upcall",           \
                                "/usr/lib/lustre/lnet_debug_log_upcall",
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(4,12,0)
   #define UMH_OSD_LOGIN        "/sbin/osd_login",
#endif

#ifndef UMH_UNIFIFW
#define UMH_UNIFIFW
#endif

#ifndef UMH_LNET_UPCALL
#define UMH_LNET_UPCALL
#endif

#ifndef UMH_OSD_LOGIN
#define UMH_OSD_LOGIN
#endif

#endif
