// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewUpdateClusterParams creates a new UpdateClusterParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateClusterParams() *UpdateClusterParams {
	return &UpdateClusterParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateClusterParamsWithTimeout creates a new UpdateClusterParams object
// with the ability to set a timeout on a request.
func NewUpdateClusterParamsWithTimeout(timeout time.Duration) *UpdateClusterParams {
	return &UpdateClusterParams{
		timeout: timeout,
	}
}

// NewUpdateClusterParamsWithContext creates a new UpdateClusterParams object
// with the ability to set a context for a request.
func NewUpdateClusterParamsWithContext(ctx context.Context) *UpdateClusterParams {
	return &UpdateClusterParams{
		Context: ctx,
	}
}

// NewUpdateClusterParamsWithHTTPClient creates a new UpdateClusterParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateClusterParamsWithHTTPClient(client *http.Client) *UpdateClusterParams {
	return &UpdateClusterParams{
		HTTPClient: client,
	}
}

/*
UpdateClusterParams contains all the parameters to send to the API endpoint

	for the update cluster operation.

	Typically these are written to a http.Request.
*/
type UpdateClusterParams struct {

	// Body.
	Body UpdateClusterBody

	/* ID.

	   id is the user settable GNM cluster name of the cluster to update
	*/
	ID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update cluster params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateClusterParams) WithDefaults() *UpdateClusterParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update cluster params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateClusterParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update cluster params
func (o *UpdateClusterParams) WithTimeout(timeout time.Duration) *UpdateClusterParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update cluster params
func (o *UpdateClusterParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update cluster params
func (o *UpdateClusterParams) WithContext(ctx context.Context) *UpdateClusterParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update cluster params
func (o *UpdateClusterParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update cluster params
func (o *UpdateClusterParams) WithHTTPClient(client *http.Client) *UpdateClusterParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update cluster params
func (o *UpdateClusterParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update cluster params
func (o *UpdateClusterParams) WithBody(body UpdateClusterBody) *UpdateClusterParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update cluster params
func (o *UpdateClusterParams) SetBody(body UpdateClusterBody) {
	o.Body = body
}

// WithID adds the id to the update cluster params
func (o *UpdateClusterParams) WithID(id string) *UpdateClusterParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the update cluster params
func (o *UpdateClusterParams) SetID(id string) {
	o.ID = id
}

// WithLocationOrganizationID adds the locationOrganizationID to the update cluster params
func (o *UpdateClusterParams) WithLocationOrganizationID(locationOrganizationID string) *UpdateClusterParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the update cluster params
func (o *UpdateClusterParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the update cluster params
func (o *UpdateClusterParams) WithLocationProjectID(locationProjectID string) *UpdateClusterParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the update cluster params
func (o *UpdateClusterParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateClusterParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
