use core_foundation::mach_port::CFMachPortRef;
use libc::boolean_t;

use crate::{error::CGError, geometry::CGPoint};

pub type CGKeyCode = u16;

#[repr(C)]
pub struct KeyCode;
impl KeyCode {
    pub const A: CGKeyCode = 0x00;
    pub const S: CGKeyCode = 0x01;
    pub const D: CGKeyCode = 0x02;
    pub const F: CGKeyCode = 0x03;
    pub const H: CGKeyCode = 0x04;
    pub const G: CGKeyCode = 0x05;
    pub const Z: CGKeyCode = 0x06;
    pub const X: CGKeyCode = 0x07;
    pub const C: CGKeyCode = 0x08;
    pub const V: CGKeyCode = 0x09;
    pub const B: CGKeyCode = 0x0B;
    pub const Q: CGKeyCode = 0x0C;
    pub const W: CGKeyCode = 0x0D;
    pub const E: CGKeyCode = 0x0E;
    pub const R: CGKeyCode = 0x0F;
    pub const Y: CGKeyCode = 0x10;
    pub const T: CGKeyCode = 0x11;
    pub const One: CGKeyCode = 0x12;
    pub const Two: CGKeyCode = 0x13;
    pub const Three: CGKeyCode = 0x14;
    pub const Four: CGKeyCode = 0x15;
    pub const Six: CGKeyCode = 0x16;
    pub const Five: CGKeyCode = 0x17;
    pub const Equal: CGKeyCode = 0x18;
    pub const Nine: CGKeyCode = 0x19;
    pub const Seven: CGKeyCode = 0x1A;
    pub const Minus: CGKeyCode = 0x1B;
    pub const Eight: CGKeyCode = 0x1C;
    pub const Zero: CGKeyCode = 0x1D;
    pub const RightBracket: CGKeyCode = 0x1E;
    pub const O: CGKeyCode = 0x1F;
    pub const U: CGKeyCode = 0x20;
    pub const LeftBracket: CGKeyCode = 0x21;
    pub const I: CGKeyCode = 0x22;
    pub const P: CGKeyCode = 0x23;
    pub const Return: CGKeyCode = 0x24;
    pub const L: CGKeyCode = 0x25;
    pub const J: CGKeyCode = 0x26;
    pub const Quote: CGKeyCode = 0x27;
    pub const K: CGKeyCode = 0x28;
    pub const Semicolon: CGKeyCode = 0x29;
    pub const Backslash: CGKeyCode = 0x2A;
    pub const Comma: CGKeyCode = 0x2B;
    pub const Slash: CGKeyCode = 0x2C;
    pub const N: CGKeyCode = 0x2D;
    pub const M: CGKeyCode = 0x2E;
    pub const Period: CGKeyCode = 0x2F;
    pub const Tab: CGKeyCode = 0x30;
    pub const Space: CGKeyCode = 0x31;
    pub const Grave: CGKeyCode = 0x32;
    pub const Delete: CGKeyCode = 0x33;
    pub const Escape: CGKeyCode = 0x35;
    pub const RightCommand: CGKeyCode = 0x36;
    pub const Command: CGKeyCode = 0x37;
    pub const Shift: CGKeyCode = 0x38;
    pub const CapsLock: CGKeyCode = 0x39;
    pub const Option: CGKeyCode = 0x3A;
    pub const Control: CGKeyCode = 0x3B;
    pub const RightShift: CGKeyCode = 0x3C;
    pub const RightOption: CGKeyCode = 0x3D;
    pub const RightControl: CGKeyCode = 0x3E;
    pub const Function: CGKeyCode = 0x3F;
    pub const F17: CGKeyCode = 0x40;
    pub const KeypadDecimal: CGKeyCode = 0x41;
    pub const KeypadMultiply: CGKeyCode = 0x43;
    pub const KeypadPlus: CGKeyCode = 0x45;
    pub const KeypadClear: CGKeyCode = 0x47;
    pub const VolumeUp: CGKeyCode = 0x48;
    pub const VolumeDown: CGKeyCode = 0x49;
    pub const Mute: CGKeyCode = 0x4A;
    pub const KeypadDivide: CGKeyCode = 0x4B;
    pub const KeypadEnter: CGKeyCode = 0x4C;
    pub const KeypadMinus: CGKeyCode = 0x4E;
    pub const F18: CGKeyCode = 0x4F;
    pub const F19: CGKeyCode = 0x50;
    pub const KeypadEquals: CGKeyCode = 0x51;
    pub const Keypad0: CGKeyCode = 0x52;
    pub const Keypad1: CGKeyCode = 0x53;
    pub const Keypad2: CGKeyCode = 0x54;
    pub const Keypad3: CGKeyCode = 0x55;
    pub const Keypad4: CGKeyCode = 0x56;
    pub const Keypad5: CGKeyCode = 0x57;
    pub const Keypad6: CGKeyCode = 0x58;
    pub const Keypad7: CGKeyCode = 0x59;
    pub const F20: CGKeyCode = 0x5A;
    pub const Keypad8: CGKeyCode = 0x5B;
    pub const Keypad9: CGKeyCode = 0x5C;
    pub const F5: CGKeyCode = 0x60;
    pub const F6: CGKeyCode = 0x61;
    pub const F7: CGKeyCode = 0x62;
    pub const F3: CGKeyCode = 0x63;
    pub const F8: CGKeyCode = 0x64;
    pub const F9: CGKeyCode = 0x65;
    pub const F11: CGKeyCode = 0x67;
    pub const F13: CGKeyCode = 0x69;
    pub const F16: CGKeyCode = 0x6A;
    pub const F14: CGKeyCode = 0x6B;
    pub const F10: CGKeyCode = 0x6D;
    pub const F12: CGKeyCode = 0x6F;
    pub const F15: CGKeyCode = 0x71;
    pub const Help: CGKeyCode = 0x72;
    pub const Home: CGKeyCode = 0x73;
    pub const PageUp: CGKeyCode = 0x74;
    pub const ForwardDelete: CGKeyCode = 0x75;
    pub const F4: CGKeyCode = 0x76;
    pub const End: CGKeyCode = 0x77;
    pub const F2: CGKeyCode = 0x78;
    pub const PageDown: CGKeyCode = 0x79;
    pub const F1: CGKeyCode = 0x7A;
    pub const LeftArrow: CGKeyCode = 0x7B;
    pub const RightArrow: CGKeyCode = 0x7C;
    pub const DownArrow: CGKeyCode = 0x7D;
    pub const UpArrow: CGKeyCode = 0x7E;
}

extern "C" {
    pub fn CGWarpMouseCursorPosition(newCursorPosition: CGPoint) -> CGError;
    pub fn CGAssociateMouseAndMouseCursorPosition(connected: boolean_t) -> CGError;
    pub fn CGWindowServerCreateServerPort() -> CFMachPortRef;
}
