
;@ Dave's Cyclone 68000 Emulator v0.088 - Assembler Output

;@ (c) Copyright 2003 Dave, All rights reserved.
;@ some code (c) Copyright 2005-2007 notaz, All rights reserved.
;@ Cyclone 68000 is free for non-commercial use.

;@ For commercial use, separate licencing terms must be obtained.

  .text
  .align 4

  .global CycloneInit
  .global CycloneRun
  .global CycloneSetSr
  .global CycloneGetSr
  .global CycloneFlushIrq
  .global CyclonePack
  .global CycloneUnpack
  .global CycloneVer

CycloneVer: .long 0x0088

;@ --------------------------- Framework --------------------------
CycloneRun:
  stmdb sp!,{r4-r11,lr}
  mov r7,r0          ;@ r7 = Pointer to Cpu Context
                     ;@ r0-3 = Temporary registers
  ldrb r9,[r7,#0x46] ;@ r9 = Flags (NZCV)
  ldr r6,=CycloneJumpTab ;@ r6 = Opcode Jump table
  ldr r5,[r7,#0x5c]  ;@ r5 = Cycles
  ldr r4,[r7,#0x40]  ;@ r4 = Current PC + Memory Base
                     ;@ r8 = Current Opcode
  ldr r1,[r7,#0x44]  ;@ Get SR high T_S__III and irq level
  mov r9,r9,lsl #28  ;@ r9 = Flags 0xf0000000, cpsr format
                     ;@ r10 = Source value / Memory Base

  mov r2,#0
  str r2,[r7,#0x98]  ;@ clear custom CycloneEnd
;@ CheckInterrupt:
  movs r0,r1,lsr #24 ;@ Get IRQ level
  beq NoInts0
  cmp r0,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  bgt CycloneDoInterrupt
NoInts0:

;@ Check if our processor is in special state
;@ and jump to opcode handler if not
  ldr r0,[r7,#0x58] ;@ state_flags
  ldrh r8,[r4],#2 ;@ Fetch first opcode
  tst r0,#0x03 ;@ special state?
  ldreq pc,[r6,r8,asl #2] ;@ Jump to opcode handler

CycloneSpecial:
  tst r0,#2 ;@ tracing?
  bne CycloneDoTrace
;@ stopped or halted
  mov r5,#0
  str r5,[r7,#0x5C]  ;@ eat all cycles
  ldmia sp!,{r4-r11,pc} ;@ we are stopped, do nothing!


;@ We come back here after execution
CycloneEnd:
  sub r4,r4,#2
CycloneEndNoBack:
  ldr r1,[r7,#0x98]
  mov r9,r9,lsr #28
  tst r1,r1
  bxne r1            ;@ jump to alternative CycloneEnd
  str r4,[r7,#0x40]  ;@ Save Current PC + Memory Base
  str r5,[r7,#0x5c]  ;@ Save Cycles
  strb r9,[r7,#0x46] ;@ Save Flags (NZCV)
  ldmia sp!,{r4-r11,pc}
  .ltorg


CycloneInit:
;@ decompress jump table
  ldr r12,=CycloneJumpTab
  add r0,r12,#0xe000*4 ;@ ctrl code pointer
  ldr r1,[r0,#-4]
  tst r1,r1
  movne pc,lr ;@ already uncompressed
  add r3,r12,#0xa000*4 ;@ handler table pointer, r12=dest
unc_loop:
  ldrh r1,[r0],#2
  and r2,r1,#0xf
  bic r1,r1,#0xf
  ldr r1,[r3,r1,lsr #2] ;@ r1=handler
  cmp r2,#0xf
  addeq r2,r2,#1 ;@ 0xf is really 0x10
  tst r2,r2
  ldreqh r2,[r0],#2 ;@ counter is in next word
  tst r2,r2
  beq unc_finish ;@ done decompressing
  tst r1,r1
  addeq r12,r12,r2,lsl #2 ;@ 0 handler means we should skip those bytes
  beq unc_loop
unc_loop_in:
  subs r2,r2,#1
  str r1,[r12],#4
  bgt unc_loop_in
  b unc_loop
unc_finish:
  ldr r12,=CycloneJumpTab
  ;@ set a-line and f-line handlers
  add r0,r12,#0xa000*4
  ldr r1,[r0,#4] ;@ a-line handler
  ldr r3,[r0,#8] ;@ f-line handler
  mov r2,#0x1000
unc_fill3:
  subs r2,r2,#1
  str r1,[r0],#4
  bgt unc_fill3
  add r0,r12,#0xf000*4
  mov r2,#0x1000
unc_fill4:
  subs r2,r2,#1
  str r3,[r0],#4
  bgt unc_fill4
  bx lr
  .ltorg

CycloneSetSr:
  mov r2,r1,lsr #8
  and r2,r2,#0xa7 ;@ only defined bits
  strb r2,[r0,#0x44] ;@ set SR high
  mov r2,r1,lsl #25
  str r2,[r0,#0x4c] ;@ the X flag
  bic r2,r1,#0xf3
  tst r1,#1
  orrne r2,r2,#2
  tst r1,#2
  orrne r2,r2,#1
  strb r2,[r0,#0x46] ;@ flags
  bx lr

CycloneGetSr:
  ldrb r1,[r0,#0x46] ;@ flags
  bic r2,r1,#0xf3
  tst r1,#1
  orrne r2,r2,#2
  tst r1,#2
  orrne r2,r2,#1
  ldr r1,[r0,#0x4c] ;@ the X flag
  tst r1,#0x20000000
  orrne r2,r2,#0x10
  ldrb r1,[r0,#0x44] ;@ the SR high
  orr r0,r2,r1,lsl #8
  bx lr

CyclonePack:
  stmfd sp!,{r4,r5,lr}
  mov r4,r0
  mov r5,r1
  mov r3,#16
;@ 0x00-0x3f: DA registers
c_pack_loop:
  ldr r1,[r0],#4
  subs r3,r3,#1
  str r1,[r5],#4
  bne c_pack_loop
;@ 0x40: PC
  ldr r0,[r4,#0x40] ;@ PC + Memory Base
  ldr r1,[r4,#0x60] ;@ Memory base
  sub r0,r0,r1
  str r0,[r5],#4
;@ 0x44: SR
  mov r0,r4
  bl CycloneGetSr
  strh r0,[r5],#2
;@ 0x46: IRQ level
  ldrb r0,[r4,#0x47]
  strb r0,[r5],#2
;@ 0x48: other SP
  ldr r0,[r4,#0x48]
  str r0,[r5],#4
;@ 0x4c: CPU state flags
  ldr r0,[r4,#0x58]
  str r0,[r5],#4
  ldmfd sp!,{r4,r5,pc}

CycloneUnpack:
  stmfd sp!,{r4,r5,lr}
  mov r4,r0
  mov r5,r1
  mov r3,#16
;@ 0x00-0x3f: DA registers
c_unpack_loop:
  ldr r1,[r5],#4
  subs r3,r3,#1
  str r1,[r0],#4
  bne c_unpack_loop
;@ 0x40: PC
  ldr r0,[r5],#4 ;@ PC
  mov r1,#0
  str r1,[r4,#0x60] ;@ Memory base
  mov lr,pc
  ldr pc,[r4,#0x64] ;@ Call checkpc()
  str r0,[r4,#0x40] ;@ PC + Memory Base
;@ 0x44: SR
  ldrh r1,[r5],#2
  mov r0,r4
  bl CycloneSetSr
;@ 0x46: IRQ level
  ldrb r0,[r5],#2
  strb r0,[r4,#0x47]
;@ 0x48: other SP
  ldr r0,[r5],#4
  str r0,[r4,#0x48]
;@ 0x4c: CPU state flags
  ldr r0,[r5],#4
  str r0,[r4,#0x58]
  ldmfd sp!,{r4,r5,pc}

CycloneFlushIrq:
  ldr r1,[r0,#0x44]  ;@ Get SR high T_S__III and irq level
  mov r2,r1,lsr #24 ;@ Get IRQ level
  cmp r2,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r2,r1 ;@ irq<=6: Is irq<=mask ?
  movle r0,#0
  bxle lr ;@ no ints

  stmdb sp!,{r4,r5,r7-r11,lr}
  mov r7,r0
  mov r0,r2
  ldrb r9,[r7,#0x46] ;@ r9 = Flags (NZCV)
  mov r5,#0
  ldr r4,[r7,#0x40]  ;@ r4 = Current PC + Memory Base
  mov r9,r9,lsl #28  ;@ r9 = Flags 0xf0000000, cpsr format
  adr r2,CycloneFlushIrqEnd
  str r2,[r7,#0x98]  ;@ set custom CycloneEnd
  b CycloneDoInterrupt

CycloneFlushIrqEnd:
  rsb r0,r5,#0
  str r4,[r7,#0x40]  ;@ Save Current PC + Memory Base
  strb r9,[r7,#0x46] ;@ Save Flags (NZCV)
  ldmia sp!,{r4,r5,r7-r11,lr}
  bx lr


CycloneSetRealTAS:
  bx lr

;@ DoInterrupt - r0=IRQ level
CycloneDoInterruptGoBack:
  sub r4,r4,#2
CycloneDoInterrupt:
  bic r8,r8,#0xff000000
  orr r8,r8,r0,lsl #29 ;@ abuse r8
  ldr r2,[r7,#0x58] ;@ state flags
  and r0,r0,#7
  orr r3,r0,#0x20 ;@ Supervisor mode + IRQ level
  bic r2,r2,#3 ;@ clear stopped and trace states
  orr r2,r2,#4 ;@ set activity bit: 'not processing instruction'
  str r2,[r7,#0x58]
  ldrb r10,[r7,#0x44] ;@ Get old SR high
  strb r3,[r7,#0x44] ;@ Put new SR high

  ldr r1,[r7,#0x60] ;@ Get Memory base
  ldr r11,[r7,#0x3c] ;@ Get A7
  tst r10,#0x20
;@ get our SP:
  ldreq r2,[r7,#0x48] ;@ ...or OSP as our stack pointer
  streq r11,[r7,#0x48]
  moveq r11,r2
;@ Push old PC onto stack
  sub r0,r11,#4 ;@ Predecremented A7
  sub r1,r4,r1 ;@ r1 = Old PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler
;@ Push old SR:
  ldr r0,[r7,#0x4c]   ;@ X bit
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r2,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r2,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC
  and r0,r0,#0x20000000
  orr r1,r1,r0,lsr #25 ;@ ___XNZVC
  orr r1,r1,r10,lsl #8 ;@ Include old SR high
  sub r0,r11,#6 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  mov r11,r8,lsr #29
  mov r0,r11
;@ Clear irq:
  mov r2,#0
  strb r2,[r7,#0x47]
  add r0,r0,#0x18 ;@ use autovector
  mov r0,r0,lsl #2 ;@ get vector address

  ldr r10,[r7,#0x60] ;@ Get Memory base
;@ Read IRQ Vector:
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  tst r0,r0 ;@ uninitialized int vector?
  moveq r0,#0x3c
  moveq lr,pc
  ldreq pc,[r7,#0x70] ;@ Call read32(r0) handler
  add lr,pc,#4
  add r0,r0,r10 ;@ r0 = Memory Base + New PC
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  tst r4,#1
  bne ExceptionAddressError_r_prg_r4
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#44 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

Exception:
  ;@ Cause an Exception - Vector number in r0
  mov r11,lr ;@ Preserve ARM return address
  bic r8,r8,#0xff000000
  orr r8,r8,r0,lsl #24 ;@ abuse r8
  ldr r10,[r7,#0x44] ;@ Get old SR high
  ldr r2,[r7,#0x58] ;@ state flags
  and r3,r10,#0x27 ;@ clear trace and unused flags
  orr r3,r3,#0x20 ;@ set supervisor mode
  bic r2,r2,#3 ;@ clear stopped and trace states
  str r2,[r7,#0x58]
  strb r3,[r7,#0x44] ;@ Put new SR high

  ldr r0,[r7,#0x3c] ;@ Get A7
  tst r10,#0x20
;@ get our SP:
  ldreq r2,[r7,#0x48] ;@ ...or OSP as our stack pointer
  streq r0,[r7,#0x48]
  moveq r0,r2
;@ Push old PC onto stack
  ldr r1,[r7,#0x60] ;@ Get Memory base
  sub r0,r0,#4 ;@ Predecremented A7
  str r0,[r7,#0x3c] ;@ Save A7
  sub r1,r4,r1 ;@ r1 = Old PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler
;@ Push old SR:
  ldr r0,[r7,#0x4c]   ;@ X bit
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r2,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r2,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC
  and r0,r0,#0x20000000
  orr r1,r1,r0,lsr #25 ;@ ___XNZVC
  ldr r0,[r7,#0x3c] ;@ A7
  orr r1,r1,r10,lsl #8 ;@ Include SR high
  sub r0,r0,#2 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ Read Exception Vector:
  mov r0,r8,lsr #24
  mov r0,r0,lsl #2
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  ldr r3,[r7,#0x60] ;@ Get Memory base
  add lr,pc,#4
  add r0,r0,r3 ;@ r0 = Memory Base + New PC
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  tst r4,#1
  bne ExceptionAddressError_r_prg_r4
  bx r11 ;@ Return

ExceptionAddressError_r_data:
  ldr r1,[r7,#0x44]
  mov r10,#0x11
  mov r11,r0
  tst r1,#0x20
  orrne r10,r10,#4
  b ExceptionAddressError

ExceptionAddressError_r_prg:
  ldr r1,[r7,#0x44]
  mov r10,#0x12
  mov r11,r0
  tst r1,#0x20
  orrne r10,r10,#4
  b ExceptionAddressError

ExceptionAddressError_w_data:
  ldr r1,[r7,#0x44]
  mov r10,#0x01
  mov r11,r0
  tst r1,#0x20
  orrne r10,r10,#4
  b ExceptionAddressError

ExceptionAddressError_r_prg_r4:
  ldr r1,[r7,#0x44]
  ldr r3,[r7,#0x60] ;@ Get Memory base
  mov r10,#0x12
  sub r11,r4,r3
  tst r1,#0x20
  orrne r10,r10,#4

ExceptionAddressError:
;@ r10 - info word (without instruction/not bit), r11 - faulting address
  ldrb r0,[r7,#0x44] ;@ Get old SR high
  ldr r2,[r7,#0x58] ;@ state flags
  and r3,r0,#0x27 ;@ clear trace and unused flags
  orr r3,r3,#0x20 ;@ set supervisor mode
  strb r3,[r7,#0x44] ;@ Put new SR high
  bic r2,r2,#3 ;@ clear stopped and trace states
  tst r2,#4
  orrne r10,r10,#8 ;@ complete info word
  orr r2,r2,#4 ;@ set activity bit: 'not processing instruction'
  str r2,[r7,#0x58]
  and r9,r9,#0xf0000000
  orr r9,r9,r0,lsl #4 ;@ some preparations for SR push

  ldr r0,[r7,#0x3c] ;@ Get A7
  tst r9,#0x200
;@ get our SP:
  ldreq r2,[r7,#0x48] ;@ ...or OSP as our stack pointer
  streq r0,[r7,#0x48]
  moveq r0,r2
;@ Push old PC onto stack
  ldr r1,[r7,#0x60] ;@ Get Memory base
  sub r0,r0,#4 ;@ Predecremented A7
  sub r1,r4,r1 ;@ r1 = Old PC
  str r0,[r7,#0x3c] ;@ Save A7
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler
;@ Push old SR:
  ldr r0,[r7,#0x4c]   ;@ X bit
  mov r1,r9,ror #28   ;@ ____NZCV
  eor r2,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r2,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC
  and r0,r0,#0x20000000
  orr r1,r1,r0,lsr #25 ;@ ___XNZVC
  ldr r0,[r7,#0x3c] ;@ A7
  and r9,r9,#0xf0000000
  sub r0,r0,#2 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler
;@ Push IR:
  ldr r0,[r7,#0x3c] ;@ A7
  mov r1,r8
  sub r0,r0,#2 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler
;@ Push address:
  ldr r0,[r7,#0x3c] ;@ A7
  mov r1,r11
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler
;@ Push info word:
  ldr r0,[r7,#0x3c] ;@ A7
  mov r1,r10
  sub r0,r0,#2 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ Read Exception Vector:
  mov r0,#0x0c
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  ldr r3,[r7,#0x60] ;@ Get Memory base
  add lr,pc,#4
  add r0,r0,r3 ;@ r0 = Memory Base + New PC
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  bic r4,r4,#1
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#50 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

CycloneDoTraceWithChecks:
  ldr r0,[r7,#0x58]
  cmp r5,#0
  orr r0,r0,#2 ;@ go to trace mode
  str r0,[r7,#0x58]
  blt CycloneEnd
;@ CheckInterrupt:
  movs r0,r1,lsr #24 ;@ Get IRQ level
  beq CycloneDoTrace
  cmp r0,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  bgt CycloneDoInterruptGoBack

CycloneDoTrace:
  str r5,[r7,#0x9c] ;@ save cycles
  ldr r1,[r7,#0x98]
  mov r5,#0
  str r1,[r7,#0xa0]
  adr r0,TraceEnd
  str r0,[r7,#0x98] ;@ store TraceEnd as CycloneEnd hadler
  ldr pc,[r6,r8,asl #2] ;@ Jump to opcode handler

TraceEnd:
  ldr r2,[r7,#0x58]
  ldr r0,[r7,#0x9c] ;@ restore cycles
  ldr r1,[r7,#0xa0] ;@ old CycloneEnd handler
  mov r9,r9,lsl #28
  add r5,r0,r5
  str r1,[r7,#0x98]
;@ still tracing?
  tst r2,#2
  beq TraceDisabled
;@ trace exception
  ldr r1,[r7,#0x58]
  mov r0,#9
  orr r1,r1,#4 ;@ set activity bit: 'not processing instruction'
  str r1,[r7,#0x58]
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

TraceDisabled:
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  cmp r5,#0
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------------------------- Opcodes ---------------------------
Op____: ;@ Called if an opcode is not recognised
  ldr r1,[r7,#0x58]
  sub r4,r4,#2
  orr r1,r1,#4 ;@ set activity bit: 'not processing instruction'
  str r1,[r7,#0x58]
  mov r0,#4
  bl Exception

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

Op__al: ;@ Unrecognised a-line opcode
  sub r4,r4,#2
  mov r0,#0x0a
  bl Exception

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

Op__fl: ;@ Unrecognised f-line opcode
  sub r4,r4,#2
  mov r0,#0x0b
  bl Exception

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0000] ori.b #$33, d0 uses Op0000 ----------
Op0000:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  mov r10,r10,asl #24
;@ Do arithmetic:
  orr r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #24
  strb r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0010] ori.b #$33, (a0) uses Op0010 ----------
Op0010:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  orr r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0018] ori.b #$33, (a0)+ uses Op0018 ----------
Op0018:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  orr r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [001f] ori.b #$33, (a7)+ uses Op001f ----------
Op001f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a7)+' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  orr r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0020] ori.b #$33, -(a0) uses Op0020 ----------
Op0020:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  orr r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0027] ori.b #$33, -(a7) uses Op0027 ----------
Op0027:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '-(a7)' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  orr r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0028] ori.b #$33, ($3333,a0) uses Op0028 ----------
Op0028:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  orr r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0030] ori.b #$33, ($33,a0,d3.w*2) uses Op0030 ----------
Op0030:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  orr r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0038] ori.b #$33, $3333.w uses Op0038 ----------
Op0038:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  orr r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0039] ori.b #$33, $33333333.l uses Op0039 ----------
Op0039:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  orr r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [003c] ori.b #$33, ccr uses Op003c ----------
Op003c:
;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  ldr r2,[r7,#0x4c]   ;@ Load old X bit
  orr r9,r9,r0,lsl #28
  orr r2,r2,r0,lsl #25 ;@ X bit
  str r2,[r7,#0x4c]   ;@ Save X bit

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0040] ori.w #$3333, d0 uses Op0040 ----------
Op0040:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
  mov r11,r11,lsl #2
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11]

  mov r10,r10,asl #16
;@ Do arithmetic:
  orr r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #16
  strh r1,[r7,r11]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0050] ori.w #$3333, (a0) uses Op0050 ----------
Op0050:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  orr r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0058] ori.w #$3333, (a0)+ uses Op0058 ----------
Op0058:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  orr r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0060] ori.w #$3333, -(a0) uses Op0060 ----------
Op0060:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  orr r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0068] ori.w #$3333, ($3333,a0) uses Op0068 ----------
Op0068:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  orr r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0070] ori.w #$3333, ($33,a0,d3.w*2) uses Op0070 ----------
Op0070:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  orr r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0078] ori.w #$3333, $3333.w uses Op0078 ----------
Op0078:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  orr r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0079] ori.w #$3333, $33333333.l uses Op0079 ----------
Op0079:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  orr r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [007c] ori.w #$3333, sr uses Op007c ----------
Op007c:
  ldr r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r0:

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  ldr r2,[r7,#0x4c]   ;@ Load old X bit
  orr r9,r9,r0,lsl #28
  orr r2,r2,r0,lsl #25 ;@ X bit
  orr r1,r11,r0,lsr #8
  and r1,r1,#0xa7 ;@ mask-out unused bits
  str r2,[r7,#0x4c]   ;@ Save X bit
  strb r1,[r7,#0x44]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  ldr r1,[r7,#0x44]
  subs r5,r5,#20 ;@ Subtract cycles
;@ CheckTrace:
  tst r1,#0x80
  bne CycloneDoTraceWithChecks
  cmp r5,#0
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0080] ori.l #$33333333, d0 uses Op0080 ----------
Op0080:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

;@ Do arithmetic:
  orr r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0090] ori.l #$33333333, (a0) uses Op0090 ----------
Op0090:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  orr r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0098] ori.l #$33333333, (a0)+ uses Op0098 ----------
Op0098:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  orr r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [00a0] ori.l #$33333333, -(a0) uses Op00a0 ----------
Op00a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  orr r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [00a8] ori.l #$33333333, ($3333,a0) uses Op00a8 ----------
Op00a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  orr r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [00b0] ori.l #$33333333, ($33,a0,d3.w*2) uses Op00b0 ----------
Op00b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  orr r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [00b8] ori.l #$33333333, $3333.w uses Op00b8 ----------
Op00b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  orr r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [00b9] ori.l #$33333333, $33333333.l uses Op00b9 ----------
Op00b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  orr r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#36 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0100] btst d0, d0 uses Op0100 ----------
Op0100:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r0:
  ldr r0,[r7,r0,lsl #2]

  and r10,r10,#31 ;@ reg - do mod 32

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#6 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0108] movep.w ($3333,a0), d0 uses Op0108 ----------
Op0108:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r11:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r11,r0,asl #24

  add r0,r10,#2
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  orr r1,r11,r1,lsr #8 ;@ second byte
;@ EaCalc : Get register index into r11:
  and r11,r8,#0x0e00
  mov r11,r11,lsr #7
;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #16
  strh r1,[r7,r11]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0110] btst d0, (a0) uses Op0110 ----------
Op0110:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0118] btst d0, (a0)+ uses Op0118 ----------
Op0118:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [011f] btst d0, (a7)+ uses Op011f ----------
Op011f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0120] btst d0, -(a0) uses Op0120 ----------
Op0120:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0127] btst d0, -(a7) uses Op0127 ----------
Op0127:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0128] btst d0, ($3333,a0) uses Op0128 ----------
Op0128:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0130] btst d0, ($33,a0,d3.w*2) uses Op0130 ----------
Op0130:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0138] btst d0, $3333.w uses Op0138 ----------
Op0138:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0139] btst d0, $33333333.l uses Op0139 ----------
Op0139:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [013a] btst d0, ($3333,pc); =3335 uses Op013a ----------
Op013a:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [013b] btst d0, ($33,pc,d3.w*2); =35 uses Op013b ----------
Op013b:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [013c] btst d0, #$33 uses Op013c ----------
Op013c:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0140] bchg d0, d0 uses Op0140 ----------
Op0140:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  and r10,r10,#31 ;@ reg - do mod 32

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0148] movep.l ($3333,a0), d0 uses Op0148 ----------
Op0148:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r11:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r11,r0,asl #24

  add r0,r10,#2
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  orr r11,r11,r1,lsr #8 ;@ second byte
  add r0,r10,#4
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  orr r11,r11,r1,lsr #16 ;@ third byte
  add r0,r10,#6
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  orr r1,r11,r1,lsr #24 ;@ fourth byte
;@ EaCalc : Get register index into r11:
  and r11,r8,#0x0e00
;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0150] bchg d0, (a0) uses Op0150 ----------
Op0150:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0158] bchg d0, (a0)+ uses Op0158 ----------
Op0158:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [015f] bchg d0, (a7)+ uses Op015f ----------
Op015f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '(a7)+' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0160] bchg d0, -(a0) uses Op0160 ----------
Op0160:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0167] bchg d0, -(a7) uses Op0167 ----------
Op0167:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '-(a7)' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0168] bchg d0, ($3333,a0) uses Op0168 ----------
Op0168:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0170] bchg d0, ($33,a0,d3.w*2) uses Op0170 ----------
Op0170:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0178] bchg d0, $3333.w uses Op0178 ----------
Op0178:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0179] bchg d0, $33333333.l uses Op0179 ----------
Op0179:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0180] bclr d0, d0 uses Op0180 ----------
Op0180:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  and r10,r10,#31 ;@ reg - do mod 32

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0188] movep.w d0, ($3333,a0) uses Op0188 ----------
Op0188:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x0e00
;@ EaRead : Read register[r11] into r11:
  ldr r11,[r7,r11,lsr #7]

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
  mov r0,r10
  mov r1,r11,lsr #8 ;@ first or third byte
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  add r0,r10,#2
  and r1,r11,#0xff
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0190] bclr d0, (a0) uses Op0190 ----------
Op0190:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0198] bclr d0, (a0)+ uses Op0198 ----------
Op0198:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [019f] bclr d0, (a7)+ uses Op019f ----------
Op019f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '(a7)+' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01a0] bclr d0, -(a0) uses Op01a0 ----------
Op01a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01a7] bclr d0, -(a7) uses Op01a7 ----------
Op01a7:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '-(a7)' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01a8] bclr d0, ($3333,a0) uses Op01a8 ----------
Op01a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01b0] bclr d0, ($33,a0,d3.w*2) uses Op01b0 ----------
Op01b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01b8] bclr d0, $3333.w uses Op01b8 ----------
Op01b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01b9] bclr d0, $33333333.l uses Op01b9 ----------
Op01b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01c0] bset d0, d0 uses Op01c0 ----------
Op01c0:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  and r10,r10,#31 ;@ reg - do mod 32

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01c8] movep.l d0, ($3333,a0) uses Op01c8 ----------
Op01c8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x0e00
;@ EaRead : Read register[r11] into r11:
  ldr r11,[r7,r11,lsr #7]

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
  mov r1,r11,lsr #24 ;@ first byte
;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  add r0,r10,#2
  mov r1,r11,lsr #16 ;@ second byte
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  add r0,r10,#4
  mov r1,r11,lsr #8 ;@ first or third byte
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  add r0,r10,#6
  and r1,r11,#0xff
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01d0] bset d0, (a0) uses Op01d0 ----------
Op01d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01d8] bset d0, (a0)+ uses Op01d8 ----------
Op01d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01df] bset d0, (a7)+ uses Op01df ----------
Op01df:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '(a7)+' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01e0] bset d0, -(a0) uses Op01e0 ----------
Op01e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01e7] bset d0, -(a7) uses Op01e7 ----------
Op01e7:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '-(a7)' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01e8] bset d0, ($3333,a0) uses Op01e8 ----------
Op01e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01f0] bset d0, ($33,a0,d3.w*2) uses Op01f0 ----------
Op01f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01f8] bset d0, $3333.w uses Op01f8 ----------
Op01f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01f9] bset d0, $33333333.l uses Op01f9 ----------
Op01f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0e00
;@ EaRead : Read register[r10] into r10:
  ldr r10,[r7,r10,lsr #7]

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  and r10,r10,#7  ;@ mem - do mod 8

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0200] andi.b #$33, d0 uses Op0200 ----------
Op0200:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  mov r10,r10,asl #24
;@ Do arithmetic:
  and r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #24
  strb r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0210] andi.b #$33, (a0) uses Op0210 ----------
Op0210:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  and r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0218] andi.b #$33, (a0)+ uses Op0218 ----------
Op0218:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  and r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [021f] andi.b #$33, (a7)+ uses Op021f ----------
Op021f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a7)+' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  and r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0220] andi.b #$33, -(a0) uses Op0220 ----------
Op0220:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  and r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0227] andi.b #$33, -(a7) uses Op0227 ----------
Op0227:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '-(a7)' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  and r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0228] andi.b #$33, ($3333,a0) uses Op0228 ----------
Op0228:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  and r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0230] andi.b #$33, ($33,a0,d3.w*2) uses Op0230 ----------
Op0230:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  and r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0238] andi.b #$33, $3333.w uses Op0238 ----------
Op0238:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  and r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0239] andi.b #$33, $33333333.l uses Op0239 ----------
Op0239:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  and r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [023c] andi.b #$33, ccr uses Op023c ----------
Op023c:
;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  ldr r2,[r7,#0x4c]   ;@ Load old X bit
  and r9,r9,r0,lsl #28
  and r2,r2,r0,lsl #25 ;@ X bit
  str r2,[r7,#0x4c]   ;@ Save X bit

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0240] andi.w #$3333, d0 uses Op0240 ----------
Op0240:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
  mov r11,r11,lsl #2
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11]

  mov r10,r10,asl #16
;@ Do arithmetic:
  and r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #16
  strh r1,[r7,r11]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0250] andi.w #$3333, (a0) uses Op0250 ----------
Op0250:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  and r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0258] andi.w #$3333, (a0)+ uses Op0258 ----------
Op0258:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  and r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0260] andi.w #$3333, -(a0) uses Op0260 ----------
Op0260:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  and r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0268] andi.w #$3333, ($3333,a0) uses Op0268 ----------
Op0268:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  and r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0270] andi.w #$3333, ($33,a0,d3.w*2) uses Op0270 ----------
Op0270:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  and r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0278] andi.w #$3333, $3333.w uses Op0278 ----------
Op0278:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  and r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0279] andi.w #$3333, $33333333.l uses Op0279 ----------
Op0279:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  and r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [027c] andi.w #$3333, sr uses Op027c ----------
Op027c:
  ldr r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r0:

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  ldr r2,[r7,#0x4c]   ;@ Load old X bit
  and r9,r9,r0,lsl #28
  and r2,r2,r0,lsl #25 ;@ X bit
  and r1,r11,r0,lsr #8
  str r2,[r7,#0x4c]   ;@ Save X bit
  strb r1,[r7,#0x44]

;@ A7 <-> OSP?
  eor r0,r1,r11
  tst r0,#0x20
  beq no_sp_swap027c
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r0, [r7,#0x48] ;@ Get OSP
  str r11,[r7,#0x48]
  str r0, [r7,#0x3C]
no_sp_swap027c:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  blt CycloneEnd
;@ CheckInterrupt:
  ldr r1,[r7,#0x44]
  movs r0,r1,lsr #24 ;@ Get IRQ level
  ldreq pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  cmp r0,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  ldrle pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  b CycloneDoInterruptGoBack

;@ ---------- [0280] andi.l #$33333333, d0 uses Op0280 ----------
Op0280:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

;@ Do arithmetic:
  and r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0290] andi.l #$33333333, (a0) uses Op0290 ----------
Op0290:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  and r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0298] andi.l #$33333333, (a0)+ uses Op0298 ----------
Op0298:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  and r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [02a0] andi.l #$33333333, -(a0) uses Op02a0 ----------
Op02a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  and r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [02a8] andi.l #$33333333, ($3333,a0) uses Op02a8 ----------
Op02a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  and r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [02b0] andi.l #$33333333, ($33,a0,d3.w*2) uses Op02b0 ----------
Op02b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  and r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [02b8] andi.l #$33333333, $3333.w uses Op02b8 ----------
Op02b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  and r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [02b9] andi.l #$33333333, $33333333.l uses Op02b9 ----------
Op02b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  and r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#36 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0400] subi.b #$33, d0 uses Op0400 ----------
Op0400:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #24
  strb r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0410] subi.b #$33, (a0) uses Op0410 ----------
Op0410:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0418] subi.b #$33, (a0)+ uses Op0418 ----------
Op0418:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [041f] subi.b #$33, (a7)+ uses Op041f ----------
Op041f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a7)+' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0420] subi.b #$33, -(a0) uses Op0420 ----------
Op0420:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0427] subi.b #$33, -(a7) uses Op0427 ----------
Op0427:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '-(a7)' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0428] subi.b #$33, ($3333,a0) uses Op0428 ----------
Op0428:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0430] subi.b #$33, ($33,a0,d3.w*2) uses Op0430 ----------
Op0430:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0438] subi.b #$33, $3333.w uses Op0438 ----------
Op0438:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0439] subi.b #$33, $33333333.l uses Op0439 ----------
Op0439:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0440] subi.w #$3333, d0 uses Op0440 ----------
Op0440:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
  mov r11,r11,lsl #2
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11]

  mov r10,r10,asl #16
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #16
  strh r1,[r7,r11]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0450] subi.w #$3333, (a0) uses Op0450 ----------
Op0450:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0458] subi.w #$3333, (a0)+ uses Op0458 ----------
Op0458:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0460] subi.w #$3333, -(a0) uses Op0460 ----------
Op0460:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0468] subi.w #$3333, ($3333,a0) uses Op0468 ----------
Op0468:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0470] subi.w #$3333, ($33,a0,d3.w*2) uses Op0470 ----------
Op0470:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0478] subi.w #$3333, $3333.w uses Op0478 ----------
Op0478:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0479] subi.w #$3333, $33333333.l uses Op0479 ----------
Op0479:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0480] subi.l #$33333333, d0 uses Op0480 ----------
Op0480:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

;@ Do arithmetic:
  rsbs r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0490] subi.l #$33333333, (a0) uses Op0490 ----------
Op0490:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  rsbs r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0498] subi.l #$33333333, (a0)+ uses Op0498 ----------
Op0498:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  rsbs r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [04a0] subi.l #$33333333, -(a0) uses Op04a0 ----------
Op04a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  rsbs r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [04a8] subi.l #$33333333, ($3333,a0) uses Op04a8 ----------
Op04a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  rsbs r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [04b0] subi.l #$33333333, ($33,a0,d3.w*2) uses Op04b0 ----------
Op04b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  rsbs r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [04b8] subi.l #$33333333, $3333.w uses Op04b8 ----------
Op04b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  rsbs r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [04b9] subi.l #$33333333, $33333333.l uses Op04b9 ----------
Op04b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  rsbs r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#36 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0600] addi.b #$33, d0 uses Op0600 ----------
Op0600:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  mov r10,r10,asl #24
;@ Do arithmetic:
  adds r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #24
  strb r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0610] addi.b #$33, (a0) uses Op0610 ----------
Op0610:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  adds r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0618] addi.b #$33, (a0)+ uses Op0618 ----------
Op0618:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  adds r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [061f] addi.b #$33, (a7)+ uses Op061f ----------
Op061f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a7)+' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  adds r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0620] addi.b #$33, -(a0) uses Op0620 ----------
Op0620:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  adds r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0627] addi.b #$33, -(a7) uses Op0627 ----------
Op0627:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '-(a7)' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  adds r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0628] addi.b #$33, ($3333,a0) uses Op0628 ----------
Op0628:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  adds r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0630] addi.b #$33, ($33,a0,d3.w*2) uses Op0630 ----------
Op0630:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  adds r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0638] addi.b #$33, $3333.w uses Op0638 ----------
Op0638:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  adds r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0639] addi.b #$33, $33333333.l uses Op0639 ----------
Op0639:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  adds r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0640] addi.w #$3333, d0 uses Op0640 ----------
Op0640:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
  mov r11,r11,lsl #2
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11]

  mov r10,r10,asl #16
;@ Do arithmetic:
  adds r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #16
  strh r1,[r7,r11]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0650] addi.w #$3333, (a0) uses Op0650 ----------
Op0650:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  adds r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0658] addi.w #$3333, (a0)+ uses Op0658 ----------
Op0658:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  adds r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0660] addi.w #$3333, -(a0) uses Op0660 ----------
Op0660:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  adds r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0668] addi.w #$3333, ($3333,a0) uses Op0668 ----------
Op0668:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  adds r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0670] addi.w #$3333, ($33,a0,d3.w*2) uses Op0670 ----------
Op0670:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  adds r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0678] addi.w #$3333, $3333.w uses Op0678 ----------
Op0678:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  adds r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0679] addi.w #$3333, $33333333.l uses Op0679 ----------
Op0679:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  adds r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0680] addi.l #$33333333, d0 uses Op0680 ----------
Op0680:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

;@ Do arithmetic:
  adds r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0690] addi.l #$33333333, (a0) uses Op0690 ----------
Op0690:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  adds r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0698] addi.l #$33333333, (a0)+ uses Op0698 ----------
Op0698:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  adds r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [06a0] addi.l #$33333333, -(a0) uses Op06a0 ----------
Op06a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  adds r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [06a8] addi.l #$33333333, ($3333,a0) uses Op06a8 ----------
Op06a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  adds r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [06b0] addi.l #$33333333, ($33,a0,d3.w*2) uses Op06b0 ----------
Op06b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  adds r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [06b8] addi.l #$33333333, $3333.w uses Op06b8 ----------
Op06b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  adds r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [06b9] addi.l #$33333333, $33333333.l uses Op06b9 ----------
Op06b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  adds r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#36 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0800] btst #$33, d0 uses Op0800 ----------
Op0800:

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#0x1F ;@ reg - do mod 32
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r0:
  ldr r0,[r7,r0,lsl #2]

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0810] btst #$33, (a0) uses Op0810 ----------
Op0810:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0818] btst #$33, (a0)+ uses Op0818 ----------
Op0818:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [081f] btst #$33, (a7)+ uses Op081f ----------
Op081f:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0820] btst #$33, -(a0) uses Op0820 ----------
Op0820:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0827] btst #$33, -(a7) uses Op0827 ----------
Op0827:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0828] btst #$33, ($3333,a0) uses Op0828 ----------
Op0828:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0830] btst #$33, ($33,a0,d3.w*2) uses Op0830 ----------
Op0830:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0838] btst #$33, $3333.w uses Op0838 ----------
Op0838:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0839] btst #$33, $33333333.l uses Op0839 ----------
Op0839:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [083a] btst #$33, ($3333,pc); =3337 uses Op083a ----------
Op083a:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [083b] btst #$33, ($33,pc,d3.w*2); =37 uses Op083b ----------
Op083b:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0840] bchg #$33, d0 uses Op0840 ----------
Op0840:

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#0x1F ;@ reg - do mod 32
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0850] bchg #$33, (a0) uses Op0850 ----------
Op0850:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0858] bchg #$33, (a0)+ uses Op0858 ----------
Op0858:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [085f] bchg #$33, (a7)+ uses Op085f ----------
Op085f:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a7)+' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0860] bchg #$33, -(a0) uses Op0860 ----------
Op0860:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0867] bchg #$33, -(a7) uses Op0867 ----------
Op0867:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '-(a7)' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0868] bchg #$33, ($3333,a0) uses Op0868 ----------
Op0868:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0870] bchg #$33, ($33,a0,d3.w*2) uses Op0870 ----------
Op0870:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0878] bchg #$33, $3333.w uses Op0878 ----------
Op0878:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0879] bchg #$33, $33333333.l uses Op0879 ----------
Op0879:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0880] bclr #$33, d0 uses Op0880 ----------
Op0880:

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#0x1F ;@ reg - do mod 32
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0890] bclr #$33, (a0) uses Op0890 ----------
Op0890:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0898] bclr #$33, (a0)+ uses Op0898 ----------
Op0898:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [089f] bclr #$33, (a7)+ uses Op089f ----------
Op089f:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a7)+' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08a0] bclr #$33, -(a0) uses Op08a0 ----------
Op08a0:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08a7] bclr #$33, -(a7) uses Op08a7 ----------
Op08a7:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '-(a7)' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08a8] bclr #$33, ($3333,a0) uses Op08a8 ----------
Op08a8:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08b0] bclr #$33, ($33,a0,d3.w*2) uses Op08b0 ----------
Op08b0:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08b8] bclr #$33, $3333.w uses Op08b8 ----------
Op08b8:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08b9] bclr #$33, $33333333.l uses Op08b9 ----------
Op08b9:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08c0] bset #$33, d0 uses Op08c0 ----------
Op08c0:

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#0x1F ;@ reg - do mod 32
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08d0] bset #$33, (a0) uses Op08d0 ----------
Op08d0:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08d8] bset #$33, (a0)+ uses Op08d8 ----------
Op08d8:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08df] bset #$33, (a7)+ uses Op08df ----------
Op08df:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a7)+' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08e0] bset #$33, -(a0) uses Op08e0 ----------
Op08e0:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08e7] bset #$33, -(a7) uses Op08e7 ----------
Op08e7:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '-(a7)' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08e8] bset #$33, ($3333,a0) uses Op08e8 ----------
Op08e8:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08f0] bset #$33, ($33,a0,d3.w*2) uses Op08f0 ----------
Op08f0:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08f8] bset #$33, $3333.w uses Op08f8 ----------
Op08f8:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08f9] bset #$33, $33333333.l uses Op08f9 ----------
Op08f9:
  str r5,[r7,#0x5c] ;@ Save Cycles


;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  mov r10,#1
  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7    ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a00] eori.b #$33, d0 uses Op0a00 ----------
Op0a00:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  mov r10,r10,asl #24
;@ Do arithmetic:
  eor r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #24
  strb r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a10] eori.b #$33, (a0) uses Op0a10 ----------
Op0a10:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  eor r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a18] eori.b #$33, (a0)+ uses Op0a18 ----------
Op0a18:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  eor r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a1f] eori.b #$33, (a7)+ uses Op0a1f ----------
Op0a1f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a7)+' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  eor r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a20] eori.b #$33, -(a0) uses Op0a20 ----------
Op0a20:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  eor r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a27] eori.b #$33, -(a7) uses Op0a27 ----------
Op0a27:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '-(a7)' into r11:
  ldr r11,[r7,#0x3c] ;@ A7
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  eor r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a28] eori.b #$33, ($3333,a0) uses Op0a28 ----------
Op0a28:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  eor r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a30] eori.b #$33, ($33,a0,d3.w*2) uses Op0a30 ----------
Op0a30:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  eor r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a38] eori.b #$33, $3333.w uses Op0a38 ----------
Op0a38:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  eor r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a39] eori.b #$33, $33333333.l uses Op0a39 ----------
Op0a39:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  eor r1,r10,r0,asl #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r1,r1,asr #24
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a3c] eori.b #$33, ccr uses Op0a3c ----------
Op0a3c:
;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  ldr r2,[r7,#0x4c]   ;@ Load old X bit
  eor r9,r9,r0,lsl #28
  eor r2,r2,r0,lsl #25 ;@ X bit
  str r2,[r7,#0x4c]   ;@ Save X bit

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a40] eori.w #$3333, d0 uses Op0a40 ----------
Op0a40:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
  mov r11,r11,lsl #2
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11]

  mov r10,r10,asl #16
;@ Do arithmetic:
  eor r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #16
  strh r1,[r7,r11]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a50] eori.w #$3333, (a0) uses Op0a50 ----------
Op0a50:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  eor r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a58] eori.w #$3333, (a0)+ uses Op0a58 ----------
Op0a58:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  eor r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a60] eori.w #$3333, -(a0) uses Op0a60 ----------
Op0a60:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  eor r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a68] eori.w #$3333, ($3333,a0) uses Op0a68 ----------
Op0a68:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  eor r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a70] eori.w #$3333, ($33,a0,d3.w*2) uses Op0a70 ----------
Op0a70:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  eor r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a78] eori.w #$3333, $3333.w uses Op0a78 ----------
Op0a78:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  eor r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a79] eori.w #$3333, $33333333.l uses Op0a79 ----------
Op0a79:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  eor r1,r10,r0,asl #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r1,r1,asr #16
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a7c] eori.w #$3333, sr uses Op0a7c ----------
Op0a7c:
  ldr r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r0:

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  ldr r2,[r7,#0x4c]   ;@ Load old X bit
  eor r9,r9,r0,lsl #28
  eor r2,r2,r0,lsl #25 ;@ X bit
  eor r1,r11,r0,lsr #8
  and r1,r1,#0xa7 ;@ mask-out unused bits
  str r2,[r7,#0x4c]   ;@ Save X bit
  strb r1,[r7,#0x44]

;@ A7 <-> OSP?
  eor r0,r1,r11
  tst r0,#0x20
  beq no_sp_swap0a7c
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r0, [r7,#0x48] ;@ Get OSP
  str r11,[r7,#0x48]
  str r0, [r7,#0x3C]
no_sp_swap0a7c:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  ldr r1,[r7,#0x44]
  subs r5,r5,#20 ;@ Subtract cycles
;@ CheckTrace:
  tst r1,#0x80
  bne CycloneDoTraceWithChecks
  cmp r5,#0
  blt CycloneEnd
;@ CheckInterrupt:
  movs r0,r1,lsr #24 ;@ Get IRQ level
  ldreq pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  cmp r0,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  ldrle pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  b CycloneDoInterruptGoBack

;@ ---------- [0a80] eori.l #$33333333, d0 uses Op0a80 ----------
Op0a80:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

;@ Do arithmetic:
  eor r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a90] eori.l #$33333333, (a0) uses Op0a90 ----------
Op0a90:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  eor r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a98] eori.l #$33333333, (a0)+ uses Op0a98 ----------
Op0a98:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  eor r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0aa0] eori.l #$33333333, -(a0) uses Op0aa0 ----------
Op0aa0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  eor r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0aa8] eori.l #$33333333, ($3333,a0) uses Op0aa8 ----------
Op0aa8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  eor r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0ab0] eori.l #$33333333, ($33,a0,d3.w*2) uses Op0ab0 ----------
Op0ab0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  eor r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0ab8] eori.l #$33333333, $3333.w uses Op0ab8 ----------
Op0ab8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  eor r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0ab9] eori.l #$33333333, $33333333.l uses Op0ab9 ----------
Op0ab9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  eor r1,r10,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  bic r0,r11,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#36 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c00] cmpi.b #$33, d0 uses Op0c00 ----------
Op0c00:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r0:
  ldr r0,[r7,r0,lsl #2]

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c10] cmpi.b #$33, (a0) uses Op0c10 ----------
Op0c10:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c18] cmpi.b #$33, (a0)+ uses Op0c18 ----------
Op0c18:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c1f] cmpi.b #$33, (a7)+ uses Op0c1f ----------
Op0c1f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c20] cmpi.b #$33, -(a0) uses Op0c20 ----------
Op0c20:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c27] cmpi.b #$33, -(a7) uses Op0c27 ----------
Op0c27:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c28] cmpi.b #$33, ($3333,a0) uses Op0c28 ----------
Op0c28:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c30] cmpi.b #$33, ($33,a0,d3.w*2) uses Op0c30 ----------
Op0c30:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c38] cmpi.b #$33, $3333.w uses Op0c38 ----------
Op0c38:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c39] cmpi.b #$33, $33333333.l uses Op0c39 ----------
Op0c39:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r10,r10,asl #24
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #24 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c40] cmpi.w #$3333, d0 uses Op0c40 ----------
Op0c40:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r0:
  ldr r0,[r7,r0,lsl #2]

  mov r10,r10,asl #16
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c50] cmpi.w #$3333, (a0) uses Op0c50 ----------
Op0c50:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c58] cmpi.w #$3333, (a0)+ uses Op0c58 ----------
Op0c58:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c60] cmpi.w #$3333, -(a0) uses Op0c60 ----------
Op0c60:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c68] cmpi.w #$3333, ($3333,a0) uses Op0c68 ----------
Op0c68:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c70] cmpi.w #$3333, ($33,a0,d3.w*2) uses Op0c70 ----------
Op0c70:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c78] cmpi.w #$3333, $3333.w uses Op0c78 ----------
Op0c78:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c79] cmpi.w #$3333, $33333333.l uses Op0c79 ----------
Op0c79:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r10,r10,asl #16
;@ Do arithmetic:
  rsbs r1,r10,r0,asl #16 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c80] cmpi.l #$33333333, d0 uses Op0c80 ----------
Op0c80:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r0:
  ldr r0,[r7,r0,lsl #2]

;@ Do arithmetic:
  rsbs r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c90] cmpi.l #$33333333, (a0) uses Op0c90 ----------
Op0c90:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  rsbs r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c98] cmpi.l #$33333333, (a0)+ uses Op0c98 ----------
Op0c98:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  rsbs r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0ca0] cmpi.l #$33333333, -(a0) uses Op0ca0 ----------
Op0ca0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  rsbs r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0ca8] cmpi.l #$33333333, ($3333,a0) uses Op0ca8 ----------
Op0ca8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  rsbs r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0cb0] cmpi.l #$33333333, ($33,a0,d3.w*2) uses Op0cb0 ----------
Op0cb0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  rsbs r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0cb8] cmpi.l #$33333333, $3333.w uses Op0cb8 ----------
Op0cb8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  rsbs r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0cb9] cmpi.l #$33333333, $33333333.l uses Op0cb9 ----------
Op0cb9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r10,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  rsbs r1,r10,r0 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1000] move.b d0, d0 uses Op1000 ----------
Op1000:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsb r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1010] move.b (a0), d0 uses Op1010 ----------
Op1010:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1018] move.b (a0)+, d0 uses Op1018 ----------
Op1018:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [101f] move.b (a7)+, d0 uses Op101f ----------
Op101f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1020] move.b -(a0), d0 uses Op1020 ----------
Op1020:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1027] move.b -(a7), d0 uses Op1027 ----------
Op1027:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1028] move.b ($3333,a0), d0 uses Op1028 ----------
Op1028:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1030] move.b ($33,a0,d3.w*2), d0 uses Op1030 ----------
Op1030:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1038] move.b $3333.w, d0 uses Op1038 ----------
Op1038:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1039] move.b $33333333.l, d0 uses Op1039 ----------
Op1039:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [103a] move.b ($3333,pc), d0; =3335 uses Op103a ----------
Op103a:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [103b] move.b ($33,pc,d3.w*2), d0; =35 uses Op103b ----------
Op103b:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [103c] move.b #$33, d0 uses Op103c ----------
Op103c:
;@ EaCalc : Get '#$33' into r1:
  ldrsb r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1080] move.b d0, (a0) uses Op1080 ----------
Op1080:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsb r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1090] move.b (a0), (a0) uses Op1090 ----------
Op1090:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1098] move.b (a0)+, (a0) uses Op1098 ----------
Op1098:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [109f] move.b (a7)+, (a0) uses Op109f ----------
Op109f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10a0] move.b -(a0), (a0) uses Op10a0 ----------
Op10a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10a7] move.b -(a7), (a0) uses Op10a7 ----------
Op10a7:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10a8] move.b ($3333,a0), (a0) uses Op10a8 ----------
Op10a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10b0] move.b ($33,a0,d3.w*2), (a0) uses Op10b0 ----------
Op10b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10b8] move.b $3333.w, (a0) uses Op10b8 ----------
Op10b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10b9] move.b $33333333.l, (a0) uses Op10b9 ----------
Op10b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10ba] move.b ($3333,pc), (a0); =3335 uses Op10ba ----------
Op10ba:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10bb] move.b ($33,pc,d3.w*2), (a0); =35 uses Op10bb ----------
Op10bb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10bc] move.b #$33, (a0) uses Op10bc ----------
Op10bc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r1:
  ldrsb r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10c0] move.b d0, (a0)+ uses Op10c0 ----------
Op10c0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsb r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10d0] move.b (a0), (a0)+ uses Op10d0 ----------
Op10d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10d8] move.b (a0)+, (a0)+ uses Op10d8 ----------
Op10d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10df] move.b (a7)+, (a0)+ uses Op10df ----------
Op10df:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10e0] move.b -(a0), (a0)+ uses Op10e0 ----------
Op10e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10e7] move.b -(a7), (a0)+ uses Op10e7 ----------
Op10e7:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10e8] move.b ($3333,a0), (a0)+ uses Op10e8 ----------
Op10e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10f0] move.b ($33,a0,d3.w*2), (a0)+ uses Op10f0 ----------
Op10f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10f8] move.b $3333.w, (a0)+ uses Op10f8 ----------
Op10f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10f9] move.b $33333333.l, (a0)+ uses Op10f9 ----------
Op10f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10fa] move.b ($3333,pc), (a0)+; =3335 uses Op10fa ----------
Op10fa:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10fb] move.b ($33,pc,d3.w*2), (a0)+; =35 uses Op10fb ----------
Op10fb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10fc] move.b #$33, (a0)+ uses Op10fc ----------
Op10fc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r1:
  ldrsb r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1100] move.b d0, -(a0) uses Op1100 ----------
Op1100:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsb r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1110] move.b (a0), -(a0) uses Op1110 ----------
Op1110:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1118] move.b (a0)+, -(a0) uses Op1118 ----------
Op1118:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [111f] move.b (a7)+, -(a0) uses Op111f ----------
Op111f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1120] move.b -(a0), -(a0) uses Op1120 ----------
Op1120:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1127] move.b -(a7), -(a0) uses Op1127 ----------
Op1127:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1128] move.b ($3333,a0), -(a0) uses Op1128 ----------
Op1128:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1130] move.b ($33,a0,d3.w*2), -(a0) uses Op1130 ----------
Op1130:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1138] move.b $3333.w, -(a0) uses Op1138 ----------
Op1138:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1139] move.b $33333333.l, -(a0) uses Op1139 ----------
Op1139:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [113a] move.b ($3333,pc), -(a0); =3335 uses Op113a ----------
Op113a:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [113b] move.b ($33,pc,d3.w*2), -(a0); =35 uses Op113b ----------
Op113b:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [113c] move.b #$33, -(a0) uses Op113c ----------
Op113c:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r1:
  ldrsb r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1140] move.b d0, ($3333,a0) uses Op1140 ----------
Op1140:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsb r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1150] move.b (a0), ($3333,a0) uses Op1150 ----------
Op1150:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1158] move.b (a0)+, ($3333,a0) uses Op1158 ----------
Op1158:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [115f] move.b (a7)+, ($3333,a0) uses Op115f ----------
Op115f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1160] move.b -(a0), ($3333,a0) uses Op1160 ----------
Op1160:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1167] move.b -(a7), ($3333,a0) uses Op1167 ----------
Op1167:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1168] move.b ($3333,a0), ($3333,a0) uses Op1168 ----------
Op1168:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1170] move.b ($33,a0,d3.w*2), ($3333,a0) uses Op1170 ----------
Op1170:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1178] move.b $3333.w, ($3333,a0) uses Op1178 ----------
Op1178:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1179] move.b $33333333.l, ($3333,a0) uses Op1179 ----------
Op1179:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [117a] move.b ($3333,pc), ($3333,a0); =3335 uses Op117a ----------
Op117a:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [117b] move.b ($33,pc,d3.w*2), ($3333,a0); =35 uses Op117b ----------
Op117b:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [117c] move.b #$33, ($3333,a0) uses Op117c ----------
Op117c:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r1:
  ldrsb r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1180] move.b d0, ($33,a0,d3.w*2) uses Op1180 ----------
Op1180:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsb r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1190] move.b (a0), ($33,a0,d3.w*2) uses Op1190 ----------
Op1190:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1198] move.b (a0)+, ($33,a0,d3.w*2) uses Op1198 ----------
Op1198:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [119f] move.b (a7)+, ($33,a0,d3.w*2) uses Op119f ----------
Op119f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11a0] move.b -(a0), ($33,a0,d3.w*2) uses Op11a0 ----------
Op11a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11a7] move.b -(a7), ($33,a0,d3.w*2) uses Op11a7 ----------
Op11a7:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11a8] move.b ($3333,a0), ($33,a0,d3.w*2) uses Op11a8 ----------
Op11a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11b0] move.b ($33,a0,d3.w*2), ($33,a0,d3.w*2) uses Op11b0 ----------
Op11b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11b8] move.b $3333.w, ($33,a0,d3.w*2) uses Op11b8 ----------
Op11b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11b9] move.b $33333333.l, ($33,a0,d3.w*2) uses Op11b9 ----------
Op11b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11ba] move.b ($3333,pc), ($33,a0,d3.w*2); =3335 uses Op11ba ----------
Op11ba:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11bb] move.b ($33,pc,d3.w*2), ($33,a0,d3.w*2); =35 uses Op11bb ----------
Op11bb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11bc] move.b #$33, ($33,a0,d3.w*2) uses Op11bc ----------
Op11bc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r1:
  ldrsb r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11c0] move.b d0, $3333.w uses Op11c0 ----------
Op11c0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsb r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11d0] move.b (a0), $3333.w uses Op11d0 ----------
Op11d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11d8] move.b (a0)+, $3333.w uses Op11d8 ----------
Op11d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11df] move.b (a7)+, $3333.w uses Op11df ----------
Op11df:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11e0] move.b -(a0), $3333.w uses Op11e0 ----------
Op11e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11e7] move.b -(a7), $3333.w uses Op11e7 ----------
Op11e7:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11e8] move.b ($3333,a0), $3333.w uses Op11e8 ----------
Op11e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11f0] move.b ($33,a0,d3.w*2), $3333.w uses Op11f0 ----------
Op11f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11f8] move.b $3333.w, $3333.w uses Op11f8 ----------
Op11f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11f9] move.b $33333333.l, $3333.w uses Op11f9 ----------
Op11f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11fa] move.b ($3333,pc), $3333.w; =3335 uses Op11fa ----------
Op11fa:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11fb] move.b ($33,pc,d3.w*2), $3333.w; =35 uses Op11fb ----------
Op11fb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11fc] move.b #$33, $3333.w uses Op11fc ----------
Op11fc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r1:
  ldrsb r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13c0] move.b d0, $33333333.l uses Op13c0 ----------
Op13c0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsb r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13d0] move.b (a0), $33333333.l uses Op13d0 ----------
Op13d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13d8] move.b (a0)+, $33333333.l uses Op13d8 ----------
Op13d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13df] move.b (a7)+, $33333333.l uses Op13df ----------
Op13df:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13e0] move.b -(a0), $33333333.l uses Op13e0 ----------
Op13e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13e7] move.b -(a7), $33333333.l uses Op13e7 ----------
Op13e7:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13e8] move.b ($3333,a0), $33333333.l uses Op13e8 ----------
Op13e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13f0] move.b ($33,a0,d3.w*2), $33333333.l uses Op13f0 ----------
Op13f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13f8] move.b $3333.w, $33333333.l uses Op13f8 ----------
Op13f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13f9] move.b $33333333.l, $33333333.l uses Op13f9 ----------
Op13f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13fa] move.b ($3333,pc), $33333333.l; =3335 uses Op13fa ----------
Op13fa:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13fb] move.b ($33,pc,d3.w*2), $33333333.l; =35 uses Op13fb ----------
Op13fb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13fc] move.b #$33, $33333333.l uses Op13fc ----------
Op13fc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r1:
  ldrsb r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ec0] move.b d0, (a7)+ uses Op1ec0 ----------
Op1ec0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsb r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ed0] move.b (a0), (a7)+ uses Op1ed0 ----------
Op1ed0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ed8] move.b (a0)+, (a7)+ uses Op1ed8 ----------
Op1ed8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1edf] move.b (a7)+, (a7)+ uses Op1edf ----------
Op1edf:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ee0] move.b -(a0), (a7)+ uses Op1ee0 ----------
Op1ee0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ee7] move.b -(a7), (a7)+ uses Op1ee7 ----------
Op1ee7:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ee8] move.b ($3333,a0), (a7)+ uses Op1ee8 ----------
Op1ee8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ef0] move.b ($33,a0,d3.w*2), (a7)+ uses Op1ef0 ----------
Op1ef0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ef8] move.b $3333.w, (a7)+ uses Op1ef8 ----------
Op1ef8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ef9] move.b $33333333.l, (a7)+ uses Op1ef9 ----------
Op1ef9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1efa] move.b ($3333,pc), (a7)+; =3335 uses Op1efa ----------
Op1efa:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1efb] move.b ($33,pc,d3.w*2), (a7)+; =35 uses Op1efb ----------
Op1efb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1efc] move.b #$33, (a7)+ uses Op1efc ----------
Op1efc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r1:
  ldrsb r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f00] move.b d0, -(a7) uses Op1f00 ----------
Op1f00:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsb r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f10] move.b (a0), -(a7) uses Op1f10 ----------
Op1f10:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f18] move.b (a0)+, -(a7) uses Op1f18 ----------
Op1f18:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f1f] move.b (a7)+, -(a7) uses Op1f1f ----------
Op1f1f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f20] move.b -(a0), -(a7) uses Op1f20 ----------
Op1f20:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f27] move.b -(a7), -(a7) uses Op1f27 ----------
Op1f27:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f28] move.b ($3333,a0), -(a7) uses Op1f28 ----------
Op1f28:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f30] move.b ($33,a0,d3.w*2), -(a7) uses Op1f30 ----------
Op1f30:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f38] move.b $3333.w, -(a7) uses Op1f38 ----------
Op1f38:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f39] move.b $33333333.l, -(a7) uses Op1f39 ----------
Op1f39:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f3a] move.b ($3333,pc), -(a7); =3335 uses Op1f3a ----------
Op1f3a:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f3b] move.b ($33,pc,d3.w*2), -(a7); =35 uses Op1f3b ----------
Op1f3b:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f3c] move.b #$33, -(a7) uses Op1f3c ----------
Op1f3c:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33' into r1:
  ldrsb r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2000] move.l d0, d0 uses Op2000 ----------
Op2000:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2010] move.l (a0), d0 uses Op2010 ----------
Op2010:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2018] move.l (a0)+, d0 uses Op2018 ----------
Op2018:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2020] move.l -(a0), d0 uses Op2020 ----------
Op2020:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2028] move.l ($3333,a0), d0 uses Op2028 ----------
Op2028:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2030] move.l ($33,a0,d3.w*2), d0 uses Op2030 ----------
Op2030:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2038] move.l $3333.w, d0 uses Op2038 ----------
Op2038:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2039] move.l $33333333.l, d0 uses Op2039 ----------
Op2039:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [203a] move.l ($3333,pc), d0; =3335 uses Op203a ----------
Op203a:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [203b] move.l ($33,pc,d3.w*2), d0; =35 uses Op203b ----------
Op203b:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [203c] move.l #$33333333, d0 uses Op203c ----------
Op203c:
;@ EaCalc : Get '#$33333333' into r1:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r1,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2040] movea.l d0, a0 uses Op2040 ----------
Op2040:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsl #2]

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2050] movea.l (a0), a0 uses Op2050 ----------
Op2050:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2058] movea.l (a0)+, a0 uses Op2058 ----------
Op2058:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2060] movea.l -(a0), a0 uses Op2060 ----------
Op2060:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2068] movea.l ($3333,a0), a0 uses Op2068 ----------
Op2068:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2070] movea.l ($33,a0,d3.w*2), a0 uses Op2070 ----------
Op2070:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2078] movea.l $3333.w, a0 uses Op2078 ----------
Op2078:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2079] movea.l $33333333.l, a0 uses Op2079 ----------
Op2079:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [207a] movea.l ($3333,pc), a0; =3335 uses Op207a ----------
Op207a:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [207b] movea.l ($33,pc,d3.w*2), a0; =35 uses Op207b ----------
Op207b:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [207c] movea.l #$33333333, a0 uses Op207c ----------
Op207c:
;@ EaCalc : Get '#$33333333' into r1:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r1,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r1) into r1:

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2080] move.l d0, (a0) uses Op2080 ----------
Op2080:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2090] move.l (a0), (a0) uses Op2090 ----------
Op2090:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2098] move.l (a0)+, (a0) uses Op2098 ----------
Op2098:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20a0] move.l -(a0), (a0) uses Op20a0 ----------
Op20a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20a8] move.l ($3333,a0), (a0) uses Op20a8 ----------
Op20a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20b0] move.l ($33,a0,d3.w*2), (a0) uses Op20b0 ----------
Op20b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20b8] move.l $3333.w, (a0) uses Op20b8 ----------
Op20b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20b9] move.l $33333333.l, (a0) uses Op20b9 ----------
Op20b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20ba] move.l ($3333,pc), (a0); =3335 uses Op20ba ----------
Op20ba:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20bb] move.l ($33,pc,d3.w*2), (a0); =35 uses Op20bb ----------
Op20bb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20bc] move.l #$33333333, (a0) uses Op20bc ----------
Op20bc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r1:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r1,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20c0] move.l d0, (a0)+ uses Op20c0 ----------
Op20c0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20d0] move.l (a0), (a0)+ uses Op20d0 ----------
Op20d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20d8] move.l (a0)+, (a0)+ uses Op20d8 ----------
Op20d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20e0] move.l -(a0), (a0)+ uses Op20e0 ----------
Op20e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20e8] move.l ($3333,a0), (a0)+ uses Op20e8 ----------
Op20e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20f0] move.l ($33,a0,d3.w*2), (a0)+ uses Op20f0 ----------
Op20f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20f8] move.l $3333.w, (a0)+ uses Op20f8 ----------
Op20f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20f9] move.l $33333333.l, (a0)+ uses Op20f9 ----------
Op20f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20fa] move.l ($3333,pc), (a0)+; =3335 uses Op20fa ----------
Op20fa:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20fb] move.l ($33,pc,d3.w*2), (a0)+; =35 uses Op20fb ----------
Op20fb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20fc] move.l #$33333333, (a0)+ uses Op20fc ----------
Op20fc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r1:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r1,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2100] move.l d0, -(a0) uses Op2100 ----------
Op2100:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r10,[r7,r2,lsr #7]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsr #7]
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2110] move.l (a0), -(a0) uses Op2110 ----------
Op2110:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r10,[r7,r2,lsr #7]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsr #7]
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2118] move.l (a0)+, -(a0) uses Op2118 ----------
Op2118:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r10,[r7,r2,lsr #7]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsr #7]
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2120] move.l -(a0), -(a0) uses Op2120 ----------
Op2120:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r10,[r7,r2,lsr #7]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsr #7]
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2128] move.l ($3333,a0), -(a0) uses Op2128 ----------
Op2128:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r10,[r7,r2,lsr #7]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsr #7]
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2130] move.l ($33,a0,d3.w*2), -(a0) uses Op2130 ----------
Op2130:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r10,[r7,r2,lsr #7]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsr #7]
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2138] move.l $3333.w, -(a0) uses Op2138 ----------
Op2138:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r10,[r7,r2,lsr #7]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsr #7]
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2139] move.l $33333333.l, -(a0) uses Op2139 ----------
Op2139:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r10,[r7,r2,lsr #7]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsr #7]
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [213a] move.l ($3333,pc), -(a0); =3335 uses Op213a ----------
Op213a:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r10,[r7,r2,lsr #7]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsr #7]
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [213b] move.l ($33,pc,d3.w*2), -(a0); =35 uses Op213b ----------
Op213b:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r10,[r7,r2,lsr #7]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsr #7]
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [213c] move.l #$33333333, -(a0) uses Op213c ----------
Op213c:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r1:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r1,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r10,[r7,r2,lsr #7]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsr #7]
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2140] move.l d0, ($3333,a0) uses Op2140 ----------
Op2140:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2150] move.l (a0), ($3333,a0) uses Op2150 ----------
Op2150:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2158] move.l (a0)+, ($3333,a0) uses Op2158 ----------
Op2158:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2160] move.l -(a0), ($3333,a0) uses Op2160 ----------
Op2160:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2168] move.l ($3333,a0), ($3333,a0) uses Op2168 ----------
Op2168:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2170] move.l ($33,a0,d3.w*2), ($3333,a0) uses Op2170 ----------
Op2170:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2178] move.l $3333.w, ($3333,a0) uses Op2178 ----------
Op2178:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2179] move.l $33333333.l, ($3333,a0) uses Op2179 ----------
Op2179:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [217a] move.l ($3333,pc), ($3333,a0); =3335 uses Op217a ----------
Op217a:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [217b] move.l ($33,pc,d3.w*2), ($3333,a0); =35 uses Op217b ----------
Op217b:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [217c] move.l #$33333333, ($3333,a0) uses Op217c ----------
Op217c:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r1:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r1,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2180] move.l d0, ($33,a0,d3.w*2) uses Op2180 ----------
Op2180:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2190] move.l (a0), ($33,a0,d3.w*2) uses Op2190 ----------
Op2190:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2198] move.l (a0)+, ($33,a0,d3.w*2) uses Op2198 ----------
Op2198:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21a0] move.l -(a0), ($33,a0,d3.w*2) uses Op21a0 ----------
Op21a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21a8] move.l ($3333,a0), ($33,a0,d3.w*2) uses Op21a8 ----------
Op21a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21b0] move.l ($33,a0,d3.w*2), ($33,a0,d3.w*2) uses Op21b0 ----------
Op21b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21b8] move.l $3333.w, ($33,a0,d3.w*2) uses Op21b8 ----------
Op21b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21b9] move.l $33333333.l, ($33,a0,d3.w*2) uses Op21b9 ----------
Op21b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21ba] move.l ($3333,pc), ($33,a0,d3.w*2); =3335 uses Op21ba ----------
Op21ba:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21bb] move.l ($33,pc,d3.w*2), ($33,a0,d3.w*2); =35 uses Op21bb ----------
Op21bb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21bc] move.l #$33333333, ($33,a0,d3.w*2) uses Op21bc ----------
Op21bc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r1:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r1,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21c0] move.l d0, $3333.w uses Op21c0 ----------
Op21c0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21d0] move.l (a0), $3333.w uses Op21d0 ----------
Op21d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21d8] move.l (a0)+, $3333.w uses Op21d8 ----------
Op21d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21e0] move.l -(a0), $3333.w uses Op21e0 ----------
Op21e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21e8] move.l ($3333,a0), $3333.w uses Op21e8 ----------
Op21e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21f0] move.l ($33,a0,d3.w*2), $3333.w uses Op21f0 ----------
Op21f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21f8] move.l $3333.w, $3333.w uses Op21f8 ----------
Op21f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21f9] move.l $33333333.l, $3333.w uses Op21f9 ----------
Op21f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21fa] move.l ($3333,pc), $3333.w; =3335 uses Op21fa ----------
Op21fa:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21fb] move.l ($33,pc,d3.w*2), $3333.w; =35 uses Op21fb ----------
Op21fb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21fc] move.l #$33333333, $3333.w uses Op21fc ----------
Op21fc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r1:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r1,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23c0] move.l d0, $33333333.l uses Op23c0 ----------
Op23c0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23d0] move.l (a0), $33333333.l uses Op23d0 ----------
Op23d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23d8] move.l (a0)+, $33333333.l uses Op23d8 ----------
Op23d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23e0] move.l -(a0), $33333333.l uses Op23e0 ----------
Op23e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23e8] move.l ($3333,a0), $33333333.l uses Op23e8 ----------
Op23e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23f0] move.l ($33,a0,d3.w*2), $33333333.l uses Op23f0 ----------
Op23f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23f8] move.l $3333.w, $33333333.l uses Op23f8 ----------
Op23f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23f9] move.l $33333333.l, $33333333.l uses Op23f9 ----------
Op23f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#36 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23fa] move.l ($3333,pc), $33333333.l; =3335 uses Op23fa ----------
Op23fa:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23fb] move.l ($33,pc,d3.w*2), $33333333.l; =35 uses Op23fb ----------
Op23fb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23fc] move.l #$33333333, $33333333.l uses Op23fc ----------
Op23fc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r1:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r1,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ec0] move.l d0, (a7)+ uses Op2ec0 ----------
Op2ec0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ed0] move.l (a0), (a7)+ uses Op2ed0 ----------
Op2ed0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ed8] move.l (a0)+, (a7)+ uses Op2ed8 ----------
Op2ed8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ee0] move.l -(a0), (a7)+ uses Op2ee0 ----------
Op2ee0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ee8] move.l ($3333,a0), (a7)+ uses Op2ee8 ----------
Op2ee8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ef0] move.l ($33,a0,d3.w*2), (a7)+ uses Op2ef0 ----------
Op2ef0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ef8] move.l $3333.w, (a7)+ uses Op2ef8 ----------
Op2ef8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ef9] move.l $33333333.l, (a7)+ uses Op2ef9 ----------
Op2ef9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2efa] move.l ($3333,pc), (a7)+; =3335 uses Op2efa ----------
Op2efa:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2efb] move.l ($33,pc,d3.w*2), (a7)+; =35 uses Op2efb ----------
Op2efb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2efc] move.l #$33333333, (a7)+ uses Op2efc ----------
Op2efc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r1:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r1,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f00] move.l d0, -(a7) uses Op2f00 ----------
Op2f00:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f10] move.l (a0), -(a7) uses Op2f10 ----------
Op2f10:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f18] move.l (a0)+, -(a7) uses Op2f18 ----------
Op2f18:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f20] move.l -(a0), -(a7) uses Op2f20 ----------
Op2f20:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f28] move.l ($3333,a0), -(a7) uses Op2f28 ----------
Op2f28:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f30] move.l ($33,a0,d3.w*2), -(a7) uses Op2f30 ----------
Op2f30:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f38] move.l $3333.w, -(a7) uses Op2f38 ----------
Op2f38:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f39] move.l $33333333.l, -(a7) uses Op2f39 ----------
Op2f39:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f3a] move.l ($3333,pc), -(a7); =3335 uses Op2f3a ----------
Op2f3a:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f3b] move.l ($33,pc,d3.w*2), -(a7); =35 uses Op2f3b ----------
Op2f3b:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f3c] move.l #$33333333, -(a7) uses Op2f3c ----------
Op2f3c:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$33333333' into r1:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r3,[r4],#2
  orr r1,r3,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
  mov r11,r1
  add r0,r10,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r1,r11,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3000] move.w d0, d0 uses Op3000 ----------
Op3000:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3010] move.w (a0), d0 uses Op3010 ----------
Op3010:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3018] move.w (a0)+, d0 uses Op3018 ----------
Op3018:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3020] move.w -(a0), d0 uses Op3020 ----------
Op3020:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3028] move.w ($3333,a0), d0 uses Op3028 ----------
Op3028:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3030] move.w ($33,a0,d3.w*2), d0 uses Op3030 ----------
Op3030:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3038] move.w $3333.w, d0 uses Op3038 ----------
Op3038:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3039] move.w $33333333.l, d0 uses Op3039 ----------
Op3039:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [303a] move.w ($3333,pc), d0; =3335 uses Op303a ----------
Op303a:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [303b] move.w ($33,pc,d3.w*2), d0; =35 uses Op303b ----------
Op303b:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [303c] move.w #$3333, d0 uses Op303c ----------
Op303c:
;@ EaCalc : Get '#$3333' into r1:
  ldrsh r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3040] movea.w d0, a0 uses Op3040 ----------
Op3040:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x1e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3050] movea.w (a0), a0 uses Op3050 ----------
Op3050:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x1e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3058] movea.w (a0)+, a0 uses Op3058 ----------
Op3058:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x1e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3060] movea.w -(a0), a0 uses Op3060 ----------
Op3060:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x1e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3068] movea.w ($3333,a0), a0 uses Op3068 ----------
Op3068:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x1e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3070] movea.w ($33,a0,d3.w*2), a0 uses Op3070 ----------
Op3070:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x1e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3078] movea.w $3333.w, a0 uses Op3078 ----------
Op3078:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x1e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3079] movea.w $33333333.l, a0 uses Op3079 ----------
Op3079:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x1e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [307a] movea.w ($3333,pc), a0; =3335 uses Op307a ----------
Op307a:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x1e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [307b] movea.w ($33,pc,d3.w*2), a0; =35 uses Op307b ----------
Op307b:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x1e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [307c] movea.w #$3333, a0 uses Op307c ----------
Op307c:
;@ EaCalc : Get '#$3333' into r1:
  ldrsh r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r1) into r1:

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x1e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3080] move.w d0, (a0) uses Op3080 ----------
Op3080:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3090] move.w (a0), (a0) uses Op3090 ----------
Op3090:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3098] move.w (a0)+, (a0) uses Op3098 ----------
Op3098:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30a0] move.w -(a0), (a0) uses Op30a0 ----------
Op30a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30a8] move.w ($3333,a0), (a0) uses Op30a8 ----------
Op30a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30b0] move.w ($33,a0,d3.w*2), (a0) uses Op30b0 ----------
Op30b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30b8] move.w $3333.w, (a0) uses Op30b8 ----------
Op30b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30b9] move.w $33333333.l, (a0) uses Op30b9 ----------
Op30b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30ba] move.w ($3333,pc), (a0); =3335 uses Op30ba ----------
Op30ba:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30bb] move.w ($33,pc,d3.w*2), (a0); =35 uses Op30bb ----------
Op30bb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30bc] move.w #$3333, (a0) uses Op30bc ----------
Op30bc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r1:
  ldrsh r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30c0] move.w d0, (a0)+ uses Op30c0 ----------
Op30c0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30d0] move.w (a0), (a0)+ uses Op30d0 ----------
Op30d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30d8] move.w (a0)+, (a0)+ uses Op30d8 ----------
Op30d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30e0] move.w -(a0), (a0)+ uses Op30e0 ----------
Op30e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30e8] move.w ($3333,a0), (a0)+ uses Op30e8 ----------
Op30e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30f0] move.w ($33,a0,d3.w*2), (a0)+ uses Op30f0 ----------
Op30f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30f8] move.w $3333.w, (a0)+ uses Op30f8 ----------
Op30f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30f9] move.w $33333333.l, (a0)+ uses Op30f9 ----------
Op30f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30fa] move.w ($3333,pc), (a0)+; =3335 uses Op30fa ----------
Op30fa:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30fb] move.w ($33,pc,d3.w*2), (a0)+; =35 uses Op30fb ----------
Op30fb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30fc] move.w #$3333, (a0)+ uses Op30fc ----------
Op30fc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r1:
  ldrsh r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3100] move.w d0, -(a0) uses Op3100 ----------
Op3100:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3110] move.w (a0), -(a0) uses Op3110 ----------
Op3110:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3118] move.w (a0)+, -(a0) uses Op3118 ----------
Op3118:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3120] move.w -(a0), -(a0) uses Op3120 ----------
Op3120:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3128] move.w ($3333,a0), -(a0) uses Op3128 ----------
Op3128:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3130] move.w ($33,a0,d3.w*2), -(a0) uses Op3130 ----------
Op3130:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3138] move.w $3333.w, -(a0) uses Op3138 ----------
Op3138:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3139] move.w $33333333.l, -(a0) uses Op3139 ----------
Op3139:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [313a] move.w ($3333,pc), -(a0); =3335 uses Op313a ----------
Op313a:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [313b] move.w ($33,pc,d3.w*2), -(a0); =35 uses Op313b ----------
Op313b:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [313c] move.w #$3333, -(a0) uses Op313c ----------
Op313c:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r1:
  ldrsh r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x1e00
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3140] move.w d0, ($3333,a0) uses Op3140 ----------
Op3140:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3150] move.w (a0), ($3333,a0) uses Op3150 ----------
Op3150:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3158] move.w (a0)+, ($3333,a0) uses Op3158 ----------
Op3158:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3160] move.w -(a0), ($3333,a0) uses Op3160 ----------
Op3160:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3168] move.w ($3333,a0), ($3333,a0) uses Op3168 ----------
Op3168:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3170] move.w ($33,a0,d3.w*2), ($3333,a0) uses Op3170 ----------
Op3170:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3178] move.w $3333.w, ($3333,a0) uses Op3178 ----------
Op3178:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3179] move.w $33333333.l, ($3333,a0) uses Op3179 ----------
Op3179:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [317a] move.w ($3333,pc), ($3333,a0); =3335 uses Op317a ----------
Op317a:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [317b] move.w ($33,pc,d3.w*2), ($3333,a0); =35 uses Op317b ----------
Op317b:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [317c] move.w #$3333, ($3333,a0) uses Op317c ----------
Op317c:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r1:
  ldrsh r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x1e00
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3180] move.w d0, ($33,a0,d3.w*2) uses Op3180 ----------
Op3180:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3190] move.w (a0), ($33,a0,d3.w*2) uses Op3190 ----------
Op3190:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3198] move.w (a0)+, ($33,a0,d3.w*2) uses Op3198 ----------
Op3198:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31a0] move.w -(a0), ($33,a0,d3.w*2) uses Op31a0 ----------
Op31a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31a8] move.w ($3333,a0), ($33,a0,d3.w*2) uses Op31a8 ----------
Op31a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31b0] move.w ($33,a0,d3.w*2), ($33,a0,d3.w*2) uses Op31b0 ----------
Op31b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31b8] move.w $3333.w, ($33,a0,d3.w*2) uses Op31b8 ----------
Op31b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31b9] move.w $33333333.l, ($33,a0,d3.w*2) uses Op31b9 ----------
Op31b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31ba] move.w ($3333,pc), ($33,a0,d3.w*2); =3335 uses Op31ba ----------
Op31ba:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31bb] move.w ($33,pc,d3.w*2), ($33,a0,d3.w*2); =35 uses Op31bb ----------
Op31bb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31bc] move.w #$3333, ($33,a0,d3.w*2) uses Op31bc ----------
Op31bc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r1:
  ldrsh r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x1e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31c0] move.w d0, $3333.w uses Op31c0 ----------
Op31c0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31d0] move.w (a0), $3333.w uses Op31d0 ----------
Op31d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31d8] move.w (a0)+, $3333.w uses Op31d8 ----------
Op31d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31e0] move.w -(a0), $3333.w uses Op31e0 ----------
Op31e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31e8] move.w ($3333,a0), $3333.w uses Op31e8 ----------
Op31e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31f0] move.w ($33,a0,d3.w*2), $3333.w uses Op31f0 ----------
Op31f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31f8] move.w $3333.w, $3333.w uses Op31f8 ----------
Op31f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31f9] move.w $33333333.l, $3333.w uses Op31f9 ----------
Op31f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31fa] move.w ($3333,pc), $3333.w; =3335 uses Op31fa ----------
Op31fa:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31fb] move.w ($33,pc,d3.w*2), $3333.w; =35 uses Op31fb ----------
Op31fb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31fc] move.w #$3333, $3333.w uses Op31fc ----------
Op31fc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r1:
  ldrsh r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33c0] move.w d0, $33333333.l uses Op33c0 ----------
Op33c0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33d0] move.w (a0), $33333333.l uses Op33d0 ----------
Op33d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33d8] move.w (a0)+, $33333333.l uses Op33d8 ----------
Op33d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33e0] move.w -(a0), $33333333.l uses Op33e0 ----------
Op33e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33e8] move.w ($3333,a0), $33333333.l uses Op33e8 ----------
Op33e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33f0] move.w ($33,a0,d3.w*2), $33333333.l uses Op33f0 ----------
Op33f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33f8] move.w $3333.w, $33333333.l uses Op33f8 ----------
Op33f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33f9] move.w $33333333.l, $33333333.l uses Op33f9 ----------
Op33f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33fa] move.w ($3333,pc), $33333333.l; =3335 uses Op33fa ----------
Op33fa:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33fb] move.w ($33,pc,d3.w*2), $33333333.l; =35 uses Op33fb ----------
Op33fb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33fc] move.w #$3333, $33333333.l uses Op33fc ----------
Op33fc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r1:
  ldrsh r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ec0] move.w d0, (a7)+ uses Op3ec0 ----------
Op3ec0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ed0] move.w (a0), (a7)+ uses Op3ed0 ----------
Op3ed0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ed8] move.w (a0)+, (a7)+ uses Op3ed8 ----------
Op3ed8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ee0] move.w -(a0), (a7)+ uses Op3ee0 ----------
Op3ee0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ee8] move.w ($3333,a0), (a7)+ uses Op3ee8 ----------
Op3ee8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ef0] move.w ($33,a0,d3.w*2), (a7)+ uses Op3ef0 ----------
Op3ef0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ef8] move.w $3333.w, (a7)+ uses Op3ef8 ----------
Op3ef8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ef9] move.w $33333333.l, (a7)+ uses Op3ef9 ----------
Op3ef9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3efa] move.w ($3333,pc), (a7)+; =3335 uses Op3efa ----------
Op3efa:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3efb] move.w ($33,pc,d3.w*2), (a7)+; =35 uses Op3efb ----------
Op3efb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3efc] move.w #$3333, (a7)+ uses Op3efc ----------
Op3efc:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r1:
  ldrsh r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f00] move.w d0, -(a7) uses Op3f00 ----------
Op3f00:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get register index into r1:
  and r1,r8,#0x000f
  mov r1,r1,lsl #2
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f10] move.w (a0), -(a7) uses Op3f10 ----------
Op3f10:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f18] move.w (a0)+, -(a7) uses Op3f18 ----------
Op3f18:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f20] move.w -(a0), -(a7) uses Op3f20 ----------
Op3f20:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f28] move.w ($3333,a0), -(a7) uses Op3f28 ----------
Op3f28:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f30] move.w ($33,a0,d3.w*2), -(a7) uses Op3f30 ----------
Op3f30:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f38] move.w $3333.w, -(a7) uses Op3f38 ----------
Op3f38:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f39] move.w $33333333.l, -(a7) uses Op3f39 ----------
Op3f39:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f3a] move.w ($3333,pc), -(a7); =3335 uses Op3f3a ----------
Op3f3a:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f3b] move.w ($33,pc,d3.w*2), -(a7); =35 uses Op3f3b ----------
Op3f3b:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f3c] move.w #$3333, -(a7) uses Op3f3c ----------
Op3f3c:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '#$3333' into r1:
  ldrsh r1,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r1) into r1:

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4000] negx.b d0 uses Op4000 ----------
Op4000:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: r1 into register[r10]:
  strb r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4010] negx.b (a0) uses Op4010 ----------
Op4010:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4018] negx.b (a0)+ uses Op4018 ----------
Op4018:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [401f] negx.b (a7)+ uses Op401f ----------
Op401f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4020] negx.b -(a0) uses Op4020 ----------
Op4020:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#1 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4027] negx.b -(a7) uses Op4027 ----------
Op4027:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4028] negx.b ($3333,a0) uses Op4028 ----------
Op4028:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4030] negx.b ($33,a0,d3.w*2) uses Op4030 ----------
Op4030:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4038] negx.b $3333.w uses Op4038 ----------
Op4038:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4039] negx.b $33333333.l uses Op4039 ----------
Op4039:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4040] negx.w d0 uses Op4040 ----------
Op4040:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10]

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: r1 into register[r10]:
  strh r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4050] negx.w (a0) uses Op4050 ----------
Op4050:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4058] negx.w (a0)+ uses Op4058 ----------
Op4058:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4060] negx.w -(a0) uses Op4060 ----------
Op4060:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4068] negx.w ($3333,a0) uses Op4068 ----------
Op4068:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4070] negx.w ($33,a0,d3.w*2) uses Op4070 ----------
Op4070:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4078] negx.w $3333.w uses Op4078 ----------
Op4078:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4079] negx.w $33333333.l uses Op4079 ----------
Op4079:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,asl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4080] negx.l d0 uses Op4080 ----------
Op4080:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#6 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4090] negx.l (a0) uses Op4090 ----------
Op4090:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4098] negx.l (a0)+ uses Op4098 ----------
Op4098:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40a0] negx.l -(a0) uses Op40a0 ----------
Op40a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40a8] negx.l ($3333,a0) uses Op40a8 ----------
Op40a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40b0] negx.l ($33,a0,d3.w*2) uses Op40b0 ----------
Op40b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40b8] negx.l $3333.w uses Op40b8 ----------
Op40b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40b9] negx.l $33333333.l uses Op40b9 ----------
Op40b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Negx:
;@ Get X bit:
  ldr r2,[r7,#0x4c]
  mvn r2,r2 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40c0] move sr, d0 uses Op40c0 ----------
Op40c0:
  ldr r0,[r7,#0x4c]   ;@ X bit
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r2,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r2,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x20000000
  orr r1,r1,r0,lsr #25 ;@ ___XNZVC
  orr r1,r1,r2,lsl #8

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#6 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40d0] move sr, (a0) uses Op40d0 ----------
Op40d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r0,[r7,#0x4c]   ;@ X bit
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r2,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r2,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x20000000
  orr r1,r1,r0,lsr #25 ;@ ___XNZVC
  orr r1,r1,r2,lsl #8

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40d8] move sr, (a0)+ uses Op40d8 ----------
Op40d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r0,[r7,#0x4c]   ;@ X bit
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r2,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r2,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x20000000
  orr r1,r1,r0,lsr #25 ;@ ___XNZVC
  orr r1,r1,r2,lsl #8

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40e0] move sr, -(a0) uses Op40e0 ----------
Op40e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r0,[r7,#0x4c]   ;@ X bit
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r2,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r2,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x20000000
  orr r1,r1,r0,lsr #25 ;@ ___XNZVC
  orr r1,r1,r2,lsl #8

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40e8] move sr, ($3333,a0) uses Op40e8 ----------
Op40e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r0,[r7,#0x4c]   ;@ X bit
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r2,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r2,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x20000000
  orr r1,r1,r0,lsr #25 ;@ ___XNZVC
  orr r1,r1,r2,lsl #8

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40f0] move sr, ($33,a0,d3.w*2) uses Op40f0 ----------
Op40f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r0,[r7,#0x4c]   ;@ X bit
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r2,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r2,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x20000000
  orr r1,r1,r0,lsr #25 ;@ ___XNZVC
  orr r1,r1,r2,lsl #8

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40f8] move sr, $3333.w uses Op40f8 ----------
Op40f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r0,[r7,#0x4c]   ;@ X bit
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r2,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r2,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x20000000
  orr r1,r1,r0,lsr #25 ;@ ___XNZVC
  orr r1,r1,r2,lsl #8

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40f9] move sr, $33333333.l uses Op40f9 ----------
Op40f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r0,[r7,#0x4c]   ;@ X bit
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r2,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r2,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x20000000
  orr r1,r1,r0,lsr #25 ;@ ___XNZVC
  orr r1,r1,r2,lsl #8

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4180] chk d0, a0 uses Op4180 ----------
Op4180:
;@ Get EA into r10 and value into r0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r0:
  ldr r0,[r7,r0,lsl #2]

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsr #7]

  mov r0,r0,asl #16
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap4180
;@ Do arithmetic:
  bic r9,r9,#0x80000000 ;@ N
  cmp r1,r0
  bgt chktrap4180
;@ old N remains
  orr r9,r9,r3
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap4180: ;@ CHK exception:
  mov r0,#6
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#50 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4190] chk (a0), a0 uses Op4190 ----------
Op4190:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsr #7]

  mov r0,r0,asl #16
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap4190
;@ Do arithmetic:
  bic r9,r9,#0x80000000 ;@ N
  cmp r1,r0
  bgt chktrap4190
;@ old N remains
  orr r9,r9,r3
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap4190: ;@ CHK exception:
  mov r0,#6
  bl Exception
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#54 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4198] chk (a0)+, a0 uses Op4198 ----------
Op4198:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsr #7]

  mov r0,r0,asl #16
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap4198
;@ Do arithmetic:
  bic r9,r9,#0x80000000 ;@ N
  cmp r1,r0
  bgt chktrap4198
;@ old N remains
  orr r9,r9,r3
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap4198: ;@ CHK exception:
  mov r0,#6
  bl Exception
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#54 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41a0] chk -(a0), a0 uses Op41a0 ----------
Op41a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsr #7]

  mov r0,r0,asl #16
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41a0
;@ Do arithmetic:
  bic r9,r9,#0x80000000 ;@ N
  cmp r1,r0
  bgt chktrap41a0
;@ old N remains
  orr r9,r9,r3
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41a0: ;@ CHK exception:
  mov r0,#6
  bl Exception
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#56 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41a8] chk ($3333,a0), a0 uses Op41a8 ----------
Op41a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsr #7]

  mov r0,r0,asl #16
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41a8
;@ Do arithmetic:
  bic r9,r9,#0x80000000 ;@ N
  cmp r1,r0
  bgt chktrap41a8
;@ old N remains
  orr r9,r9,r3
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41a8: ;@ CHK exception:
  mov r0,#6
  bl Exception
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#58 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41b0] chk ($33,a0,d3.w*2), a0 uses Op41b0 ----------
Op41b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsr #7]

  mov r0,r0,asl #16
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41b0
;@ Do arithmetic:
  bic r9,r9,#0x80000000 ;@ N
  cmp r1,r0
  bgt chktrap41b0
;@ old N remains
  orr r9,r9,r3
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41b0: ;@ CHK exception:
  mov r0,#6
  bl Exception
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#60 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41b8] chk $3333.w, a0 uses Op41b8 ----------
Op41b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsr #7]

  mov r0,r0,asl #16
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41b8
;@ Do arithmetic:
  bic r9,r9,#0x80000000 ;@ N
  cmp r1,r0
  bgt chktrap41b8
;@ old N remains
  orr r9,r9,r3
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41b8: ;@ CHK exception:
  mov r0,#6
  bl Exception
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#58 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41b9] chk $33333333.l, a0 uses Op41b9 ----------
Op41b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsr #7]

  mov r0,r0,asl #16
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41b9
;@ Do arithmetic:
  bic r9,r9,#0x80000000 ;@ N
  cmp r1,r0
  bgt chktrap41b9
;@ old N remains
  orr r9,r9,r3
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41b9: ;@ CHK exception:
  mov r0,#6
  bl Exception
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#62 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41ba] chk ($3333,pc), a0; =3335 uses Op41ba ----------
Op41ba:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsr #7]

  mov r0,r0,asl #16
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41ba
;@ Do arithmetic:
  bic r9,r9,#0x80000000 ;@ N
  cmp r1,r0
  bgt chktrap41ba
;@ old N remains
  orr r9,r9,r3
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41ba: ;@ CHK exception:
  mov r0,#6
  bl Exception
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#58 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41bb] chk ($33,pc,d3.w*2), a0; =35 uses Op41bb ----------
Op41bb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsr #7]

  mov r0,r0,asl #16
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41bb
;@ Do arithmetic:
  bic r9,r9,#0x80000000 ;@ N
  cmp r1,r0
  bgt chktrap41bb
;@ old N remains
  orr r9,r9,r3
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41bb: ;@ CHK exception:
  mov r0,#6
  bl Exception
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#60 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41bc] chk #$33, a0 uses Op41bc ----------
Op41bc:
;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r0:

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
;@ EaRead : Read register[r1] into r1:
  ldr r1,[r7,r1,lsr #7]

  mov r0,r0,asl #16
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41bc
;@ Do arithmetic:
  bic r9,r9,#0x80000000 ;@ N
  cmp r1,r0
  bgt chktrap41bc
;@ old N remains
  orr r9,r9,r3
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41bc: ;@ CHK exception:
  mov r0,#6
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#54 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41d0] lea (a0), a0 uses Op41d0 ----------
Op41d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r1:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r1,[r7,r2,lsl #2]
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41e8] lea ($3333,a0), a0 uses Op41e8 ----------
Op41e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r1:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r1,r0,r2 ;@ Add on offset
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41f0] lea ($33,a0,d3.w*2), a0 uses Op41f0 ----------
Op41f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r1:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r1,r2,r3 ;@ r1=Disp+An+Rn
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41f8] lea $3333.w, a0 uses Op41f8 ----------
Op41f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r1:
  ldrsh r1,[r4],#2 ;@ Fetch Absolute Short address
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41f9] lea $33333333.l, a0 uses Op41f9 ----------
Op41f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r1:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r1,r0,r2,lsl #16
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41fa] lea ($3333,pc), a0; =3335 uses Op41fa ----------
Op41fa:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r1:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r1,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41fb] lea ($33,pc,d3.w*2), a0; =35 uses Op41fb ----------
Op41fb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r1:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r1,r2,r0,asr #8 ;@ r1=Disp+PC+Rn
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4200] clr.b d0 uses Op4200 ----------
Op4200:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: r1 into register[r10]:
  strb r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4210] clr.b (a0) uses Op4210 ----------
Op4210:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4218] clr.b (a0)+ uses Op4218 ----------
Op4218:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [421f] clr.b (a7)+ uses Op421f ----------
Op421f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4220] clr.b -(a0) uses Op4220 ----------
Op4220:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#1 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4227] clr.b -(a7) uses Op4227 ----------
Op4227:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4228] clr.b ($3333,a0) uses Op4228 ----------
Op4228:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4230] clr.b ($33,a0,d3.w*2) uses Op4230 ----------
Op4230:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4238] clr.b $3333.w uses Op4238 ----------
Op4238:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4239] clr.b $33333333.l uses Op4239 ----------
Op4239:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4240] clr.w d0 uses Op4240 ----------
Op4240:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: r1 into register[r10]:
  strh r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4250] clr.w (a0) uses Op4250 ----------
Op4250:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4258] clr.w (a0)+ uses Op4258 ----------
Op4258:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4260] clr.w -(a0) uses Op4260 ----------
Op4260:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4268] clr.w ($3333,a0) uses Op4268 ----------
Op4268:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4270] clr.w ($33,a0,d3.w*2) uses Op4270 ----------
Op4270:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4278] clr.w $3333.w uses Op4278 ----------
Op4278:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4279] clr.w $33333333.l uses Op4279 ----------
Op4279:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4280] clr.l d0 uses Op4280 ----------
Op4280:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#6 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4290] clr.l (a0) uses Op4290 ----------
Op4290:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4298] clr.l (a0)+ uses Op4298 ----------
Op4298:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [42a0] clr.l -(a0) uses Op42a0 ----------
Op42a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [42a8] clr.l ($3333,a0) uses Op42a8 ----------
Op42a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [42b0] clr.l ($33,a0,d3.w*2) uses Op42b0 ----------
Op42b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [42b8] clr.l $3333.w uses Op42b8 ----------
Op42b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [42b9] clr.l $33333333.l uses Op42b9 ----------
Op42b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4400] neg.b d0 uses Op4400 ----------
Op4400:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

;@ Neg:
  mov r0,r0,asl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: r1 into register[r10]:
  strb r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4410] neg.b (a0) uses Op4410 ----------
Op4410:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Neg:
  mov r0,r0,asl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4418] neg.b (a0)+ uses Op4418 ----------
Op4418:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Neg:
  mov r0,r0,asl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [441f] neg.b (a7)+ uses Op441f ----------
Op441f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Neg:
  mov r0,r0,asl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4420] neg.b -(a0) uses Op4420 ----------
Op4420:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#1 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Neg:
  mov r0,r0,asl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4427] neg.b -(a7) uses Op4427 ----------
Op4427:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Neg:
  mov r0,r0,asl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4428] neg.b ($3333,a0) uses Op4428 ----------
Op4428:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Neg:
  mov r0,r0,asl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4430] neg.b ($33,a0,d3.w*2) uses Op4430 ----------
Op4430:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Neg:
  mov r0,r0,asl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4438] neg.b $3333.w uses Op4438 ----------
Op4438:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Neg:
  mov r0,r0,asl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4439] neg.b $33333333.l uses Op4439 ----------
Op4439:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Neg:
  mov r0,r0,asl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4440] neg.w d0 uses Op4440 ----------
Op4440:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10]

;@ Neg:
  mov r0,r0,asl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: r1 into register[r10]:
  strh r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4450] neg.w (a0) uses Op4450 ----------
Op4450:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Neg:
  mov r0,r0,asl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4458] neg.w (a0)+ uses Op4458 ----------
Op4458:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Neg:
  mov r0,r0,asl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4460] neg.w -(a0) uses Op4460 ----------
Op4460:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Neg:
  mov r0,r0,asl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4468] neg.w ($3333,a0) uses Op4468 ----------
Op4468:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Neg:
  mov r0,r0,asl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4470] neg.w ($33,a0,d3.w*2) uses Op4470 ----------
Op4470:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Neg:
  mov r0,r0,asl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4478] neg.w $3333.w uses Op4478 ----------
Op4478:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Neg:
  mov r0,r0,asl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4479] neg.w $33333333.l uses Op4479 ----------
Op4479:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Neg:
  mov r0,r0,asl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4480] neg.l d0 uses Op4480 ----------
Op4480:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#6 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4490] neg.l (a0) uses Op4490 ----------
Op4490:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4498] neg.l (a0)+ uses Op4498 ----------
Op4498:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44a0] neg.l -(a0) uses Op44a0 ----------
Op44a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44a8] neg.l ($3333,a0) uses Op44a8 ----------
Op44a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44b0] neg.l ($33,a0,d3.w*2) uses Op44b0 ----------
Op44b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44b8] neg.l $3333.w uses Op44b8 ----------
Op44b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44b9] neg.l $33333333.l uses Op44b9 ----------
Op44b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44c0] move d0, ccr uses Op44c0 ----------
Op44c0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r0:
  ldr r0,[r7,r0,lsl #2]

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44d0] move (a0), ccr uses Op44d0 ----------
Op44d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44d8] move (a0)+, ccr uses Op44d8 ----------
Op44d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44e0] move -(a0), ccr uses Op44e0 ----------
Op44e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44e8] move ($3333,a0), ccr uses Op44e8 ----------
Op44e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44f0] move ($33,a0,d3.w*2), ccr uses Op44f0 ----------
Op44f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44f8] move $3333.w, ccr uses Op44f8 ----------
Op44f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44f9] move $33333333.l, ccr uses Op44f9 ----------
Op44f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44fa] move ($3333,pc), ccr; =3335 uses Op44fa ----------
Op44fa:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44fb] move ($33,pc,d3.w*2), ccr; =35 uses Op44fb ----------
Op44fb:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44fc] move #$3333, ccr uses Op44fc ----------
Op44fc:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r0:

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4600] not.b d0 uses Op4600 ----------
Op4600:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

;@ Not:
  mov r0,r0,asl #24
  mvn r1,r0,asr #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r10]:
  strb r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4610] not.b (a0) uses Op4610 ----------
Op4610:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Not:
  mov r0,r0,asl #24
  mvn r1,r0,asr #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4618] not.b (a0)+ uses Op4618 ----------
Op4618:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Not:
  mov r0,r0,asl #24
  mvn r1,r0,asr #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [461f] not.b (a7)+ uses Op461f ----------
Op461f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Not:
  mov r0,r0,asl #24
  mvn r1,r0,asr #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4620] not.b -(a0) uses Op4620 ----------
Op4620:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#1 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Not:
  mov r0,r0,asl #24
  mvn r1,r0,asr #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4627] not.b -(a7) uses Op4627 ----------
Op4627:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Not:
  mov r0,r0,asl #24
  mvn r1,r0,asr #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4628] not.b ($3333,a0) uses Op4628 ----------
Op4628:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Not:
  mov r0,r0,asl #24
  mvn r1,r0,asr #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4630] not.b ($33,a0,d3.w*2) uses Op4630 ----------
Op4630:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Not:
  mov r0,r0,asl #24
  mvn r1,r0,asr #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4638] not.b $3333.w uses Op4638 ----------
Op4638:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Not:
  mov r0,r0,asl #24
  mvn r1,r0,asr #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4639] not.b $33333333.l uses Op4639 ----------
Op4639:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

;@ Not:
  mov r0,r0,asl #24
  mvn r1,r0,asr #24
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4640] not.w d0 uses Op4640 ----------
Op4640:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10]

;@ Not:
  mov r0,r0,asl #16
  mvn r1,r0,asr #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r10]:
  strh r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4650] not.w (a0) uses Op4650 ----------
Op4650:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Not:
  mov r0,r0,asl #16
  mvn r1,r0,asr #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4658] not.w (a0)+ uses Op4658 ----------
Op4658:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Not:
  mov r0,r0,asl #16
  mvn r1,r0,asr #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4660] not.w -(a0) uses Op4660 ----------
Op4660:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Not:
  mov r0,r0,asl #16
  mvn r1,r0,asr #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4668] not.w ($3333,a0) uses Op4668 ----------
Op4668:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Not:
  mov r0,r0,asl #16
  mvn r1,r0,asr #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4670] not.w ($33,a0,d3.w*2) uses Op4670 ----------
Op4670:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Not:
  mov r0,r0,asl #16
  mvn r1,r0,asr #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4678] not.w $3333.w uses Op4678 ----------
Op4678:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Not:
  mov r0,r0,asl #16
  mvn r1,r0,asr #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4679] not.w $33333333.l uses Op4679 ----------
Op4679:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

;@ Not:
  mov r0,r0,asl #16
  mvn r1,r0,asr #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4680] not.l d0 uses Op4680 ----------
Op4680:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#6 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4690] not.l (a0) uses Op4690 ----------
Op4690:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4698] not.l (a0)+ uses Op4698 ----------
Op4698:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46a0] not.l -(a0) uses Op46a0 ----------
Op46a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46a8] not.l ($3333,a0) uses Op46a8 ----------
Op46a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46b0] not.l ($33,a0,d3.w*2) uses Op46b0 ----------
Op46b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46b8] not.l $3333.w uses Op46b8 ----------
Op46b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46b9] not.l $33333333.l uses Op46b9 ----------
Op46b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46c0] move d0, sr uses Op46c0 ----------
Op46c0:
  ldr r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r0:
  ldr r0,[r7,r0,lsl #2]

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r1,r0,ror #8
  and r1,r1,#0xa7 ;@ only take defined bits
  strb r1,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  eor r0,r1,r11
  tst r0,#0x20
  beq no_sp_swap46c0
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r0, [r7,#0x48] ;@ Get OSP
  str r11,[r7,#0x48]
  str r0, [r7,#0x3C]
no_sp_swap46c0:
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  ldr r1,[r7,#0x44]
  subs r5,r5,#12 ;@ Subtract cycles
;@ CheckTrace:
  tst r1,#0x80
  bne CycloneDoTraceWithChecks
  cmp r5,#0
  blt CycloneEnd
;@ CheckInterrupt:
  movs r0,r1,lsr #24 ;@ Get IRQ level
  ldreq pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  cmp r0,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  ldrle pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  b CycloneDoInterruptGoBack

;@ ---------- [46d0] move (a0), sr uses Op46d0 ----------
Op46d0:
  ldr r11,[r7,#0x44] ;@ Get SR high
  str r5,[r7,#0x5c] ;@ Save Cycles
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r1,r0,ror #8
  and r1,r1,#0xa7 ;@ only take defined bits
  strb r1,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  eor r0,r1,r11
  tst r0,#0x20
  beq no_sp_swap46d0
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r0, [r7,#0x48] ;@ Get OSP
  str r11,[r7,#0x48]
  str r0, [r7,#0x3C]
no_sp_swap46d0:
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  ldr r1,[r7,#0x44]
  subs r5,r5,#16 ;@ Subtract cycles
;@ CheckTrace:
  tst r1,#0x80
  bne CycloneDoTraceWithChecks
  cmp r5,#0
  blt CycloneEnd
;@ CheckInterrupt:
  movs r0,r1,lsr #24 ;@ Get IRQ level
  ldreq pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  cmp r0,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  ldrle pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  b CycloneDoInterruptGoBack

;@ ---------- [46d8] move (a0)+, sr uses Op46d8 ----------
Op46d8:
  ldr r11,[r7,#0x44] ;@ Get SR high
  str r5,[r7,#0x5c] ;@ Save Cycles
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r1,r0,ror #8
  and r1,r1,#0xa7 ;@ only take defined bits
  strb r1,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  eor r0,r1,r11
  tst r0,#0x20
  beq no_sp_swap46d8
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r0, [r7,#0x48] ;@ Get OSP
  str r11,[r7,#0x48]
  str r0, [r7,#0x3C]
no_sp_swap46d8:
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  ldr r1,[r7,#0x44]
  subs r5,r5,#16 ;@ Subtract cycles
;@ CheckTrace:
  tst r1,#0x80
  bne CycloneDoTraceWithChecks
  cmp r5,#0
  blt CycloneEnd
;@ CheckInterrupt:
  movs r0,r1,lsr #24 ;@ Get IRQ level
  ldreq pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  cmp r0,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  ldrle pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  b CycloneDoInterruptGoBack

;@ ---------- [46e0] move -(a0), sr uses Op46e0 ----------
Op46e0:
  ldr r11,[r7,#0x44] ;@ Get SR high
  str r5,[r7,#0x5c] ;@ Save Cycles
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r1,r0,ror #8
  and r1,r1,#0xa7 ;@ only take defined bits
  strb r1,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  eor r0,r1,r11
  tst r0,#0x20
  beq no_sp_swap46e0
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r0, [r7,#0x48] ;@ Get OSP
  str r11,[r7,#0x48]
  str r0, [r7,#0x3C]
no_sp_swap46e0:
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  ldr r1,[r7,#0x44]
  subs r5,r5,#18 ;@ Subtract cycles
;@ CheckTrace:
  tst r1,#0x80
  bne CycloneDoTraceWithChecks
  cmp r5,#0
  blt CycloneEnd
;@ CheckInterrupt:
  movs r0,r1,lsr #24 ;@ Get IRQ level
  ldreq pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  cmp r0,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  ldrle pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  b CycloneDoInterruptGoBack

;@ ---------- [46e8] move ($3333,a0), sr uses Op46e8 ----------
Op46e8:
  ldr r11,[r7,#0x44] ;@ Get SR high
  str r5,[r7,#0x5c] ;@ Save Cycles
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r1,r0,ror #8
  and r1,r1,#0xa7 ;@ only take defined bits
  strb r1,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  eor r0,r1,r11
  tst r0,#0x20
  beq no_sp_swap46e8
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r0, [r7,#0x48] ;@ Get OSP
  str r11,[r7,#0x48]
  str r0, [r7,#0x3C]
no_sp_swap46e8:
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  ldr r1,[r7,#0x44]
  subs r5,r5,#20 ;@ Subtract cycles
;@ CheckTrace:
  tst r1,#0x80
  bne CycloneDoTraceWithChecks
  cmp r5,#0
  blt CycloneEnd
;@ CheckInterrupt:
  movs r0,r1,lsr #24 ;@ Get IRQ level
  ldreq pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  cmp r0,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  ldrle pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  b CycloneDoInterruptGoBack

;@ ---------- [46f0] move ($33,a0,d3.w*2), sr uses Op46f0 ----------
Op46f0:
  ldr r11,[r7,#0x44] ;@ Get SR high
  str r5,[r7,#0x5c] ;@ Save Cycles
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r1,r0,ror #8
  and r1,r1,#0xa7 ;@ only take defined bits
  strb r1,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  eor r0,r1,r11
  tst r0,#0x20
  beq no_sp_swap46f0
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r0, [r7,#0x48] ;@ Get OSP
  str r11,[r7,#0x48]
  str r0, [r7,#0x3C]
no_sp_swap46f0:
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  ldr r1,[r7,#0x44]
  subs r5,r5,#22 ;@ Subtract cycles
;@ CheckTrace:
  tst r1,#0x80
  bne CycloneDoTraceWithChecks
  cmp r5,#0
  blt CycloneEnd
;@ CheckInterrupt:
  movs r0,r1,lsr #24 ;@ Get IRQ level
  ldreq pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  cmp r0,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  ldrle pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  b CycloneDoInterruptGoBack

;@ ---------- [46f8] move $3333.w, sr uses Op46f8 ----------
Op46f8:
  ldr r11,[r7,#0x44] ;@ Get SR high
  str r5,[r7,#0x5c] ;@ Save Cycles
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r1,r0,ror #8
  and r1,r1,#0xa7 ;@ only take defined bits
  strb r1,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  eor r0,r1,r11
  tst r0,#0x20
  beq no_sp_swap46f8
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r0, [r7,#0x48] ;@ Get OSP
  str r11,[r7,#0x48]
  str r0, [r7,#0x3C]
no_sp_swap46f8:
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  ldr r1,[r7,#0x44]
  subs r5,r5,#20 ;@ Subtract cycles
;@ CheckTrace:
  tst r1,#0x80
  bne CycloneDoTraceWithChecks
  cmp r5,#0
  blt CycloneEnd
;@ CheckInterrupt:
  movs r0,r1,lsr #24 ;@ Get IRQ level
  ldreq pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  cmp r0,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  ldrle pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  b CycloneDoInterruptGoBack

;@ ---------- [46f9] move $33333333.l, sr uses Op46f9 ----------
Op46f9:
  ldr r11,[r7,#0x44] ;@ Get SR high
  str r5,[r7,#0x5c] ;@ Save Cycles
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r1,r0,ror #8
  and r1,r1,#0xa7 ;@ only take defined bits
  strb r1,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  eor r0,r1,r11
  tst r0,#0x20
  beq no_sp_swap46f9
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r0, [r7,#0x48] ;@ Get OSP
  str r11,[r7,#0x48]
  str r0, [r7,#0x3C]
no_sp_swap46f9:
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  ldr r1,[r7,#0x44]
  subs r5,r5,#24 ;@ Subtract cycles
;@ CheckTrace:
  tst r1,#0x80
  bne CycloneDoTraceWithChecks
  cmp r5,#0
  blt CycloneEnd
;@ CheckInterrupt:
  movs r0,r1,lsr #24 ;@ Get IRQ level
  ldreq pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  cmp r0,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  ldrle pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  b CycloneDoInterruptGoBack

;@ ---------- [46fa] move ($3333,pc), sr; =3335 uses Op46fa ----------
Op46fa:
  ldr r11,[r7,#0x44] ;@ Get SR high
  str r5,[r7,#0x5c] ;@ Save Cycles
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r1,r0,ror #8
  and r1,r1,#0xa7 ;@ only take defined bits
  strb r1,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  eor r0,r1,r11
  tst r0,#0x20
  beq no_sp_swap46fa
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r0, [r7,#0x48] ;@ Get OSP
  str r11,[r7,#0x48]
  str r0, [r7,#0x3C]
no_sp_swap46fa:
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  ldr r1,[r7,#0x44]
  subs r5,r5,#20 ;@ Subtract cycles
;@ CheckTrace:
  tst r1,#0x80
  bne CycloneDoTraceWithChecks
  cmp r5,#0
  blt CycloneEnd
;@ CheckInterrupt:
  movs r0,r1,lsr #24 ;@ Get IRQ level
  ldreq pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  cmp r0,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  ldrle pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  b CycloneDoInterruptGoBack

;@ ---------- [46fb] move ($33,pc,d3.w*2), sr; =35 uses Op46fb ----------
Op46fb:
  ldr r11,[r7,#0x44] ;@ Get SR high
  str r5,[r7,#0x5c] ;@ Save Cycles
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r1,r0,ror #8
  and r1,r1,#0xa7 ;@ only take defined bits
  strb r1,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  eor r0,r1,r11
  tst r0,#0x20
  beq no_sp_swap46fb
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r0, [r7,#0x48] ;@ Get OSP
  str r11,[r7,#0x48]
  str r0, [r7,#0x3C]
no_sp_swap46fb:
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  ldr r1,[r7,#0x44]
  subs r5,r5,#22 ;@ Subtract cycles
;@ CheckTrace:
  tst r1,#0x80
  bne CycloneDoTraceWithChecks
  cmp r5,#0
  blt CycloneEnd
;@ CheckInterrupt:
  movs r0,r1,lsr #24 ;@ Get IRQ level
  ldreq pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  cmp r0,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  ldrle pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  b CycloneDoInterruptGoBack

;@ ---------- [46fc] move #$3333, sr uses Op46fc ----------
Op46fc:
  ldr r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r0:

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r1,r0,ror #8
  and r1,r1,#0xa7 ;@ only take defined bits
  strb r1,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  eor r0,r1,r11
  tst r0,#0x20
  beq no_sp_swap46fc
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r0, [r7,#0x48] ;@ Get OSP
  str r11,[r7,#0x48]
  str r0, [r7,#0x3C]
no_sp_swap46fc:
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  ldr r1,[r7,#0x44]
  subs r5,r5,#16 ;@ Subtract cycles
;@ CheckTrace:
  tst r1,#0x80
  bne CycloneDoTraceWithChecks
  cmp r5,#0
  blt CycloneEnd
;@ CheckInterrupt:
  movs r0,r1,lsr #24 ;@ Get IRQ level
  ldreq pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  cmp r0,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  ldrle pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  b CycloneDoInterruptGoBack

;@ ---------- [4800] nbcd d0 uses Op4800 ----------
Op4800:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  ldr r2,[r7,#0x4c]
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  mov r0,r0,asl #24
  and r2,r2,#0x20000000
  add r2,r0,r2,lsr #5 ;@ add X
  rsb r11,r2,#0x9a000000 ;@ do arithmetic
  cmp r11,#0x9a000000
  beq finish4800

  mvn r3,r11,lsr #31 ;@ Undefined V behavior
  and r2,r11,#0x0f000000
  cmp r2,#0x0a000000
  andeq r11,r11,#0xf0000000
  addeq r11,r11,#0x10000000
  and r3,r3,r11,lsr #31 ;@ Undefined V behavior part II
  movs r1,r11,asr #24
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,r3,lsl #28 ;@ save V
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: r1 into register[r10]:
  strb r1,[r7,r10,lsl #2]

finish4800:
  tst r11,r11
  orrmi r9,r9,#0x80000000 ;@ N
  str r9,[r7,#0x4c] ;@ Save X

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#6 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4810] nbcd (a0) uses Op4810 ----------
Op4810:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  ldr r2,[r7,#0x4c]
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  mov r0,r0,asl #24
  and r2,r2,#0x20000000
  add r2,r0,r2,lsr #5 ;@ add X
  rsb r11,r2,#0x9a000000 ;@ do arithmetic
  cmp r11,#0x9a000000
  beq finish4810

  mvn r3,r11,lsr #31 ;@ Undefined V behavior
  and r2,r11,#0x0f000000
  cmp r2,#0x0a000000
  andeq r11,r11,#0xf0000000
  addeq r11,r11,#0x10000000
  and r3,r3,r11,lsr #31 ;@ Undefined V behavior part II
  movs r1,r11,asr #24
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,r3,lsl #28 ;@ save V
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish4810:
  tst r11,r11
  orrmi r9,r9,#0x80000000 ;@ N
  str r9,[r7,#0x4c] ;@ Save X

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4818] nbcd (a0)+ uses Op4818 ----------
Op4818:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  ldr r2,[r7,#0x4c]
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  mov r0,r0,asl #24
  and r2,r2,#0x20000000
  add r2,r0,r2,lsr #5 ;@ add X
  rsb r11,r2,#0x9a000000 ;@ do arithmetic
  cmp r11,#0x9a000000
  beq finish4818

  mvn r3,r11,lsr #31 ;@ Undefined V behavior
  and r2,r11,#0x0f000000
  cmp r2,#0x0a000000
  andeq r11,r11,#0xf0000000
  addeq r11,r11,#0x10000000
  and r3,r3,r11,lsr #31 ;@ Undefined V behavior part II
  movs r1,r11,asr #24
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,r3,lsl #28 ;@ save V
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish4818:
  tst r11,r11
  orrmi r9,r9,#0x80000000 ;@ N
  str r9,[r7,#0x4c] ;@ Save X

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [481f] nbcd (a7)+ uses Op481f ----------
Op481f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  ldr r2,[r7,#0x4c]
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  mov r0,r0,asl #24
  and r2,r2,#0x20000000
  add r2,r0,r2,lsr #5 ;@ add X
  rsb r11,r2,#0x9a000000 ;@ do arithmetic
  cmp r11,#0x9a000000
  beq finish481f

  mvn r3,r11,lsr #31 ;@ Undefined V behavior
  and r2,r11,#0x0f000000
  cmp r2,#0x0a000000
  andeq r11,r11,#0xf0000000
  addeq r11,r11,#0x10000000
  and r3,r3,r11,lsr #31 ;@ Undefined V behavior part II
  movs r1,r11,asr #24
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,r3,lsl #28 ;@ save V
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish481f:
  tst r11,r11
  orrmi r9,r9,#0x80000000 ;@ N
  str r9,[r7,#0x4c] ;@ Save X

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4820] nbcd -(a0) uses Op4820 ----------
Op4820:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#1 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  ldr r2,[r7,#0x4c]
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  mov r0,r0,asl #24
  and r2,r2,#0x20000000
  add r2,r0,r2,lsr #5 ;@ add X
  rsb r11,r2,#0x9a000000 ;@ do arithmetic
  cmp r11,#0x9a000000
  beq finish4820

  mvn r3,r11,lsr #31 ;@ Undefined V behavior
  and r2,r11,#0x0f000000
  cmp r2,#0x0a000000
  andeq r11,r11,#0xf0000000
  addeq r11,r11,#0x10000000
  and r3,r3,r11,lsr #31 ;@ Undefined V behavior part II
  movs r1,r11,asr #24
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,r3,lsl #28 ;@ save V
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish4820:
  tst r11,r11
  orrmi r9,r9,#0x80000000 ;@ N
  str r9,[r7,#0x4c] ;@ Save X

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4827] nbcd -(a7) uses Op4827 ----------
Op4827:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  ldr r2,[r7,#0x4c]
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  mov r0,r0,asl #24
  and r2,r2,#0x20000000
  add r2,r0,r2,lsr #5 ;@ add X
  rsb r11,r2,#0x9a000000 ;@ do arithmetic
  cmp r11,#0x9a000000
  beq finish4827

  mvn r3,r11,lsr #31 ;@ Undefined V behavior
  and r2,r11,#0x0f000000
  cmp r2,#0x0a000000
  andeq r11,r11,#0xf0000000
  addeq r11,r11,#0x10000000
  and r3,r3,r11,lsr #31 ;@ Undefined V behavior part II
  movs r1,r11,asr #24
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,r3,lsl #28 ;@ save V
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish4827:
  tst r11,r11
  orrmi r9,r9,#0x80000000 ;@ N
  str r9,[r7,#0x4c] ;@ Save X

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4828] nbcd ($3333,a0) uses Op4828 ----------
Op4828:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  ldr r2,[r7,#0x4c]
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  mov r0,r0,asl #24
  and r2,r2,#0x20000000
  add r2,r0,r2,lsr #5 ;@ add X
  rsb r11,r2,#0x9a000000 ;@ do arithmetic
  cmp r11,#0x9a000000
  beq finish4828

  mvn r3,r11,lsr #31 ;@ Undefined V behavior
  and r2,r11,#0x0f000000
  cmp r2,#0x0a000000
  andeq r11,r11,#0xf0000000
  addeq r11,r11,#0x10000000
  and r3,r3,r11,lsr #31 ;@ Undefined V behavior part II
  movs r1,r11,asr #24
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,r3,lsl #28 ;@ save V
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish4828:
  tst r11,r11
  orrmi r9,r9,#0x80000000 ;@ N
  str r9,[r7,#0x4c] ;@ Save X

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4830] nbcd ($33,a0,d3.w*2) uses Op4830 ----------
Op4830:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  ldr r2,[r7,#0x4c]
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  mov r0,r0,asl #24
  and r2,r2,#0x20000000
  add r2,r0,r2,lsr #5 ;@ add X
  rsb r11,r2,#0x9a000000 ;@ do arithmetic
  cmp r11,#0x9a000000
  beq finish4830

  mvn r3,r11,lsr #31 ;@ Undefined V behavior
  and r2,r11,#0x0f000000
  cmp r2,#0x0a000000
  andeq r11,r11,#0xf0000000
  addeq r11,r11,#0x10000000
  and r3,r3,r11,lsr #31 ;@ Undefined V behavior part II
  movs r1,r11,asr #24
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,r3,lsl #28 ;@ save V
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish4830:
  tst r11,r11
  orrmi r9,r9,#0x80000000 ;@ N
  str r9,[r7,#0x4c] ;@ Save X

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4838] nbcd $3333.w uses Op4838 ----------
Op4838:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  ldr r2,[r7,#0x4c]
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  mov r0,r0,asl #24
  and r2,r2,#0x20000000
  add r2,r0,r2,lsr #5 ;@ add X
  rsb r11,r2,#0x9a000000 ;@ do arithmetic
  cmp r11,#0x9a000000
  beq finish4838

  mvn r3,r11,lsr #31 ;@ Undefined V behavior
  and r2,r11,#0x0f000000
  cmp r2,#0x0a000000
  andeq r11,r11,#0xf0000000
  addeq r11,r11,#0x10000000
  and r3,r3,r11,lsr #31 ;@ Undefined V behavior part II
  movs r1,r11,asr #24
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,r3,lsl #28 ;@ save V
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish4838:
  tst r11,r11
  orrmi r9,r9,#0x80000000 ;@ N
  str r9,[r7,#0x4c] ;@ Save X

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4839] nbcd $33333333.l uses Op4839 ----------
Op4839:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  ldr r2,[r7,#0x4c]
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  mov r0,r0,asl #24
  and r2,r2,#0x20000000
  add r2,r0,r2,lsr #5 ;@ add X
  rsb r11,r2,#0x9a000000 ;@ do arithmetic
  cmp r11,#0x9a000000
  beq finish4839

  mvn r3,r11,lsr #31 ;@ Undefined V behavior
  and r2,r11,#0x0f000000
  cmp r2,#0x0a000000
  andeq r11,r11,#0xf0000000
  addeq r11,r11,#0x10000000
  and r3,r3,r11,lsr #31 ;@ Undefined V behavior part II
  movs r1,r11,asr #24
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,r3,lsl #28 ;@ save V
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish4839:
  tst r11,r11
  orrmi r9,r9,#0x80000000 ;@ N
  str r9,[r7,#0x4c] ;@ Save X

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4840] swap d0 uses Op4840 ----------
Op4840:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0007
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  mov r1,r0,ror #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4850] pea (a0) uses Op4850 ----------
Op4850:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r10,[r7,#0x3c]
;@ EaCalc : Get '(a0)' into r1:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r1,[r7,r2,lsl #2]

  sub r0,r10,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7

  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4868] pea ($3333,a0) uses Op4868 ----------
Op4868:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r10,[r7,#0x3c]
;@ EaCalc : Get '($3333,a0)' into r1:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r1,r0,r2 ;@ Add on offset

  sub r0,r10,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7

  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4870] pea ($33,a0,d3.w*2) uses Op4870 ----------
Op4870:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r10,[r7,#0x3c]
;@ EaCalc : Get '($33,a0,d3.w*2)' into r1:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r1,r2,r3 ;@ r1=Disp+An+Rn

  sub r0,r10,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7

  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4878] pea $3333.w uses Op4878 ----------
Op4878:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r10,[r7,#0x3c]
;@ EaCalc : Get '$3333.w' into r1:
  ldrsh r1,[r4],#2 ;@ Fetch Absolute Short address

  sub r0,r10,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7

  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4879] pea $33333333.l uses Op4879 ----------
Op4879:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r10,[r7,#0x3c]
;@ EaCalc : Get '$33333333.l' into r1:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r1,r0,r2,lsl #16

  sub r0,r10,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7

  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [487a] pea ($3333,pc); =3335 uses Op487a ----------
Op487a:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r10,[r7,#0x3c]
;@ EaCalc : Get '($3333,pc)' into r1:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r1,r2,r0,asr #8 ;@ ($nn,PC)

  sub r0,r10,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7

  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [487b] pea ($33,pc,d3.w*2); =35 uses Op487b ----------
Op487b:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r10,[r7,#0x3c]
;@ EaCalc : Get '($33,pc,d3.w*2)' into r1:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r1,r2,r0,asr #8 ;@ r1=Disp+PC+Rn

  sub r0,r10,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7

  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4880] ext.w d0 uses Op4880 ----------
Op4880:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0007
  mov r10,r10,lsl #2
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10]

  mov r0,r0,asl #24
  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
  mov r1,r0,asr #24

;@ EaWrite: r1 into register[r10]:
  strh r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4890] movem.w d0-d1/d4-d5/a0-a1/a4-a5, (a0) uses Op4890 ----------
Op4890:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '(a0)' into r6:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r6,[r7,r2,lsl #2]

  tst r11,r11
  beq NoRegs4890

Movemloop4890:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4890

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '(a0)' (address in r6):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  add r6,r6,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4890

NoRegs4890:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [48a0] movem.w d2-d3/d6-d7/a2-a3/a6-a7, -(a0) uses Op48a0 ----------
Op48a0:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#0x40 ;@ order reversed for -(An)

;@ Get the address into r6:
;@ EaCalc : Get '(a0)' into r6:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r6,[r7,r2,lsl #2]

  tst r11,r11
  beq NoRegs48a0

Movemloop48a0:
  add r10,r10,#-4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop48a0

  sub r6,r6,#2 ;@ Pre-decrement address
  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '-(a0)' (address in r6):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  sub r5,r5,#4 ;@ Take some cycles
  tst r11,r11
  bne Movemloop48a0

;@ Write back address:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0007
  orr r0,r0,#0x8 ;@ A0-7
;@ EaWrite: r6 into register[r0]:
  str r6,[r7,r0,lsl #2]

NoRegs48a0:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [48a8] movem.w d0-d1/d4-d5/a0-a1/a4-a5, ($3333,a0) uses Op48a8 ----------
Op48a8:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '($3333,a0)' into r6:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r6,r0,r2 ;@ Add on offset

  tst r11,r11
  beq NoRegs48a8

Movemloop48a8:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop48a8

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '($3333,a0)' (address in r6):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  add r6,r6,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles
  tst r11,r11
  bne Movemloop48a8

NoRegs48a8:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [48b0] movem.w d0-d1/d4-d5/a0-a1/a4-a5, ($33,a0,d3.w*2) uses Op48b0 ----------
Op48b0:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r6:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r6,r2,r3 ;@ r6=Disp+An+Rn

  tst r11,r11
  beq NoRegs48b0

Movemloop48b0:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop48b0

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r6):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  add r6,r6,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles
  tst r11,r11
  bne Movemloop48b0

NoRegs48b0:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [48b8] movem.w d0-d1/d4-d5/a0-a1/a4-a5, $3333.w uses Op48b8 ----------
Op48b8:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '$3333.w' into r6:
  ldrsh r6,[r4],#2 ;@ Fetch Absolute Short address

  tst r11,r11
  beq NoRegs48b8

Movemloop48b8:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop48b8

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '$3333.w' (address in r6):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  add r6,r6,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles
  tst r11,r11
  bne Movemloop48b8

NoRegs48b8:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [48b9] movem.w d0-d1/d4-d5/a0-a1/a4-a5, $33333333.l uses Op48b9 ----------
Op48b9:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '$33333333.l' into r6:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r6,r0,r2,lsl #16

  tst r11,r11
  beq NoRegs48b9

Movemloop48b9:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop48b9

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '$33333333.l' (address in r6):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  add r6,r6,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles
  tst r11,r11
  bne Movemloop48b9

NoRegs48b9:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [48c0] ext.l d0 uses Op48c0 ----------
Op48c0:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0007
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  mov r0,r0,asl #16
  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
  mov r1,r0,asr #16

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [48d0] movem.l d0-d1/d4-d5/a0-a1/a4-a5, (a0) uses Op48d0 ----------
Op48d0:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '(a0)' into r6:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r6,[r7,r2,lsl #2]

  tst r11,r11
  beq NoRegs48d0

Movemloop48d0:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop48d0

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '(a0)' (address in r6):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  add r6,r6,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles
  tst r11,r11
  bne Movemloop48d0

NoRegs48d0:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [48e0] movem.l d2-d3/d6-d7/a2-a3/a6-a7, -(a0) uses Op48e0 ----------
Op48e0:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#0x40 ;@ order reversed for -(An)

;@ Get the address into r6:
;@ EaCalc : Get '(a0)' into r6:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r6,[r7,r2,lsl #2]

  tst r11,r11
  beq NoRegs48e0

Movemloop48e0:
  add r10,r10,#-4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop48e0

  sub r6,r6,#4 ;@ Pre-decrement address
  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '-(a0)' (address in r6):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  sub r5,r5,#8 ;@ Take some cycles
  tst r11,r11
  bne Movemloop48e0

;@ Write back address:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0007
  orr r0,r0,#0x8 ;@ A0-7
;@ EaWrite: r6 into register[r0]:
  str r6,[r7,r0,lsl #2]

NoRegs48e0:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [48e8] movem.l d0-d1/d4-d5/a0-a1/a4-a5, ($3333,a0) uses Op48e8 ----------
Op48e8:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '($3333,a0)' into r6:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r6,r0,r2 ;@ Add on offset

  tst r11,r11
  beq NoRegs48e8

Movemloop48e8:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop48e8

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '($3333,a0)' (address in r6):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  add r6,r6,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles
  tst r11,r11
  bne Movemloop48e8

NoRegs48e8:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [48f0] movem.l d0-d1/d4-d5/a0-a1/a4-a5, ($33,a0,d3.w*2) uses Op48f0 ----------
Op48f0:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r6:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r6,r2,r3 ;@ r6=Disp+An+Rn

  tst r11,r11
  beq NoRegs48f0

Movemloop48f0:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop48f0

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r6):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  add r6,r6,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles
  tst r11,r11
  bne Movemloop48f0

NoRegs48f0:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [48f8] movem.l d0-d1/d4-d5/a0-a1/a4-a5, $3333.w uses Op48f8 ----------
Op48f8:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '$3333.w' into r6:
  ldrsh r6,[r4],#2 ;@ Fetch Absolute Short address

  tst r11,r11
  beq NoRegs48f8

Movemloop48f8:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop48f8

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '$3333.w' (address in r6):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  add r6,r6,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles
  tst r11,r11
  bne Movemloop48f8

NoRegs48f8:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [48f9] movem.l d0-d1/d4-d5/a0-a1/a4-a5, $33333333.l uses Op48f9 ----------
Op48f9:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '$33333333.l' into r6:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r6,r0,r2,lsl #16

  tst r11,r11
  beq NoRegs48f9

Movemloop48f9:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop48f9

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '$33333333.l' (address in r6):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  add r6,r6,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles
  tst r11,r11
  bne Movemloop48f9

NoRegs48f9:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4a00] tst.b d0 uses Op4a00 ----------
Op4a00:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r0:
  ldr r0,[r7,r0,lsl #2]
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a10] tst.b (a0) uses Op4a10 ----------
Op4a10:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a18] tst.b (a0)+ uses Op4a18 ----------
Op4a18:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a1f] tst.b (a7)+ uses Op4a1f ----------
Op4a1f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a20] tst.b -(a0) uses Op4a20 ----------
Op4a20:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a27] tst.b -(a7) uses Op4a27 ----------
Op4a27:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a28] tst.b ($3333,a0) uses Op4a28 ----------
Op4a28:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a30] tst.b ($33,a0,d3.w*2) uses Op4a30 ----------
Op4a30:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a38] tst.b $3333.w uses Op4a38 ----------
Op4a38:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a39] tst.b $33333333.l uses Op4a39 ----------
Op4a39:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a40] tst.w d0 uses Op4a40 ----------
Op4a40:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r0:
  ldr r0,[r7,r0]
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a50] tst.w (a0) uses Op4a50 ----------
Op4a50:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a58] tst.w (a0)+ uses Op4a58 ----------
Op4a58:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a60] tst.w -(a0) uses Op4a60 ----------
Op4a60:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a68] tst.w ($3333,a0) uses Op4a68 ----------
Op4a68:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a70] tst.w ($33,a0,d3.w*2) uses Op4a70 ----------
Op4a70:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a78] tst.w $3333.w uses Op4a78 ----------
Op4a78:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a79] tst.w $33333333.l uses Op4a79 ----------
Op4a79:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a80] tst.l d0 uses Op4a80 ----------
Op4a80:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r0:
  ldr r0,[r7,r0,lsl #2]

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a90] tst.l (a0) uses Op4a90 ----------
Op4a90:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a98] tst.l (a0)+ uses Op4a98 ----------
Op4a98:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4aa0] tst.l -(a0) uses Op4aa0 ----------
Op4aa0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4aa8] tst.l ($3333,a0) uses Op4aa8 ----------
Op4aa8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ab0] tst.l ($33,a0,d3.w*2) uses Op4ab0 ----------
Op4ab0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ab8] tst.l $3333.w uses Op4ab8 ----------
Op4ab8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ab9] tst.l $33333333.l uses Op4ab9 ----------
Op4ab9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ac0] tas d0 uses Op4ac0 ----------
Op4ac0:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r1:
  ldr r1,[r7,r10,lsl #2]
  mov r1,r1,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: r1 into register[r10]:
  mov r1,r1,asr #24
  strb r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ad0] tas (a0) uses Op4ad0 ----------
Op4ad0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ad8] tas (a0)+ uses Op4ad8 ----------
Op4ad8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4adf] tas (a7)+ uses Op4adf ----------
Op4adf:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r10) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ae0] tas -(a0) uses Op4ae0 ----------
Op4ae0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#1 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ae7] tas -(a7) uses Op4ae7 ----------
Op4ae7:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r10) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ae8] tas ($3333,a0) uses Op4ae8 ----------
Op4ae8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4af0] tas ($33,a0,d3.w*2) uses Op4af0 ----------
Op4af0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4af8] tas $3333.w uses Op4af8 ----------
Op4af8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4af9] tas $33333333.l uses Op4af9 ----------
Op4af9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r1:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4c90] movem.w (a0), d0-d1/d4-d5/a0-a1/a4-a5 uses Op4c90 ----------
Op4c90:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '(a0)' into r6:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r6,[r7,r2,lsl #2]

  tst r11,r11
  beq NoRegs4c90

Movemloop4c90:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4c90

  ;@ Copy memory to register:
;@ EaRead : Read '(a0)' (address in r6) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r6,r6,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4c90

NoRegs4c90:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4c98] movem.w (a0)+, d0-d1/d4-d5/a0-a1/a4-a5 uses Op4c98 ----------
Op4c98:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '(a0)' into r6:
  and r2,r8,#0x000f
  ldr r6,[r7,r2,lsl #2]

  tst r11,r11
  beq NoRegs4c98

Movemloop4c98:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4c98

  ;@ Copy memory to register:
;@ EaRead : Read '(a0)+' (address in r6) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r6,r6,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4c98

;@ Write back address:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaWrite: r6 into register[r0]:
  str r6,[r7,r0,lsl #2]

NoRegs4c98:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4ca8] movem.w ($3333,a0), d0-d1/d4-d5/a0-a1/a4-a5 uses Op4ca8 ----------
Op4ca8:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '($3333,a0)' into r6:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r6,r0,r2 ;@ Add on offset

  tst r11,r11
  beq NoRegs4ca8

Movemloop4ca8:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4ca8

  ;@ Copy memory to register:
;@ EaRead : Read '($3333,a0)' (address in r6) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r6,r6,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4ca8

NoRegs4ca8:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4cb0] movem.w ($33,a0,d3.w*2), d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cb0 ----------
Op4cb0:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r6:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r6,r2,r3 ;@ r6=Disp+An+Rn

  tst r11,r11
  beq NoRegs4cb0

Movemloop4cb0:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4cb0

  ;@ Copy memory to register:
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r6) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r6,r6,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4cb0

NoRegs4cb0:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4cb8] movem.w $3333.w, d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cb8 ----------
Op4cb8:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '$3333.w' into r6:
  ldrsh r6,[r4],#2 ;@ Fetch Absolute Short address

  tst r11,r11
  beq NoRegs4cb8

Movemloop4cb8:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4cb8

  ;@ Copy memory to register:
;@ EaRead : Read '$3333.w' (address in r6) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r6,r6,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4cb8

NoRegs4cb8:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4cb9] movem.w $33333333.l, d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cb9 ----------
Op4cb9:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '$33333333.l' into r6:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r6,r0,r2,lsl #16

  tst r11,r11
  beq NoRegs4cb9

Movemloop4cb9:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4cb9

  ;@ Copy memory to register:
;@ EaRead : Read '$33333333.l' (address in r6) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r6,r6,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4cb9

NoRegs4cb9:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4cba] movem.w ($3333,pc), d0-d1/d4-d5/a0-a1/a4-a5; =3337 uses Op4cba ----------
Op4cba:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '($3333,pc)' into r6:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r6,r2,r0,asr #8 ;@ ($nn,PC)

  tst r11,r11
  beq NoRegs4cba

Movemloop4cba:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4cba

  ;@ Copy memory to register:
;@ EaRead : Read '($3333,pc)' (address in r6) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r6,r6,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4cba

NoRegs4cba:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4cbb] movem.w ($33,pc,d3.w*2), d0-d1/d4-d5/a0-a1/a4-a5; =37 uses Op4cbb ----------
Op4cbb:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r6:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r6,r2,r0,asr #8 ;@ r6=Disp+PC+Rn

  tst r11,r11
  beq NoRegs4cbb

Movemloop4cbb:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4cbb

  ;@ Copy memory to register:
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r6) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r6,r6,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4cbb

NoRegs4cbb:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4cd0] movem.l (a0), d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cd0 ----------
Op4cd0:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '(a0)' into r6:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r6,[r7,r2,lsl #2]

  tst r11,r11
  beq NoRegs4cd0

Movemloop4cd0:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4cd0

  ;@ Copy memory to register:
;@ EaRead : Read '(a0)' (address in r6) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r6,r6,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4cd0

NoRegs4cd0:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4cd8] movem.l (a0)+, d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cd8 ----------
Op4cd8:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '(a0)' into r6:
  and r2,r8,#0x000f
  ldr r6,[r7,r2,lsl #2]

  tst r11,r11
  beq NoRegs4cd8

Movemloop4cd8:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4cd8

  ;@ Copy memory to register:
;@ EaRead : Read '(a0)+' (address in r6) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r6,r6,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4cd8

;@ Write back address:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaWrite: r6 into register[r0]:
  str r6,[r7,r0,lsl #2]

NoRegs4cd8:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4ce8] movem.l ($3333,a0), d0-d1/d4-d5/a0-a1/a4-a5 uses Op4ce8 ----------
Op4ce8:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '($3333,a0)' into r6:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r6,r0,r2 ;@ Add on offset

  tst r11,r11
  beq NoRegs4ce8

Movemloop4ce8:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4ce8

  ;@ Copy memory to register:
;@ EaRead : Read '($3333,a0)' (address in r6) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r6,r6,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4ce8

NoRegs4ce8:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4cf0] movem.l ($33,a0,d3.w*2), d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cf0 ----------
Op4cf0:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r6:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r6,r2,r3 ;@ r6=Disp+An+Rn

  tst r11,r11
  beq NoRegs4cf0

Movemloop4cf0:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4cf0

  ;@ Copy memory to register:
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r6) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r6,r6,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4cf0

NoRegs4cf0:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4cf8] movem.l $3333.w, d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cf8 ----------
Op4cf8:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '$3333.w' into r6:
  ldrsh r6,[r4],#2 ;@ Fetch Absolute Short address

  tst r11,r11
  beq NoRegs4cf8

Movemloop4cf8:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4cf8

  ;@ Copy memory to register:
;@ EaRead : Read '$3333.w' (address in r6) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r6,r6,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4cf8

NoRegs4cf8:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4cf9] movem.l $33333333.l, d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cf9 ----------
Op4cf9:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '$33333333.l' into r6:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r6,r0,r2,lsl #16

  tst r11,r11
  beq NoRegs4cf9

Movemloop4cf9:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4cf9

  ;@ Copy memory to register:
;@ EaRead : Read '$33333333.l' (address in r6) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r6,r6,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4cf9

NoRegs4cf9:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4cfa] movem.l ($3333,pc), d0-d1/d4-d5/a0-a1/a4-a5; =3337 uses Op4cfa ----------
Op4cfa:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '($3333,pc)' into r6:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r6,r2,r0,asr #8 ;@ ($nn,PC)

  tst r11,r11
  beq NoRegs4cfa

Movemloop4cfa:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4cfa

  ;@ Copy memory to register:
;@ EaRead : Read '($3333,pc)' (address in r6) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r6,r6,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4cfa

NoRegs4cfa:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4cfb] movem.l ($33,pc,d3.w*2), d0-d1/d4-d5/a0-a1/a4-a5; =37 uses Op4cfb ----------
Op4cfb:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  ldrh r11,[r4],#2 ;@ r11=register mask
;@ r10=Register Index*4:
  mov r10,#-4

;@ Get the address into r6:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r6:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r6,r2,r0,asr #8 ;@ r6=Disp+PC+Rn

  tst r11,r11
  beq NoRegs4cfb

Movemloop4cfb:
  add r10,r10,#4 ;@ r10=Next Register
  movs r11,r11,lsr #1
  bcc Movemloop4cfb

  ;@ Copy memory to register:
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r6) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r6,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r6,r6,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles
  tst r11,r11
  bne Movemloop4cfb

NoRegs4cfb:
  ldr r6,=CycloneJumpTab ;@ restore Opcode Jump table

  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  .ltorg

;@ ---------- [4e40] trap #0 uses Op4e40 ----------
Op4e40:
  str r5,[r7,#0x5c] ;@ Save Cycles

  and r0,r8,#0xf ;@ Get trap number
  orr r0,r0,#0x20 ;@ 32+n
  bl Exception

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#38 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e50] link a0,#$3333 uses Op4e50 ----------
Op4e50:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ Get An
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0007
  orr r10,r10,#0x8 ;@ A0-7
;@ EaRead : Read register[r10] into r1:
  ldr r1,[r7,r10,lsl #2]

  ldr r0,[r7,#0x3c] ;@ Get A7
  sub r0,r0,#4 ;@ A7-=4
  mov r11,r0

;@ Write An to Stack
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler
;@ Save to An
;@ EaWrite: r11 into register[r10]:
  str r11,[r7,r10,lsl #2]

;@ Get offset:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r0:

  add r11,r11,r0 ;@ Add offset to A7
  str r11,[r7,#0x3c]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e57] link a7,#$3333 uses Op4e57 ----------
Op4e57:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r0,[r7,#0x3c] ;@ Get A7
  sub r0,r0,#4 ;@ A7-=4
  mov r11,r0
  mov r1,r0

;@ Write An to Stack
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler
;@ Save to An
;@ Get offset:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r0:

  add r11,r11,r0 ;@ Add offset to A7
  str r11,[r7,#0x3c]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e58] unlk a0 uses Op4e58 ----------
Op4e58:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ Get An
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  add r11,r0,#4 ;@ A7+=4

;@ Pop An from stack:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  str r11,[r7,#0x3c] ;@ Save A7

;@ An = value from stack:
;@ EaWrite: r0 into register[r10]:
  str r0,[r7,r10,lsl #2]

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e60] move a0, usp uses Op4e60 ----------
Op4e60:
  ldr r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  orr r0,r0,#0x8 ;@ A0-7
;@ EaRead : Read register[r0] into r0:
  ldr r0,[r7,r0,lsl #2]

  str r0,[r7,#0x48] ;@ Put in USP

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e68] move usp, a0 uses Op4e68 ----------
Op4e68:
  ldr r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

  ldr r1,[r7,#0x48] ;@ Get from USP

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e70] reset uses Op4e70 ----------
Op4e70:
  ldr r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#132 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e71] nop uses Op4e71 ----------
Op4e71:
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e72] stop uses Op4e72 ----------
Op4e72:
  ldr r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

  ldrh r0,[r4],#2 ;@ Fetch the immediate
  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  eor r0,r0,r11
  tst r0,#0x20
  beq no_sp_swap4e72
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r0, [r7,#0x48] ;@ Get OSP
  str r11,[r7,#0x48]
  str r0, [r7,#0x3C]
no_sp_swap4e72:

  ldr r0,[r7,#0x58]
  mov r5,#0 ;@ eat cycles
  orr r0,r0,#1 ;@ stopped
  str r0,[r7,#0x58]


  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e73] rte uses Op4e73 ----------
Op4e73:
  ldr r11,[r7,#0x44] ;@ Get SR high
  str r5,[r7,#0x5c] ;@ Save Cycles
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongPrivilegeMode ;@ No

;@ Pop SR:
  ldr r0,[r7,#0x3c]
  add r1,r0,#2 ;@ Postincrement A7
  str r1,[r7,#0x3c] ;@ Save A7
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

  ldr r10,[r7,#0x60] ;@ Get Memory base
;@ Pop PC:
  ldr r0,[r7,#0x3c]
  add r1,r0,#4 ;@ Postincrement A7
  str r1,[r7,#0x3c] ;@ Save A7
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  add r0,r0,r10 ;@ Memory Base+PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  ldr r1,[r7,#0x44] ;@ reload SR high
;@ A7 <-> OSP?
  eor r0,r1,r11
  tst r0,#0x20
  beq no_sp_swap4e73
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r0, [r7,#0x48] ;@ Get OSP
  str r11,[r7,#0x48]
  str r0, [r7,#0x3C]
no_sp_swap4e73:
  ldr r1,[r7,#0x58]
  bic r1,r1,#0x0c ;@ clear 'not processing instruction' and 'doing addr error' bits
  str r1,[r7,#0x58]
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  ldr r1,[r7,#0x44]
  subs r5,r5,#20 ;@ Subtract cycles
;@ CheckTrace:
  tst r1,#0x80
  bne CycloneDoTraceWithChecks
  cmp r5,#0
  blt CycloneEnd
;@ CheckInterrupt:
  movs r0,r1,lsr #24 ;@ Get IRQ level
  ldreq pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  cmp r0,#6 ;@ irq>6 ?
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  ldrle pc,[r6,r8,asl #2] ;@ Jump to next opcode handler
  b CycloneDoInterruptGoBack

;@ ---------- [4e75] rts uses Op4e75 ----------
Op4e75:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r10,[r7,#0x60] ;@ Get Memory base
;@ Pop PC:
  ldr r0,[r7,#0x3c]
  add r1,r0,#4 ;@ Postincrement A7
  str r1,[r7,#0x3c] ;@ Save A7
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  add r0,r0,r10 ;@ Memory Base+PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e76] trapv uses Op4e76 ----------
Op4e76:
  str r5,[r7,#0x5c] ;@ Save Cycles
  mov r5,#0

  tst r9,#0x10000000
  subne r5,r5,#34
  movne r0,#7 ;@ TRAPV exception
  blne Exception
  ldr r0,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  add r5,r0,r5
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e77] rtr uses Op4e77 ----------
Op4e77:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ Pop SR:
  ldr r0,[r7,#0x3c]
  add r1,r0,#2 ;@ Postincrement A7
  str r1,[r7,#0x3c] ;@ Save A7
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsl #25
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  str r2,[r7,#0x4c]   ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldr r10,[r7,#0x60] ;@ Get Memory base
;@ Pop PC:
  ldr r0,[r7,#0x3c]
  add r1,r0,#4 ;@ Postincrement A7
  str r1,[r7,#0x3c] ;@ Save A7
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  add r0,r0,r10 ;@ Memory Base+PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e90] jsr (a0) uses Op4e90 ----------
Op4e90:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ Jump - Get new PC from r11
  add r0,r11,r10 ;@ Memory Base + New PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  ldr r2,[r7,#0x3c]
  sub r1,r4,r10 ;@ r1 = Old PC
  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
;@ Push old PC onto stack
  sub r0,r2,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ea8] jsr ($3333,a0) uses Op4ea8 ----------
Op4ea8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ Jump - Get new PC from r11
  add r0,r11,r10 ;@ Memory Base + New PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  ldr r2,[r7,#0x3c]
  sub r1,r4,r10 ;@ r1 = Old PC
  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
;@ Push old PC onto stack
  sub r0,r2,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4eb0] jsr ($33,a0,d3.w*2) uses Op4eb0 ----------
Op4eb0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ Jump - Get new PC from r11
  add r0,r11,r10 ;@ Memory Base + New PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  ldr r2,[r7,#0x3c]
  sub r1,r4,r10 ;@ r1 = Old PC
  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
;@ Push old PC onto stack
  sub r0,r2,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4eb8] jsr $3333.w uses Op4eb8 ----------
Op4eb8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ Jump - Get new PC from r11
  add r0,r11,r10 ;@ Memory Base + New PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  ldr r2,[r7,#0x3c]
  sub r1,r4,r10 ;@ r1 = Old PC
  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
;@ Push old PC onto stack
  sub r0,r2,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4eb9] jsr $33333333.l uses Op4eb9 ----------
Op4eb9:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ Jump - Get new PC from r11
  add r0,r11,r10 ;@ Memory Base + New PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  ldr r2,[r7,#0x3c]
  sub r1,r4,r10 ;@ r1 = Old PC
  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
;@ Push old PC onto stack
  sub r0,r2,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4eba] jsr ($3333,pc); =3335 uses Op4eba ----------
Op4eba:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '($3333,pc)' into r11:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r11,r2,r0,asr #8 ;@ ($nn,PC)
;@ Jump - Get new PC from r11
  add r0,r11,r10 ;@ Memory Base + New PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  ldr r2,[r7,#0x3c]
  sub r1,r4,r10 ;@ r1 = Old PC
  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
;@ Push old PC onto stack
  sub r0,r2,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ebb] jsr ($33,pc,d3.w*2); =35 uses Op4ebb ----------
Op4ebb:
  str r5,[r7,#0x5c] ;@ Save Cycles

  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '($33,pc,d3.w*2)' into r11:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r11,r2,r0,asr #8 ;@ r11=Disp+PC+Rn
;@ Jump - Get new PC from r11
  add r0,r11,r10 ;@ Memory Base + New PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  ldr r2,[r7,#0x3c]
  sub r1,r4,r10 ;@ r1 = Old PC
  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
;@ Push old PC onto stack
  sub r0,r2,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler
  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ed0] jmp (a0) uses Op4ed0 ----------
Op4ed0:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ Jump - Get new PC from r11
  add r0,r11,r10 ;@ Memory Base + New PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ee8] jmp ($3333,a0) uses Op4ee8 ----------
Op4ee8:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '($3333,a0)' into r11:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r11,r0,r2 ;@ Add on offset
;@ Jump - Get new PC from r11
  add r0,r11,r10 ;@ Memory Base + New PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ef0] jmp ($33,a0,d3.w*2) uses Op4ef0 ----------
Op4ef0:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ Jump - Get new PC from r11
  add r0,r11,r10 ;@ Memory Base + New PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ef8] jmp $3333.w uses Op4ef8 ----------
Op4ef8:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ Jump - Get new PC from r11
  add r0,r11,r10 ;@ Memory Base + New PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ef9] jmp $33333333.l uses Op4ef9 ----------
Op4ef9:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ Jump - Get new PC from r11
  add r0,r11,r10 ;@ Memory Base + New PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4efa] jmp ($3333,pc); =3335 uses Op4efa ----------
Op4efa:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '($3333,pc)' into r11:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r11,r2,r0,asr #8 ;@ ($nn,PC)
;@ Jump - Get new PC from r11
  add r0,r11,r10 ;@ Memory Base + New PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4efb] jmp ($33,pc,d3.w*2); =35 uses Op4efb ----------
Op4efb:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '($33,pc,d3.w*2)' into r11:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  ldrh r3,[r4] ;@ Get extension word
  sub r0,r4,r0 ;@ r0=PC
  add r4,r4,#2
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r3,r3,asl #24 ;@ r3=Get 8-bit signed Disp
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  add r11,r2,r0,asr #8 ;@ r11=Disp+PC+Rn
;@ Jump - Get new PC from r11
  add r0,r11,r10 ;@ Memory Base + New PC

;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5000] addq.b #8, d0 uses Op5000 ----------
Op5000:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: r1 into register[r10]:
  mov r1,r1,asr #24
  strb r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5010] addq.b #8, (a0) uses Op5010 ----------
Op5010:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5018] addq.b #8, (a0)+ uses Op5018 ----------
Op5018:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [501f] addq.b #8, (a7)+ uses Op501f ----------
Op501f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5020] addq.b #8, -(a0) uses Op5020 ----------
Op5020:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#1 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5027] addq.b #8, -(a7) uses Op5027 ----------
Op5027:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5028] addq.b #8, ($3333,a0) uses Op5028 ----------
Op5028:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5030] addq.b #8, ($33,a0,d3.w*2) uses Op5030 ----------
Op5030:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5038] addq.b #8, $3333.w uses Op5038 ----------
Op5038:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5039] addq.b #8, $33333333.l uses Op5039 ----------
Op5039:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5040] addq.w #8, d0 uses Op5040 ----------
Op5040:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10]

  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: r1 into register[r10]:
  mov r1,r1,asr #16
  strh r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5048] addq.w #8, a0 uses Op5048 ----------
Op5048:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  adds r1,r0,#0x0008

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5050] addq.w #8, (a0) uses Op5050 ----------
Op5050:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r1,r1,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5058] addq.w #8, (a0)+ uses Op5058 ----------
Op5058:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r1,r1,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5060] addq.w #8, -(a0) uses Op5060 ----------
Op5060:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r1,r1,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5068] addq.w #8, ($3333,a0) uses Op5068 ----------
Op5068:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r1,r1,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5070] addq.w #8, ($33,a0,d3.w*2) uses Op5070 ----------
Op5070:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r1,r1,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5078] addq.w #8, $3333.w uses Op5078 ----------
Op5078:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r1,r1,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5079] addq.w #8, $33333333.l uses Op5079 ----------
Op5079:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r1,r1,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5080] addq.l #8, d0 uses Op5080 ----------
Op5080:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5088] addq.l #8, a0 uses Op5088 ----------
Op5088:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  adds r1,r0,#0x0008

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5090] addq.l #8, (a0) uses Op5090 ----------
Op5090:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5098] addq.l #8, (a0)+ uses Op5098 ----------
Op5098:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50a0] addq.l #8, -(a0) uses Op50a0 ----------
Op50a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50a8] addq.l #8, ($3333,a0) uses Op50a8 ----------
Op50a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50b0] addq.l #8, ($33,a0,d3.w*2) uses Op50b0 ----------
Op50b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50b8] addq.l #8, $3333.w uses Op50b8 ----------
Op50b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50b9] addq.l #8, $33333333.l uses Op50b9 ----------
Op50b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50c0] st d0 uses Op50c0 ----------
Op50c0:
  mvn r1,#0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#6 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50c8] dbt d0, 3335 uses Op50c8 ----------
Op50c8:
;@ condition true:
DbraTrue:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50d0] st (a0) uses Op50d0 ----------
Op50d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mvn r1,#0

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50d8] st (a0)+ uses Op50d8 ----------
Op50d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mvn r1,#0

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50df] st (a7)+ uses Op50df ----------
Op50df:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mvn r1,#0

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50e0] st -(a0) uses Op50e0 ----------
Op50e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mvn r1,#0

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50e7] st -(a7) uses Op50e7 ----------
Op50e7:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mvn r1,#0

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50e8] st ($3333,a0) uses Op50e8 ----------
Op50e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mvn r1,#0

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50f0] st ($33,a0,d3.w*2) uses Op50f0 ----------
Op50f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mvn r1,#0

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50f8] st $3333.w uses Op50f8 ----------
Op50f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mvn r1,#0

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50f9] st $33333333.l uses Op50f9 ----------
Op50f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mvn r1,#0

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5100] subq.b #8, d0 uses Op5100 ----------
Op5100:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: r1 into register[r10]:
  mov r1,r1,asr #24
  strb r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5110] subq.b #8, (a0) uses Op5110 ----------
Op5110:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5118] subq.b #8, (a0)+ uses Op5118 ----------
Op5118:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [511f] subq.b #8, (a7)+ uses Op511f ----------
Op511f:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a7)+' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5120] subq.b #8, -(a0) uses Op5120 ----------
Op5120:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#1 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5127] subq.b #8, -(a7) uses Op5127 ----------
Op5127:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a7)' into r10:
  ldr r10,[r7,#0x3c] ;@ A7
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,#0x3c] ;@ A7
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5128] subq.b #8, ($3333,a0) uses Op5128 ----------
Op5128:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5130] subq.b #8, ($33,a0,d3.w*2) uses Op5130 ----------
Op5130:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5138] subq.b #8, $3333.w uses Op5138 ----------
Op5138:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5139] subq.b #8, $33333333.l uses Op5139 ----------
Op5139:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler

  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r1,r1,asr #24
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5140] subq.w #8, d0 uses Op5140 ----------
Op5140:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10]

  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: r1 into register[r10]:
  mov r1,r1,asr #16
  strh r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5148] subq.w #8, a0 uses Op5148 ----------
Op5148:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  subs r1,r0,#0x0008

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5150] subq.w #8, (a0) uses Op5150 ----------
Op5150:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r1,r1,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5158] subq.w #8, (a0)+ uses Op5158 ----------
Op5158:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r1,r1,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5160] subq.w #8, -(a0) uses Op5160 ----------
Op5160:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r1,r1,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5168] subq.w #8, ($3333,a0) uses Op5168 ----------
Op5168:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r1,r1,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5170] subq.w #8, ($33,a0,d3.w*2) uses Op5170 ----------
Op5170:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r1,r1,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5178] subq.w #8, $3333.w uses Op5178 ----------
Op5178:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r1,r1,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5179] subq.w #8, $33333333.l uses Op5179 ----------
Op5179:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r1,r1,asr #16
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5180] subq.l #8, d0 uses Op5180 ----------
Op5180:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5188] subq.l #8, a0 uses Op5188 ----------
Op5188:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  subs r1,r0,#0x0008

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5190] subq.l #8, (a0) uses Op5190 ----------
Op5190:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5198] subq.l #8, (a0)+ uses Op5198 ----------
Op5198:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51a0] subq.l #8, -(a0) uses Op51a0 ----------
Op51a0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51a8] subq.l #8, ($3333,a0) uses Op51a8 ----------
Op51a8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($3333,a0)' into r10:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51b0] subq.l #8, ($33,a0,d3.w*2) uses Op51b0 ----------
Op51b0:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51b8] subq.l #8, $3333.w uses Op51b8 ----------
Op51b8:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51b9] subq.l #8, $33333333.l uses Op51b9 ----------
Op51b9:
  str r5,[r7,#0x5c] ;@ Save Cycles

;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  str r9,[r7,#0x4c] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  bic r0,r10,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51c0] sf d0 uses Op51c0 ----------
Op51c0:
  mov r1,#0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51c8] dbra d0, 3335 uses Op51c8 ----------
Op51c8:
;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmn r0,#1
  beq DbraMin1

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r0,r4,r0 ;@ r0 = New PC
;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ Dn.w is -1:
DbraMin1:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51d0] sf (a0) uses Op51d0 ----------
Op51d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51d8] sf (a0)+ uses Op51d8 ----------
Op51d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51df] sf (a7)+ uses Op51df ----------
Op51df:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51e0] sf -(a0) uses Op51e0 ----------
Op51e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51e7] sf -(a7) uses Op51e7 ----------
Op51e7:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51e8] sf ($3333,a0) uses Op51e8 ----------
Op51e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51f0] sf ($33,a0,d3.w*2) uses Op51f0 ----------
Op51f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51f8] sf $3333.w uses Op51f8 ----------
Op51f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51f9] sf $33333333.l uses Op51f9 ----------
Op51f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52c0] shi d0 uses Op52c0 ----------
Op52c0:
  mov r1,#0
  tst r9,#0x60000000 ;@ hi: !C && !Z
  mvneq r1,r1
  subeq r5,r5,#2 ;@ Extra cycles

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52c8] dbhi d0, 3335 uses Op52c8 ----------
Op52c8:
  tst r9,#0x60000000 ;@ hi: !C && !Z
  beq DbraTrue

;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmn r0,#1
  beq DbraMin1

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r0,r4,r0 ;@ r0 = New PC
;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52d0] shi (a0) uses Op52d0 ----------
Op52d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ hi: !C && !Z
  mvneq r1,r1

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52d8] shi (a0)+ uses Op52d8 ----------
Op52d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ hi: !C && !Z
  mvneq r1,r1

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52df] shi (a7)+ uses Op52df ----------
Op52df:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ hi: !C && !Z
  mvneq r1,r1

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52e0] shi -(a0) uses Op52e0 ----------
Op52e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ hi: !C && !Z
  mvneq r1,r1

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52e7] shi -(a7) uses Op52e7 ----------
Op52e7:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ hi: !C && !Z
  mvneq r1,r1

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52e8] shi ($3333,a0) uses Op52e8 ----------
Op52e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ hi: !C && !Z
  mvneq r1,r1

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52f0] shi ($33,a0,d3.w*2) uses Op52f0 ----------
Op52f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ hi: !C && !Z
  mvneq r1,r1

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52f8] shi $3333.w uses Op52f8 ----------
Op52f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ hi: !C && !Z
  mvneq r1,r1

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52f9] shi $33333333.l uses Op52f9 ----------
Op52f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ hi: !C && !Z
  mvneq r1,r1

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53c0] sls d0 uses Op53c0 ----------
Op53c0:
  mov r1,#0
  tst r9,#0x60000000 ;@ ls: C || Z
  mvnne r1,r1
  subne r5,r5,#2 ;@ Extra cycles

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53c8] dbls d0, 3335 uses Op53c8 ----------
Op53c8:
  tst r9,#0x60000000 ;@ ls: C || Z
  bne DbraTrue

;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmn r0,#1
  beq DbraMin1

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r0,r4,r0 ;@ r0 = New PC
;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53d0] sls (a0) uses Op53d0 ----------
Op53d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ ls: C || Z
  mvnne r1,r1

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53d8] sls (a0)+ uses Op53d8 ----------
Op53d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ ls: C || Z
  mvnne r1,r1

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53df] sls (a7)+ uses Op53df ----------
Op53df:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ ls: C || Z
  mvnne r1,r1

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53e0] sls -(a0) uses Op53e0 ----------
Op53e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ ls: C || Z
  mvnne r1,r1

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53e7] sls -(a7) uses Op53e7 ----------
Op53e7:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ ls: C || Z
  mvnne r1,r1

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53e8] sls ($3333,a0) uses Op53e8 ----------
Op53e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ ls: C || Z
  mvnne r1,r1

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53f0] sls ($33,a0,d3.w*2) uses Op53f0 ----------
Op53f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ ls: C || Z
  mvnne r1,r1

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53f8] sls $3333.w uses Op53f8 ----------
Op53f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ ls: C || Z
  mvnne r1,r1

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53f9] sls $33333333.l uses Op53f9 ----------
Op53f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
  tst r9,#0x60000000 ;@ ls: C || Z
  mvnne r1,r1

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54c0] scc d0 uses Op54c0 ----------
Op54c0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1
  subcc r5,r5,#2 ;@ Extra cycles

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54c8] dbcc d0, 3335 uses Op54c8 ----------
Op54c8:
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
;@ If so, don't dbra
  bcc DbraTrue

;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmn r0,#1
  beq DbraMin1

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r0,r4,r0 ;@ r0 = New PC
;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54d0] scc (a0) uses Op54d0 ----------
Op54d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54d8] scc (a0)+ uses Op54d8 ----------
Op54d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54df] scc (a7)+ uses Op54df ----------
Op54df:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54e0] scc -(a0) uses Op54e0 ----------
Op54e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54e7] scc -(a7) uses Op54e7 ----------
Op54e7:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54e8] scc ($3333,a0) uses Op54e8 ----------
Op54e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54f0] scc ($33,a0,d3.w*2) uses Op54f0 ----------
Op54f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54f8] scc $3333.w uses Op54f8 ----------
Op54f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54f9] scc $33333333.l uses Op54f9 ----------
Op54f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55c0] scs d0 uses Op55c0 ----------
Op55c0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1
  subcs r5,r5,#2 ;@ Extra cycles

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55c8] dbcs d0, 3335 uses Op55c8 ----------
Op55c8:
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
;@ If so, don't dbra
  bcs DbraTrue

;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmn r0,#1
  beq DbraMin1

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r0,r4,r0 ;@ r0 = New PC
;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55d0] scs (a0) uses Op55d0 ----------
Op55d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55d8] scs (a0)+ uses Op55d8 ----------
Op55d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55df] scs (a7)+ uses Op55df ----------
Op55df:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55e0] scs -(a0) uses Op55e0 ----------
Op55e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55e7] scs -(a7) uses Op55e7 ----------
Op55e7:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55e8] scs ($3333,a0) uses Op55e8 ----------
Op55e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55f0] scs ($33,a0,d3.w*2) uses Op55f0 ----------
Op55f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55f8] scs $3333.w uses Op55f8 ----------
Op55f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55f9] scs $33333333.l uses Op55f9 ----------
Op55f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56c0] sne d0 uses Op56c0 ----------
Op56c0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1
  subne r5,r5,#2 ;@ Extra cycles

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56c8] dbne d0, 3335 uses Op56c8 ----------
Op56c8:
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
;@ If so, don't dbra
  bne DbraTrue

;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmn r0,#1
  beq DbraMin1

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r0,r4,r0 ;@ r0 = New PC
;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56d0] sne (a0) uses Op56d0 ----------
Op56d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56d8] sne (a0)+ uses Op56d8 ----------
Op56d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56df] sne (a7)+ uses Op56df ----------
Op56df:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56e0] sne -(a0) uses Op56e0 ----------
Op56e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56e7] sne -(a7) uses Op56e7 ----------
Op56e7:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56e8] sne ($3333,a0) uses Op56e8 ----------
Op56e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56f0] sne ($33,a0,d3.w*2) uses Op56f0 ----------
Op56f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56f8] sne $3333.w uses Op56f8 ----------
Op56f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56f9] sne $33333333.l uses Op56f9 ----------
Op56f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57c0] seq d0 uses Op57c0 ----------
Op57c0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1
  subeq r5,r5,#2 ;@ Extra cycles

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57c8] dbeq d0, 3335 uses Op57c8 ----------
Op57c8:
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
;@ If so, don't dbra
  beq DbraTrue

;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmn r0,#1
  beq DbraMin1

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r0,r4,r0 ;@ r0 = New PC
;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57d0] seq (a0) uses Op57d0 ----------
Op57d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57d8] seq (a0)+ uses Op57d8 ----------
Op57d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57df] seq (a7)+ uses Op57df ----------
Op57df:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57e0] seq -(a0) uses Op57e0 ----------
Op57e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57e7] seq -(a7) uses Op57e7 ----------
Op57e7:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '-(a7)' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57e8] seq ($3333,a0) uses Op57e8 ----------
Op57e8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '($3333,a0)' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch offset
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57f0] seq ($33,a0,d3.w*2) uses Op57f0 ----------
Op57f0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57f8] seq $3333.w uses Op57f8 ----------
Op57f8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57f9] seq $33333333.l uses Op57f9 ----------
Op57f9:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58c0] svc d0 uses Op58c0 ----------
Op58c0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvc r1,r1
  subvc r5,r5,#2 ;@ Extra cycles

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58c8] dbvc d0, 3335 uses Op58c8 ----------
Op58c8:
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
;@ If so, don't dbra
  bvc DbraTrue

;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmn r0,#1
  beq DbraMin1

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r0,r4,r0 ;@ r0 = New PC
;@ Check Memory Base+pc
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()

  mov r4,r0
  tst r4,#1 ;@ address error?
  bne ExceptionAddressError_r_prg_r4
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58d0] svc (a0) uses Op58d0 ----------
Op58d0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvc r1,r1

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58d8] svc (a0)+ uses Op58d8 ----------
Op58d8:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvc r1,r1

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58df] svc (a7)+ uses Op58df ----------
Op58df:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvc r1,r1

;@ EaCalc : Get '(a7)+' into r0:
  ldr r0,[r7,#0x3c] ;@ A7
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,#0x3c] ;@ A7
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58e0] svc -(a0) uses Op58e0 ----------
Op58e0:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvc r1,r1

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  str r4,[r7,#0x40] ;@ Save PC
  bic r0,r0,#0xff000000
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldr r5,[r7,#0x5c] ;@ Load Cycles
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58e7] svc -(a7) uses Op58e7 ----------
Op58e7:
  str r5,[r7,#0x5c] ;@ Save Cycles

  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvc r1,r1

;@ EaCalc : Get '-(