/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.ast.visitor;

import java.util.Map;
import org.apache.groovy.contracts.ast.visitor.BaseVisitor;
import org.apache.groovy.contracts.common.spi.ProcessingContextInformation;
import org.apache.groovy.contracts.domain.Assertion;
import org.apache.groovy.contracts.domain.ClassInvariant;
import org.apache.groovy.contracts.domain.Contract;
import org.apache.groovy.contracts.domain.Postcondition;
import org.apache.groovy.contracts.domain.Precondition;
import org.apache.groovy.contracts.generation.CandidateChecks;
import org.apache.groovy.contracts.generation.ClassInvariantGenerator;
import org.apache.groovy.contracts.generation.PostconditionGenerator;
import org.apache.groovy.contracts.generation.PreconditionGenerator;
import org.apache.groovy.contracts.util.Validate;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;

public class DomainModelInjectionVisitor
extends BaseVisitor {
    private final ProcessingContextInformation pci;
    private final Contract contract;

    public DomainModelInjectionVisitor(SourceUnit sourceUnit, ReaderSource source, ProcessingContextInformation pci) {
        super(sourceUnit, source);
        Validate.notNull(pci);
        Validate.notNull(pci.contract());
        this.pci = pci;
        this.contract = pci.contract();
    }

    public void visitClass(ClassNode type) {
        this.injectClassInvariant(type, this.contract.classInvariant());
        for (Map.Entry<MethodNode, Precondition> entry : this.contract.preconditions()) {
            this.injectPrecondition(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<MethodNode, Assertion> entry : this.contract.postconditions()) {
            this.injectPostcondition(entry.getKey(), (Postcondition)entry.getValue());
        }
    }

    public void injectClassInvariant(ClassNode type, ClassInvariant classInvariant) {
        if (!this.pci.isClassInvariantsEnabled() || !CandidateChecks.isContractsCandidate(type)) {
            return;
        }
        ReaderSource source = this.pci.readerSource();
        ClassInvariantGenerator classInvariantGenerator = new ClassInvariantGenerator(source);
        classInvariantGenerator.generateInvariantAssertionStatement(type, classInvariant);
    }

    public void injectPrecondition(MethodNode method, Precondition precondition) {
        if (!this.pci.isPreconditionsEnabled() || !CandidateChecks.isPreconditionCandidate(method.getDeclaringClass(), method)) {
            return;
        }
        ReaderSource source = this.pci.readerSource();
        PreconditionGenerator preconditionGenerator = new PreconditionGenerator(source);
        preconditionGenerator.generatePreconditionAssertionStatement(method, precondition);
    }

    public void injectPostcondition(MethodNode method, Postcondition postcondition) {
        if (!this.pci.isPostconditionsEnabled() || !CandidateChecks.isPostconditionCandidate(method.getDeclaringClass(), method)) {
            return;
        }
        ReaderSource source = this.pci.readerSource();
        PostconditionGenerator postconditionGenerator = new PostconditionGenerator(source);
        postconditionGenerator.generatePostconditionAssertionStatement(method, postcondition);
    }
}

