/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.sdkmodule;

import com.android.aapt.Resources;
import com.android.bundle.SdkModulesConfigOuterClass;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

final class AndroidResourceRenamer {
    private final String sdkPackageNameHash;

    AndroidResourceRenamer(SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig) {
        this.sdkPackageNameHash = AndroidResourceRenamer.getAlphaNumericHash(sdkModulesConfig.getSdkPackageName());
    }

    BundleModule renameAndroidResources(BundleModule module) {
        if (!module.getResourceTable().isPresent()) {
            return module;
        }
        ImmutableSet<ZipPath> androidResourcePaths = ResourcesUtils.getAllFileReferences(module.getResourceTable().get());
        ImmutableList<ModuleEntry> newEntries = module.getEntries().stream().map(entry -> androidResourcePaths.contains(entry.getPath()) ? this.updateAndroidResourceEntryPath((ModuleEntry)entry) : entry).collect(ImmutableList.toImmutableList());
        return module.toBuilder().setResourceTable(this.renameInResourceTable(module.getResourceTable().get())).setRawEntries(newEntries).build();
    }

    private ModuleEntry updateAndroidResourceEntryPath(ModuleEntry androidResourceEntry) {
        return androidResourceEntry.toBuilder().setPath(this.renamedResourcePath(androidResourceEntry.getPath())).build();
    }

    private Resources.ResourceTable renameInResourceTable(Resources.ResourceTable resourceTable) {
        Resources.ResourceTable.Builder renamedResourceTableBuilder = resourceTable.toBuilder();
        this.renameInResourceTable(renamedResourceTableBuilder);
        return renamedResourceTableBuilder.build();
    }

    private void renameInResourceTable(Resources.ResourceTable.Builder resourceTable) {
        resourceTable.getPackageBuilderList().forEach(this::renameInPackage);
    }

    private void renameInPackage(Resources.Package.Builder resourceTablePackage) {
        resourceTablePackage.getTypeBuilderList().forEach(this::renameInType);
    }

    private void renameInType(Resources.Type.Builder type) {
        type.getEntryBuilderList().forEach(this::renameInEntry);
    }

    private void renameInEntry(Resources.Entry.Builder entry) {
        entry.getConfigValueBuilderList().forEach(this::renameInConfigValue);
    }

    private void renameInConfigValue(Resources.ConfigValue.Builder configValue) {
        if (!configValue.getValue().getItem().hasFile()) {
            return;
        }
        this.renameInFile(configValue.getValueBuilder().getItemBuilder().getFileBuilder());
    }

    private void renameInFile(Resources.FileReference.Builder file) {
        file.setPath(this.renamedResourcePath(ZipPath.create(file.getPath())).toString());
    }

    private ZipPath renamedResourcePath(ZipPath oldPath) {
        if (oldPath == null || oldPath.getParent() == null || oldPath.getParent().equals(ZipPath.ROOT)) {
            throw InvalidBundleException.createWithUserMessage("Android resource entry with unexpected path: " + oldPath);
        }
        return oldPath.getParent().resolve(this.sdkPackageNameHash + oldPath.getFileName());
    }

    private static String getAlphaNumericHash(String packageName) {
        String result;
        try {
            result = ByteSource.wrap(packageName.getBytes(StandardCharsets.UTF_8)).hash(Hashing.farmHashFingerprint64()).toString();
        }
        catch (IOException e11) {
            throw new UncheckedIOException("An error occurred when calculating the hash.", e11);
        }
        return result;
    }
}

