# fable_library/core/string_.pyi
from __future__ import annotations

from collections.abc import Callable
from typing import Any

class IPrintfFormat:
    """F# printf-style formatting class."""
    def __init__(self, input: str) -> None: ...
    @property
    def input(self) -> str: ...
    def __call__(self, arg: Any) -> IPrintfFormat | str: ...
    def cont(self, continuation: Callable[[str], Any]) -> Any: ...

class ConsolePrinter:
    """Console printer wrapper that maintains F# currying semantics."""
    def __call__(self, arg: Any) -> ConsolePrinter | None: ...

class StringComparison:
    """String comparison enumeration."""

    CURRENT_CULTURE: int = 0
    CURRENT_CULTURE_IGNORE_CASE: int = 1
    INVARIANT_CULTURE: int = 2
    INVARIANT_CULTURE_IGNORE_CASE: int = 3
    ORDINAL: int = 4
    ORDINAL_IGNORE_CASE: int = 5

# F# printf-style formatting functions
def printf(input: str) -> IPrintfFormat: ...
def continue_print(cont: Callable[..., Any], arg: Any) -> Any: ...
def to_console(arg: Any) -> ConsolePrinter: ...
def to_text(arg: Any) -> str: ...

# String formatting functions
def format_replacement(
    rep: Any,
    flags: str | None = None,
    pad_length: int | None = None,
    precision: int | None = None,
    format: str | None = None,
) -> str: ...
def format(string: str, args: tuple[Any, ...]) -> str: ...

# String manipulation functions
def initialize(n: int, f: Callable[[int], str]) -> str: ...
def insert(string: str, start_index: int, value: str) -> str: ...
def is_null_or_empty(string: str | None) -> bool: ...
def is_null_or_white_space(string: str | None) -> bool: ...
def concat(strings: Any) -> str: ...
def join(delimiter: str, strings: Any) -> str: ...
def pad_left(string: str, length: int, ch: str | None = None, is_right: bool = False) -> str: ...
def pad_right(string: str, length: int, ch: str | None = None) -> str: ...
def remove(string: str, start_index: int, count: int | None = None) -> str: ...
def replace(string: str, search: str, replace: str) -> str: ...
def replicate(n: int, x: str) -> str: ...
def get_char_at_index(input: str, index: int) -> str: ...
def split(
    string: str,
    splitters: Any,
    count: int | None = None,
    remove_empty: int = 0,
) -> list[str]: ...
def trim(string: str, *chars: Any) -> str: ...
def trim_start(string: str, *chars: Any) -> str: ...
def trim_end(string: str, *chars: Any) -> str: ...
def filter(pred: Callable[[str], bool], x: str) -> str: ...
def substring(string: str, start_index: int, length: int | None = None) -> str: ...
def to_char_array2(string: str, start_index: int, length: int) -> list[str]: ...

# String comparison functions
def compare(*args: Any) -> int: ...
def starts_with(string: str, pattern: str, ic: bool | None = None) -> bool: ...
def ends_with(string: str, pattern: str, ic: bool | None = None) -> bool: ...
def index_of(string: str, pattern: str, start_index: int = 0) -> int: ...
def last_index_of(string: str, pattern: str, start_index: int | None = None) -> int: ...

# Additional compatibility functions
def compare_to(this: str, other: str) -> int: ...
def ends_with_exact(string: str, pattern: str) -> bool: ...
def starts_with_exact(string: str, pattern: str) -> bool: ...
def index_of_any(string: str, any_of: Any, *args: int) -> int: ...
def interpolate(string: str, values: Any) -> str: ...
