/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.MpxjEnum;
import net.sf.mpxj.common.EnumHelper;
import net.sf.mpxj.common.NumberHelper;

public enum LineStyle implements MpxjEnum
{
    NONE(0, "None"),
    SOLID(1, "Solid"),
    DOTTED1(2, "Dotted1"),
    DOTTED2(3, "Dotted2"),
    DASHED(4, "Dashed");

    private static final LineStyle[] TYPE_VALUES;
    private final int m_value;
    private final String m_name;

    private LineStyle(int type, String name) {
        this.m_value = type;
        this.m_name = name;
    }

    public static LineStyle getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = NONE.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static LineStyle getInstance(Number type) {
        int value = type == null ? -1 : NumberHelper.getInt(type);
        return LineStyle.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    static {
        TYPE_VALUES = (LineStyle[])EnumHelper.createTypeArray(LineStyle.class, (int)1);
    }
}

