// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package licensemanager

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateLicenseConfiguration = "CreateLicenseConfiguration"

// CreateLicenseConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateLicenseConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLicenseConfiguration for more information on using the CreateLicenseConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLicenseConfigurationRequest method.
//    req, resp := client.CreateLicenseConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseConfiguration
func (c *LicenseManager) CreateLicenseConfigurationRequest(input *CreateLicenseConfigurationInput) (req *request.Request, output *CreateLicenseConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateLicenseConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLicenseConfigurationInput{}
	}

	output = &CreateLicenseConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLicenseConfiguration API operation for AWS License Manager.
//
// Creates a license configuration.
//
// A license configuration is an abstraction of a customer license agreement
// that can be consumed and enforced by License Manager. Components include
// specifications for the license type (licensing by instance, socket, CPU,
// or vCPU), allowed tenancy (shared tenancy, Dedicated Instance, Dedicated
// Host, or all of these), license affinity to host (how long a license must
// be associated with a host), and the number of licenses purchased and used.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager's
// API operation CreateLicenseConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameter values are not valid.
//
//   * ServerInternalException
//   The server experienced an internal error. Try again.
//
//   * ResourceLimitExceededException
//   Your resource limits have been exceeded.
//
//   * AuthorizationException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * AccessDeniedException
//   Access to resource denied.
//
//   * RateLimitExceededException
//   Too many requests have been submitted. Try again after a brief wait.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/CreateLicenseConfiguration
func (c *LicenseManager) CreateLicenseConfiguration(input *CreateLicenseConfigurationInput) (*CreateLicenseConfigurationOutput, error) {
	req, out := c.CreateLicenseConfigurationRequest(input)
	return out, req.Send()
}

// CreateLicenseConfigurationWithContext is the same as CreateLicenseConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLicenseConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManager) CreateLicenseConfigurationWithContext(ctx aws.Context, input *CreateLicenseConfigurationInput, opts ...request.Option) (*CreateLicenseConfigurationOutput, error) {
	req, out := c.CreateLicenseConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLicenseConfiguration = "DeleteLicenseConfiguration"

// DeleteLicenseConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLicenseConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLicenseConfiguration for more information on using the DeleteLicenseConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLicenseConfigurationRequest method.
//    req, resp := client.DeleteLicenseConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteLicenseConfiguration
func (c *LicenseManager) DeleteLicenseConfigurationRequest(input *DeleteLicenseConfigurationInput) (req *request.Request, output *DeleteLicenseConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteLicenseConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLicenseConfigurationInput{}
	}

	output = &DeleteLicenseConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLicenseConfiguration API operation for AWS License Manager.
//
// Deletes the specified license configuration.
//
// You cannot delete a license configuration that is in use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager's
// API operation DeleteLicenseConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameter values are not valid.
//
//   * ServerInternalException
//   The server experienced an internal error. Try again.
//
//   * AuthorizationException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * AccessDeniedException
//   Access to resource denied.
//
//   * RateLimitExceededException
//   Too many requests have been submitted. Try again after a brief wait.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/DeleteLicenseConfiguration
func (c *LicenseManager) DeleteLicenseConfiguration(input *DeleteLicenseConfigurationInput) (*DeleteLicenseConfigurationOutput, error) {
	req, out := c.DeleteLicenseConfigurationRequest(input)
	return out, req.Send()
}

// DeleteLicenseConfigurationWithContext is the same as DeleteLicenseConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLicenseConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManager) DeleteLicenseConfigurationWithContext(ctx aws.Context, input *DeleteLicenseConfigurationInput, opts ...request.Option) (*DeleteLicenseConfigurationOutput, error) {
	req, out := c.DeleteLicenseConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLicenseConfiguration = "GetLicenseConfiguration"

// GetLicenseConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetLicenseConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLicenseConfiguration for more information on using the GetLicenseConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLicenseConfigurationRequest method.
//    req, resp := client.GetLicenseConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseConfiguration
func (c *LicenseManager) GetLicenseConfigurationRequest(input *GetLicenseConfigurationInput) (req *request.Request, output *GetLicenseConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetLicenseConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLicenseConfigurationInput{}
	}

	output = &GetLicenseConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLicenseConfiguration API operation for AWS License Manager.
//
// Gets detailed information about the specified license configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager's
// API operation GetLicenseConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameter values are not valid.
//
//   * ServerInternalException
//   The server experienced an internal error. Try again.
//
//   * AuthorizationException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * AccessDeniedException
//   Access to resource denied.
//
//   * RateLimitExceededException
//   Too many requests have been submitted. Try again after a brief wait.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetLicenseConfiguration
func (c *LicenseManager) GetLicenseConfiguration(input *GetLicenseConfigurationInput) (*GetLicenseConfigurationOutput, error) {
	req, out := c.GetLicenseConfigurationRequest(input)
	return out, req.Send()
}

// GetLicenseConfigurationWithContext is the same as GetLicenseConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetLicenseConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManager) GetLicenseConfigurationWithContext(ctx aws.Context, input *GetLicenseConfigurationInput, opts ...request.Option) (*GetLicenseConfigurationOutput, error) {
	req, out := c.GetLicenseConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceSettings = "GetServiceSettings"

// GetServiceSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceSettings for more information on using the GetServiceSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServiceSettingsRequest method.
//    req, resp := client.GetServiceSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetServiceSettings
func (c *LicenseManager) GetServiceSettingsRequest(input *GetServiceSettingsInput) (req *request.Request, output *GetServiceSettingsOutput) {
	op := &request.Operation{
		Name:       opGetServiceSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceSettingsInput{}
	}

	output = &GetServiceSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceSettings API operation for AWS License Manager.
//
// Gets the License Manager settings for the current Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager's
// API operation GetServiceSettings for usage and error information.
//
// Returned Error Types:
//   * ServerInternalException
//   The server experienced an internal error. Try again.
//
//   * AuthorizationException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * AccessDeniedException
//   Access to resource denied.
//
//   * RateLimitExceededException
//   Too many requests have been submitted. Try again after a brief wait.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/GetServiceSettings
func (c *LicenseManager) GetServiceSettings(input *GetServiceSettingsInput) (*GetServiceSettingsOutput, error) {
	req, out := c.GetServiceSettingsRequest(input)
	return out, req.Send()
}

// GetServiceSettingsWithContext is the same as GetServiceSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManager) GetServiceSettingsWithContext(ctx aws.Context, input *GetServiceSettingsInput, opts ...request.Option) (*GetServiceSettingsOutput, error) {
	req, out := c.GetServiceSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAssociationsForLicenseConfiguration = "ListAssociationsForLicenseConfiguration"

// ListAssociationsForLicenseConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociationsForLicenseConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssociationsForLicenseConfiguration for more information on using the ListAssociationsForLicenseConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssociationsForLicenseConfigurationRequest method.
//    req, resp := client.ListAssociationsForLicenseConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListAssociationsForLicenseConfiguration
func (c *LicenseManager) ListAssociationsForLicenseConfigurationRequest(input *ListAssociationsForLicenseConfigurationInput) (req *request.Request, output *ListAssociationsForLicenseConfigurationOutput) {
	op := &request.Operation{
		Name:       opListAssociationsForLicenseConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAssociationsForLicenseConfigurationInput{}
	}

	output = &ListAssociationsForLicenseConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssociationsForLicenseConfiguration API operation for AWS License Manager.
//
// Lists the resource associations for the specified license configuration.
//
// Resource associations need not consume licenses from a license configuration.
// For example, an AMI or a stopped instance might not consume a license (depending
// on the license rules).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager's
// API operation ListAssociationsForLicenseConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameter values are not valid.
//
//   * FilterLimitExceededException
//   The request uses too many filters or too many filter values.
//
//   * ServerInternalException
//   The server experienced an internal error. Try again.
//
//   * AuthorizationException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * AccessDeniedException
//   Access to resource denied.
//
//   * RateLimitExceededException
//   Too many requests have been submitted. Try again after a brief wait.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListAssociationsForLicenseConfiguration
func (c *LicenseManager) ListAssociationsForLicenseConfiguration(input *ListAssociationsForLicenseConfigurationInput) (*ListAssociationsForLicenseConfigurationOutput, error) {
	req, out := c.ListAssociationsForLicenseConfigurationRequest(input)
	return out, req.Send()
}

// ListAssociationsForLicenseConfigurationWithContext is the same as ListAssociationsForLicenseConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssociationsForLicenseConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManager) ListAssociationsForLicenseConfigurationWithContext(ctx aws.Context, input *ListAssociationsForLicenseConfigurationInput, opts ...request.Option) (*ListAssociationsForLicenseConfigurationOutput, error) {
	req, out := c.ListAssociationsForLicenseConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFailuresForLicenseConfigurationOperations = "ListFailuresForLicenseConfigurationOperations"

// ListFailuresForLicenseConfigurationOperationsRequest generates a "aws/request.Request" representing the
// client's request for the ListFailuresForLicenseConfigurationOperations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFailuresForLicenseConfigurationOperations for more information on using the ListFailuresForLicenseConfigurationOperations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFailuresForLicenseConfigurationOperationsRequest method.
//    req, resp := client.ListFailuresForLicenseConfigurationOperationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListFailuresForLicenseConfigurationOperations
func (c *LicenseManager) ListFailuresForLicenseConfigurationOperationsRequest(input *ListFailuresForLicenseConfigurationOperationsInput) (req *request.Request, output *ListFailuresForLicenseConfigurationOperationsOutput) {
	op := &request.Operation{
		Name:       opListFailuresForLicenseConfigurationOperations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListFailuresForLicenseConfigurationOperationsInput{}
	}

	output = &ListFailuresForLicenseConfigurationOperationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFailuresForLicenseConfigurationOperations API operation for AWS License Manager.
//
// Lists the license configuration operations that failed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager's
// API operation ListFailuresForLicenseConfigurationOperations for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameter values are not valid.
//
//   * ServerInternalException
//   The server experienced an internal error. Try again.
//
//   * AuthorizationException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * AccessDeniedException
//   Access to resource denied.
//
//   * RateLimitExceededException
//   Too many requests have been submitted. Try again after a brief wait.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListFailuresForLicenseConfigurationOperations
func (c *LicenseManager) ListFailuresForLicenseConfigurationOperations(input *ListFailuresForLicenseConfigurationOperationsInput) (*ListFailuresForLicenseConfigurationOperationsOutput, error) {
	req, out := c.ListFailuresForLicenseConfigurationOperationsRequest(input)
	return out, req.Send()
}

// ListFailuresForLicenseConfigurationOperationsWithContext is the same as ListFailuresForLicenseConfigurationOperations with the addition of
// the ability to pass a context and additional request options.
//
// See ListFailuresForLicenseConfigurationOperations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManager) ListFailuresForLicenseConfigurationOperationsWithContext(ctx aws.Context, input *ListFailuresForLicenseConfigurationOperationsInput, opts ...request.Option) (*ListFailuresForLicenseConfigurationOperationsOutput, error) {
	req, out := c.ListFailuresForLicenseConfigurationOperationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLicenseConfigurations = "ListLicenseConfigurations"

// ListLicenseConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListLicenseConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLicenseConfigurations for more information on using the ListLicenseConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLicenseConfigurationsRequest method.
//    req, resp := client.ListLicenseConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseConfigurations
func (c *LicenseManager) ListLicenseConfigurationsRequest(input *ListLicenseConfigurationsInput) (req *request.Request, output *ListLicenseConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListLicenseConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLicenseConfigurationsInput{}
	}

	output = &ListLicenseConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLicenseConfigurations API operation for AWS License Manager.
//
// Lists the license configurations for your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager's
// API operation ListLicenseConfigurations for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameter values are not valid.
//
//   * ServerInternalException
//   The server experienced an internal error. Try again.
//
//   * FilterLimitExceededException
//   The request uses too many filters or too many filter values.
//
//   * AuthorizationException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * AccessDeniedException
//   Access to resource denied.
//
//   * RateLimitExceededException
//   Too many requests have been submitted. Try again after a brief wait.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseConfigurations
func (c *LicenseManager) ListLicenseConfigurations(input *ListLicenseConfigurationsInput) (*ListLicenseConfigurationsOutput, error) {
	req, out := c.ListLicenseConfigurationsRequest(input)
	return out, req.Send()
}

// ListLicenseConfigurationsWithContext is the same as ListLicenseConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListLicenseConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManager) ListLicenseConfigurationsWithContext(ctx aws.Context, input *ListLicenseConfigurationsInput, opts ...request.Option) (*ListLicenseConfigurationsOutput, error) {
	req, out := c.ListLicenseConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLicenseSpecificationsForResource = "ListLicenseSpecificationsForResource"

// ListLicenseSpecificationsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListLicenseSpecificationsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLicenseSpecificationsForResource for more information on using the ListLicenseSpecificationsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLicenseSpecificationsForResourceRequest method.
//    req, resp := client.ListLicenseSpecificationsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseSpecificationsForResource
func (c *LicenseManager) ListLicenseSpecificationsForResourceRequest(input *ListLicenseSpecificationsForResourceInput) (req *request.Request, output *ListLicenseSpecificationsForResourceOutput) {
	op := &request.Operation{
		Name:       opListLicenseSpecificationsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLicenseSpecificationsForResourceInput{}
	}

	output = &ListLicenseSpecificationsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLicenseSpecificationsForResource API operation for AWS License Manager.
//
// Describes the license configurations for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager's
// API operation ListLicenseSpecificationsForResource for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameter values are not valid.
//
//   * ServerInternalException
//   The server experienced an internal error. Try again.
//
//   * AuthorizationException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * AccessDeniedException
//   Access to resource denied.
//
//   * RateLimitExceededException
//   Too many requests have been submitted. Try again after a brief wait.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseSpecificationsForResource
func (c *LicenseManager) ListLicenseSpecificationsForResource(input *ListLicenseSpecificationsForResourceInput) (*ListLicenseSpecificationsForResourceOutput, error) {
	req, out := c.ListLicenseSpecificationsForResourceRequest(input)
	return out, req.Send()
}

// ListLicenseSpecificationsForResourceWithContext is the same as ListLicenseSpecificationsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListLicenseSpecificationsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManager) ListLicenseSpecificationsForResourceWithContext(ctx aws.Context, input *ListLicenseSpecificationsForResourceInput, opts ...request.Option) (*ListLicenseSpecificationsForResourceOutput, error) {
	req, out := c.ListLicenseSpecificationsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResourceInventory = "ListResourceInventory"

// ListResourceInventoryRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceInventory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceInventory for more information on using the ListResourceInventory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourceInventoryRequest method.
//    req, resp := client.ListResourceInventoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListResourceInventory
func (c *LicenseManager) ListResourceInventoryRequest(input *ListResourceInventoryInput) (req *request.Request, output *ListResourceInventoryOutput) {
	op := &request.Operation{
		Name:       opListResourceInventory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourceInventoryInput{}
	}

	output = &ListResourceInventoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceInventory API operation for AWS License Manager.
//
// Lists resources managed using Systems Manager inventory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager's
// API operation ListResourceInventory for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameter values are not valid.
//
//   * ServerInternalException
//   The server experienced an internal error. Try again.
//
//   * FilterLimitExceededException
//   The request uses too many filters or too many filter values.
//
//   * FailedDependencyException
//   A dependency required to run the API is missing.
//
//   * AuthorizationException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * AccessDeniedException
//   Access to resource denied.
//
//   * RateLimitExceededException
//   Too many requests have been submitted. Try again after a brief wait.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListResourceInventory
func (c *LicenseManager) ListResourceInventory(input *ListResourceInventoryInput) (*ListResourceInventoryOutput, error) {
	req, out := c.ListResourceInventoryRequest(input)
	return out, req.Send()
}

// ListResourceInventoryWithContext is the same as ListResourceInventory with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceInventory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManager) ListResourceInventoryWithContext(ctx aws.Context, input *ListResourceInventoryInput, opts ...request.Option) (*ListResourceInventoryOutput, error) {
	req, out := c.ListResourceInventoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListTagsForResource
func (c *LicenseManager) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS License Manager.
//
// Lists the tags for the specified license configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameter values are not valid.
//
//   * ServerInternalException
//   The server experienced an internal error. Try again.
//
//   * AuthorizationException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * AccessDeniedException
//   Access to resource denied.
//
//   * RateLimitExceededException
//   Too many requests have been submitted. Try again after a brief wait.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListTagsForResource
func (c *LicenseManager) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManager) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUsageForLicenseConfiguration = "ListUsageForLicenseConfiguration"

// ListUsageForLicenseConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the ListUsageForLicenseConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsageForLicenseConfiguration for more information on using the ListUsageForLicenseConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsageForLicenseConfigurationRequest method.
//    req, resp := client.ListUsageForLicenseConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListUsageForLicenseConfiguration
func (c *LicenseManager) ListUsageForLicenseConfigurationRequest(input *ListUsageForLicenseConfigurationInput) (req *request.Request, output *ListUsageForLicenseConfigurationOutput) {
	op := &request.Operation{
		Name:       opListUsageForLicenseConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUsageForLicenseConfigurationInput{}
	}

	output = &ListUsageForLicenseConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsageForLicenseConfiguration API operation for AWS License Manager.
//
// Lists all license usage records for a license configuration, displaying license
// consumption details by resource at a selected point in time. Use this action
// to audit the current license consumption for any license inventory and configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager's
// API operation ListUsageForLicenseConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameter values are not valid.
//
//   * FilterLimitExceededException
//   The request uses too many filters or too many filter values.
//
//   * ServerInternalException
//   The server experienced an internal error. Try again.
//
//   * AuthorizationException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * AccessDeniedException
//   Access to resource denied.
//
//   * RateLimitExceededException
//   Too many requests have been submitted. Try again after a brief wait.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListUsageForLicenseConfiguration
func (c *LicenseManager) ListUsageForLicenseConfiguration(input *ListUsageForLicenseConfigurationInput) (*ListUsageForLicenseConfigurationOutput, error) {
	req, out := c.ListUsageForLicenseConfigurationRequest(input)
	return out, req.Send()
}

// ListUsageForLicenseConfigurationWithContext is the same as ListUsageForLicenseConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsageForLicenseConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManager) ListUsageForLicenseConfigurationWithContext(ctx aws.Context, input *ListUsageForLicenseConfigurationInput, opts ...request.Option) (*ListUsageForLicenseConfigurationOutput, error) {
	req, out := c.ListUsageForLicenseConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/TagResource
func (c *LicenseManager) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS License Manager.
//
// Adds the specified tags to the specified license configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameter values are not valid.
//
//   * ServerInternalException
//   The server experienced an internal error. Try again.
//
//   * AuthorizationException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * AccessDeniedException
//   Access to resource denied.
//
//   * RateLimitExceededException
//   Too many requests have been submitted. Try again after a brief wait.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/TagResource
func (c *LicenseManager) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManager) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UntagResource
func (c *LicenseManager) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS License Manager.
//
// Removes the specified tags from the specified license configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameter values are not valid.
//
//   * ServerInternalException
//   The server experienced an internal error. Try again.
//
//   * AuthorizationException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * AccessDeniedException
//   Access to resource denied.
//
//   * RateLimitExceededException
//   Too many requests have been submitted. Try again after a brief wait.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UntagResource
func (c *LicenseManager) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManager) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLicenseConfiguration = "UpdateLicenseConfiguration"

// UpdateLicenseConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLicenseConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLicenseConfiguration for more information on using the UpdateLicenseConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateLicenseConfigurationRequest method.
//    req, resp := client.UpdateLicenseConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseConfiguration
func (c *LicenseManager) UpdateLicenseConfigurationRequest(input *UpdateLicenseConfigurationInput) (req *request.Request, output *UpdateLicenseConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateLicenseConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLicenseConfigurationInput{}
	}

	output = &UpdateLicenseConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateLicenseConfiguration API operation for AWS License Manager.
//
// Modifies the attributes of an existing license configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager's
// API operation UpdateLicenseConfiguration for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameter values are not valid.
//
//   * ServerInternalException
//   The server experienced an internal error. Try again.
//
//   * AuthorizationException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * AccessDeniedException
//   Access to resource denied.
//
//   * RateLimitExceededException
//   Too many requests have been submitted. Try again after a brief wait.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseConfiguration
func (c *LicenseManager) UpdateLicenseConfiguration(input *UpdateLicenseConfigurationInput) (*UpdateLicenseConfigurationOutput, error) {
	req, out := c.UpdateLicenseConfigurationRequest(input)
	return out, req.Send()
}

// UpdateLicenseConfigurationWithContext is the same as UpdateLicenseConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLicenseConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManager) UpdateLicenseConfigurationWithContext(ctx aws.Context, input *UpdateLicenseConfigurationInput, opts ...request.Option) (*UpdateLicenseConfigurationOutput, error) {
	req, out := c.UpdateLicenseConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLicenseSpecificationsForResource = "UpdateLicenseSpecificationsForResource"

// UpdateLicenseSpecificationsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLicenseSpecificationsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLicenseSpecificationsForResource for more information on using the UpdateLicenseSpecificationsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateLicenseSpecificationsForResourceRequest method.
//    req, resp := client.UpdateLicenseSpecificationsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseSpecificationsForResource
func (c *LicenseManager) UpdateLicenseSpecificationsForResourceRequest(input *UpdateLicenseSpecificationsForResourceInput) (req *request.Request, output *UpdateLicenseSpecificationsForResourceOutput) {
	op := &request.Operation{
		Name:       opUpdateLicenseSpecificationsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLicenseSpecificationsForResourceInput{}
	}

	output = &UpdateLicenseSpecificationsForResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateLicenseSpecificationsForResource API operation for AWS License Manager.
//
// Adds or removes the specified license configurations for the specified AWS
// resource.
//
// You can update the license specifications of AMIs, instances, and hosts.
// You cannot update the license specifications for launch templates and AWS
// CloudFormation templates, as they send license configurations to the operation
// that creates the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager's
// API operation UpdateLicenseSpecificationsForResource for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameter values are not valid.
//
//   * InvalidResourceStateException
//   License Manager cannot allocate a license to a resource because of its state.
//
//   For example, you cannot allocate a license to an instance in the process
//   of shutting down.
//
//   * LicenseUsageException
//   You do not have enough licenses available to support a new resource launch.
//
//   * ServerInternalException
//   The server experienced an internal error. Try again.
//
//   * AuthorizationException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * AccessDeniedException
//   Access to resource denied.
//
//   * RateLimitExceededException
//   Too many requests have been submitted. Try again after a brief wait.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseSpecificationsForResource
func (c *LicenseManager) UpdateLicenseSpecificationsForResource(input *UpdateLicenseSpecificationsForResourceInput) (*UpdateLicenseSpecificationsForResourceOutput, error) {
	req, out := c.UpdateLicenseSpecificationsForResourceRequest(input)
	return out, req.Send()
}

// UpdateLicenseSpecificationsForResourceWithContext is the same as UpdateLicenseSpecificationsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLicenseSpecificationsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManager) UpdateLicenseSpecificationsForResourceWithContext(ctx aws.Context, input *UpdateLicenseSpecificationsForResourceInput, opts ...request.Option) (*UpdateLicenseSpecificationsForResourceOutput, error) {
	req, out := c.UpdateLicenseSpecificationsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServiceSettings = "UpdateServiceSettings"

// UpdateServiceSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServiceSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServiceSettings for more information on using the UpdateServiceSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateServiceSettingsRequest method.
//    req, resp := client.UpdateServiceSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateServiceSettings
func (c *LicenseManager) UpdateServiceSettingsRequest(input *UpdateServiceSettingsInput) (req *request.Request, output *UpdateServiceSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateServiceSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceSettingsInput{}
	}

	output = &UpdateServiceSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateServiceSettings API operation for AWS License Manager.
//
// Updates License Manager settings for the current Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS License Manager's
// API operation UpdateServiceSettings for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameter values are not valid.
//
//   * ServerInternalException
//   The server experienced an internal error. Try again.
//
//   * AuthorizationException
//   The AWS user account does not have permission to perform the action. Check
//   the IAM policy associated with this account.
//
//   * AccessDeniedException
//   Access to resource denied.
//
//   * RateLimitExceededException
//   Too many requests have been submitted. Try again after a brief wait.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateServiceSettings
func (c *LicenseManager) UpdateServiceSettings(input *UpdateServiceSettingsInput) (*UpdateServiceSettingsOutput, error) {
	req, out := c.UpdateServiceSettingsRequest(input)
	return out, req.Send()
}

// UpdateServiceSettingsWithContext is the same as UpdateServiceSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServiceSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LicenseManager) UpdateServiceSettingsWithContext(ctx aws.Context, input *UpdateServiceSettingsInput, opts ...request.Option) (*UpdateServiceSettingsOutput, error) {
	req, out := c.UpdateServiceSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access to resource denied.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The AWS user account does not have permission to perform the action. Check
// the IAM policy associated with this account.
type AuthorizationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AuthorizationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizationException) GoString() string {
	return s.String()
}

func newErrorAuthorizationException(v protocol.ResponseMetadata) error {
	return &AuthorizationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AuthorizationException) Code() string {
	return "AuthorizationException"
}

// Message returns the exception's message.
func (s *AuthorizationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AuthorizationException) OrigErr() error {
	return nil
}

func (s *AuthorizationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AuthorizationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AuthorizationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes automated discovery.
type AutomatedDiscoveryInformation struct {
	_ struct{} `type:"structure"`

	// Time that automated discovery last ran.
	LastRunTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s AutomatedDiscoveryInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutomatedDiscoveryInformation) GoString() string {
	return s.String()
}

// SetLastRunTime sets the LastRunTime field's value.
func (s *AutomatedDiscoveryInformation) SetLastRunTime(v time.Time) *AutomatedDiscoveryInformation {
	s.LastRunTime = &v
	return s
}

// Details about license consumption.
type ConsumedLicenseSummary struct {
	_ struct{} `type:"structure"`

	// Number of licenses consumed by the resource.
	ConsumedLicenses *int64 `type:"long"`

	// Resource type of the resource consuming a license.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s ConsumedLicenseSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConsumedLicenseSummary) GoString() string {
	return s.String()
}

// SetConsumedLicenses sets the ConsumedLicenses field's value.
func (s *ConsumedLicenseSummary) SetConsumedLicenses(v int64) *ConsumedLicenseSummary {
	s.ConsumedLicenses = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ConsumedLicenseSummary) SetResourceType(v string) *ConsumedLicenseSummary {
	s.ResourceType = &v
	return s
}

type CreateLicenseConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Description of the license configuration.
	Description *string `type:"string"`

	// Number of licenses managed by the license configuration.
	LicenseCount *int64 `type:"long"`

	// Indicates whether hard or soft license enforcement is used. Exceeding a hard
	// limit blocks the launch of new instances.
	LicenseCountHardLimit *bool `type:"boolean"`

	// Dimension used to track the license inventory.
	//
	// LicenseCountingType is a required field
	LicenseCountingType *string `type:"string" required:"true" enum:"LicenseCountingType"`

	// License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost).
	// The available rules vary by dimension, as follows.
	//
	//    * Cores dimension: allowedTenancy | licenseAffinityToHost | maximumCores
	//    | minimumCores
	//
	//    * Instances dimension: allowedTenancy | maximumCores | minimumCores |
	//    maximumSockets | minimumSockets | maximumVcpus | minimumVcpus
	//
	//    * Sockets dimension: allowedTenancy | licenseAffinityToHost | maximumSockets
	//    | minimumSockets
	//
	//    * vCPUs dimension: allowedTenancy | honorVcpuOptimization | maximumVcpus
	//    | minimumVcpus
	//
	// The unit for licenseAffinityToHost is days and the range is 1 to 180. The
	// possible values for allowedTenancy are EC2-Default, EC2-DedicatedHost, and
	// EC2-DedicatedInstance. The possible values for honorVcpuOptimization are
	// True and False.
	LicenseRules []*string `type:"list"`

	// Name of the license configuration.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Product information.
	ProductInformationList []*ProductInformation `type:"list"`

	// Tags to add to the license configuration.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateLicenseConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLicenseConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLicenseConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLicenseConfigurationInput"}
	if s.LicenseCountingType == nil {
		invalidParams.Add(request.NewErrParamRequired("LicenseCountingType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ProductInformationList != nil {
		for i, v := range s.ProductInformationList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ProductInformationList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateLicenseConfigurationInput) SetDescription(v string) *CreateLicenseConfigurationInput {
	s.Description = &v
	return s
}

// SetLicenseCount sets the LicenseCount field's value.
func (s *CreateLicenseConfigurationInput) SetLicenseCount(v int64) *CreateLicenseConfigurationInput {
	s.LicenseCount = &v
	return s
}

// SetLicenseCountHardLimit sets the LicenseCountHardLimit field's value.
func (s *CreateLicenseConfigurationInput) SetLicenseCountHardLimit(v bool) *CreateLicenseConfigurationInput {
	s.LicenseCountHardLimit = &v
	return s
}

// SetLicenseCountingType sets the LicenseCountingType field's value.
func (s *CreateLicenseConfigurationInput) SetLicenseCountingType(v string) *CreateLicenseConfigurationInput {
	s.LicenseCountingType = &v
	return s
}

// SetLicenseRules sets the LicenseRules field's value.
func (s *CreateLicenseConfigurationInput) SetLicenseRules(v []*string) *CreateLicenseConfigurationInput {
	s.LicenseRules = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateLicenseConfigurationInput) SetName(v string) *CreateLicenseConfigurationInput {
	s.Name = &v
	return s
}

// SetProductInformationList sets the ProductInformationList field's value.
func (s *CreateLicenseConfigurationInput) SetProductInformationList(v []*ProductInformation) *CreateLicenseConfigurationInput {
	s.ProductInformationList = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLicenseConfigurationInput) SetTags(v []*Tag) *CreateLicenseConfigurationInput {
	s.Tags = v
	return s
}

type CreateLicenseConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the license configuration.
	LicenseConfigurationArn *string `type:"string"`
}

// String returns the string representation
func (s CreateLicenseConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLicenseConfigurationOutput) GoString() string {
	return s.String()
}

// SetLicenseConfigurationArn sets the LicenseConfigurationArn field's value.
func (s *CreateLicenseConfigurationOutput) SetLicenseConfigurationArn(v string) *CreateLicenseConfigurationOutput {
	s.LicenseConfigurationArn = &v
	return s
}

type DeleteLicenseConfigurationInput struct {
	_ struct{} `type:"structure"`

	// ID of the license configuration.
	//
	// LicenseConfigurationArn is a required field
	LicenseConfigurationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLicenseConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLicenseConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLicenseConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLicenseConfigurationInput"}
	if s.LicenseConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LicenseConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLicenseConfigurationArn sets the LicenseConfigurationArn field's value.
func (s *DeleteLicenseConfigurationInput) SetLicenseConfigurationArn(v string) *DeleteLicenseConfigurationInput {
	s.LicenseConfigurationArn = &v
	return s
}

type DeleteLicenseConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLicenseConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLicenseConfigurationOutput) GoString() string {
	return s.String()
}

// A dependency required to run the API is missing.
type FailedDependencyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s FailedDependencyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedDependencyException) GoString() string {
	return s.String()
}

func newErrorFailedDependencyException(v protocol.ResponseMetadata) error {
	return &FailedDependencyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *FailedDependencyException) Code() string {
	return "FailedDependencyException"
}

// Message returns the exception's message.
func (s *FailedDependencyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *FailedDependencyException) OrigErr() error {
	return nil
}

func (s *FailedDependencyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *FailedDependencyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *FailedDependencyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A filter name and value pair that is used to return more specific results
// from a describe operation. Filters can be used to match a set of resources
// by specific criteria, such as tags, attributes, or IDs.
type Filter struct {
	_ struct{} `type:"structure"`

	// Name of the filter. Filter names are case-sensitive.
	Name *string `type:"string"`

	// Filter values. Filter values are case-sensitive.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

// The request uses too many filters or too many filter values.
type FilterLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s FilterLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterLimitExceededException) GoString() string {
	return s.String()
}

func newErrorFilterLimitExceededException(v protocol.ResponseMetadata) error {
	return &FilterLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *FilterLimitExceededException) Code() string {
	return "FilterLimitExceededException"
}

// Message returns the exception's message.
func (s *FilterLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *FilterLimitExceededException) OrigErr() error {
	return nil
}

func (s *FilterLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *FilterLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *FilterLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetLicenseConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the license configuration.
	//
	// LicenseConfigurationArn is a required field
	LicenseConfigurationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetLicenseConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLicenseConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLicenseConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLicenseConfigurationInput"}
	if s.LicenseConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LicenseConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLicenseConfigurationArn sets the LicenseConfigurationArn field's value.
func (s *GetLicenseConfigurationInput) SetLicenseConfigurationArn(v string) *GetLicenseConfigurationInput {
	s.LicenseConfigurationArn = &v
	return s
}

type GetLicenseConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Automated discovery information.
	AutomatedDiscoveryInformation *AutomatedDiscoveryInformation `type:"structure"`

	// Summaries of the licenses consumed by resources.
	ConsumedLicenseSummaryList []*ConsumedLicenseSummary `type:"list"`

	// Number of licenses assigned to resources.
	ConsumedLicenses *int64 `type:"long"`

	// Description of the license configuration.
	Description *string `type:"string"`

	// Amazon Resource Name (ARN) of the license configuration.
	LicenseConfigurationArn *string `type:"string"`

	// Unique ID for the license configuration.
	LicenseConfigurationId *string `type:"string"`

	// Number of available licenses.
	LicenseCount *int64 `type:"long"`

	// Sets the number of available licenses as a hard limit.
	LicenseCountHardLimit *bool `type:"boolean"`

	// Dimension on which the licenses are counted.
	LicenseCountingType *string `type:"string" enum:"LicenseCountingType"`

	// License rules.
	LicenseRules []*string `type:"list"`

	// Summaries of the managed resources.
	ManagedResourceSummaryList []*ManagedResourceSummary `type:"list"`

	// Name of the license configuration.
	Name *string `type:"string"`

	// Account ID of the owner of the license configuration.
	OwnerAccountId *string `type:"string"`

	// Product information.
	ProductInformationList []*ProductInformation `type:"list"`

	// License configuration status.
	Status *string `type:"string"`

	// Tags for the license configuration.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s GetLicenseConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLicenseConfigurationOutput) GoString() string {
	return s.String()
}

// SetAutomatedDiscoveryInformation sets the AutomatedDiscoveryInformation field's value.
func (s *GetLicenseConfigurationOutput) SetAutomatedDiscoveryInformation(v *AutomatedDiscoveryInformation) *GetLicenseConfigurationOutput {
	s.AutomatedDiscoveryInformation = v
	return s
}

// SetConsumedLicenseSummaryList sets the ConsumedLicenseSummaryList field's value.
func (s *GetLicenseConfigurationOutput) SetConsumedLicenseSummaryList(v []*ConsumedLicenseSummary) *GetLicenseConfigurationOutput {
	s.ConsumedLicenseSummaryList = v
	return s
}

// SetConsumedLicenses sets the ConsumedLicenses field's value.
func (s *GetLicenseConfigurationOutput) SetConsumedLicenses(v int64) *GetLicenseConfigurationOutput {
	s.ConsumedLicenses = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetLicenseConfigurationOutput) SetDescription(v string) *GetLicenseConfigurationOutput {
	s.Description = &v
	return s
}

// SetLicenseConfigurationArn sets the LicenseConfigurationArn field's value.
func (s *GetLicenseConfigurationOutput) SetLicenseConfigurationArn(v string) *GetLicenseConfigurationOutput {
	s.LicenseConfigurationArn = &v
	return s
}

// SetLicenseConfigurationId sets the LicenseConfigurationId field's value.
func (s *GetLicenseConfigurationOutput) SetLicenseConfigurationId(v string) *GetLicenseConfigurationOutput {
	s.LicenseConfigurationId = &v
	return s
}

// SetLicenseCount sets the LicenseCount field's value.
func (s *GetLicenseConfigurationOutput) SetLicenseCount(v int64) *GetLicenseConfigurationOutput {
	s.LicenseCount = &v
	return s
}

// SetLicenseCountHardLimit sets the LicenseCountHardLimit field's value.
func (s *GetLicenseConfigurationOutput) SetLicenseCountHardLimit(v bool) *GetLicenseConfigurationOutput {
	s.LicenseCountHardLimit = &v
	return s
}

// SetLicenseCountingType sets the LicenseCountingType field's value.
func (s *GetLicenseConfigurationOutput) SetLicenseCountingType(v string) *GetLicenseConfigurationOutput {
	s.LicenseCountingType = &v
	return s
}

// SetLicenseRules sets the LicenseRules field's value.
func (s *GetLicenseConfigurationOutput) SetLicenseRules(v []*string) *GetLicenseConfigurationOutput {
	s.LicenseRules = v
	return s
}

// SetManagedResourceSummaryList sets the ManagedResourceSummaryList field's value.
func (s *GetLicenseConfigurationOutput) SetManagedResourceSummaryList(v []*ManagedResourceSummary) *GetLicenseConfigurationOutput {
	s.ManagedResourceSummaryList = v
	return s
}

// SetName sets the Name field's value.
func (s *GetLicenseConfigurationOutput) SetName(v string) *GetLicenseConfigurationOutput {
	s.Name = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *GetLicenseConfigurationOutput) SetOwnerAccountId(v string) *GetLicenseConfigurationOutput {
	s.OwnerAccountId = &v
	return s
}

// SetProductInformationList sets the ProductInformationList field's value.
func (s *GetLicenseConfigurationOutput) SetProductInformationList(v []*ProductInformation) *GetLicenseConfigurationOutput {
	s.ProductInformationList = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetLicenseConfigurationOutput) SetStatus(v string) *GetLicenseConfigurationOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetLicenseConfigurationOutput) SetTags(v []*Tag) *GetLicenseConfigurationOutput {
	s.Tags = v
	return s
}

type GetServiceSettingsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetServiceSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceSettingsInput) GoString() string {
	return s.String()
}

type GetServiceSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether cross-account discovery has been enabled.
	EnableCrossAccountsDiscovery *bool `type:"boolean"`

	// Amazon Resource Name (ARN) of the AWS resource share. The License Manager
	// master account will provide member accounts with access to this share.
	LicenseManagerResourceShareArn *string `type:"string"`

	// Indicates whether AWS Organizations has been integrated with License Manager
	// for cross-account discovery.
	OrganizationConfiguration *OrganizationConfiguration `type:"structure"`

	// Regional S3 bucket path for storing reports, license trail event data, discovery
	// data, and so on.
	S3BucketArn *string `type:"string"`

	// SNS topic configured to receive notifications from License Manager.
	SnsTopicArn *string `type:"string"`
}

// String returns the string representation
func (s GetServiceSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceSettingsOutput) GoString() string {
	return s.String()
}

// SetEnableCrossAccountsDiscovery sets the EnableCrossAccountsDiscovery field's value.
func (s *GetServiceSettingsOutput) SetEnableCrossAccountsDiscovery(v bool) *GetServiceSettingsOutput {
	s.EnableCrossAccountsDiscovery = &v
	return s
}

// SetLicenseManagerResourceShareArn sets the LicenseManagerResourceShareArn field's value.
func (s *GetServiceSettingsOutput) SetLicenseManagerResourceShareArn(v string) *GetServiceSettingsOutput {
	s.LicenseManagerResourceShareArn = &v
	return s
}

// SetOrganizationConfiguration sets the OrganizationConfiguration field's value.
func (s *GetServiceSettingsOutput) SetOrganizationConfiguration(v *OrganizationConfiguration) *GetServiceSettingsOutput {
	s.OrganizationConfiguration = v
	return s
}

// SetS3BucketArn sets the S3BucketArn field's value.
func (s *GetServiceSettingsOutput) SetS3BucketArn(v string) *GetServiceSettingsOutput {
	s.S3BucketArn = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *GetServiceSettingsOutput) SetSnsTopicArn(v string) *GetServiceSettingsOutput {
	s.SnsTopicArn = &v
	return s
}

// One or more parameter values are not valid.
type InvalidParameterValueException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidParameterValueException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterValueException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterValueException(v protocol.ResponseMetadata) error {
	return &InvalidParameterValueException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterValueException) Code() string {
	return "InvalidParameterValueException"
}

// Message returns the exception's message.
func (s *InvalidParameterValueException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterValueException) OrigErr() error {
	return nil
}

func (s *InvalidParameterValueException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterValueException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterValueException) RequestID() string {
	return s.RespMetadata.RequestID
}

// License Manager cannot allocate a license to a resource because of its state.
//
// For example, you cannot allocate a license to an instance in the process
// of shutting down.
type InvalidResourceStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidResourceStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidResourceStateException) GoString() string {
	return s.String()
}

func newErrorInvalidResourceStateException(v protocol.ResponseMetadata) error {
	return &InvalidResourceStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidResourceStateException) Code() string {
	return "InvalidResourceStateException"
}

// Message returns the exception's message.
func (s *InvalidResourceStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidResourceStateException) OrigErr() error {
	return nil
}

func (s *InvalidResourceStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidResourceStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidResourceStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An inventory filter.
type InventoryFilter struct {
	_ struct{} `type:"structure"`

	// Condition of the filter.
	//
	// Condition is a required field
	Condition *string `type:"string" required:"true" enum:"InventoryFilterCondition"`

	// Name of the filter.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Value of the filter.
	Value *string `type:"string"`
}

// String returns the string representation
func (s InventoryFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InventoryFilter"}
	if s.Condition == nil {
		invalidParams.Add(request.NewErrParamRequired("Condition"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *InventoryFilter) SetCondition(v string) *InventoryFilter {
	s.Condition = &v
	return s
}

// SetName sets the Name field's value.
func (s *InventoryFilter) SetName(v string) *InventoryFilter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *InventoryFilter) SetValue(v string) *InventoryFilter {
	s.Value = &v
	return s
}

// A license configuration is an abstraction of a customer license agreement
// that can be consumed and enforced by License Manager. Components include
// specifications for the license type (licensing by instance, socket, CPU,
// or vCPU), allowed tenancy (shared tenancy, Dedicated Instance, Dedicated
// Host, or all of these), host affinity (how long a VM must be associated with
// a host), and the number of licenses purchased and used.
type LicenseConfiguration struct {
	_ struct{} `type:"structure"`

	// Automated discovery information.
	AutomatedDiscoveryInformation *AutomatedDiscoveryInformation `type:"structure"`

	// Summaries for licenses consumed by various resources.
	ConsumedLicenseSummaryList []*ConsumedLicenseSummary `type:"list"`

	// Number of licenses consumed.
	ConsumedLicenses *int64 `type:"long"`

	// Description of the license configuration.
	Description *string `type:"string"`

	// Amazon Resource Name (ARN) of the license configuration.
	LicenseConfigurationArn *string `type:"string"`

	// Unique ID of the license configuration.
	LicenseConfigurationId *string `type:"string"`

	// Number of licenses managed by the license configuration.
	LicenseCount *int64 `type:"long"`

	// Number of available licenses as a hard limit.
	LicenseCountHardLimit *bool `type:"boolean"`

	// Dimension to use to track the license inventory.
	LicenseCountingType *string `type:"string" enum:"LicenseCountingType"`

	// License rules.
	LicenseRules []*string `type:"list"`

	// Summaries for managed resources.
	ManagedResourceSummaryList []*ManagedResourceSummary `type:"list"`

	// Name of the license configuration.
	Name *string `type:"string"`

	// Account ID of the license configuration's owner.
	OwnerAccountId *string `type:"string"`

	// Product information.
	ProductInformationList []*ProductInformation `type:"list"`

	// Status of the license configuration.
	Status *string `type:"string"`
}

// String returns the string representation
func (s LicenseConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LicenseConfiguration) GoString() string {
	return s.String()
}

// SetAutomatedDiscoveryInformation sets the AutomatedDiscoveryInformation field's value.
func (s *LicenseConfiguration) SetAutomatedDiscoveryInformation(v *AutomatedDiscoveryInformation) *LicenseConfiguration {
	s.AutomatedDiscoveryInformation = v
	return s
}

// SetConsumedLicenseSummaryList sets the ConsumedLicenseSummaryList field's value.
func (s *LicenseConfiguration) SetConsumedLicenseSummaryList(v []*ConsumedLicenseSummary) *LicenseConfiguration {
	s.ConsumedLicenseSummaryList = v
	return s
}

// SetConsumedLicenses sets the ConsumedLicenses field's value.
func (s *LicenseConfiguration) SetConsumedLicenses(v int64) *LicenseConfiguration {
	s.ConsumedLicenses = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *LicenseConfiguration) SetDescription(v string) *LicenseConfiguration {
	s.Description = &v
	return s
}

// SetLicenseConfigurationArn sets the LicenseConfigurationArn field's value.
func (s *LicenseConfiguration) SetLicenseConfigurationArn(v string) *LicenseConfiguration {
	s.LicenseConfigurationArn = &v
	return s
}

// SetLicenseConfigurationId sets the LicenseConfigurationId field's value.
func (s *LicenseConfiguration) SetLicenseConfigurationId(v string) *LicenseConfiguration {
	s.LicenseConfigurationId = &v
	return s
}

// SetLicenseCount sets the LicenseCount field's value.
func (s *LicenseConfiguration) SetLicenseCount(v int64) *LicenseConfiguration {
	s.LicenseCount = &v
	return s
}

// SetLicenseCountHardLimit sets the LicenseCountHardLimit field's value.
func (s *LicenseConfiguration) SetLicenseCountHardLimit(v bool) *LicenseConfiguration {
	s.LicenseCountHardLimit = &v
	return s
}

// SetLicenseCountingType sets the LicenseCountingType field's value.
func (s *LicenseConfiguration) SetLicenseCountingType(v string) *LicenseConfiguration {
	s.LicenseCountingType = &v
	return s
}

// SetLicenseRules sets the LicenseRules field's value.
func (s *LicenseConfiguration) SetLicenseRules(v []*string) *LicenseConfiguration {
	s.LicenseRules = v
	return s
}

// SetManagedResourceSummaryList sets the ManagedResourceSummaryList field's value.
func (s *LicenseConfiguration) SetManagedResourceSummaryList(v []*ManagedResourceSummary) *LicenseConfiguration {
	s.ManagedResourceSummaryList = v
	return s
}

// SetName sets the Name field's value.
func (s *LicenseConfiguration) SetName(v string) *LicenseConfiguration {
	s.Name = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *LicenseConfiguration) SetOwnerAccountId(v string) *LicenseConfiguration {
	s.OwnerAccountId = &v
	return s
}

// SetProductInformationList sets the ProductInformationList field's value.
func (s *LicenseConfiguration) SetProductInformationList(v []*ProductInformation) *LicenseConfiguration {
	s.ProductInformationList = v
	return s
}

// SetStatus sets the Status field's value.
func (s *LicenseConfiguration) SetStatus(v string) *LicenseConfiguration {
	s.Status = &v
	return s
}

// Describes an association with a license configuration.
type LicenseConfigurationAssociation struct {
	_ struct{} `type:"structure"`

	// Time when the license configuration was associated with the resource.
	AssociationTime *time.Time `type:"timestamp"`

	// Amazon Resource Name (ARN) of the resource.
	ResourceArn *string `type:"string"`

	// ID of the AWS account that owns the resource consuming licenses.
	ResourceOwnerId *string `type:"string"`

	// Type of server resource.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s LicenseConfigurationAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LicenseConfigurationAssociation) GoString() string {
	return s.String()
}

// SetAssociationTime sets the AssociationTime field's value.
func (s *LicenseConfigurationAssociation) SetAssociationTime(v time.Time) *LicenseConfigurationAssociation {
	s.AssociationTime = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *LicenseConfigurationAssociation) SetResourceArn(v string) *LicenseConfigurationAssociation {
	s.ResourceArn = &v
	return s
}

// SetResourceOwnerId sets the ResourceOwnerId field's value.
func (s *LicenseConfigurationAssociation) SetResourceOwnerId(v string) *LicenseConfigurationAssociation {
	s.ResourceOwnerId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *LicenseConfigurationAssociation) SetResourceType(v string) *LicenseConfigurationAssociation {
	s.ResourceType = &v
	return s
}

// Details about the usage of a resource associated with a license configuration.
type LicenseConfigurationUsage struct {
	_ struct{} `type:"structure"`

	// Time when the license configuration was initially associated with the resource.
	AssociationTime *time.Time `type:"timestamp"`

	// Number of licenses consumed by the resource.
	ConsumedLicenses *int64 `type:"long"`

	// Amazon Resource Name (ARN) of the resource.
	ResourceArn *string `type:"string"`

	// ID of the account that owns the resource.
	ResourceOwnerId *string `type:"string"`

	// Status of the resource.
	ResourceStatus *string `type:"string"`

	// Type of resource.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s LicenseConfigurationUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LicenseConfigurationUsage) GoString() string {
	return s.String()
}

// SetAssociationTime sets the AssociationTime field's value.
func (s *LicenseConfigurationUsage) SetAssociationTime(v time.Time) *LicenseConfigurationUsage {
	s.AssociationTime = &v
	return s
}

// SetConsumedLicenses sets the ConsumedLicenses field's value.
func (s *LicenseConfigurationUsage) SetConsumedLicenses(v int64) *LicenseConfigurationUsage {
	s.ConsumedLicenses = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *LicenseConfigurationUsage) SetResourceArn(v string) *LicenseConfigurationUsage {
	s.ResourceArn = &v
	return s
}

// SetResourceOwnerId sets the ResourceOwnerId field's value.
func (s *LicenseConfigurationUsage) SetResourceOwnerId(v string) *LicenseConfigurationUsage {
	s.ResourceOwnerId = &v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *LicenseConfigurationUsage) SetResourceStatus(v string) *LicenseConfigurationUsage {
	s.ResourceStatus = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *LicenseConfigurationUsage) SetResourceType(v string) *LicenseConfigurationUsage {
	s.ResourceType = &v
	return s
}

// Describes the failure of a license operation.
type LicenseOperationFailure struct {
	_ struct{} `type:"structure"`

	// Error message.
	ErrorMessage *string `type:"string"`

	// Failure time.
	FailureTime *time.Time `type:"timestamp"`

	// Reserved.
	MetadataList []*Metadata `type:"list"`

	// Name of the operation.
	OperationName *string `type:"string"`

	// The requester is "License Manager Automated Discovery".
	OperationRequestedBy *string `type:"string"`

	// Amazon Resource Name (ARN) of the resource.
	ResourceArn *string `type:"string"`

	// ID of the AWS account that owns the resource.
	ResourceOwnerId *string `type:"string"`

	// Resource type.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s LicenseOperationFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LicenseOperationFailure) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *LicenseOperationFailure) SetErrorMessage(v string) *LicenseOperationFailure {
	s.ErrorMessage = &v
	return s
}

// SetFailureTime sets the FailureTime field's value.
func (s *LicenseOperationFailure) SetFailureTime(v time.Time) *LicenseOperationFailure {
	s.FailureTime = &v
	return s
}

// SetMetadataList sets the MetadataList field's value.
func (s *LicenseOperationFailure) SetMetadataList(v []*Metadata) *LicenseOperationFailure {
	s.MetadataList = v
	return s
}

// SetOperationName sets the OperationName field's value.
func (s *LicenseOperationFailure) SetOperationName(v string) *LicenseOperationFailure {
	s.OperationName = &v
	return s
}

// SetOperationRequestedBy sets the OperationRequestedBy field's value.
func (s *LicenseOperationFailure) SetOperationRequestedBy(v string) *LicenseOperationFailure {
	s.OperationRequestedBy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *LicenseOperationFailure) SetResourceArn(v string) *LicenseOperationFailure {
	s.ResourceArn = &v
	return s
}

// SetResourceOwnerId sets the ResourceOwnerId field's value.
func (s *LicenseOperationFailure) SetResourceOwnerId(v string) *LicenseOperationFailure {
	s.ResourceOwnerId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *LicenseOperationFailure) SetResourceType(v string) *LicenseOperationFailure {
	s.ResourceType = &v
	return s
}

// Details for associating a license configuration with a resource.
type LicenseSpecification struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the license configuration.
	//
	// LicenseConfigurationArn is a required field
	LicenseConfigurationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LicenseSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LicenseSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LicenseSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LicenseSpecification"}
	if s.LicenseConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LicenseConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLicenseConfigurationArn sets the LicenseConfigurationArn field's value.
func (s *LicenseSpecification) SetLicenseConfigurationArn(v string) *LicenseSpecification {
	s.LicenseConfigurationArn = &v
	return s
}

// You do not have enough licenses available to support a new resource launch.
type LicenseUsageException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s LicenseUsageException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LicenseUsageException) GoString() string {
	return s.String()
}

func newErrorLicenseUsageException(v protocol.ResponseMetadata) error {
	return &LicenseUsageException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LicenseUsageException) Code() string {
	return "LicenseUsageException"
}

// Message returns the exception's message.
func (s *LicenseUsageException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LicenseUsageException) OrigErr() error {
	return nil
}

func (s *LicenseUsageException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LicenseUsageException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LicenseUsageException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAssociationsForLicenseConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of a license configuration.
	//
	// LicenseConfigurationArn is a required field
	LicenseConfigurationArn *string `type:"string" required:"true"`

	// Maximum number of results to return in a single call.
	MaxResults *int64 `type:"integer"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAssociationsForLicenseConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociationsForLicenseConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociationsForLicenseConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssociationsForLicenseConfigurationInput"}
	if s.LicenseConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LicenseConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLicenseConfigurationArn sets the LicenseConfigurationArn field's value.
func (s *ListAssociationsForLicenseConfigurationInput) SetLicenseConfigurationArn(v string) *ListAssociationsForLicenseConfigurationInput {
	s.LicenseConfigurationArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssociationsForLicenseConfigurationInput) SetMaxResults(v int64) *ListAssociationsForLicenseConfigurationInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociationsForLicenseConfigurationInput) SetNextToken(v string) *ListAssociationsForLicenseConfigurationInput {
	s.NextToken = &v
	return s
}

type ListAssociationsForLicenseConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the associations for the license configuration.
	LicenseConfigurationAssociations []*LicenseConfigurationAssociation `type:"list"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAssociationsForLicenseConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociationsForLicenseConfigurationOutput) GoString() string {
	return s.String()
}

// SetLicenseConfigurationAssociations sets the LicenseConfigurationAssociations field's value.
func (s *ListAssociationsForLicenseConfigurationOutput) SetLicenseConfigurationAssociations(v []*LicenseConfigurationAssociation) *ListAssociationsForLicenseConfigurationOutput {
	s.LicenseConfigurationAssociations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociationsForLicenseConfigurationOutput) SetNextToken(v string) *ListAssociationsForLicenseConfigurationOutput {
	s.NextToken = &v
	return s
}

type ListFailuresForLicenseConfigurationOperationsInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name of the license configuration.
	//
	// LicenseConfigurationArn is a required field
	LicenseConfigurationArn *string `type:"string" required:"true"`

	// Maximum number of results to return in a single call.
	MaxResults *int64 `type:"integer"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListFailuresForLicenseConfigurationOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFailuresForLicenseConfigurationOperationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFailuresForLicenseConfigurationOperationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFailuresForLicenseConfigurationOperationsInput"}
	if s.LicenseConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LicenseConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLicenseConfigurationArn sets the LicenseConfigurationArn field's value.
func (s *ListFailuresForLicenseConfigurationOperationsInput) SetLicenseConfigurationArn(v string) *ListFailuresForLicenseConfigurationOperationsInput {
	s.LicenseConfigurationArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFailuresForLicenseConfigurationOperationsInput) SetMaxResults(v int64) *ListFailuresForLicenseConfigurationOperationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFailuresForLicenseConfigurationOperationsInput) SetNextToken(v string) *ListFailuresForLicenseConfigurationOperationsInput {
	s.NextToken = &v
	return s
}

type ListFailuresForLicenseConfigurationOperationsOutput struct {
	_ struct{} `type:"structure"`

	// License configuration operations that failed.
	LicenseOperationFailureList []*LicenseOperationFailure `type:"list"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListFailuresForLicenseConfigurationOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFailuresForLicenseConfigurationOperationsOutput) GoString() string {
	return s.String()
}

// SetLicenseOperationFailureList sets the LicenseOperationFailureList field's value.
func (s *ListFailuresForLicenseConfigurationOperationsOutput) SetLicenseOperationFailureList(v []*LicenseOperationFailure) *ListFailuresForLicenseConfigurationOperationsOutput {
	s.LicenseOperationFailureList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFailuresForLicenseConfigurationOperationsOutput) SetNextToken(v string) *ListFailuresForLicenseConfigurationOperationsOutput {
	s.NextToken = &v
	return s
}

type ListLicenseConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// Filters to scope the results. The following filters and logical operators
	// are supported:
	//
	//    * licenseCountingType - The dimension on which licenses are counted. Possible
	//    values are vCPU | Instance | Core | Socket. Logical operators are EQUALS
	//    | NOT_EQUALS.
	//
	//    * enforceLicenseCount - A Boolean value that indicates whether hard license
	//    enforcement is used. Logical operators are EQUALS | NOT_EQUALS.
	//
	//    * usagelimitExceeded - A Boolean value that indicates whether the available
	//    licenses have been exceeded. Logical operators are EQUALS | NOT_EQUALS.
	Filters []*Filter `type:"list"`

	// Amazon Resource Names (ARN) of the license configurations.
	LicenseConfigurationArns []*string `type:"list"`

	// Maximum number of results to return in a single call.
	MaxResults *int64 `type:"integer"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLicenseConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLicenseConfigurationsInput) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *ListLicenseConfigurationsInput) SetFilters(v []*Filter) *ListLicenseConfigurationsInput {
	s.Filters = v
	return s
}

// SetLicenseConfigurationArns sets the LicenseConfigurationArns field's value.
func (s *ListLicenseConfigurationsInput) SetLicenseConfigurationArns(v []*string) *ListLicenseConfigurationsInput {
	s.LicenseConfigurationArns = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLicenseConfigurationsInput) SetMaxResults(v int64) *ListLicenseConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLicenseConfigurationsInput) SetNextToken(v string) *ListLicenseConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListLicenseConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the license configurations.
	LicenseConfigurations []*LicenseConfiguration `type:"list"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLicenseConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLicenseConfigurationsOutput) GoString() string {
	return s.String()
}

// SetLicenseConfigurations sets the LicenseConfigurations field's value.
func (s *ListLicenseConfigurationsOutput) SetLicenseConfigurations(v []*LicenseConfiguration) *ListLicenseConfigurationsOutput {
	s.LicenseConfigurations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLicenseConfigurationsOutput) SetNextToken(v string) *ListLicenseConfigurationsOutput {
	s.NextToken = &v
	return s
}

type ListLicenseSpecificationsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return in a single call.
	MaxResults *int64 `type:"integer"`

	// Token for the next set of results.
	NextToken *string `type:"string"`

	// Amazon Resource Name (ARN) of a resource that has an associated license configuration.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListLicenseSpecificationsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLicenseSpecificationsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLicenseSpecificationsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLicenseSpecificationsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLicenseSpecificationsForResourceInput) SetMaxResults(v int64) *ListLicenseSpecificationsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLicenseSpecificationsForResourceInput) SetNextToken(v string) *ListLicenseSpecificationsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListLicenseSpecificationsForResourceInput) SetResourceArn(v string) *ListLicenseSpecificationsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListLicenseSpecificationsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// License configurations associated with a resource.
	LicenseSpecifications []*LicenseSpecification `type:"list"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLicenseSpecificationsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLicenseSpecificationsForResourceOutput) GoString() string {
	return s.String()
}

// SetLicenseSpecifications sets the LicenseSpecifications field's value.
func (s *ListLicenseSpecificationsForResourceOutput) SetLicenseSpecifications(v []*LicenseSpecification) *ListLicenseSpecificationsForResourceOutput {
	s.LicenseSpecifications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLicenseSpecificationsForResourceOutput) SetNextToken(v string) *ListLicenseSpecificationsForResourceOutput {
	s.NextToken = &v
	return s
}

type ListResourceInventoryInput struct {
	_ struct{} `type:"structure"`

	// Filters to scope the results. The following filters and logical operators
	// are supported:
	//
	//    * account_id - The ID of the AWS account that owns the resource. Logical
	//    operators are EQUALS | NOT_EQUALS.
	//
	//    * application_name - The name of the application. Logical operators are
	//    EQUALS | BEGINS_WITH.
	//
	//    * license_included - The type of license included. Logical operators are
	//    EQUALS | NOT_EQUALS. Possible values are sql-server-enterprise | sql-server-standard
	//    | sql-server-web | windows-server-datacenter.
	//
	//    * platform - The platform of the resource. Logical operators are EQUALS
	//    | BEGINS_WITH.
	//
	//    * resource_id - The ID of the resource. Logical operators are EQUALS |
	//    NOT_EQUALS.
	Filters []*InventoryFilter `type:"list"`

	// Maximum number of results to return in a single call.
	MaxResults *int64 `type:"integer"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResourceInventoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceInventoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceInventoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceInventoryInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListResourceInventoryInput) SetFilters(v []*InventoryFilter) *ListResourceInventoryInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceInventoryInput) SetMaxResults(v int64) *ListResourceInventoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceInventoryInput) SetNextToken(v string) *ListResourceInventoryInput {
	s.NextToken = &v
	return s
}

type ListResourceInventoryOutput struct {
	_ struct{} `type:"structure"`

	// Token for the next set of results.
	NextToken *string `type:"string"`

	// Information about the resources.
	ResourceInventoryList []*ResourceInventory `type:"list"`
}

// String returns the string representation
func (s ListResourceInventoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceInventoryOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceInventoryOutput) SetNextToken(v string) *ListResourceInventoryOutput {
	s.NextToken = &v
	return s
}

// SetResourceInventoryList sets the ResourceInventoryList field's value.
func (s *ListResourceInventoryOutput) SetResourceInventoryList(v []*ResourceInventory) *ListResourceInventoryOutput {
	s.ResourceInventoryList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the license configuration.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the tags.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListUsageForLicenseConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Filters to scope the results. The following filters and logical operators
	// are supported:
	//
	//    * resourceArn - The ARN of the license configuration resource. Logical
	//    operators are EQUALS | NOT_EQUALS.
	//
	//    * resourceType - The resource type (EC2_INSTANCE | EC2_HOST | EC2_AMI
	//    | SYSTEMS_MANAGER_MANAGED_INSTANCE). Logical operators are EQUALS | NOT_EQUALS.
	//
	//    * resourceAccount - The ID of the account that owns the resource. Logical
	//    operators are EQUALS | NOT_EQUALS.
	Filters []*Filter `type:"list"`

	// Amazon Resource Name (ARN) of the license configuration.
	//
	// LicenseConfigurationArn is a required field
	LicenseConfigurationArn *string `type:"string" required:"true"`

	// Maximum number of results to return in a single call.
	MaxResults *int64 `type:"integer"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListUsageForLicenseConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsageForLicenseConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsageForLicenseConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsageForLicenseConfigurationInput"}
	if s.LicenseConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LicenseConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListUsageForLicenseConfigurationInput) SetFilters(v []*Filter) *ListUsageForLicenseConfigurationInput {
	s.Filters = v
	return s
}

// SetLicenseConfigurationArn sets the LicenseConfigurationArn field's value.
func (s *ListUsageForLicenseConfigurationInput) SetLicenseConfigurationArn(v string) *ListUsageForLicenseConfigurationInput {
	s.LicenseConfigurationArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsageForLicenseConfigurationInput) SetMaxResults(v int64) *ListUsageForLicenseConfigurationInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsageForLicenseConfigurationInput) SetNextToken(v string) *ListUsageForLicenseConfigurationInput {
	s.NextToken = &v
	return s
}

type ListUsageForLicenseConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the license configurations.
	LicenseConfigurationUsageList []*LicenseConfigurationUsage `type:"list"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListUsageForLicenseConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsageForLicenseConfigurationOutput) GoString() string {
	return s.String()
}

// SetLicenseConfigurationUsageList sets the LicenseConfigurationUsageList field's value.
func (s *ListUsageForLicenseConfigurationOutput) SetLicenseConfigurationUsageList(v []*LicenseConfigurationUsage) *ListUsageForLicenseConfigurationOutput {
	s.LicenseConfigurationUsageList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsageForLicenseConfigurationOutput) SetNextToken(v string) *ListUsageForLicenseConfigurationOutput {
	s.NextToken = &v
	return s
}

// Summary information about a managed resource.
type ManagedResourceSummary struct {
	_ struct{} `type:"structure"`

	// Number of resources associated with licenses.
	AssociationCount *int64 `type:"long"`

	// Type of resource associated with a license.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s ManagedResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ManagedResourceSummary) GoString() string {
	return s.String()
}

// SetAssociationCount sets the AssociationCount field's value.
func (s *ManagedResourceSummary) SetAssociationCount(v int64) *ManagedResourceSummary {
	s.AssociationCount = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ManagedResourceSummary) SetResourceType(v string) *ManagedResourceSummary {
	s.ResourceType = &v
	return s
}

// Reserved.
type Metadata struct {
	_ struct{} `type:"structure"`

	// Reserved.
	Name *string `type:"string"`

	// Reserved.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Metadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Metadata) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Metadata) SetName(v string) *Metadata {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Metadata) SetValue(v string) *Metadata {
	s.Value = &v
	return s
}

// Configuration information for AWS Organizations.
type OrganizationConfiguration struct {
	_ struct{} `type:"structure"`

	// Enables AWS Organization integration.
	//
	// EnableIntegration is a required field
	EnableIntegration *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s OrganizationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OrganizationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OrganizationConfiguration"}
	if s.EnableIntegration == nil {
		invalidParams.Add(request.NewErrParamRequired("EnableIntegration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableIntegration sets the EnableIntegration field's value.
func (s *OrganizationConfiguration) SetEnableIntegration(v bool) *OrganizationConfiguration {
	s.EnableIntegration = &v
	return s
}

// Describes product information for a license configuration.
type ProductInformation struct {
	_ struct{} `type:"structure"`

	// Product information filters.
	//
	// The following filters and logical operators are supported when the resource
	// type is SSM_MANAGED:
	//
	//    * Application Name - The name of the application. Logical operator is
	//    EQUALS.
	//
	//    * Application Publisher - The publisher of the application. Logical operator
	//    is EQUALS.
	//
	//    * Application Version - The version of the application. Logical operator
	//    is EQUALS.
	//
	//    * Platform Name - The name of the platform. Logical operator is EQUALS.
	//
	//    * Platform Type - The platform type. Logical operator is EQUALS.
	//
	//    * License Included - The type of license included. Logical operators are
	//    EQUALS and NOT_EQUALS. Possible values are: sql-server-enterprise | sql-server-standard
	//    | sql-server-web | windows-server-datacenter.
	//
	// The following filters and logical operators are supported when the resource
	// type is RDS:
	//
	//    * Engine Edition - The edition of the database engine. Logical operator
	//    is EQUALS. Possible values are: oracle-ee | oracle-se | oracle-se1 | oracle-se2.
	//
	//    * License Pack - The license pack. Logical operator is EQUALS. Possible
	//    values are: data guard | diagnostic pack sqlt | tuning pack sqlt | ols
	//    | olap.
	//
	// ProductInformationFilterList is a required field
	ProductInformationFilterList []*ProductInformationFilter `type:"list" required:"true"`

	// Resource type. The possible values are SSM_MANAGED | RDS.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ProductInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProductInformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProductInformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProductInformation"}
	if s.ProductInformationFilterList == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductInformationFilterList"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ProductInformationFilterList != nil {
		for i, v := range s.ProductInformationFilterList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ProductInformationFilterList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProductInformationFilterList sets the ProductInformationFilterList field's value.
func (s *ProductInformation) SetProductInformationFilterList(v []*ProductInformationFilter) *ProductInformation {
	s.ProductInformationFilterList = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ProductInformation) SetResourceType(v string) *ProductInformation {
	s.ResourceType = &v
	return s
}

// Describes product information filters.
type ProductInformationFilter struct {
	_ struct{} `type:"structure"`

	// Logical operator.
	//
	// ProductInformationFilterComparator is a required field
	ProductInformationFilterComparator *string `type:"string" required:"true"`

	// Filter name.
	//
	// ProductInformationFilterName is a required field
	ProductInformationFilterName *string `type:"string" required:"true"`

	// Filter value.
	//
	// ProductInformationFilterValue is a required field
	ProductInformationFilterValue []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s ProductInformationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProductInformationFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProductInformationFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProductInformationFilter"}
	if s.ProductInformationFilterComparator == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductInformationFilterComparator"))
	}
	if s.ProductInformationFilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductInformationFilterName"))
	}
	if s.ProductInformationFilterValue == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductInformationFilterValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProductInformationFilterComparator sets the ProductInformationFilterComparator field's value.
func (s *ProductInformationFilter) SetProductInformationFilterComparator(v string) *ProductInformationFilter {
	s.ProductInformationFilterComparator = &v
	return s
}

// SetProductInformationFilterName sets the ProductInformationFilterName field's value.
func (s *ProductInformationFilter) SetProductInformationFilterName(v string) *ProductInformationFilter {
	s.ProductInformationFilterName = &v
	return s
}

// SetProductInformationFilterValue sets the ProductInformationFilterValue field's value.
func (s *ProductInformationFilter) SetProductInformationFilterValue(v []*string) *ProductInformationFilter {
	s.ProductInformationFilterValue = v
	return s
}

// Too many requests have been submitted. Try again after a brief wait.
type RateLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s RateLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RateLimitExceededException) GoString() string {
	return s.String()
}

func newErrorRateLimitExceededException(v protocol.ResponseMetadata) error {
	return &RateLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RateLimitExceededException) Code() string {
	return "RateLimitExceededException"
}

// Message returns the exception's message.
func (s *RateLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RateLimitExceededException) OrigErr() error {
	return nil
}

func (s *RateLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RateLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RateLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about a resource.
type ResourceInventory struct {
	_ struct{} `type:"structure"`

	// Platform of the resource.
	Platform *string `type:"string"`

	// Platform version of the resource in the inventory.
	PlatformVersion *string `type:"string"`

	// Amazon Resource Name (ARN) of the resource.
	ResourceArn *string `type:"string"`

	// ID of the resource.
	ResourceId *string `type:"string"`

	// ID of the account that owns the resource.
	ResourceOwningAccountId *string `type:"string"`

	// Type of resource.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s ResourceInventory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceInventory) GoString() string {
	return s.String()
}

// SetPlatform sets the Platform field's value.
func (s *ResourceInventory) SetPlatform(v string) *ResourceInventory {
	s.Platform = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *ResourceInventory) SetPlatformVersion(v string) *ResourceInventory {
	s.PlatformVersion = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ResourceInventory) SetResourceArn(v string) *ResourceInventory {
	s.ResourceArn = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ResourceInventory) SetResourceId(v string) *ResourceInventory {
	s.ResourceId = &v
	return s
}

// SetResourceOwningAccountId sets the ResourceOwningAccountId field's value.
func (s *ResourceInventory) SetResourceOwningAccountId(v string) *ResourceInventory {
	s.ResourceOwningAccountId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceInventory) SetResourceType(v string) *ResourceInventory {
	s.ResourceType = &v
	return s
}

// Your resource limits have been exceeded.
type ResourceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The server experienced an internal error. Try again.
type ServerInternalException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServerInternalException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerInternalException) GoString() string {
	return s.String()
}

func newErrorServerInternalException(v protocol.ResponseMetadata) error {
	return &ServerInternalException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServerInternalException) Code() string {
	return "ServerInternalException"
}

// Message returns the exception's message.
func (s *ServerInternalException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServerInternalException) OrigErr() error {
	return nil
}

func (s *ServerInternalException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServerInternalException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServerInternalException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about a tag for a license configuration.
type Tag struct {
	_ struct{} `type:"structure"`

	// Tag key.
	Key *string `type:"string"`

	// Tag value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the license configuration.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// One or more tags.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the license configuration.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// Keys identifying the tags to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateLicenseConfigurationInput struct {
	_ struct{} `type:"structure"`

	// New description of the license configuration.
	Description *string `type:"string"`

	// Amazon Resource Name (ARN) of the license configuration.
	//
	// LicenseConfigurationArn is a required field
	LicenseConfigurationArn *string `type:"string" required:"true"`

	// New status of the license configuration.
	LicenseConfigurationStatus *string `type:"string" enum:"LicenseConfigurationStatus"`

	// New number of licenses managed by the license configuration.
	LicenseCount *int64 `type:"long"`

	// New hard limit of the number of available licenses.
	LicenseCountHardLimit *bool `type:"boolean"`

	// New license rule. The only rule that you can add after you create a license
	// configuration is licenseAffinityToHost.
	LicenseRules []*string `type:"list"`

	// New name of the license configuration.
	Name *string `type:"string"`

	// New product information.
	ProductInformationList []*ProductInformation `type:"list"`
}

// String returns the string representation
func (s UpdateLicenseConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLicenseConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLicenseConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLicenseConfigurationInput"}
	if s.LicenseConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LicenseConfigurationArn"))
	}
	if s.ProductInformationList != nil {
		for i, v := range s.ProductInformationList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ProductInformationList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateLicenseConfigurationInput) SetDescription(v string) *UpdateLicenseConfigurationInput {
	s.Description = &v
	return s
}

// SetLicenseConfigurationArn sets the LicenseConfigurationArn field's value.
func (s *UpdateLicenseConfigurationInput) SetLicenseConfigurationArn(v string) *UpdateLicenseConfigurationInput {
	s.LicenseConfigurationArn = &v
	return s
}

// SetLicenseConfigurationStatus sets the LicenseConfigurationStatus field's value.
func (s *UpdateLicenseConfigurationInput) SetLicenseConfigurationStatus(v string) *UpdateLicenseConfigurationInput {
	s.LicenseConfigurationStatus = &v
	return s
}

// SetLicenseCount sets the LicenseCount field's value.
func (s *UpdateLicenseConfigurationInput) SetLicenseCount(v int64) *UpdateLicenseConfigurationInput {
	s.LicenseCount = &v
	return s
}

// SetLicenseCountHardLimit sets the LicenseCountHardLimit field's value.
func (s *UpdateLicenseConfigurationInput) SetLicenseCountHardLimit(v bool) *UpdateLicenseConfigurationInput {
	s.LicenseCountHardLimit = &v
	return s
}

// SetLicenseRules sets the LicenseRules field's value.
func (s *UpdateLicenseConfigurationInput) SetLicenseRules(v []*string) *UpdateLicenseConfigurationInput {
	s.LicenseRules = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateLicenseConfigurationInput) SetName(v string) *UpdateLicenseConfigurationInput {
	s.Name = &v
	return s
}

// SetProductInformationList sets the ProductInformationList field's value.
func (s *UpdateLicenseConfigurationInput) SetProductInformationList(v []*ProductInformation) *UpdateLicenseConfigurationInput {
	s.ProductInformationList = v
	return s
}

type UpdateLicenseConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateLicenseConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLicenseConfigurationOutput) GoString() string {
	return s.String()
}

type UpdateLicenseSpecificationsForResourceInput struct {
	_ struct{} `type:"structure"`

	// ARNs of the license configurations to add.
	AddLicenseSpecifications []*LicenseSpecification `type:"list"`

	// ARNs of the license configurations to remove.
	RemoveLicenseSpecifications []*LicenseSpecification `type:"list"`

	// Amazon Resource Name (ARN) of the AWS resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateLicenseSpecificationsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLicenseSpecificationsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLicenseSpecificationsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLicenseSpecificationsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.AddLicenseSpecifications != nil {
		for i, v := range s.AddLicenseSpecifications {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddLicenseSpecifications", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RemoveLicenseSpecifications != nil {
		for i, v := range s.RemoveLicenseSpecifications {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RemoveLicenseSpecifications", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddLicenseSpecifications sets the AddLicenseSpecifications field's value.
func (s *UpdateLicenseSpecificationsForResourceInput) SetAddLicenseSpecifications(v []*LicenseSpecification) *UpdateLicenseSpecificationsForResourceInput {
	s.AddLicenseSpecifications = v
	return s
}

// SetRemoveLicenseSpecifications sets the RemoveLicenseSpecifications field's value.
func (s *UpdateLicenseSpecificationsForResourceInput) SetRemoveLicenseSpecifications(v []*LicenseSpecification) *UpdateLicenseSpecificationsForResourceInput {
	s.RemoveLicenseSpecifications = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UpdateLicenseSpecificationsForResourceInput) SetResourceArn(v string) *UpdateLicenseSpecificationsForResourceInput {
	s.ResourceArn = &v
	return s
}

type UpdateLicenseSpecificationsForResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateLicenseSpecificationsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLicenseSpecificationsForResourceOutput) GoString() string {
	return s.String()
}

type UpdateServiceSettingsInput struct {
	_ struct{} `type:"structure"`

	// Activates cross-account discovery.
	EnableCrossAccountsDiscovery *bool `type:"boolean"`

	// Enables integration with AWS Organizations for cross-account discovery.
	OrganizationConfiguration *OrganizationConfiguration `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager
	// information is stored.
	S3BucketArn *string `type:"string"`

	// Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager
	// alerts.
	SnsTopicArn *string `type:"string"`
}

// String returns the string representation
func (s UpdateServiceSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceSettingsInput"}
	if s.OrganizationConfiguration != nil {
		if err := s.OrganizationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OrganizationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableCrossAccountsDiscovery sets the EnableCrossAccountsDiscovery field's value.
func (s *UpdateServiceSettingsInput) SetEnableCrossAccountsDiscovery(v bool) *UpdateServiceSettingsInput {
	s.EnableCrossAccountsDiscovery = &v
	return s
}

// SetOrganizationConfiguration sets the OrganizationConfiguration field's value.
func (s *UpdateServiceSettingsInput) SetOrganizationConfiguration(v *OrganizationConfiguration) *UpdateServiceSettingsInput {
	s.OrganizationConfiguration = v
	return s
}

// SetS3BucketArn sets the S3BucketArn field's value.
func (s *UpdateServiceSettingsInput) SetS3BucketArn(v string) *UpdateServiceSettingsInput {
	s.S3BucketArn = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *UpdateServiceSettingsInput) SetSnsTopicArn(v string) *UpdateServiceSettingsInput {
	s.SnsTopicArn = &v
	return s
}

type UpdateServiceSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateServiceSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceSettingsOutput) GoString() string {
	return s.String()
}

const (
	// InventoryFilterConditionEquals is a InventoryFilterCondition enum value
	InventoryFilterConditionEquals = "EQUALS"

	// InventoryFilterConditionNotEquals is a InventoryFilterCondition enum value
	InventoryFilterConditionNotEquals = "NOT_EQUALS"

	// InventoryFilterConditionBeginsWith is a InventoryFilterCondition enum value
	InventoryFilterConditionBeginsWith = "BEGINS_WITH"

	// InventoryFilterConditionContains is a InventoryFilterCondition enum value
	InventoryFilterConditionContains = "CONTAINS"
)

// InventoryFilterCondition_Values returns all elements of the InventoryFilterCondition enum
func InventoryFilterCondition_Values() []string {
	return []string{
		InventoryFilterConditionEquals,
		InventoryFilterConditionNotEquals,
		InventoryFilterConditionBeginsWith,
		InventoryFilterConditionContains,
	}
}

const (
	// LicenseConfigurationStatusAvailable is a LicenseConfigurationStatus enum value
	LicenseConfigurationStatusAvailable = "AVAILABLE"

	// LicenseConfigurationStatusDisabled is a LicenseConfigurationStatus enum value
	LicenseConfigurationStatusDisabled = "DISABLED"
)

// LicenseConfigurationStatus_Values returns all elements of the LicenseConfigurationStatus enum
func LicenseConfigurationStatus_Values() []string {
	return []string{
		LicenseConfigurationStatusAvailable,
		LicenseConfigurationStatusDisabled,
	}
}

const (
	// LicenseCountingTypeVCpu is a LicenseCountingType enum value
	LicenseCountingTypeVCpu = "vCPU"

	// LicenseCountingTypeInstance is a LicenseCountingType enum value
	LicenseCountingTypeInstance = "Instance"

	// LicenseCountingTypeCore is a LicenseCountingType enum value
	LicenseCountingTypeCore = "Core"

	// LicenseCountingTypeSocket is a LicenseCountingType enum value
	LicenseCountingTypeSocket = "Socket"
)

// LicenseCountingType_Values returns all elements of the LicenseCountingType enum
func LicenseCountingType_Values() []string {
	return []string{
		LicenseCountingTypeVCpu,
		LicenseCountingTypeInstance,
		LicenseCountingTypeCore,
		LicenseCountingTypeSocket,
	}
}

const (
	// ResourceTypeEc2Instance is a ResourceType enum value
	ResourceTypeEc2Instance = "EC2_INSTANCE"

	// ResourceTypeEc2Host is a ResourceType enum value
	ResourceTypeEc2Host = "EC2_HOST"

	// ResourceTypeEc2Ami is a ResourceType enum value
	ResourceTypeEc2Ami = "EC2_AMI"

	// ResourceTypeRds is a ResourceType enum value
	ResourceTypeRds = "RDS"

	// ResourceTypeSystemsManagerManagedInstance is a ResourceType enum value
	ResourceTypeSystemsManagerManagedInstance = "SYSTEMS_MANAGER_MANAGED_INSTANCE"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeEc2Instance,
		ResourceTypeEc2Host,
		ResourceTypeEc2Ami,
		ResourceTypeRds,
		ResourceTypeSystemsManagerManagedInstance,
	}
}
