/* client.c generated by valac 0.46.3, the Vala compiler
 * generated from client.vala, do not modify */

/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2010  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>

#define PASANG_TYPE_NETWORK_PLAYER (pasang_network_player_get_type ())
#define PASANG_NETWORK_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_NETWORK_PLAYER, PasangNetworkPlayer))
#define PASANG_NETWORK_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_NETWORK_PLAYER, PasangNetworkPlayerClass))
#define PASANG_IS_NETWORK_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_NETWORK_PLAYER))
#define PASANG_IS_NETWORK_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_NETWORK_PLAYER))
#define PASANG_NETWORK_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_NETWORK_PLAYER, PasangNetworkPlayerClass))

typedef struct _PasangNetworkPlayer PasangNetworkPlayer;
typedef struct _PasangNetworkPlayerClass PasangNetworkPlayerClass;
typedef struct _PasangNetworkPlayerPrivate PasangNetworkPlayerPrivate;
enum  {
	PASANG_NETWORK_PLAYER_0_PROPERTY,
	PASANG_NETWORK_PLAYER_NUM_PROPERTIES
};
static GParamSpec* pasang_network_player_properties[PASANG_NETWORK_PLAYER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define PASANG_TYPE_CLIENT (pasang_client_get_type ())
#define PASANG_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_CLIENT, PasangClient))
#define PASANG_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_CLIENT, PasangClientClass))
#define PASANG_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_CLIENT))
#define PASANG_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_CLIENT))
#define PASANG_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_CLIENT, PasangClientClass))

typedef struct _PasangClient PasangClient;
typedef struct _PasangClientClass PasangClientClass;
typedef struct _PasangClientPrivate PasangClientPrivate;
enum  {
	PASANG_CLIENT_0_PROPERTY,
	PASANG_CLIENT_NUM_PROPERTIES
};
static GParamSpec* pasang_client_properties[PASANG_CLIENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PasangClientDispatcherData PasangClientDispatcherData;
typedef struct _PasangClientLoginData PasangClientLoginData;
typedef struct _PasangClientLogoutData PasangClientLogoutData;
typedef struct _PasangClientProcessMessagesData PasangClientProcessMessagesData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
enum  {
	PASANG_CLIENT_ON_JOIN_GAME_SIGNAL,
	PASANG_CLIENT_ON_LEAVE_GAME_SIGNAL,
	PASANG_CLIENT_ON_MOVE_RECEIVED_SIGNAL,
	PASANG_CLIENT_NUM_SIGNALS
};
static guint pasang_client_signals[PASANG_CLIENT_NUM_SIGNALS] = {0};

struct _PasangNetworkPlayer {
	GObject parent_instance;
	PasangNetworkPlayerPrivate * priv;
	glong id;
	gchar* name;
};

struct _PasangNetworkPlayerClass {
	GObjectClass parent_class;
};

struct _PasangClient {
	GObject parent_instance;
	PasangClientPrivate * priv;
	GtkWidget* menu;
	gchar* opponent_name;
};

struct _PasangClientClass {
	GObjectClass parent_class;
};

struct _PasangClientPrivate {
	GtkWindow* parent;
	GListStore* player_list;
	GtkEntry* server_address_entry;
	GtkEntry* server_port_entry;
	GtkEntry* user_name_entry;
	GtkInfoBar* status_info_bar;
	GtkLabel* status_info;
	gchar* error_message;
	GCancellable* dispatcher_cancellable;
	GQueue* dispatcher_queue;
	GSocketConnection* connection;
	GDataInputStream* input;
	GDataOutputStream* output;
	glong id;
	gchar* user_name;
	glong opponent_id;
	glong challenged_id;
};

struct _PasangClientDispatcherData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PasangClient* self;
	GCancellable* _tmp0_;
	gboolean _tmp1_;
	GQueue* _tmp2_;
	GSocketConnection* _tmp3_;
	GQueue* _tmp4_;
	gpointer _tmp5_;
	gchar* _tmp6_;
	GQuark _tmp8_;
};

struct _PasangClientLoginData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PasangClient* self;
	gchar* server_name;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* user_name;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gint server_port;
	GtkEntry* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GSocketConnection* _tmp16_;
	GResolver* resolver;
	GResolver* _tmp17_;
	GList* addresses;
	GResolver* _tmp18_;
	const gchar* _tmp19_;
	GCancellable* _tmp20_;
	GList* _tmp21_;
	GInetAddress* address;
	GList* _tmp22_;
	gconstpointer _tmp23_;
	GInetAddress* _tmp24_;
	GInetAddress* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GInetSocketAddress* socket_address;
	GInetAddress* _tmp28_;
	GInetSocketAddress* _tmp29_;
	GSocketClient* client;
	GSocketClient* _tmp30_;
	GSocketConnection* _tmp31_;
	GSocketClient* _tmp32_;
	GInetSocketAddress* _tmp33_;
	GCancellable* _tmp34_;
	GSocketConnection* _tmp35_;
	GSocketConnection* _tmp36_;
	GSocketConnection* _tmp37_;
	GInputStream* _tmp38_;
	GInputStream* _tmp39_;
	GDataInputStream* _tmp40_;
	GSocketConnection* _tmp41_;
	GOutputStream* _tmp42_;
	GOutputStream* _tmp43_;
	GDataOutputStream* _tmp44_;
	GtkEntry* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	GError* err_cancelled;
	GError* err;
	GError* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	GError* _inner_error0_;
};

struct _PasangClientLogoutData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PasangClient* self;
	GSocketConnection* _tmp0_;
	GSocketConnection* _tmp1_;
	GCancellable* _tmp2_;
	GError* err;
	FILE* _tmp3_;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GListStore* _tmp6_;
	GError* _inner_error0_;
};

struct _PasangClientProcessMessagesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PasangClient* self;
	GSocketConnection* _tmp0_;
	gchar* line;
	gsize length;
	gchar* _tmp1_;
	GDataInputStream* _tmp2_;
	GCancellable* _tmp3_;
	gsize _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GCancellable* _tmp12_;
	GCancellable* _tmp13_;
	gchar* _tmp14_;
	GError* err_cancelled;
	GError* err;
	FILE* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError* _inner_error0_;
};

struct _Block2Data {
	int _ref_count_;
	PasangClient* self;
	GtkSwitch* suis;
};

struct _Block3Data {
	int _ref_count_;
	PasangClient* self;
	GtkPopover* popover;
};

static gpointer pasang_network_player_parent_class = NULL;
static gint PasangClient_private_offset;
static gpointer pasang_client_parent_class = NULL;
extern gchar* pasang_reloc_exe_name;

GType pasang_network_player_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangNetworkPlayer, g_object_unref)
PasangNetworkPlayer* pasang_network_player_new (void);
PasangNetworkPlayer* pasang_network_player_construct (GType object_type);
static void pasang_network_player_finalize (GObject * obj);
GType pasang_client_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangClient, g_object_unref)
static void _g_free0_ (gpointer var);
static inline void _g_queue_free__g_free0_ (GQueue* self);
PasangClient* pasang_client_new (GtkWindow* window);
PasangClient* pasang_client_construct (GType object_type,
                                       GtkWindow* window);
static void pasang_client_create_menu (PasangClient* self);
static void pasang_client_dispatcher (PasangClient* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
static void pasang_client_dispatcher_finish (PasangClient* self,
                                      GAsyncResult* _res_);
static void pasang_client_send (PasangClient* self,
                         const gchar* message);
void pasang_client_send_move (PasangClient* self,
                              gint seq,
                              const gchar* move_notation);
void pasang_client_request_retreat (PasangClient* self);
void pasang_client_request_logout (PasangClient* self);
static void pasang_client_dispatch (PasangClient* self,
                             const gchar* command);
static void pasang_client_dispatcher_data_free (gpointer _data);
static gboolean pasang_client_dispatcher_co (PasangClientDispatcherData* _data_);
void pasang_util_wait_async (gint millisecs,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
void pasang_util_wait_finish (GAsyncResult* _res_);
static void pasang_client_dispatcher_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
static void pasang_client_login (PasangClient* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
static void pasang_client_login_finish (PasangClient* self,
                                 GAsyncResult* _res_);
static void pasang_client_logout (PasangClient* self,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_);
static void pasang_client_logout_finish (PasangClient* self,
                                  GAsyncResult* _res_);
static void pasang_client_process_messages (PasangClient* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void pasang_client_process_messages_finish (PasangClient* self,
                                            GAsyncResult* _res_);
static void pasang_client_login_data_free (gpointer _data);
static gboolean pasang_client_login_co (PasangClientLoginData* _data_);
static void pasang_client_login_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
void pasang_client_update_status (PasangClient* self);
static void pasang_client_logout_data_free (gpointer _data);
static gboolean pasang_client_logout_co (PasangClientLogoutData* _data_);
static void pasang_client_logout_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_);
static void pasang_client_process_messages_data_free (gpointer _data);
static gboolean pasang_client_process_messages_co (PasangClientProcessMessagesData* _data_);
static void pasang_client_process_messages_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void pasang_client_interpret (PasangClient* self,
                              const gchar* line,
                              GError** error);
static gchar* pasang_client_sanitize (PasangClient* self,
                               const gchar* s);
static void pasang_client_login_accepted (PasangClient* self,
                                   const gchar* login_info,
                                   GError** error);
static void pasang_client_login_refused (PasangClient* self);
static void pasang_client_remote_user_registered (PasangClient* self,
                                           const gchar* user_info);
static void pasang_client_remote_user_deregistered (PasangClient* self,
                                             const gchar* id_string);
static void pasang_client_opponent_booked (PasangClient* self,
                                    const gchar* id_string);
static void pasang_client_play_ended (PasangClient* self);
static void pasang_client_move_received (PasangClient* self,
                                  const gchar* arg);
static void pasang_client_remote_user_status_changed (PasangClient* self,
                                               glong remote_user_id,
                                               gboolean available,
                                               const gchar* remote_user_name);
static gboolean pasang_client_accept_challenge (PasangClient* self,
                                         const gchar* challenger);
GtkWidget* pasang_game_menu_create_item (const gchar* text,
                                         GtkWidget* widget);
static GtkWidget* pasang_client_create_server_setter_button (PasangClient* self);
static GtkWidget* __lambda12_ (PasangClient* self,
                        GObject* p);
static GtkWidget* ___lambda12__gtk_list_box_create_widget_func (GObject* item,
                                                         gpointer self);
static void __lambda13_ (PasangClient* self,
                  GtkListBoxRow* row);
static void ___lambda13__gtk_list_box_row_activated (GtkListBox* _sender,
                                              GtkListBoxRow* row,
                                              gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static GtkBox* pasang_client_create_configuration_widget (PasangClient* self,
                                                   GtkPopover* popover);
static void __lambda10_ (Block2Data* _data2_);
static void ___lambda10__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda11_ (Block2Data* _data2_);
static void ___lambda11__gtk_popover_closed (GtkPopover* _sender,
                                      gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda7_ (Block3Data* _data3_);
static void ___lambda7__gtk_entry_activate (GtkEntry* _sender,
                                     gpointer self);
static void __lambda8_ (Block3Data* _data3_);
static void ___lambda8__gtk_entry_activate (GtkEntry* _sender,
                                     gpointer self);
static void __lambda9_ (Block3Data* _data3_);
static void ___lambda9__gtk_entry_activate (GtkEntry* _sender,
                                     gpointer self);
static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static void pasang_client_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

PasangNetworkPlayer*
pasang_network_player_construct (GType object_type)
{
	PasangNetworkPlayer * self = NULL;
#line 21 "client.vala"
	self = (PasangNetworkPlayer*) g_object_new (object_type, NULL);
#line 21 "client.vala"
	return self;
#line 428 "client.c"
}

PasangNetworkPlayer*
pasang_network_player_new (void)
{
#line 21 "client.vala"
	return pasang_network_player_construct (PASANG_TYPE_NETWORK_PLAYER);
#line 436 "client.c"
}

static void
pasang_network_player_class_init (PasangNetworkPlayerClass * klass,
                                  gpointer klass_data)
{
#line 21 "client.vala"
	pasang_network_player_parent_class = g_type_class_peek_parent (klass);
#line 21 "client.vala"
	G_OBJECT_CLASS (klass)->finalize = pasang_network_player_finalize;
#line 447 "client.c"
}

static void
pasang_network_player_instance_init (PasangNetworkPlayer * self,
                                     gpointer klass)
{
}

static void
pasang_network_player_finalize (GObject * obj)
{
	PasangNetworkPlayer * self;
#line 21 "client.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_NETWORK_PLAYER, PasangNetworkPlayer);
#line 23 "client.vala"
	_g_free0 (self->name);
#line 21 "client.vala"
	G_OBJECT_CLASS (pasang_network_player_parent_class)->finalize (obj);
#line 466 "client.c"
}

GType
pasang_network_player_get_type (void)
{
	static volatile gsize pasang_network_player_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_network_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangNetworkPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_network_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangNetworkPlayer), 0, (GInstanceInitFunc) pasang_network_player_instance_init, NULL };
		GType pasang_network_player_type_id;
		pasang_network_player_type_id = g_type_register_static (G_TYPE_OBJECT, "PasangNetworkPlayer", &g_define_type_info, 0);
		g_once_init_leave (&pasang_network_player_type_id__volatile, pasang_network_player_type_id);
	}
	return pasang_network_player_type_id__volatile;
}

static inline gpointer
pasang_client_get_instance_private (PasangClient* self)
{
	return G_STRUCT_MEMBER_P (self, PasangClient_private_offset);
}

static void
_g_free0_ (gpointer var)
{
#line 64 "client.vala"
	var = (g_free (var), NULL);
#line 493 "client.c"
}

static inline void
_g_queue_free__g_free0_ (GQueue* self)
{
#line 64 "client.vala"
	g_queue_free_full (self, (GDestroyNotify) _g_free0_);
#line 501 "client.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 83 "client.vala"
	return self ? g_object_ref (self) : NULL;
#line 509 "client.c"
}

PasangClient*
pasang_client_construct (GType object_type,
                         GtkWindow* window)
{
	PasangClient * self = NULL;
	GtkWindow* _tmp0_;
#line 82 "client.vala"
	g_return_val_if_fail (window != NULL, NULL);
#line 82 "client.vala"
	self = (PasangClient*) g_object_new (object_type, NULL);
#line 83 "client.vala"
	_tmp0_ = _g_object_ref0 (window);
#line 83 "client.vala"
	_g_object_unref0 (self->priv->parent);
#line 83 "client.vala"
	self->priv->parent = _tmp0_;
#line 84 "client.vala"
	pasang_client_create_menu (self);
#line 85 "client.vala"
	pasang_client_dispatcher (self, NULL, NULL);
#line 82 "client.vala"
	return self;
#line 534 "client.c"
}

PasangClient*
pasang_client_new (GtkWindow* window)
{
#line 82 "client.vala"
	return pasang_client_construct (PASANG_TYPE_CLIENT, window);
#line 542 "client.c"
}

static void
pasang_client_send (PasangClient* self,
                    const gchar* message)
{
	GSocketConnection* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 88 "client.vala"
	g_return_if_fail (self != NULL);
#line 88 "client.vala"
	g_return_if_fail (message != NULL);
#line 89 "client.vala"
	_tmp0_ = self->priv->connection;
#line 89 "client.vala"
	if (_tmp0_ != NULL) {
#line 559 "client.c"
		{
			GDataOutputStream* _tmp1_;
#line 91 "client.vala"
			_tmp1_ = self->priv->output;
#line 91 "client.vala"
			g_data_output_stream_put_string (_tmp1_, message, NULL, &_inner_error0_);
#line 91 "client.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 568 "client.c"
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			FILE* _tmp2_;
			GError* _tmp3_;
			const gchar* _tmp4_;
#line 90 "client.vala"
			err = _inner_error0_;
#line 90 "client.vala"
			_inner_error0_ = NULL;
#line 94 "client.vala"
			_tmp2_ = stderr;
#line 94 "client.vala"
			_tmp3_ = err;
#line 94 "client.vala"
			_tmp4_ = _tmp3_->message;
#line 94 "client.vala"
			fprintf (_tmp2_, "Send error: %s\n", _tmp4_);
#line 90 "client.vala"
			_g_error_free0 (err);
#line 593 "client.c"
		}
		__finally0:
#line 90 "client.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 90 "client.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 90 "client.vala"
			g_clear_error (&_inner_error0_);
#line 90 "client.vala"
			return;
#line 604 "client.c"
		}
	}
}

void
pasang_client_send_move (PasangClient* self,
                         gint seq,
                         const gchar* move_notation)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 99 "client.vala"
	g_return_if_fail (self != NULL);
#line 99 "client.vala"
	g_return_if_fail (move_notation != NULL);
#line 100 "client.vala"
	if (self->priv->opponent_id == ((glong) -1)) {
#line 100 "client.vala"
		return;
#line 624 "client.c"
	}
#line 101 "client.vala"
	_tmp0_ = g_strdup_printf ("MOVE %d %s\n", seq, move_notation);
#line 101 "client.vala"
	_tmp1_ = _tmp0_;
#line 101 "client.vala"
	pasang_client_send (self, _tmp1_);
#line 101 "client.vala"
	_g_free0 (_tmp1_);
#line 634 "client.c"
}

void
pasang_client_request_retreat (PasangClient* self)
{
#line 104 "client.vala"
	g_return_if_fail (self != NULL);
#line 105 "client.vala"
	self->priv->opponent_id = (glong) -1;
#line 106 "client.vala"
	pasang_client_send (self, "LEAVE\n");
#line 646 "client.c"
}

void
pasang_client_request_logout (PasangClient* self)
{
#line 109 "client.vala"
	g_return_if_fail (self != NULL);
#line 110 "client.vala"
	pasang_client_dispatch (self, "logout");
#line 656 "client.c"
}

static void
pasang_client_dispatch (PasangClient* self,
                        const gchar* command)
{
	GQueue* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 113 "client.vala"
	g_return_if_fail (self != NULL);
#line 113 "client.vala"
	g_return_if_fail (command != NULL);
#line 114 "client.vala"
	_tmp0_ = self->priv->dispatcher_queue;
#line 114 "client.vala"
	_tmp1_ = g_strdup (command);
#line 114 "client.vala"
	g_queue_push_tail (_tmp0_, _tmp1_);
#line 115 "client.vala"
	_tmp2_ = self->priv->dispatcher_cancellable;
#line 115 "client.vala"
	g_cancellable_cancel (_tmp2_);
#line 680 "client.c"
}

static void
pasang_client_dispatcher_data_free (gpointer _data)
{
	PasangClientDispatcherData* _data_;
	_data_ = _data;
#line 26 "client.vala"
	_g_object_unref0 (_data_->self);
#line 26 "client.vala"
	g_slice_free (PasangClientDispatcherData, _data_);
#line 692 "client.c"
}

static void
pasang_client_dispatcher (PasangClient* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	PasangClientDispatcherData* _data_;
	PasangClient* _tmp0_;
#line 26 "client.vala"
	_data_ = g_slice_new0 (PasangClientDispatcherData);
#line 26 "client.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 26 "client.vala"
	g_task_set_task_data (_data_->_async_result, _data_, pasang_client_dispatcher_data_free);
#line 26 "client.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 26 "client.vala"
	_data_->self = _tmp0_;
#line 26 "client.vala"
	pasang_client_dispatcher_co (_data_);
#line 714 "client.c"
}

static void
pasang_client_dispatcher_finish (PasangClient* self,
                                 GAsyncResult* _res_)
{
	PasangClientDispatcherData* _data_;
#line 26 "client.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 724 "client.c"
}

static void
pasang_client_dispatcher_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	PasangClientDispatcherData* _data_;
#line 125 "client.vala"
	_data_ = _user_data_;
#line 125 "client.vala"
	_data_->_source_object_ = source_object;
#line 125 "client.vala"
	_data_->_res_ = _res_;
#line 125 "client.vala"
	pasang_client_dispatcher_co (_data_);
#line 741 "client.c"
}

static gboolean
pasang_client_dispatcher_co (PasangClientDispatcherData* _data_)
{
#line 118 "client.vala"
	switch (_data_->_state_) {
#line 118 "client.vala"
		case 0:
#line 751 "client.c"
		goto _state_0;
#line 118 "client.vala"
		case 1:
#line 755 "client.c"
		goto _state_1;
#line 118 "client.vala"
		case 2:
#line 759 "client.c"
		goto _state_2;
#line 118 "client.vala"
		case 3:
#line 763 "client.c"
		goto _state_3;
#line 118 "client.vala"
		case 4:
#line 767 "client.c"
		goto _state_4;
		default:
#line 118 "client.vala"
		g_assert_not_reached ();
#line 772 "client.c"
	}
	_state_0:
#line 119 "client.vala"
	while (TRUE) {
#line 128 "client.vala"
		static GQuark _tmp7_label0 = 0;
#line 128 "client.vala"
		static GQuark _tmp7_label1 = 0;
#line 120 "client.vala"
		_data_->_tmp0_ = _data_->self->priv->dispatcher_cancellable;
#line 120 "client.vala"
		g_cancellable_reset (_data_->_tmp0_);
#line 121 "client.vala"
		_data_->_tmp2_ = _data_->self->priv->dispatcher_queue;
#line 121 "client.vala"
		if (g_queue_is_empty (_data_->_tmp2_)) {
#line 121 "client.vala"
			_data_->_tmp3_ = _data_->self->priv->connection;
#line 121 "client.vala"
			_data_->_tmp1_ = _data_->_tmp3_ == NULL;
#line 793 "client.c"
		} else {
#line 121 "client.vala"
			_data_->_tmp1_ = FALSE;
#line 797 "client.c"
		}
#line 121 "client.vala"
		if (_data_->_tmp1_) {
#line 125 "client.vala"
			_data_->_state_ = 1;
#line 125 "client.vala"
			pasang_util_wait_async (1000, pasang_client_dispatcher_ready, _data_);
#line 125 "client.vala"
			return FALSE;
#line 807 "client.c"
			_state_1:
#line 125 "client.vala"
			pasang_util_wait_finish (_data_->_res_);
#line 126 "client.vala"
			continue;
#line 813 "client.c"
		}
#line 128 "client.vala"
		_data_->_tmp4_ = _data_->self->priv->dispatcher_queue;
#line 128 "client.vala"
		_data_->_tmp5_ = g_queue_pop_head (_data_->_tmp4_);
#line 128 "client.vala"
		_data_->_tmp8_ = 0U;
#line 128 "client.vala"
		_data_->_tmp6_ = (gchar*) _data_->_tmp5_;
#line 128 "client.vala"
		_data_->_tmp8_ = (NULL == _data_->_tmp6_) ? 0 : g_quark_from_string (_data_->_tmp6_);
#line 128 "client.vala"
		g_free (_data_->_tmp6_);
#line 128 "client.vala"
		if (_data_->_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("login")))) {
#line 128 "client.vala"
			switch (0) {
#line 831 "client.c"
				default:
				{
#line 129 "client.vala"
					_data_->_state_ = 2;
#line 129 "client.vala"
					pasang_client_login (_data_->self, pasang_client_dispatcher_ready, _data_);
#line 129 "client.vala"
					return FALSE;
#line 840 "client.c"
					_state_2:
#line 129 "client.vala"
					pasang_client_login_finish (_data_->self, _data_->_res_);
#line 129 "client.vala"
					break;
#line 846 "client.c"
				}
			}
		} else if (_data_->_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("logout")))) {
#line 128 "client.vala"
			switch (0) {
#line 852 "client.c"
				default:
				{
#line 130 "client.vala"
					_data_->_state_ = 3;
#line 130 "client.vala"
					pasang_client_logout (_data_->self, pasang_client_dispatcher_ready, _data_);
#line 130 "client.vala"
					return FALSE;
#line 861 "client.c"
					_state_3:
#line 130 "client.vala"
					pasang_client_logout_finish (_data_->self, _data_->_res_);
#line 130 "client.vala"
					break;
#line 867 "client.c"
				}
			}
		} else {
#line 128 "client.vala"
			switch (0) {
#line 873 "client.c"
				default:
				{
#line 131 "client.vala"
					_data_->_state_ = 4;
#line 131 "client.vala"
					pasang_client_process_messages (_data_->self, pasang_client_dispatcher_ready, _data_);
#line 131 "client.vala"
					return FALSE;
#line 882 "client.c"
					_state_4:
#line 131 "client.vala"
					pasang_client_process_messages_finish (_data_->self, _data_->_res_);
#line 131 "client.vala"
					break;
#line 888 "client.c"
				}
			}
		}
	}
#line 118 "client.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 118 "client.vala"
	if (_data_->_state_ != 0) {
#line 118 "client.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 118 "client.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 901 "client.c"
		}
	}
#line 118 "client.vala"
	g_object_unref (_data_->_async_result);
#line 118 "client.vala"
	return FALSE;
#line 908 "client.c"
}

static void
pasang_client_login_data_free (gpointer _data)
{
	PasangClientLoginData* _data_;
	_data_ = _data;
#line 26 "client.vala"
	_g_object_unref0 (_data_->self);
#line 26 "client.vala"
	g_slice_free (PasangClientLoginData, _data_);
#line 920 "client.c"
}

static void
pasang_client_login (PasangClient* self,
                     GAsyncReadyCallback _callback_,
                     gpointer _user_data_)
{
	PasangClientLoginData* _data_;
	PasangClient* _tmp0_;
#line 26 "client.vala"
	_data_ = g_slice_new0 (PasangClientLoginData);
#line 26 "client.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 26 "client.vala"
	g_task_set_task_data (_data_->_async_result, _data_, pasang_client_login_data_free);
#line 26 "client.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 26 "client.vala"
	_data_->self = _tmp0_;
#line 26 "client.vala"
	pasang_client_login_co (_data_);
#line 942 "client.c"
}

static void
pasang_client_login_finish (PasangClient* self,
                            GAsyncResult* _res_)
{
	PasangClientLoginData* _data_;
#line 26 "client.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 952 "client.c"
}

/**
     * Attempt login.
     * input: server_address_entry, server_port_entry, user_name_entry
     * output: connection (null if fail), input, output
     * messages sent: LOGIN ...
     */
static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1307 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1308 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1308 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1309 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1310 "glib-2.0.vapi"
	result = _result_;
#line 1310 "glib-2.0.vapi"
	return result;
#line 979 "client.c"
}

static void
pasang_client_login_ready (GObject* source_object,
                           GAsyncResult* _res_,
                           gpointer _user_data_)
{
	PasangClientLoginData* _data_;
#line 157 "client.vala"
	_data_ = _user_data_;
#line 157 "client.vala"
	_data_->_source_object_ = source_object;
#line 157 "client.vala"
	_data_->_res_ = _res_;
#line 157 "client.vala"
	pasang_client_login_co (_data_);
#line 996 "client.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 164 "client.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1004 "client.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 164 "client.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 1012 "client.c"
}

static gboolean
pasang_client_login_co (PasangClientLoginData* _data_)
{
#line 142 "client.vala"
	switch (_data_->_state_) {
#line 142 "client.vala"
		case 0:
#line 1022 "client.c"
		goto _state_0;
#line 142 "client.vala"
		case 1:
#line 1026 "client.c"
		goto _state_1;
#line 142 "client.vala"
		case 2:
#line 1030 "client.c"
		goto _state_2;
#line 142 "client.vala"
		case 3:
#line 1034 "client.c"
		goto _state_3;
		default:
#line 142 "client.vala"
		g_assert_not_reached ();
#line 1039 "client.c"
	}
	_state_0:
#line 143 "client.vala"
	_data_->_tmp0_ = _data_->self->priv->server_address_entry;
#line 143 "client.vala"
	_data_->_tmp1_ = gtk_entry_get_text (_data_->_tmp0_);
#line 143 "client.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 143 "client.vala"
	_data_->_tmp3_ = string_strip (_data_->_tmp2_);
#line 143 "client.vala"
	_data_->server_name = _data_->_tmp3_;
#line 144 "client.vala"
	_data_->_tmp4_ = _data_->self->priv->user_name_entry;
#line 144 "client.vala"
	_data_->_tmp5_ = gtk_entry_get_text (_data_->_tmp4_);
#line 144 "client.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 144 "client.vala"
	_data_->_tmp7_ = string_strip (_data_->_tmp6_);
#line 144 "client.vala"
	_data_->user_name = _data_->_tmp7_;
#line 145 "client.vala"
	_data_->_tmp8_ = _data_->self->priv->server_port_entry;
#line 145 "client.vala"
	_data_->_tmp9_ = gtk_entry_get_text (_data_->_tmp8_);
#line 145 "client.vala"
	_data_->_tmp10_ = _data_->_tmp9_;
#line 145 "client.vala"
	_data_->server_port = atoi (_data_->_tmp10_);
#line 146 "client.vala"
	_data_->_tmp11_ = _data_->server_name;
#line 146 "client.vala"
	if (g_strcmp0 (_data_->_tmp11_, "") == 0) {
#line 147 "client.vala"
		_data_->_tmp12_ = g_strdup (_ ("'Server' cannot be blank"));
#line 147 "client.vala"
		_g_free0 (_data_->self->priv->error_message);
#line 147 "client.vala"
		_data_->self->priv->error_message = _data_->_tmp12_;
#line 1080 "client.c"
	} else {
#line 149 "client.vala"
		_data_->_tmp13_ = _data_->user_name;
#line 149 "client.vala"
		if (g_strcmp0 (_data_->_tmp13_, "") == 0) {
#line 150 "client.vala"
			_data_->_tmp14_ = g_strdup (_ ("'Name' cannot be blank"));
#line 150 "client.vala"
			_g_free0 (_data_->self->priv->error_message);
#line 150 "client.vala"
			_data_->self->priv->error_message = _data_->_tmp14_;
#line 1092 "client.c"
		} else {
#line 152 "client.vala"
			if (_data_->server_port == 0) {
#line 153 "client.vala"
				_data_->_tmp15_ = g_strdup (_ ("'Port' must be valid"));
#line 153 "client.vala"
				_g_free0 (_data_->self->priv->error_message);
#line 153 "client.vala"
				_data_->self->priv->error_message = _data_->_tmp15_;
#line 1102 "client.c"
			} else {
				{
#line 157 "client.vala"
					_data_->_tmp16_ = _data_->self->priv->connection;
#line 157 "client.vala"
					if (_data_->_tmp16_ != NULL) {
#line 157 "client.vala"
						_data_->_state_ = 1;
#line 157 "client.vala"
						pasang_client_logout (_data_->self, pasang_client_login_ready, _data_);
#line 157 "client.vala"
						return FALSE;
#line 1115 "client.c"
						_state_1:
#line 157 "client.vala"
						pasang_client_logout_finish (_data_->self, _data_->_res_);
#line 1119 "client.c"
					}
#line 158 "client.vala"
					_data_->_tmp17_ = g_resolver_get_default ();
#line 158 "client.vala"
					_data_->resolver = _data_->_tmp17_;
#line 159 "client.vala"
					_data_->_tmp18_ = _data_->resolver;
#line 159 "client.vala"
					_data_->_tmp19_ = _data_->server_name;
#line 159 "client.vala"
					_data_->_tmp20_ = _data_->self->priv->dispatcher_cancellable;
#line 159 "client.vala"
					_data_->_state_ = 2;
#line 159 "client.vala"
					g_resolver_lookup_by_name_async (_data_->_tmp18_, _data_->_tmp19_, _data_->_tmp20_, pasang_client_login_ready, _data_);
#line 159 "client.vala"
					return FALSE;
#line 1137 "client.c"
					_state_2:
#line 159 "client.vala"
					_data_->_tmp21_ = g_resolver_lookup_by_name_finish (_data_->_tmp18_, _data_->_res_, &_data_->_inner_error0_);
#line 159 "client.vala"
					_data_->addresses = _data_->_tmp21_;
#line 159 "client.vala"
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 159 "client.vala"
						_g_object_unref0 (_data_->resolver);
#line 159 "client.vala"
						if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
#line 1149 "client.c"
							goto __catch1_g_io_error_cancelled;
						}
						goto __catch1_g_error;
					}
#line 160 "client.vala"
					_data_->_tmp22_ = _data_->addresses;
#line 160 "client.vala"
					_data_->_tmp23_ = g_list_nth_data (_data_->_tmp22_, (guint) 0);
#line 160 "client.vala"
					_data_->_tmp24_ = _g_object_ref0 ((GInetAddress*) _data_->_tmp23_);
#line 160 "client.vala"
					_data_->address = _data_->_tmp24_;
#line 161 "client.vala"
					_data_->_tmp25_ = _data_->address;
#line 161 "client.vala"
					_data_->_tmp26_ = g_inet_address_to_string (_data_->_tmp25_);
#line 161 "client.vala"
					_data_->_tmp27_ = _data_->_tmp26_;
#line 161 "client.vala"
					g_debug ("client.vala:161: server IP: %s", _data_->_tmp27_);
#line 161 "client.vala"
					_g_free0 (_data_->_tmp27_);
#line 162 "client.vala"
					_data_->_tmp28_ = _data_->address;
#line 162 "client.vala"
					_data_->_tmp29_ = (GInetSocketAddress*) g_inet_socket_address_new (_data_->_tmp28_, (guint16) _data_->server_port);
#line 162 "client.vala"
					_data_->socket_address = _data_->_tmp29_;
#line 163 "client.vala"
					_data_->_tmp30_ = g_socket_client_new ();
#line 163 "client.vala"
					_data_->client = _data_->_tmp30_;
#line 164 "client.vala"
					_data_->_tmp32_ = _data_->client;
#line 164 "client.vala"
					_data_->_tmp33_ = _data_->socket_address;
#line 164 "client.vala"
					_data_->_tmp34_ = _data_->self->priv->dispatcher_cancellable;
#line 164 "client.vala"
					_data_->_state_ = 3;
#line 164 "client.vala"
					g_socket_client_connect_async (_data_->_tmp32_, (GSocketConnectable*) _data_->_tmp33_, _data_->_tmp34_, pasang_client_login_ready, _data_);
#line 164 "client.vala"
					return FALSE;
#line 1194 "client.c"
					_state_3:
#line 164 "client.vala"
					_data_->_tmp35_ = g_socket_client_connect_finish (_data_->_tmp32_, _data_->_res_, &_data_->_inner_error0_);
#line 164 "client.vala"
					_data_->_tmp31_ = _data_->_tmp35_;
#line 164 "client.vala"
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 164 "client.vala"
						_g_object_unref0 (_data_->client);
#line 164 "client.vala"
						_g_object_unref0 (_data_->socket_address);
#line 164 "client.vala"
						_g_object_unref0 (_data_->address);
#line 164 "client.vala"
						(_data_->addresses == NULL) ? NULL : (_data_->addresses = (_g_list_free__g_object_unref0_ (_data_->addresses), NULL));
#line 164 "client.vala"
						_g_object_unref0 (_data_->resolver);
#line 164 "client.vala"
						if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
#line 1214 "client.c"
							goto __catch1_g_io_error_cancelled;
						}
						goto __catch1_g_error;
					}
#line 164 "client.vala"
					_data_->_tmp36_ = _data_->_tmp31_;
#line 164 "client.vala"
					_data_->_tmp31_ = NULL;
#line 164 "client.vala"
					_g_object_unref0 (_data_->self->priv->connection);
#line 164 "client.vala"
					_data_->self->priv->connection = _data_->_tmp36_;
#line 165 "client.vala"
					_data_->_tmp37_ = _data_->self->priv->connection;
#line 165 "client.vala"
					_data_->_tmp38_ = g_io_stream_get_input_stream ((GIOStream*) _data_->_tmp37_);
#line 165 "client.vala"
					_data_->_tmp39_ = _data_->_tmp38_;
#line 165 "client.vala"
					_data_->_tmp40_ = g_data_input_stream_new (_data_->_tmp39_);
#line 165 "client.vala"
					_g_object_unref0 (_data_->self->priv->input);
#line 165 "client.vala"
					_data_->self->priv->input = _data_->_tmp40_;
#line 166 "client.vala"
					_data_->_tmp41_ = _data_->self->priv->connection;
#line 166 "client.vala"
					_data_->_tmp42_ = g_io_stream_get_output_stream ((GIOStream*) _data_->_tmp41_);
#line 166 "client.vala"
					_data_->_tmp43_ = _data_->_tmp42_;
#line 166 "client.vala"
					_data_->_tmp44_ = g_data_output_stream_new (_data_->_tmp43_);
#line 166 "client.vala"
					_g_object_unref0 (_data_->self->priv->output);
#line 166 "client.vala"
					_data_->self->priv->output = _data_->_tmp44_;
#line 167 "client.vala"
					_data_->_tmp45_ = _data_->self->priv->user_name_entry;
#line 167 "client.vala"
					_data_->_tmp46_ = gtk_entry_get_text (_data_->_tmp45_);
#line 167 "client.vala"
					_data_->_tmp47_ = _data_->_tmp46_;
#line 167 "client.vala"
					_data_->_tmp48_ = g_strdup_printf ("LOGIN %s\n", _data_->_tmp47_);
#line 167 "client.vala"
					_data_->_tmp49_ = _data_->_tmp48_;
#line 167 "client.vala"
					pasang_client_send (_data_->self, _data_->_tmp49_);
#line 167 "client.vala"
					_g_free0 (_data_->_tmp49_);
#line 156 "client.vala"
					_g_object_unref0 (_data_->_tmp31_);
#line 156 "client.vala"
					_g_object_unref0 (_data_->client);
#line 156 "client.vala"
					_g_object_unref0 (_data_->socket_address);
#line 156 "client.vala"
					_g_object_unref0 (_data_->address);
#line 156 "client.vala"
					(_data_->addresses == NULL) ? NULL : (_data_->addresses = (_g_list_free__g_object_unref0_ (_data_->addresses), NULL));
#line 156 "client.vala"
					_g_object_unref0 (_data_->resolver);
#line 1277 "client.c"
				}
				goto __finally1;
				__catch1_g_io_error_cancelled:
				{
#line 156 "client.vala"
					_data_->err_cancelled = _data_->_inner_error0_;
#line 156 "client.vala"
					_data_->_inner_error0_ = NULL;
#line 169 "client.vala"
					_g_object_unref0 (_data_->self->priv->connection);
#line 169 "client.vala"
					_data_->self->priv->connection = NULL;
#line 156 "client.vala"
					_g_error_free0 (_data_->err_cancelled);
#line 1292 "client.c"
				}
				goto __finally1;
				__catch1_g_error:
				{
#line 156 "client.vala"
					_data_->err = _data_->_inner_error0_;
#line 156 "client.vala"
					_data_->_inner_error0_ = NULL;
#line 171 "client.vala"
					_g_object_unref0 (_data_->self->priv->connection);
#line 171 "client.vala"
					_data_->self->priv->connection = NULL;
#line 172 "client.vala"
					_data_->_tmp50_ = _data_->err;
#line 172 "client.vala"
					_data_->_tmp51_ = _data_->_tmp50_->message;
#line 172 "client.vala"
					_data_->_tmp52_ = g_strdup (_data_->_tmp51_);
#line 172 "client.vala"
					_g_free0 (_data_->self->priv->error_message);
#line 172 "client.vala"
					_data_->self->priv->error_message = _data_->_tmp52_;
#line 156 "client.vala"
					_g_error_free0 (_data_->err);
#line 1317 "client.c"
				}
				__finally1:
#line 156 "client.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 156 "client.vala"
					_g_free0 (_data_->user_name);
#line 156 "client.vala"
					_g_free0 (_data_->server_name);
#line 156 "client.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 156 "client.vala"
					g_clear_error (&_data_->_inner_error0_);
#line 156 "client.vala"
					g_object_unref (_data_->_async_result);
#line 156 "client.vala"
					return FALSE;
#line 1334 "client.c"
				}
			}
		}
	}
#line 175 "client.vala"
	pasang_client_update_status (_data_->self);
#line 142 "client.vala"
	_g_free0 (_data_->user_name);
#line 142 "client.vala"
	_g_free0 (_data_->server_name);
#line 142 "client.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 142 "client.vala"
	if (_data_->_state_ != 0) {
#line 142 "client.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 142 "client.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1353 "client.c"
		}
	}
#line 142 "client.vala"
	g_object_unref (_data_->_async_result);
#line 142 "client.vala"
	return FALSE;
#line 1360 "client.c"
}

static void
pasang_client_logout_data_free (gpointer _data)
{
	PasangClientLogoutData* _data_;
	_data_ = _data;
#line 26 "client.vala"
	_g_object_unref0 (_data_->self);
#line 26 "client.vala"
	g_slice_free (PasangClientLogoutData, _data_);
#line 1372 "client.c"
}

static void
pasang_client_logout (PasangClient* self,
                      GAsyncReadyCallback _callback_,
                      gpointer _user_data_)
{
	PasangClientLogoutData* _data_;
	PasangClient* _tmp0_;
#line 26 "client.vala"
	_data_ = g_slice_new0 (PasangClientLogoutData);
#line 26 "client.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 26 "client.vala"
	g_task_set_task_data (_data_->_async_result, _data_, pasang_client_logout_data_free);
#line 26 "client.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 26 "client.vala"
	_data_->self = _tmp0_;
#line 26 "client.vala"
	pasang_client_logout_co (_data_);
#line 1394 "client.c"
}

static void
pasang_client_logout_finish (PasangClient* self,
                             GAsyncResult* _res_)
{
	PasangClientLogoutData* _data_;
#line 26 "client.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 1404 "client.c"
}

/**
     * Destroy connection.
     * output: set connection to null
     * error_message is retained in case the logout is performed because of disconnection
     * from the server.
     */
static void
pasang_client_logout_ready (GObject* source_object,
                            GAsyncResult* _res_,
                            gpointer _user_data_)
{
	PasangClientLogoutData* _data_;
#line 187 "client.vala"
	_data_ = _user_data_;
#line 187 "client.vala"
	_data_->_source_object_ = source_object;
#line 187 "client.vala"
	_data_->_res_ = _res_;
#line 187 "client.vala"
	pasang_client_logout_co (_data_);
#line 1427 "client.c"
}

static gboolean
pasang_client_logout_co (PasangClientLogoutData* _data_)
{
#line 184 "client.vala"
	switch (_data_->_state_) {
#line 184 "client.vala"
		case 0:
#line 1437 "client.c"
		goto _state_0;
#line 184 "client.vala"
		case 1:
#line 1441 "client.c"
		goto _state_1;
		default:
#line 184 "client.vala"
		g_assert_not_reached ();
#line 1446 "client.c"
	}
	_state_0:
	{
#line 186 "client.vala"
		_data_->_tmp0_ = _data_->self->priv->connection;
#line 186 "client.vala"
		if (_data_->_tmp0_ != NULL) {
#line 187 "client.vala"
			_data_->_tmp1_ = _data_->self->priv->connection;
#line 187 "client.vala"
			_data_->_tmp2_ = _data_->self->priv->dispatcher_cancellable;
#line 187 "client.vala"
			_data_->_state_ = 1;
#line 187 "client.vala"
			g_io_stream_close_async ((GIOStream*) _data_->_tmp1_, 100, _data_->_tmp2_, pasang_client_logout_ready, _data_);
#line 187 "client.vala"
			return FALSE;
#line 1464 "client.c"
			_state_1:
#line 187 "client.vala"
			g_io_stream_close_finish ((GIOStream*) _data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
#line 187 "client.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 1470 "client.c"
				goto __catch2_g_error;
			}
#line 188 "client.vala"
			_g_object_unref0 (_data_->self->priv->connection);
#line 188 "client.vala"
			_data_->self->priv->connection = NULL;
#line 1477 "client.c"
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
#line 185 "client.vala"
		_data_->err = _data_->_inner_error0_;
#line 185 "client.vala"
		_data_->_inner_error0_ = NULL;
#line 192 "client.vala"
		_data_->_tmp3_ = stderr;
#line 192 "client.vala"
		_data_->_tmp4_ = _data_->err;
#line 192 "client.vala"
		_data_->_tmp5_ = _data_->_tmp4_->message;
#line 192 "client.vala"
		fprintf (_data_->_tmp3_, "Logout error: %s\n", _data_->_tmp5_);
#line 185 "client.vala"
		_g_error_free0 (_data_->err);
#line 1497 "client.c"
	}
	__finally2:
#line 185 "client.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 185 "client.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 185 "client.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 185 "client.vala"
		g_object_unref (_data_->_async_result);
#line 185 "client.vala"
		return FALSE;
#line 1510 "client.c"
	}
#line 194 "client.vala"
	_data_->_tmp6_ = _data_->self->priv->player_list;
#line 194 "client.vala"
	g_list_store_remove_all (_data_->_tmp6_);
#line 195 "client.vala"
	_g_free0 (_data_->self->priv->user_name);
#line 195 "client.vala"
	_data_->self->priv->user_name = NULL;
#line 196 "client.vala"
	_data_->self->priv->id = (glong) -1;
#line 197 "client.vala"
	_data_->self->priv->opponent_id = (glong) -1;
#line 198 "client.vala"
	_data_->self->priv->challenged_id = (glong) -1;
#line 199 "client.vala"
	g_signal_emit (_data_->self, pasang_client_signals[PASANG_CLIENT_ON_LEAVE_GAME_SIGNAL], 0);
#line 200 "client.vala"
	pasang_client_update_status (_data_->self);
#line 184 "client.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 184 "client.vala"
	if (_data_->_state_ != 0) {
#line 184 "client.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 184 "client.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1538 "client.c"
		}
	}
#line 184 "client.vala"
	g_object_unref (_data_->_async_result);
#line 184 "client.vala"
	return FALSE;
#line 1545 "client.c"
}

static void
pasang_client_process_messages_data_free (gpointer _data)
{
	PasangClientProcessMessagesData* _data_;
	_data_ = _data;
#line 26 "client.vala"
	_g_object_unref0 (_data_->self);
#line 26 "client.vala"
	g_slice_free (PasangClientProcessMessagesData, _data_);
#line 1557 "client.c"
}

static void
pasang_client_process_messages (PasangClient* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	PasangClientProcessMessagesData* _data_;
	PasangClient* _tmp0_;
#line 26 "client.vala"
	_data_ = g_slice_new0 (PasangClientProcessMessagesData);
#line 26 "client.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 26 "client.vala"
	g_task_set_task_data (_data_->_async_result, _data_, pasang_client_process_messages_data_free);
#line 26 "client.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 26 "client.vala"
	_data_->self = _tmp0_;
#line 26 "client.vala"
	pasang_client_process_messages_co (_data_);
#line 1579 "client.c"
}

static void
pasang_client_process_messages_finish (PasangClient* self,
                                       GAsyncResult* _res_)
{
	PasangClientProcessMessagesData* _data_;
#line 26 "client.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 1589 "client.c"
}

/**
     * Process messages from the server.
     * The read loop may break if
     *  1. dispatcher_cancellable is triggered, or
     *  2. the connection is lost.
     */
static void
pasang_client_process_messages_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	PasangClientProcessMessagesData* _data_;
#line 214 "client.vala"
	_data_ = _user_data_;
#line 214 "client.vala"
	_data_->_source_object_ = source_object;
#line 214 "client.vala"
	_data_->_res_ = _res_;
#line 214 "client.vala"
	pasang_client_process_messages_co (_data_);
#line 1612 "client.c"
}

static gboolean
pasang_client_process_messages_co (PasangClientProcessMessagesData* _data_)
{
#line 209 "client.vala"
	switch (_data_->_state_) {
#line 209 "client.vala"
		case 0:
#line 1622 "client.c"
		goto _state_0;
#line 209 "client.vala"
		case 1:
#line 1626 "client.c"
		goto _state_1;
#line 209 "client.vala"
		case 2:
#line 1630 "client.c"
		goto _state_2;
		default:
#line 209 "client.vala"
		g_assert_not_reached ();
#line 1635 "client.c"
	}
	_state_0:
#line 210 "client.vala"
	_data_->_tmp0_ = _data_->self->priv->connection;
#line 210 "client.vala"
	if (_data_->_tmp0_ == NULL) {
#line 210 "client.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 210 "client.vala"
		if (_data_->_state_ != 0) {
#line 210 "client.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 210 "client.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1650 "client.c"
			}
		}
#line 210 "client.vala"
		g_object_unref (_data_->_async_result);
#line 210 "client.vala"
		return FALSE;
#line 1657 "client.c"
	}
	{
#line 214 "client.vala"
		while (TRUE) {
#line 214 "client.vala"
			_data_->_tmp2_ = _data_->self->priv->input;
#line 214 "client.vala"
			_data_->_tmp3_ = _data_->self->priv->dispatcher_cancellable;
#line 214 "client.vala"
			_data_->_tmp4_ = 0UL;
#line 214 "client.vala"
			_data_->_state_ = 1;
#line 214 "client.vala"
			g_data_input_stream_read_line_async (_data_->_tmp2_, 100, _data_->_tmp3_, pasang_client_process_messages_ready, _data_);
#line 214 "client.vala"
			return FALSE;
#line 1674 "client.c"
			_state_1:
#line 214 "client.vala"
			_data_->_tmp5_ = g_data_input_stream_read_line_finish (_data_->_tmp2_, _data_->_res_, &_data_->_tmp4_, &_data_->_inner_error0_);
#line 214 "client.vala"
			_data_->length = _data_->_tmp4_;
#line 214 "client.vala"
			_data_->_tmp1_ = _data_->_tmp5_;
#line 214 "client.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 214 "client.vala"
				_g_free0 (_data_->line);
#line 214 "client.vala"
				if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
#line 1688 "client.c"
					goto __catch3_g_io_error_cancelled;
				}
				goto __catch3_g_error;
			}
#line 214 "client.vala"
			_data_->_tmp6_ = _data_->_tmp1_;
#line 214 "client.vala"
			_data_->_tmp1_ = NULL;
#line 214 "client.vala"
			_g_free0 (_data_->line);
#line 214 "client.vala"
			_data_->line = _data_->_tmp6_;
#line 214 "client.vala"
			_data_->_tmp7_ = _data_->line;
#line 214 "client.vala"
			if (!(_data_->_tmp7_ != NULL)) {
#line 214 "client.vala"
				_g_free0 (_data_->_tmp1_);
#line 214 "client.vala"
				break;
#line 1709 "client.c"
			}
#line 215 "client.vala"
			_data_->_tmp8_ = _data_->line;
#line 215 "client.vala"
			g_message ("client.vala:215: From server: %s", _data_->_tmp8_);
#line 216 "client.vala"
			_data_->_tmp9_ = _data_->line;
#line 216 "client.vala"
			_data_->_tmp10_ = pasang_client_sanitize (_data_->self, _data_->_tmp9_);
#line 216 "client.vala"
			_data_->_tmp11_ = _data_->_tmp10_;
#line 216 "client.vala"
			pasang_client_interpret (_data_->self, _data_->_tmp11_, &_data_->_inner_error0_);
#line 216 "client.vala"
			_g_free0 (_data_->_tmp11_);
#line 216 "client.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 216 "client.vala"
				_g_free0 (_data_->_tmp1_);
#line 216 "client.vala"
				_g_free0 (_data_->line);
#line 216 "client.vala"
				if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
#line 1733 "client.c"
					goto __catch3_g_io_error_cancelled;
				}
				goto __catch3_g_error;
			}
#line 217 "client.vala"
			_data_->_tmp12_ = _data_->self->priv->dispatcher_cancellable;
#line 217 "client.vala"
			if (g_cancellable_is_cancelled (_data_->_tmp12_)) {
#line 217 "client.vala"
				_g_free0 (_data_->_tmp1_);
#line 217 "client.vala"
				break;
#line 1746 "client.c"
			}
#line 214 "client.vala"
			_g_free0 (_data_->_tmp1_);
#line 1750 "client.c"
		}
#line 220 "client.vala"
		_data_->_tmp13_ = _data_->self->priv->dispatcher_cancellable;
#line 220 "client.vala"
		if (!g_cancellable_is_cancelled (_data_->_tmp13_)) {
#line 221 "client.vala"
			_data_->_tmp14_ = g_strdup (_ ("Disconnected from the server."));
#line 221 "client.vala"
			_g_free0 (_data_->self->priv->error_message);
#line 221 "client.vala"
			_data_->self->priv->error_message = _data_->_tmp14_;
#line 222 "client.vala"
			pasang_client_update_status (_data_->self);
#line 223 "client.vala"
			_data_->_state_ = 2;
#line 223 "client.vala"
			pasang_client_logout (_data_->self, pasang_client_process_messages_ready, _data_);
#line 223 "client.vala"
			return FALSE;
#line 1770 "client.c"
			_state_2:
#line 223 "client.vala"
			pasang_client_logout_finish (_data_->self, _data_->_res_);
#line 1774 "client.c"
		}
#line 211 "client.vala"
		_g_free0 (_data_->line);
#line 1778 "client.c"
	}
	goto __finally3;
	__catch3_g_io_error_cancelled:
	{
#line 211 "client.vala"
		_data_->err_cancelled = _data_->_inner_error0_;
#line 211 "client.vala"
		_data_->_inner_error0_ = NULL;
#line 211 "client.vala"
		_g_error_free0 (_data_->err_cancelled);
#line 1789 "client.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
#line 211 "client.vala"
		_data_->err = _data_->_inner_error0_;
#line 211 "client.vala"
		_data_->_inner_error0_ = NULL;
#line 230 "client.vala"
		_data_->_tmp15_ = stderr;
#line 230 "client.vala"
		_data_->_tmp16_ = _data_->err;
#line 230 "client.vala"
		_data_->_tmp17_ = _data_->_tmp16_->message;
#line 230 "client.vala"
		fprintf (_data_->_tmp15_, "IO error: %s\n", _data_->_tmp17_);
#line 211 "client.vala"
		_g_error_free0 (_data_->err);
#line 1808 "client.c"
	}
	__finally3:
#line 211 "client.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 211 "client.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 211 "client.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 211 "client.vala"
		g_object_unref (_data_->_async_result);
#line 211 "client.vala"
		return FALSE;
#line 1821 "client.c"
	}
#line 209 "client.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 209 "client.vala"
	if (_data_->_state_ != 0) {
#line 209 "client.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 209 "client.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1831 "client.c"
		}
	}
#line 209 "client.vala"
	g_object_unref (_data_->_async_result);
#line 209 "client.vala"
	return FALSE;
#line 1838 "client.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1481 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1481 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1860 "client.c"
	} else {
#line 1481 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 1864 "client.c"
	}
#line 1481 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1481 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1870 "client.c"
	} else {
#line 1481 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 1874 "client.c"
	}
#line 1481 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1878 "client.c"
		gchar* _tmp2_;
#line 1482 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1482 "glib-2.0.vapi"
		result = _tmp2_;
#line 1482 "glib-2.0.vapi"
		return result;
#line 1886 "client.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1485 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1485 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1485 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1485 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1485 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1485 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1485 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1485 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1914 "client.c"
				goto __catch4_g_regex_error;
			}
#line 1485 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1485 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1485 "glib-2.0.vapi"
			return NULL;
#line 1923 "client.c"
		}
#line 1486 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1486 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1486 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1486 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1486 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1486 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1937 "client.c"
				goto __catch4_g_regex_error;
			}
#line 1486 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1486 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1486 "glib-2.0.vapi"
			return NULL;
#line 1946 "client.c"
		}
#line 1486 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1486 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1486 "glib-2.0.vapi"
		result = _tmp10_;
#line 1486 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1486 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1486 "glib-2.0.vapi"
		return result;
#line 1960 "client.c"
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
#line 1484 "glib-2.0.vapi"
		e = _inner_error0_;
#line 1484 "glib-2.0.vapi"
		_inner_error0_ = NULL;
#line 1488 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 1484 "glib-2.0.vapi"
		_g_error_free0 (e);
#line 1974 "client.c"
	}
	__finally4:
#line 1484 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1484 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1484 "glib-2.0.vapi"
	return NULL;
#line 1983 "client.c"
}

static gchar*
pasang_client_sanitize (PasangClient* self,
                        const gchar* s)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 234 "client.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 234 "client.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 235 "client.vala"
	_tmp0_ = string_strip (s);
#line 235 "client.vala"
	_tmp1_ = _tmp0_;
#line 235 "client.vala"
	_tmp2_ = string_replace (_tmp1_, "\n", "");
#line 235 "client.vala"
	_tmp3_ = _tmp2_;
#line 235 "client.vala"
	_g_free0 (_tmp1_);
#line 235 "client.vala"
	result = _tmp3_;
#line 235 "client.vala"
	return result;
#line 2013 "client.c"
}

static void
pasang_client_interpret (PasangClient* self,
                         const gchar* line,
                         GError** error)
{
	gchar** msg = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint msg_length1;
	gint _msg_size_;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* arg = NULL;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GQuark _tmp13_ = 0U;
#line 242 "client.vala"
	static GQuark _tmp12_label0 = 0;
#line 242 "client.vala"
	static GQuark _tmp12_label1 = 0;
#line 242 "client.vala"
	static GQuark _tmp12_label2 = 0;
#line 242 "client.vala"
	static GQuark _tmp12_label3 = 0;
#line 242 "client.vala"
	static GQuark _tmp12_label4 = 0;
#line 242 "client.vala"
	static GQuark _tmp12_label5 = 0;
#line 242 "client.vala"
	static GQuark _tmp12_label6 = 0;
#line 2050 "client.c"
	GError* _inner_error0_ = NULL;
#line 238 "client.vala"
	g_return_if_fail (self != NULL);
#line 238 "client.vala"
	g_return_if_fail (line != NULL);
#line 239 "client.vala"
	if (g_strcmp0 (line, "") == 0) {
#line 239 "client.vala"
		return;
#line 2060 "client.c"
	}
#line 240 "client.vala"
	_tmp1_ = _tmp0_ = g_strsplit (line, " ", 2);
#line 240 "client.vala"
	msg = _tmp1_;
#line 240 "client.vala"
	msg_length1 = _vala_array_length (_tmp0_);
#line 240 "client.vala"
	_msg_size_ = msg_length1;
#line 241 "client.vala"
	_tmp3_ = msg;
#line 241 "client.vala"
	_tmp3__length1 = msg_length1;
#line 241 "client.vala"
	if (_tmp3__length1 == 2) {
#line 2076 "client.c"
		gchar** _tmp4_;
		gint _tmp4__length1;
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 241 "client.vala"
		_tmp4_ = msg;
#line 241 "client.vala"
		_tmp4__length1 = msg_length1;
#line 241 "client.vala"
		_tmp5_ = _tmp4_[1];
#line 241 "client.vala"
		_tmp6_ = string_strip (_tmp5_);
#line 241 "client.vala"
		_g_free0 (_tmp2_);
#line 241 "client.vala"
		_tmp2_ = _tmp6_;
#line 2093 "client.c"
	} else {
		gchar* _tmp7_;
#line 241 "client.vala"
		_tmp7_ = g_strdup ("");
#line 241 "client.vala"
		_g_free0 (_tmp2_);
#line 241 "client.vala"
		_tmp2_ = _tmp7_;
#line 2102 "client.c"
	}
#line 241 "client.vala"
	_tmp8_ = g_strdup (_tmp2_);
#line 241 "client.vala"
	arg = _tmp8_;
#line 242 "client.vala"
	_tmp9_ = msg;
#line 242 "client.vala"
	_tmp9__length1 = msg_length1;
#line 242 "client.vala"
	_tmp10_ = _tmp9_[0];
#line 242 "client.vala"
	_tmp11_ = _tmp10_;
#line 242 "client.vala"
	_tmp13_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
#line 242 "client.vala"
	if (_tmp13_ == ((0 != _tmp12_label0) ? _tmp12_label0 : (_tmp12_label0 = g_quark_from_static_string ("LOGIN-OK")))) {
#line 242 "client.vala"
		switch (0) {
#line 2122 "client.c"
			default:
			{
				const gchar* _tmp14_;
#line 243 "client.vala"
				_tmp14_ = arg;
#line 243 "client.vala"
				pasang_client_login_accepted (self, _tmp14_, &_inner_error0_);
#line 243 "client.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 243 "client.vala"
					g_propagate_error (error, _inner_error0_);
#line 243 "client.vala"
					_g_free0 (arg);
#line 243 "client.vala"
					_g_free0 (_tmp2_);
#line 243 "client.vala"
					msg = (_vala_array_free (msg, msg_length1, (GDestroyNotify) g_free), NULL);
#line 243 "client.vala"
					return;
#line 2142 "client.c"
				}
#line 243 "client.vala"
				break;
#line 2146 "client.c"
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label1) ? _tmp12_label1 : (_tmp12_label1 = g_quark_from_static_string ("LOGIN-ERROR")))) {
#line 242 "client.vala"
		switch (0) {
#line 2152 "client.c"
			default:
			{
#line 244 "client.vala"
				pasang_client_login_refused (self);
#line 244 "client.vala"
				break;
#line 2159 "client.c"
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label2) ? _tmp12_label2 : (_tmp12_label2 = g_quark_from_static_string ("USER")))) {
#line 242 "client.vala"
		switch (0) {
#line 2165 "client.c"
			default:
			{
				const gchar* _tmp15_;
#line 245 "client.vala"
				_tmp15_ = arg;
#line 245 "client.vala"
				pasang_client_remote_user_registered (self, _tmp15_);
#line 245 "client.vala"
				break;
#line 2175 "client.c"
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label3) ? _tmp12_label3 : (_tmp12_label3 = g_quark_from_static_string ("EXIT")))) {
#line 242 "client.vala"
		switch (0) {
#line 2181 "client.c"
			default:
			{
				const gchar* _tmp16_;
#line 246 "client.vala"
				_tmp16_ = arg;
#line 246 "client.vala"
				pasang_client_remote_user_deregistered (self, _tmp16_);
#line 246 "client.vala"
				break;
#line 2191 "client.c"
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label4) ? _tmp12_label4 : (_tmp12_label4 = g_quark_from_static_string ("PLAY-AGAINST")))) {
#line 242 "client.vala"
		switch (0) {
#line 2197 "client.c"
			default:
			{
				const gchar* _tmp17_;
#line 247 "client.vala"
				_tmp17_ = arg;
#line 247 "client.vala"
				pasang_client_opponent_booked (self, _tmp17_);
#line 247 "client.vala"
				break;
#line 2207 "client.c"
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label5) ? _tmp12_label5 : (_tmp12_label5 = g_quark_from_static_string ("PLAY-END")))) {
#line 242 "client.vala"
		switch (0) {
#line 2213 "client.c"
			default:
			{
#line 248 "client.vala"
				pasang_client_play_ended (self);
#line 248 "client.vala"
				break;
#line 2220 "client.c"
			}
		}
	} else if (_tmp13_ == ((0 != _tmp12_label6) ? _tmp12_label6 : (_tmp12_label6 = g_quark_from_static_string ("MOVE")))) {
#line 242 "client.vala"
		switch (0) {
#line 2226 "client.c"
			default:
			{
				const gchar* _tmp18_;
#line 249 "client.vala"
				_tmp18_ = arg;
#line 249 "client.vala"
				pasang_client_move_received (self, _tmp18_);
#line 249 "client.vala"
				break;
#line 2236 "client.c"
			}
		}
	}
#line 238 "client.vala"
	_g_free0 (arg);
#line 238 "client.vala"
	_g_free0 (_tmp2_);
#line 238 "client.vala"
	msg = (_vala_array_free (msg, msg_length1, (GDestroyNotify) g_free), NULL);
#line 2246 "client.c"
}

/**
     * input: login_info in the form of "id name"
     * output: id, user_name
     * message sent: GET-USER-LIST
     * 
     */
static glong
long_parse (const gchar* str)
{
	glong result = 0L;
#line 269 "glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0L);
#line 270 "glib-2.0.vapi"
	result = strtol (str, NULL, (guint) 0);
#line 270 "glib-2.0.vapi"
	return result;
#line 2265 "client.c"
}

static void
pasang_client_login_accepted (PasangClient* self,
                              const gchar* login_info,
                              GError** error)
{
	gchar** info = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint info_length1;
	gint _info_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gchar* _tmp7_;
#line 259 "client.vala"
	g_return_if_fail (self != NULL);
#line 259 "client.vala"
	g_return_if_fail (login_info != NULL);
#line 260 "client.vala"
	_g_free0 (self->priv->error_message);
#line 260 "client.vala"
	self->priv->error_message = NULL;
#line 261 "client.vala"
	_tmp1_ = _tmp0_ = g_strsplit (login_info, " ", 2);
#line 261 "client.vala"
	info = _tmp1_;
#line 261 "client.vala"
	info_length1 = _vala_array_length (_tmp0_);
#line 261 "client.vala"
	_info_size_ = info_length1;
#line 262 "client.vala"
	_tmp2_ = info;
#line 262 "client.vala"
	_tmp2__length1 = info_length1;
#line 262 "client.vala"
	if (_tmp2__length1 != 2) {
#line 262 "client.vala"
		info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
#line 262 "client.vala"
		return;
#line 2313 "client.c"
	}
#line 263 "client.vala"
	_tmp3_ = info;
#line 263 "client.vala"
	_tmp3__length1 = info_length1;
#line 263 "client.vala"
	_tmp4_ = _tmp3_[0];
#line 263 "client.vala"
	self->priv->id = long_parse (_tmp4_);
#line 264 "client.vala"
	_tmp5_ = info;
#line 264 "client.vala"
	_tmp5__length1 = info_length1;
#line 264 "client.vala"
	_tmp6_ = _tmp5_[1];
#line 264 "client.vala"
	_tmp7_ = string_strip (_tmp6_);
#line 264 "client.vala"
	_g_free0 (self->priv->user_name);
#line 264 "client.vala"
	self->priv->user_name = _tmp7_;
#line 265 "client.vala"
	pasang_client_send (self, "GET-USER-LIST\n");
#line 266 "client.vala"
	pasang_client_update_status (self);
#line 259 "client.vala"
	info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
#line 2341 "client.c"
}

static void
pasang_client_login_refused (PasangClient* self)
{
	gchar* _tmp0_;
#line 269 "client.vala"
	g_return_if_fail (self != NULL);
#line 270 "client.vala"
	_tmp0_ = g_strdup (_ ("Login refused."));
#line 270 "client.vala"
	_g_free0 (self->priv->error_message);
#line 270 "client.vala"
	self->priv->error_message = _tmp0_;
#line 271 "client.vala"
	pasang_client_update_status (self);
#line 2358 "client.c"
}

/**
     * Update list of users whenever a remote player logs in or changes her status.
     * Input: user_info in the form of "id status name"
     * Output: modified row, if id found; a new row if id is not found
     */
static void
pasang_client_remote_user_registered (PasangClient* self,
                                      const gchar* user_info)
{
	gchar** info = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint info_length1;
	gint _info_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	glong remote_user_id = 0L;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* remote_user_name = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
#line 279 "client.vala"
	g_return_if_fail (self != NULL);
#line 279 "client.vala"
	g_return_if_fail (user_info != NULL);
#line 280 "client.vala"
	_tmp1_ = _tmp0_ = g_strsplit (user_info, " ", 3);
#line 280 "client.vala"
	info = _tmp1_;
#line 280 "client.vala"
	info_length1 = _vala_array_length (_tmp0_);
#line 280 "client.vala"
	_info_size_ = info_length1;
#line 281 "client.vala"
	_tmp2_ = info;
#line 281 "client.vala"
	_tmp2__length1 = info_length1;
#line 281 "client.vala"
	if (_tmp2__length1 != 3) {
#line 281 "client.vala"
		info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
#line 281 "client.vala"
		return;
#line 2412 "client.c"
	}
#line 282 "client.vala"
	_tmp3_ = info;
#line 282 "client.vala"
	_tmp3__length1 = info_length1;
#line 282 "client.vala"
	_tmp4_ = _tmp3_[0];
#line 282 "client.vala"
	remote_user_id = long_parse (_tmp4_);
#line 283 "client.vala"
	if (remote_user_id == self->priv->id) {
#line 283 "client.vala"
		info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
#line 283 "client.vala"
		return;
#line 2428 "client.c"
	}
#line 284 "client.vala"
	_tmp5_ = info;
#line 284 "client.vala"
	_tmp5__length1 = info_length1;
#line 284 "client.vala"
	_tmp6_ = _tmp5_[2];
#line 284 "client.vala"
	_tmp7_ = string_strip (_tmp6_);
#line 284 "client.vala"
	remote_user_name = _tmp7_;
#line 286 "client.vala"
	_tmp8_ = info;
#line 286 "client.vala"
	_tmp8__length1 = info_length1;
#line 286 "client.vala"
	_tmp9_ = _tmp8_[1];
#line 286 "client.vala"
	_tmp10_ = remote_user_name;
#line 286 "client.vala"
	pasang_client_remote_user_status_changed (self, remote_user_id, g_strcmp0 (_tmp9_, "w") == 0, _tmp10_);
#line 287 "client.vala"
	pasang_client_update_status (self);
#line 279 "client.vala"
	_g_free0 (remote_user_name);
#line 279 "client.vala"
	info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
#line 2456 "client.c"
}

/**
     * Remove remote user entry.
     * Input: remote user id
     * Output: row deleted if found
     */
static void
pasang_client_remote_user_deregistered (PasangClient* self,
                                        const gchar* id_string)
{
	glong remote_user_id = 0L;
#line 295 "client.vala"
	g_return_if_fail (self != NULL);
#line 295 "client.vala"
	g_return_if_fail (id_string != NULL);
#line 296 "client.vala"
	remote_user_id = long_parse (id_string);
#line 297 "client.vala"
	pasang_client_remote_user_status_changed (self, remote_user_id, FALSE, NULL);
#line 298 "client.vala"
	if (remote_user_id == self->priv->opponent_id) {
#line 299 "client.vala"
		pasang_client_play_ended (self);
#line 2481 "client.c"
	}
#line 301 "client.vala"
	pasang_client_update_status (self);
#line 2485 "client.c"
}

/**
     * Add, remove or ignore remote user depending on the status.
     */
static void
pasang_client_remote_user_status_changed (PasangClient* self,
                                          glong remote_user_id,
                                          gboolean available,
                                          const gchar* remote_user_name)
{
	gint n = 0;
	GObject* obj = NULL;
	gboolean _tmp8_ = FALSE;
	GObject* _tmp9_;
#line 307 "client.vala"
	g_return_if_fail (self != NULL);
#line 310 "client.vala"
	n = 0;
#line 311 "client.vala"
	obj = NULL;
#line 312 "client.vala"
	while (TRUE) {
#line 2509 "client.c"
		GListStore* _tmp0_;
		GObject* _tmp1_;
		GObject* _tmp2_;
		PasangNetworkPlayer* p = NULL;
		GObject* _tmp3_;
		PasangNetworkPlayer* _tmp4_;
		PasangNetworkPlayer* _tmp5_;
		gint _tmp7_;
#line 312 "client.vala"
		_tmp0_ = self->priv->player_list;
#line 312 "client.vala"
		_tmp1_ = g_list_model_get_item ((GListModel*) _tmp0_, (guint) n);
#line 312 "client.vala"
		_g_object_unref0 (obj);
#line 312 "client.vala"
		obj = _tmp1_;
#line 312 "client.vala"
		_tmp2_ = obj;
#line 312 "client.vala"
		if (!(_tmp2_ != NULL)) {
#line 312 "client.vala"
			break;
#line 2532 "client.c"
		}
#line 313 "client.vala"
		_tmp3_ = obj;
#line 313 "client.vala"
		_tmp4_ = _g_object_ref0 (PASANG_IS_NETWORK_PLAYER (_tmp3_) ? ((PasangNetworkPlayer*) _tmp3_) : NULL);
#line 313 "client.vala"
		p = _tmp4_;
#line 314 "client.vala"
		_tmp5_ = p;
#line 314 "client.vala"
		if (_tmp5_->id == remote_user_id) {
#line 315 "client.vala"
			if (!available) {
#line 2546 "client.c"
				GListStore* _tmp6_;
#line 315 "client.vala"
				_tmp6_ = self->priv->player_list;
#line 315 "client.vala"
				g_list_store_remove (_tmp6_, (guint) n);
#line 2552 "client.c"
			}
#line 316 "client.vala"
			_g_object_unref0 (p);
#line 316 "client.vala"
			break;
#line 2558 "client.c"
		}
#line 318 "client.vala"
		_tmp7_ = n;
#line 318 "client.vala"
		n = _tmp7_ + 1;
#line 312 "client.vala"
		_g_object_unref0 (p);
#line 2566 "client.c"
	}
#line 321 "client.vala"
	_tmp9_ = obj;
#line 321 "client.vala"
	if (_tmp9_ == NULL) {
#line 321 "client.vala"
		_tmp8_ = available;
#line 2574 "client.c"
	} else {
#line 321 "client.vala"
		_tmp8_ = FALSE;
#line 2578 "client.c"
	}
#line 321 "client.vala"
	if (_tmp8_) {
#line 2582 "client.c"
		PasangNetworkPlayer* p = NULL;
		PasangNetworkPlayer* _tmp10_;
		PasangNetworkPlayer* _tmp11_;
		PasangNetworkPlayer* _tmp12_;
		gchar* _tmp13_;
		GListStore* _tmp14_;
		PasangNetworkPlayer* _tmp15_;
#line 322 "client.vala"
		_tmp10_ = pasang_network_player_new ();
#line 322 "client.vala"
		p = _tmp10_;
#line 323 "client.vala"
		_tmp11_ = p;
#line 323 "client.vala"
		_tmp11_->id = remote_user_id;
#line 324 "client.vala"
		_tmp12_ = p;
#line 324 "client.vala"
		_tmp13_ = g_strdup (remote_user_name);
#line 324 "client.vala"
		_g_free0 (_tmp12_->name);
#line 324 "client.vala"
		_tmp12_->name = _tmp13_;
#line 325 "client.vala"
		_tmp14_ = self->priv->player_list;
#line 325 "client.vala"
		_tmp15_ = p;
#line 325 "client.vala"
		g_list_store_append (_tmp14_, (GObject*) _tmp15_);
#line 321 "client.vala"
		_g_object_unref0 (p);
#line 2614 "client.c"
	}
#line 307 "client.vala"
	_g_object_unref0 (obj);
#line 2618 "client.c"
}

/**
     * Receive or decline an opponent.
     * Input: remote user id
     * output: opponent_id, opponent_name
     */
static void
pasang_client_opponent_booked (PasangClient* self,
                               const gchar* id_string)
{
	glong remote_user_id = 0L;
	gint n = 0;
	GObject* obj = NULL;
#line 334 "client.vala"
	g_return_if_fail (self != NULL);
#line 334 "client.vala"
	g_return_if_fail (id_string != NULL);
#line 335 "client.vala"
	remote_user_id = long_parse (id_string);
#line 336 "client.vala"
	if (remote_user_id == self->priv->id) {
#line 336 "client.vala"
		return;
#line 2643 "client.c"
	}
#line 338 "client.vala"
	n = 0;
#line 339 "client.vala"
	obj = NULL;
#line 340 "client.vala"
	while (TRUE) {
#line 2651 "client.c"
		GListStore* _tmp0_;
		GObject* _tmp1_;
		GObject* _tmp2_;
		PasangNetworkPlayer* p = NULL;
		GObject* _tmp3_;
		PasangNetworkPlayer* _tmp4_;
		PasangNetworkPlayer* _tmp5_;
		gint _tmp13_;
#line 340 "client.vala"
		_tmp0_ = self->priv->player_list;
#line 340 "client.vala"
		_tmp1_ = g_list_model_get_item ((GListModel*) _tmp0_, (guint) n);
#line 340 "client.vala"
		_g_object_unref0 (obj);
#line 340 "client.vala"
		obj = _tmp1_;
#line 340 "client.vala"
		_tmp2_ = obj;
#line 340 "client.vala"
		if (!(_tmp2_ != NULL)) {
#line 340 "client.vala"
			break;
#line 2674 "client.c"
		}
#line 341 "client.vala"
		_tmp3_ = obj;
#line 341 "client.vala"
		_tmp4_ = _g_object_ref0 (PASANG_IS_NETWORK_PLAYER (_tmp3_) ? ((PasangNetworkPlayer*) _tmp3_) : NULL);
#line 341 "client.vala"
		p = _tmp4_;
#line 342 "client.vala"
		_tmp5_ = p;
#line 342 "client.vala"
		if (_tmp5_->id == remote_user_id) {
#line 2686 "client.c"
			gboolean _tmp6_ = FALSE;
			PasangNetworkPlayer* _tmp7_;
#line 343 "client.vala"
			_tmp7_ = p;
#line 343 "client.vala"
			if (_tmp7_->id == self->priv->challenged_id) {
#line 343 "client.vala"
				_tmp6_ = TRUE;
#line 2695 "client.c"
			} else {
				PasangNetworkPlayer* _tmp8_;
				const gchar* _tmp9_;
#line 343 "client.vala"
				_tmp8_ = p;
#line 343 "client.vala"
				_tmp9_ = _tmp8_->name;
#line 343 "client.vala"
				_tmp6_ = pasang_client_accept_challenge (self, _tmp9_);
#line 2705 "client.c"
			}
#line 343 "client.vala"
			if (_tmp6_) {
#line 2709 "client.c"
				PasangNetworkPlayer* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
#line 344 "client.vala"
				self->priv->opponent_id = remote_user_id;
#line 345 "client.vala"
				_tmp10_ = p;
#line 345 "client.vala"
				_tmp11_ = _tmp10_->name;
#line 345 "client.vala"
				_tmp12_ = g_strdup (_tmp11_);
#line 345 "client.vala"
				_g_free0 (self->opponent_name);
#line 345 "client.vala"
				self->opponent_name = _tmp12_;
#line 346 "client.vala"
				self->priv->challenged_id = (glong) -1;
#line 347 "client.vala"
				g_signal_emit (self, pasang_client_signals[PASANG_CLIENT_ON_JOIN_GAME_SIGNAL], 0);
#line 348 "client.vala"
				pasang_client_update_status (self);
#line 2731 "client.c"
			} else {
#line 351 "client.vala"
				pasang_client_request_retreat (self);
#line 2735 "client.c"
			}
#line 353 "client.vala"
			_g_object_unref0 (p);
#line 353 "client.vala"
			break;
#line 2741 "client.c"
		}
#line 355 "client.vala"
		_tmp13_ = n;
#line 355 "client.vala"
		n = _tmp13_ + 1;
#line 340 "client.vala"
		_g_object_unref0 (p);
#line 2749 "client.c"
	}
#line 334 "client.vala"
	_g_object_unref0 (obj);
#line 2753 "client.c"
}

/**
     * Show a dialog to accept or decline a challenge
     */
static gboolean
pasang_client_accept_challenge (PasangClient* self,
                                const gchar* challenger)
{
	GtkMessageDialog* dialog = NULL;
	GtkWindow* _tmp0_;
	GtkMessageDialog* _tmp1_;
	gint response = 0;
	gboolean result = FALSE;
#line 362 "client.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 362 "client.vala"
	g_return_val_if_fail (challenger != NULL, FALSE);
#line 363 "client.vala"
	_tmp0_ = self->priv->parent;
#line 363 "client.vala"
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, _ ("%s is inviting you to play."), challenger);
#line 363 "client.vala"
	g_object_ref_sink (_tmp1_);
#line 363 "client.vala"
	dialog = _tmp1_;
#line 370 "client.vala"
	gtk_dialog_add_button ((GtkDialog*) dialog, _ ("Accept"), (gint) GTK_RESPONSE_OK);
#line 371 "client.vala"
	gtk_dialog_add_button ((GtkDialog*) dialog, _ ("Decline"), (gint) GTK_RESPONSE_CANCEL);
#line 372 "client.vala"
	response = gtk_dialog_run ((GtkDialog*) dialog);
#line 373 "client.vala"
	gtk_widget_destroy ((GtkWidget*) dialog);
#line 374 "client.vala"
	result = response == ((gint) GTK_RESPONSE_OK);
#line 374 "client.vala"
	_g_object_unref0 (dialog);
#line 374 "client.vala"
	return result;
#line 2794 "client.c"
}

/**
     * Play ended. Retreat from opponnet.
     */
static void
pasang_client_play_ended (PasangClient* self)
{
#line 380 "client.vala"
	g_return_if_fail (self != NULL);
#line 381 "client.vala"
	if (self->priv->opponent_id != ((glong) -1)) {
#line 2807 "client.c"
		GtkMessageDialog* dialog = NULL;
		GtkWindow* _tmp0_;
		GtkMessageDialog* _tmp1_;
		GtkMessageDialog* _tmp2_;
		GtkMessageDialog* _tmp3_;
#line 382 "client.vala"
		_tmp0_ = self->priv->parent;
#line 382 "client.vala"
		_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "%s", _ ("Your opponent has left the game"));
#line 382 "client.vala"
		g_object_ref_sink (_tmp1_);
#line 382 "client.vala"
		dialog = _tmp1_;
#line 385 "client.vala"
		_tmp2_ = dialog;
#line 385 "client.vala"
		gtk_dialog_run ((GtkDialog*) _tmp2_);
#line 386 "client.vala"
		_tmp3_ = dialog;
#line 386 "client.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp3_);
#line 381 "client.vala"
		_g_object_unref0 (dialog);
#line 2831 "client.c"
	}
#line 388 "client.vala"
	self->priv->opponent_id = (glong) -1;
#line 389 "client.vala"
	self->priv->challenged_id = (glong) -1;
#line 390 "client.vala"
	g_signal_emit (self, pasang_client_signals[PASANG_CLIENT_ON_LEAVE_GAME_SIGNAL], 0);
#line 391 "client.vala"
	pasang_client_update_status (self);
#line 2841 "client.c"
}

/**
     * Opponent's move has arrived.
     * input: opponent id + sequence number + move notation
     * output: signal emitted
     */
static void
pasang_client_move_received (PasangClient* self,
                             const gchar* arg)
{
	gchar** info = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint info_length1;
	gint _info_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
#line 399 "client.vala"
	g_return_if_fail (self != NULL);
#line 399 "client.vala"
	g_return_if_fail (arg != NULL);
#line 400 "client.vala"
	if (self->priv->opponent_id == ((glong) -1)) {
#line 401 "client.vala"
		g_message ("client.vala:401: Sync error: no opponent, but a move was received.");
#line 402 "client.vala"
		return;
#line 2879 "client.c"
	}
#line 404 "client.vala"
	_tmp1_ = _tmp0_ = g_strsplit (arg, " ", 3);
#line 404 "client.vala"
	info = _tmp1_;
#line 404 "client.vala"
	info_length1 = _vala_array_length (_tmp0_);
#line 404 "client.vala"
	_info_size_ = info_length1;
#line 405 "client.vala"
	_tmp2_ = info;
#line 405 "client.vala"
	_tmp2__length1 = info_length1;
#line 405 "client.vala"
	if (_tmp2__length1 != 3) {
#line 406 "client.vala"
		g_message ("client.vala:406: Format error: \"id seq move\" expected.");
#line 407 "client.vala"
		info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
#line 407 "client.vala"
		return;
#line 2901 "client.c"
	}
#line 409 "client.vala"
	_tmp3_ = info;
#line 409 "client.vala"
	_tmp3__length1 = info_length1;
#line 409 "client.vala"
	_tmp4_ = _tmp3_[0];
#line 409 "client.vala"
	if (self->priv->opponent_id != long_parse (_tmp4_)) {
#line 410 "client.vala"
		g_message ("client.vala:410: Sync error: unexpected opponent id.");
#line 411 "client.vala"
		info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
#line 411 "client.vala"
		return;
#line 2917 "client.c"
	}
#line 413 "client.vala"
	_tmp5_ = info;
#line 413 "client.vala"
	_tmp5__length1 = info_length1;
#line 413 "client.vala"
	_tmp6_ = _tmp5_[1];
#line 413 "client.vala"
	_tmp7_ = info;
#line 413 "client.vala"
	_tmp7__length1 = info_length1;
#line 413 "client.vala"
	_tmp8_ = _tmp7_[2];
#line 413 "client.vala"
	g_signal_emit (self, pasang_client_signals[PASANG_CLIENT_ON_MOVE_RECEIVED_SIGNAL], 0, atoi (_tmp6_), _tmp8_);
#line 399 "client.vala"
	info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
#line 2935 "client.c"
}

/**
     * Update status visually.
     */
void
pasang_client_update_status (PasangClient* self)
{
	const gchar* _tmp0_;
#line 420 "client.vala"
	g_return_if_fail (self != NULL);
#line 422 "client.vala"
	_tmp0_ = self->priv->error_message;
#line 422 "client.vala"
	if (_tmp0_ != NULL) {
#line 2951 "client.c"
		GtkInfoBar* _tmp1_;
		GtkLabel* _tmp2_;
		const gchar* _tmp3_;
		GtkInfoBar* _tmp4_;
#line 423 "client.vala"
		_tmp1_ = self->priv->status_info_bar;
#line 423 "client.vala"
		gtk_info_bar_set_message_type (_tmp1_, GTK_MESSAGE_ERROR);
#line 424 "client.vala"
		_tmp2_ = self->priv->status_info;
#line 424 "client.vala"
		_tmp3_ = self->priv->error_message;
#line 424 "client.vala"
		gtk_label_set_label (_tmp2_, _tmp3_);
#line 425 "client.vala"
		_tmp4_ = self->priv->status_info_bar;
#line 425 "client.vala"
		gtk_widget_show ((GtkWidget*) _tmp4_);
#line 2970 "client.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		GSocketConnection* _tmp7_;
#line 428 "client.vala"
		_tmp7_ = self->priv->connection;
#line 428 "client.vala"
		if (_tmp7_ == NULL) {
#line 428 "client.vala"
			_tmp6_ = TRUE;
#line 2981 "client.c"
		} else {
			const gchar* _tmp8_;
#line 428 "client.vala"
			_tmp8_ = self->priv->user_name;
#line 428 "client.vala"
			_tmp6_ = _tmp8_ == NULL;
#line 2988 "client.c"
		}
#line 428 "client.vala"
		if (_tmp6_) {
#line 428 "client.vala"
			_tmp5_ = TRUE;
#line 2994 "client.c"
		} else {
#line 428 "client.vala"
			_tmp5_ = self->priv->id == ((glong) -1);
#line 2998 "client.c"
		}
#line 428 "client.vala"
		if (_tmp5_) {
#line 3002 "client.c"
			GtkInfoBar* _tmp9_;
#line 429 "client.vala"
			_tmp9_ = self->priv->status_info_bar;
#line 429 "client.vala"
			gtk_widget_hide ((GtkWidget*) _tmp9_);
#line 3008 "client.c"
		} else {
#line 432 "client.vala"
			if (self->priv->opponent_id == ((glong) -1)) {
#line 3012 "client.c"
				GListStore* _tmp10_;
#line 433 "client.vala"
				_tmp10_ = self->priv->player_list;
#line 433 "client.vala"
				if (g_list_model_get_n_items ((GListModel*) _tmp10_) == ((guint) 0)) {
#line 3018 "client.c"
					GtkInfoBar* _tmp11_;
					GtkLabel* _tmp12_;
					GtkInfoBar* _tmp13_;
#line 434 "client.vala"
					_tmp11_ = self->priv->status_info_bar;
#line 434 "client.vala"
					gtk_info_bar_set_message_type (_tmp11_, GTK_MESSAGE_INFO);
#line 435 "client.vala"
					_tmp12_ = self->priv->status_info;
#line 435 "client.vala"
					gtk_label_set_label (_tmp12_, _ ("No other players are available"));
#line 436 "client.vala"
					_tmp13_ = self->priv->status_info_bar;
#line 436 "client.vala"
					gtk_widget_show ((GtkWidget*) _tmp13_);
#line 3034 "client.c"
				} else {
					GtkInfoBar* _tmp14_;
#line 439 "client.vala"
					_tmp14_ = self->priv->status_info_bar;
#line 439 "client.vala"
					gtk_widget_hide ((GtkWidget*) _tmp14_);
#line 3041 "client.c"
				}
			}
		}
	}
}

/**
     * Create menu showing available remote players
     */
static GtkWidget*
__lambda12_ (PasangClient* self,
             GObject* p)
{
	GtkWidget* widget = NULL;
	const gchar* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* result = NULL;
#line 467 "client.vala"
	g_return_val_if_fail (p != NULL, NULL);
#line 468 "client.vala"
	_tmp0_ = (PASANG_IS_NETWORK_PLAYER (p) ? ((PasangNetworkPlayer*) p) : NULL)->name;
#line 468 "client.vala"
	_tmp1_ = pasang_game_menu_create_item (_tmp0_, NULL);
#line 468 "client.vala"
	widget = _tmp1_;
#line 469 "client.vala"
	gtk_widget_show_all (widget);
#line 470 "client.vala"
	result = widget;
#line 470 "client.vala"
	return result;
#line 3073 "client.c"
}

static GtkWidget*
___lambda12__gtk_list_box_create_widget_func (GObject* item,
                                              gpointer self)
{
	GtkWidget* result;
	result = __lambda12_ ((PasangClient*) self, item);
#line 467 "client.vala"
	return result;
#line 3084 "client.c"
}

static void
__lambda13_ (PasangClient* self,
             GtkListBoxRow* row)
{
	gint n = 0;
	PasangNetworkPlayer* p = NULL;
	GListStore* _tmp0_;
	GObject* _tmp1_;
	PasangNetworkPlayer* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 476 "client.vala"
	g_return_if_fail (row != NULL);
#line 477 "client.vala"
	n = gtk_list_box_row_get_index (row);
#line 478 "client.vala"
	_tmp0_ = self->priv->player_list;
#line 478 "client.vala"
	_tmp1_ = g_list_model_get_item ((GListModel*) _tmp0_, (guint) n);
#line 478 "client.vala"
	_tmp2_ = PASANG_IS_NETWORK_PLAYER (_tmp1_) ? ((PasangNetworkPlayer*) _tmp1_) : NULL;
#line 478 "client.vala"
	if (_tmp2_ == NULL) {
#line 478 "client.vala"
		_g_object_unref0 (_tmp1_);
#line 3112 "client.c"
	}
#line 478 "client.vala"
	p = _tmp2_;
#line 479 "client.vala"
	self->priv->challenged_id = p->id;
#line 480 "client.vala"
	_tmp3_ = g_strdup_printf ("CHALLENGE %ld\n", p->id);
#line 480 "client.vala"
	_tmp4_ = _tmp3_;
#line 480 "client.vala"
	pasang_client_send (self, _tmp4_);
#line 480 "client.vala"
	_g_free0 (_tmp4_);
#line 476 "client.vala"
	_g_object_unref0 (p);
#line 3128 "client.c"
}

static void
___lambda13__gtk_list_box_row_activated (GtkListBox* _sender,
                                         GtkListBoxRow* row,
                                         gpointer self)
{
#line 476 "client.vala"
	__lambda13_ ((PasangClient*) self, row);
#line 3138 "client.c"
}

static void
pasang_client_create_menu (PasangClient* self)
{
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkListBox* list_box = NULL;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp8_;
	GtkListBoxRow* _tmp9_;
	GtkListBoxRow* _tmp10_;
	GtkListBox* _tmp11_;
	GtkInfoBar* _tmp12_;
	GtkContainer* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkInfoBar* _tmp16_;
	GListStore* _tmp17_;
	GtkListBox* _tmp18_;
	GtkListBox* _tmp19_;
	GListStore* _tmp20_;
	GtkListBox* _tmp21_;
	GtkListBox* _tmp22_;
	GtkListBox* _tmp23_;
	GtkWidget* _tmp24_;
#line 447 "client.vala"
	g_return_if_fail (self != NULL);
#line 448 "client.vala"
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
#line 448 "client.vala"
	g_object_ref_sink (_tmp0_);
#line 448 "client.vala"
	box = _tmp0_;
#line 449 "client.vala"
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) box);
#line 449 "client.vala"
	gtk_style_context_add_class (_tmp1_, "listbox-menu");
#line 452 "client.vala"
	_tmp2_ = (GtkListBox*) gtk_list_box_new ();
#line 452 "client.vala"
	g_object_ref_sink (_tmp2_);
#line 452 "client.vala"
	list_box = _tmp2_;
#line 453 "client.vala"
	_tmp3_ = list_box;
#line 453 "client.vala"
	_tmp4_ = pasang_client_create_server_setter_button (self);
#line 453 "client.vala"
	_tmp5_ = _tmp4_;
#line 453 "client.vala"
	_tmp6_ = pasang_game_menu_create_item (_ ("Play Online"), _tmp5_);
#line 453 "client.vala"
	_tmp7_ = _tmp6_;
#line 453 "client.vala"
	gtk_container_add ((GtkContainer*) _tmp3_, _tmp7_);
#line 453 "client.vala"
	_g_object_unref0 (_tmp7_);
#line 453 "client.vala"
	_g_object_unref0 (_tmp5_);
#line 454 "client.vala"
	_tmp8_ = list_box;
#line 454 "client.vala"
	_tmp9_ = gtk_list_box_get_row_at_index (_tmp8_, 0);
#line 454 "client.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 454 "client.vala"
	row = _tmp10_;
#line 455 "client.vala"
	gtk_list_box_row_set_activatable (row, FALSE);
#line 456 "client.vala"
	gtk_list_box_row_set_selectable (row, FALSE);
#line 457 "client.vala"
	_tmp11_ = list_box;
#line 457 "client.vala"
	gtk_box_pack_start (box, (GtkWidget*) _tmp11_, FALSE, FALSE, (guint) 0);
#line 460 "client.vala"
	_tmp12_ = self->priv->status_info_bar;
#line 460 "client.vala"
	_tmp13_ = gtk_info_bar_get_content_area (_tmp12_);
#line 460 "client.vala"
	_tmp14_ = self->priv->status_info;
#line 460 "client.vala"
	gtk_container_add (_tmp13_, (GtkWidget*) _tmp14_);
#line 461 "client.vala"
	_tmp15_ = self->priv->status_info;
#line 461 "client.vala"
	g_object_set (_tmp15_, "wrap", TRUE, NULL);
#line 462 "client.vala"
	_tmp16_ = self->priv->status_info_bar;
#line 462 "client.vala"
	gtk_box_pack_start (box, (GtkWidget*) _tmp16_, FALSE, FALSE, (guint) 0);
#line 465 "client.vala"
	_tmp17_ = g_list_store_new (PASANG_TYPE_NETWORK_PLAYER);
#line 465 "client.vala"
	_g_object_unref0 (self->priv->player_list);
#line 465 "client.vala"
	self->priv->player_list = _tmp17_;
#line 466 "client.vala"
	_tmp18_ = (GtkListBox*) gtk_list_box_new ();
#line 466 "client.vala"
	g_object_ref_sink (_tmp18_);
#line 466 "client.vala"
	_g_object_unref0 (list_box);
#line 466 "client.vala"
	list_box = _tmp18_;
#line 467 "client.vala"
	_tmp19_ = list_box;
#line 467 "client.vala"
	_tmp20_ = self->priv->player_list;
#line 467 "client.vala"
	gtk_list_box_bind_model (_tmp19_, (GListModel*) _tmp20_, ___lambda12__gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
#line 472 "client.vala"
	_tmp21_ = list_box;
#line 472 "client.vala"
	gtk_box_pack_start (box, (GtkWidget*) _tmp21_, FALSE, FALSE, (guint) 0);
#line 475 "client.vala"
	_tmp22_ = list_box;
#line 475 "client.vala"
	gtk_list_box_set_selection_mode (_tmp22_, GTK_SELECTION_NONE);
#line 476 "client.vala"
	_tmp23_ = list_box;
#line 476 "client.vala"
	g_signal_connect_object (_tmp23_, "row-activated", (GCallback) ___lambda13__gtk_list_box_row_activated, self, 0);
#line 483 "client.vala"
	_tmp24_ = _g_object_ref0 ((GtkWidget*) box);
#line 483 "client.vala"
	_g_object_unref0 (self->menu);
#line 483 "client.vala"
	self->menu = _tmp24_;
#line 484 "client.vala"
	pasang_client_update_status (self);
#line 447 "client.vala"
	_g_object_unref0 (row);
#line 447 "client.vala"
	_g_object_unref0 (list_box);
#line 447 "client.vala"
	_g_object_unref0 (box);
#line 3284 "client.c"
}

/**
     * Create a switch and a gear button to pop up server configuration
     */
static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 490 "client.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 490 "client.vala"
	return _data2_;
#line 3297 "client.c"
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 490 "client.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 3307 "client.c"
		PasangClient* self;
#line 490 "client.vala"
		self = _data2_->self;
#line 490 "client.vala"
		_g_object_unref0 (_data2_->suis);
#line 490 "client.vala"
		_g_object_unref0 (self);
#line 490 "client.vala"
		g_slice_free (Block2Data, _data2_);
#line 3317 "client.c"
	}
}

static void
__lambda10_ (Block2Data* _data2_)
{
	PasangClient* self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 504 "client.vala"
	self = _data2_->self;
#line 505 "client.vala"
	_g_free0 (self->priv->error_message);
#line 505 "client.vala"
	self->priv->error_message = NULL;
#line 506 "client.vala"
	_tmp1_ = gtk_switch_get_active (_data2_->suis);
#line 506 "client.vala"
	_tmp2_ = _tmp1_;
#line 506 "client.vala"
	if (_tmp2_) {
#line 506 "client.vala"
		_tmp0_ = "login";
#line 3342 "client.c"
	} else {
#line 506 "client.vala"
		_tmp0_ = "logout";
#line 3346 "client.c"
	}
#line 506 "client.vala"
	pasang_client_dispatch (self, _tmp0_);
#line 3350 "client.c"
}

static void
___lambda10__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 504 "client.vala"
	__lambda10_ (self);
#line 3360 "client.c"
}

static void
__lambda11_ (Block2Data* _data2_)
{
	PasangClient* self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 508 "client.vala"
	self = _data2_->self;
#line 509 "client.vala"
	_g_free0 (self->priv->error_message);
#line 509 "client.vala"
	self->priv->error_message = NULL;
#line 510 "client.vala"
	_tmp1_ = gtk_switch_get_active (_data2_->suis);
#line 510 "client.vala"
	_tmp2_ = _tmp1_;
#line 510 "client.vala"
	if (_tmp2_) {
#line 510 "client.vala"
		_tmp0_ = "login";
#line 3384 "client.c"
	} else {
#line 510 "client.vala"
		_tmp0_ = "logout";
#line 3388 "client.c"
	}
#line 510 "client.vala"
	pasang_client_dispatch (self, _tmp0_);
#line 3392 "client.c"
}

static void
___lambda11__gtk_popover_closed (GtkPopover* _sender,
                                 gpointer self)
{
#line 508 "client.vala"
	__lambda11_ (self);
#line 3401 "client.c"
}

static GtkWidget*
pasang_client_create_server_setter_button (PasangClient* self)
{
	Block2Data* _data2_;
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkMenuButton* button = NULL;
	GtkMenuButton* _tmp1_;
	GtkImage* _tmp2_;
	GtkImage* _tmp3_;
	GtkPopover* popover = NULL;
	GtkPopover* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkSwitch* _tmp7_;
	GtkWidget* result = NULL;
#line 490 "client.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 490 "client.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 490 "client.vala"
	_data2_->_ref_count_ = 1;
#line 490 "client.vala"
	_data2_->self = g_object_ref (self);
#line 491 "client.vala"
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 491 "client.vala"
	g_object_ref_sink (_tmp0_);
#line 491 "client.vala"
	box = _tmp0_;
#line 493 "client.vala"
	_tmp1_ = (GtkMenuButton*) gtk_menu_button_new ();
#line 493 "client.vala"
	g_object_ref_sink (_tmp1_);
#line 493 "client.vala"
	button = _tmp1_;
#line 494 "client.vala"
	_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name ("emblem-system-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
#line 494 "client.vala"
	g_object_ref_sink (_tmp2_);
#line 494 "client.vala"
	_tmp3_ = _tmp2_;
#line 494 "client.vala"
	gtk_button_set_image ((GtkButton*) button, (GtkWidget*) _tmp3_);
#line 494 "client.vala"
	_g_object_unref0 (_tmp3_);
#line 495 "client.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) button, _ ("Configure login"));
#line 496 "client.vala"
	_tmp4_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) button);
#line 496 "client.vala"
	g_object_ref_sink (_tmp4_);
#line 496 "client.vala"
	popover = _tmp4_;
#line 497 "client.vala"
	_tmp5_ = pasang_client_create_configuration_widget (self, popover);
#line 497 "client.vala"
	_tmp6_ = _tmp5_;
#line 497 "client.vala"
	gtk_container_add ((GtkContainer*) popover, (GtkWidget*) _tmp6_);
#line 497 "client.vala"
	_g_object_unref0 (_tmp6_);
#line 498 "client.vala"
	gtk_menu_button_set_popover (button, popover);
#line 500 "client.vala"
	_tmp7_ = (GtkSwitch*) gtk_switch_new ();
#line 500 "client.vala"
	g_object_ref_sink (_tmp7_);
#line 500 "client.vala"
	_data2_->suis = _tmp7_;
#line 501 "client.vala"
	gtk_switch_set_active (_data2_->suis, FALSE);
#line 504 "client.vala"
	g_signal_connect_data ((GObject*) _data2_->suis, "notify::active", (GCallback) ___lambda10__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 508 "client.vala"
	g_signal_connect_data (popover, "closed", (GCallback) ___lambda11__gtk_popover_closed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 513 "client.vala"
	gtk_widget_set_valign ((GtkWidget*) _data2_->suis, GTK_ALIGN_CENTER);
#line 514 "client.vala"
	gtk_box_pack_start (box, (GtkWidget*) _data2_->suis, FALSE, FALSE, (guint) 5);
#line 515 "client.vala"
	gtk_box_pack_end (box, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
#line 516 "client.vala"
	result = (GtkWidget*) box;
#line 516 "client.vala"
	_g_object_unref0 (popover);
#line 516 "client.vala"
	_g_object_unref0 (button);
#line 516 "client.vala"
	block2_data_unref (_data2_);
#line 516 "client.vala"
	_data2_ = NULL;
#line 516 "client.vala"
	return result;
#line 3498 "client.c"
}

/**
     * Create widget to enter :
     *    Server name, Port number, and User name
     */
static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 523 "client.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 523 "client.vala"
	return _data3_;
#line 3512 "client.c"
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 523 "client.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 3522 "client.c"
		PasangClient* self;
#line 523 "client.vala"
		self = _data3_->self;
#line 523 "client.vala"
		_g_object_unref0 (_data3_->popover);
#line 523 "client.vala"
		_g_object_unref0 (self);
#line 523 "client.vala"
		g_slice_free (Block3Data, _data3_);
#line 3532 "client.c"
	}
}

static void
__lambda7_ (Block3Data* _data3_)
{
	PasangClient* self;
#line 555 "client.vala"
	self = _data3_->self;
#line 555 "client.vala"
	g_signal_emit_by_name (_data3_->popover, "closed");
#line 3544 "client.c"
}

static void
___lambda7__gtk_entry_activate (GtkEntry* _sender,
                                gpointer self)
{
#line 555 "client.vala"
	__lambda7_ (self);
#line 3553 "client.c"
}

static void
__lambda8_ (Block3Data* _data3_)
{
	PasangClient* self;
#line 556 "client.vala"
	self = _data3_->self;
#line 556 "client.vala"
	g_signal_emit_by_name (_data3_->popover, "closed");
#line 3564 "client.c"
}

static void
___lambda8__gtk_entry_activate (GtkEntry* _sender,
                                gpointer self)
{
#line 556 "client.vala"
	__lambda8_ (self);
#line 3573 "client.c"
}

static void
__lambda9_ (Block3Data* _data3_)
{
	PasangClient* self;
#line 557 "client.vala"
	self = _data3_->self;
#line 557 "client.vala"
	g_signal_emit_by_name (_data3_->popover, "closed");
#line 3584 "client.c"
}

static void
___lambda9__gtk_entry_activate (GtkEntry* _sender,
                                gpointer self)
{
#line 557 "client.vala"
	__lambda9_ (self);
#line 3593 "client.c"
}

static GtkBox*
pasang_client_create_configuration_widget (PasangClient* self,
                                           GtkPopover* popover)
{
	Block3Data* _data3_;
	GtkPopover* _tmp0_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkEntry* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkEntry* _tmp11_;
	GtkEntry* _tmp12_;
	GtkEntry* _tmp13_;
	GtkEntry* _tmp14_;
	GtkEntry* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkEntry* _tmp18_;
	gchar* cmd = NULL;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	GtkLabel* footnote = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkEntry* _tmp25_;
	GtkEntry* _tmp26_;
	GtkEntry* _tmp27_;
	GtkBox* box = NULL;
	GtkBox* _tmp28_;
	GtkSeparator* _tmp29_;
	GtkSeparator* _tmp30_;
	GtkStyleContext* _tmp31_;
	GtkBox* result = NULL;
#line 523 "client.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 523 "client.vala"
	g_return_val_if_fail (popover != NULL, NULL);
#line 523 "client.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 523 "client.vala"
	_data3_->_ref_count_ = 1;
#line 523 "client.vala"
	_data3_->self = g_object_ref (self);
#line 523 "client.vala"
	_tmp0_ = _g_object_ref0 (popover);
#line 523 "client.vala"
	_g_object_unref0 (_data3_->popover);
#line 523 "client.vala"
	_data3_->popover = _tmp0_;
#line 524 "client.vala"
	_tmp1_ = (GtkGrid*) gtk_grid_new ();
#line 524 "client.vala"
	g_object_ref_sink (_tmp1_);
#line 524 "client.vala"
	grid = _tmp1_;
#line 525 "client.vala"
	gtk_grid_set_row_spacing (grid, (guint) 10);
#line 526 "client.vala"
	gtk_grid_set_column_spacing (grid, (guint) 10);
#line 527 "client.vala"
	_tmp2_ = self->priv->server_address_entry;
#line 527 "client.vala"
	gtk_entry_set_text (_tmp2_, "localhost");
#line 528 "client.vala"
	_tmp3_ = self->priv->server_address_entry;
#line 528 "client.vala"
	gtk_entry_set_width_chars (_tmp3_, 25);
#line 529 "client.vala"
	_tmp4_ = self->priv->server_port_entry;
#line 529 "client.vala"
	gtk_entry_set_text (_tmp4_, "3812");
#line 530 "client.vala"
	_tmp5_ = self->priv->server_port_entry;
#line 530 "client.vala"
	gtk_entry_set_width_chars (_tmp5_, 6);
#line 531 "client.vala"
	_tmp6_ = (GtkLabel*) gtk_label_new (_ ("Server:"));
#line 531 "client.vala"
	g_object_ref_sink (_tmp6_);
#line 531 "client.vala"
	_tmp7_ = _tmp6_;
#line 531 "client.vala"
	gtk_grid_attach (grid, (GtkWidget*) _tmp7_, 0, 0, 1, 1);
#line 531 "client.vala"
	_g_object_unref0 (_tmp7_);
#line 532 "client.vala"
	_tmp8_ = self->priv->server_address_entry;
#line 532 "client.vala"
	gtk_grid_attach (grid, (GtkWidget*) _tmp8_, 1, 0, 1, 1);
#line 533 "client.vala"
	_tmp9_ = (GtkLabel*) gtk_label_new (_ ("Port:"));
#line 533 "client.vala"
	g_object_ref_sink (_tmp9_);
#line 533 "client.vala"
	_tmp10_ = _tmp9_;
#line 533 "client.vala"
	gtk_grid_attach (grid, (GtkWidget*) _tmp10_, 2, 0, 1, 1);
#line 533 "client.vala"
	_g_object_unref0 (_tmp10_);
#line 534 "client.vala"
	_tmp11_ = self->priv->server_port_entry;
#line 534 "client.vala"
	gtk_grid_attach (grid, (GtkWidget*) _tmp11_, 3, 0, 1, 1);
#line 535 "client.vala"
	_tmp12_ = self->priv->server_address_entry;
#line 535 "client.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
#line 538 "client.vala"
	_tmp13_ = self->priv->user_name_entry;
#line 538 "client.vala"
	gtk_entry_set_text (_tmp13_, "");
#line 539 "client.vala"
	_tmp14_ = self->priv->user_name_entry;
#line 539 "client.vala"
	gtk_entry_set_placeholder_text (_tmp14_, _ ("Name seen by other players"));
#line 540 "client.vala"
	_tmp15_ = self->priv->user_name_entry;
#line 540 "client.vala"
	gtk_entry_set_width_chars (_tmp15_, 30);
#line 541 "client.vala"
	_tmp16_ = (GtkLabel*) gtk_label_new (_ ("Name:"));
#line 541 "client.vala"
	g_object_ref_sink (_tmp16_);
#line 541 "client.vala"
	_tmp17_ = _tmp16_;
#line 541 "client.vala"
	gtk_grid_attach (grid, (GtkWidget*) _tmp17_, 0, 1, 1, 1);
#line 541 "client.vala"
	_g_object_unref0 (_tmp17_);
#line 542 "client.vala"
	_tmp18_ = self->priv->user_name_entry;
#line 542 "client.vala"
	gtk_grid_attach (grid, (GtkWidget*) _tmp18_, 1, 1, 3, 1);
#line 545 "client.vala"
	_tmp19_ = pasang_reloc_exe_name;
#line 545 "client.vala"
	_tmp20_ = g_strconcat (_tmp19_, " --server", NULL);
#line 545 "client.vala"
	cmd = _tmp20_;
#line 546 "client.vala"
	_tmp21_ = g_strdup_printf (_ ("Note: to run a game server, enter the command\n" \
"   <tt>%s</tt>\n" \
"on a terminal."), cmd);
#line 546 "client.vala"
	_tmp22_ = _tmp21_;
#line 546 "client.vala"
	_tmp23_ = (GtkLabel*) gtk_label_new (_tmp22_);
#line 546 "client.vala"
	g_object_ref_sink (_tmp23_);
#line 546 "client.vala"
	_tmp24_ = _tmp23_;
#line 546 "client.vala"
	_g_free0 (_tmp22_);
#line 546 "client.vala"
	footnote = _tmp24_;
#line 549 "client.vala"
	gtk_label_set_use_markup (footnote, TRUE);
#line 550 "client.vala"
	gtk_label_set_max_width_chars (footnote, 40);
#line 551 "client.vala"
	g_object_set (footnote, "wrap", TRUE, NULL);
#line 552 "client.vala"
	g_object_set (footnote, "wrap-mode", PANGO_WRAP_WORD, NULL);
#line 555 "client.vala"
	_tmp25_ = self->priv->server_address_entry;
#line 555 "client.vala"
	g_signal_connect_data (_tmp25_, "activate", (GCallback) ___lambda7__gtk_entry_activate, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 556 "client.vala"
	_tmp26_ = self->priv->server_port_entry;
#line 556 "client.vala"
	g_signal_connect_data (_tmp26_, "activate", (GCallback) ___lambda8__gtk_entry_activate, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 557 "client.vala"
	_tmp27_ = self->priv->user_name_entry;
#line 557 "client.vala"
	g_signal_connect_data (_tmp27_, "activate", (GCallback) ___lambda9__gtk_entry_activate, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 559 "client.vala"
	_tmp28_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 10);
#line 559 "client.vala"
	g_object_ref_sink (_tmp28_);
#line 559 "client.vala"
	box = _tmp28_;
#line 560 "client.vala"
	gtk_box_pack_start (box, (GtkWidget*) grid, TRUE, TRUE, (guint) 0);
#line 561 "client.vala"
	_tmp29_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
#line 561 "client.vala"
	g_object_ref_sink (_tmp29_);
#line 561 "client.vala"
	_tmp30_ = _tmp29_;
#line 561 "client.vala"
	gtk_box_pack_start (box, (GtkWidget*) _tmp30_, TRUE, TRUE, (guint) 0);
#line 561 "client.vala"
	_g_object_unref0 (_tmp30_);
#line 562 "client.vala"
	gtk_box_pack_start (box, (GtkWidget*) footnote, TRUE, TRUE, (guint) 0);
#line 563 "client.vala"
	_tmp31_ = gtk_widget_get_style_context ((GtkWidget*) box);
#line 563 "client.vala"
	gtk_style_context_add_class (_tmp31_, "box-top-level");
#line 564 "client.vala"
	gtk_widget_show_all ((GtkWidget*) box);
#line 565 "client.vala"
	result = box;
#line 565 "client.vala"
	_g_object_unref0 (footnote);
#line 565 "client.vala"
	_g_free0 (cmd);
#line 565 "client.vala"
	_g_object_unref0 (grid);
#line 565 "client.vala"
	block3_data_unref (_data3_);
#line 565 "client.vala"
	_data3_ = NULL;
#line 565 "client.vala"
	return result;
#line 3818 "client.c"
}

static void
g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_STRING) (gpointer data1, gint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 26 "client.vala"
	g_return_if_fail (n_param_values == 3);
#line 26 "client.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 26 "client.vala"
		data1 = closure->data;
#line 26 "client.vala"
		data2 = param_values->data[0].v_pointer;
#line 3843 "client.c"
	} else {
#line 26 "client.vala"
		data1 = param_values->data[0].v_pointer;
#line 26 "client.vala"
		data2 = closure->data;
#line 3849 "client.c"
	}
#line 26 "client.vala"
	callback = (GMarshalFunc_VOID__INT_STRING) (marshal_data ? marshal_data : cc->callback);
#line 26 "client.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 3855 "client.c"
}

static void
pasang_client_class_init (PasangClientClass * klass,
                          gpointer klass_data)
{
#line 26 "client.vala"
	pasang_client_parent_class = g_type_class_peek_parent (klass);
#line 26 "client.vala"
	g_type_class_adjust_private_offset (klass, &PasangClient_private_offset);
#line 26 "client.vala"
	G_OBJECT_CLASS (klass)->finalize = pasang_client_finalize;
#line 3868 "client.c"
	/**
	     * Signals relevant for game state.
	     */
#line 26 "client.vala"
	pasang_client_signals[PASANG_CLIENT_ON_JOIN_GAME_SIGNAL] = g_signal_new ("on-join-game", PASANG_TYPE_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 26 "client.vala"
	pasang_client_signals[PASANG_CLIENT_ON_LEAVE_GAME_SIGNAL] = g_signal_new ("on-leave-game", PASANG_TYPE_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 26 "client.vala"
	pasang_client_signals[PASANG_CLIENT_ON_MOVE_RECEIVED_SIGNAL] = g_signal_new ("on-move-received", PASANG_TYPE_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_STRING, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_STRING);
#line 3878 "client.c"
}

static void
pasang_client_instance_init (PasangClient * self,
                             gpointer klass)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkInfoBar* _tmp3_;
	GtkLabel* _tmp4_;
	GCancellable* _tmp5_;
	GQueue* _tmp6_;
	gchar* _tmp7_;
#line 26 "client.vala"
	self->priv = pasang_client_get_instance_private (self);
#line 49 "client.vala"
	_tmp0_ = (GtkEntry*) gtk_entry_new ();
#line 49 "client.vala"
	g_object_ref_sink (_tmp0_);
#line 49 "client.vala"
	self->priv->server_address_entry = _tmp0_;
#line 50 "client.vala"
	_tmp1_ = (GtkEntry*) gtk_entry_new ();
#line 50 "client.vala"
	g_object_ref_sink (_tmp1_);
#line 50 "client.vala"
	self->priv->server_port_entry = _tmp1_;
#line 51 "client.vala"
	_tmp2_ = (GtkEntry*) gtk_entry_new ();
#line 51 "client.vala"
	g_object_ref_sink (_tmp2_);
#line 51 "client.vala"
	self->priv->user_name_entry = _tmp2_;
#line 56 "client.vala"
	_tmp3_ = (GtkInfoBar*) gtk_info_bar_new ();
#line 56 "client.vala"
	g_object_ref_sink (_tmp3_);
#line 56 "client.vala"
	self->priv->status_info_bar = _tmp3_;
#line 57 "client.vala"
	_tmp4_ = (GtkLabel*) gtk_label_new (NULL);
#line 57 "client.vala"
	g_object_ref_sink (_tmp4_);
#line 57 "client.vala"
	self->priv->status_info = _tmp4_;
#line 58 "client.vala"
	self->priv->error_message = NULL;
#line 63 "client.vala"
	_tmp5_ = g_cancellable_new ();
#line 63 "client.vala"
	self->priv->dispatcher_cancellable = _tmp5_;
#line 64 "client.vala"
	_tmp6_ = g_queue_new ();
#line 64 "client.vala"
	self->priv->dispatcher_queue = _tmp6_;
#line 65 "client.vala"
	self->priv->connection = NULL;
#line 66 "client.vala"
	self->priv->input = NULL;
#line 67 "client.vala"
	self->priv->output = NULL;
#line 72 "client.vala"
	self->priv->id = (glong) -1;
#line 73 "client.vala"
	self->priv->user_name = NULL;
#line 74 "client.vala"
	self->priv->opponent_id = (glong) -1;
#line 75 "client.vala"
	_tmp7_ = g_strdup ("");
#line 75 "client.vala"
	self->opponent_name = _tmp7_;
#line 80 "client.vala"
	self->priv->challenged_id = (glong) -1;
#line 3953 "client.c"
}

static void
pasang_client_finalize (GObject * obj)
{
	PasangClient * self;
#line 26 "client.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_CLIENT, PasangClient);
#line 27 "client.vala"
	_g_object_unref0 (self->menu);
#line 39 "client.vala"
	_g_object_unref0 (self->priv->parent);
#line 44 "client.vala"
	_g_object_unref0 (self->priv->player_list);
#line 49 "client.vala"
	_g_object_unref0 (self->priv->server_address_entry);
#line 50 "client.vala"
	_g_object_unref0 (self->priv->server_port_entry);
#line 51 "client.vala"
	_g_object_unref0 (self->priv->user_name_entry);
#line 56 "client.vala"
	_g_object_unref0 (self->priv->status_info_bar);
#line 57 "client.vala"
	_g_object_unref0 (self->priv->status_info);
#line 58 "client.vala"
	_g_free0 (self->priv->error_message);
#line 63 "client.vala"
	_g_object_unref0 (self->priv->dispatcher_cancellable);
#line 64 "client.vala"
	(self->priv->dispatcher_queue == NULL) ? NULL : (self->priv->dispatcher_queue = (_g_queue_free__g_free0_ (self->priv->dispatcher_queue), NULL));
#line 65 "client.vala"
	_g_object_unref0 (self->priv->connection);
#line 66 "client.vala"
	_g_object_unref0 (self->priv->input);
#line 67 "client.vala"
	_g_object_unref0 (self->priv->output);
#line 73 "client.vala"
	_g_free0 (self->priv->user_name);
#line 75 "client.vala"
	_g_free0 (self->opponent_name);
#line 26 "client.vala"
	G_OBJECT_CLASS (pasang_client_parent_class)->finalize (obj);
#line 3996 "client.c"
}

GType
pasang_client_get_type (void)
{
	static volatile gsize pasang_client_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangClient), 0, (GInstanceInitFunc) pasang_client_instance_init, NULL };
		GType pasang_client_type_id;
		pasang_client_type_id = g_type_register_static (G_TYPE_OBJECT, "PasangClient", &g_define_type_info, 0);
		PasangClient_private_offset = g_type_add_instance_private (pasang_client_type_id, sizeof (PasangClientPrivate));
		g_once_init_leave (&pasang_client_type_id__volatile, pasang_client_type_id);
	}
	return pasang_client_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

