/* Memory management */
extern void free_bond (struct Bond *bond);
extern void free_bond_list (struct Bond *list);


extern struct Bond *copy_bond (struct Bond *bond);
extern void concat_bond_lists (struct Bond *list1, struct Bond *list2,
                                       int *num_sel);
extern int num_sel_recompute (struct Bond *list);
extern void duplicate_selected_in_list (struct Bond *list);
extern void update_sel_close (struct Bond *list);
extern void remove_duplicate_in_list (struct Bond **list, int *nul_sel);
extern void remove_empty_groups (struct Bond **list, int *nul_sel);
extern struct Bond *copy_bond_list (struct Bond *list);
extern struct Bond *add_bond (const LLINT x1, const LLINT y1,
			      const LLINT x2, const LLINT y2, const int type,
			      struct Bond **list, const int options);
extern struct Bond *add_atom (const LLINT x, const LLINT y,
			      struct Bond **list, const int type);
extern struct Bond * closest_end_of_bond (const LLINT x, const LLINT y,
	                                  unsigned int *end, struct Bond *list,
					  double * dist,
					  const double sensibility);
extern struct Bond *closest_bond (const LLINT x, const LLINT y,
				  struct Bond *list, const LLINT sensibility);
extern double distance_to_bond (const LLINT x, const LLINT y,
				struct Bond *bond);
extern void clear_selection (struct Bond *list, int *num_sel);
extern void clear_selection_attribute (struct Bond *list,
				       const int attribute);
extern void select_in_rectangle (LLINT x1, LLINT y1,
				 LLINT x2, LLINT y2, struct Bond *list,
				 int *num_sel);
extern void change_in_rectangle (LLINT x1, LLINT y1,
				 LLINT x2, LLINT y2, struct Bond *list,
				 int *num_sel);
extern void select_molecule (struct Bond *list, struct Bond *ref,
			     int *num_sel);
extern void select_add_molecule (struct Bond *list, struct Bond *ref,
				 int *num_sel);
extern void delete_bond (struct Bond **list, struct Bond *ref, int *num_sel);
extern void delete_molecule (struct Bond **list, struct Bond *ref,
			     int *num_sel);
extern int update_num_sel (struct Bond *list);
extern int closest_point (struct Bond *list, LLINT * x, LLINT * y,
			  LLINT sensibility);
extern void center_of_selection (struct Bond *list, LLINT * x, LLINT * y);
extern void delete_selection (struct Bond **list, int *num_sel);
extern struct Bond * copy_selection (struct Bond *list, LLINT xshift,
                                     LLINT yshift);
extern void save_list_bonds (struct Bond *list, FILE * file, const int debug,
			     const int no_title);
extern struct Bond *load_list_bonds (FILE * file, const int recursive,
                                     const int shift);
extern void move_bond_from_pos (struct Bond *new, struct Bond *old,
				const LLINT x, const LLINT y);
extern void move_point_from_pos (struct Bond *new, struct Bond *old,
				 const LLINT x_point, const LLINT y_point,
				 const LLINT x, const LLINT y);
extern void move_point_close (struct Bond *new, struct Bond *old,
			      const LLINT x, const LLINT y);
extern int generate_points (struct Bond *list, LLINT ** x, LLINT ** y,
			    short int **sel);
extern void rotate_angle (struct Bond *list_new, struct Bond *list_old,
			  const LLINT x_orig, const LLINT y_orig,
			  const double st, const double ct,
			  const int recursive);
extern int unmodified (struct Bond *list, const char filename[]);
extern void select_all (struct Bond *list, int *num_sel);

/* Grouping and ungrouping */
extern void group_selection (struct Bond **list, int *num_sel);
extern void ungroup_selection (struct Bond **list, int *num_sel);

extern void bounds_of_list (struct Bond *list, LLINT * xmin,
			    LLINT * xmax, LLINT * ymin, LLINT * ymax);
extern void bounds_of_selection (struct Bond *list, LLINT * xmin,
				 LLINT * xmax, LLINT * ymin, LLINT * ymax);
extern void bounds_of_bond (struct Bond *bond, LLINT * xmin, LLINT * xmax,
			    LLINT * ymin, LLINT * ymax, const int groups);
extern int is_similar (struct Bond *bond1, struct Bond *bond2);
extern double distance_to_bond_list (const LLINT x, const LLINT y,
				     struct Bond *list);
extern int bonds_are_close (struct Bond *bond1, struct Bond *bond2);
extern void update_bounds_of_group (struct Bond *group);
extern int bond_list_are_similar (struct Bond *list1, struct Bond *list2);
extern void align_selection (struct Bond *list, const int horizontal,
			     const int vertical);
extern int text_to_pango (struct Bond *bond);
extern unsigned int corresponding_bracket (const gchar * text,
                                           const unsigned p);
extern gchar *richtext_to_pango (const gchar * text, const unsigned int p1i,
                                 const unsigned int p2i);
extern int parts_of_group_text (struct Bond *bond, gchar ** left,
                                gchar ** right);
extern gchar * centered_part_of_group (struct Bond *bond);

/* Ornaments */
extern struct Bond * delete_ornaments_on_point (struct Bond *list,
	                                        const LLINT x, const LLINT y);
extern unsigned int gather_ornaments_on_point
  (struct Bond *list, struct Ornament orns[], const unsigned int max,
   const LLINT x, const LLINT y);

