/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.SSLMessages;
import java.io.Serializable;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class NullTrustManager
implements X509TrustManager,
Serializable {
    @NotNull
    private static final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];
    @NotNull
    private static final NullTrustManager INSTANCE = new NullTrustManager();
    private static final long serialVersionUID = 2435783503919293156L;

    private NullTrustManager() {
    }

    @NotNull
    public static NullTrustManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        throw new CertificateException(SSLMessages.ERR_NULL_TRUST_MANAGER_CERT_NOT_TRUSTED.get());
    }

    @Override
    public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        throw new CertificateException(SSLMessages.ERR_NULL_TRUST_MANAGER_CERT_NOT_TRUSTED.get());
    }

    @Override
    @NotNull
    public X509Certificate[] getAcceptedIssuers() {
        return NO_CERTIFICATES;
    }
}

