// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv32 -target-feature +xandesperf -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg \
// RUN:     | FileCheck %s

#include <stdint.h>
#include <riscv_nds.h>

// CHECK-LABEL: @test_ffb(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.nds.ffb.i32(i32 [[A:%.*]], i32 [[B:%.*]])
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int32_t test_ffb(uint32_t a, uint32_t b) {
  return __riscv_nds_ffb_32(a, b);
}

// CHECK-LABEL: @test_ffzmism(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.nds.ffzmism.i32(i32 [[A:%.*]], i32 [[B:%.*]])
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int32_t test_ffzmism(uint32_t a, uint32_t b) {
  return __riscv_nds_ffzmism_32(a, b);
}

// CHECK-LABEL: @test_ffmism(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.nds.ffmism.i32(i32 [[A:%.*]], i32 [[B:%.*]])
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int32_t test_ffmism(uint32_t a, uint32_t b) {
  return __riscv_nds_ffmism_32(a, b);
}

// CHECK-LABEL: @test_flmism(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.nds.flmism.i32(i32 [[A:%.*]], i32 [[B:%.*]])
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int32_t test_flmism(uint32_t a, uint32_t b) {
  return __riscv_nds_flmism_32(a, b);
}
