#include "hinfo_rr.h"

namespace ADNS {

	HINFO_RR::HINFO_RR()
	{
		cpu = gcnew DNS_CHARSTRING();
		os = gcnew DNS_CHARSTRING();
		rr_type = RR_TYPE::HINFO;
		rr_class = RR_CLASS::IN;
		UpdateRdata();
	}

	Void HINFO_RR::UpdateRdata()
	{
		if (!rdata)
			rdata = gcnew array<Byte>(cpu->GetCharacterString()->Length + os->GetCharacterString()->Length);
		else
			rdata->Resize(rdata,cpu->GetCharacterString()->Length + os->GetCharacterString()->Length);

		cpu->GetCharacterString()->CopyTo(rdata,0);
		os->GetCharacterString()->CopyTo(rdata,cpu->GetCharacterString()->Length);

		return;
	}

	DNS_CHARSTRING^ HINFO_RR::GetCpu()
	{
		return cpu->Clone();
	}

	DNS_CHARSTRING^ HINFO_RR::GetOS()
	{	
		return os->Clone();
	}

	Void HINFO_RR::SetCpu(array<Byte>^ c)
	{
		cpu->SetCharacterString(c);
		UpdateRdata();
	}

	Void HINFO_RR::SetCpu(String^ c)
	{
		cpu->SetCharacterString(c);
		UpdateRdata();
	}

	Void HINFO_RR::SetOS(array<Byte>^ o)
	{
		cpu->SetCharacterString(o);
		UpdateRdata();
	}

	Void HINFO_RR::SetOS(String^ o)
	{
		cpu->SetCharacterString(o);
		UpdateRdata();
	}

	String^ HINFO_RR::Print()
	{
		String^ output;
		output = PrintHeader();
		output += cpu->Print();
		output += " ";
		output += os->Print();

		return output;
	}

	Void HINFO_RR::ToCanonical()
	{
		owner->MakeCanonical();
		return;
	}

	HINFO_RR^ HINFO_RR::Clone()
	{
		HINFO_RR^ newrr = gcnew HINFO_RR();
		newrr->rr_type = rr_type;
		newrr->owner = owner->Clone();
		newrr->ttl = ttl;
		newrr->rr_class = rr_class;
		newrr->os = os->Clone();
		newrr->cpu = cpu->Clone();
		UpdateRdata();
		return newrr;
	}

	ResourceRecord^ HINFO_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
	{
		HINFO_RR^ hinfoout;
		array<Byte>^ tmparray;
		int pos;
		int len;

		hinfoout = gcnew HINFO_RR();				
		//Set the RR header info
		hinfoout->owner = gcnew DOMAIN_NAME(domainname);
		hinfoout->ttl = ttl;
		hinfoout->rr_class = (RR_CLASS) rr_class;
		// Set the CPU character string
		pos = rdata_start;
		len = packet[pos++];
		tmparray = gcnew array<Byte>(len);
		packet->Copy(packet,pos,tmparray,0,len);
		hinfoout->SetCpu(tmparray);
		pos += len;
		// Set the OS character string
		len = packet[pos++];
		tmparray = gcnew array<Byte>(len);
		packet->Copy(packet,pos,tmparray,0,len);
		hinfoout->SetOS(tmparray);
		return hinfoout;
	}

	String^ HINFO_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<HINFO_RR^>(rec)->Print();
	}

	ResourceRecord^ HINFO_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<HINFO_RR^>(rec)->Clone();
	}
}