/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo, Marko Mattila

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __CLIENT_NET_H__
#define __CLIENT_NET_H__

#include "SDL.h"
#include "SDL_net.h"
#include "SDL_thread.h"
#include "globals.h"
#include "monitor_queue.h"
#include "msg.h"
#include <cassert>
#include <string>

#define CHECK_WAIT 1000

class client_net
{
 public:
  virtual msg *recv() throw (string &) = 0;
  virtual void send(msg * m) throw (string &) = 0;
  virtual bool has_msgs() throw (string &) = 0; 
  virtual void disconnect() = 0;
};

class client_tcpnet : public client_net
{
 public:
  client_tcpnet(IPaddress *serv_ip) throw (string &);
  virtual ~client_tcpnet();

  msg *recv() throw (string &);
  void send(msg * m) throw (string &);
  bool has_msgs() throw (string &);
  void disconnect();

 protected:
  TCPsocket socket;
  SDLNet_SocketSet socketset;
  SDL_Thread *trans_th;
  SDL_Thread *input_th;
  bool active;
  monitor_queue<msg *> in;
  monitor_queue<msg *> out;
  string send_err;
  string rec_err;
  SDL_cond *cond;
  SDL_mutex *mutex;

  static int transf_func(void *data);
  static int input_func(void *data);
};

class client_localnet : public client_net
{
 public:
  client_localnet();
  virtual ~client_localnet();

  msg *recv() throw (string &);
  void send(msg * m) throw (string &);
  bool has_msgs() throw (string &);
  void disconnect();

  monitor_queue<msg *> * get_in_queue();
  monitor_queue<msg *> * get_out_queue();

 protected:
  monitor_queue<msg *> in;
  monitor_queue<msg *> out;
};

#endif
