/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.math.ec.ECPoint;

public abstract class ECPublicBCPGKey
extends BCPGObject
implements BCPGKey {
    ASN1ObjectIdentifier oid;
    BigInteger point;

    protected ECPublicBCPGKey(BCPGInputStream bCPGInputStream) throws IOException {
        this.oid = ASN1ObjectIdentifier.getInstance(ASN1Primitive.fromByteArray(ECPublicBCPGKey.readBytesOfEncodedLength(bCPGInputStream)));
        this.point = new MPInteger(bCPGInputStream).getValue();
    }

    protected ECPublicBCPGKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, ECPoint eCPoint) {
        this.point = new BigInteger(1, eCPoint.getEncoded(false));
        this.oid = aSN1ObjectIdentifier;
    }

    protected ECPublicBCPGKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, BigInteger bigInteger) {
        this.point = bigInteger;
        this.oid = aSN1ObjectIdentifier;
    }

    public String getFormat() {
        return "PGP";
    }

    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        byte[] byArray = this.oid.getEncoded();
        bCPGOutputStream.write(byArray, 1, byArray.length - 1);
        MPInteger mPInteger = new MPInteger(this.point);
        bCPGOutputStream.writeObject(mPInteger);
    }

    public BigInteger getEncodedPoint() {
        return this.point;
    }

    public ASN1ObjectIdentifier getCurveOID() {
        return this.oid;
    }

    protected static byte[] readBytesOfEncodedLength(BCPGInputStream bCPGInputStream) throws IOException {
        int n = bCPGInputStream.read();
        if (n < 0) {
            throw new IOException("unexpected end-of-stream");
        }
        if (n == 0 || n == 255) {
            throw new IOException("future extensions not yet implemented");
        }
        if (n > 127) {
            throw new IOException("unsupported OID");
        }
        byte[] byArray = new byte[n + 2];
        bCPGInputStream.readFully(byArray, 2, byArray.length - 2);
        byArray[0] = 6;
        byArray[1] = (byte)n;
        return byArray;
    }
}

