/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.sike;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import org.bouncycastle.pqc.legacy.crypto.sike.SIKEEngine;
import org.bouncycastle.pqc.legacy.crypto.sike.SIKEPublicKeyParameters;

public class SIKEKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public SIKEKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("SIKEKEM", 0, asymmetricKeyParameter, CryptoServicePurpose.ENCRYPTION));
        SIKEPublicKeyParameters sIKEPublicKeyParameters = (SIKEPublicKeyParameters)asymmetricKeyParameter;
        SIKEEngine sIKEEngine = sIKEPublicKeyParameters.getParameters().getEngine();
        return this.generateEncapsulated(asymmetricKeyParameter, sIKEEngine.getDefaultSessionKeySize());
    }

    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter, int n) {
        System.err.println("WARNING: the SIKE algorithm is only for research purposes, insecure");
        SIKEPublicKeyParameters sIKEPublicKeyParameters = (SIKEPublicKeyParameters)asymmetricKeyParameter;
        SIKEEngine sIKEEngine = sIKEPublicKeyParameters.getParameters().getEngine();
        byte[] byArray = new byte[sIKEEngine.getCipherTextSize()];
        byte[] byArray2 = new byte[n / 8];
        sIKEEngine.crypto_kem_enc(byArray, byArray2, sIKEPublicKeyParameters.getPublicKey(), this.sr);
        return new SecretWithEncapsulationImpl(byArray2, byArray);
    }
}

