/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.workgroup.agent.AgentSession;
import org.jivesoftware.smackx.workgroup.agent.OfferContent;
import org.jxmpp.jid.Jid;

public class Offer {
    private final XMPPConnection connection;
    private final AgentSession session;
    private final String sessionID;
    private final Jid userJID;
    private final Jid userID;
    private final Jid workgroupName;
    private final Date expiresDate;
    private final Map<String, List<String>> metaData;
    private final OfferContent content;
    private boolean accepted = false;
    private boolean rejected = false;

    Offer(XMPPConnection conn, AgentSession agentSession, Jid userID, Jid userJID, Jid workgroupName, Date expiresDate, String sessionID, Map<String, List<String>> metaData, OfferContent content) {
        this.connection = conn;
        this.session = agentSession;
        this.userID = userID;
        this.userJID = userJID;
        this.workgroupName = workgroupName;
        this.expiresDate = expiresDate;
        this.sessionID = sessionID;
        this.metaData = metaData;
        this.content = content;
    }

    public void accept() throws SmackException.NotConnectedException, InterruptedException {
        AcceptPacket acceptPacket = new AcceptPacket(this.session.getWorkgroupJID());
        this.connection.sendStanza(acceptPacket);
        this.accepted = true;
    }

    public void reject() throws SmackException.NotConnectedException, InterruptedException {
        RejectPacket rejectPacket = new RejectPacket(this.session.getWorkgroupJID());
        this.connection.sendStanza(rejectPacket);
        this.rejected = true;
    }

    public Jid getUserID() {
        return this.userID;
    }

    public Jid getUserJID() {
        return this.userJID;
    }

    public Jid getWorkgroupName() {
        return this.workgroupName;
    }

    public Date getExpiresDate() {
        return this.expiresDate;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public Map<String, List<String>> getMetaData() {
        return this.metaData;
    }

    public OfferContent getContent() {
        return this.content;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    private class AcceptPacket
    extends IQ {
        AcceptPacket(Jid workgroup) {
            super("offer-accept", "http://jabber.org/protocol/workgroup");
            this.setTo(workgroup);
            this.setType(IQ.Type.set);
        }

        @Override
        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
            xml.attribute("id", Offer.this.getSessionID());
            xml.setEmptyElement();
            return xml;
        }
    }

    private class RejectPacket
    extends IQ {
        RejectPacket(Jid workgroup) {
            super("offer-reject", "http://jabber.org/protocol/workgroup");
            this.setTo(workgroup);
            this.setType(IQ.Type.set);
        }

        @Override
        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
            xml.attribute("id", Offer.this.getSessionID());
            xml.setEmptyElement();
            return xml;
        }
    }
}

