/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnsserverlookup;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.minidns.dnsserverlookup.DnsServerLookupMechanism;

public abstract class AbstractDnsServerLookupMechanism
implements DnsServerLookupMechanism {
    protected static final Logger LOGGER = Logger.getLogger(AbstractDnsServerLookupMechanism.class.getName());
    private final String name;
    private final int priority;

    protected AbstractDnsServerLookupMechanism(String name, int priority) {
        this.name = name;
        this.priority = priority;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final int getPriority() {
        return this.priority;
    }

    @Override
    public final int compareTo(DnsServerLookupMechanism other) {
        int myPriority = this.getPriority();
        int otherPriority = other.getPriority();
        return Integer.compare(myPriority, otherPriority);
    }

    @Override
    public abstract List<String> getDnsServerAddresses();

    protected static List<String> toListOfStrings(Collection<? extends InetAddress> inetAddresses) {
        ArrayList<String> result = new ArrayList<String>(inetAddresses.size());
        for (InetAddress inetAddress : inetAddresses) {
            String address = inetAddress.getHostAddress();
            result.add(address);
        }
        return result;
    }
}

