/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.util.ArmorUtils;

public final class ArmoredOutputStreamFactory {
    public static final String PGPAINLESS = "PGPainless";
    private static String version = "PGPainless";
    private static String[] comment = new String[0];

    private ArmoredOutputStreamFactory() {
    }

    @Nonnull
    public static ArmoredOutputStream get(@Nonnull OutputStream outputStream) {
        ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream(outputStream);
        armoredOutputStream.clearHeaders();
        if (version != null && !version.isEmpty()) {
            armoredOutputStream.setHeader("Version", version);
        }
        for (String comment : ArmoredOutputStreamFactory.comment) {
            ArmorUtils.addCommentHeader(armoredOutputStream, comment);
        }
        return armoredOutputStream;
    }

    @Nonnull
    public static ArmoredOutputStream get(@Nonnull OutputStream outputStream, @Nonnull ProducerOptions options) {
        if (options.isHideArmorHeaders()) {
            ArmoredOutputStream armorOut = new ArmoredOutputStream(outputStream);
            armorOut.clearHeaders();
            return armorOut;
        }
        return ArmoredOutputStreamFactory.get(outputStream);
    }

    public static void setVersionInfo(@Nullable String versionString) {
        if (versionString == null) {
            version = null;
            return;
        }
        String trimmed = versionString.trim();
        version = trimmed.isEmpty() ? null : trimmed;
    }

    public static void resetVersionInfo() {
        version = PGPAINLESS;
    }

    public static void setComment(@Nullable String commentString) {
        if (commentString == null) {
            throw new IllegalArgumentException("Comment cannot be null.");
        }
        String trimmed = commentString.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("Comment cannot be empty.");
        }
        String[] lines = commentString.split("\n");
        comment = lines;
    }

    public static void resetComment() {
        comment = new String[0];
    }
}

