%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM4":  ["0x8042434445464748", "0x7172737475767778", "0x0000000000000000", "0x0000000000000000"],
    "XMM5":  ["0xFFFF804200004546", "0x0000717200007576", "0x0000000000000000", "0x0000000000000000"],
    "XMM6":  ["0xFFFFFFFF00000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM7":  ["0x8042434445464748", "0x7172737475767778", "0x0000000000000000", "0x0000000000000000"],
    "XMM8":  ["0xFFFF804200004546", "0x0000717200007576", "0x0000000000000000", "0x0000000000000000"],
    "XMM9":  ["0xFFFFFFFF00000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM10": ["0x8042434445464748", "0x7172737475767778", "0x4142434445464748", "0x7172737475767778"],
    "XMM11": ["0xFFFF804200004546", "0x0000717200007576", "0x0000414200004546", "0x0000717200007576"],
    "XMM12": ["0xFFFFFFFF00000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM13": ["0x8042434445464748", "0x7172737475767778", "0x4142434445464748", "0x7172737475767778"],
    "XMM14": ["0xFFFF804200004546", "0x0000717200007576", "0x0000414200004546", "0x0000717200007576"],
    "XMM15": ["0xFFFFFFFF00000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx + 32 * 0]
vmovapd ymm1, [rdx + 32 * 1]
vmovapd ymm2, [rdx + 32 * 2]
vmovapd ymm3, [rdx + 32 * 3]

vpsrad xmm4, xmm0, xmm1
vpsrad xmm5, xmm0, xmm2
vpsrad xmm6, xmm0, xmm3

vpsrad xmm7, xmm0, [rdx + 32 * 1]
vpsrad xmm8, xmm0, [rdx + 32 * 2]
vpsrad xmm9, xmm0, [rdx + 32 * 3]

vpsrad ymm10, ymm0, xmm1
vpsrad ymm11, ymm0, xmm2
vpsrad ymm12, ymm0, xmm3

vpsrad ymm13, ymm0, [rdx + 32 * 1]
vpsrad ymm14, ymm0, [rdx + 32 * 2]
vpsrad ymm15, ymm0, [rdx + 32 * 3]

hlt

align 32
.data:
dq 0x8042434445464748
dq 0x7172737475767778
dq 0x4142434445464748
dq 0x7172737475767778

dq 0x0000000000000000
dq 0x5152535455565758
dq 0x5152535455565758
dq 0x5152535455565758

dq 0x0000000000000010
dq 0x5152535455565758
dq 0x5152535455565758
dq 0x5152535455565758

dq 0x0000000000000020
dq 0x5152535455565758
dq 0x5152535455565758
dq 0x5152535455565758
