# frozen_string_literal: true

require_relative '../../test_helper'

class TestFakerVulnerabilityIdentifier < Test::Unit::TestCase
  def setup
    @tester = Faker::VulnerabilityIdentifier
  end

  def test_cve_no_args
    assert_match(/^CVE-\d{4}-\d{4,}$/, @tester.cve)
  end

  def test_cve_with_year
    assert_match(/^CVE-2012-\d{4,}$/, @tester.cve(year: 2012))
  end
end
