//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "dispatch2")]
use dispatch2::*;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstreamerror?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFStreamError {
    pub domain: CFIndex,
    pub error: i32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFStreamError {
    const ENCODING: Encoding = Encoding::Struct("?", &[<CFIndex>::ENCODING, <i32>::ENCODING]);
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFStreamError {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstreampropertykey?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type CFStreamPropertyKey = CFString;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstreamstatus?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFStreamStatus(pub CFIndex);
impl CFStreamStatus {
    #[doc(alias = "kCFStreamStatusNotOpen")]
    pub const NotOpen: Self = Self(0);
    #[doc(alias = "kCFStreamStatusOpening")]
    pub const Opening: Self = Self(1);
    #[doc(alias = "kCFStreamStatusOpen")]
    pub const Open: Self = Self(2);
    #[doc(alias = "kCFStreamStatusReading")]
    pub const Reading: Self = Self(3);
    #[doc(alias = "kCFStreamStatusWriting")]
    pub const Writing: Self = Self(4);
    #[doc(alias = "kCFStreamStatusAtEnd")]
    pub const AtEnd: Self = Self(5);
    #[doc(alias = "kCFStreamStatusClosed")]
    pub const Closed: Self = Self(6);
    #[doc(alias = "kCFStreamStatusError")]
    pub const Error: Self = Self(7);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFStreamStatus {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFStreamStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstreameventtype?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFStreamEventType(pub CFOptionFlags);
bitflags::bitflags! {
    impl CFStreamEventType: CFOptionFlags {
        #[doc(alias = "kCFStreamEventNone")]
        const None = 0;
        #[doc(alias = "kCFStreamEventOpenCompleted")]
        const OpenCompleted = 1;
        #[doc(alias = "kCFStreamEventHasBytesAvailable")]
        const HasBytesAvailable = 2;
        #[doc(alias = "kCFStreamEventCanAcceptBytes")]
        const CanAcceptBytes = 4;
        #[doc(alias = "kCFStreamEventErrorOccurred")]
        const ErrorOccurred = 8;
        #[doc(alias = "kCFStreamEventEndEncountered")]
        const EndEncountered = 16;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFStreamEventType {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFStreamEventType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstreamclientcontext?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFStreamClientContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*mut c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*mut c_void) -> *const CFString>,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFStreamClientContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut c_void>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*mut c_void)>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*mut c_void) -> *const CFString>>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFStreamClientContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfreadstream?language=objc)
#[repr(C)]
pub struct CFReadStream {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFReadStream {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFReadStream"> for CFReadStream {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfwritestream?language=objc)
#[repr(C)]
pub struct CFWriteStream {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFWriteStream {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFWriteStream"> for CFWriteStream {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfreadstreamclientcallback?language=objc)
pub type CFReadStreamClientCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFReadStream, CFStreamEventType, *mut c_void)>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfwritestreamclientcallback?language=objc)
pub type CFWriteStreamClientCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFWriteStream, CFStreamEventType, *mut c_void)>;

unsafe impl ConcreteType for CFReadStream {
    #[doc(alias = "CFReadStreamGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFReadStreamGetTypeID() -> CFTypeID;
        }
        unsafe { CFReadStreamGetTypeID() }
    }
}

unsafe impl ConcreteType for CFWriteStream {
    #[doc(alias = "CFWriteStreamGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFWriteStreamGetTypeID() -> CFTypeID;
        }
        unsafe { CFWriteStreamGetTypeID() }
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertydatawritten?language=objc)
    pub static kCFStreamPropertyDataWritten: Option<&'static CFStreamPropertyKey>;
}

impl CFReadStream {
    #[doc(alias = "CFReadStreamCreateWithBytesNoCopy")]
    #[inline]
    pub unsafe fn with_bytes_no_copy(
        alloc: Option<&CFAllocator>,
        bytes: *const u8,
        length: CFIndex,
        bytes_deallocator: Option<&CFAllocator>,
    ) -> Option<CFRetained<CFReadStream>> {
        extern "C-unwind" {
            fn CFReadStreamCreateWithBytesNoCopy(
                alloc: Option<&CFAllocator>,
                bytes: *const u8,
                length: CFIndex,
                bytes_deallocator: Option<&CFAllocator>,
            ) -> Option<NonNull<CFReadStream>>;
        }
        let ret =
            unsafe { CFReadStreamCreateWithBytesNoCopy(alloc, bytes, length, bytes_deallocator) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CFWriteStream {
    #[doc(alias = "CFWriteStreamCreateWithBuffer")]
    #[inline]
    pub unsafe fn with_buffer(
        alloc: Option<&CFAllocator>,
        buffer: *mut u8,
        buffer_capacity: CFIndex,
    ) -> Option<CFRetained<CFWriteStream>> {
        extern "C-unwind" {
            fn CFWriteStreamCreateWithBuffer(
                alloc: Option<&CFAllocator>,
                buffer: *mut u8,
                buffer_capacity: CFIndex,
            ) -> Option<NonNull<CFWriteStream>>;
        }
        let ret = unsafe { CFWriteStreamCreateWithBuffer(alloc, buffer, buffer_capacity) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFWriteStreamCreateWithAllocatedBuffers")]
    #[inline]
    pub fn with_allocated_buffers(
        alloc: Option<&CFAllocator>,
        buffer_allocator: Option<&CFAllocator>,
    ) -> Option<CFRetained<CFWriteStream>> {
        extern "C-unwind" {
            fn CFWriteStreamCreateWithAllocatedBuffers(
                alloc: Option<&CFAllocator>,
                buffer_allocator: Option<&CFAllocator>,
            ) -> Option<NonNull<CFWriteStream>>;
        }
        let ret = unsafe { CFWriteStreamCreateWithAllocatedBuffers(alloc, buffer_allocator) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CFReadStream {
    #[doc(alias = "CFReadStreamCreateWithFile")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub fn with_file(
        alloc: Option<&CFAllocator>,
        file_url: Option<&CFURL>,
    ) -> Option<CFRetained<CFReadStream>> {
        extern "C-unwind" {
            fn CFReadStreamCreateWithFile(
                alloc: Option<&CFAllocator>,
                file_url: Option<&CFURL>,
            ) -> Option<NonNull<CFReadStream>>;
        }
        let ret = unsafe { CFReadStreamCreateWithFile(alloc, file_url) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CFWriteStream {
    #[doc(alias = "CFWriteStreamCreateWithFile")]
    #[cfg(feature = "CFURL")]
    #[inline]
    pub fn with_file(
        alloc: Option<&CFAllocator>,
        file_url: Option<&CFURL>,
    ) -> Option<CFRetained<CFWriteStream>> {
        extern "C-unwind" {
            fn CFWriteStreamCreateWithFile(
                alloc: Option<&CFAllocator>,
                file_url: Option<&CFURL>,
            ) -> Option<NonNull<CFWriteStream>>;
        }
        let ret = unsafe { CFWriteStreamCreateWithFile(alloc, file_url) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

extern "C-unwind" {
    pub fn CFStreamCreateBoundPair(
        alloc: Option<&CFAllocator>,
        read_stream: *mut *mut CFReadStream,
        write_stream: *mut *mut CFWriteStream,
        transfer_buffer_size: CFIndex,
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertyappendtofile?language=objc)
    pub static kCFStreamPropertyAppendToFile: Option<&'static CFStreamPropertyKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertyfilecurrentoffset?language=objc)
    pub static kCFStreamPropertyFileCurrentOffset: Option<&'static CFStreamPropertyKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocketnativehandle?language=objc)
    pub static kCFStreamPropertySocketNativeHandle: Option<&'static CFStreamPropertyKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocketremotehostname?language=objc)
    pub static kCFStreamPropertySocketRemoteHostName: Option<&'static CFStreamPropertyKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocketremoteportnumber?language=objc)
    pub static kCFStreamPropertySocketRemotePortNumber: Option<&'static CFStreamPropertyKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamerrordomainsocks?language=objc)
    pub static kCFStreamErrorDomainSOCKS: c_int;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocksproxy?language=objc)
    pub static kCFStreamPropertySOCKSProxy: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocksproxyhost?language=objc)
    pub static kCFStreamPropertySOCKSProxyHost: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocksproxyport?language=objc)
    pub static kCFStreamPropertySOCKSProxyPort: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocksversion?language=objc)
    pub static kCFStreamPropertySOCKSVersion: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamsocketsocksversion4?language=objc)
    pub static kCFStreamSocketSOCKSVersion4: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamsocketsocksversion5?language=objc)
    pub static kCFStreamSocketSOCKSVersion5: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocksuser?language=objc)
    pub static kCFStreamPropertySOCKSUser: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysockspassword?language=objc)
    pub static kCFStreamPropertySOCKSPassword: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamerrordomainssl?language=objc)
    pub static kCFStreamErrorDomainSSL: c_int;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertysocketsecuritylevel?language=objc)
    pub static kCFStreamPropertySocketSecurityLevel: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamsocketsecuritylevelnone?language=objc)
    pub static kCFStreamSocketSecurityLevelNone: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamsocketsecuritylevelsslv2?language=objc)
    pub static kCFStreamSocketSecurityLevelSSLv2: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamsocketsecuritylevelsslv3?language=objc)
    pub static kCFStreamSocketSecurityLevelSSLv3: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamsocketsecurityleveltlsv1?language=objc)
    pub static kCFStreamSocketSecurityLevelTLSv1: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreamsocketsecuritylevelnegotiatedssl?language=objc)
    pub static kCFStreamSocketSecurityLevelNegotiatedSSL: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfstreampropertyshouldclosenativesocket?language=objc)
    pub static kCFStreamPropertyShouldCloseNativeSocket: &'static CFString;
}

extern "C-unwind" {
    #[cfg(feature = "CFSocket")]
    #[deprecated = "Use nw_connection_t in Network framework instead"]
    pub fn CFStreamCreatePairWithSocket(
        alloc: Option<&CFAllocator>,
        sock: CFSocketNativeHandle,
        read_stream: *mut *mut CFReadStream,
        write_stream: *mut *mut CFWriteStream,
    );
}

extern "C-unwind" {
    #[deprecated = "Use nw_connection_t in Network framework instead"]
    pub fn CFStreamCreatePairWithSocketToHost(
        alloc: Option<&CFAllocator>,
        host: Option<&CFString>,
        port: u32,
        read_stream: *mut *mut CFReadStream,
        write_stream: *mut *mut CFWriteStream,
    );
}

extern "C-unwind" {
    #[cfg(all(feature = "CFData", feature = "CFSocket"))]
    #[deprecated = "Use nw_connection_t in Network framework instead"]
    pub fn CFStreamCreatePairWithPeerSocketSignature(
        alloc: Option<&CFAllocator>,
        signature: *const CFSocketSignature,
        read_stream: *mut *mut CFReadStream,
        write_stream: *mut *mut CFWriteStream,
    );
}

impl CFReadStream {
    #[doc(alias = "CFReadStreamGetStatus")]
    #[inline]
    pub fn status(self: &CFReadStream) -> CFStreamStatus {
        extern "C-unwind" {
            fn CFReadStreamGetStatus(stream: &CFReadStream) -> CFStreamStatus;
        }
        unsafe { CFReadStreamGetStatus(self) }
    }
}

impl CFWriteStream {
    #[doc(alias = "CFWriteStreamGetStatus")]
    #[inline]
    pub fn status(self: &CFWriteStream) -> CFStreamStatus {
        extern "C-unwind" {
            fn CFWriteStreamGetStatus(stream: &CFWriteStream) -> CFStreamStatus;
        }
        unsafe { CFWriteStreamGetStatus(self) }
    }
}

impl CFReadStream {
    #[doc(alias = "CFReadStreamCopyError")]
    #[cfg(feature = "CFError")]
    #[inline]
    pub fn copy_error(self: &CFReadStream) -> Option<CFRetained<CFError>> {
        extern "C-unwind" {
            fn CFReadStreamCopyError(stream: &CFReadStream) -> Option<NonNull<CFError>>;
        }
        let ret = unsafe { CFReadStreamCopyError(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CFWriteStream {
    #[doc(alias = "CFWriteStreamCopyError")]
    #[cfg(feature = "CFError")]
    #[inline]
    pub fn copy_error(self: &CFWriteStream) -> Option<CFRetained<CFError>> {
        extern "C-unwind" {
            fn CFWriteStreamCopyError(stream: &CFWriteStream) -> Option<NonNull<CFError>>;
        }
        let ret = unsafe { CFWriteStreamCopyError(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CFReadStream {
    #[doc(alias = "CFReadStreamOpen")]
    #[inline]
    pub fn open(self: &CFReadStream) -> bool {
        extern "C-unwind" {
            fn CFReadStreamOpen(stream: &CFReadStream) -> Boolean;
        }
        let ret = unsafe { CFReadStreamOpen(self) };
        ret != 0
    }
}

impl CFWriteStream {
    #[doc(alias = "CFWriteStreamOpen")]
    #[inline]
    pub fn open(self: &CFWriteStream) -> bool {
        extern "C-unwind" {
            fn CFWriteStreamOpen(stream: &CFWriteStream) -> Boolean;
        }
        let ret = unsafe { CFWriteStreamOpen(self) };
        ret != 0
    }
}

impl CFReadStream {
    #[doc(alias = "CFReadStreamClose")]
    #[inline]
    pub fn close(self: &CFReadStream) {
        extern "C-unwind" {
            fn CFReadStreamClose(stream: &CFReadStream);
        }
        unsafe { CFReadStreamClose(self) }
    }
}

impl CFWriteStream {
    #[doc(alias = "CFWriteStreamClose")]
    #[inline]
    pub fn close(self: &CFWriteStream) {
        extern "C-unwind" {
            fn CFWriteStreamClose(stream: &CFWriteStream);
        }
        unsafe { CFWriteStreamClose(self) }
    }
}

impl CFReadStream {
    #[doc(alias = "CFReadStreamHasBytesAvailable")]
    #[inline]
    pub fn has_bytes_available(self: &CFReadStream) -> bool {
        extern "C-unwind" {
            fn CFReadStreamHasBytesAvailable(stream: &CFReadStream) -> Boolean;
        }
        let ret = unsafe { CFReadStreamHasBytesAvailable(self) };
        ret != 0
    }

    #[doc(alias = "CFReadStreamRead")]
    #[inline]
    pub unsafe fn read(self: &CFReadStream, buffer: *mut u8, buffer_length: CFIndex) -> CFIndex {
        extern "C-unwind" {
            fn CFReadStreamRead(
                stream: &CFReadStream,
                buffer: *mut u8,
                buffer_length: CFIndex,
            ) -> CFIndex;
        }
        unsafe { CFReadStreamRead(self, buffer, buffer_length) }
    }

    #[doc(alias = "CFReadStreamGetBuffer")]
    #[inline]
    pub unsafe fn buffer(
        self: &CFReadStream,
        max_bytes_to_read: CFIndex,
        num_bytes_read: *mut CFIndex,
    ) -> *const u8 {
        extern "C-unwind" {
            fn CFReadStreamGetBuffer(
                stream: &CFReadStream,
                max_bytes_to_read: CFIndex,
                num_bytes_read: *mut CFIndex,
            ) -> *const u8;
        }
        unsafe { CFReadStreamGetBuffer(self, max_bytes_to_read, num_bytes_read) }
    }
}

impl CFWriteStream {
    #[doc(alias = "CFWriteStreamCanAcceptBytes")]
    #[inline]
    pub fn can_accept_bytes(self: &CFWriteStream) -> bool {
        extern "C-unwind" {
            fn CFWriteStreamCanAcceptBytes(stream: &CFWriteStream) -> Boolean;
        }
        let ret = unsafe { CFWriteStreamCanAcceptBytes(self) };
        ret != 0
    }

    #[doc(alias = "CFWriteStreamWrite")]
    #[inline]
    pub unsafe fn write(
        self: &CFWriteStream,
        buffer: *const u8,
        buffer_length: CFIndex,
    ) -> CFIndex {
        extern "C-unwind" {
            fn CFWriteStreamWrite(
                stream: &CFWriteStream,
                buffer: *const u8,
                buffer_length: CFIndex,
            ) -> CFIndex;
        }
        unsafe { CFWriteStreamWrite(self, buffer, buffer_length) }
    }
}

impl CFReadStream {
    #[doc(alias = "CFReadStreamCopyProperty")]
    #[inline]
    pub fn property(
        self: &CFReadStream,
        property_name: Option<&CFStreamPropertyKey>,
    ) -> Option<CFRetained<CFType>> {
        extern "C-unwind" {
            fn CFReadStreamCopyProperty(
                stream: &CFReadStream,
                property_name: Option<&CFStreamPropertyKey>,
            ) -> Option<NonNull<CFType>>;
        }
        let ret = unsafe { CFReadStreamCopyProperty(self, property_name) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CFWriteStream {
    #[doc(alias = "CFWriteStreamCopyProperty")]
    #[inline]
    pub fn property(
        self: &CFWriteStream,
        property_name: Option<&CFStreamPropertyKey>,
    ) -> Option<CFRetained<CFType>> {
        extern "C-unwind" {
            fn CFWriteStreamCopyProperty(
                stream: &CFWriteStream,
                property_name: Option<&CFStreamPropertyKey>,
            ) -> Option<NonNull<CFType>>;
        }
        let ret = unsafe { CFWriteStreamCopyProperty(self, property_name) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CFReadStream {
    #[doc(alias = "CFReadStreamSetProperty")]
    #[inline]
    pub unsafe fn set_property(
        self: &CFReadStream,
        property_name: Option<&CFStreamPropertyKey>,
        property_value: Option<&CFType>,
    ) -> bool {
        extern "C-unwind" {
            fn CFReadStreamSetProperty(
                stream: &CFReadStream,
                property_name: Option<&CFStreamPropertyKey>,
                property_value: Option<&CFType>,
            ) -> Boolean;
        }
        let ret = unsafe { CFReadStreamSetProperty(self, property_name, property_value) };
        ret != 0
    }
}

impl CFWriteStream {
    #[doc(alias = "CFWriteStreamSetProperty")]
    #[inline]
    pub unsafe fn set_property(
        self: &CFWriteStream,
        property_name: Option<&CFStreamPropertyKey>,
        property_value: Option<&CFType>,
    ) -> bool {
        extern "C-unwind" {
            fn CFWriteStreamSetProperty(
                stream: &CFWriteStream,
                property_name: Option<&CFStreamPropertyKey>,
                property_value: Option<&CFType>,
            ) -> Boolean;
        }
        let ret = unsafe { CFWriteStreamSetProperty(self, property_name, property_value) };
        ret != 0
    }
}

impl CFReadStream {
    #[doc(alias = "CFReadStreamSetClient")]
    #[inline]
    pub unsafe fn set_client(
        self: &CFReadStream,
        stream_events: CFOptionFlags,
        client_cb: CFReadStreamClientCallBack,
        client_context: *mut CFStreamClientContext,
    ) -> bool {
        extern "C-unwind" {
            fn CFReadStreamSetClient(
                stream: &CFReadStream,
                stream_events: CFOptionFlags,
                client_cb: CFReadStreamClientCallBack,
                client_context: *mut CFStreamClientContext,
            ) -> Boolean;
        }
        let ret = unsafe { CFReadStreamSetClient(self, stream_events, client_cb, client_context) };
        ret != 0
    }
}

impl CFWriteStream {
    #[doc(alias = "CFWriteStreamSetClient")]
    #[inline]
    pub unsafe fn set_client(
        self: &CFWriteStream,
        stream_events: CFOptionFlags,
        client_cb: CFWriteStreamClientCallBack,
        client_context: *mut CFStreamClientContext,
    ) -> bool {
        extern "C-unwind" {
            fn CFWriteStreamSetClient(
                stream: &CFWriteStream,
                stream_events: CFOptionFlags,
                client_cb: CFWriteStreamClientCallBack,
                client_context: *mut CFStreamClientContext,
            ) -> Boolean;
        }
        let ret = unsafe { CFWriteStreamSetClient(self, stream_events, client_cb, client_context) };
        ret != 0
    }
}

impl CFReadStream {
    #[doc(alias = "CFReadStreamScheduleWithRunLoop")]
    #[cfg(feature = "CFRunLoop")]
    #[inline]
    pub fn schedule_with_run_loop(
        self: &CFReadStream,
        run_loop: Option<&CFRunLoop>,
        run_loop_mode: Option<&CFRunLoopMode>,
    ) {
        extern "C-unwind" {
            fn CFReadStreamScheduleWithRunLoop(
                stream: &CFReadStream,
                run_loop: Option<&CFRunLoop>,
                run_loop_mode: Option<&CFRunLoopMode>,
            );
        }
        unsafe { CFReadStreamScheduleWithRunLoop(self, run_loop, run_loop_mode) }
    }
}

impl CFWriteStream {
    #[doc(alias = "CFWriteStreamScheduleWithRunLoop")]
    #[cfg(feature = "CFRunLoop")]
    #[inline]
    pub fn schedule_with_run_loop(
        self: &CFWriteStream,
        run_loop: Option<&CFRunLoop>,
        run_loop_mode: Option<&CFRunLoopMode>,
    ) {
        extern "C-unwind" {
            fn CFWriteStreamScheduleWithRunLoop(
                stream: &CFWriteStream,
                run_loop: Option<&CFRunLoop>,
                run_loop_mode: Option<&CFRunLoopMode>,
            );
        }
        unsafe { CFWriteStreamScheduleWithRunLoop(self, run_loop, run_loop_mode) }
    }
}

impl CFReadStream {
    #[doc(alias = "CFReadStreamUnscheduleFromRunLoop")]
    #[cfg(feature = "CFRunLoop")]
    #[inline]
    pub fn unschedule_from_run_loop(
        self: &CFReadStream,
        run_loop: Option<&CFRunLoop>,
        run_loop_mode: Option<&CFRunLoopMode>,
    ) {
        extern "C-unwind" {
            fn CFReadStreamUnscheduleFromRunLoop(
                stream: &CFReadStream,
                run_loop: Option<&CFRunLoop>,
                run_loop_mode: Option<&CFRunLoopMode>,
            );
        }
        unsafe { CFReadStreamUnscheduleFromRunLoop(self, run_loop, run_loop_mode) }
    }
}

impl CFWriteStream {
    #[doc(alias = "CFWriteStreamUnscheduleFromRunLoop")]
    #[cfg(feature = "CFRunLoop")]
    #[inline]
    pub fn unschedule_from_run_loop(
        self: &CFWriteStream,
        run_loop: Option<&CFRunLoop>,
        run_loop_mode: Option<&CFRunLoopMode>,
    ) {
        extern "C-unwind" {
            fn CFWriteStreamUnscheduleFromRunLoop(
                stream: &CFWriteStream,
                run_loop: Option<&CFRunLoop>,
                run_loop_mode: Option<&CFRunLoopMode>,
            );
        }
        unsafe { CFWriteStreamUnscheduleFromRunLoop(self, run_loop, run_loop_mode) }
    }
}

impl CFReadStream {
    #[doc(alias = "CFReadStreamSetDispatchQueue")]
    #[cfg(feature = "dispatch2")]
    #[inline]
    pub unsafe fn set_dispatch_queue(self: &CFReadStream, q: Option<&DispatchQueue>) {
        extern "C-unwind" {
            fn CFReadStreamSetDispatchQueue(stream: &CFReadStream, q: Option<&DispatchQueue>);
        }
        unsafe { CFReadStreamSetDispatchQueue(self, q) }
    }
}

impl CFWriteStream {
    #[doc(alias = "CFWriteStreamSetDispatchQueue")]
    #[cfg(feature = "dispatch2")]
    #[inline]
    pub unsafe fn set_dispatch_queue(self: &CFWriteStream, q: Option<&DispatchQueue>) {
        extern "C-unwind" {
            fn CFWriteStreamSetDispatchQueue(stream: &CFWriteStream, q: Option<&DispatchQueue>);
        }
        unsafe { CFWriteStreamSetDispatchQueue(self, q) }
    }
}

impl CFReadStream {
    #[doc(alias = "CFReadStreamCopyDispatchQueue")]
    #[cfg(feature = "dispatch2")]
    #[inline]
    pub unsafe fn dispatch_queue(self: &CFReadStream) -> Option<DispatchRetained<DispatchQueue>> {
        extern "C-unwind" {
            fn CFReadStreamCopyDispatchQueue(
                stream: &CFReadStream,
            ) -> Option<NonNull<DispatchQueue>>;
        }
        let ret = unsafe { CFReadStreamCopyDispatchQueue(self) };
        ret.map(|ret| unsafe { DispatchRetained::from_raw(ret) })
    }
}

impl CFWriteStream {
    #[doc(alias = "CFWriteStreamCopyDispatchQueue")]
    #[cfg(feature = "dispatch2")]
    #[inline]
    pub unsafe fn dispatch_queue(self: &CFWriteStream) -> Option<DispatchRetained<DispatchQueue>> {
        extern "C-unwind" {
            fn CFWriteStreamCopyDispatchQueue(
                stream: &CFWriteStream,
            ) -> Option<NonNull<DispatchQueue>>;
        }
        let ret = unsafe { CFWriteStreamCopyDispatchQueue(self) };
        ret.map(|ret| unsafe { DispatchRetained::from_raw(ret) })
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstreamerrordomain?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFStreamErrorDomain(pub CFIndex);
impl CFStreamErrorDomain {
    #[doc(alias = "kCFStreamErrorDomainCustom")]
    pub const Custom: Self = Self(-1);
    #[doc(alias = "kCFStreamErrorDomainPOSIX")]
    pub const POSIX: Self = Self(1);
    #[doc(alias = "kCFStreamErrorDomainMacOSStatus")]
    pub const MacOSStatus: Self = Self(2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFStreamErrorDomain {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFStreamErrorDomain {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CFReadStream {
    #[doc(alias = "CFReadStreamGetError")]
    #[inline]
    pub fn error(self: &CFReadStream) -> CFStreamError {
        extern "C-unwind" {
            fn CFReadStreamGetError(stream: &CFReadStream) -> CFStreamError;
        }
        unsafe { CFReadStreamGetError(self) }
    }
}

impl CFWriteStream {
    #[doc(alias = "CFWriteStreamGetError")]
    #[inline]
    pub fn error(self: &CFWriteStream) -> CFStreamError {
        extern "C-unwind" {
            fn CFWriteStreamGetError(stream: &CFWriteStream) -> CFStreamError;
        }
        unsafe { CFWriteStreamGetError(self) }
    }
}

#[deprecated = "renamed to `CFReadStream::with_bytes_no_copy`"]
#[inline]
pub unsafe extern "C-unwind" fn CFReadStreamCreateWithBytesNoCopy(
    alloc: Option<&CFAllocator>,
    bytes: *const u8,
    length: CFIndex,
    bytes_deallocator: Option<&CFAllocator>,
) -> Option<CFRetained<CFReadStream>> {
    extern "C-unwind" {
        fn CFReadStreamCreateWithBytesNoCopy(
            alloc: Option<&CFAllocator>,
            bytes: *const u8,
            length: CFIndex,
            bytes_deallocator: Option<&CFAllocator>,
        ) -> Option<NonNull<CFReadStream>>;
    }
    let ret = unsafe { CFReadStreamCreateWithBytesNoCopy(alloc, bytes, length, bytes_deallocator) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFWriteStream::with_buffer`"]
#[inline]
pub unsafe extern "C-unwind" fn CFWriteStreamCreateWithBuffer(
    alloc: Option<&CFAllocator>,
    buffer: *mut u8,
    buffer_capacity: CFIndex,
) -> Option<CFRetained<CFWriteStream>> {
    extern "C-unwind" {
        fn CFWriteStreamCreateWithBuffer(
            alloc: Option<&CFAllocator>,
            buffer: *mut u8,
            buffer_capacity: CFIndex,
        ) -> Option<NonNull<CFWriteStream>>;
    }
    let ret = unsafe { CFWriteStreamCreateWithBuffer(alloc, buffer, buffer_capacity) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFWriteStream::with_allocated_buffers`"]
#[inline]
pub extern "C-unwind" fn CFWriteStreamCreateWithAllocatedBuffers(
    alloc: Option<&CFAllocator>,
    buffer_allocator: Option<&CFAllocator>,
) -> Option<CFRetained<CFWriteStream>> {
    extern "C-unwind" {
        fn CFWriteStreamCreateWithAllocatedBuffers(
            alloc: Option<&CFAllocator>,
            buffer_allocator: Option<&CFAllocator>,
        ) -> Option<NonNull<CFWriteStream>>;
    }
    let ret = unsafe { CFWriteStreamCreateWithAllocatedBuffers(alloc, buffer_allocator) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFReadStream::with_file`"]
#[inline]
pub extern "C-unwind" fn CFReadStreamCreateWithFile(
    alloc: Option<&CFAllocator>,
    file_url: Option<&CFURL>,
) -> Option<CFRetained<CFReadStream>> {
    extern "C-unwind" {
        fn CFReadStreamCreateWithFile(
            alloc: Option<&CFAllocator>,
            file_url: Option<&CFURL>,
        ) -> Option<NonNull<CFReadStream>>;
    }
    let ret = unsafe { CFReadStreamCreateWithFile(alloc, file_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFURL")]
#[deprecated = "renamed to `CFWriteStream::with_file`"]
#[inline]
pub extern "C-unwind" fn CFWriteStreamCreateWithFile(
    alloc: Option<&CFAllocator>,
    file_url: Option<&CFURL>,
) -> Option<CFRetained<CFWriteStream>> {
    extern "C-unwind" {
        fn CFWriteStreamCreateWithFile(
            alloc: Option<&CFAllocator>,
            file_url: Option<&CFURL>,
        ) -> Option<NonNull<CFWriteStream>>;
    }
    let ret = unsafe { CFWriteStreamCreateWithFile(alloc, file_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFReadStream::status`"]
#[inline]
pub extern "C-unwind" fn CFReadStreamGetStatus(stream: &CFReadStream) -> CFStreamStatus {
    extern "C-unwind" {
        fn CFReadStreamGetStatus(stream: &CFReadStream) -> CFStreamStatus;
    }
    unsafe { CFReadStreamGetStatus(stream) }
}

#[deprecated = "renamed to `CFWriteStream::status`"]
#[inline]
pub extern "C-unwind" fn CFWriteStreamGetStatus(stream: &CFWriteStream) -> CFStreamStatus {
    extern "C-unwind" {
        fn CFWriteStreamGetStatus(stream: &CFWriteStream) -> CFStreamStatus;
    }
    unsafe { CFWriteStreamGetStatus(stream) }
}

#[cfg(feature = "CFError")]
#[deprecated = "renamed to `CFReadStream::copy_error`"]
#[inline]
pub extern "C-unwind" fn CFReadStreamCopyError(
    stream: &CFReadStream,
) -> Option<CFRetained<CFError>> {
    extern "C-unwind" {
        fn CFReadStreamCopyError(stream: &CFReadStream) -> Option<NonNull<CFError>>;
    }
    let ret = unsafe { CFReadStreamCopyError(stream) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFError")]
#[deprecated = "renamed to `CFWriteStream::copy_error`"]
#[inline]
pub extern "C-unwind" fn CFWriteStreamCopyError(
    stream: &CFWriteStream,
) -> Option<CFRetained<CFError>> {
    extern "C-unwind" {
        fn CFWriteStreamCopyError(stream: &CFWriteStream) -> Option<NonNull<CFError>>;
    }
    let ret = unsafe { CFWriteStreamCopyError(stream) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFReadStream::open`"]
#[inline]
pub extern "C-unwind" fn CFReadStreamOpen(stream: &CFReadStream) -> bool {
    extern "C-unwind" {
        fn CFReadStreamOpen(stream: &CFReadStream) -> Boolean;
    }
    let ret = unsafe { CFReadStreamOpen(stream) };
    ret != 0
}

#[deprecated = "renamed to `CFWriteStream::open`"]
#[inline]
pub extern "C-unwind" fn CFWriteStreamOpen(stream: &CFWriteStream) -> bool {
    extern "C-unwind" {
        fn CFWriteStreamOpen(stream: &CFWriteStream) -> Boolean;
    }
    let ret = unsafe { CFWriteStreamOpen(stream) };
    ret != 0
}

#[deprecated = "renamed to `CFReadStream::close`"]
#[inline]
pub extern "C-unwind" fn CFReadStreamClose(stream: &CFReadStream) {
    extern "C-unwind" {
        fn CFReadStreamClose(stream: &CFReadStream);
    }
    unsafe { CFReadStreamClose(stream) }
}

#[deprecated = "renamed to `CFWriteStream::close`"]
#[inline]
pub extern "C-unwind" fn CFWriteStreamClose(stream: &CFWriteStream) {
    extern "C-unwind" {
        fn CFWriteStreamClose(stream: &CFWriteStream);
    }
    unsafe { CFWriteStreamClose(stream) }
}

#[deprecated = "renamed to `CFReadStream::has_bytes_available`"]
#[inline]
pub extern "C-unwind" fn CFReadStreamHasBytesAvailable(stream: &CFReadStream) -> bool {
    extern "C-unwind" {
        fn CFReadStreamHasBytesAvailable(stream: &CFReadStream) -> Boolean;
    }
    let ret = unsafe { CFReadStreamHasBytesAvailable(stream) };
    ret != 0
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFReadStream::read`"]
    pub fn CFReadStreamRead(
        stream: &CFReadStream,
        buffer: *mut u8,
        buffer_length: CFIndex,
    ) -> CFIndex;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFReadStream::buffer`"]
    pub fn CFReadStreamGetBuffer(
        stream: &CFReadStream,
        max_bytes_to_read: CFIndex,
        num_bytes_read: *mut CFIndex,
    ) -> *const u8;
}

#[deprecated = "renamed to `CFWriteStream::can_accept_bytes`"]
#[inline]
pub extern "C-unwind" fn CFWriteStreamCanAcceptBytes(stream: &CFWriteStream) -> bool {
    extern "C-unwind" {
        fn CFWriteStreamCanAcceptBytes(stream: &CFWriteStream) -> Boolean;
    }
    let ret = unsafe { CFWriteStreamCanAcceptBytes(stream) };
    ret != 0
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFWriteStream::write`"]
    pub fn CFWriteStreamWrite(
        stream: &CFWriteStream,
        buffer: *const u8,
        buffer_length: CFIndex,
    ) -> CFIndex;
}

#[deprecated = "renamed to `CFReadStream::property`"]
#[inline]
pub extern "C-unwind" fn CFReadStreamCopyProperty(
    stream: &CFReadStream,
    property_name: Option<&CFStreamPropertyKey>,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CFReadStreamCopyProperty(
            stream: &CFReadStream,
            property_name: Option<&CFStreamPropertyKey>,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { CFReadStreamCopyProperty(stream, property_name) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFWriteStream::property`"]
#[inline]
pub extern "C-unwind" fn CFWriteStreamCopyProperty(
    stream: &CFWriteStream,
    property_name: Option<&CFStreamPropertyKey>,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CFWriteStreamCopyProperty(
            stream: &CFWriteStream,
            property_name: Option<&CFStreamPropertyKey>,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { CFWriteStreamCopyProperty(stream, property_name) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFReadStream::set_property`"]
#[inline]
pub unsafe extern "C-unwind" fn CFReadStreamSetProperty(
    stream: &CFReadStream,
    property_name: Option<&CFStreamPropertyKey>,
    property_value: Option<&CFType>,
) -> bool {
    extern "C-unwind" {
        fn CFReadStreamSetProperty(
            stream: &CFReadStream,
            property_name: Option<&CFStreamPropertyKey>,
            property_value: Option<&CFType>,
        ) -> Boolean;
    }
    let ret = unsafe { CFReadStreamSetProperty(stream, property_name, property_value) };
    ret != 0
}

#[deprecated = "renamed to `CFWriteStream::set_property`"]
#[inline]
pub unsafe extern "C-unwind" fn CFWriteStreamSetProperty(
    stream: &CFWriteStream,
    property_name: Option<&CFStreamPropertyKey>,
    property_value: Option<&CFType>,
) -> bool {
    extern "C-unwind" {
        fn CFWriteStreamSetProperty(
            stream: &CFWriteStream,
            property_name: Option<&CFStreamPropertyKey>,
            property_value: Option<&CFType>,
        ) -> Boolean;
    }
    let ret = unsafe { CFWriteStreamSetProperty(stream, property_name, property_value) };
    ret != 0
}

#[deprecated = "renamed to `CFReadStream::set_client`"]
#[inline]
pub unsafe extern "C-unwind" fn CFReadStreamSetClient(
    stream: &CFReadStream,
    stream_events: CFOptionFlags,
    client_cb: CFReadStreamClientCallBack,
    client_context: *mut CFStreamClientContext,
) -> bool {
    extern "C-unwind" {
        fn CFReadStreamSetClient(
            stream: &CFReadStream,
            stream_events: CFOptionFlags,
            client_cb: CFReadStreamClientCallBack,
            client_context: *mut CFStreamClientContext,
        ) -> Boolean;
    }
    let ret = unsafe { CFReadStreamSetClient(stream, stream_events, client_cb, client_context) };
    ret != 0
}

#[deprecated = "renamed to `CFWriteStream::set_client`"]
#[inline]
pub unsafe extern "C-unwind" fn CFWriteStreamSetClient(
    stream: &CFWriteStream,
    stream_events: CFOptionFlags,
    client_cb: CFWriteStreamClientCallBack,
    client_context: *mut CFStreamClientContext,
) -> bool {
    extern "C-unwind" {
        fn CFWriteStreamSetClient(
            stream: &CFWriteStream,
            stream_events: CFOptionFlags,
            client_cb: CFWriteStreamClientCallBack,
            client_context: *mut CFStreamClientContext,
        ) -> Boolean;
    }
    let ret = unsafe { CFWriteStreamSetClient(stream, stream_events, client_cb, client_context) };
    ret != 0
}

#[cfg(feature = "CFRunLoop")]
#[deprecated = "renamed to `CFReadStream::schedule_with_run_loop`"]
#[inline]
pub extern "C-unwind" fn CFReadStreamScheduleWithRunLoop(
    stream: &CFReadStream,
    run_loop: Option<&CFRunLoop>,
    run_loop_mode: Option<&CFRunLoopMode>,
) {
    extern "C-unwind" {
        fn CFReadStreamScheduleWithRunLoop(
            stream: &CFReadStream,
            run_loop: Option<&CFRunLoop>,
            run_loop_mode: Option<&CFRunLoopMode>,
        );
    }
    unsafe { CFReadStreamScheduleWithRunLoop(stream, run_loop, run_loop_mode) }
}

#[cfg(feature = "CFRunLoop")]
#[deprecated = "renamed to `CFWriteStream::schedule_with_run_loop`"]
#[inline]
pub extern "C-unwind" fn CFWriteStreamScheduleWithRunLoop(
    stream: &CFWriteStream,
    run_loop: Option<&CFRunLoop>,
    run_loop_mode: Option<&CFRunLoopMode>,
) {
    extern "C-unwind" {
        fn CFWriteStreamScheduleWithRunLoop(
            stream: &CFWriteStream,
            run_loop: Option<&CFRunLoop>,
            run_loop_mode: Option<&CFRunLoopMode>,
        );
    }
    unsafe { CFWriteStreamScheduleWithRunLoop(stream, run_loop, run_loop_mode) }
}

#[cfg(feature = "CFRunLoop")]
#[deprecated = "renamed to `CFReadStream::unschedule_from_run_loop`"]
#[inline]
pub extern "C-unwind" fn CFReadStreamUnscheduleFromRunLoop(
    stream: &CFReadStream,
    run_loop: Option<&CFRunLoop>,
    run_loop_mode: Option<&CFRunLoopMode>,
) {
    extern "C-unwind" {
        fn CFReadStreamUnscheduleFromRunLoop(
            stream: &CFReadStream,
            run_loop: Option<&CFRunLoop>,
            run_loop_mode: Option<&CFRunLoopMode>,
        );
    }
    unsafe { CFReadStreamUnscheduleFromRunLoop(stream, run_loop, run_loop_mode) }
}

#[cfg(feature = "CFRunLoop")]
#[deprecated = "renamed to `CFWriteStream::unschedule_from_run_loop`"]
#[inline]
pub extern "C-unwind" fn CFWriteStreamUnscheduleFromRunLoop(
    stream: &CFWriteStream,
    run_loop: Option<&CFRunLoop>,
    run_loop_mode: Option<&CFRunLoopMode>,
) {
    extern "C-unwind" {
        fn CFWriteStreamUnscheduleFromRunLoop(
            stream: &CFWriteStream,
            run_loop: Option<&CFRunLoop>,
            run_loop_mode: Option<&CFRunLoopMode>,
        );
    }
    unsafe { CFWriteStreamUnscheduleFromRunLoop(stream, run_loop, run_loop_mode) }
}

extern "C-unwind" {
    #[cfg(feature = "dispatch2")]
    #[deprecated = "renamed to `CFReadStream::set_dispatch_queue`"]
    pub fn CFReadStreamSetDispatchQueue(stream: &CFReadStream, q: Option<&DispatchQueue>);
}

extern "C-unwind" {
    #[cfg(feature = "dispatch2")]
    #[deprecated = "renamed to `CFWriteStream::set_dispatch_queue`"]
    pub fn CFWriteStreamSetDispatchQueue(stream: &CFWriteStream, q: Option<&DispatchQueue>);
}

#[cfg(feature = "dispatch2")]
#[deprecated = "renamed to `CFReadStream::dispatch_queue`"]
#[inline]
pub unsafe extern "C-unwind" fn CFReadStreamCopyDispatchQueue(
    stream: &CFReadStream,
) -> Option<DispatchRetained<DispatchQueue>> {
    extern "C-unwind" {
        fn CFReadStreamCopyDispatchQueue(stream: &CFReadStream) -> Option<NonNull<DispatchQueue>>;
    }
    let ret = unsafe { CFReadStreamCopyDispatchQueue(stream) };
    ret.map(|ret| unsafe { DispatchRetained::from_raw(ret) })
}

#[cfg(feature = "dispatch2")]
#[deprecated = "renamed to `CFWriteStream::dispatch_queue`"]
#[inline]
pub unsafe extern "C-unwind" fn CFWriteStreamCopyDispatchQueue(
    stream: &CFWriteStream,
) -> Option<DispatchRetained<DispatchQueue>> {
    extern "C-unwind" {
        fn CFWriteStreamCopyDispatchQueue(stream: &CFWriteStream)
            -> Option<NonNull<DispatchQueue>>;
    }
    let ret = unsafe { CFWriteStreamCopyDispatchQueue(stream) };
    ret.map(|ret| unsafe { DispatchRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFReadStream::error`"]
#[inline]
pub extern "C-unwind" fn CFReadStreamGetError(stream: &CFReadStream) -> CFStreamError {
    extern "C-unwind" {
        fn CFReadStreamGetError(stream: &CFReadStream) -> CFStreamError;
    }
    unsafe { CFReadStreamGetError(stream) }
}

#[deprecated = "renamed to `CFWriteStream::error`"]
#[inline]
pub extern "C-unwind" fn CFWriteStreamGetError(stream: &CFWriteStream) -> CFStreamError {
    extern "C-unwind" {
        fn CFWriteStreamGetError(stream: &CFWriteStream) -> CFStreamError;
    }
    unsafe { CFWriteStreamGetError(stream) }
}
