// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv32 -target-feature +zbkx -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg \
// RUN:     | FileCheck %s  -check-prefix=RV32ZBKX
// RUN: %clang_cc1 -triple riscv64 -target-feature +zbkx -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg \
// RUN:     | FileCheck %s  -check-prefix=RV64ZBKX

#include <riscv_bitmanip.h>

#if __riscv_xlen == 32
// RV32ZBKX-LABEL: @xperm8_32(
// RV32ZBKX-NEXT:  entry:
// RV32ZBKX-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.xperm8.i32(i32 [[RS1:%.*]], i32 [[RS2:%.*]])
// RV32ZBKX-NEXT:    ret i32 [[TMP0]]
//
uint32_t xperm8_32(uint32_t rs1, uint32_t rs2)
{
  return __riscv_xperm8_32(rs1, rs2);
}

// RV32ZBKX-LABEL: @xperm4_32(
// RV32ZBKX-NEXT:  entry:
// RV32ZBKX-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.xperm4.i32(i32 [[RS1:%.*]], i32 [[RS2:%.*]])
// RV32ZBKX-NEXT:    ret i32 [[TMP0]]
//
uint32_t xperm4_32(uint32_t rs1, uint32_t rs2)
{
  return __riscv_xperm4_32(rs1, rs2);
}
#endif

#if __riscv_xlen == 64
// RV64ZBKX-LABEL: @xperm8_64(
// RV64ZBKX-NEXT:  entry:
// RV64ZBKX-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.xperm8.i64(i64 [[RS1:%.*]], i64 [[RS2:%.*]])
// RV64ZBKX-NEXT:    ret i64 [[TMP0]]
//
uint64_t xperm8_64(uint64_t rs1, uint64_t rs2)
{
  return __riscv_xperm8_64(rs1, rs2);
}

// RV64ZBKX-LABEL: @xperm4_64(
// RV64ZBKX-NEXT:  entry:
// RV64ZBKX-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.xperm4.i64(i64 [[RS1:%.*]], i64 [[RS2:%.*]])
// RV64ZBKX-NEXT:    ret i64 [[TMP0]]
//
uint64_t xperm4_64(uint64_t rs1, uint64_t rs2)
{
  return __riscv_xperm4_64(rs1, rs2);
}
#endif
