/** VSys:$handlers.cc:0.0.3-010$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: handlers.cc; File version: 0.0.3-010
 */
#include "config.h"
#include "nfc.h"
#include "handlers.h"

/*
 * List of devices with assiged handlers.
 * List of supported handlers devices (handlers) may be seen
 * in handlers.h
 *
 * Format - dev name, dev name length, pointer to pcap_handler for
 * current device. List must be terminated with field with zero length.
 * Handler in termination field is default handler - if no match occured.
 */

#ifdef WIN32
iff_list faces[] = { 
	__IFF(  "eth", 3, ether_handler, 0x0200 ),
	__IFF(  "ppp", 3, ppp_handler, 0x0200 ),
	__IFF( "default", 0, 0, 0x0 )
};
#else 


#ifdef __OS_BSD_LIKE
/*
 * Part from LINT of FreeBSD 4.7
 *
 * # PCI Ethernet NICs that use the common MII bus controller code.
 * device      dc      # DEC/Intel 21143 and various workalikes
 * device      fxp     # Intel EtherExpress PRO/100B (82557, 82558)
 * device      pcn     # AMD Am79C97x PCI 10/100 NICs
 * device      rl      # RealTek 8129/8139
 * device      sf      # Adaptec AIC-6915 (``Starfire'')
 * device      sis     # Silicon Integrated Systems SiS 900/SiS 7016
 * device      ste     # Sundance ST201 (D-Link DFE-550TX)
 * device      tl      # Texas Instruments ThunderLAN
 * device      tx      # SMC EtherPower II (83c17x ``EPIC'')
 * device      vr      # VIA Rhine, Rhine II
 * device      wb      # Winbond W89C840F
 * device      xl      # 3Com 3c90x (``Boomerang'', ``Cyclone'')
 * 
 * # PCI Ethernet NICs.
 * device      de      # DEC/Intel DC21x4x (``Tulip'')
 * device      txp     # 3Com 3cR990 (``Typhoon'')
 * device      vx      # 3Com 3c590, 3c595 (``Vortex'')
 *
 * # Gigabit Ethernet NICs.
 * device      bge     # Broadcom BCM570x (``Tigon III'')
 * device      em      # Intel Pro/1000 (82542,82543,82544,82540)
 * device      gx      # Intel Pro/1000 (82542, 82543)
 * device      lge     # Level 1 LXT1001 (``Mercury'')
 * device      nge     # NatSemi DP83820 and DP83821
 * device      sk      # SysKonnect GEnesis
 * device      ti      # Alteon (``Tigon I'', ``Tigon II'')
 * device      wx
 *
 * #
 * # Network interfaces: `cx', `ed', `el', `ep', `ie', `is', `le', `lnc'
 * #
 * # ar: Arnet SYNC/570i hdlc sync 2/4 port V.35/X.21 serial driver (requires sppp)
 * # cm: Arcnet SMC COM90c26 / SMC COM90c56
 * #     (and SMC COM90c66 in '56 compatibility mode) adapters.
 * # cs: IBM Etherjet and other Crystal Semi CS89x0-based adapters
 * # cx: Cronyx/Sigma multiport sync/async (with Cisco or PPP framing)
 * # ed: Western Digital and SMC 80xx; Novell NE1000 and NE2000; 3Com 3C503
 * # el: 3Com 3C501 (slow!)
 * # ep: 3Com 3C509
 * # ex: Intel EtherExpress Pro/10 and other i82595-based adapters
 * # fe: Fujitsu MB86960A/MB86965A Ethernet
 * # ie: AT&T StarLAN 10 and EN100; 3Com 3C507; unknown NI5210; Intel EtherExpress
 * # le: Digital Equipment EtherWorks 2 and EtherWorks 3 (DEPCA, DE100,
 * #     DE101, DE200, DE201, DE202, DE203, DE204, DE205, DE422)
 * # lnc: Lance/PCnet cards (Isolan, Novell NE2100, NE32-VL, AMD Am7990 & Am79C960)
 * # rdp: RealTek RTL 8002-based pocket ethernet adapters
 * # sbni: Granch SBNI12-xx adapters
 * # sr: RISCom/N2 hdlc sync 1/2 port V.35/X.21 serial driver (requires sppp)
 * # wl: Lucent Wavelan (ISA card only).
 * # awi: IEEE 802.11b PRISM I cards.
 * # wi: Lucent WaveLAN/IEEE 802.11 PCMCIA adapters. Note: this supports both
 * #     the PCMCIA and ISA cards: the ISA card is really a PCMCIA to ISA
 * #     bridge with a PCMCIA adapter plugged into it.
 * # an: Aironet 4500/4800 802.11 wireless adapters. Supports the PCMCIA,
 * #     PCI and ISA varieties.
 * # xe: Xircom/Intel EtherExpress Pro100/16 PC Card ethernet controller.
 * # ray: Raytheon Raylink 802.11 wireless NICs, OEM as Webgear Aviator 2.4GHz
 * # oltr: Olicom ISA token-ring adapters OC-3115, OC-3117, OC-3118 and OC-3133
 * #       (no options needed)
 * #
 * 
 * 
 */
// Don't remove next line!
// __IFF( "__OS_BSD", 0, 0, 0x0000 ),  
iff_list faces[] = { 
	__IFF( "tun", 3, ppp_handler, 0x1000 ),
	__IFF( "ppp", 3, ppp_handler, 0x1001 ),
	__IFF( "ng", 2, ppp_handler, 0x1100 ),
	__IFF( "gif", 3, ppp_handler, 0x1201 ),
	__IFF( "gre", 3, ppp_handler, 0x1202 ),
	__IFF(  "lo", 2, ether_handler, 0x0100 ),
	// # PCI Ethernet NICs that use the common MII bus controller code.
	__IFF(  "dc", 2, ether_handler, 0x0200 ),
	__IFF( "fxp", 3, ether_handler, 0x0300 ),
	__IFF( "bfe", 3, ether_handler, 0x0ee0 ),
	__IFF( "pcn", 3, ether_handler, 0x0400 ),
	__IFF(  "rl", 2, ether_handler, 0x0500 ),
	__IFF(  "sf", 2, ether_handler, 0x0600 ),
	__IFF( "sis", 3, ether_handler, 0x0700 ),
	__IFF( "ste", 3, ether_handler, 0x0800 ),
	__IFF(  "tl", 2, ether_handler, 0x0900 ),
	__IFF(  "tx", 2, ether_handler, 0x0a00 ),
	__IFF(  "vr", 2, ether_handler, 0x0b00 ),
	__IFF(  "wb", 2, ether_handler, 0x0c00 ),
	__IFF(  "xl", 2, ether_handler, 0x0d00 ),
	// # PCI Ethernet NICs.
	__IFF(  "de", 2, ether_handler, 0x0e00 ),
	__IFF( "txp", 3, ether_handler, 0x0f00 ),
	__IFF(  "vx", 2, ether_handler, 0x0140 ),
	//  # Gigabit Ethernet NICs.
	__IFF( "bge", 3, ether_handler, 0x0240 ),
	__IFF(  "em", 2, ether_handler, 0x0340 ),
	__IFF(  "gx", 2, ether_handler, 0x0440 ),
	__IFF( "lge", 3, ether_handler, 0x0540 ),
	__IFF( "nge", 3, ether_handler, 0x0640 ),
	__IFF(  "sk", 2, ether_handler, 0x0740 ),
	__IFF(  "ti", 2, ether_handler, 0x0840 ),
	__IFF(  "wx", 2, ether_handler, 0x0940 ),
	//  # Network interfaces: `cx', `ed', `el', `ep', `ie', `is', `le', `lnc'
	__IFF(  "cx", 2, ether_handler, 0x0a40 ),
	__IFF(  "ed", 2, ether_handler, 0x0b40 ),
	__IFF(  "el", 2, ether_handler, 0x0c40 ),
	__IFF(  "ep", 2, ether_handler, 0x0d40 ),
	__IFF(  "ie", 2, ether_handler, 0x0e40 ),
	__IFF(  "is", 2, ether_handler, 0x0f40 ),
	__IFF(  "le", 2, ether_handler, 0x0040 ),
	__IFF(  "ex", 2, ether_handler, 0x0180 ),
	__IFF( "lnc", 3, ether_handler, 0x0280 ),
	__IFF( "vlan", 4, ether_handler, 0x0680 ),
	// MY driver
	__IFF(  "my", 2, ether_handler, 0x0380 ),
	// (RadioEthernet Cisco Aironet PCI 352)
	__IFF(  "an", 2, ether_handler, 0x0480 ),
	// Lucent WaveLAN/IEEE 802.11 PCMCIA adapters. 
	__IFF(  "wi", 2, ether_handler, 0x0580 ),
	__IFF( "bsd_divert_iface", 16, 0, 0x0900 ),
	/* To be continued */
	__IFF( "default", 0, 0, 0x0 ) };

#else
#if !defined __OS_LINUX_LIKE
# warning "Unknown OS type - using Linux headers"
#endif//!__OS_LINUX_LIKE

// Don't remove next line!
// __IFF( "__OS_Linux", 0, 0, 0x0000 ),  
iff_list faces[] = { 
	__IFF(  "lo", 2, ether_handler, 0x0100 ),
	__IFF( "eth", 3, ether_handler, 0x0200 ),
	__IFF( "dmfe", 4, ether_handler, 0x0201 ), // solaris fast ethernet device :)
	__IFF( "ppp", 3, ppp_handler, 0x1000 ),
	__IFF( "ulog_iface", 10, 0, 0x0 ),
	__IFF( "default", 0, 0, 0x0 ) };

#endif//__OS_BSD_LIKE

#endif//WIN32
