/** VSys:$nf.h:0.0.3-014$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: nf.h; File version: 0.0.3-014
 */
/*
 * Truncated Cisco `flowdata.h' file
 * Only definition of NetFlow v5 is left
 * Some types are changed to confirm linux variable names (u_int16_t ex)
 */


/* $Id: nf.h,v 1.2 2005/11/16 11:12:35 netup Exp $
 * $Source: /cvsroot/ndsad/ndsad/nf.h,v $
 *------------------------------------------------------------------
 *
 * contains definitions of structs used to send/receive NetFlow data
 * 
 * Cisco NetFlow FlowCollector
 *
 * Copyright (c) 1997 by Cisco Systems, Inc.
 * All rights reserved.
 *------------------------------------------------------------------
 * $Log: nf.h,v $
 * Revision 1.2  2005/11/16 11:12:35  netup
 * 1. new version in configure.in - 1.33
 * 2. Linux iptables ULOG support added
 * 3. FreeBSD divert/tee support added
 * 4. configure 'around' fixed
 *
 * Revision 1.1.1.1  2005/06/08 16:02:21  netup
 * Initial import
 *
 * Revision 1.6  2005/01/10 17:49:32  aospan
 * Solrais build fixes
 *
 * Revision 1.5  2004/03/26 20:22:09  dkalinin
 * fix for nm_send()
 *
 * Revision 1.4  2004/03/25 09:29:01  dkalinin
 * nearly working win32 port
 *
 * Revision 1.3  2004/03/24 09:37:08  dkalinin
 * initial win32 port
 *
 * Revision 1.2  2003/12/11 14:38:57  sergey
 * RH9 HACK!!!
 *
 *------------------------------------------------------------------
 * $Endlog$
 */

#ifndef __NFLOW_H__
#define __NFLOW_H__

#ifdef WIN32
#include "win32/types.h"
#else
#include <sys/types.h>
#endif

#define NF5_VER		5
#define V5MSG_SIZE	30

#ifdef __OS_SOLARIS_LIKE
#define u_int16_t uint16_t
#define u_int32_t uint32_t
#define u_int8_t uint8_t
#endif


//#define NF_LIFETIME (( u_int32_t ) 1800000l)
//#define NF_IDLETIME (( u_int32_t ) 30000l)
#define NF_LIFETIME (1800l)
#define NF_IDLETIME (30l)
#define TCP_FIN     0x01

/* For V5 engine_type, RSP uses 0, VIPs uses 1 */
#define V5_RSP_EXPORT           0
#define V5_VIP_EXPORT           1

#ifndef MAX
#define MAX(a,b) ((a) >= (b) ? (a) : (b))
#endif

#ifndef MIN
#define MIN(a,b) ((a) >= (b) ? (b) : (a))
#endif

struct nf5_hdr {
//typedef struct {
   u_int16_t version;         
    u_int16_t count;           /* The number of records in PDU. */
	u_int8_t  __pad[12];
	u_int32_t seq;
	u_int8_t  __pad2[4];
#if 0
    u_int32_t  uptime;       /* Current time in millisecs since router booted */
    u_int32_t  unix_secs;       /* Current seconds since 0000 UTC 1970 */
    u_int32_t  unix_nsecs;      /* Residual nanoseconds since 0000 UTC 1970 */
    u_int32_t  flow_sequence;   /* Seq counter of total flows seen */
    u_int8_t  engine_type;     /* Type of flow switching engine */
    u_int8_t  engine_id;       /* ID number of the flow switching engine */
    u_int16_t reserved;
#endif
//nf5_hdr;
};

struct nf5_stat {
//typedef struct {
    u_int32_t saddr;    /* Source IP Address */
    u_int32_t daddr;    /* Destination IP Address */
    u_int32_t nexthop;  /* Next hop router's IP Address */
    u_int16_t iface;    /* Input interface index */
    u_int16_t __pad;    /* Output interface index */
    
    u_int32_t d_pkt;    /* Packets sent in Duration */
    u_int32_t d_oct;    /* Octets sent in Duration. */
	/*
	 * ts_[first/last] - timestamp(!) of first/last packet.
	 * NOT uptime as in Cisco NetFlow v5.
	 */
    u_int32_t ts_first; /* SysUptime at start of flow */
    u_int32_t ts_last;  /* and of last packet of flow */
    
    u_int16_t sport;    /* TCP/UDP source port number or equivalent */
    u_int16_t dport;    /* TCP/UDP destination port number or equivalent */
    u_int8_t  pad;
    u_int8_t  tcp_flags;/* Cumulative OR of tcp flags */
    u_int8_t  proto;    /* IP protocol, e.g., 6=TCP, 17=UDP, ... */
    u_int8_t  tos;      /* IP Type-of-Service */
	char __pad2[8];
#if 0
    u_int16_t src_as;         /* originating AS of source address */
    u_int16_t dst_as;         /* originating AS of destination address */
    u_int8_t  src_mask;       /* source address prefix mask bits */
    u_int8_t  dst_mask;       /* destination address prefix mask bits */
    u_int16_t reserved;
#endif
};
//} nf5_stat;

#define __NF5_PORTS( x )   (((u_int32_t *) (x))[8])
#if 0
#define __NF5_EQUAL( x,y ) (\
             !memcmp( (void *) x, (void *) y, 16 ) &&\
             x->proto == y->proto && __NF5_PORTS( x ) == __NF5_PORTS( y ))
#endif
#define __NF5_EQUAL( x,y ) (\
    x->saddr == y->saddr && x->daddr == y->daddr && x->iface == y->iface &&\
    x->dport == y->dport && x->proto == y->proto && x->sport == y->sport &&\
	x->tos   == y->tos   )

typedef struct {
    nf5_hdr    header;
    nf5_stat   records[V5MSG_SIZE];
} nf5_msg;

/*
 * Check if nf is valid to proceed
 * See nf.c for wider discription
 */
int nf_valid( const nf5_stat * );
int nf_valid_ts( const nf5_stat *, const u_int32_t );

/*
 * Send nf to listener
 *
 * Currently - only debug print
 */

int  nf_queue( const nf5_stat *, nf5_msg * );
void  nf_send( const nf5_stat * );
void nfm_send(       nf5_msg * );
void  nf_prepare( nf5_stat * );
void nfm_prepare( nf5_msg * );

#ifndef __HASH_MACRO__
int nf_hash( const nf5_stat * );
#else
#define nf_hash( nf ) ( nf->daddr ^ nf->saddr ^ nf->sport ^ nf->dport )
#endif//__HASH_MACRO__

#endif//__NFLOW_H__
